/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_Enums
#define GUARD_Enums

enum GameStateType {GST_MainMenu, GST_SetupBattle, GST_PreBattle, GST_Battle, GST_Score, GST_Reload,
                    GST_ForceSelect, GST_TheOS};

enum PBState {PBS_Position, PBS_PreBattle};

enum MenuChoiceType {MCT_None, MCT_LeftCursor, MCT_RightCursor, MCT_Highlight};

enum SideInfoType {SIT_Number, SIT_Type, SIT_Script, SIT_Points};

enum CompassDirection {CD_N, CD_NE, CD_E, CD_SE, CD_S, CD_SW, CD_W, CD_NW};

enum WindowChoice {
    WC_Nothing,
    WC_Close,
    WC_Quit,
    WC_ExpensiveUpdate,
    WC_Yes,
    WC_No,
    WC_InfoString,
    WC_CopyBox,
    WC_DeleteBox,
    WC_SidePU,
    WC_ImActive,
    WC_ImClosing,
    WC_ImMoving,
    WC_YouClose,
    WC_CloseSidePU,
    WC_LargeBlankDW,
    WC_SliderWithUnits,

    MM_MainSM,
    MM_SetupBattle,
    MM_ForceSelect,
    MM_Options,

    Opt_StandardOptions,
	Opt_FullscreenToggle,
	Opt_SetResolution,
    Opt_SetWindowColor,
	Opt_800,
	Opt_1024,
	Opt_1280,
    Opt_MusicOn,
    Opt_MusicOff,

    FS_LoadSideDW,
    FS_LoadSideMenu,
    FS_NewSide,
    FS_LoadSide,
    FS_LoadSidePU,
    FS_DeleteFleet,
    FS_CopyFleet,
    FS_DeleteSide,
    FS_CopySide,
    FS_NewSideName,

    FS_BasePU,
    FS_AddGroups,
    FS_DeleteGroup,
    FS_StartingPositions,
    FS_SideOptions,
    FS_SideOptionsPU,
	FS_ExitNoSave,
	FS_ExitNoSaveQ,

    FS_AddGroupMenu,
    FS_AddGroupPU,
    FS_NewUnit,
    FS_NewCaSh,
    FS_NewFr,
    FS_NewSmSh,
    FS_NewGroupChoicesOK,
    FS_CapShipTypeSlider,
    FS_NewGroupParentPU,
    FS_DeleteUnit,
    FS_CopyUnit,
    FS_NewUnitName,

    FS_Commander,
    FS_WhichSaveGroup,
    FS_ChooseGSaveGroup,

    FS_EditGroup,
    FS_EditGroupPU,
    FS_ChangeParentCap,
    FS_ChangeAIScript,
    FS_ChooseSaveGroup,
    FS_EditUnit,
    FS_EditUnitPU,

    FS_AIScriptMenu,
    FS_ChangeAIScriptPU,

    FS_Picture,
    FS_SmallWeapons,
    FS_BigWeapons,
    FS_Engine,
    FS_Armour,
    FS_Shield,
    FS_CSType,

    FS_HCS,
    FS_MCS,
    FS_LCS,

    FS_PictureMenu,
    FS_WeaponsDW,
    FS_SmallWeaponsMenu,
    FS_BigWeaponsMenu,

    FS_EquipmentDW,
    FS_EngineMenu,
    FS_ArmourMenu,
    FS_ShieldMenu,

	FS_ForceExitQ,

    FS_GroupNumChange,

    FS_WT_None,
    FS_WT_Twin1,
    FS_WT_Twin2,
    FS_WT_Twin3,

    FS_WT_BSSmall1,
    FS_WT_BSSmall2,
    FS_WT_BSSmall3,
    FS_WT_BSLarge1,
    FS_WT_BSLarge2,
    FS_WT_BSLarge3,

    FS_WT_Missile1,
    FS_WT_Missile2,
    FS_WT_Missile3,
    FS_WT_Torpedo1,
    FS_WT_Torpedo2,
    FS_WT_Torpedo3,

    FS_ET_None,
    FS_ET_SSEngine1,
    FS_ET_SSEngine2,
    FS_ET_SSEngine3,
    FS_ET_FrEngine1,
    FS_ET_FrEngine2,
    FS_ET_FrEngine3,
	FS_ET_CSEngine1,

    FS_ET_SSArmour1,
    FS_ET_SSArmour2,
    FS_ET_SSArmour3,
    FS_ET_FrArmour1,
    FS_ET_FrArmour2,
    FS_ET_FrArmour3,
    FS_ET_CSArmour1,
    FS_ET_CSArmour2,
    FS_ET_CSArmour3,

    FS_ET_SSShield1,
    FS_ET_SSShield2,
    FS_ET_SSShield3,
    FS_ET_FrShield1,
    FS_ET_FrShield2,
    FS_ET_FrShield3,


    SB_BasePU,
    SB_LoadSideMenu,
    SB_SelectForce,

    SB_PlayerList,
    SB_RandomSeed,
    SB_Kick,

    SB_ToBattle,

    PB_BasePU,
    PB_IntoBattle,
    PB_SaveAndExit,

    RTS_BasePU,
    RTS_InfoChoicePU,
    RTS_GameInfo,
    RTS_SideStats,
    RTS_SideVars,
    RTS_SideSaveGroups,
    RTS_SideAIDebug,

    RTS_GroupStats,
    RTS_GroupShieldsInfo,
    RTS_GroupStatusReport,
    RTS_GroupAIReport,
    RTS_GroupVars,
    RTS_GroupSaveGroups,
    RTS_GroupTimers,
    RTS_OptPU,
    RTS_RestartQ,
    RTS_SetGameSpeed,
    RTS_SetScrollSpeed,
    RTS_GroupNums,
    RTS_GroupRects,
	RTS_CycleGroupInfo,

    Score_BasePU,
    Score_Restart
};

enum GenPicture{
    GENPIC_CURSOR,
    GENPIC_CLOSEBOX,

    GENPIC_TITLE,

    GENPIC_SMSHEXPLODE1,
    GENPIC_SMSHEXPLODE2,
    GENPIC_SMSHEXPLODE3,
    GENPIC_SMSHEXPLODE4,
    GENPIC_SMSHEXPLODE5,
    GENPIC_SMSHEXPLODE6,

    GENPIC_FREXPLODE1,
    GENPIC_FREXPLODE2,
    GENPIC_FREXPLODE3,
    GENPIC_FREXPLODE4,
    GENPIC_FREXPLODE5,
    GENPIC_FREXPLODE6,
    GENPIC_FREXPLODE7,

    GENPIC_HCSEXPLODE1,
    GENPIC_HCSEXPLODE2,
    GENPIC_HCSEXPLODE3,
    GENPIC_HCSEXPLODE4,
    GENPIC_HCSEXPLODE5,
    GENPIC_HCSEXPLODE6,
    GENPIC_HCSEXPLODE7,
    GENPIC_HCSEXPLODE8,
    GENPIC_HCSEXPLODE9,

    GENPIC_MCSEXPLODE1,
    GENPIC_MCSEXPLODE2,
    GENPIC_MCSEXPLODE3,
    GENPIC_MCSEXPLODE4,
    GENPIC_MCSEXPLODE5,
    GENPIC_MCSEXPLODE6,
    GENPIC_MCSEXPLODE7,
    GENPIC_MCSEXPLODE8,
    GENPIC_MCSEXPLODE9,

    GENPIC_LCSEXPLODE1,
    GENPIC_LCSEXPLODE2,
    GENPIC_LCSEXPLODE3,
    GENPIC_LCSEXPLODE4,
    GENPIC_LCSEXPLODE5,
    GENPIC_LCSEXPLODE6,
    GENPIC_LCSEXPLODE7,
    GENPIC_LCSEXPLODE8,
    GENPIC_LCSEXPLODE9
};

enum WeaponType{
    WT_None,
    WT_Twin1,
    WT_Twin2,
    WT_Twin3,

    WT_BSSmall1,
    WT_BSSmall2,
    WT_BSSmall3,

    WT_BSLarge1,
    WT_BSLarge2,
    WT_BSLarge3,

    WT_Missile1,
    WT_Missile2,
    WT_Missile3,

    WT_Torpedo1,
    WT_Torpedo2,
    WT_Torpedo3
};

enum WeaponCat{
    WCAT_None,
    WCAT_Twin,
    WCAT_Small,
    WCAT_Large,
    WCAT_Missile,
    WCAT_Torpedo,
    WCAT_Explosion
};

enum EquipCat{
    EQCAT_None,
    EQCAT_SSEngine,
    EQCAT_FrEngine,
    EQCAT_CSEngine,
    EQCAT_SSArmour,
    EQCAT_FrArmour,
    EQCAT_CSArmour,
    EQCAT_SSShield,
    EQCAT_FrShield
};

enum UnitType {UT_CaShUnit, UT_FrUnit, UT_SmShUnit};

enum CapShipType {CST_None, CST_Light, CST_Medium, CST_Heavy};

enum WeaponStage {w_Reloading, w_Ready, w_Aiming, w_Firing};

enum MoveCommand {MC_NoMove, MC_MoveCompass, MC_MoveGroup, MC_Patrol};

//these share the decimal number of the ascii codes, so we don't have to manipulate things quite so much when turning into bytecode
const unsigned char TT_Tab = 9;
//space is 20
const unsigned char TT_Comment = 35; //i.e. #
//
const unsigned char TT_Modulo = 37; //%
//
//40 no TT_OpenB
//41 no TT_CloseB
const unsigned char TT_Multiply = 42;
const unsigned char TT_Add = 43;
//comma 44
const unsigned char TT_Minus = 45;
//46 dot
const unsigned char TT_Divide = 47;
//
//48 -> 5something are numbers

const unsigned char TT_Colon = 58;
const unsigned char TT_Jump = 64;

////

//starting from A:
const unsigned char TT_If = 65;
const unsigned char TT_Else = 66;
const unsigned char TT_ElIf = 67;
const unsigned char TT_Return = 68;
const unsigned char TT_StartTimer = 69;

const unsigned char TT_Move = 70;
const unsigned char TT_MoveAway = 71;
const unsigned char TT_Fire = 72;
const unsigned char TT_Patrol = 73;

const unsigned char TT_Our = 74;
const unsigned char TT_AnyEnemy = 75;
const unsigned char TT_AnyFriend = 76;
const unsigned char TT_AnyAlly = 77;
const unsigned char TT_NearestEnemy = 78;
const unsigned char TT_NearestFriend = 79;
const unsigned char TT_NearestAlly = 80;
const unsigned char TT_NearestWorldEdge = 81;

const unsigned char TT_NumEnemy = 82;
const unsigned char TT_NumFriend = 83;
const unsigned char TT_NumAlly = 84;

const unsigned char TT_Number = 85;
const unsigned char TT_Health = 86;
const unsigned char TT_Shield = 87;
const unsigned char TT_Armour = 88;
const unsigned char TT_MaxHealth = 89;
const unsigned char TT_MaxShield = 90;
const unsigned char TT_MaxArmour = 91;
const unsigned char TT_UnitMaxShield = 92;
const unsigned char TT_UnitMaxArmour = 93;
const unsigned char TT_Speed = 94;
const unsigned char TT_Distance = 95;

const unsigned char TT_SmallRange = 96;
const unsigned char TT_SmallPower = 97;
const unsigned char TT_BigRange = 98;
const unsigned char TT_BigPower = 99;
const unsigned char TT_BigType = 100;
const unsigned char TT_BigAmmo = 101;
const unsigned char TT_InSmallRange = 102;
const unsigned char TT_InBigRange = 103;
const unsigned char TT_OurInSmallRange = 104;
const unsigned char TT_OurInBigRange = 105;

const unsigned char TT_Left = 106;
const unsigned char TT_MissTarget = 107;
const unsigned char TT_TorpTarget = 108;
const unsigned char TT_GroupType = 109;

const unsigned char TT_None = 110;
const unsigned char TT_Laser = 111;
const unsigned char TT_Missile = 112;
const unsigned char TT_Torpedo = 113;

const unsigned char TT_CapitalShip = 114;
const unsigned char TT_Frigate = 115;
const unsigned char TT_SmallShip = 116;

const unsigned char TT_Equal = 117;
const unsigned char TT_NotEqual = 118;
const unsigned char TT_GreaterThan = 119;
const unsigned char TT_LessThan = 120;
const unsigned char TT_GreaterThanEqual = 121;
const unsigned char TT_LessThanEqual = 122;
const unsigned char TT_Not = 123;

const unsigned char TT_And = 124;
const unsigned char TT_Or = 125;

const unsigned char TT_Integer = 126;
const unsigned char TT_ScriptVar = 127;
const unsigned char TT_SaveGroup = 128;
const unsigned char TT_ScriptTimer = 129;

const unsigned char TT_GScriptVar = 130;
const unsigned char TT_GSaveGroup = 131;

const unsigned char TT_Assign = 132;
const unsigned char TT_Increment = 133;
const unsigned char TT_Decrement = 134;

const unsigned char TT_N = 135;
const unsigned char TT_NE = 136;
const unsigned char TT_E = 137;
const unsigned char TT_SE = 138;
const unsigned char TT_S = 139;
const unsigned char TT_SW = 140;
const unsigned char TT_W = 141;
const unsigned char TT_NW = 142;

const unsigned char TT_NorthEdge = 143;
const unsigned char TT_EastEdge = 144;
const unsigned char TT_SouthEdge = 145;
const unsigned char TT_WestEdge = 146;

const unsigned char TT_Random = 147;

#endif
