/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

import jlibs.core.graph.Convertor;

public abstract class Ladder<E> {
    public abstract E parent(E var1);

    public int getHeight(E fromElem, E toElem) {
        if (fromElem == null) {
            return -1;
        }
        int ht = 0;
        while (fromElem != toElem) {
            fromElem = this.parent(fromElem);
            ++ht;
        }
        return ht;
    }

    public int getHeight(E elem) {
        return this.getHeight(elem, null);
    }

    public <A extends E> A getParent(E elem, Class<A> clazz) {
        if (elem == null) {
            return null;
        }
        while ((elem = this.parent(elem)) != null && !clazz.isInstance(elem)) {
        }
        return (A)elem;
    }

    public <A extends E> A getAncestor(E elem, Class<A> clazz) {
        if (clazz.isInstance(elem)) {
            return (A)elem;
        }
        return this.getParent(elem, clazz);
    }

    public E getRoot(E elem) {
        if (elem == null) {
            return null;
        }
        E parent = this.parent(elem);
        while (parent != null) {
            elem = parent;
            parent = this.parent(elem);
        }
        return elem;
    }

    public E getSharedAncestor(E elem1, E elem2) {
        int diff;
        int ht2;
        if (elem1 == elem2) {
            return elem1;
        }
        if (elem1 == null || elem2 == null) {
            return null;
        }
        int ht1 = this.getHeight(elem1);
        if (ht1 > (ht2 = this.getHeight(elem2))) {
            diff = ht1 - ht2;
        } else {
            diff = ht2 - ht1;
            E temp = elem1;
            elem1 = elem2;
            elem2 = temp;
        }
        while (diff > 0) {
            elem1 = this.parent(elem1);
            --diff;
        }
        do {
            if (elem1.equals(elem2)) {
                return elem1;
            }
            elem1 = this.parent(elem1);
            elem2 = this.parent(elem2);
        } while (elem1 != null);
        return null;
    }

    public boolean isAncestor(E elem, E ancestor) {
        if (ancestor == null) {
            return false;
        }
        while (elem != null) {
            if (elem == ancestor) {
                return true;
            }
            elem = this.parent(elem);
        }
        return false;
    }

    public boolean isRelated(E elem1, E elem2) {
        return elem1 != null && elem2 != null && this.getRoot(elem1) == this.getRoot(elem2);
    }

    public String getPath(E elem, Convertor<E, String> convertor, String separator) {
        StringBuilder buff = new StringBuilder();
        while (elem != null) {
            if (buff.length() > 0) {
                buff.insert(0, separator);
            }
            buff.insert(0, convertor.convert(elem));
            elem = this.parent(elem);
        }
        return buff.toString();
    }

    public String getRelativePath(E fromElem, E toElem, Convertor<E, String> convertor, String separator) {
        if (fromElem == toElem) {
            return ".";
        }
        E sharedAncestor = this.getSharedAncestor(fromElem, toElem);
        if (sharedAncestor == null) {
            return null;
        }
        StringBuilder buff1 = new StringBuilder();
        while (!fromElem.equals(sharedAncestor)) {
            if (buff1.length() > 0) {
                buff1.append(separator);
            }
            buff1.append("..");
            fromElem = this.parent(fromElem);
        }
        StringBuilder buff2 = new StringBuilder();
        while (!toElem.equals(sharedAncestor)) {
            if (buff2.length() > 0) {
                buff2.insert(0, separator);
            }
            buff2.insert(0, convertor.convert(toElem));
            toElem = this.parent(toElem);
        }
        if (buff1.length() > 0 && buff2.length() > 0) {
            return buff1 + separator + buff2;
        }
        return buff1.length() > 0 ? buff1.toString() : buff2.toString();
    }
}

