/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.appbar;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.action.ActionGroup;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.appbar.AppBarButton;
import com.jgoodies.fluent.appbar.AppBarItem;
import com.jgoodies.fluent.appbar.AppBarMenuButton;
import com.jgoodies.fluent.appbar.AppBarSeparator;
import com.jgoodies.fluent.appbar.AppBarToggleButton;
import com.jgoodies.fluent.internal.DefaultMenuBuilderCopy;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.internal.UnmodifiablePanel;
import com.jgoodies.fluent.navigation.NavigationBar;
import com.jgoodies.fluent.resources.Fluent;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.navigation.IAppBar;
import com.jgoodies.navigation.PageModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;

public class CommandBar
extends UnmodifiablePanel
implements IAppBar {
    protected final IFluentResources fluentResources;
    protected final CommandBarFactory buttonFactory;
    private final List<AppBarItem<?>> primaryItems = new ArrayList();
    private final List<JMenuItem> secondaryItems = new ArrayList<JMenuItem>();
    private JComponent content;
    private JButton moreButton;
    private int firstOverflowItemIndex;
    private IAppBar.Location location = IAppBar.Location.TOP;
    private boolean actionTextHidden = false;
    private boolean disabledButtonHidden = true;
    private boolean dynamicOverflowEnabled = true;
    private Font buttonFont;
    private Paddings.Padding buttonPadding;
    private static final int EPX48 = ScreenScaling.toPhysical(48);

    public CommandBar() {
        this((Theme)null);
    }

    public CommandBar(Theme theme) {
        this.fluentResources = FluentResources.getInstance();
        this.buttonFactory = this.createFactory(theme);
        this.initComponents();
        this.initEventHandling();
        this.setLayout(new CommandBarLayout());
        this.setBackground(this.getTheme().background());
    }

    private void initComponents() {
        JPanel initialContent = new JPanel(null);
        initialContent.setOpaque(false);
        initialContent.setMinimumSize(new Dimension(0, 0));
        initialContent.setPreferredSize(new Dimension(0, 0));
        this.setContent(initialContent);
        this.moreButton = this.buttonFactory.createButton(this.fluentResources.getAppBarMoreIcon());
        this.moreButton.setHideActionText(true);
        this.moreButton.setName("more_actions_button");
        this.moreButton.setPreferredSize(ScreenScaling.physicalDimension(48, 48));
        this.addImpl(this.moreButton, null, -1);
    }

    private void initEventHandling() {
        this.moreButton.addActionListener(this::onMorePerformed);
        this.updateMoreButtonToolTip();
    }

    protected final CommandBarFactory getButtonFactory() {
        return this.buttonFactory;
    }

    protected CommandBarFactory createFactory(Theme theme) {
        return new CommandBarFactory(theme);
    }

    private ResourceMap getResources() {
        return new Fluent().getResourceMap(this.getLocale());
    }

    public final Theme getTheme() {
        return this.buttonFactory.getTheme();
    }

    protected final void setTheme(Theme theme) {
        this.buttonFactory.setTheme(theme);
        this.setBackground(theme.background());
    }

    @Override
    public final void setLocation(IAppBar.Location newValue) {
        this.location = Preconditions.checkNotNull(newValue, "The %s must not be null.", "location");
    }

    public final boolean isActionTextHidden() {
        return this.actionTextHidden;
    }

    public final void setActionTextHidden(boolean b) {
        this.actionTextHidden = b;
    }

    public final boolean isDisabledButtonHidden() {
        return this.disabledButtonHidden;
    }

    public final void setDisabledButtonHidden(boolean b) {
        this.disabledButtonHidden = b;
    }

    public final boolean isDynamicOverflowEnabled() {
        return this.dynamicOverflowEnabled;
    }

    public final void setDynamicOverflowEnabled(boolean enabled) {
        this.dynamicOverflowEnabled = enabled;
    }

    public final void setButtonFont(Font font) {
        this.buttonFont = font;
    }

    public final void setButtonPadding(Paddings.Padding padding) {
        this.buttonPadding = padding;
    }

    public final void setContent(JComponent content) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = content;
        this.addImpl(content, null, 0);
    }

    public final void setContent(PageModel pageModel) {
        NavigationBar navigationBar = new NavigationBar(pageModel, this.getTheme());
        this.setContent(navigationBar.buildPanel());
    }

    protected final void addPrimaryComponent(JComponent c) {
        this.addImpl(c, null, this.getComponentCount() - 1);
    }

    public final <C extends JComponent> C addPrimary(AppBarItem<C> item) {
        Preconditions.checkNotNull(item, "The %s must not be null.", "primary item");
        this.primaryItems.add(item);
        C component = item.createPrimaryComponent();
        this.addPrimaryComponent((JComponent)component);
        return component;
    }

    public final JButton addPrimary(Action action) {
        return this.addPrimary(new AppBarButton(this, action));
    }

    public final void addPrimary(Action ... actions) {
        Preconditions.checkNotNullOrEmpty(actions, "The %s must not be null or empty.", "actions");
        for (Action action : actions) {
            if (action != null) {
                this.addPrimary(action);
                continue;
            }
            this.addPrimarySeparator();
        }
    }

    public final JButton addPrimary(String markedText, Consumer<ActionEvent> handler) {
        return this.addPrimary((Action)new ConsumerAction(markedText, handler));
    }

    public final JButton addPrimaryMenu(JMenu menu) {
        return this.addPrimary(new AppBarMenuButton(this, menu));
    }

    public final JToggleButton addPrimaryToggle(Action toggleAction) {
        return this.addPrimary(new AppBarToggleButton(this, toggleAction));
    }

    public final void addPrimarySeparator() {
        this.addPrimary(new AppBarSeparator());
    }

    public final void addPrimary(ActionGroup group) {
        group.build(new PrimaryItemsBuilder(this));
    }

    public final void clearPrimaryItems() {
        this.removeAll();
        this.primaryItems.clear();
        if (this.content != null) {
            this.addImpl(this.content, null, -1);
        }
        this.addImpl(this.moreButton, null, -1);
    }

    public final void addSecondary(Action ... actions) {
        Preconditions.checkNotNullOrEmpty(actions, "The %s must not be null or empty.", "actions");
        for (Action action : actions) {
            if (action != null) {
                this.secondaryItems.add(this.buttonFactory.createMenuItem(action));
                continue;
            }
            this.addSecondarySeparator();
        }
    }

    public final void addSecondary(String markedText, Consumer<ActionEvent> handler) {
        this.addSecondary(new ConsumerAction(markedText, handler));
    }

    public final void addSecondary(JMenuItem menuItem) {
        Preconditions.checkNotNull(menuItem, "The %s must not be null.", "seconary menu item");
        this.secondaryItems.add(menuItem);
    }

    public final void addSecondarySeparator() {
        this.secondaryItems.add(null);
    }

    public final void addSecondary(ActionGroup group) {
        group.build(new SecondaryItemsBuilder(this));
    }

    public final void clearSecondaryItems() {
        this.secondaryItems.clear();
    }

    @Override
    public final Component add(Component comp) {
        throw CommandBar.unsupportedAddOperation();
    }

    @Override
    public final Component add(String name, Component comp) {
        throw CommandBar.unsupportedAddOperation();
    }

    @Override
    public final Component add(Component comp, int index) {
        throw CommandBar.unsupportedAddOperation();
    }

    @Override
    public final void add(Component comp, Object constraints) {
        throw CommandBar.unsupportedAddOperation();
    }

    @Override
    public final void add(Component comp, Object constraints, int index) {
        throw CommandBar.unsupportedAddOperation();
    }

    private static UnsupportedOperationException unsupportedAddOperation() {
        return new UnsupportedOperationException("CommandBar allows only content, primary and secondary items.");
    }

    @Override
    public JComponent buildPanel() {
        return this;
    }

    protected void onMorePerformed(ActionEvent evt) {
        this.showOverflowMenu(evt, this.createOverflowMenu());
    }

    protected JPopupMenu createOverflowMenu() {
        int count;
        JPopupMenu menu = new JPopupMenu("CommandBar Overflow Menu");
        boolean needSeparator = false;
        for (int i = this.firstOverflowItemIndex; i < this.primaryItems.size(); ++i) {
            AppBarItem<?> appBarItem = this.primaryItems.get(i);
            appBarItem.addTo(menu);
            needSeparator = !(appBarItem instanceof AppBarSeparator);
        }
        if (needSeparator) {
            menu.addSeparator();
        }
        for (JMenuItem jMenuItem : this.secondaryItems) {
            if (jMenuItem == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(jMenuItem);
        }
        if (menu.getComponentCount() > 0 && menu.getComponent(0) instanceof JPopupMenu.Separator) {
            menu.remove(0);
        }
        if ((count = menu.getComponentCount()) > 0 && menu.getComponent(count - 1) instanceof JPopupMenu.Separator) {
            menu.remove(count - 1);
        }
        return menu;
    }

    private void showOverflowMenu(ActionEvent evt, JPopupMenu popupMenu) {
        AbstractButton source = (AbstractButton)evt.getSource();
        Container parent = source.getParent();
        int x = parent.getWidth() - popupMenu.getPreferredSize().width;
        int y = this.location == IAppBar.Location.TOP ? parent.getHeight() : -popupMenu.getPreferredSize().height;
        popupMenu.show(parent, x, y);
    }

    private void updateMoreButtonToolTip() {
        this.moreButton.setToolTipText(this.getResources().getString("CommandBar.MoreActions", new Object[0]));
    }

    private boolean hasSecondaryItems() {
        return !this.secondaryItems.isEmpty();
    }

    public static final class Builder {
        private final CommandBar target;

        public Builder() {
            this(new CommandBar());
        }

        public Builder(CommandBar target) {
            this.target = target;
        }

        public Builder theme(Theme theme) {
            this.target.setTheme(theme);
            return this;
        }

        public Builder location(IAppBar.Location location) {
            this.target.setLocation(location);
            return this;
        }

        public Builder actionTextsHidden(boolean value) {
            this.target.setActionTextHidden(value);
            return this;
        }

        public Builder disabledButtonHidden(boolean b) {
            this.target.setDisabledButtonHidden(b);
            return this;
        }

        public Builder showDisabledButtons() {
            return this.disabledButtonHidden(false);
        }

        public Builder dynamicOverflowEnabled(boolean b) {
            this.target.setDynamicOverflowEnabled(b);
            return this;
        }

        public Builder disableDynamicOverflow() {
            return this.dynamicOverflowEnabled(false);
        }

        public Builder buttonFont(Font font) {
            this.target.setButtonFont(font);
            return this;
        }

        public Builder buttonPadding(Paddings.Padding padding) {
            this.target.setButtonPadding(padding);
            return this;
        }

        public Builder content(JComponent content) {
            this.target.setContent(content);
            return this;
        }

        public Builder content(PageModel pageModel) {
            this.target.setContent(pageModel);
            return this;
        }

        public Builder primary(Action ... actions) {
            this.target.addPrimary(actions);
            return this;
        }

        public Builder primary(List<Action> actions) {
            this.target.addPrimary(actions.toArray(new Action[actions.size()]));
            return this;
        }

        public Builder primary(String markedText, Consumer<ActionEvent> handler) {
            this.target.addPrimary(markedText, handler);
            return this;
        }

        public Builder primarySeparator() {
            this.target.addPrimarySeparator();
            return this;
        }

        public Builder primaryMenu(JMenu menu) {
            this.target.addPrimaryMenu(menu);
            return this;
        }

        public Builder primaryToggle(Action toggleAction) {
            this.target.addPrimaryToggle(toggleAction);
            return this;
        }

        public Builder primary(boolean expression, Action ... actions) {
            if (expression) {
                this.primary(actions);
            }
            return this;
        }

        public Builder primary(boolean expression, List<Action> actions) {
            if (expression) {
                this.primary(actions);
            }
            return this;
        }

        public Builder primary(boolean expression, String markedText, Consumer<ActionEvent> handler) {
            if (expression) {
                this.primary(markedText, handler);
            }
            return this;
        }

        public Builder primarySeparator(boolean expression) {
            if (expression) {
                this.primarySeparator();
            }
            return this;
        }

        public Builder secondary(Action ... actions) {
            this.target.addSecondary(actions);
            return this;
        }

        public Builder secondary(List<Action> actions) {
            this.target.addSecondary(actions.toArray(new Action[actions.size()]));
            return this;
        }

        public Builder secondary(String markedText, Consumer<ActionEvent> handler) {
            this.target.addSecondary(markedText, handler);
            return this;
        }

        public Builder secondarySeparator() {
            this.target.addSecondarySeparator();
            return this;
        }

        public Builder secondary(boolean expression, Action ... actions) {
            if (expression) {
                this.secondary(actions);
            }
            return this;
        }

        public Builder secondary(boolean expression, List<Action> actions) {
            if (expression) {
                this.secondary(actions);
            }
            return this;
        }

        public Builder secondary(boolean expression, String markedText, Consumer<ActionEvent> handler) {
            if (expression) {
                this.secondary(markedText, handler);
            }
            return this;
        }

        public Builder secondarySeparator(boolean expression) {
            if (expression) {
                this.secondarySeparator();
            }
            return this;
        }

        public CommandBar build() {
            return this.target;
        }

        public JComponent buildPanel() {
            return this.build().buildPanel();
        }
    }

    public class CommandBarFactory
    extends FluentButtonFactory {
        public CommandBarFactory(Theme theme) {
            super(theme);
        }

        @Override
        public final JButton createButton(Action action) {
            return this.createButton(action, true);
        }

        @Override
        public final JButton createButton(Icon icon) {
            return this.createButton(icon, true);
        }

        @Override
        public final JButton createButton(String text) {
            return this.createButton(text, true);
        }

        public final JButton createButton(Action action, boolean visibleIffEnabled) {
            JButton button = super.createButton(action);
            return visibleIffEnabled ? this.visibleIffEnabled(button) : button;
        }

        public final JButton createButton(Icon icon, boolean visibleIffEnabled) {
            JButton button = super.createButton(icon);
            return visibleIffEnabled ? this.visibleIffEnabled(button) : button;
        }

        public final JButton createButton(String text, boolean visibleIffEnabled) {
            JButton button = super.createButton(text);
            return visibleIffEnabled ? this.visibleIffEnabled(button) : button;
        }

        public final JMenuItem createMenuItem(Action action) {
            return new JMenuItem(action);
        }

        public final FluentButtonFactory.NavigationToggleButton createToggleButton(Action action) {
            return this.createToggleButton(action, FluentButtonFactory.SelectionMarkerMode.OFF);
        }

        private <B extends AbstractButton> B visibleIffEnabled(B button) {
            if (CommandBar.this.disabledButtonHidden) {
                button.addPropertyChangeListener("enabled", evt -> button.setVisible(button.isEnabled()));
                button.setVisible(button.isEnabled());
            }
            return button;
        }

        @Override
        protected void configureButton(AbstractButton button) {
            super.configureButton(button);
            button.setHideActionText(CommandBar.this.actionTextHidden);
            if (CommandBar.this.buttonFont != null) {
                button.setFont(CommandBar.this.buttonFont);
            }
            if (CommandBar.this.buttonPadding != null) {
                button.setBorder(new CompoundBorder(new BasicBorders.MarginBorder(), CommandBar.this.buttonPadding));
            }
        }
    }

    private final class CommandBarLayout
    implements LayoutManager {
        private CommandBarLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container commandBar) {
            Object object = commandBar.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, EPX48);
                if (CommandBar.this.isDynamicOverflowEnabled()) {
                    if (CommandBar.this.content != null) {
                        dim.width += ((CommandBar)CommandBar.this).content.getMinimumSize().width;
                    }
                    dim.width += EPX48;
                    return dim;
                }
                int count = commandBar.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component m = commandBar.getComponent(i);
                    if (!this.isVisible(m)) continue;
                    dim.width += m.getMinimumSize().width;
                }
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container commandBar) {
            Object object = commandBar.getTreeLock();
            synchronized (object) {
                Dimension dim = new Dimension(0, EPX48);
                int count = commandBar.getComponentCount();
                for (int i = 0; i < count; ++i) {
                    Component m = commandBar.getComponent(i);
                    if (!this.isVisible(m)) continue;
                    dim.width += m.getPreferredSize().width;
                }
                return dim;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container commandBar) {
            Object object = commandBar.getTreeLock();
            synchronized (object) {
                int width = commandBar.getSize().width;
                int height = EPX48;
                int count = commandBar.getComponentCount();
                int contentMinimumWidth = ((CommandBar)CommandBar.this).content.getMinimumSize().width;
                int moreMinimumWidth = ((CommandBar)CommandBar.this).moreButton.getMinimumSize().width;
                int x = 0;
                for (int i = 0; i < count; ++i) {
                    Component m = commandBar.getComponent(i);
                    m.setLocation(x, 0);
                    if (this.isVisible(m)) {
                        int minWidth = m.getMinimumSize().width;
                        m.setSize(minWidth, height);
                        x += minWidth;
                        continue;
                    }
                    m.setSize(0, 0);
                }
                CommandBar.this.firstOverflowItemIndex = CommandBar.this.primaryItems.size();
                if (x == width) {
                    return;
                }
                if (x < width) {
                    int extraSpace = width - x;
                    CommandBar.this.content.setSize(contentMinimumWidth + extraSpace, height);
                    this.moveButtons(extraSpace, commandBar);
                    CommandBar.this.moreButton.setLocation(width - moreMinimumWidth, 0);
                    return;
                }
                if (!CommandBar.this.isDynamicOverflowEnabled()) {
                    return;
                }
                CommandBar.this.moreButton.setLocation(width - moreMinimumWidth, 0);
                CommandBar.this.moreButton.setSize(moreMinimumWidth, height);
                int remainingWidth = width - moreMinimumWidth;
                for (int i = count - 2; i > 0; --i) {
                    Component m = commandBar.getComponent(i);
                    int mX = m.getLocation().x;
                    int mWidth = m.getSize().width;
                    int shift = remainingWidth - (mX + mWidth);
                    if (shift < 0) {
                        m.setSize(0, 0);
                        CommandBar.this.firstOverflowItemIndex = i - 1;
                        continue;
                    }
                    if (CommandBar.this.primaryItems.get(i - 1) instanceof AppBarSeparator) {
                        m.setSize(0, 0);
                        continue;
                    }
                    this.moveButtons(shift, commandBar);
                    return;
                }
                int contentWidth = Math.min(remainingWidth, ((CommandBar)CommandBar.this).content.getPreferredSize().width);
                CommandBar.this.content.setSize(contentWidth, height);
            }
        }

        private void moveButtons(int horizontalShift, Container commandBar) {
            int count = commandBar.getComponentCount();
            for (int i = 1; i < count - 1; ++i) {
                Component m = commandBar.getComponent(i);
                m.setLocation(m.getLocation().x + horizontalShift, 0);
            }
        }

        private boolean isVisible(Component c) {
            return c != CommandBar.this.moreButton ? c.isVisible() : CommandBar.this.hasSecondaryItems();
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static final class PrimaryItemsBuilder
    implements ActionGroup.ActionGroupBuilder {
        private final CommandBar commandBar;

        private PrimaryItemsBuilder(CommandBar commandBar) {
            this.commandBar = commandBar;
        }

        @Override
        public void add(Action action) {
            this.commandBar.addPrimary(action);
        }

        @Override
        public void add(ActionGroup group) {
            this.commandBar.addPrimaryMenu(DefaultMenuBuilderCopy.menuFor(group));
        }

        @Override
        public void addSeparator() {
            this.commandBar.addPrimarySeparator();
        }
    }

    private static final class SecondaryItemsBuilder
    implements ActionGroup.ActionGroupBuilder {
        private final CommandBar commandBar;

        private SecondaryItemsBuilder(CommandBar commandBar) {
            this.commandBar = commandBar;
        }

        @Override
        public void add(Action action) {
            this.commandBar.addSecondary(action);
        }

        @Override
        public void add(ActionGroup group) {
            this.commandBar.addSecondary(DefaultMenuBuilderCopy.menuFor(group));
        }

        @Override
        public void addSeparator() {
            this.commandBar.addSecondarySeparator();
        }
    }
}

