/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.wizard;

import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.wizard.WizardPage;
import com.jgoodies.dialogs.core.pane.wizard.WizardPageModel;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractWizardPage<PM extends WizardPageModel>
implements WizardPage {
    private final PM pageModel;
    private final Icon mainInstructionIcon;
    private final String mainInstructionText;
    private boolean mainInstructionLabelsContent;
    private JComponent pageContent;
    private JComponent additionalCommandContent;
    private boolean additionalCommandContentBuilt;
    private Component defaultFocusOwner;

    public AbstractWizardPage(PM pageModel) {
        this(pageModel, null, null);
    }

    public AbstractWizardPage(PM pageModel, String mainInstructionText) {
        this(pageModel, null, mainInstructionText);
    }

    public AbstractWizardPage(PM pageModel, Icon mainInstructionIcon, String mainInstructionText) {
        this.pageModel = pageModel;
        this.mainInstructionIcon = mainInstructionIcon;
        this.mainInstructionText = mainInstructionText;
        JSDLCoreStyleChecker.getInstance().checkMainInstruction(mainInstructionText, MessageType.PLAIN);
    }

    public final PM getPageModel() {
        return this.pageModel;
    }

    @Override
    public final Icon getMainInstructionIcon() {
        return this.mainInstructionIcon;
    }

    @Override
    public final String getMainInstructionText() {
        return this.mainInstructionText;
    }

    @Override
    public final boolean getMainInstructionLabelsContent() {
        return this.mainInstructionLabelsContent;
    }

    public final void setMainInstructionLabelsContent(boolean newValue) {
        this.mainInstructionLabelsContent = newValue;
    }

    @Override
    public final JComponent getPageContent() {
        if (this.pageContent == null) {
            this.pageContent = this.buildPageContent();
        }
        return this.pageContent;
    }

    @Override
    public final JComponent getAdditionalCommandContent() {
        if (!this.additionalCommandContentBuilt) {
            this.additionalCommandContent = this.buildAdditionalCommandContent();
        }
        return this.additionalCommandContent;
    }

    @Override
    public final Component getDefaultFocusOwner() {
        return this.defaultFocusOwner;
    }

    public final void setDefaultFocusOwner(Component component) {
        this.defaultFocusOwner = component;
    }

    protected abstract JComponent buildPageContent();

    protected JComponent buildAdditionalCommandContent() {
        return null;
    }

    @Override
    public void onActivating() {
    }

    @Override
    public void onActivated() {
    }

    @Override
    public void onDeactivating() {
    }
}

