/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.internal;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.jsdl.action.ConsumerAction;
import com.jgoodies.components.internal.LinkUnderlineSupport;
import com.jgoodies.components.internal.TextFieldIcons;
import com.jgoodies.components.util.ComponentUtils;
import com.jgoodies.components.util.CompoundIcon;
import com.jgoodies.components.util.NullIcon;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public final class TextFieldSupport {
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_ROLLOVER_ICON = "rolloverIcon";
    public static final String PROPERTY_PRESSED_ICON = "pressedIcon";
    public static final String PROPERTY_BUTTON_PAINTED_ALWAYS = "buttonPaintedAlways";
    public static final String PROPERTY_ICON_VISIBLE_ALWAYS = "iconVisibleAlways";
    public static final String PROPERTY_MENU_ICON = "menuIcon";
    public static final String PROPERTY_ICON_ACTION = "iconAction";
    public static final String PROPERTY_LINK_ACTION = "linkAction";
    public static final String PROPERTY_MENU = "menu";
    public static final String PROPERTY_SELECT_ON_FOCUS_GAIN_ENABLED = "JGoodies.selectAllOnFocusGain";
    private static final String KEY_EVENT_HANDLER = "TextFieldSupport.eventHandler";
    private static final String KEY_ROLLOVER_STATE_TEXT_BOX = "TextFieldSupport.rolloverStateTextBox";
    private static final String KEY_ROLLOVER_STATE_TEXT = "TextFieldSupport.rolloverStateText";
    private static final String KEY_ROLLOVER_STATE_ICON = "TextFieldSupport.rolloverStateIcon";
    private static final String KEY_ROLLOVER_STATE_MENU = "TextFieldSupport.rolloverStateMenu";
    private static final String KEY_PRESSED = "TextFieldSupport.pressed";
    private static final String KEY_CONTROL_DOWN = "TextFieldSupport.controlDown";
    private static final Border ICON_BORDER = new IconBorder();
    private static Action showPopupAction;
    private static final EventHandler EVENT_HANDLER;

    private TextFieldSupport() {
    }

    public static void updateUI(JTextComponent c) {
        boolean installed;
        boolean bl = installed = c.getClientProperty(KEY_EVENT_HANDLER) != null;
        if (!installed) {
            c.addFocusListener(EVENT_HANDLER);
            c.addMouseListener(EVENT_HANDLER);
            c.addMouseMotionListener(EVENT_HANDLER);
            c.addKeyListener(EVENT_HANDLER);
            c.putClientProperty(KEY_EVENT_HANDLER, EVENT_HANDLER);
            TextFieldSupport.updateBorder(c);
        } else if (c.getBorder() instanceof UIResource) {
            TextFieldSupport.updateBorder(c);
        }
        TextFieldIcons.ensureValidImages();
    }

    private static void updateBorder(JTextComponent c) {
        Border border = c.getBorder();
        Border iconBorder = ICON_BORDER;
        c.setBorder(border instanceof UIResource ? new BorderUIResource.CompoundBorderUIResource(border, iconBorder) : new CompoundBorder(border, iconBorder));
    }

    public static Icon getIcon(JTextComponent c) {
        return (Icon)c.getClientProperty(PROPERTY_ICON);
    }

    public static void setIcon(JTextComponent c, Icon newIcon) {
        Icon oldIcon = TextFieldSupport.getIcon(c);
        if (oldIcon == newIcon) {
            return;
        }
        c.putClientProperty(PROPERTY_ICON, newIcon);
        c.revalidate();
        c.repaint();
    }

    public static Icon getPressedIcon(JTextComponent c) {
        return (Icon)c.getClientProperty(PROPERTY_PRESSED_ICON);
    }

    public static void setPressedIcon(JTextComponent c, Icon newIcon) {
        Icon oldIcon = TextFieldSupport.getPressedIcon(c);
        if (oldIcon == newIcon) {
            return;
        }
        c.putClientProperty(PROPERTY_PRESSED_ICON, newIcon);
        c.repaint();
    }

    public static Icon getRolloverIcon(JTextComponent c) {
        return (Icon)c.getClientProperty(PROPERTY_ROLLOVER_ICON);
    }

    public static void setRolloverIcon(JTextComponent c, Icon newIcon) {
        Icon oldIcon = TextFieldSupport.getRolloverIcon(c);
        if (oldIcon == newIcon) {
            return;
        }
        c.putClientProperty(PROPERTY_ROLLOVER_ICON, newIcon);
        c.repaint();
    }

    public static boolean isButtonPaintedAlways(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(PROPERTY_BUTTON_PAINTED_ALWAYS));
    }

    public static void setButtonPaintedAlways(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isButtonPaintedAlways(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(PROPERTY_BUTTON_PAINTED_ALWAYS, newValue);
        c.repaint();
    }

    public static boolean isIconVisibleAlways(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(PROPERTY_ICON_VISIBLE_ALWAYS));
    }

    public static void setIconVisibleAlways(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isIconVisibleAlways(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(PROPERTY_ICON_VISIBLE_ALWAYS, newValue);
        c.repaint();
    }

    public static Action getIconAction(JTextComponent c) {
        return (Action)c.getClientProperty(PROPERTY_ICON_ACTION);
    }

    public static void setIconAction(JTextComponent c, Action newAction) {
        Action oldAction = TextFieldSupport.getIconAction(c);
        if (oldAction == newAction) {
            return;
        }
        if (oldAction != null) {
            ComponentUtils.unregisterKeyboardAction(c, oldAction);
        }
        if (newAction != null) {
            ComponentUtils.registerKeyboardAction(c, newAction);
            ToolTipManager.sharedInstance().registerComponent(c);
        }
        c.putClientProperty(PROPERTY_ICON_ACTION, newAction);
        c.revalidate();
        c.repaint();
    }

    public static void setIconAction(JTextComponent c, Consumer<ActionEvent> consumer) {
        TextFieldSupport.setIconAction(c, new ConsumerAction("unused", consumer));
    }

    public static Action getLinkAction(JTextComponent c) {
        return (Action)c.getClientProperty(PROPERTY_LINK_ACTION);
    }

    public static void setLinkAction(JTextComponent c, Action newAction) {
        Action oldAction = TextFieldSupport.getLinkAction(c);
        if (oldAction == newAction) {
            return;
        }
        if (oldAction != null) {
            ComponentUtils.unregisterKeyboardAction(c, oldAction);
        }
        if (newAction != null) {
            ComponentUtils.registerKeyboardAction(c, newAction);
        }
        c.putClientProperty(PROPERTY_LINK_ACTION, newAction);
        c.repaint();
    }

    public static void setLinkAction(JTextComponent c, Consumer<ActionEvent> consumer) {
        TextFieldSupport.setLinkAction(c, new ConsumerAction("unused", consumer));
    }

    public static Icon getMenuIcon(JTextComponent c) {
        return (Icon)c.getClientProperty(PROPERTY_MENU_ICON);
    }

    public static void setMenuIcon(JTextComponent c, Icon newIcon) {
        Icon oldIcon = TextFieldSupport.getIcon(c);
        if (oldIcon == newIcon) {
            return;
        }
        c.putClientProperty(PROPERTY_MENU_ICON, newIcon);
        c.revalidate();
        c.repaint();
    }

    public static JPopupMenu getMenu(JTextComponent c) {
        return (JPopupMenu)c.getClientProperty(PROPERTY_MENU);
    }

    public static void setMenu(JTextComponent c, JPopupMenu newMenu) {
        JPopupMenu oldMenu = TextFieldSupport.getMenu(c);
        if (oldMenu == newMenu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.removePropertyChangeListener("visible", EVENT_HANDLER);
            ComponentUtils.unregisterKeyboardAction(c, TextFieldSupport.getShowPopupAction());
        }
        if (newMenu != null) {
            newMenu.addPropertyChangeListener("visible", EVENT_HANDLER);
            ComponentUtils.registerKeyboardAction(c, TextFieldSupport.getShowPopupAction());
        }
        c.putClientProperty(PROPERTY_MENU, newMenu);
        c.revalidate();
        c.repaint();
    }

    public static Boolean getSelectOnFocusGainEnabled(JTextComponent c) {
        return (Boolean)c.getClientProperty(PROPERTY_SELECT_ON_FOCUS_GAIN_ENABLED);
    }

    public static void setSelectOnFocusGainEnabled(JTextComponent component, Boolean b) {
        component.putClientProperty(PROPERTY_SELECT_ON_FOCUS_GAIN_ENABLED, b);
    }

    public static String getToolTipText(JTextComponent c, MouseEvent e, String superToolTipText) {
        Action iconAction = TextFieldSupport.getIconAction(c);
        if (iconAction == null || !TextFieldSupport.isOverIcon(c, e.getX(), e.getY())) {
            return superToolTipText;
        }
        String toolTip = (String)iconAction.getValue("ShortDescription");
        if (Strings.isNotBlank(toolTip)) {
            return toolTip;
        }
        return (String)iconAction.getValue("Name");
    }

    public static Dimension getPreferredSize(JTextComponent c, Dimension original) {
        Icon menuIcon;
        Icon actionIcon = TextFieldSupport.getActionBaseIcon(c);
        if (actionIcon != null && !TextFieldSupport.isIconPainted(c)) {
            original.width += actionIcon.getIconWidth();
        }
        if (TextFieldSupport.hasMenu(c) && !TextFieldSupport.isMenuIconPainted(c) && (menuIcon = TextFieldSupport.getCurrentMenuIcon(c, -1)) != null) {
            original.width += menuIcon.getIconWidth();
        }
        return original;
    }

    private static Icon getActionBaseIcon(JTextComponent c) {
        Icon icon = TextFieldSupport.getIcon(c);
        if (icon != null) {
            return icon;
        }
        Action a = TextFieldSupport.getIconAction(c);
        if (a == null) {
            return null;
        }
        return (Icon)a.getValue("SmallIcon");
    }

    private static Icon getCurrentActionIcon(JTextComponent c, int height) {
        Icon baseIcon = TextFieldSupport.getActionBaseIcon(c);
        if (baseIcon == null) {
            return null;
        }
        boolean clickable = TextFieldSupport.isIconClickable(c);
        boolean rollover = TextFieldSupport.isRolloverStateIcon(c);
        boolean pressed = TextFieldSupport.isPressed(c) && rollover && clickable;
        boolean active = TextFieldSupport.isButtonPaintedAlways(c) && clickable;
        int width = baseIcon.getIconWidth();
        if (pressed) {
            Icon icon = TextFieldSupport.getPressedIcon(c);
            return icon != null ? icon : new CompoundIcon(TextFieldIcons.getButtonIconPressed(width, height), baseIcon, CompoundIcon.Anchor.CENTER);
        }
        if (rollover && clickable) {
            Icon icon = TextFieldSupport.getRolloverIcon(c);
            return icon != null ? icon : new CompoundIcon(TextFieldIcons.getButtonIconRollover(width, height), baseIcon, CompoundIcon.Anchor.CENTER);
        }
        if (active) {
            return new CompoundIcon(TextFieldIcons.getButtonIcon(width, height), baseIcon, CompoundIcon.Anchor.CENTER);
        }
        return new CompoundIcon(new NullIcon(width, height), baseIcon, CompoundIcon.Anchor.CENTER);
    }

    private static Icon getMenuBaseIcon(JTextComponent c) {
        Icon customIcon = TextFieldSupport.getMenuIcon(c);
        return customIcon != null ? customIcon : TextFieldIcons.getPopupIcon();
    }

    private static Icon getCurrentMenuIcon(JTextComponent c, int height) {
        Icon baseIcon = TextFieldSupport.getMenuBaseIcon(c);
        if (baseIcon == null) {
            return null;
        }
        int width = baseIcon.getIconWidth();
        Icon background = TextFieldSupport.getMenuBackgroundIcon(c, width, height);
        return new CompoundIcon(background, baseIcon, CompoundIcon.Anchor.CENTER);
    }

    private static Icon getMenuBackgroundIcon(JTextComponent c, int width, int height) {
        boolean pressed;
        boolean popupVisible = TextFieldSupport.isPopupMenuVisible(c);
        boolean rollover = TextFieldSupport.isRolloverStateMenu(c) || popupVisible;
        boolean bl = pressed = TextFieldSupport.isPressed(c) && rollover || popupVisible;
        if (pressed) {
            return TextFieldIcons.getButtonIconPressed(width, height);
        }
        if (rollover) {
            return TextFieldIcons.getButtonIconRollover(width, height);
        }
        if (TextFieldSupport.isButtonPaintedAlways(c) || TextFieldSupport.isRolloverStateIcon(c) && TextFieldSupport.isIconClickable(c)) {
            return TextFieldIcons.getButtonIcon(width, height);
        }
        return new NullIcon(width, height);
    }

    private static boolean isRolloverStateTextBox(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_ROLLOVER_STATE_TEXT_BOX));
    }

    private static void setRolloverStateTextBox(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isRolloverStateTextBox(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_ROLLOVER_STATE_TEXT_BOX, newValue);
        if (newValue && !LinkUnderlineSupport.isLinkPainted(c)) {
            TextFieldSupport.changeCursor(c, 2);
        }
        c.repaint();
    }

    private static boolean isRolloverStateText(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_ROLLOVER_STATE_TEXT));
    }

    private static void setRolloverStateText(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isRolloverStateText(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_ROLLOVER_STATE_TEXT, newValue);
        TextFieldSupport.updateLink(c);
    }

    private static boolean isRolloverStateIcon(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_ROLLOVER_STATE_ICON));
    }

    private static void setRolloverStateIcon(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isRolloverStateIcon(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_ROLLOVER_STATE_ICON, newValue);
        if (newValue) {
            TextFieldSupport.changeCursor(c, 0);
        }
        c.repaint();
    }

    private static boolean isRolloverStateMenu(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_ROLLOVER_STATE_MENU));
    }

    private static void setRolloverStateMenu(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isRolloverStateMenu(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_ROLLOVER_STATE_MENU, newValue);
        if (newValue) {
            TextFieldSupport.changeCursor(c, 0);
        }
        c.repaint();
    }

    private static boolean isPressed(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_PRESSED));
    }

    private static void setPressed(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isPressed(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_PRESSED, newValue);
        c.repaint();
    }

    private static boolean isIconClickable(JTextComponent c) {
        Action iconAction = TextFieldSupport.getIconAction(c);
        return iconAction != null && iconAction.isEnabled();
    }

    private static boolean isIconPainted(JTextComponent c) {
        if (TextFieldSupport.isIconVisibleAlways(c)) {
            return true;
        }
        if (!c.isEnabled() || !c.isEditable()) {
            return false;
        }
        if (c.isFocusOwner() || TextFieldSupport.isPopupMenuVisible(c)) {
            return true;
        }
        Action action = TextFieldSupport.getIconAction(c);
        return action != null && action.isEnabled() && (TextFieldSupport.isRolloverStateTextBox(c) || TextFieldSupport.isRolloverStateIcon(c) || TextFieldSupport.isRolloverStateMenu(c));
    }

    private static boolean isMenuIconPainted(JTextComponent c) {
        return TextFieldSupport.hasMenu(c) && (TextFieldSupport.isIconPainted(c) || TextFieldSupport.isRolloverStateTextBox(c) || TextFieldSupport.isRolloverStateIcon(c) || TextFieldSupport.isRolloverStateMenu(c));
    }

    private static boolean isPopupMenuVisible(JTextComponent c) {
        JPopupMenu menu = TextFieldSupport.getMenu(c);
        return menu != null && menu.isVisible();
    }

    private static boolean hasMenu(JTextComponent c) {
        return TextFieldSupport.getMenu(c) != null;
    }

    private static boolean isOverIcon(JTextComponent c, int x, int y) {
        return TextFieldSupport.isIconPainted(c) && TextFieldSupport.getIconBounds(c).contains(x, y);
    }

    private static Rectangle getIconBounds(JTextComponent c) {
        Icon actionIcon = TextFieldSupport.getCurrentActionIcon(c, -1);
        if (actionIcon == null) {
            return new Rectangle();
        }
        boolean isLTR = c.getComponentOrientation().isLeftToRight();
        boolean hasMenu = TextFieldSupport.hasMenu(c);
        Icon menuIcon = TextFieldSupport.getCurrentMenuIcon(c, -1);
        int iconShift = hasMenu ? menuIcon.getIconWidth() : 0;
        Insets margin = c.getMargin();
        Insets insets = c.getInsets();
        int marginLeft = margin != null ? margin.left : 0;
        int marginRight = margin != null ? margin.right : 0;
        int left = insets.left - marginLeft;
        int right = insets.right - marginRight;
        int x = isLTR ? c.getWidth() - right : iconShift;
        int y = 0;
        int width = (isLTR ? right : left) - iconShift;
        int height = c.getHeight();
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    private static boolean isOverMenu(JTextComponent c, int x, int y) {
        return TextFieldSupport.hasMenu(c) && TextFieldSupport.getMenuBounds(c).contains(x, y);
    }

    private static boolean isOverText(JTextComponent c, InputEvent e) {
        Point p;
        if (e instanceof MouseEvent) {
            p = ((MouseEvent)e).getPoint();
        } else {
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info == null) {
                return false;
            }
            p = info.getLocation();
            SwingUtilities.convertPointFromScreen(p, c);
        }
        return TextFieldSupport.isOverText(c, p.x, p.y);
    }

    private static boolean isOverText(JTextComponent c, int x, int y) {
        int offs0 = 0;
        int offs1 = c.getText().length();
        Insets insets = c.getInsets();
        try {
            Shape shape = c.getUI().getRootView(c).modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, new Rectangle());
            Rectangle b = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            Rectangle textBounds = new Rectangle(insets.left, insets.top, b.width, b.height);
            return textBounds.contains(x, y);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static Rectangle getMenuBounds(JTextComponent c) {
        if (!TextFieldSupport.hasMenu(c)) {
            return new Rectangle();
        }
        boolean isLTR = c.getComponentOrientation().isLeftToRight();
        Insets margin = c.getMargin();
        Insets insets = c.getInsets();
        int marginLeft = margin != null ? margin.left : 0;
        int marginRight = margin != null ? margin.right : 0;
        int left = insets.left - marginLeft;
        int right = insets.right - marginRight;
        int actionIconWidth = TextFieldSupport.isIconPainted(c) && TextFieldSupport.getActionBaseIcon(c) != null ? TextFieldSupport.getCurrentActionIcon(c, -1).getIconWidth() : 0;
        int x = isLTR ? c.getWidth() - right + actionIconWidth : 0;
        int y = 0;
        int width = (isLTR ? right : left) - actionIconWidth;
        int height = c.getHeight();
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    private static void changeCursor(JTextComponent c, int type) {
        c.setCursor(Cursor.getPredefinedCursor(type));
    }

    private static boolean isControlDown(JTextComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(KEY_CONTROL_DOWN));
    }

    private static void setControlDown(JTextComponent c, boolean newValue) {
        boolean oldValue = TextFieldSupport.isControlDown(c);
        if (oldValue == newValue) {
            return;
        }
        c.putClientProperty(KEY_CONTROL_DOWN, newValue);
        TextFieldSupport.updateLink(c);
    }

    private static void updateLink(JTextComponent c) {
        Action linkAction = TextFieldSupport.getLinkAction(c);
        boolean linkPainted = TextFieldSupport.isControlDown(c) && TextFieldSupport.isRolloverStateText(c) && linkAction != null && linkAction.isEnabled();
        LinkUnderlineSupport.setLinkPainted(c, linkPainted);
    }

    private static boolean isControlDown(InputEvent e) {
        return SystemUtils.IS_OS_MAC ? (e.getModifiersEx() & 0x100) != 0 : (e.getModifiersEx() & 0x80) != 0;
    }

    private static void showPopupMenu(JTextComponent c) {
        JPopupMenu popupMenu = TextFieldSupport.getMenu(c);
        ComponentOrientation co = c.getComponentOrientation();
        if (co != popupMenu.getComponentOrientation()) {
            popupMenu.applyComponentOrientation(co);
        }
        popupMenu.pack();
        int x = co.isLeftToRight() ? c.getWidth() - popupMenu.getPreferredSize().width : 0;
        popupMenu.show(c, x, c.getHeight() - 1);
    }

    private static Action getShowPopupAction() {
        if (showPopupAction == null) {
            showPopupAction = new ShowPopupAction();
        }
        return showPopupAction;
    }

    static {
        EVENT_HANDLER = new EventHandler();
    }

    private static final class EventHandler
    implements FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            EventHandler.field(e).repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            EventHandler.field(e).repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JTextComponent c = EventHandler.field(e);
            TextFieldSupport.setRolloverStateText(c, TextFieldSupport.isOverText(c, e));
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TextFieldSupport.setControlDown(EventHandler.field(e), TextFieldSupport.isControlDown(e));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TextFieldSupport.setControlDown(EventHandler.field(e), TextFieldSupport.isControlDown(e));
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTextComponent field = EventHandler.field(e);
            TextFieldSupport.setControlDown(field, TextFieldSupport.isControlDown(e));
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            TextFieldSupport.setPressed(field, true);
            if (TextFieldSupport.isOverMenu(field, e.getX(), e.getY())) {
                TextFieldSupport.showPopupMenu(field);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JTextComponent field = EventHandler.field(e);
            TextFieldSupport.setControlDown(field, TextFieldSupport.isControlDown(e));
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            TextFieldSupport.setPressed(field, false);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTextComponent field = EventHandler.field(e);
            TextFieldSupport.setControlDown(field, TextFieldSupport.isControlDown(e));
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            Action iconAction = TextFieldSupport.getIconAction(field);
            if (iconAction != null && iconAction.isEnabled() && TextFieldSupport.isOverIcon(field, e.getX(), e.getY())) {
                EventHandler.performAction(field, iconAction);
                return;
            }
            Action linkAction = TextFieldSupport.getLinkAction(field);
            if (linkAction != null && linkAction.isEnabled() && LinkUnderlineSupport.isLinkPainted(field)) {
                EventHandler.performAction(field, linkAction);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            EventHandler.setRolloverState(e);
            TextFieldSupport.setControlDown(EventHandler.field(e), TextFieldSupport.isControlDown(e));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTextComponent field = EventHandler.field(e);
            TextFieldSupport.setRolloverStateTextBox(field, false);
            TextFieldSupport.setRolloverStateText(field, false);
            TextFieldSupport.setRolloverStateIcon(field, false);
            TextFieldSupport.setRolloverStateMenu(field, false);
            TextFieldSupport.setControlDown(EventHandler.field(e), false);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            EventHandler.setRolloverState(e);
            TextFieldSupport.setControlDown(EventHandler.field(e), TextFieldSupport.isControlDown(e));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            JPopupMenu menu = (JPopupMenu)e.getSource();
            if (!menu.isVisible() && menu.getInvoker() != null) {
                menu.getInvoker().repaint();
            }
        }

        private static void setRolloverState(MouseEvent e) {
            boolean overMenu;
            boolean overIcon;
            boolean overText;
            boolean overTextBox;
            JTextComponent c = EventHandler.field(e);
            if (TextFieldSupport.isOverIcon(c, e.getX(), e.getY())) {
                overTextBox = false;
                overText = false;
                overIcon = true;
                overMenu = false;
            } else if (TextFieldSupport.isOverMenu(c, e.getX(), e.getY())) {
                overTextBox = false;
                overText = false;
                overIcon = false;
                overMenu = true;
            } else {
                overTextBox = true;
                overText = TextFieldSupport.isOverText(c, e);
                overIcon = false;
                overMenu = false;
            }
            TextFieldSupport.setRolloverStateTextBox(c, overTextBox);
            TextFieldSupport.setRolloverStateText(c, overText);
            TextFieldSupport.setRolloverStateIcon(c, overIcon);
            TextFieldSupport.setRolloverStateMenu(c, overMenu);
        }

        private static void performAction(JTextComponent c, Action action) {
            action.actionPerformed(new ActionEvent(c, 1001, (String)action.getValue("ActionCommandKey")));
        }

        private static JTextComponent field(ComponentEvent e) {
            return (JTextComponent)e.getComponent();
        }
    }

    private static final class IconBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 7449629122643189364L;

        private IconBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 0;
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            JTextComponent field = (JTextComponent)c;
            boolean isLTR = IconBorder.isLeftToRight(field);
            Icon actionIcon = TextFieldSupport.getActionBaseIcon(field);
            if (actionIcon != null && TextFieldSupport.isIconPainted(field)) {
                int iconWidth = actionIcon.getIconWidth();
                Insets margin = field.getMargin();
                if (isLTR) {
                    insets.right = iconWidth;
                } else {
                    insets.left = iconWidth + (margin != null ? margin.left : 0);
                }
            }
            if (TextFieldSupport.isMenuIconPainted(field)) {
                Icon menuIcon = TextFieldSupport.getCurrentMenuIcon(field, -1);
                if (isLTR) {
                    insets.right += menuIcon.getIconWidth();
                } else {
                    insets.left += menuIcon.getIconWidth();
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            int iconShift;
            Icon menuIcon;
            JTextComponent field = (JTextComponent)c;
            Insets margin = field.getMargin();
            int marginTop = margin != null ? margin.top : 0;
            int marginBottom = margin != null ? margin.bottom : 0;
            int marginRight = margin != null ? margin.right : 0;
            int iconHeight = h + marginTop + marginBottom;
            boolean isLTR = IconBorder.isLeftToRight(field);
            boolean hasMenu = TextFieldSupport.hasMenu(field);
            Icon actionIcon = TextFieldSupport.getCurrentActionIcon(field, iconHeight);
            if (hasMenu) {
                menuIcon = TextFieldSupport.getCurrentMenuIcon(field, iconHeight);
                iconShift = menuIcon.getIconWidth();
            } else {
                menuIcon = null;
                iconShift = 0;
            }
            if (actionIcon != null && TextFieldSupport.isIconPainted(field)) {
                int iconX = x + (isLTR ? w - actionIcon.getIconWidth() - iconShift : iconShift) + marginRight;
                int iconY = y + (h - actionIcon.getIconHeight()) / 2;
                actionIcon.paintIcon(c, g, iconX, iconY);
            }
            if (TextFieldSupport.isMenuIconPainted(field)) {
                int menuX = x + w - menuIcon.getIconWidth() + marginRight;
                int menuY = y - marginTop;
                menuIcon.paintIcon(c, g, menuX, menuY);
            }
        }

        private static boolean isLeftToRight(JTextComponent field) {
            return field.getComponentOrientation().isLeftToRight();
        }
    }

    private static final class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
            super(null);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt DOWN"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = (JTextComponent)e.getSource();
            TextFieldSupport.showPopupMenu(c);
        }
    }
}

