/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.TreeChartModel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTreeChart<T>
extends JComponent {
    public static final String PROPERTY_MODEL = "model";
    private final ChangeListener modelChangeHandler = new TreeChartModelChangeHandler();
    protected TreeChartModel<T> model;

    public AbstractTreeChart(TreeChartModel<T> model) {
        this.setModel(model);
        this.setFocusable(false);
    }

    public final TreeChartModel<T> getModel() {
        return this.model;
    }

    public final void setModel(TreeChartModel<T> newModel) {
        TreeChartModel<T> oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.modelChangeHandler);
        }
        this.model = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.modelChangeHandler);
        }
        if (oldModel == newModel) {
            return;
        }
        this.firePropertyChange(PROPERTY_MODEL, oldModel, newModel);
        this.invalidateCache();
        this.repaint();
    }

    protected abstract void render(Graphics2D var1, T var2);

    private boolean hasEmptyModel() {
        return this.model == null || this.model.getChildCount(this.model.getRoot()) == 0;
    }

    private void invalidateCache() {
    }

    private void ensureValidCache() {
    }

    protected final int[] computePartitions(T node, int totalWidth) {
        long totalSize = this.model.getSize(node);
        int elements = this.model.getChildCount(node);
        int[] result = new int[elements];
        if (elements == 1) {
            result[0] = totalWidth;
            return result;
        }
        double lastRoundingRest = 0.0;
        int usedWidth = 0;
        for (int i = 0; i < elements; ++i) {
            double roundingRest;
            double size = this.model.getSize(this.model.getChild(node, i));
            double fraction = totalSize == 0L ? 1.0 : size / (double)totalSize;
            double width = fraction * (double)totalWidth;
            int roundedWidth = (int)Math.round(width + lastRoundingRest);
            lastRoundingRest = roundingRest = width - (double)roundedWidth;
            result[i] = i < elements - 1 ? roundedWidth : totalWidth - usedWidth;
            usedWidth += roundedWidth;
        }
        return result;
    }

    @Override
    public final void paint(Graphics g) {
        g.setFont(this.getFont());
        this.paint0((Graphics2D)g);
    }

    private void paint0(Graphics2D g2) {
        if (this.hasEmptyModel()) {
            this.renderNoData(g2);
            return;
        }
        this.ensureValidCache();
        Object newAAHint = RenderingHints.VALUE_ANTIALIAS_ON;
        Object oldAAHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (newAAHint != oldAAHint) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, newAAHint);
        } else {
            oldAAHint = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.render(g2, this.model.getRoot());
        this.setCursor(Cursor.getDefaultCursor());
        if (oldAAHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
        }
    }

    private void renderNoData(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics();
        String str = "No Tree Data";
        int x = (this.getSize().width - fm.stringWidth(str)) / 2;
        int y = (this.getSize().height + fm.getAscent()) / 2;
        g2.setColor(Color.BLACK);
        g2.drawString(str, x, y);
    }

    private final class TreeChartModelChangeHandler
    implements ChangeListener {
        private TreeChartModelChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractTreeChart.this.invalidateCache();
            AbstractTreeChart.this.repaint();
        }
    }
}

