/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.response;

import com.jgoodies.app.response.ResponseError;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ResponseDocument<D> {
    private D data;
    private final List<ResponseError> errors = new ArrayList<ResponseError>();
    private Object meta;

    private ResponseDocument() {
    }

    public D getData() {
        return this.data;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<ResponseError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public Optional<ResponseError> firstError() {
        return Optional.ofNullable(this.errors.isEmpty() ? null : this.errors.get(0));
    }

    public Object getMeta() {
        return this.meta;
    }

    public static final class Builder<T> {
        private final ResponseDocument<T> target = new ResponseDocument();

        public Builder<T> data(T data) {
            Preconditions.checkArgument(!this.target.hasErrors(), "Errors have been set before. Data and errors must not coexist.");
            ((ResponseDocument)this.target).data = data;
            return this;
        }

        public Builder<T> addError(ResponseError error) {
            Preconditions.checkArgument(!this.target.hasErrors(), "Data has been set before. Errors and data must not coexist.");
            ((ResponseDocument)this.target).errors.add(error);
            return this;
        }

        public Builder<T> meta(Object meta) {
            ((ResponseDocument)this.target).meta = meta;
            return this;
        }

        public Builder<T> invalid(ValidationResult result) {
            this.addError(new ResponseError.Builder().badRequest().code("Invalid").build());
            this.meta(result);
            return this;
        }

        public ResponseDocument<T> build() {
            return this.target;
        }
    }
}

