/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rundeck.client.util.DataOutput;

public class Format {
    private Format() {
    }

    public static String format(String format, DataOutput data, String start, String end) {
        return Format.format(format, data.asMap(), start, end);
    }

    public static String format(String format, Map<?, ?> data, String start, String end) {
        Pattern pat = Pattern.compile(Pattern.quote(start) + "([\\w._-]+)" + Pattern.quote(end));
        Matcher matcher = pat.matcher(format);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String found = matcher.group(1);
            String[] path = new String[]{found};
            if (found.contains(".")) {
                path = found.split("\\.");
            }
            Object result = Format.descend(data, path);
            String replacement = "";
            if (result != null) {
                replacement = Matcher.quoteReplacement(result.toString());
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Object descend(Map<?, ?> data, String ... found) {
        if (found == null || found.length == 0) {
            return null;
        }
        String key = found[0];
        Object value = data.getOrDefault(key, null);
        if (null == value) {
            return null;
        }
        if (found.length > 1) {
            String[] rest = new String[found.length - 1];
            System.arraycopy(found, 1, rest, 0, rest.length);
            if (value instanceof Map) {
                return Format.descend(value, rest);
            }
            return null;
        }
        return value;
    }

    public static Function<Map<?, ?>, String> formatter(String format, String start, String end) {
        return map -> Format.format(format, map, start, end);
    }

    public static <X extends DataOutput> Function<X, String> dataFormatter(String format, String start, String end) {
        return Format.formatter(format, DataOutput::asMap, start, end);
    }

    public static <X> Function<X, String> formatter(String format, Function<X, Map<?, ?>> convert, String start, String end) {
        return obj -> Format.format(format, (Map)convert.apply(obj), start, end);
    }

    public static String date(Date date, String simpleFormat) {
        return new SimpleDateFormat(simpleFormat).format(date);
    }
}

