package org.antlr.v4.unicode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ArrayList;

import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.Interval;

/**
 * Code-generated utility class mapping Unicode properties to Unicode code point ranges.
 */
public abstract class UnicodeData {
	private static final Map<String, IntervalSet> propertyCodePointRanges = new HashMap<>(1185);
	private static final Map<String, String> propertyAliases = new HashMap<>(5156 / 2);

	private static void addProperty(String propertyName, int[] rawIntervals) {
		List<Interval> intervals = new ArrayList<>(rawIntervals.length / 2);
		for (int i = 0; i < rawIntervals.length; i += 2) {
			intervals.add(new Interval(rawIntervals[i], rawIntervals[i + 1]));
		}
		IntervalSet result = new IntervalSet(intervals);
		result.setReadonly(true);
		propertyCodePointRanges.put(propertyName, result);
	}

	static private void addProperty1() { addProperty("cc", new int[] { 0,31,127,159 }); }
	static private void addProperty2() { addProperty("c", new int[] { 0,31,127,159,173,173,888,889,896,899,907,907,909,909,930,930,1328,1328,1367,1368,1419,1420,1424,1424,1480,1487,1515,1518,1525,1541,1564,1564,1757,1757,1806,1807,1867,1868,1970,1983,2043,2044,2094,2095,2111,2111,2140,2141,2143,2143,2155,2159,2191,2199,2274,2274,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2679,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2802,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2936,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3067,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3190,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3408,3411,3428,3429,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3573,3584,3643,3646,3676,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3912,3912,3949,3952,3992,3992,4029,4029,4045,4045,4059,4095,4294,4294,4296,4300,4302,4303,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4989,4991,5018,5023,5110,5111,5118,5119,5789,5791,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6110,6111,6122,6127,6138,6143,6158,6158,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6463,6465,6467,6510,6511,6517,6527,6572,6575,6602,6607,6619,6621,6684,6685,6751,6751,6781,6782,6794,6799,6810,6815,6830,6831,6863,6911,6989,6991,7039,7039,7156,7163,7224,7226,7242,7244,7305,7311,7355,7356,7368,7375,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8203,8207,8234,8238,8288,8303,8306,8307,8335,8335,8349,8351,8385,8399,8433,8447,8588,8591,9255,9279,9291,9311,11124,11125,11158,11158,11508,11512,11558,11558,11560,11564,11566,11567,11624,11630,11633,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12352,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,42125,42127,42183,42191,42540,42559,42744,42751,42955,42959,42962,42962,42964,42964,42970,42993,43053,43055,43066,43071,43128,43135,43206,43213,43226,43231,43348,43358,43389,43391,43470,43470,43482,43485,43519,43519,43575,43583,43598,43599,43610,43611,43715,43738,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43884,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,63743,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64451,64466,64912,64913,64968,64974,64976,65007,65050,65055,65107,65107,65127,65127,65132,65135,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65531,65534,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65791,65795,65798,65844,65846,65935,65935,65949,65951,65953,65999,66046,66175,66205,66207,66257,66271,66300,66303,66340,66348,66379,66383,66427,66431,66462,66462,66500,66503,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66926,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67670,67743,67750,67760,67807,67827,67827,67830,67834,67868,67870,67898,67902,67904,67967,68024,68027,68048,68049,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,68175,68185,68191,68256,68287,68327,68330,68343,68351,68406,68408,68438,68439,68467,68471,68498,68504,68509,68520,68528,68607,68681,68735,68787,68799,68851,68857,68904,68911,68922,69215,69247,69247,69290,69290,69294,69295,69298,69372,69416,69423,69466,69487,69514,69551,69580,69599,69623,69631,69710,69713,69750,69758,69821,69821,69827,69839,69865,69871,69882,69887,69941,69941,69960,69967,70007,70015,70112,70112,70133,70143,70162,70162,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70748,70748,70754,70783,70856,70863,70874,71039,71094,71095,71134,71167,71237,71247,71258,71263,71277,71295,71354,71359,71370,71423,71451,71452,71468,71471,71495,71679,71740,71839,71923,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72007,72015,72026,72095,72104,72105,72152,72153,72165,72191,72264,72271,72355,72367,72441,72447,72458,72703,72713,72713,72759,72759,72774,72783,72813,72815,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73562,73647,73649,73663,73714,73726,74650,74751,74863,74863,74869,74879,75076,77711,77811,77823,78896,78911,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92998,93007,93018,93018,93026,93026,93048,93052,93072,93759,93851,93951,94027,94030,94088,94094,94112,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113819,113824,118527,118574,118575,118599,118607,118724,118783,119030,119039,119079,119080,119155,119162,119275,119295,119366,119487,119508,119519,119540,119551,119639,119647,119673,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,121484,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123216,123535,123567,123583,123642,123646,123648,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125126,125143,125183,125260,125263,125274,125277,125280,126064,126133,126208,126270,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,126703,126706,126975,127020,127023,127124,127135,127151,127152,127168,127168,127184,127184,127222,127231,127406,127461,127491,127503,127548,127551,127561,127567,127570,127583,127590,127743,128728,128731,128749,128751,128765,128767,128887,128890,128986,128991,129004,129007,129009,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129199,129202,129279,129620,129631,129646,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,129791,129939,129939,129995,130031,130042,131071,173792,173823,177978,177983,178206,178207,183970,183983,191457,194559,195102,196607,201547,201551,205744,917759,918000,1114111 }); }
	static private void addProperty3() { addProperty("zs", new int[] { 32,32,160,160,5760,5760,8192,8202,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty4() { addProperty("z", new int[] { 32,32,160,160,5760,5760,8192,8202,8232,8233,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty5() { addProperty("po", new int[] { 33,35,37,39,42,42,44,44,46,47,58,59,63,64,92,92,161,161,167,167,182,183,191,191,894,894,903,903,1370,1375,1417,1417,1472,1472,1475,1475,1478,1478,1523,1524,1545,1546,1548,1549,1563,1563,1565,1567,1642,1645,1748,1748,1792,1805,2039,2041,2096,2110,2142,2142,2404,2405,2416,2416,2557,2557,2678,2678,2800,2800,3191,3191,3204,3204,3572,3572,3663,3663,3674,3675,3844,3858,3860,3860,3973,3973,4048,4052,4057,4058,4170,4175,4347,4347,4960,4968,5742,5742,5867,5869,5941,5942,6100,6102,6104,6106,6144,6149,6151,6154,6468,6469,6686,6687,6816,6822,6824,6829,7002,7008,7037,7038,7164,7167,7227,7231,7294,7295,7360,7367,7379,7379,8214,8215,8224,8231,8240,8248,8251,8254,8257,8259,8263,8273,8275,8275,8277,8286,11513,11516,11518,11519,11632,11632,11776,11777,11782,11784,11787,11787,11790,11798,11800,11801,11803,11803,11806,11807,11818,11822,11824,11833,11836,11839,11841,11841,11843,11855,11858,11860,12289,12291,12349,12349,12539,12539,42238,42239,42509,42511,42611,42611,42622,42622,42738,42743,43124,43127,43214,43215,43256,43258,43260,43260,43310,43311,43359,43359,43457,43469,43486,43487,43612,43615,43742,43743,43760,43761,44011,44011,65040,65046,65049,65049,65072,65072,65093,65094,65097,65100,65104,65106,65108,65111,65119,65121,65128,65128,65130,65131,65281,65283,65285,65287,65290,65290,65292,65292,65294,65295,65306,65307,65311,65312,65340,65340,65377,65377,65380,65381,65792,65794,66463,66463,66512,66512,66927,66927,67671,67671,67871,67871,67903,67903,68176,68184,68223,68223,68336,68342,68409,68415,68505,68508,69461,69465,69510,69513,69703,69709,69819,69820,69822,69825,69952,69955,70004,70005,70085,70088,70093,70093,70107,70107,70109,70111,70200,70205,70313,70313,70731,70735,70746,70747,70749,70749,70854,70854,71105,71127,71233,71235,71264,71276,71353,71353,71484,71486,71739,71739,72004,72006,72162,72162,72255,72262,72346,72348,72350,72354,72448,72457,72769,72773,72816,72817,73463,73464,73539,73551,73727,73727,74864,74868,77809,77810,92782,92783,92917,92917,92983,92987,92996,92996,93847,93850,94178,94178,113823,113823,121479,121483,125278,125279 }); }
	static private void addProperty6() { addProperty("p", new int[] { 33,35,37,42,44,47,58,59,63,64,91,93,95,95,123,123,125,125,161,161,167,167,171,171,182,183,187,187,191,191,894,894,903,903,1370,1375,1417,1418,1470,1470,1472,1472,1475,1475,1478,1478,1523,1524,1545,1546,1548,1549,1563,1563,1565,1567,1642,1645,1748,1748,1792,1805,2039,2041,2096,2110,2142,2142,2404,2405,2416,2416,2557,2557,2678,2678,2800,2800,3191,3191,3204,3204,3572,3572,3663,3663,3674,3675,3844,3858,3860,3860,3898,3901,3973,3973,4048,4052,4057,4058,4170,4175,4347,4347,4960,4968,5120,5120,5742,5742,5787,5788,5867,5869,5941,5942,6100,6102,6104,6106,6144,6154,6468,6469,6686,6687,6816,6822,6824,6829,7002,7008,7037,7038,7164,7167,7227,7231,7294,7295,7360,7367,7379,7379,8208,8231,8240,8259,8261,8273,8275,8286,8317,8318,8333,8334,8968,8971,9001,9002,10088,10101,10181,10182,10214,10223,10627,10648,10712,10715,10748,10749,11513,11516,11518,11519,11632,11632,11776,11822,11824,11855,11858,11869,12289,12291,12296,12305,12308,12319,12336,12336,12349,12349,12448,12448,12539,12539,42238,42239,42509,42511,42611,42611,42622,42622,42738,42743,43124,43127,43214,43215,43256,43258,43260,43260,43310,43311,43359,43359,43457,43469,43486,43487,43612,43615,43742,43743,43760,43761,44011,44011,64830,64831,65040,65049,65072,65106,65108,65121,65123,65123,65128,65128,65130,65131,65281,65283,65285,65290,65292,65295,65306,65307,65311,65312,65339,65341,65343,65343,65371,65371,65373,65373,65375,65381,65792,65794,66463,66463,66512,66512,66927,66927,67671,67671,67871,67871,67903,67903,68176,68184,68223,68223,68336,68342,68409,68415,68505,68508,69293,69293,69461,69465,69510,69513,69703,69709,69819,69820,69822,69825,69952,69955,70004,70005,70085,70088,70093,70093,70107,70107,70109,70111,70200,70205,70313,70313,70731,70735,70746,70747,70749,70749,70854,70854,71105,71127,71233,71235,71264,71276,71353,71353,71484,71486,71739,71739,72004,72006,72162,72162,72255,72262,72346,72348,72350,72354,72448,72457,72769,72773,72816,72817,73463,73464,73539,73551,73727,73727,74864,74868,77809,77810,92782,92783,92917,92917,92983,92987,92996,92996,93847,93850,94178,94178,113823,113823,121479,121483,125278,125279 }); }
	static private void addProperty7() { addProperty("sc", new int[] { 36,36,162,165,1423,1423,1547,1547,2046,2047,2546,2547,2555,2555,2801,2801,3065,3065,3647,3647,6107,6107,8352,8384,43064,43064,65020,65020,65129,65129,65284,65284,65504,65505,65509,65510,73693,73696,123647,123647,126128,126128 }); }
	static private void addProperty8() { addProperty("s", new int[] { 36,36,43,43,60,62,94,94,96,96,124,124,126,126,162,166,168,169,172,172,174,177,180,180,184,184,215,215,247,247,706,709,722,735,741,747,749,749,751,767,885,885,900,901,1014,1014,1154,1154,1421,1423,1542,1544,1547,1547,1550,1551,1758,1758,1769,1769,1789,1790,2038,2038,2046,2047,2184,2184,2546,2547,2554,2555,2801,2801,2928,2928,3059,3066,3199,3199,3407,3407,3449,3449,3647,3647,3841,3843,3859,3859,3861,3863,3866,3871,3892,3892,3894,3894,3896,3896,4030,4037,4039,4044,4046,4047,4053,4056,4254,4255,5008,5017,5741,5741,6107,6107,6464,6464,6622,6655,7009,7018,7028,7036,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,8260,8260,8274,8274,8314,8316,8330,8332,8352,8384,8448,8449,8451,8454,8456,8457,8468,8468,8470,8472,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8506,8507,8512,8516,8522,8525,8527,8527,8586,8587,8592,8967,8972,9000,9003,9254,9280,9290,9372,9449,9472,10087,10132,10180,10183,10213,10224,10626,10649,10711,10716,10747,10750,11123,11126,11157,11159,11263,11493,11498,11856,11857,11904,11929,11931,12019,12032,12245,12272,12283,12292,12292,12306,12307,12320,12320,12342,12343,12350,12351,12443,12444,12688,12689,12694,12703,12736,12771,12800,12830,12842,12871,12880,12880,12896,12927,12938,12976,12992,13311,19904,19967,42128,42182,42752,42774,42784,42785,42889,42890,43048,43051,43062,43065,43639,43641,43867,43867,43882,43883,64297,64297,64434,64450,64832,64847,64975,64975,65020,65023,65122,65122,65124,65126,65129,65129,65284,65284,65291,65291,65308,65310,65342,65342,65344,65344,65372,65372,65374,65374,65504,65510,65512,65518,65532,65533,65847,65855,65913,65929,65932,65934,65936,65948,65952,65952,66000,66044,67703,67704,68296,68296,71487,71487,73685,73713,92988,92991,92997,92997,113820,113820,118608,118723,118784,119029,119040,119078,119081,119140,119146,119148,119171,119172,119180,119209,119214,119274,119296,119361,119365,119365,119552,119638,120513,120513,120539,120539,120571,120571,120597,120597,120629,120629,120655,120655,120687,120687,120713,120713,120745,120745,120771,120771,120832,121343,121399,121402,121453,121460,121462,121475,121477,121478,123215,123215,123647,123647,126124,126124,126128,126128,126254,126254,126704,126705,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127245,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994 }); }
	static private void addProperty9() { addProperty("ps", new int[] { 40,40,91,91,123,123,3898,3898,3900,3900,5787,5787,8218,8218,8222,8222,8261,8261,8317,8317,8333,8333,8968,8968,8970,8970,9001,9001,10088,10088,10090,10090,10092,10092,10094,10094,10096,10096,10098,10098,10100,10100,10181,10181,10214,10214,10216,10216,10218,10218,10220,10220,10222,10222,10627,10627,10629,10629,10631,10631,10633,10633,10635,10635,10637,10637,10639,10639,10641,10641,10643,10643,10645,10645,10647,10647,10712,10712,10714,10714,10748,10748,11810,11810,11812,11812,11814,11814,11816,11816,11842,11842,11861,11861,11863,11863,11865,11865,11867,11867,12296,12296,12298,12298,12300,12300,12302,12302,12304,12304,12308,12308,12310,12310,12312,12312,12314,12314,12317,12317,64831,64831,65047,65047,65077,65077,65079,65079,65081,65081,65083,65083,65085,65085,65087,65087,65089,65089,65091,65091,65095,65095,65113,65113,65115,65115,65117,65117,65288,65288,65339,65339,65371,65371,65375,65375,65378,65378 }); }
	static private void addProperty10() { addProperty("pe", new int[] { 41,41,93,93,125,125,3899,3899,3901,3901,5788,5788,8262,8262,8318,8318,8334,8334,8969,8969,8971,8971,9002,9002,10089,10089,10091,10091,10093,10093,10095,10095,10097,10097,10099,10099,10101,10101,10182,10182,10215,10215,10217,10217,10219,10219,10221,10221,10223,10223,10628,10628,10630,10630,10632,10632,10634,10634,10636,10636,10638,10638,10640,10640,10642,10642,10644,10644,10646,10646,10648,10648,10713,10713,10715,10715,10749,10749,11811,11811,11813,11813,11815,11815,11817,11817,11862,11862,11864,11864,11866,11866,11868,11868,12297,12297,12299,12299,12301,12301,12303,12303,12305,12305,12309,12309,12311,12311,12313,12313,12315,12315,12318,12319,64830,64830,65048,65048,65078,65078,65080,65080,65082,65082,65084,65084,65086,65086,65088,65088,65090,65090,65092,65092,65096,65096,65114,65114,65116,65116,65118,65118,65289,65289,65341,65341,65373,65373,65376,65376,65379,65379 }); }
	static private void addProperty11() { addProperty("sm", new int[] { 43,43,60,62,124,124,126,126,172,172,177,177,215,215,247,247,1014,1014,1542,1544,8260,8260,8274,8274,8314,8316,8330,8332,8472,8472,8512,8516,8523,8523,8592,8596,8602,8603,8608,8608,8611,8611,8614,8614,8622,8622,8654,8655,8658,8658,8660,8660,8692,8959,8992,8993,9084,9084,9115,9139,9180,9185,9655,9655,9665,9665,9720,9727,9839,9839,10176,10180,10183,10213,10224,10239,10496,10626,10649,10711,10716,10747,10750,11007,11056,11076,11079,11084,64297,64297,65122,65122,65124,65126,65291,65291,65308,65310,65372,65372,65374,65374,65506,65506,65513,65516,120513,120513,120539,120539,120571,120571,120597,120597,120629,120629,120655,120655,120687,120687,120713,120713,120745,120745,120771,120771,126704,126705 }); }
	static private void addProperty12() { addProperty("pd", new int[] { 45,45,1418,1418,1470,1470,5120,5120,6150,6150,8208,8213,11799,11799,11802,11802,11834,11835,11840,11840,11869,11869,12316,12316,12336,12336,12448,12448,65073,65074,65112,65112,65123,65123,65293,65293,69293,69293 }); }
	static private void addProperty13() { addProperty("nd", new int[] { 48,57,1632,1641,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty14() { addProperty("n", new int[] { 48,57,178,179,185,185,188,190,1632,1641,1776,1785,1984,1993,2406,2415,2534,2543,2548,2553,2662,2671,2790,2799,2918,2927,2930,2935,3046,3058,3174,3183,3192,3198,3302,3311,3416,3422,3430,3448,3558,3567,3664,3673,3792,3801,3872,3891,4160,4169,4240,4249,4969,4988,5870,5872,6112,6121,6128,6137,6160,6169,6470,6479,6608,6618,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,8304,8304,8308,8313,8320,8329,8528,8578,8581,8585,9312,9371,9450,9471,10102,10131,11517,11517,12295,12295,12321,12329,12344,12346,12690,12693,12832,12841,12872,12879,12881,12895,12928,12937,12977,12991,42528,42537,42726,42735,43056,43061,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,65799,65843,65856,65912,65930,65931,66273,66299,66336,66339,66369,66369,66378,66378,66513,66517,66720,66729,67672,67679,67705,67711,67751,67759,67835,67839,67862,67867,68028,68029,68032,68047,68050,68095,68160,68168,68221,68222,68253,68255,68331,68335,68440,68447,68472,68479,68521,68527,68858,68863,68912,68921,69216,69246,69405,69414,69457,69460,69573,69579,69714,69743,69872,69881,69942,69951,70096,70105,70113,70132,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71483,71904,71922,72016,72025,72784,72812,73040,73049,73120,73129,73552,73561,73664,73684,74752,74862,92768,92777,92864,92873,93008,93017,93019,93025,93824,93846,119488,119507,119520,119539,119648,119672,120782,120831,123200,123209,123632,123641,124144,124153,125127,125135,125264,125273,126065,126123,126125,126127,126129,126132,126209,126253,126255,126269,127232,127244,130032,130041 }); }
	static private void addProperty15() { addProperty("lu", new int[] { 65,90,192,214,216,222,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,330,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,452,455,455,458,458,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,497,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,975,975,978,980,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1012,1012,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,4256,4293,4295,4295,4301,4301,5024,5109,7312,7354,7357,7359,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8120,8123,8136,8139,8152,8155,8168,8172,8184,8187,8450,8450,8455,8455,8459,8461,8464,8466,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8496,8499,8510,8511,8517,8517,8579,8579,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,119808,119833,119860,119885,119912,119937,119964,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119989,120016,120041,120068,120069,120071,120074,120077,120084,120086,120092,120120,120121,120123,120126,120128,120132,120134,120134,120138,120144,120172,120197,120224,120249,120276,120301,120328,120353,120380,120405,120432,120457,120488,120512,120546,120570,120604,120628,120662,120686,120720,120744,120778,120778,125184,125217 }); }
	static private void addProperty16() { addProperty("l", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,880,884,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1369,1376,1416,1488,1514,1519,1522,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2417,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3654,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3782,3782,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5873,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6103,6103,6108,6108,6176,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6823,6823,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8579,8580,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11823,11823,12293,12294,12337,12341,12347,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42623,42653,42656,42725,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43488,43492,43494,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43741,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,66176,66204,66208,66256,66304,66335,66349,66368,66370,66377,66384,66421,66432,66461,66464,66499,66504,66511,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71840,71903,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93760,93823,93952,94026,94032,94032,94099,94111,94176,94177,94179,94179,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty17() { addProperty("sk", new int[] { 94,94,96,96,168,168,175,175,180,180,184,184,706,709,722,735,741,747,749,749,751,767,885,885,900,901,2184,2184,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,12443,12444,42752,42774,42784,42785,42889,42890,43867,43867,43882,43883,64434,64450,65342,65342,65344,65344,65507,65507,127995,127999 }); }
	static private void addProperty18() { addProperty("pc", new int[] { 95,95,8255,8256,8276,8276,65075,65076,65101,65103,65343,65343 }); }
	static private void addProperty19() { addProperty("ll", new int[] { 97,122,181,181,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,312,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,397,402,402,405,405,409,411,414,414,417,417,419,419,421,421,424,424,426,427,429,429,432,432,436,436,438,438,441,442,445,447,454,454,457,457,460,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,496,499,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,545,545,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,569,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,659,661,687,881,881,883,883,887,887,891,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1020,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1376,1416,4304,4346,4349,4351,5112,5117,7296,7304,7424,7467,7531,7543,7545,7578,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7837,7839,7839,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8071,8080,8087,8096,8103,8112,8116,8118,8119,8126,8126,8130,8132,8134,8135,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8458,8458,8462,8463,8467,8467,8495,8495,8500,8500,8505,8505,8508,8509,8518,8521,8526,8526,8580,8580,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11377,11377,11379,11380,11382,11387,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11492,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42651,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42801,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42863,42865,42872,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42894,42894,42897,42897,42899,42901,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42927,42927,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42963,42963,42965,42965,42967,42967,42969,42969,42998,42998,43002,43002,43824,43866,43872,43880,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,68800,68850,71872,71903,93792,93823,119834,119859,119886,119892,119894,119911,119938,119963,119990,119993,119995,119995,119997,120003,120005,120015,120042,120067,120094,120119,120146,120171,120198,120223,120250,120275,120302,120327,120354,120379,120406,120431,120458,120485,120514,120538,120540,120545,120572,120596,120598,120603,120630,120654,120656,120661,120688,120712,120714,120719,120746,120770,120772,120777,120779,120779,122624,122633,122635,122654,122661,122666,125218,125251 }); }
	static private void addProperty20() { addProperty("so", new int[] { 166,166,169,169,174,174,176,176,1154,1154,1421,1422,1550,1551,1758,1758,1769,1769,1789,1790,2038,2038,2554,2554,2928,2928,3059,3064,3066,3066,3199,3199,3407,3407,3449,3449,3841,3843,3859,3859,3861,3863,3866,3871,3892,3892,3894,3894,3896,3896,4030,4037,4039,4044,4046,4047,4053,4056,4254,4255,5008,5017,5741,5741,6464,6464,6622,6655,7009,7018,7028,7036,8448,8449,8451,8454,8456,8457,8468,8468,8470,8471,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8506,8507,8522,8522,8524,8525,8527,8527,8586,8587,8597,8601,8604,8607,8609,8610,8612,8613,8615,8621,8623,8653,8656,8657,8659,8659,8661,8691,8960,8967,8972,8991,8994,9000,9003,9083,9085,9114,9140,9179,9186,9254,9280,9290,9372,9449,9472,9654,9656,9664,9666,9719,9728,9838,9840,10087,10132,10175,10240,10495,11008,11055,11077,11078,11085,11123,11126,11157,11159,11263,11493,11498,11856,11857,11904,11929,11931,12019,12032,12245,12272,12283,12292,12292,12306,12307,12320,12320,12342,12343,12350,12351,12688,12689,12694,12703,12736,12771,12800,12830,12842,12871,12880,12880,12896,12927,12938,12976,12992,13311,19904,19967,42128,42182,43048,43051,43062,43063,43065,43065,43639,43641,64832,64847,64975,64975,65021,65023,65508,65508,65512,65512,65517,65518,65532,65533,65847,65855,65913,65929,65932,65934,65936,65948,65952,65952,66000,66044,67703,67704,68296,68296,71487,71487,73685,73692,73697,73713,92988,92991,92997,92997,113820,113820,118608,118723,118784,119029,119040,119078,119081,119140,119146,119148,119171,119172,119180,119209,119214,119274,119296,119361,119365,119365,119552,119638,120832,121343,121399,121402,121453,121460,121462,121475,121477,121478,123215,123215,126124,126124,126254,126254,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127245,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,127994,128000,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994 }); }
	static private void addProperty21() { addProperty("lo", new int[] { 170,170,186,186,443,443,448,451,660,660,1488,1514,1519,1522,1568,1599,1601,1610,1646,1647,1649,1747,1749,1749,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2048,2069,2112,2136,2144,2154,2160,2183,2185,2190,2208,2248,2308,2361,2365,2365,2384,2384,2392,2401,2418,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3653,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4352,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5121,5740,5743,5759,5761,5786,5792,5866,5873,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6108,6108,6176,6210,6212,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7287,7401,7404,7406,7411,7413,7414,7418,7418,8501,8504,11568,11623,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,12294,12294,12348,12348,12353,12438,12447,12447,12449,12538,12543,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,40980,40982,42124,42192,42231,42240,42507,42512,42527,42538,42539,42606,42606,42656,42725,42895,42895,42999,42999,43003,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43488,43492,43495,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43631,43633,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43740,43744,43754,43762,43762,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43968,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65382,65391,65393,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,66176,66204,66208,66256,66304,66335,66349,66368,66370,66377,66384,66421,66432,66461,66464,66499,66504,66511,66640,66717,66816,66855,66864,66915,67072,67382,67392,67413,67424,67431,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,93027,93047,93053,93071,93952,94026,94032,94032,94208,100343,100352,101589,101632,101640,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,122634,122634,123136,123180,123214,123214,123536,123565,123584,123627,124112,124138,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty22() { addProperty("pi", new int[] { 171,171,8216,8216,8219,8220,8223,8223,8249,8249,11778,11778,11780,11780,11785,11785,11788,11788,11804,11804,11808,11808 }); }
	static private void addProperty23() { addProperty("cf", new int[] { 173,173,1536,1541,1564,1564,1757,1757,1807,1807,2192,2193,2274,2274,6158,6158,8203,8207,8234,8238,8288,8292,8294,8303,65279,65279,65529,65531,69821,69821,69837,69837,78896,78911,113824,113827,119155,119162,917505,917505,917536,917631 }); }
	static private void addProperty24() { addProperty("no", new int[] { 178,179,185,185,188,190,2548,2553,2930,2935,3056,3058,3192,3198,3416,3422,3440,3448,3882,3891,4969,4988,6128,6137,6618,6618,8304,8304,8308,8313,8320,8329,8528,8543,8585,8585,9312,9371,9450,9471,10102,10131,11517,11517,12690,12693,12832,12841,12872,12879,12881,12895,12928,12937,12977,12991,43056,43061,65799,65843,65909,65912,65930,65931,66273,66299,66336,66339,67672,67679,67705,67711,67751,67759,67835,67839,67862,67867,68028,68029,68032,68047,68050,68095,68160,68168,68221,68222,68253,68255,68331,68335,68440,68447,68472,68479,68521,68527,68858,68863,69216,69246,69405,69414,69457,69460,69573,69579,69714,69733,70113,70132,71482,71483,71914,71922,72794,72812,73664,73684,93019,93025,93824,93846,119488,119507,119520,119539,119648,119672,125127,125135,126065,126123,126125,126127,126129,126132,126209,126253,126255,126269,127232,127244 }); }
	static private void addProperty25() { addProperty("pf", new int[] { 187,187,8217,8217,8221,8221,8250,8250,11779,11779,11781,11781,11786,11786,11789,11789,11805,11805,11809,11809 }); }
	static private void addProperty26() { addProperty("lt", new int[] { 453,453,456,456,459,459,498,498,8072,8079,8088,8095,8104,8111,8124,8124,8140,8140,8188,8188 }); }
	static private void addProperty27() { addProperty("lm", new int[] { 688,705,710,721,736,740,748,748,750,750,884,884,890,890,1369,1369,1600,1600,1765,1766,2036,2037,2042,2042,2074,2074,2084,2084,2088,2088,2249,2249,2417,2417,3654,3654,3782,3782,4348,4348,6103,6103,6211,6211,6823,6823,7288,7293,7468,7530,7544,7544,7579,7615,8305,8305,8319,8319,8336,8348,11388,11389,11631,11631,11823,11823,12293,12293,12337,12341,12347,12347,12445,12446,12540,12542,40981,40981,42232,42237,42508,42508,42623,42623,42652,42653,42775,42783,42864,42864,42888,42888,42994,42996,43000,43001,43471,43471,43494,43494,43632,43632,43741,43741,43763,43764,43868,43871,43881,43881,65392,65392,65438,65439,67456,67461,67463,67504,67506,67514,92992,92995,94099,94111,94176,94177,94179,94179,110576,110579,110581,110587,110589,110590,122928,122989,123191,123197,124139,124139,125259,125259 }); }
	static private void addProperty28() { addProperty("mn", new int[] { 768,879,1155,1159,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2497,2500,2509,2509,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2879,2879,2881,2884,2893,2893,2901,2902,2914,2915,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3270,3270,3276,3277,3298,3299,3328,3329,3387,3388,3393,3396,3405,3405,3426,3427,3457,3457,3530,3530,3538,3540,3542,3542,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6845,6847,6862,6912,6915,6964,6964,6966,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8400,8412,8417,8417,8421,8432,11503,11505,11647,11647,11744,11775,12330,12333,12441,12442,42607,42607,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70464,70464,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70835,70840,70842,70842,70847,70848,70850,70851,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,118528,118573,118576,118598,119143,119145,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917760,917999 }); }
	static private void addProperty29() { addProperty("m", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2307,2362,2364,2366,2383,2385,2391,2402,2403,2433,2435,2492,2492,2494,2500,2503,2504,2507,2509,2519,2519,2530,2531,2558,2558,2561,2563,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2691,2748,2748,2750,2757,2759,2761,2763,2765,2786,2787,2810,2815,2817,2819,2876,2876,2878,2884,2887,2888,2891,2893,2901,2903,2914,2915,2946,2946,3006,3010,3014,3016,3018,3021,3031,3031,3072,3076,3132,3132,3134,3140,3142,3144,3146,3149,3157,3158,3170,3171,3201,3203,3260,3260,3262,3268,3270,3272,3274,3277,3285,3286,3298,3299,3315,3315,3328,3331,3387,3388,3390,3396,3398,3400,3402,3405,3415,3415,3426,3427,3457,3459,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3902,3903,3953,3972,3974,3975,3981,3991,3993,4028,4038,4038,4139,4158,4182,4185,4190,4192,4194,4196,4199,4205,4209,4212,4226,4237,4239,4239,4250,4253,4957,4959,5906,5909,5938,5940,5970,5971,6002,6003,6068,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6443,6448,6459,6679,6683,6741,6750,6752,6780,6783,6783,6832,6862,6912,6916,6964,6980,7019,7027,7040,7042,7073,7085,7142,7155,7204,7223,7376,7378,7380,7400,7405,7405,7412,7412,7415,7417,7616,7679,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43043,43047,43052,43052,43136,43137,43188,43205,43232,43249,43263,43263,43302,43309,43335,43347,43392,43395,43443,43456,43493,43493,43561,43574,43587,43587,43596,43597,43643,43645,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43755,43759,43765,43766,44003,44010,44012,44013,64286,64286,65024,65039,65056,65071,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69632,69634,69688,69702,69744,69744,69747,69748,69759,69762,69808,69818,69826,69826,69888,69890,69927,69940,69957,69958,70003,70003,70016,70018,70067,70080,70089,70092,70094,70095,70188,70199,70206,70206,70209,70209,70367,70378,70400,70403,70459,70460,70462,70468,70471,70472,70475,70477,70487,70487,70498,70499,70502,70508,70512,70516,70709,70726,70750,70750,70832,70851,71087,71093,71096,71104,71132,71133,71216,71232,71339,71351,71453,71467,71724,71738,71984,71989,71991,71992,71995,71998,72000,72000,72002,72003,72145,72151,72154,72160,72164,72164,72193,72202,72243,72249,72251,72254,72263,72263,72273,72283,72330,72345,72751,72758,72760,72767,72850,72871,72873,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73098,73102,73104,73105,73107,73111,73459,73462,73472,73473,73475,73475,73524,73530,73534,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94033,94087,94095,94098,94180,94180,94192,94193,113821,113822,118528,118573,118576,118598,119141,119145,119149,119154,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917760,917999 }); }
	static private void addProperty30() { addProperty("cn", new int[] { 888,889,896,899,907,907,909,909,930,930,1328,1328,1367,1368,1419,1420,1424,1424,1480,1487,1515,1518,1525,1535,1806,1806,1867,1868,1970,1983,2043,2044,2094,2095,2111,2111,2140,2141,2143,2143,2155,2159,2191,2191,2194,2199,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2679,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2802,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2936,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3067,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3190,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3408,3411,3428,3429,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3573,3584,3643,3646,3676,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3912,3912,3949,3952,3992,3992,4029,4029,4045,4045,4059,4095,4294,4294,4296,4300,4302,4303,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4989,4991,5018,5023,5110,5111,5118,5119,5789,5791,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6110,6111,6122,6127,6138,6143,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6463,6465,6467,6510,6511,6517,6527,6572,6575,6602,6607,6619,6621,6684,6685,6751,6751,6781,6782,6794,6799,6810,6815,6830,6831,6863,6911,6989,6991,7039,7039,7156,7163,7224,7226,7242,7244,7305,7311,7355,7356,7368,7375,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8293,8293,8306,8307,8335,8335,8349,8351,8385,8399,8433,8447,8588,8591,9255,9279,9291,9311,11124,11125,11158,11158,11508,11512,11558,11558,11560,11564,11566,11567,11624,11630,11633,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12352,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,42125,42127,42183,42191,42540,42559,42744,42751,42955,42959,42962,42962,42964,42964,42970,42993,43053,43055,43066,43071,43128,43135,43206,43213,43226,43231,43348,43358,43389,43391,43470,43470,43482,43485,43519,43519,43575,43583,43598,43599,43610,43611,43715,43738,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43884,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,55295,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64451,64466,64912,64913,64968,64974,64976,65007,65050,65055,65107,65107,65127,65127,65132,65135,65141,65141,65277,65278,65280,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65528,65534,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65791,65795,65798,65844,65846,65935,65935,65949,65951,65953,65999,66046,66175,66205,66207,66257,66271,66300,66303,66340,66348,66379,66383,66427,66431,66462,66462,66500,66503,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66926,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67670,67743,67750,67760,67807,67827,67827,67830,67834,67868,67870,67898,67902,67904,67967,68024,68027,68048,68049,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,68175,68185,68191,68256,68287,68327,68330,68343,68351,68406,68408,68438,68439,68467,68471,68498,68504,68509,68520,68528,68607,68681,68735,68787,68799,68851,68857,68904,68911,68922,69215,69247,69247,69290,69290,69294,69295,69298,69372,69416,69423,69466,69487,69514,69551,69580,69599,69623,69631,69710,69713,69750,69758,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69960,69967,70007,70015,70112,70112,70133,70143,70162,70162,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70748,70748,70754,70783,70856,70863,70874,71039,71094,71095,71134,71167,71237,71247,71258,71263,71277,71295,71354,71359,71370,71423,71451,71452,71468,71471,71495,71679,71740,71839,71923,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72007,72015,72026,72095,72104,72105,72152,72153,72165,72191,72264,72271,72355,72367,72441,72447,72458,72703,72713,72713,72759,72759,72774,72783,72813,72815,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73562,73647,73649,73663,73714,73726,74650,74751,74863,74863,74869,74879,75076,77711,77811,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92998,93007,93018,93018,93026,93026,93048,93052,93072,93759,93851,93951,94027,94030,94088,94094,94112,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113819,113828,118527,118574,118575,118599,118607,118724,118783,119030,119039,119079,119080,119275,119295,119366,119487,119508,119519,119540,119551,119639,119647,119673,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,121484,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123216,123535,123567,123583,123642,123646,123648,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125126,125143,125183,125260,125263,125274,125277,125280,126064,126133,126208,126270,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,126703,126706,126975,127020,127023,127124,127135,127151,127152,127168,127168,127184,127184,127222,127231,127406,127461,127491,127503,127548,127551,127561,127567,127570,127583,127590,127743,128728,128731,128749,128751,128765,128767,128887,128890,128986,128991,129004,129007,129009,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129199,129202,129279,129620,129631,129646,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,129791,129939,129939,129995,130031,130042,131071,173792,173823,177978,177983,178206,178207,183970,183983,191457,194559,195102,196607,201547,201551,205744,917504,917506,917535,917632,917759,918000,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty31() { addProperty("me", new int[] { 1160,1161,6846,6846,8413,8416,8418,8420,42608,42610 }); }
	static private void addProperty32() { addProperty("mc", new int[] { 2307,2307,2363,2363,2366,2368,2377,2380,2382,2383,2434,2435,2494,2496,2503,2504,2507,2508,2519,2519,2563,2563,2622,2624,2691,2691,2750,2752,2761,2761,2763,2764,2818,2819,2878,2878,2880,2880,2887,2888,2891,2892,2903,2903,3006,3007,3009,3010,3014,3016,3018,3020,3031,3031,3073,3075,3137,3140,3202,3203,3262,3262,3264,3268,3271,3272,3274,3275,3285,3286,3315,3315,3330,3331,3390,3392,3398,3400,3402,3404,3415,3415,3458,3459,3535,3537,3544,3551,3570,3571,3902,3903,3967,3967,4139,4140,4145,4145,4152,4152,4155,4156,4182,4183,4194,4196,4199,4205,4227,4228,4231,4236,4239,4239,4250,4252,5909,5909,5940,5940,6070,6070,6078,6085,6087,6088,6435,6438,6441,6443,6448,6449,6451,6456,6681,6682,6741,6741,6743,6743,6753,6753,6755,6756,6765,6770,6916,6916,6965,6965,6971,6971,6973,6977,6979,6980,7042,7042,7073,7073,7078,7079,7082,7082,7143,7143,7146,7148,7150,7150,7154,7155,7204,7211,7220,7221,7393,7393,7415,7415,12334,12335,43043,43044,43047,43047,43136,43137,43188,43203,43346,43347,43395,43395,43444,43445,43450,43451,43454,43456,43567,43568,43571,43572,43597,43597,43643,43643,43645,43645,43755,43755,43758,43759,43765,43765,44003,44004,44006,44007,44009,44010,44012,44012,69632,69632,69634,69634,69762,69762,69808,69810,69815,69816,69932,69932,69957,69958,70018,70018,70067,70069,70079,70080,70094,70094,70188,70190,70194,70195,70197,70197,70368,70370,70402,70403,70462,70463,70465,70468,70471,70472,70475,70477,70487,70487,70498,70499,70709,70711,70720,70721,70725,70725,70832,70834,70841,70841,70843,70846,70849,70849,71087,71089,71096,71099,71102,71102,71216,71218,71227,71228,71230,71230,71340,71340,71342,71343,71350,71350,71456,71457,71462,71462,71724,71726,71736,71736,71984,71989,71991,71992,71997,71997,72000,72000,72002,72002,72145,72147,72156,72159,72164,72164,72249,72249,72279,72280,72343,72343,72751,72751,72766,72766,72873,72873,72881,72881,72884,72884,73098,73102,73107,73108,73110,73110,73461,73462,73475,73475,73524,73525,73534,73535,73537,73537,94033,94087,94192,94193,119141,119142,119149,119154 }); }
	static private void addProperty33() { addProperty("nl", new int[] { 5870,5872,8544,8578,8581,8584,12295,12295,12321,12329,12344,12346,42726,42735,65856,65908,66369,66369,66378,66378,66513,66517,74752,74862 }); }
	static private void addProperty34() { addProperty("zl", new int[] { 8232,8232 }); }
	static private void addProperty35() { addProperty("zp", new int[] { 8233,8233 }); }
	static private void addProperty36() { addProperty("cs", new int[] { 55296,57343 }); }
	static private void addProperty37() { addProperty("co", new int[] { 57344,63743,983040,1048573,1048576,1114109 }); }
	static private void addProperty38() { addProperty("alpha", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,837,837,880,884,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1369,1376,1416,1456,1469,1471,1471,1473,1474,1476,1477,1479,1479,1488,1514,1519,1522,1552,1562,1568,1623,1625,1631,1646,1747,1749,1756,1761,1768,1773,1775,1786,1788,1791,1791,1808,1855,1869,1969,1994,2026,2036,2037,2042,2042,2048,2071,2074,2092,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2260,2271,2275,2281,2288,2363,2365,2380,2382,2384,2389,2403,2417,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2500,2503,2504,2507,2508,2510,2510,2519,2519,2524,2525,2527,2531,2544,2545,2556,2556,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2622,2626,2631,2632,2635,2636,2641,2641,2649,2652,2654,2654,2672,2677,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2757,2759,2761,2763,2764,2768,2768,2784,2787,2809,2812,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2884,2887,2888,2891,2892,2902,2903,2908,2909,2911,2915,2929,2929,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3020,3024,3024,3031,3031,3072,3084,3086,3088,3090,3112,3114,3129,3133,3140,3142,3144,3146,3148,3157,3158,3160,3162,3165,3165,3168,3171,3200,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3268,3270,3272,3274,3276,3285,3286,3293,3294,3296,3299,3313,3315,3328,3340,3342,3344,3346,3386,3389,3396,3398,3400,3402,3404,3406,3406,3412,3415,3423,3427,3450,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3535,3540,3542,3542,3544,3551,3570,3571,3585,3642,3648,3654,3661,3661,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3769,3771,3773,3776,3780,3782,3782,3789,3789,3804,3807,3840,3840,3904,3911,3913,3948,3953,3971,3976,3991,3993,4028,4096,4150,4152,4152,4155,4159,4176,4239,4250,4253,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5907,5919,5939,5952,5971,5984,5996,5998,6000,6002,6003,6016,6067,6070,6088,6103,6103,6108,6108,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6456,6480,6509,6512,6516,6528,6571,6576,6601,6656,6683,6688,6750,6753,6772,6823,6823,6847,6848,6860,6862,6912,6963,6965,6979,6981,6988,7040,7081,7084,7087,7098,7141,7143,7153,7168,7222,7245,7247,7258,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7655,7668,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8544,8584,9398,9449,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11775,11823,11823,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42612,42619,42623,42735,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43013,43015,43047,43072,43123,43136,43203,43205,43205,43250,43255,43259,43259,43261,43263,43274,43306,43312,43346,43360,43388,43392,43442,43444,43455,43471,43471,43488,43503,43514,43518,43520,43574,43584,43597,43616,43638,43642,43710,43712,43712,43714,43714,43739,43741,43744,43759,43762,43765,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44010,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66426,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68099,68101,68102,68108,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68903,69248,69289,69291,69292,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69632,69701,69745,69749,69760,69816,69826,69826,69840,69864,69888,69938,69956,69959,69968,70002,70006,70006,70016,70079,70081,70084,70094,70095,70106,70106,70108,70108,70144,70161,70163,70196,70199,70199,70206,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70376,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70468,70471,70472,70475,70476,70480,70480,70487,70487,70493,70499,70656,70721,70723,70725,70727,70730,70751,70753,70784,70849,70852,70853,70855,70855,71040,71093,71096,71102,71128,71133,71168,71230,71232,71232,71236,71236,71296,71349,71352,71352,71424,71450,71453,71466,71488,71494,71680,71736,71840,71903,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,71996,71999,72002,72096,72103,72106,72151,72154,72159,72161,72161,72163,72164,72192,72242,72245,72254,72272,72343,72349,72349,72368,72440,72704,72712,72714,72758,72760,72766,72768,72768,72818,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73025,73027,73027,73030,73031,73056,73061,73063,73064,73066,73102,73104,73105,73107,73110,73112,73112,73440,73462,73472,73488,73490,73530,73534,73536,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93760,93823,93952,94026,94031,94087,94095,94111,94176,94177,94179,94179,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113822,113822,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125255,125255,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127280,127305,127312,127337,127344,127369,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty39() { addProperty("ahex", new int[] { 48,57,65,70,97,102 }); }
	static private void addProperty40() { addProperty("bidi_c", new int[] { 1564,1564,8206,8207,8234,8238,8294,8297 }); }
	static private void addProperty41() { addProperty("bidi_m", new int[] { 40,41,60,60,62,62,91,91,93,93,123,123,125,125,171,171,187,187,3898,3901,5787,5788,8249,8250,8261,8262,8317,8318,8333,8334,8512,8512,8705,8708,8712,8717,8721,8721,8725,8726,8730,8733,8735,8738,8740,8740,8742,8742,8747,8755,8761,8761,8763,8780,8786,8789,8799,8800,8802,8802,8804,8811,8814,8844,8847,8850,8856,8856,8866,8867,8870,8888,8894,8895,8905,8909,8912,8913,8918,8941,8944,8959,8968,8971,8992,8993,9001,9002,10088,10101,10176,10176,10179,10182,10184,10185,10187,10189,10195,10198,10204,10206,10210,10223,10627,10648,10651,10656,10658,10671,10680,10680,10688,10693,10697,10697,10702,10706,10708,10709,10712,10716,10721,10721,10723,10725,10728,10729,10740,10745,10748,10749,10762,10780,10782,10785,10788,10788,10790,10790,10793,10793,10795,10798,10804,10805,10812,10814,10839,10840,10852,10853,10858,10861,10863,10864,10867,10868,10873,10915,10918,10925,10927,10966,10972,10972,10974,10974,10978,10982,10988,10990,10995,10995,10999,11003,11005,11005,11262,11262,11778,11781,11785,11786,11788,11789,11804,11805,11808,11817,11861,11868,12296,12305,12308,12315,65113,65118,65124,65125,65288,65289,65308,65308,65310,65310,65339,65339,65341,65341,65371,65371,65373,65373,65375,65376,65378,65379,120539,120539,120597,120597,120655,120655,120713,120713,120771,120771 }); }
	static private void addProperty42() { addProperty("dash", new int[] { 45,45,1418,1418,1470,1470,5120,5120,6150,6150,8208,8213,8275,8275,8315,8315,8331,8331,8722,8722,11799,11799,11802,11802,11834,11835,11840,11840,11869,11869,12316,12316,12336,12336,12448,12448,65073,65074,65112,65112,65123,65123,65293,65293,69293,69293 }); }
	static private void addProperty43() { addProperty("di", new int[] { 173,173,847,847,1564,1564,4447,4448,6068,6069,6155,6159,8203,8207,8234,8238,8288,8303,12644,12644,65024,65039,65279,65279,65440,65440,65520,65528,113824,113827,119155,119162,917504,921599 }); }
	static private void addProperty44() { addProperty("dep", new int[] { 329,329,1651,1651,3959,3959,3961,3961,6051,6052,8298,8303,9001,9002,917505,917505 }); }
	static private void addProperty45() { addProperty("dia", new int[] { 94,94,96,96,168,168,175,175,180,180,183,184,688,846,848,855,861,866,884,885,890,890,900,901,1155,1159,1369,1369,1425,1441,1443,1469,1471,1471,1473,1474,1476,1476,1611,1618,1623,1624,1759,1760,1765,1766,1770,1772,1840,1866,1958,1968,2027,2037,2072,2073,2200,2207,2249,2258,2275,2302,2364,2364,2381,2381,2385,2388,2417,2417,2492,2492,2509,2509,2620,2620,2637,2637,2748,2748,2765,2765,2813,2815,2876,2876,2893,2893,2901,2901,3021,3021,3132,3132,3149,3149,3260,3260,3277,3277,3387,3388,3405,3405,3530,3530,3655,3660,3662,3662,3770,3770,3784,3788,3864,3865,3893,3893,3895,3895,3897,3897,3902,3903,3970,3972,3974,3975,4038,4038,4151,4151,4153,4154,4195,4196,4201,4205,4231,4237,4239,4239,4250,4251,4957,4959,5908,5909,6089,6099,6109,6109,6457,6459,6773,6780,6783,6783,6832,6846,6849,6859,6964,6964,6980,6980,7019,7027,7082,7083,7222,7223,7288,7293,7376,7400,7405,7405,7412,7412,7415,7417,7468,7530,7620,7631,7669,7679,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,11503,11505,11823,11823,12330,12335,12441,12444,12540,12540,42607,42607,42620,42621,42623,42623,42652,42653,42736,42737,42752,42785,42888,42890,43000,43001,43204,43204,43232,43249,43307,43310,43347,43347,43443,43443,43456,43456,43493,43493,43643,43645,43711,43714,43766,43766,43867,43871,43881,43883,44012,44013,64286,64286,65056,65071,65342,65342,65344,65344,65392,65392,65438,65439,65507,65507,66272,66272,67456,67461,67463,67504,67506,67514,68325,68326,68898,68903,69373,69375,69446,69456,69506,69509,69702,69702,69744,69744,69817,69818,69939,69940,70003,70003,70080,70080,70090,70092,70197,70198,70377,70378,70460,70460,70477,70477,70502,70508,70512,70516,70722,70722,70726,70726,70850,70851,71103,71104,71231,71231,71350,71351,71467,71467,71737,71738,71997,71998,72003,72003,72160,72160,72244,72244,72263,72263,72345,72345,72767,72767,73026,73026,73028,73029,73111,73111,78919,78933,92912,92916,92976,92982,94095,94111,94192,94193,110576,110579,110581,110587,110589,110590,118528,118573,118576,118598,119143,119145,119149,119154,119163,119170,119173,119179,119210,119213,122928,122989,123184,123190,123566,123566,123628,123631,125136,125142,125252,125254,125256,125258 }); }
	static private void addProperty46() { addProperty("ext", new int[] { 183,183,720,721,1600,1600,2042,2042,2901,2901,3654,3654,3782,3782,6154,6154,6211,6211,6823,6823,7222,7222,7291,7291,12293,12293,12337,12341,12445,12446,12540,12542,40981,40981,42508,42508,43471,43471,43494,43494,43632,43632,43741,43741,43763,43764,65392,65392,67457,67458,70493,70493,71110,71112,72344,72344,92994,92995,94176,94177,94179,94179,123196,123197,125252,125254 }); }
	static private void addProperty47() { addProperty("comp_ex", new int[] { 832,833,835,836,884,884,894,894,903,903,2392,2399,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2908,2909,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3958,3960,3960,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,8049,8049,8051,8051,8053,8053,8055,8055,8057,8057,8059,8059,8061,8061,8123,8123,8126,8126,8137,8137,8139,8139,8147,8147,8155,8155,8163,8163,8171,8171,8174,8175,8185,8185,8187,8187,8189,8189,8192,8193,8486,8486,8490,8491,9001,9002,10972,10972,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64285,64285,64287,64287,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64334,119134,119140,119227,119232,194560,195101 }); }
	static private void addProperty48() { addProperty("gr_base", new int[] { 32,126,160,172,174,767,880,887,890,895,900,906,908,908,910,929,931,1154,1162,1327,1329,1366,1369,1418,1421,1423,1470,1470,1472,1472,1475,1475,1478,1478,1488,1514,1519,1524,1542,1551,1563,1563,1565,1610,1632,1647,1649,1749,1758,1758,1765,1766,1769,1769,1774,1805,1808,1808,1810,1839,1869,1957,1969,1969,1984,2026,2036,2042,2046,2069,2074,2074,2084,2084,2088,2088,2096,2110,2112,2136,2142,2142,2144,2154,2160,2190,2208,2249,2307,2361,2363,2363,2365,2368,2377,2380,2382,2384,2392,2401,2404,2432,2434,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2495,2496,2503,2504,2507,2508,2510,2510,2524,2525,2527,2529,2534,2557,2563,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2622,2624,2649,2652,2654,2654,2662,2671,2674,2676,2678,2678,2691,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2752,2761,2761,2763,2764,2768,2768,2784,2785,2790,2801,2809,2809,2818,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2880,2880,2887,2888,2891,2892,2908,2909,2911,2913,2918,2935,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3007,3007,3009,3010,3014,3016,3018,3020,3024,3024,3046,3066,3073,3075,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3137,3140,3160,3162,3165,3165,3168,3169,3174,3183,3191,3200,3202,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3262,3264,3265,3267,3268,3271,3272,3274,3275,3293,3294,3296,3297,3302,3311,3313,3315,3330,3340,3342,3344,3346,3386,3389,3389,3391,3392,3398,3400,3402,3404,3406,3407,3412,3414,3416,3425,3430,3455,3458,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3536,3537,3544,3550,3558,3567,3570,3572,3585,3632,3634,3635,3647,3654,3663,3675,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3782,3782,3792,3801,3804,3807,3840,3863,3866,3892,3894,3894,3896,3896,3898,3911,3913,3948,3967,3967,3973,3973,3976,3980,4030,4037,4039,4044,4046,4058,4096,4140,4145,4145,4152,4152,4155,4156,4159,4183,4186,4189,4193,4208,4213,4225,4227,4228,4231,4236,4238,4252,4254,4293,4295,4295,4301,4301,4304,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4960,4988,4992,5017,5024,5109,5112,5117,5120,5788,5792,5880,5888,5905,5909,5909,5919,5937,5940,5942,5952,5969,5984,5996,5998,6000,6016,6067,6070,6070,6078,6085,6087,6088,6100,6108,6112,6121,6128,6137,6144,6154,6160,6169,6176,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6435,6438,6441,6443,6448,6449,6451,6456,6464,6464,6468,6509,6512,6516,6528,6571,6576,6601,6608,6618,6622,6678,6681,6682,6686,6741,6743,6743,6753,6753,6755,6756,6765,6770,6784,6793,6800,6809,6816,6829,6916,6963,6971,6971,6973,6977,6979,6988,6992,7018,7028,7038,7042,7073,7078,7079,7082,7082,7086,7141,7143,7143,7146,7148,7150,7150,7154,7155,7164,7211,7220,7221,7227,7241,7245,7304,7312,7354,7357,7367,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8190,8192,8202,8208,8231,8239,8287,8304,8305,8308,8334,8336,8348,8352,8384,8448,8587,8592,9254,9280,9290,9312,11123,11126,11157,11159,11502,11506,11507,11513,11557,11559,11559,11565,11565,11568,11623,11631,11632,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11776,11869,11904,11929,11931,12019,12032,12245,12272,12283,12288,12329,12336,12351,12353,12438,12443,12543,12549,12591,12593,12686,12688,12771,12784,12830,12832,42124,42128,42182,42192,42539,42560,42606,42611,42611,42622,42653,42656,42735,42738,42743,42752,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43044,43047,43051,43056,43065,43072,43127,43136,43203,43214,43225,43250,43262,43264,43301,43310,43334,43346,43347,43359,43388,43395,43442,43444,43445,43450,43451,43454,43469,43471,43481,43486,43492,43494,43518,43520,43560,43567,43568,43571,43572,43584,43586,43588,43595,43597,43597,43600,43609,43612,43643,43645,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43755,43758,43765,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43883,43888,44004,44006,44007,44009,44012,44016,44025,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64450,64467,64911,64914,64967,64975,64975,65008,65023,65040,65049,65072,65106,65108,65126,65128,65131,65136,65140,65142,65276,65281,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,65532,65533,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65792,65794,65799,65843,65847,65934,65936,65948,65952,65952,66000,66044,66176,66204,66208,66256,66273,66299,66304,66339,66349,66378,66384,66421,66432,66461,66463,66499,66504,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66927,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67671,67742,67751,67759,67808,67826,67828,67829,67835,67867,67871,67897,67903,67903,67968,68023,68028,68047,68050,68096,68112,68115,68117,68119,68121,68149,68160,68168,68176,68184,68192,68255,68288,68324,68331,68342,68352,68405,68409,68437,68440,68466,68472,68497,68505,68508,68521,68527,68608,68680,68736,68786,68800,68850,68858,68899,68912,68921,69216,69246,69248,69289,69293,69293,69296,69297,69376,69415,69424,69445,69457,69465,69488,69505,69510,69513,69552,69579,69600,69622,69632,69632,69634,69687,69703,69709,69714,69743,69745,69746,69749,69749,69762,69810,69815,69816,69819,69820,69822,69825,69840,69864,69872,69881,69891,69926,69932,69932,69942,69959,69968,70002,70004,70006,70018,70069,70079,70088,70093,70094,70096,70111,70113,70132,70144,70161,70163,70190,70194,70195,70197,70197,70200,70205,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70313,70320,70366,70368,70370,70384,70393,70402,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70463,70463,70465,70468,70471,70472,70475,70477,70480,70480,70493,70499,70656,70711,70720,70721,70725,70725,70727,70747,70749,70749,70751,70753,70784,70831,70833,70834,70841,70841,70843,70844,70846,70846,70849,70849,70852,70855,70864,70873,71040,71086,71088,71089,71096,71099,71102,71102,71105,71131,71168,71218,71227,71228,71230,71230,71233,71236,71248,71257,71264,71276,71296,71338,71340,71340,71342,71343,71350,71350,71352,71353,71360,71369,71424,71450,71456,71457,71462,71462,71472,71494,71680,71726,71736,71736,71739,71739,71840,71922,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71985,71989,71991,71992,71997,71997,71999,72002,72004,72006,72016,72025,72096,72103,72106,72147,72156,72159,72161,72164,72192,72192,72203,72242,72249,72250,72255,72262,72272,72272,72279,72280,72284,72329,72343,72343,72346,72354,72368,72440,72448,72457,72704,72712,72714,72751,72766,72766,72768,72773,72784,72812,72816,72847,72873,72873,72881,72881,72884,72884,72960,72966,72968,72969,72971,73008,73030,73030,73040,73049,73056,73061,73063,73064,73066,73102,73107,73108,73110,73110,73112,73112,73120,73129,73440,73458,73461,73464,73474,73488,73490,73525,73534,73535,73537,73537,73539,73561,73648,73648,73664,73713,73727,74649,74752,74862,74864,74868,74880,75075,77712,77810,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92768,92777,92782,92862,92864,92873,92880,92909,92917,92917,92928,92975,92983,92997,93008,93017,93019,93025,93027,93047,93053,93071,93760,93850,93952,94026,94032,94087,94099,94111,94176,94179,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113820,113820,113823,113823,118608,118723,118784,119029,119040,119078,119081,119140,119142,119142,119146,119149,119171,119172,119180,119209,119214,119274,119296,119361,119365,119365,119488,119507,119520,119539,119552,119638,119648,119672,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,121343,121399,121402,121453,121460,121462,121475,121477,121483,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123200,123209,123214,123215,123536,123565,123584,123627,123632,123641,123647,123647,124112,124139,124144,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125127,125135,125184,125251,125259,125259,125264,125273,125278,125279,126065,126132,126209,126269,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127232,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty49() { addProperty("gr_ext", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2494,2494,2497,2500,2509,2509,2519,2519,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2878,2879,2881,2884,2893,2893,2901,2903,2914,2915,2946,2946,3006,3006,3008,3008,3021,3021,3031,3031,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3266,3266,3270,3270,3276,3277,3285,3286,3298,3299,3328,3329,3387,3388,3390,3390,3393,3396,3405,3405,3415,3415,3426,3427,3457,3457,3530,3530,3535,3535,3538,3540,3542,3542,3551,3551,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6862,6912,6915,6964,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8204,8204,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,65438,65439,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70462,70462,70464,70464,70487,70487,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70832,70832,70835,70840,70842,70842,70845,70845,70847,70848,70850,70851,71087,71087,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71984,71984,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,118528,118573,118576,118598,119141,119141,119143,119145,119150,119154,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917536,917631,917760,917999 }); }
	static private void addProperty50() { addProperty("gr_link", new int[] { 2381,2381,2509,2509,2637,2637,2765,2765,2893,2893,3021,3021,3149,3149,3277,3277,3387,3388,3405,3405,3530,3530,3642,3642,3770,3770,3972,3972,4153,4154,5908,5909,5940,5940,6098,6098,6752,6752,6980,6980,7082,7083,7154,7155,11647,11647,43014,43014,43052,43052,43204,43204,43347,43347,43456,43456,43766,43766,44013,44013,68159,68159,69702,69702,69744,69744,69759,69759,69817,69817,69939,69940,70080,70080,70197,70197,70378,70378,70477,70477,70722,70722,70850,70850,71103,71103,71231,71231,71350,71350,71467,71467,71737,71737,71997,71998,72160,72160,72244,72244,72263,72263,72345,72345,72767,72767,73028,73029,73111,73111,73537,73538 }); }
	static private void addProperty51() { addProperty("hex", new int[] { 48,57,65,70,97,102,65296,65305,65313,65318,65345,65350 }); }
	static private void addProperty52() { addProperty("hyphen", new int[] { 45,45,173,173,1418,1418,6150,6150,8208,8209,11799,11799,12539,12539,65123,65123,65293,65293,65381,65381 }); }
	static private void addProperty53() { addProperty("idc", new int[] { 48,57,65,90,95,95,97,122,170,170,181,181,183,183,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,768,884,886,887,890,893,895,895,902,906,908,908,910,929,931,1013,1015,1153,1155,1159,1162,1327,1329,1366,1369,1369,1376,1416,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1488,1514,1519,1522,1552,1562,1568,1641,1646,1747,1749,1756,1759,1768,1770,1788,1791,1791,1808,1866,1869,1969,1984,2037,2042,2042,2045,2045,2048,2093,2112,2139,2144,2154,2160,2183,2185,2190,2200,2273,2275,2403,2406,2415,2417,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2545,2556,2556,2558,2558,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2677,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2799,2809,2815,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2901,2903,2908,2909,2911,2915,2918,2927,2929,2929,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3055,3072,3084,3086,3088,3090,3112,3114,3129,3132,3140,3142,3144,3146,3149,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3200,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315,3328,3340,3342,3344,3346,3396,3398,3400,3402,3406,3412,3415,3423,3427,3430,3439,3450,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3558,3567,3570,3571,3585,3642,3648,3662,3664,3673,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3792,3801,3804,3807,3840,3840,3864,3865,3872,3881,3893,3893,3895,3895,3897,3897,3902,3911,3913,3948,3953,3972,3974,3991,3993,4028,4038,4038,4096,4169,4176,4253,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4959,4969,4977,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5909,5919,5940,5952,5971,5984,5996,5998,6000,6002,6003,6016,6099,6103,6103,6108,6109,6112,6121,6155,6157,6159,6169,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6459,6470,6509,6512,6516,6528,6571,6576,6601,6608,6618,6656,6683,6688,6750,6752,6780,6783,6793,6800,6809,6823,6823,6832,6845,6847,6862,6912,6988,6992,7001,7019,7027,7040,7155,7168,7223,7232,7241,7245,7293,7296,7304,7312,7354,7357,7359,7376,7378,7380,7418,7424,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8255,8256,8276,8276,8305,8305,8319,8319,8336,8348,8400,8412,8417,8417,8421,8432,8450,8450,8455,8455,8458,8467,8469,8469,8472,8477,8484,8484,8486,8486,8488,8488,8490,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11492,11499,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11647,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11775,12293,12295,12321,12335,12337,12341,12344,12348,12353,12438,12441,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42539,42560,42607,42612,42621,42623,42737,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43047,43052,43052,43072,43123,43136,43205,43216,43225,43232,43255,43259,43259,43261,43309,43312,43347,43360,43388,43392,43456,43471,43481,43488,43518,43520,43574,43584,43597,43600,43609,43616,43638,43642,43714,43739,43741,43744,43759,43762,43766,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44010,44012,44013,44016,44025,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65024,65039,65056,65071,65075,65076,65101,65103,65136,65140,65142,65276,65296,65305,65313,65338,65343,65343,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66045,66045,66176,66204,66208,66256,66272,66272,66304,66335,66349,66378,66384,66426,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68099,68101,68102,68108,68115,68117,68119,68121,68149,68152,68154,68159,68159,68192,68220,68224,68252,68288,68295,68297,68326,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68903,68912,68921,69248,69289,69291,69292,69296,69297,69373,69404,69415,69415,69424,69456,69488,69509,69552,69572,69600,69622,69632,69702,69734,69749,69759,69818,69826,69826,69840,69864,69872,69881,69888,69940,69942,69951,69956,69959,69968,70003,70006,70006,70016,70084,70089,70092,70094,70106,70108,70108,70144,70161,70163,70199,70206,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70378,70384,70393,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70459,70468,70471,70472,70475,70477,70480,70480,70487,70487,70493,70499,70502,70508,70512,70516,70656,70730,70736,70745,70750,70753,70784,70853,70855,70855,70864,70873,71040,71093,71096,71104,71128,71133,71168,71232,71236,71236,71248,71257,71296,71352,71360,71369,71424,71450,71453,71467,71472,71481,71488,71494,71680,71738,71840,71913,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,72003,72016,72025,72096,72103,72106,72151,72154,72161,72163,72164,72192,72254,72263,72263,72272,72345,72349,72349,72368,72440,72704,72712,72714,72758,72760,72768,72784,72793,72818,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73031,73040,73049,73056,73061,73063,73064,73066,73102,73104,73105,73107,73112,73120,73129,73440,73462,73472,73488,73490,73530,73534,73538,73552,73561,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78912,78933,82944,83526,92160,92728,92736,92766,92768,92777,92784,92862,92864,92873,92880,92909,92912,92916,92928,92982,92992,92995,93008,93017,93027,93047,93053,93071,93760,93823,93952,94026,94031,94087,94095,94111,94176,94177,94179,94180,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113821,113822,118528,118573,118576,118598,119141,119145,119149,119154,119163,119170,119173,119179,119210,119213,119362,119364,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,120782,120831,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123184,123197,123200,123209,123214,123214,123536,123566,123584,123641,124112,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125136,125142,125184,125259,125264,125273,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743,917760,917999 }); }
	static private void addProperty54() { addProperty("ids", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,880,884,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1369,1376,1416,1488,1514,1519,1522,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2417,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3654,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3782,3782,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6103,6103,6108,6108,6176,6264,6272,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6823,6823,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8472,8477,8484,8484,8486,8486,8488,8488,8490,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12443,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42623,42653,42656,42735,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43488,43492,43494,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43741,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66421,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71840,71903,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93760,93823,93952,94026,94032,94032,94099,94111,94176,94177,94179,94179,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty55() { addProperty("ideo", new int[] { 12294,12295,12321,12329,12344,12346,13312,19903,19968,40959,63744,64109,64112,64217,94180,94180,94208,100343,100352,101589,101632,101640,110960,111355,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty56() { addProperty("idsb", new int[] { 12272,12273,12276,12283 }); }
	static private void addProperty57() { addProperty("idst", new int[] { 12274,12275 }); }
	static private void addProperty58() { addProperty("join_c", new int[] { 8204,8205 }); }
	static private void addProperty59() { addProperty("loe", new int[] { 3648,3652,3776,3780,6581,6583,6586,6586,43701,43702,43705,43705,43707,43708 }); }
	static private void addProperty60() { addProperty("lower", new int[] { 97,122,170,170,181,181,186,186,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,312,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,397,402,402,405,405,409,411,414,414,417,417,419,419,421,421,424,424,426,427,429,429,432,432,436,436,438,438,441,442,445,447,454,454,457,457,460,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,496,499,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,545,545,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,569,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,659,661,696,704,705,736,740,837,837,881,881,883,883,887,887,890,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1020,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1376,1416,4304,4346,4348,4351,5112,5117,7296,7304,7424,7615,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7837,7839,7839,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8071,8080,8087,8096,8103,8112,8116,8118,8119,8126,8126,8130,8132,8134,8135,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8305,8305,8319,8319,8336,8348,8458,8458,8462,8463,8467,8467,8495,8495,8500,8500,8505,8505,8508,8509,8518,8521,8526,8526,8560,8575,8580,8580,9424,9449,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11377,11377,11379,11380,11382,11389,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11492,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42653,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42801,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42872,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42894,42894,42897,42897,42899,42901,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42927,42927,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42963,42963,42965,42965,42967,42967,42969,42969,42994,42996,42998,42998,43000,43002,43824,43866,43868,43881,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,67456,67456,67459,67461,67463,67504,67506,67514,68800,68850,71872,71903,93792,93823,119834,119859,119886,119892,119894,119911,119938,119963,119990,119993,119995,119995,119997,120003,120005,120015,120042,120067,120094,120119,120146,120171,120198,120223,120250,120275,120302,120327,120354,120379,120406,120431,120458,120485,120514,120538,120540,120545,120572,120596,120598,120603,120630,120654,120656,120661,120688,120712,120714,120719,120746,120770,120772,120777,120779,120779,122624,122633,122635,122654,122661,122666,122928,122989,125218,125251 }); }
	static private void addProperty61() { addProperty("math", new int[] { 43,43,60,62,94,94,124,124,126,126,172,172,177,177,215,215,247,247,976,978,981,981,1008,1009,1012,1014,1542,1544,8214,8214,8242,8244,8256,8256,8260,8260,8274,8274,8289,8292,8314,8318,8330,8334,8400,8412,8417,8417,8421,8422,8427,8431,8450,8450,8455,8455,8458,8467,8469,8469,8472,8477,8484,8484,8488,8489,8492,8493,8495,8497,8499,8504,8508,8521,8523,8523,8592,8615,8617,8622,8624,8625,8630,8631,8636,8667,8669,8669,8676,8677,8692,8959,8968,8971,8992,8993,9084,9084,9115,9141,9143,9143,9168,9168,9180,9186,9632,9633,9646,9655,9660,9665,9670,9671,9674,9675,9679,9683,9698,9698,9700,9700,9703,9708,9720,9727,9733,9734,9792,9792,9794,9794,9824,9827,9837,9839,10176,10239,10496,11007,11056,11076,11079,11084,64297,64297,65121,65126,65128,65128,65291,65291,65308,65310,65340,65340,65342,65342,65372,65372,65374,65374,65506,65506,65513,65516,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705 }); }
	static private void addProperty62() { addProperty("nchar", new int[] { 64976,65007,65534,65535,131070,131071,196606,196607,262142,262143,327678,327679,393214,393215,458750,458751,524286,524287,589822,589823,655358,655359,720894,720895,786430,786431,851966,851967,917502,917503,983038,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty63() { addProperty("qmark", new int[] { 34,34,39,39,171,171,187,187,8216,8223,8249,8250,11842,11842,12300,12303,12317,12319,65089,65092,65282,65282,65287,65287,65378,65379 }); }
	static private void addProperty64() { addProperty("radical", new int[] { 11904,11929,11931,12019,12032,12245 }); }
	static private void addProperty65() { addProperty("sd", new int[] { 105,106,303,303,585,585,616,616,669,669,690,690,1011,1011,1110,1110,1112,1112,7522,7522,7574,7574,7588,7588,7592,7592,7725,7725,7883,7883,8305,8305,8520,8521,11388,11388,119842,119843,119894,119895,119946,119947,119998,119999,120050,120051,120102,120103,120154,120155,120206,120207,120258,120259,120310,120311,120362,120363,120414,120415,120466,120467,122650,122650,122956,122957,122984,122984 }); }
	static private void addProperty66() { addProperty("term", new int[] { 33,33,44,44,46,46,58,59,63,63,894,894,903,903,1417,1417,1475,1475,1548,1548,1563,1563,1565,1567,1748,1748,1792,1802,1804,1804,2040,2041,2096,2110,2142,2142,2404,2405,3674,3675,3848,3848,3853,3858,4170,4171,4961,4968,5742,5742,5867,5869,5941,5942,6100,6102,6106,6106,6146,6149,6152,6153,6468,6469,6824,6827,7002,7003,7005,7007,7037,7038,7227,7231,7294,7295,8252,8253,8263,8265,11822,11822,11836,11836,11841,11841,11852,11852,11854,11855,11859,11860,12289,12290,42238,42239,42509,42511,42739,42743,43126,43127,43214,43215,43311,43311,43463,43465,43613,43615,43743,43743,43760,43761,44011,44011,65104,65106,65108,65111,65281,65281,65292,65292,65294,65294,65306,65307,65311,65311,65377,65377,65380,65380,66463,66463,66512,66512,67671,67671,67871,67871,68182,68183,68336,68341,68410,68415,68505,68508,69461,69465,69510,69513,69703,69709,69822,69825,69953,69955,70085,70086,70093,70093,70110,70111,70200,70204,70313,70313,70731,70733,70746,70747,71106,71109,71113,71127,71233,71234,71484,71486,72004,72004,72006,72006,72258,72259,72347,72348,72353,72354,72769,72771,72817,72817,73463,73464,73539,73540,74864,74868,92782,92783,92917,92917,92983,92985,92996,92996,93847,93848,113823,113823,121479,121482 }); }
	static private void addProperty67() { addProperty("uideo", new int[] { 13312,19903,19968,40959,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,196608,201546,201552,205743 }); }
	static private void addProperty68() { addProperty("upper", new int[] { 65,90,192,214,216,222,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,330,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,452,455,455,458,458,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,497,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,975,975,978,980,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1012,1012,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,4256,4293,4295,4295,4301,4301,5024,5109,7312,7354,7357,7359,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8120,8123,8136,8139,8152,8155,8168,8172,8184,8187,8450,8450,8455,8455,8459,8461,8464,8466,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8496,8499,8510,8511,8517,8517,8544,8559,8579,8579,9398,9423,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,119808,119833,119860,119885,119912,119937,119964,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119989,120016,120041,120068,120069,120071,120074,120077,120084,120086,120092,120120,120121,120123,120126,120128,120132,120134,120134,120138,120144,120172,120197,120224,120249,120276,120301,120328,120353,120380,120405,120432,120457,120488,120512,120546,120570,120604,120628,120662,120686,120720,120744,120778,120778,125184,125217,127280,127305,127312,127337,127344,127369 }); }
	static private void addProperty69() { addProperty("wspace", new int[] { 9,13,32,32,133,133,160,160,5760,5760,8192,8202,8232,8233,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty70() { addProperty("xidc", new int[] { 48,57,65,90,95,95,97,122,170,170,181,181,183,183,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,768,884,886,887,891,893,895,895,902,906,908,908,910,929,931,1013,1015,1153,1155,1159,1162,1327,1329,1366,1369,1369,1376,1416,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1488,1514,1519,1522,1552,1562,1568,1641,1646,1747,1749,1756,1759,1768,1770,1788,1791,1791,1808,1866,1869,1969,1984,2037,2042,2042,2045,2045,2048,2093,2112,2139,2144,2154,2160,2183,2185,2190,2200,2273,2275,2403,2406,2415,2417,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2545,2556,2556,2558,2558,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2677,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2799,2809,2815,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2901,2903,2908,2909,2911,2915,2918,2927,2929,2929,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3055,3072,3084,3086,3088,3090,3112,3114,3129,3132,3140,3142,3144,3146,3149,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3200,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315,3328,3340,3342,3344,3346,3396,3398,3400,3402,3406,3412,3415,3423,3427,3430,3439,3450,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3558,3567,3570,3571,3585,3642,3648,3662,3664,3673,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3792,3801,3804,3807,3840,3840,3864,3865,3872,3881,3893,3893,3895,3895,3897,3897,3902,3911,3913,3948,3953,3972,3974,3991,3993,4028,4038,4038,4096,4169,4176,4253,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4959,4969,4977,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5909,5919,5940,5952,5971,5984,5996,5998,6000,6002,6003,6016,6099,6103,6103,6108,6109,6112,6121,6155,6157,6159,6169,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6459,6470,6509,6512,6516,6528,6571,6576,6601,6608,6618,6656,6683,6688,6750,6752,6780,6783,6793,6800,6809,6823,6823,6832,6845,6847,6862,6912,6988,6992,7001,7019,7027,7040,7155,7168,7223,7232,7241,7245,7293,7296,7304,7312,7354,7357,7359,7376,7378,7380,7418,7424,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8255,8256,8276,8276,8305,8305,8319,8319,8336,8348,8400,8412,8417,8417,8421,8432,8450,8450,8455,8455,8458,8467,8469,8469,8472,8477,8484,8484,8486,8486,8488,8488,8490,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11492,11499,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11647,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11775,12293,12295,12321,12335,12337,12341,12344,12348,12353,12438,12441,12442,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42539,42560,42607,42612,42621,42623,42737,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43047,43052,43052,43072,43123,43136,43205,43216,43225,43232,43255,43259,43259,43261,43309,43312,43347,43360,43388,43392,43456,43471,43481,43488,43518,43520,43574,43584,43597,43600,43609,43616,43638,43642,43714,43739,43741,43744,43759,43762,43766,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44010,44012,44013,44016,44025,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64605,64612,64829,64848,64911,64914,64967,65008,65017,65024,65039,65056,65071,65075,65076,65101,65103,65137,65137,65139,65139,65143,65143,65145,65145,65147,65147,65149,65149,65151,65276,65296,65305,65313,65338,65343,65343,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66045,66045,66176,66204,66208,66256,66272,66272,66304,66335,66349,66378,66384,66426,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68099,68101,68102,68108,68115,68117,68119,68121,68149,68152,68154,68159,68159,68192,68220,68224,68252,68288,68295,68297,68326,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68903,68912,68921,69248,69289,69291,69292,69296,69297,69373,69404,69415,69415,69424,69456,69488,69509,69552,69572,69600,69622,69632,69702,69734,69749,69759,69818,69826,69826,69840,69864,69872,69881,69888,69940,69942,69951,69956,69959,69968,70003,70006,70006,70016,70084,70089,70092,70094,70106,70108,70108,70144,70161,70163,70199,70206,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70378,70384,70393,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70459,70468,70471,70472,70475,70477,70480,70480,70487,70487,70493,70499,70502,70508,70512,70516,70656,70730,70736,70745,70750,70753,70784,70853,70855,70855,70864,70873,71040,71093,71096,71104,71128,71133,71168,71232,71236,71236,71248,71257,71296,71352,71360,71369,71424,71450,71453,71467,71472,71481,71488,71494,71680,71738,71840,71913,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,72003,72016,72025,72096,72103,72106,72151,72154,72161,72163,72164,72192,72254,72263,72263,72272,72345,72349,72349,72368,72440,72704,72712,72714,72758,72760,72768,72784,72793,72818,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73031,73040,73049,73056,73061,73063,73064,73066,73102,73104,73105,73107,73112,73120,73129,73440,73462,73472,73488,73490,73530,73534,73538,73552,73561,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78912,78933,82944,83526,92160,92728,92736,92766,92768,92777,92784,92862,92864,92873,92880,92909,92912,92916,92928,92982,92992,92995,93008,93017,93027,93047,93053,93071,93760,93823,93952,94026,94031,94087,94095,94111,94176,94177,94179,94180,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113821,113822,118528,118573,118576,118598,119141,119145,119149,119154,119163,119170,119173,119179,119210,119213,119362,119364,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,120782,120831,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123184,123197,123200,123209,123214,123214,123536,123566,123584,123641,124112,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125136,125142,125184,125259,125264,125273,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743,917760,917999 }); }
	static private void addProperty71() { addProperty("xids", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,880,884,886,887,891,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1369,1376,1416,1488,1514,1519,1522,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2417,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3634,3648,3654,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3762,3773,3773,3776,3780,3782,3782,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6103,6103,6108,6108,6176,6264,6272,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6823,6823,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8472,8477,8484,8484,8486,8486,8488,8488,8490,8505,8508,8511,8517,8521,8526,8526,8544,8584,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42623,42653,42656,42735,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43488,43492,43494,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43741,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64605,64612,64829,64848,64911,64914,64967,65008,65017,65137,65137,65139,65139,65143,65143,65145,65145,65147,65147,65149,65149,65151,65276,65313,65338,65345,65370,65382,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66421,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71840,71903,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93760,93823,93952,94026,94032,94032,94099,94111,94176,94177,94179,94179,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty72() { addProperty("sensitive", new int[] { 65,90,97,122,181,181,192,214,216,246,248,311,313,396,398,410,412,425,428,441,444,445,447,447,452,544,546,563,570,596,598,599,601,601,603,604,608,609,611,611,613,614,616,620,623,623,625,626,629,629,637,637,640,640,642,643,647,652,658,658,669,670,700,700,702,702,768,769,775,776,778,778,780,780,787,787,817,817,834,834,837,837,880,883,886,887,891,893,895,895,902,902,904,906,908,908,910,929,931,977,981,1013,1015,1019,1021,1153,1162,1327,1329,1366,1377,1415,4256,4293,4295,4295,4301,4301,4304,4346,4349,4351,5024,5109,5112,5117,7296,7304,7312,7354,7357,7359,7545,7545,7549,7549,7566,7566,7680,7835,7838,7838,7840,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8486,8486,8490,8491,8498,8498,8526,8526,8544,8575,8579,8580,9398,9449,11264,11376,11378,11379,11381,11382,11390,11491,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,42560,42605,42624,42651,42786,42799,42802,42863,42873,42887,42891,42893,42896,42900,42902,42926,42928,42954,42960,42961,42966,42969,42997,42998,43859,43859,43888,43967,64256,64262,64275,64279,65313,65338,65345,65370,66560,66639,66736,66771,66776,66811,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,68736,68786,68800,68850,71840,71903,93760,93823,125184,125251 }); }
	static private void addProperty73() { addProperty("sterm", new int[] { 33,33,46,46,63,63,1417,1417,1565,1567,1748,1748,1792,1794,2041,2041,2103,2103,2105,2105,2109,2110,2404,2405,4170,4171,4962,4962,4967,4968,5742,5742,5941,5942,6147,6147,6153,6153,6468,6469,6824,6827,7002,7003,7006,7007,7037,7038,7227,7228,7294,7295,8252,8253,8263,8265,11822,11822,11836,11836,11859,11860,12290,12290,42239,42239,42510,42511,42739,42739,42743,42743,43126,43127,43214,43215,43311,43311,43464,43465,43613,43615,43760,43761,44011,44011,65106,65106,65110,65111,65281,65281,65294,65294,65311,65311,65377,65377,68182,68183,69461,69465,69510,69513,69703,69704,69822,69825,69953,69955,70085,70086,70093,70093,70110,70111,70200,70201,70203,70204,70313,70313,70731,70732,71106,71107,71113,71127,71233,71234,71484,71486,72004,72004,72006,72006,72258,72259,72347,72348,72769,72770,73463,73464,73539,73540,92782,92783,92917,92917,92983,92984,92996,92996,93848,93848,113823,113823,121480,121480 }); }
	static private void addProperty74() { addProperty("vs", new int[] { 6155,6157,6159,6159,65024,65039,917760,917999 }); }
	static private void addProperty75() { addProperty("nfdinert", new int[] { 0,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,307,312,312,319,322,329,331,338,339,358,359,383,415,418,430,433,460,477,477,484,485,497,499,502,503,540,541,544,549,564,767,847,847,880,883,885,893,895,900,907,907,909,909,913,937,945,969,975,978,981,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1154,1160,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1569,1575,1610,1632,1647,1649,1727,1729,1729,1731,1746,1748,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2344,2346,2352,2354,2355,2357,2363,2365,2380,2382,2384,2389,2391,2400,2491,2493,2506,2510,2523,2526,2526,2528,2557,2559,2610,2612,2613,2615,2619,2621,2636,2638,2648,2652,2653,2655,2747,2749,2764,2766,2875,2877,2887,2889,2890,2894,2907,2910,2963,2965,3017,3022,3131,3133,3143,3145,3148,3150,3156,3159,3259,3261,3263,3265,3270,3273,3273,3276,3276,3278,3386,3389,3401,3406,3529,3531,3545,3547,3547,3551,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3952,3959,3959,3961,3961,3966,3967,3973,3973,3976,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4037,4039,4133,4135,4150,4152,4152,4155,4236,4238,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6917,6919,6919,6921,6921,6923,6923,6925,6925,6927,6929,6931,6963,6965,6970,6972,6972,6974,6975,6978,6978,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7834,7834,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8125,8125,8127,8128,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8190,8191,8194,8399,8413,8416,8418,8420,8433,8485,8487,8489,8492,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,9000,9003,10971,10973,11502,11506,11646,11648,11743,11776,12329,12336,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12440,12443,12445,12447,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12543,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,44031,55204,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64284,64288,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64335,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69785,69787,69787,69789,69802,69804,69816,69819,69887,69891,69933,69936,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70474,70478,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70842,70845,70845,70847,70849,70852,71097,71100,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71991,71993,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119133,119146,119148,119155,119162,119171,119172,119180,119209,119214,119226,119233,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,194559,195102,1114111 }); }
	static private void addProperty76() { addProperty("nfkdinert", new int[] { 0,159,161,167,169,169,171,174,176,177,182,183,187,187,191,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,305,312,312,321,322,330,331,338,339,358,359,384,415,418,430,433,451,477,477,484,485,502,503,540,541,544,549,564,687,697,727,734,735,741,767,847,847,880,883,885,889,891,893,895,899,907,907,909,909,913,937,945,969,975,975,983,1007,1011,1011,1014,1016,1018,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1154,1160,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1414,1416,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1569,1575,1610,1632,1647,1649,1652,1657,1727,1729,1729,1731,1746,1748,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2344,2346,2352,2354,2355,2357,2363,2365,2380,2382,2384,2389,2391,2400,2491,2493,2506,2510,2523,2526,2526,2528,2557,2559,2610,2612,2613,2615,2619,2621,2636,2638,2648,2652,2653,2655,2747,2749,2764,2766,2875,2877,2887,2889,2890,2894,2907,2910,2963,2965,3017,3022,3131,3133,3143,3145,3148,3150,3156,3159,3259,3261,3263,3265,3270,3273,3273,3276,3276,3278,3386,3389,3401,3406,3529,3531,3545,3547,3547,3551,3634,3636,3639,3643,3655,3660,3762,3764,3767,3771,3783,3788,3803,3806,3851,3853,3863,3866,3892,3894,3894,3896,3896,3898,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3952,3966,3967,3973,3973,3976,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4037,4039,4133,4135,4150,4152,4152,4155,4236,4238,4347,4349,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6917,6919,6919,6921,6921,6923,6923,6925,6925,6927,6929,6931,6963,6965,6970,6972,6972,6974,6975,6978,6978,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7467,7471,7471,7483,7483,7502,7502,7531,7543,7545,7578,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8203,8208,8210,8214,8216,8227,8231,8238,8240,8242,8245,8245,8248,8251,8253,8253,8255,8262,8266,8278,8280,8286,8288,8303,8306,8307,8335,8335,8349,8359,8361,8399,8413,8416,8418,8420,8433,8447,8452,8452,8456,8456,8468,8468,8471,8472,8478,8479,8483,8483,8485,8485,8487,8487,8489,8489,8494,8494,8498,8498,8506,8506,8513,8516,8522,8527,8576,8584,8586,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8747,8750,8750,8753,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,9000,9003,9311,9451,10763,10765,10867,10871,10971,10973,11387,11390,11502,11506,11630,11632,11646,11648,11743,11776,11934,11936,12018,12020,12031,12246,12287,12289,12329,12336,12341,12343,12343,12347,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12440,12445,12445,12448,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12544,12592,12687,12689,12704,12799,12831,12831,12872,12879,12927,12927,13312,42606,42608,42611,42622,42651,42656,42735,42738,42863,42865,42993,42997,42999,43002,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,43867,43872,43880,43882,44012,44014,44031,55204,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65021,65039,65050,65055,65093,65094,65107,65107,65127,65127,65132,65135,65139,65139,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,66044,66046,66271,66273,66421,66427,67456,67462,67462,67505,67505,67515,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69785,69787,69787,69789,69802,69804,69816,69819,69887,69891,69933,69936,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70474,70478,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70842,70845,70845,70847,70849,70852,71097,71100,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71991,71993,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119133,119146,119148,119155,119162,119171,119172,119180,119209,119214,119226,119233,119361,119365,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,120832,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127231,127243,127247,127279,127279,127312,127337,127341,127375,127377,127487,127491,127503,127548,127551,127561,127567,127570,130031,130042,194559,195102,1114111 }); }
	static private void addProperty77() { addProperty("nfcinert", new int[] { 0,59,63,64,81,81,91,96,113,113,123,167,169,191,208,208,215,215,222,223,240,240,247,247,254,254,260,261,272,273,280,281,290,291,294,295,302,303,305,312,315,316,319,322,325,326,329,331,338,339,342,343,350,351,354,355,358,359,370,371,384,415,418,430,433,438,440,460,477,477,482,485,492,499,502,503,508,511,540,541,544,549,564,657,659,767,847,847,880,883,885,893,895,902,904,912,914,916,918,918,920,920,922,926,928,928,930,932,934,936,938,939,941,941,943,944,946,948,950,950,952,952,954,958,960,960,962,964,966,968,972,973,975,977,979,1029,1031,1039,1041,1042,1044,1044,1049,1049,1051,1053,1055,1058,1060,1062,1064,1066,1068,1068,1070,1071,1073,1074,1076,1076,1081,1081,1083,1085,1087,1090,1092,1094,1096,1098,1100,1100,1102,1109,1111,1139,1142,1154,1160,1239,1242,1255,1258,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1569,1572,1574,1576,1607,1609,1609,1632,1647,1649,1728,1730,1745,1747,1748,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2343,2345,2351,2353,2354,2356,2363,2365,2380,2382,2384,2389,2391,2400,2491,2493,2493,2495,2502,2504,2508,2510,2518,2520,2523,2526,2526,2528,2557,2559,2610,2612,2613,2615,2619,2621,2636,2638,2648,2652,2653,2655,2747,2749,2764,2766,2875,2877,2877,2879,2886,2888,2892,2894,2901,2904,2907,2910,2961,2963,3005,3007,3013,3016,3020,3022,3030,3032,3131,3133,3141,3143,3148,3150,3156,3159,3259,3261,3262,3264,3265,3267,3269,3271,3273,3275,3276,3278,3284,3287,3386,3389,3389,3391,3397,3400,3404,3406,3414,3416,3529,3531,3534,3536,3544,3546,3547,3549,3550,3552,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3952,3959,3959,3961,3961,3966,3967,3973,3973,3976,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4037,4039,4132,4134,4141,4143,4150,4152,4152,4155,4236,4238,4351,4371,4448,4470,4519,4547,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6916,6918,6918,6920,6920,6922,6922,6924,6924,6926,6928,6930,6963,6966,6969,6971,6971,6973,6973,6976,6977,6979,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7684,7689,7696,7697,7708,7711,7720,7721,7746,7747,7764,7767,7806,7807,7816,7821,7826,7829,7834,7839,7924,7925,7930,7935,7954,7959,7962,7967,7986,7991,7994,7999,8002,8007,8010,8015,8018,8024,8026,8031,8050,8050,8054,8054,8056,8056,8058,8058,8062,8063,8066,8071,8074,8079,8082,8087,8090,8095,8098,8103,8106,8114,8116,8117,8119,8122,8125,8125,8128,8130,8132,8133,8135,8136,8138,8138,8141,8146,8148,8154,8156,8162,8164,8170,8172,8173,8176,8178,8180,8181,8183,8184,8186,8186,8191,8191,8194,8399,8413,8416,8418,8420,8433,8485,8487,8489,8492,8591,8593,8593,8595,8595,8597,8655,8657,8657,8659,8659,8661,8706,8708,8711,8713,8714,8716,8738,8740,8740,8742,8763,8765,8770,8772,8772,8774,8775,8777,8780,8782,8800,8802,8803,8806,8817,8820,8821,8824,8825,8830,8833,8836,8837,8840,8848,8851,8865,8867,8871,8874,8874,8876,8881,8886,9000,9003,10971,10973,11502,11506,11646,11648,11743,11776,12329,12336,12357,12359,12362,12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12387,12389,12389,12391,12391,12393,12398,12400,12401,12403,12404,12406,12407,12409,12410,12412,12440,12443,12444,12446,12453,12455,12458,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12483,12485,12485,12487,12487,12489,12494,12496,12497,12499,12500,12502,12503,12505,12506,12508,12526,12531,12540,12542,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,44031,44033,44059,44061,44087,44089,44115,44117,44143,44145,44171,44173,44199,44201,44227,44229,44255,44257,44283,44285,44311,44313,44339,44341,44367,44369,44395,44397,44423,44425,44451,44453,44479,44481,44507,44509,44535,44537,44563,44565,44591,44593,44619,44621,44647,44649,44675,44677,44703,44705,44731,44733,44759,44761,44787,44789,44815,44817,44843,44845,44871,44873,44899,44901,44927,44929,44955,44957,44983,44985,45011,45013,45039,45041,45067,45069,45095,45097,45123,45125,45151,45153,45179,45181,45207,45209,45235,45237,45263,45265,45291,45293,45319,45321,45347,45349,45375,45377,45403,45405,45431,45433,45459,45461,45487,45489,45515,45517,45543,45545,45571,45573,45599,45601,45627,45629,45655,45657,45683,45685,45711,45713,45739,45741,45767,45769,45795,45797,45823,45825,45851,45853,45879,45881,45907,45909,45935,45937,45963,45965,45991,45993,46019,46021,46047,46049,46075,46077,46103,46105,46131,46133,46159,46161,46187,46189,46215,46217,46243,46245,46271,46273,46299,46301,46327,46329,46355,46357,46383,46385,46411,46413,46439,46441,46467,46469,46495,46497,46523,46525,46551,46553,46579,46581,46607,46609,46635,46637,46663,46665,46691,46693,46719,46721,46747,46749,46775,46777,46803,46805,46831,46833,46859,46861,46887,46889,46915,46917,46943,46945,46971,46973,46999,47001,47027,47029,47055,47057,47083,47085,47111,47113,47139,47141,47167,47169,47195,47197,47223,47225,47251,47253,47279,47281,47307,47309,47335,47337,47363,47365,47391,47393,47419,47421,47447,47449,47475,47477,47503,47505,47531,47533,47559,47561,47587,47589,47615,47617,47643,47645,47671,47673,47699,47701,47727,47729,47755,47757,47783,47785,47811,47813,47839,47841,47867,47869,47895,47897,47923,47925,47951,47953,47979,47981,48007,48009,48035,48037,48063,48065,48091,48093,48119,48121,48147,48149,48175,48177,48203,48205,48231,48233,48259,48261,48287,48289,48315,48317,48343,48345,48371,48373,48399,48401,48427,48429,48455,48457,48483,48485,48511,48513,48539,48541,48567,48569,48595,48597,48623,48625,48651,48653,48679,48681,48707,48709,48735,48737,48763,48765,48791,48793,48819,48821,48847,48849,48875,48877,48903,48905,48931,48933,48959,48961,48987,48989,49015,49017,49043,49045,49071,49073,49099,49101,49127,49129,49155,49157,49183,49185,49211,49213,49239,49241,49267,49269,49295,49297,49323,49325,49351,49353,49379,49381,49407,49409,49435,49437,49463,49465,49491,49493,49519,49521,49547,49549,49575,49577,49603,49605,49631,49633,49659,49661,49687,49689,49715,49717,49743,49745,49771,49773,49799,49801,49827,49829,49855,49857,49883,49885,49911,49913,49939,49941,49967,49969,49995,49997,50023,50025,50051,50053,50079,50081,50107,50109,50135,50137,50163,50165,50191,50193,50219,50221,50247,50249,50275,50277,50303,50305,50331,50333,50359,50361,50387,50389,50415,50417,50443,50445,50471,50473,50499,50501,50527,50529,50555,50557,50583,50585,50611,50613,50639,50641,50667,50669,50695,50697,50723,50725,50751,50753,50779,50781,50807,50809,50835,50837,50863,50865,50891,50893,50919,50921,50947,50949,50975,50977,51003,51005,51031,51033,51059,51061,51087,51089,51115,51117,51143,51145,51171,51173,51199,51201,51227,51229,51255,51257,51283,51285,51311,51313,51339,51341,51367,51369,51395,51397,51423,51425,51451,51453,51479,51481,51507,51509,51535,51537,51563,51565,51591,51593,51619,51621,51647,51649,51675,51677,51703,51705,51731,51733,51759,51761,51787,51789,51815,51817,51843,51845,51871,51873,51899,51901,51927,51929,51955,51957,51983,51985,52011,52013,52039,52041,52067,52069,52095,52097,52123,52125,52151,52153,52179,52181,52207,52209,52235,52237,52263,52265,52291,52293,52319,52321,52347,52349,52375,52377,52403,52405,52431,52433,52459,52461,52487,52489,52515,52517,52543,52545,52571,52573,52599,52601,52627,52629,52655,52657,52683,52685,52711,52713,52739,52741,52767,52769,52795,52797,52823,52825,52851,52853,52879,52881,52907,52909,52935,52937,52963,52965,52991,52993,53019,53021,53047,53049,53075,53077,53103,53105,53131,53133,53159,53161,53187,53189,53215,53217,53243,53245,53271,53273,53299,53301,53327,53329,53355,53357,53383,53385,53411,53413,53439,53441,53467,53469,53495,53497,53523,53525,53551,53553,53579,53581,53607,53609,53635,53637,53663,53665,53691,53693,53719,53721,53747,53749,53775,53777,53803,53805,53831,53833,53859,53861,53887,53889,53915,53917,53943,53945,53971,53973,53999,54001,54027,54029,54055,54057,54083,54085,54111,54113,54139,54141,54167,54169,54195,54197,54223,54225,54251,54253,54279,54281,54307,54309,54335,54337,54363,54365,54391,54393,54419,54421,54447,54449,54475,54477,54503,54505,54531,54533,54559,54561,54587,54589,54615,54617,54643,54645,54671,54673,54699,54701,54727,54729,54755,54757,54783,54785,54811,54813,54839,54841,54867,54869,54895,54897,54923,54925,54951,54953,54979,54981,55007,55009,55035,55037,55063,55065,55091,55093,55119,55121,55147,55149,55175,55177,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64284,64288,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64335,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69784,69786,69786,69788,69796,69798,69816,69819,69887,69891,69926,69928,69936,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70461,70463,70470,70472,70476,70478,70486,70488,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70831,70833,70840,70843,70844,70846,70849,70852,71086,71088,71095,71098,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71983,71985,71988,71990,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119133,119146,119148,119155,119162,119171,119172,119180,119209,119214,119226,119233,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,194559,195102,1114111 }); }
	static private void addProperty78() { addProperty("nfkcinert", new int[] { 0,59,63,64,81,81,91,96,113,113,123,159,161,167,169,169,171,174,176,177,182,183,187,187,191,191,208,208,215,215,222,223,240,240,247,247,254,254,260,261,272,273,280,281,290,291,294,295,302,303,305,305,308,312,315,316,321,322,325,326,330,331,338,339,342,343,350,351,354,355,358,359,370,371,384,415,418,430,433,438,440,451,477,477,482,485,492,496,502,503,508,511,540,541,544,549,564,657,659,687,697,727,734,735,741,767,847,847,880,883,885,889,891,893,895,899,902,902,904,912,914,916,918,918,920,920,922,926,928,928,930,932,934,936,938,939,941,941,943,944,946,948,950,950,952,952,954,958,960,960,962,964,966,968,972,973,975,975,983,1007,1011,1011,1014,1016,1018,1029,1031,1039,1041,1042,1044,1044,1049,1049,1051,1053,1055,1058,1060,1062,1064,1066,1068,1068,1070,1071,1073,1074,1076,1076,1081,1081,1083,1085,1087,1090,1092,1094,1096,1098,1100,1100,1102,1109,1111,1139,1142,1154,1160,1239,1242,1255,1258,1414,1416,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1569,1572,1574,1576,1607,1609,1609,1632,1647,1649,1652,1657,1728,1730,1745,1747,1748,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2343,2345,2351,2353,2354,2356,2363,2365,2380,2382,2384,2389,2391,2400,2491,2493,2493,2495,2502,2504,2508,2510,2518,2520,2523,2526,2526,2528,2557,2559,2610,2612,2613,2615,2619,2621,2636,2638,2648,2652,2653,2655,2747,2749,2764,2766,2875,2877,2877,2879,2886,2888,2892,2894,2901,2904,2907,2910,2961,2963,3005,3007,3013,3016,3020,3022,3030,3032,3131,3133,3141,3143,3148,3150,3156,3159,3259,3261,3262,3264,3265,3267,3269,3271,3273,3275,3276,3278,3284,3287,3386,3389,3389,3391,3397,3400,3404,3406,3414,3416,3529,3531,3534,3536,3544,3546,3547,3549,3550,3552,3634,3636,3639,3643,3655,3660,3762,3764,3767,3771,3783,3788,3803,3806,3851,3853,3863,3866,3892,3894,3894,3896,3896,3898,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3952,3966,3967,3973,3973,3976,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4037,4039,4132,4134,4141,4143,4150,4152,4152,4155,4236,4238,4347,4349,4351,4371,4448,4470,4519,4547,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6916,6918,6918,6920,6920,6922,6922,6924,6924,6926,6928,6930,6963,6966,6969,6971,6971,6973,6973,6976,6977,6979,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7467,7471,7471,7483,7483,7502,7502,7531,7543,7545,7578,7684,7689,7696,7697,7708,7711,7720,7721,7746,7747,7764,7767,7806,7807,7816,7821,7826,7829,7836,7839,7924,7925,7930,7935,7954,7959,7962,7967,7986,7991,7994,7999,8002,8007,8010,8015,8018,8024,8026,8031,8050,8050,8054,8054,8056,8056,8058,8058,8062,8063,8066,8071,8074,8079,8082,8087,8090,8095,8098,8103,8106,8114,8116,8117,8119,8122,8130,8130,8132,8133,8135,8136,8138,8138,8144,8146,8148,8154,8156,8156,8160,8162,8164,8170,8172,8172,8176,8178,8180,8181,8183,8184,8186,8186,8191,8191,8203,8208,8210,8214,8216,8227,8231,8238,8240,8242,8245,8245,8248,8251,8253,8253,8255,8262,8266,8278,8280,8286,8288,8303,8306,8307,8335,8335,8349,8359,8361,8399,8413,8416,8418,8420,8433,8447,8452,8452,8456,8456,8468,8468,8471,8472,8478,8479,8483,8483,8485,8485,8487,8487,8489,8489,8494,8494,8498,8498,8506,8506,8513,8516,8522,8527,8576,8584,8586,8591,8593,8593,8595,8595,8597,8655,8657,8657,8659,8659,8661,8706,8708,8711,8713,8714,8716,8738,8740,8740,8742,8747,8750,8750,8753,8763,8765,8770,8772,8772,8774,8775,8777,8780,8782,8800,8802,8803,8806,8817,8820,8821,8824,8825,8830,8833,8836,8837,8840,8848,8851,8865,8867,8871,8874,8874,8876,8881,8886,9000,9003,9311,9451,10763,10765,10867,10871,10971,10973,11387,11390,11502,11506,11630,11632,11646,11648,11743,11776,11934,11936,12018,12020,12031,12246,12287,12289,12329,12336,12341,12343,12343,12347,12357,12359,12362,12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12387,12389,12389,12391,12391,12393,12398,12400,12401,12403,12404,12406,12407,12409,12410,12412,12440,12446,12446,12448,12453,12455,12458,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12483,12485,12485,12487,12487,12489,12494,12496,12497,12499,12500,12502,12503,12505,12506,12508,12526,12531,12540,12542,12542,12544,12592,12687,12689,12704,12799,12831,12831,12872,12879,12927,12927,13312,42606,42608,42611,42622,42651,42656,42735,42738,42863,42865,42993,42997,42999,43002,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,43867,43872,43880,43882,44012,44014,44031,44033,44059,44061,44087,44089,44115,44117,44143,44145,44171,44173,44199,44201,44227,44229,44255,44257,44283,44285,44311,44313,44339,44341,44367,44369,44395,44397,44423,44425,44451,44453,44479,44481,44507,44509,44535,44537,44563,44565,44591,44593,44619,44621,44647,44649,44675,44677,44703,44705,44731,44733,44759,44761,44787,44789,44815,44817,44843,44845,44871,44873,44899,44901,44927,44929,44955,44957,44983,44985,45011,45013,45039,45041,45067,45069,45095,45097,45123,45125,45151,45153,45179,45181,45207,45209,45235,45237,45263,45265,45291,45293,45319,45321,45347,45349,45375,45377,45403,45405,45431,45433,45459,45461,45487,45489,45515,45517,45543,45545,45571,45573,45599,45601,45627,45629,45655,45657,45683,45685,45711,45713,45739,45741,45767,45769,45795,45797,45823,45825,45851,45853,45879,45881,45907,45909,45935,45937,45963,45965,45991,45993,46019,46021,46047,46049,46075,46077,46103,46105,46131,46133,46159,46161,46187,46189,46215,46217,46243,46245,46271,46273,46299,46301,46327,46329,46355,46357,46383,46385,46411,46413,46439,46441,46467,46469,46495,46497,46523,46525,46551,46553,46579,46581,46607,46609,46635,46637,46663,46665,46691,46693,46719,46721,46747,46749,46775,46777,46803,46805,46831,46833,46859,46861,46887,46889,46915,46917,46943,46945,46971,46973,46999,47001,47027,47029,47055,47057,47083,47085,47111,47113,47139,47141,47167,47169,47195,47197,47223,47225,47251,47253,47279,47281,47307,47309,47335,47337,47363,47365,47391,47393,47419,47421,47447,47449,47475,47477,47503,47505,47531,47533,47559,47561,47587,47589,47615,47617,47643,47645,47671,47673,47699,47701,47727,47729,47755,47757,47783,47785,47811,47813,47839,47841,47867,47869,47895,47897,47923,47925,47951,47953,47979,47981,48007,48009,48035,48037,48063,48065,48091,48093,48119,48121,48147,48149,48175,48177,48203,48205,48231,48233,48259,48261,48287,48289,48315,48317,48343,48345,48371,48373,48399,48401,48427,48429,48455,48457,48483,48485,48511,48513,48539,48541,48567,48569,48595,48597,48623,48625,48651,48653,48679,48681,48707,48709,48735,48737,48763,48765,48791,48793,48819,48821,48847,48849,48875,48877,48903,48905,48931,48933,48959,48961,48987,48989,49015,49017,49043,49045,49071,49073,49099,49101,49127,49129,49155,49157,49183,49185,49211,49213,49239,49241,49267,49269,49295,49297,49323,49325,49351,49353,49379,49381,49407,49409,49435,49437,49463,49465,49491,49493,49519,49521,49547,49549,49575,49577,49603,49605,49631,49633,49659,49661,49687,49689,49715,49717,49743,49745,49771,49773,49799,49801,49827,49829,49855,49857,49883,49885,49911,49913,49939,49941,49967,49969,49995,49997,50023,50025,50051,50053,50079,50081,50107,50109,50135,50137,50163,50165,50191,50193,50219,50221,50247,50249,50275,50277,50303,50305,50331,50333,50359,50361,50387,50389,50415,50417,50443,50445,50471,50473,50499,50501,50527,50529,50555,50557,50583,50585,50611,50613,50639,50641,50667,50669,50695,50697,50723,50725,50751,50753,50779,50781,50807,50809,50835,50837,50863,50865,50891,50893,50919,50921,50947,50949,50975,50977,51003,51005,51031,51033,51059,51061,51087,51089,51115,51117,51143,51145,51171,51173,51199,51201,51227,51229,51255,51257,51283,51285,51311,51313,51339,51341,51367,51369,51395,51397,51423,51425,51451,51453,51479,51481,51507,51509,51535,51537,51563,51565,51591,51593,51619,51621,51647,51649,51675,51677,51703,51705,51731,51733,51759,51761,51787,51789,51815,51817,51843,51845,51871,51873,51899,51901,51927,51929,51955,51957,51983,51985,52011,52013,52039,52041,52067,52069,52095,52097,52123,52125,52151,52153,52179,52181,52207,52209,52235,52237,52263,52265,52291,52293,52319,52321,52347,52349,52375,52377,52403,52405,52431,52433,52459,52461,52487,52489,52515,52517,52543,52545,52571,52573,52599,52601,52627,52629,52655,52657,52683,52685,52711,52713,52739,52741,52767,52769,52795,52797,52823,52825,52851,52853,52879,52881,52907,52909,52935,52937,52963,52965,52991,52993,53019,53021,53047,53049,53075,53077,53103,53105,53131,53133,53159,53161,53187,53189,53215,53217,53243,53245,53271,53273,53299,53301,53327,53329,53355,53357,53383,53385,53411,53413,53439,53441,53467,53469,53495,53497,53523,53525,53551,53553,53579,53581,53607,53609,53635,53637,53663,53665,53691,53693,53719,53721,53747,53749,53775,53777,53803,53805,53831,53833,53859,53861,53887,53889,53915,53917,53943,53945,53971,53973,53999,54001,54027,54029,54055,54057,54083,54085,54111,54113,54139,54141,54167,54169,54195,54197,54223,54225,54251,54253,54279,54281,54307,54309,54335,54337,54363,54365,54391,54393,54419,54421,54447,54449,54475,54477,54503,54505,54531,54533,54559,54561,54587,54589,54615,54617,54643,54645,54671,54673,54699,54701,54727,54729,54755,54757,54783,54785,54811,54813,54839,54841,54867,54869,54895,54897,54923,54925,54951,54953,54979,54981,55007,55009,55035,55037,55063,55065,55091,55093,55119,55121,55147,55149,55175,55177,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65021,65039,65050,65055,65093,65094,65107,65107,65127,65127,65132,65135,65139,65139,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,66044,66046,66271,66273,66421,66427,67456,67462,67462,67505,67505,67515,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69784,69786,69786,69788,69796,69798,69816,69819,69887,69891,69926,69928,69936,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70461,70463,70470,70472,70476,70478,70486,70488,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70831,70833,70840,70843,70844,70846,70849,70852,71086,71088,71095,71098,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71983,71985,71988,71990,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119133,119146,119148,119155,119162,119171,119172,119180,119209,119214,119226,119233,119361,119365,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,120832,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127231,127243,127247,127279,127279,127312,127337,127341,127375,127377,127487,127491,127503,127548,127551,127561,127567,127570,130031,130042,194559,195102,1114111 }); }
	static private void addProperty79() { addProperty("segstart", new int[] { 0,767,847,847,880,1154,1160,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1610,1632,1647,1649,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2363,2365,2380,2382,2384,2389,2491,2493,2493,2495,2508,2510,2518,2520,2557,2559,2619,2621,2636,2638,2747,2749,2764,2766,2875,2877,2877,2879,2892,2894,2901,2904,3005,3007,3020,3022,3030,3032,3131,3133,3148,3150,3156,3159,3259,3261,3265,3267,3276,3278,3284,3287,3386,3389,3389,3391,3404,3406,3414,3416,3529,3531,3534,3536,3550,3552,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3952,3955,3955,3957,3961,3966,3967,3969,3969,3973,3973,3976,4020,4022,4022,4024,4037,4039,4141,4143,4150,4152,4152,4155,4236,4238,4448,4470,4519,4547,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6963,6966,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7680,8399,8413,8416,8418,8420,8433,11502,11506,11646,11648,11743,11776,12329,12336,12440,12443,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,64285,64287,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69816,69819,69887,69891,69926,69928,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70461,70463,70476,70478,70486,70488,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70831,70833,70841,70843,70844,70846,70849,70852,71086,71088,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71983,71985,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119140,119146,119148,119155,119162,119171,119172,119180,119209,119214,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,1114111 }); }
	static private void addProperty80() { addProperty("pat_syn", new int[] { 33,47,58,64,91,94,96,96,123,126,161,167,169,169,171,172,174,174,176,177,182,182,187,187,191,191,215,215,247,247,8208,8231,8240,8254,8257,8275,8277,8286,8592,9311,9472,10101,10132,11263,11776,11903,12289,12291,12296,12320,12336,12336,64830,64831,65093,65094 }); }
	static private void addProperty81() { addProperty("pat_ws", new int[] { 9,13,32,32,133,133,8206,8207,8232,8233 }); }
	static private void addProperty82() { addProperty("alnum", new int[] { 48,57,65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,705,710,721,736,740,748,748,750,750,837,837,880,884,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1369,1376,1416,1456,1469,1471,1471,1473,1474,1476,1477,1479,1479,1488,1514,1519,1522,1552,1562,1568,1623,1625,1641,1646,1747,1749,1756,1761,1768,1773,1788,1791,1791,1808,1855,1869,1969,1984,2026,2036,2037,2042,2042,2048,2071,2074,2092,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2260,2271,2275,2281,2288,2363,2365,2380,2382,2384,2389,2403,2406,2415,2417,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2500,2503,2504,2507,2508,2510,2510,2519,2519,2524,2525,2527,2531,2534,2545,2556,2556,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2622,2626,2631,2632,2635,2636,2641,2641,2649,2652,2654,2654,2662,2677,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2757,2759,2761,2763,2764,2768,2768,2784,2787,2790,2799,2809,2812,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2884,2887,2888,2891,2892,2902,2903,2908,2909,2911,2915,2918,2927,2929,2929,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3020,3024,3024,3031,3031,3046,3055,3072,3084,3086,3088,3090,3112,3114,3129,3133,3140,3142,3144,3146,3148,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3200,3203,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3268,3270,3272,3274,3276,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315,3328,3340,3342,3344,3346,3386,3389,3396,3398,3400,3402,3404,3406,3406,3412,3415,3423,3427,3430,3439,3450,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3535,3540,3542,3542,3544,3551,3558,3567,3570,3571,3585,3642,3648,3654,3661,3661,3664,3673,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3769,3771,3773,3776,3780,3782,3782,3789,3789,3792,3801,3804,3807,3840,3840,3872,3881,3904,3911,3913,3948,3953,3971,3976,3991,3993,4028,4096,4150,4152,4152,4155,4169,4176,4253,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5907,5919,5939,5952,5971,5984,5996,5998,6000,6002,6003,6016,6067,6070,6088,6103,6103,6108,6108,6112,6121,6160,6169,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6456,6470,6509,6512,6516,6528,6571,6576,6601,6608,6617,6656,6683,6688,6750,6753,6772,6784,6793,6800,6809,6823,6823,6847,6848,6860,6862,6912,6963,6965,6979,6981,6988,6992,7001,7040,7081,7084,7141,7143,7153,7168,7222,7232,7241,7245,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7655,7668,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8544,8584,9398,9449,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11775,11823,11823,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42539,42560,42606,42612,42619,42623,42735,42775,42783,42786,42888,42891,42954,42960,42961,42963,42963,42965,42969,42994,43013,43015,43047,43072,43123,43136,43203,43205,43205,43216,43225,43250,43255,43259,43259,43261,43306,43312,43346,43360,43388,43392,43442,43444,43455,43471,43481,43488,43518,43520,43574,43584,43597,43600,43609,43616,43638,43642,43710,43712,43712,43714,43714,43739,43741,43744,43759,43762,43765,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43866,43868,43881,43888,44010,44016,44025,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64256,64262,64275,64279,64285,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65296,65305,65313,65338,65345,65370,65382,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66426,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68099,68101,68102,68108,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68903,68912,68921,69248,69289,69291,69292,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69632,69701,69734,69743,69745,69749,69760,69816,69826,69826,69840,69864,69872,69881,69888,69938,69942,69951,69956,69959,69968,70002,70006,70006,70016,70079,70081,70084,70094,70106,70108,70108,70144,70161,70163,70196,70199,70199,70206,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70376,70384,70393,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70468,70471,70472,70475,70476,70480,70480,70487,70487,70493,70499,70656,70721,70723,70725,70727,70730,70736,70745,70751,70753,70784,70849,70852,70853,70855,70855,70864,70873,71040,71093,71096,71102,71128,71133,71168,71230,71232,71232,71236,71236,71248,71257,71296,71349,71352,71352,71360,71369,71424,71450,71453,71466,71472,71481,71488,71494,71680,71736,71840,71913,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,71996,71999,72002,72016,72025,72096,72103,72106,72151,72154,72159,72161,72161,72163,72164,72192,72242,72245,72254,72272,72343,72349,72349,72368,72440,72704,72712,72714,72758,72760,72766,72768,72768,72784,72793,72818,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73025,73027,73027,73030,73031,73040,73049,73056,73061,73063,73064,73066,73102,73104,73105,73107,73110,73112,73112,73120,73129,73440,73462,73472,73488,73490,73530,73534,73536,73552,73561,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92768,92777,92784,92862,92864,92873,92880,92909,92928,92975,92992,92995,93008,93017,93027,93047,93053,93071,93760,93823,93952,94026,94031,94087,94095,94111,94176,94177,94179,94179,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113822,113822,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,120782,120831,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123191,123197,123200,123209,123214,123214,123536,123565,123584,123627,123632,123641,124112,124139,124144,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125255,125255,125259,125259,125264,125273,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127280,127305,127312,127337,127344,127369,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty83() { addProperty("blank", new int[] { 9,9,32,32,160,160,5760,5760,8192,8202,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty84() { addProperty("graph", new int[] { 33,126,161,887,890,895,900,906,908,908,910,929,931,1327,1329,1366,1369,1418,1421,1423,1425,1479,1488,1514,1519,1524,1536,1805,1807,1866,1869,1969,1984,2042,2045,2093,2096,2110,2112,2139,2142,2142,2144,2154,2160,2190,2192,2193,2200,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2558,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2678,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2801,2809,2815,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2901,2903,2908,2909,2911,2915,2918,2935,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3066,3072,3084,3086,3088,3090,3112,3114,3129,3132,3140,3142,3144,3146,3149,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3191,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315,3328,3340,3342,3344,3346,3396,3398,3400,3402,3407,3412,3427,3430,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3558,3567,3570,3572,3585,3642,3647,3675,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3792,3801,3804,3807,3840,3911,3913,3948,3953,3991,3993,4028,4030,4044,4046,4058,4096,4293,4295,4295,4301,4301,4304,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4988,4992,5017,5024,5109,5112,5117,5120,5759,5761,5788,5792,5880,5888,5909,5919,5942,5952,5971,5984,5996,5998,6000,6002,6003,6016,6109,6112,6121,6128,6137,6144,6169,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6459,6464,6464,6468,6509,6512,6516,6528,6571,6576,6601,6608,6618,6622,6683,6686,6750,6752,6780,6783,6793,6800,6809,6816,6829,6832,6862,6912,6988,6992,7038,7040,7155,7164,7223,7227,7241,7245,7304,7312,7354,7357,7367,7376,7418,7424,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8190,8203,8231,8234,8238,8240,8286,8288,8292,8294,8305,8308,8334,8336,8348,8352,8384,8400,8432,8448,8587,8592,9254,9280,9290,9312,11123,11126,11157,11159,11507,11513,11557,11559,11559,11565,11565,11568,11623,11631,11632,11647,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11869,11904,11929,11931,12019,12032,12245,12272,12283,12289,12351,12353,12438,12441,12543,12549,12591,12593,12686,12688,12771,12784,12830,12832,42124,42128,42182,42192,42539,42560,42743,42752,42954,42960,42961,42963,42963,42965,42969,42994,43052,43056,43065,43072,43127,43136,43205,43214,43225,43232,43347,43359,43388,43392,43469,43471,43481,43486,43518,43520,43574,43584,43597,43600,43609,43612,43714,43739,43766,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43883,43888,44013,44016,44025,44032,55203,55216,55238,55243,55291,57344,64109,64112,64217,64256,64262,64275,64279,64285,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64450,64467,64911,64914,64967,64975,64975,65008,65049,65056,65106,65108,65126,65128,65131,65136,65140,65142,65276,65279,65279,65281,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,65529,65533,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65792,65794,65799,65843,65847,65934,65936,65948,65952,65952,66000,66045,66176,66204,66208,66256,66272,66299,66304,66339,66349,66378,66384,66426,66432,66461,66463,66499,66504,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66927,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67671,67742,67751,67759,67808,67826,67828,67829,67835,67867,67871,67897,67903,67903,67968,68023,68028,68047,68050,68099,68101,68102,68108,68115,68117,68119,68121,68149,68152,68154,68159,68168,68176,68184,68192,68255,68288,68326,68331,68342,68352,68405,68409,68437,68440,68466,68472,68497,68505,68508,68521,68527,68608,68680,68736,68786,68800,68850,68858,68903,68912,68921,69216,69246,69248,69289,69291,69293,69296,69297,69373,69415,69424,69465,69488,69513,69552,69579,69600,69622,69632,69709,69714,69749,69759,69826,69837,69837,69840,69864,69872,69881,69888,69940,69942,69959,69968,70006,70016,70111,70113,70132,70144,70161,70163,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70313,70320,70378,70384,70393,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70459,70468,70471,70472,70475,70477,70480,70480,70487,70487,70493,70499,70502,70508,70512,70516,70656,70747,70749,70753,70784,70855,70864,70873,71040,71093,71096,71133,71168,71236,71248,71257,71264,71276,71296,71353,71360,71369,71424,71450,71453,71467,71472,71494,71680,71739,71840,71922,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,72006,72016,72025,72096,72103,72106,72151,72154,72164,72192,72263,72272,72354,72368,72440,72448,72457,72704,72712,72714,72758,72760,72773,72784,72812,72816,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73031,73040,73049,73056,73061,73063,73064,73066,73102,73104,73105,73107,73112,73120,73129,73440,73464,73472,73488,73490,73530,73534,73561,73648,73648,73664,73713,73727,74649,74752,74862,74864,74868,74880,75075,77712,77810,77824,78933,82944,83526,92160,92728,92736,92766,92768,92777,92782,92862,92864,92873,92880,92909,92912,92917,92928,92997,93008,93017,93019,93025,93027,93047,93053,93071,93760,93850,93952,94026,94031,94087,94095,94111,94176,94180,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113820,113827,118528,118573,118576,118598,118608,118723,118784,119029,119040,119078,119081,119274,119296,119365,119488,119507,119520,119539,119552,119638,119648,119672,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,121483,121499,121503,121505,121519,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123184,123197,123200,123209,123214,123215,123536,123566,123584,123641,123647,123647,124112,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125127,125142,125184,125259,125264,125273,125278,125279,126065,126132,126209,126269,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127232,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743,917505,917505,917536,917631,917760,917999,983040,1048573,1048576,1114109 }); }
	static private void addProperty85() { addProperty("print", new int[] { 32,126,160,887,890,895,900,906,908,908,910,929,931,1327,1329,1366,1369,1418,1421,1423,1425,1479,1488,1514,1519,1524,1536,1805,1807,1866,1869,1969,1984,2042,2045,2093,2096,2110,2112,2139,2142,2142,2144,2154,2160,2190,2192,2193,2200,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2558,2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2678,2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2801,2809,2815,2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2901,2903,2908,2909,2911,2915,2918,2935,2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3066,3072,3084,3086,3088,3090,3112,3114,3129,3132,3140,3142,3144,3146,3149,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3191,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315,3328,3340,3342,3344,3346,3396,3398,3400,3402,3407,3412,3427,3430,3455,3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3558,3567,3570,3572,3585,3642,3647,3675,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3792,3801,3804,3807,3840,3911,3913,3948,3953,3991,3993,4028,4030,4044,4046,4058,4096,4293,4295,4295,4301,4301,4304,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4988,4992,5017,5024,5109,5112,5117,5120,5788,5792,5880,5888,5909,5919,5942,5952,5971,5984,5996,5998,6000,6002,6003,6016,6109,6112,6121,6128,6137,6144,6169,6176,6264,6272,6314,6320,6389,6400,6430,6432,6443,6448,6459,6464,6464,6468,6509,6512,6516,6528,6571,6576,6601,6608,6618,6622,6683,6686,6750,6752,6780,6783,6793,6800,6809,6816,6829,6832,6862,6912,6988,6992,7038,7040,7155,7164,7223,7227,7241,7245,7304,7312,7354,7357,7367,7376,7418,7424,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8190,8192,8231,8234,8292,8294,8305,8308,8334,8336,8348,8352,8384,8400,8432,8448,8587,8592,9254,9280,9290,9312,11123,11126,11157,11159,11507,11513,11557,11559,11559,11565,11565,11568,11623,11631,11632,11647,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11744,11869,11904,11929,11931,12019,12032,12245,12272,12283,12288,12351,12353,12438,12441,12543,12549,12591,12593,12686,12688,12771,12784,12830,12832,42124,42128,42182,42192,42539,42560,42743,42752,42954,42960,42961,42963,42963,42965,42969,42994,43052,43056,43065,43072,43127,43136,43205,43214,43225,43232,43347,43359,43388,43392,43469,43471,43481,43486,43518,43520,43574,43584,43597,43600,43609,43612,43714,43739,43766,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43883,43888,44013,44016,44025,44032,55203,55216,55238,55243,55291,57344,64109,64112,64217,64256,64262,64275,64279,64285,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64450,64467,64911,64914,64967,64975,64975,65008,65049,65056,65106,65108,65126,65128,65131,65136,65140,65142,65276,65279,65279,65281,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,65529,65533,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65792,65794,65799,65843,65847,65934,65936,65948,65952,65952,66000,66045,66176,66204,66208,66256,66272,66299,66304,66339,66349,66378,66384,66426,66432,66461,66463,66499,66504,66517,66560,66717,66720,66729,66736,66771,66776,66811,66816,66855,66864,66915,66927,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67671,67742,67751,67759,67808,67826,67828,67829,67835,67867,67871,67897,67903,67903,67968,68023,68028,68047,68050,68099,68101,68102,68108,68115,68117,68119,68121,68149,68152,68154,68159,68168,68176,68184,68192,68255,68288,68326,68331,68342,68352,68405,68409,68437,68440,68466,68472,68497,68505,68508,68521,68527,68608,68680,68736,68786,68800,68850,68858,68903,68912,68921,69216,69246,69248,69289,69291,69293,69296,69297,69373,69415,69424,69465,69488,69513,69552,69579,69600,69622,69632,69709,69714,69749,69759,69826,69837,69837,69840,69864,69872,69881,69888,69940,69942,69959,69968,70006,70016,70111,70113,70132,70144,70161,70163,70209,70272,70278,70280,70280,70282,70285,70287,70301,70303,70313,70320,70378,70384,70393,70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70459,70468,70471,70472,70475,70477,70480,70480,70487,70487,70493,70499,70502,70508,70512,70516,70656,70747,70749,70753,70784,70855,70864,70873,71040,71093,71096,71133,71168,71236,71248,71257,71264,71276,71296,71353,71360,71369,71424,71450,71453,71467,71472,71494,71680,71739,71840,71922,71935,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,72006,72016,72025,72096,72103,72106,72151,72154,72164,72192,72263,72272,72354,72368,72440,72448,72457,72704,72712,72714,72758,72760,72773,72784,72812,72816,72847,72850,72871,72873,72886,72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73031,73040,73049,73056,73061,73063,73064,73066,73102,73104,73105,73107,73112,73120,73129,73440,73464,73472,73488,73490,73530,73534,73561,73648,73648,73664,73713,73727,74649,74752,74862,74864,74868,74880,75075,77712,77810,77824,78933,82944,83526,92160,92728,92736,92766,92768,92777,92782,92862,92864,92873,92880,92909,92912,92917,92928,92997,93008,93017,93019,93025,93027,93047,93053,93071,93760,93850,93952,94026,94031,94087,94095,94111,94176,94180,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,113820,113827,118528,118573,118576,118598,118608,118723,118784,119029,119040,119078,119081,119274,119296,119365,119488,119507,119520,119539,119552,119638,119648,119672,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,121483,121499,121503,121505,121519,122624,122654,122661,122666,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123136,123180,123184,123197,123200,123209,123214,123215,123536,123566,123584,123641,123647,123647,124112,124153,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125127,125142,125184,125259,125264,125273,125278,125279,126065,126132,126209,126269,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127232,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994,130032,130041,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743,917505,917505,917536,917631,917760,917999,983040,1048573,1048576,1114109 }); }
	static private void addProperty86() { addProperty("xdigit", new int[] { 48,57,65,70,97,102,1632,1641,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,65313,65318,65345,65350,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty87() { addProperty("cased", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,442,444,447,452,659,661,696,704,705,736,740,837,837,880,883,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1376,1416,4256,4293,4295,4295,4301,4301,4304,4346,4348,4351,5024,5109,5112,5117,7296,7304,7312,7354,7357,7359,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8500,8505,8505,8508,8511,8517,8521,8526,8526,8544,8575,8579,8580,9398,9449,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,42560,42605,42624,42653,42786,42887,42891,42894,42896,42954,42960,42961,42963,42963,42965,42969,42994,42998,43000,43002,43824,43866,43868,43881,43888,43967,64256,64262,64275,64279,65313,65338,65345,65370,66560,66639,66736,66771,66776,66811,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67456,67456,67459,67461,67463,67504,67506,67514,68736,68786,68800,68850,71840,71903,93760,93823,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122633,122635,122654,122661,122666,122928,122989,125184,125251,127280,127305,127312,127337,127344,127369 }); }
	static private void addProperty88() { addProperty("ci", new int[] { 39,39,46,46,58,58,94,94,96,96,168,168,173,173,175,175,180,180,183,184,688,879,884,885,890,890,900,901,903,903,1155,1161,1369,1369,1375,1375,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1524,1524,1536,1541,1552,1562,1564,1564,1600,1600,1611,1631,1648,1648,1750,1757,1759,1768,1770,1773,1807,1807,1809,1809,1840,1866,1958,1968,2027,2037,2042,2042,2045,2045,2070,2093,2137,2139,2184,2184,2192,2193,2200,2207,2249,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2417,2417,2433,2433,2492,2492,2497,2500,2509,2509,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2879,2879,2881,2884,2893,2893,2901,2902,2914,2915,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3270,3270,3276,3277,3298,3299,3328,3329,3387,3388,3393,3396,3405,3405,3426,3427,3457,3457,3530,3530,3538,3540,3542,3542,3633,3633,3636,3642,3654,3662,3761,3761,3764,3772,3782,3782,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4348,4348,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6103,6103,6109,6109,6155,6159,6211,6211,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6823,6823,6832,6862,6912,6915,6964,6964,6966,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7288,7293,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7468,7530,7544,7544,7579,7679,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,8203,8207,8216,8217,8228,8228,8231,8231,8234,8238,8288,8292,8294,8303,8305,8305,8319,8319,8336,8348,8400,8432,11388,11389,11503,11505,11631,11631,11647,11647,11744,11775,11823,11823,12293,12293,12330,12333,12337,12341,12347,12347,12441,12446,12540,12542,40981,40981,42232,42237,42508,42508,42607,42610,42612,42621,42623,42623,42652,42655,42736,42737,42752,42785,42864,42864,42888,42890,42994,42996,43000,43001,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43471,43471,43493,43494,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43632,43632,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43741,43741,43756,43757,43763,43764,43766,43766,43867,43871,43881,43883,44005,44005,44008,44008,44013,44013,64286,64286,64434,64450,65024,65039,65043,65043,65056,65071,65106,65106,65109,65109,65279,65279,65287,65287,65294,65294,65306,65306,65342,65342,65344,65344,65392,65392,65438,65439,65507,65507,65529,65531,66045,66045,66272,66272,66422,66426,67456,67461,67463,67504,67506,67514,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69821,69821,69826,69826,69837,69837,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70464,70464,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70835,70840,70842,70842,70847,70848,70850,70851,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78896,78912,78919,78933,92912,92916,92976,92982,92992,92995,94031,94031,94095,94111,94176,94177,94179,94180,110576,110579,110581,110587,110589,110590,113821,113822,113824,113827,118528,118573,118576,118598,119143,119145,119155,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,122928,122989,123023,123023,123184,123197,123566,123566,123628,123631,124139,124143,125136,125142,125252,125259,127995,127999,917505,917505,917536,917631,917760,917999 }); }
	static private void addProperty89() { addProperty("cwl", new int[] { 65,90,192,214,216,222,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,330,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,453,455,456,458,459,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,498,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,975,975,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1012,1012,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,4256,4293,4295,4295,4301,4301,5024,5109,7312,7354,7357,7359,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8072,8079,8088,8095,8104,8111,8120,8124,8136,8140,8152,8155,8168,8172,8184,8188,8486,8486,8490,8491,8498,8498,8544,8559,8579,8579,9398,9423,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,125184,125217 }); }
	static private void addProperty90() { addProperty("cwu", new int[] { 97,122,181,181,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,311,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,396,402,402,405,405,409,410,414,414,417,417,419,419,421,421,424,424,429,429,432,432,436,436,438,438,441,441,445,445,447,447,453,454,456,457,459,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,496,498,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,563,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,596,598,599,601,601,603,604,608,609,611,611,613,614,616,620,623,623,625,626,629,629,637,637,640,640,642,643,647,652,658,658,669,670,837,837,881,881,883,883,887,887,891,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1019,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1377,1415,4304,4346,4349,4351,5112,5117,7296,7304,7545,7545,7549,7549,7566,7566,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7835,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8116,8118,8119,8124,8124,8126,8126,8130,8132,8134,8135,8140,8140,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8188,8188,8526,8526,8560,8575,8580,8580,9424,9449,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11379,11379,11382,11382,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11491,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42651,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42799,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42863,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42897,42897,42899,42900,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42967,42967,42969,42969,42998,42998,43859,43859,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,68800,68850,71872,71903,93792,93823,125218,125251 }); }
	static private void addProperty91() { addProperty("cwt", new int[] { 97,122,181,181,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,311,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,396,402,402,405,405,409,410,414,414,417,417,419,419,421,421,424,424,429,429,432,432,436,436,438,438,441,441,445,445,447,447,452,452,454,455,457,458,460,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,497,499,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,563,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,596,598,599,601,601,603,604,608,609,611,611,613,614,616,620,623,623,625,626,629,629,637,637,640,640,642,643,647,652,658,658,669,670,837,837,881,881,883,883,887,887,891,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1019,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1377,1415,5112,5117,7296,7304,7545,7545,7549,7549,7566,7566,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7835,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8071,8080,8087,8096,8103,8112,8116,8118,8119,8126,8126,8130,8132,8134,8135,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8526,8526,8560,8575,8580,8580,9424,9449,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11379,11379,11382,11382,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11491,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42651,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42799,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42863,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42897,42897,42899,42900,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42967,42967,42969,42969,42998,42998,43859,43859,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,68800,68850,71872,71903,93792,93823,125218,125251 }); }
	static private void addProperty92() { addProperty("cwcf", new int[] { 65,90,181,181,192,214,216,223,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,329,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,383,383,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,453,455,456,458,459,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,498,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,837,837,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,962,962,975,977,981,982,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1008,1009,1012,1013,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,1415,1415,4256,4293,4295,4295,4301,4301,5112,5117,7296,7304,7312,7354,7357,7359,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7834,7835,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8064,8111,8114,8116,8119,8124,8130,8132,8135,8140,8152,8155,8168,8172,8178,8180,8183,8188,8486,8486,8490,8491,8498,8498,8544,8559,8579,8579,9398,9423,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,43888,43967,64256,64262,64275,64279,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,125184,125217 }); }
	static private void addProperty93() { addProperty("cwcm", new int[] { 65,90,97,122,181,181,192,214,216,246,248,311,313,396,398,410,412,425,428,441,444,445,447,447,452,544,546,563,570,596,598,599,601,601,603,604,608,609,611,611,613,614,616,620,623,623,625,626,629,629,637,637,640,640,642,643,647,652,658,658,669,670,837,837,880,883,886,887,891,893,895,895,902,902,904,906,908,908,910,929,931,977,981,1013,1015,1019,1021,1153,1162,1327,1329,1366,1377,1415,4256,4293,4295,4295,4301,4301,4304,4346,4349,4351,5024,5109,5112,5117,7296,7304,7312,7354,7357,7359,7545,7545,7549,7549,7566,7566,7680,7835,7838,7838,7840,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8486,8486,8490,8491,8498,8498,8526,8526,8544,8575,8579,8580,9398,9449,11264,11376,11378,11379,11381,11382,11390,11491,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,42560,42605,42624,42651,42786,42799,42802,42863,42873,42887,42891,42893,42896,42900,42902,42926,42928,42954,42960,42961,42966,42969,42997,42998,43859,43859,43888,43967,64256,64262,64275,64279,65313,65338,65345,65370,66560,66639,66736,66771,66776,66811,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,68736,68786,68800,68850,71840,71903,93760,93823,125184,125251 }); }
	static private void addProperty94() { addProperty("cwkcf", new int[] { 65,90,160,160,168,168,170,170,173,173,175,175,178,181,184,186,188,190,192,214,216,223,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,308,310,310,313,313,315,315,317,317,319,321,323,323,325,325,327,327,329,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,383,383,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,688,696,728,733,736,740,832,833,835,837,847,847,880,880,882,882,884,884,886,886,890,890,894,895,900,906,908,908,910,911,913,929,931,939,962,962,975,982,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1008,1010,1012,1013,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,1415,1415,1564,1564,1653,1656,2392,2399,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2908,2909,3635,3635,3763,3763,3804,3805,3852,3852,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3961,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,4256,4293,4295,4295,4301,4301,4348,4348,4447,4448,5112,5117,6068,6069,6155,6159,7296,7304,7312,7354,7357,7359,7468,7470,7472,7482,7484,7501,7503,7530,7544,7544,7579,7615,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7834,7835,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8049,8049,8051,8051,8053,8053,8055,8055,8057,8057,8059,8059,8061,8061,8064,8111,8114,8116,8119,8132,8135,8143,8147,8147,8152,8155,8157,8159,8163,8163,8168,8175,8178,8180,8183,8190,8192,8207,8209,8209,8215,8215,8228,8230,8234,8239,8243,8244,8246,8247,8252,8252,8254,8254,8263,8265,8279,8279,8287,8305,8308,8334,8336,8348,8360,8360,8448,8451,8453,8455,8457,8467,8469,8470,8473,8477,8480,8482,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8507,8512,8517,8521,8528,8575,8579,8579,8585,8585,8748,8749,8751,8752,9001,9002,9312,9450,10764,10764,10868,10870,10972,10972,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11388,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,11631,11631,11935,11935,12019,12019,12032,12245,12288,12288,12342,12342,12344,12346,12443,12444,12447,12447,12543,12543,12593,12686,12690,12703,12800,12830,12832,12871,12880,12926,12928,13311,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42652,42653,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42864,42864,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42994,42997,43000,43001,43868,43871,43881,43881,43888,43967,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65020,65024,65049,65072,65092,65095,65106,65108,65126,65128,65131,65136,65138,65140,65140,65142,65276,65279,65279,65281,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,65520,65528,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,67457,67461,67463,67504,67506,67514,68736,68786,71840,71871,93760,93791,113824,113827,119134,119140,119155,119162,119227,119232,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,122928,122989,125184,125217,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127232,127242,127248,127278,127280,127311,127338,127340,127376,127376,127488,127490,127504,127547,127552,127560,127568,127569,130032,130041,194560,195101,917504,921599 }); }
	static private void addProperty95() { addProperty("emoji", new int[] { 35,35,42,42,48,57,169,169,174,174,8252,8252,8265,8265,8482,8482,8505,8505,8596,8601,8617,8618,8986,8987,9000,9000,9167,9167,9193,9203,9208,9210,9410,9410,9642,9643,9654,9654,9664,9664,9723,9726,9728,9732,9742,9742,9745,9745,9748,9749,9752,9752,9757,9757,9760,9760,9762,9763,9766,9766,9770,9770,9774,9775,9784,9786,9792,9792,9794,9794,9800,9811,9823,9824,9827,9827,9829,9830,9832,9832,9851,9851,9854,9855,9874,9879,9881,9881,9883,9884,9888,9889,9895,9895,9898,9899,9904,9905,9917,9918,9924,9925,9928,9928,9934,9935,9937,9937,9939,9940,9961,9962,9968,9973,9975,9978,9981,9981,9986,9986,9989,9989,9992,9997,9999,9999,10002,10002,10004,10004,10006,10006,10013,10013,10017,10017,10024,10024,10035,10036,10052,10052,10055,10055,10060,10060,10062,10062,10067,10069,10071,10071,10083,10084,10133,10135,10145,10145,10160,10160,10175,10175,10548,10549,11013,11015,11035,11036,11088,11088,11093,11093,12336,12336,12349,12349,12951,12951,12953,12953,126980,126980,127183,127183,127344,127345,127358,127359,127374,127374,127377,127386,127462,127487,127489,127490,127514,127514,127535,127535,127538,127546,127568,127569,127744,127777,127780,127891,127894,127895,127897,127899,127902,127984,127987,127989,127991,128253,128255,128317,128329,128334,128336,128359,128367,128368,128371,128378,128391,128391,128394,128397,128400,128400,128405,128406,128420,128421,128424,128424,128433,128434,128444,128444,128450,128452,128465,128467,128476,128478,128481,128481,128483,128483,128488,128488,128495,128495,128499,128499,128506,128591,128640,128709,128715,128722,128725,128727,128732,128741,128745,128745,128747,128748,128752,128752,128755,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty96() { addProperty("epres", new int[] { 8986,8987,9193,9196,9200,9200,9203,9203,9725,9726,9748,9749,9800,9811,9855,9855,9875,9875,9889,9889,9898,9899,9917,9918,9924,9925,9934,9934,9940,9940,9962,9962,9970,9971,9973,9973,9978,9978,9981,9981,9989,9989,9994,9995,10024,10024,10060,10060,10062,10062,10067,10069,10071,10071,10133,10135,10160,10160,10175,10175,11035,11036,11088,11088,11093,11093,126980,126980,127183,127183,127374,127374,127377,127386,127462,127487,127489,127489,127514,127514,127535,127535,127538,127542,127544,127546,127568,127569,127744,127776,127789,127797,127799,127868,127870,127891,127904,127946,127951,127955,127968,127984,127988,127988,127992,128062,128064,128064,128066,128252,128255,128317,128331,128334,128336,128359,128378,128378,128405,128406,128420,128420,128507,128591,128640,128709,128716,128716,128720,128722,128725,128727,128732,128735,128747,128748,128756,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty97() { addProperty("emod", new int[] { 127995,127999 }); }
	static private void addProperty98() { addProperty("ebase", new int[] { 9757,9757,9977,9977,9994,9997,127877,127877,127938,127940,127943,127943,127946,127948,128066,128067,128070,128080,128102,128120,128124,128124,128129,128131,128133,128135,128143,128143,128145,128145,128170,128170,128372,128373,128378,128378,128400,128400,128405,128406,128581,128583,128587,128591,128675,128675,128692,128694,128704,128704,128716,128716,129292,129292,129295,129295,129304,129311,129318,129318,129328,129337,129340,129342,129399,129399,129461,129462,129464,129465,129467,129467,129485,129487,129489,129501,129731,129733,129776,129784 }); }
	static private void addProperty99() { addProperty("ecomp", new int[] { 35,35,42,42,48,57,8205,8205,8419,8419,65039,65039,127462,127487,127995,127999,129456,129459,917536,917631 }); }
	static private void addProperty100() { addProperty("ri", new int[] { 127462,127487 }); }
	static private void addProperty101() { addProperty("pcm", new int[] { 1536,1541,1757,1757,1807,1807,2192,2193,2274,2274,69821,69821,69837,69837 }); }
	static private void addProperty102() { addProperty("extpict", new int[] { 169,169,174,174,8252,8252,8265,8265,8482,8482,8505,8505,8596,8601,8617,8618,8986,8987,9000,9000,9096,9096,9167,9167,9193,9203,9208,9210,9410,9410,9642,9643,9654,9654,9664,9664,9723,9726,9728,9733,9735,9746,9748,9861,9872,9989,9992,10002,10004,10004,10006,10006,10013,10013,10017,10017,10024,10024,10035,10036,10052,10052,10055,10055,10060,10060,10062,10062,10067,10069,10071,10071,10083,10087,10133,10135,10145,10145,10160,10160,10175,10175,10548,10549,11013,11015,11035,11036,11088,11088,11093,11093,12336,12336,12349,12349,12951,12951,12953,12953,126976,127231,127245,127247,127279,127279,127340,127345,127358,127359,127374,127374,127377,127386,127405,127461,127489,127503,127514,127514,127535,127535,127538,127546,127548,127551,127561,127994,128000,128317,128326,128591,128640,128767,128884,128895,128981,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129279,129292,129338,129340,129349,129351,129791,130048,131069 }); }
	static private void addProperty103() { addProperty("basic_emoji", new int[] { 8986,8987,9193,9196,9200,9200,9203,9203,9725,9726,9748,9749,9800,9811,9855,9855,9875,9875,9889,9889,9898,9899,9917,9918,9924,9925,9934,9934,9940,9940,9962,9962,9970,9971,9973,9973,9978,9978,9981,9981,9989,9989,9994,9995,10024,10024,10060,10060,10062,10062,10067,10069,10071,10071,10133,10135,10160,10160,10175,10175,11035,11036,11088,11088,11093,11093,126980,126980,127183,127183,127374,127374,127377,127386,127489,127489,127514,127514,127535,127535,127538,127542,127544,127546,127568,127569,127744,127776,127789,127797,127799,127868,127870,127891,127904,127946,127951,127955,127968,127984,127988,127988,127992,128062,128064,128064,128066,128252,128255,128317,128331,128334,128336,128359,128378,128378,128405,128406,128420,128420,128507,128591,128640,128709,128716,128716,128720,128722,128725,128727,128732,128735,128747,128748,128756,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty104() { addProperty("emoji_keycap_sequence", new int[] {  }); }
	static private void addProperty105() { addProperty("rgi_emoji_modifier_sequence", new int[] {  }); }
	static private void addProperty106() { addProperty("rgi_emoji_flag_sequence", new int[] {  }); }
	static private void addProperty107() { addProperty("rgi_emoji_tag_sequence", new int[] {  }); }
	static private void addProperty108() { addProperty("rgi_emoji_zwj_sequence", new int[] {  }); }
	static private void addProperty109() { addProperty("rgi_emoji", new int[] { 8986,8987,9193,9196,9200,9200,9203,9203,9725,9726,9748,9749,9800,9811,9855,9855,9875,9875,9889,9889,9898,9899,9917,9918,9924,9925,9934,9934,9940,9940,9962,9962,9970,9971,9973,9973,9978,9978,9981,9981,9989,9989,9994,9995,10024,10024,10060,10060,10062,10062,10067,10069,10071,10071,10133,10135,10160,10160,10175,10175,11035,11036,11088,11088,11093,11093,126980,126980,127183,127183,127374,127374,127377,127386,127489,127489,127514,127514,127535,127535,127538,127542,127544,127546,127568,127569,127744,127776,127789,127797,127799,127868,127870,127891,127904,127946,127951,127955,127968,127984,127988,127988,127992,128062,128064,128064,128066,128252,128255,128317,128331,128334,128336,128359,128378,128378,128405,128406,128420,128420,128507,128591,128640,128709,128716,128716,128720,128722,128725,128727,128732,128735,128747,128748,128756,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty110() { addProperty("bc=l", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,696,699,705,720,721,736,740,750,750,880,883,886,893,895,899,902,902,904,1013,1015,1154,1162,1417,1419,1420,2307,2361,2363,2363,2365,2368,2377,2380,2382,2384,2392,2401,2404,2432,2434,2491,2493,2496,2501,2508,2510,2529,2532,2545,2548,2554,2556,2557,2559,2560,2563,2619,2621,2624,2627,2630,2633,2634,2638,2640,2642,2671,2674,2676,2678,2688,2691,2747,2749,2752,2758,2758,2761,2764,2766,2785,2788,2800,2802,2809,2816,2816,2818,2875,2877,2878,2880,2880,2885,2892,2894,2900,2903,2913,2916,2945,2947,3007,3009,3020,3022,3058,3067,3071,3073,3075,3077,3131,3133,3133,3137,3141,3145,3145,3150,3156,3159,3169,3172,3191,3199,3200,3202,3259,3261,3275,3278,3297,3300,3327,3330,3386,3389,3392,3397,3404,3406,3425,3428,3456,3458,3529,3531,3537,3541,3541,3543,3632,3634,3635,3643,3646,3648,3654,3663,3760,3762,3763,3773,3783,3791,3863,3866,3892,3894,3894,3896,3896,3902,3952,3967,3967,3973,3973,3976,3980,3992,3992,4029,4037,4039,4140,4145,4145,4152,4152,4155,4156,4159,4183,4186,4189,4193,4208,4213,4225,4227,4228,4231,4236,4238,4252,4254,4956,4960,5007,5018,5119,5121,5759,5761,5786,5789,5905,5909,5937,5940,5969,5972,6001,6004,6067,6070,6070,6078,6085,6087,6088,6100,6106,6108,6108,6110,6127,6138,6143,6160,6276,6279,6312,6314,6431,6435,6438,6441,6449,6451,6456,6460,6463,6465,6467,6470,6621,6656,6678,6681,6682,6684,6741,6743,6743,6751,6751,6753,6753,6755,6756,6765,6770,6781,6782,6784,6831,6863,6911,6916,6963,6965,6965,6971,6971,6973,6977,6979,7018,7028,7039,7042,7073,7078,7079,7082,7082,7086,7141,7143,7143,7146,7148,7150,7150,7154,7211,7220,7221,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7680,8124,8126,8126,8130,8140,8144,8156,8160,8172,8176,8188,8191,8191,8206,8206,8305,8307,8319,8319,8335,8351,8433,8447,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8527,8544,8584,8588,8591,9014,9082,9109,9109,9255,9279,9291,9311,9372,9449,9900,9900,10240,10495,11124,11125,11158,11158,11264,11492,11499,11502,11506,11512,11520,11646,11648,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12293,12295,12321,12329,12334,12335,12337,12341,12344,12348,12352,12440,12445,12447,12449,12538,12540,12735,12772,12828,12831,12879,12896,12923,12927,12976,12992,13003,13008,13174,13179,13277,13280,13310,13312,19903,19968,42127,42183,42508,42512,42606,42624,42653,42656,42735,42738,42751,42786,42887,42889,43009,43011,43013,43015,43018,43020,43044,43047,43047,43053,43063,43066,43123,43128,43203,43206,43231,43250,43262,43264,43301,43310,43334,43346,43391,43395,43442,43444,43445,43450,43451,43454,43492,43494,43560,43567,43568,43571,43572,43575,43586,43588,43595,43597,43643,43645,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43755,43758,43765,43767,43881,43884,44004,44006,44007,44009,44012,44014,64284,65050,65055,65107,65107,65127,65127,65132,65135,65280,65280,65313,65338,65345,65370,65382,65503,65511,65511,65519,65519,65536,65792,65794,65855,65933,65935,65949,65951,65953,66044,66046,66271,66300,66421,66427,67583,69632,69632,69634,69687,69703,69713,69734,69743,69745,69746,69749,69758,69762,69810,69815,69816,69819,69825,69827,69887,69891,69926,69932,69932,69941,70002,70004,70015,70018,70069,70079,70088,70093,70094,70096,70190,70194,70195,70197,70197,70200,70205,70207,70208,70210,70366,70368,70370,70379,70399,70402,70458,70461,70463,70465,70501,70509,70511,70517,70711,70720,70721,70725,70725,70727,70749,70751,70834,70841,70841,70843,70846,70849,70849,70852,71089,71094,71099,71102,71102,71105,71131,71134,71218,71227,71228,71230,71230,71233,71263,71277,71338,71340,71340,71342,71343,71350,71350,71352,71452,71456,71457,71462,71462,71468,71726,71736,71736,71739,71994,71997,71997,71999,72002,72004,72147,72152,72153,72156,72159,72161,72192,72199,72200,72203,72242,72249,72250,72255,72262,72264,72272,72279,72280,72284,72329,72343,72343,72346,72751,72759,72759,72766,72849,72872,72873,72881,72881,72884,72884,72887,73008,73015,73017,73019,73019,73022,73022,73030,73030,73032,73103,73106,73108,73110,73110,73112,73458,73461,73471,73474,73525,73531,73535,73537,73537,73539,73684,73714,78911,78913,78918,78934,92911,92917,92975,92983,94030,94032,94094,94099,94177,94179,94179,94181,113820,113823,113823,113828,118527,118574,118575,118599,119142,119146,119154,119171,119172,119180,119209,119214,119272,119275,119295,119366,119551,119639,120538,120540,120596,120598,120654,120656,120712,120714,120770,120772,120781,120832,121343,121399,121402,121453,121460,121462,121475,121477,121498,121504,121504,121520,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,123646,123648,124139,124144,124927,127020,127023,127124,127135,127151,127152,127168,127168,127184,127184,127222,127231,127248,127278,127280,127337,127344,127404,127406,127583,127590,127743,128728,128731,128749,128751,128765,128767,128887,128890,128986,128991,129004,129007,129009,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129199,129202,129279,129620,129631,129646,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,129791,129939,129939,129995,130031,130042,131069,131072,196605,196608,262141,262144,327677,327680,393213,393216,458749,458752,524285,524288,589821,589824,655357,655360,720893,720896,786429,786432,851965,851968,917501,921600,983037,983040,1048573,1048576,1114109 }); }
	static private void addProperty111() { addProperty("bc=r", new int[] { 1424,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1535,1984,2026,2036,2037,2042,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2143,8207,8207,64285,64285,64287,64296,64298,64335,67584,67870,67872,68096,68100,68100,68103,68107,68112,68151,68155,68158,68160,68324,68327,68408,68416,68863,68928,69215,69247,69290,69293,69311,69376,69423,69488,69505,69510,69631,124928,125135,125143,125251,125259,126063,126144,126207,126288,126463,126720,126975 }); }
	static private void addProperty112() { addProperty("bc=en", new int[] { 48,57,178,179,185,185,1776,1785,8304,8304,8308,8313,8320,8329,9352,9371,65296,65305,66273,66299,120782,120831,127232,127242,130032,130041 }); }
	static private void addProperty113() { addProperty("bc=es", new int[] { 43,43,45,45,8314,8315,8330,8331,8722,8722,64297,64297,65122,65123,65291,65291,65293,65293 }); }
	static private void addProperty114() { addProperty("bc=et", new int[] { 35,37,162,165,176,177,1423,1423,1545,1546,1642,1642,2546,2547,2555,2555,2801,2801,3065,3065,3647,3647,6107,6107,8240,8244,8352,8399,8494,8494,8723,8723,43064,43065,65119,65119,65129,65130,65283,65285,65504,65505,65509,65510,73693,73696,123647,123647 }); }
	static private void addProperty115() { addProperty("bc=an", new int[] { 1536,1541,1632,1641,1643,1644,1757,1757,2192,2193,2274,2274,68912,68921,69216,69246 }); }
	static private void addProperty116() { addProperty("bc=cs", new int[] { 44,44,46,47,58,58,160,160,1548,1548,8239,8239,8260,8260,65104,65104,65106,65106,65109,65109,65292,65292,65294,65295,65306,65306 }); }
	static private void addProperty117() { addProperty("bc=b", new int[] { 10,10,13,13,28,30,133,133,8233,8233 }); }
	static private void addProperty118() { addProperty("bc=s", new int[] { 9,9,11,11,31,31 }); }
	static private void addProperty119() { addProperty("bc=ws", new int[] { 12,12,32,32,5760,5760,8192,8202,8232,8232,8287,8287,12288,12288 }); }
	static private void addProperty120() { addProperty("bc=on", new int[] { 33,34,38,42,59,64,91,96,123,126,161,161,166,169,171,172,174,175,180,180,182,184,187,191,215,215,247,247,697,698,706,719,722,735,741,749,751,767,884,885,894,894,900,901,903,903,1014,1014,1418,1418,1421,1422,1542,1543,1550,1551,1758,1758,1769,1769,2038,2041,3059,3064,3066,3066,3192,3198,3898,3901,5008,5017,5120,5120,5787,5788,6128,6137,6144,6154,6464,6464,6468,6469,6622,6655,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,8208,8231,8245,8259,8261,8286,8316,8318,8332,8334,8448,8449,8451,8454,8456,8457,8468,8468,8470,8472,8478,8483,8485,8485,8487,8487,8489,8489,8506,8507,8512,8516,8522,8525,8528,8543,8585,8587,8592,8721,8724,9013,9083,9108,9110,9254,9280,9290,9312,9351,9450,9899,9901,10239,10496,11123,11126,11157,11159,11263,11493,11498,11513,11519,11776,11869,11904,11929,11931,12019,12032,12245,12272,12283,12289,12292,12296,12320,12336,12336,12342,12343,12349,12351,12443,12444,12448,12448,12539,12539,12736,12771,12829,12830,12880,12895,12924,12926,12977,12991,13004,13007,13175,13178,13278,13279,13311,13311,19904,19967,42128,42182,42509,42511,42611,42611,42622,42623,42752,42785,42888,42888,43048,43051,43124,43127,43882,43883,64830,64847,64975,64975,65021,65023,65040,65049,65072,65103,65105,65105,65108,65108,65110,65118,65120,65121,65124,65126,65128,65128,65131,65131,65281,65282,65286,65290,65307,65312,65339,65344,65371,65381,65506,65508,65512,65518,65529,65533,65793,65793,65856,65932,65936,65948,65952,65952,67871,67871,68409,68415,69714,69733,71264,71276,73685,73692,73697,73713,94178,94178,119273,119274,119296,119361,119365,119365,119552,119638,120539,120539,120597,120597,120655,120655,120713,120713,120771,120771,126704,126705,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127243,127247,127279,127279,127338,127343,127405,127405,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994 }); }
	static private void addProperty121() { addProperty("bc=lre", new int[] { 8234,8234 }); }
	static private void addProperty122() { addProperty("bc=lro", new int[] { 8237,8237 }); }
	static private void addProperty123() { addProperty("bc=al", new int[] { 1544,1544,1547,1547,1549,1549,1563,1610,1645,1647,1649,1749,1765,1766,1774,1775,1786,1808,1810,1839,1867,1957,1969,1983,2144,2191,2194,2199,2208,2249,64336,64829,64848,64974,65008,65020,65136,65278,68864,68899,68904,68911,68922,68927,69312,69372,69424,69445,69457,69487,126064,126143,126208,126287,126464,126703,126706,126719 }); }
	static private void addProperty124() { addProperty("bc=rle", new int[] { 8235,8235 }); }
	static private void addProperty125() { addProperty("bc=rlo", new int[] { 8238,8238 }); }
	static private void addProperty126() { addProperty("bc=pdf", new int[] { 8236,8236 }); }
	static private void addProperty127() { addProperty("bc=nsm", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2497,2500,2509,2509,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2879,2879,2881,2884,2893,2893,2901,2902,2914,2915,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3276,3277,3298,3299,3328,3329,3387,3388,3393,3396,3405,3405,3426,3427,3457,3457,3530,3530,3538,3540,3542,3542,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6862,6912,6915,6964,6964,6966,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8400,8432,11503,11505,11647,11647,11744,11775,12330,12333,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70464,70464,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70835,70840,70842,70842,70847,70848,70850,70851,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72198,72201,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,118528,118573,118576,118598,119143,119145,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917760,917999 }); }
	static private void addProperty128() { addProperty("bc=bn", new int[] { 0,8,14,27,127,132,134,159,173,173,6158,6158,8203,8205,8288,8293,8298,8303,64976,65007,65279,65279,65520,65528,65534,65535,113824,113827,119155,119162,131070,131071,196606,196607,262142,262143,327678,327679,393214,393215,458750,458751,524286,524287,589822,589823,655358,655359,720894,720895,786430,786431,851966,851967,917502,917759,918000,921599,983038,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty129() { addProperty("bc=fsi", new int[] { 8296,8296 }); }
	static private void addProperty130() { addProperty("bc=lri", new int[] { 8294,8294 }); }
	static private void addProperty131() { addProperty("bc=rli", new int[] { 8295,8295 }); }
	static private void addProperty132() { addProperty("bc=pdi", new int[] { 8297,8297 }); }
	static private void addProperty133() { addProperty("blk=nb", new int[] { 12256,12271,66048,66175,66528,66559,67008,67071,67520,67583,67760,67807,67904,67967,68256,68287,68528,68607,68688,68735,68928,69215,70224,70271,70528,70655,70880,71039,71376,71423,71504,71679,71760,71839,72032,72095,72544,72703,72896,72959,73136,73439,73568,73647,75088,77711,78944,82943,83584,92159,93072,93759,93856,93951,94112,94175,101760,110575,111360,113663,113840,118527,118736,118783,119376,119487,119680,119807,121520,122623,123024,123135,123216,123535,123648,124111,124160,124895,125152,125183,125280,126063,126144,126207,126288,126463,126720,126975,130048,131071,173792,173823,191472,194559,195104,196607,205744,917503,917632,917759,918000,983039 }); }
	static private void addProperty134() { addProperty("blk=ascii", new int[] { 0,127 }); }
	static private void addProperty135() { addProperty("blk=latin_1_sup", new int[] { 128,255 }); }
	static private void addProperty136() { addProperty("blk=latin_ext_a", new int[] { 256,383 }); }
	static private void addProperty137() { addProperty("blk=latin_ext_b", new int[] { 384,591 }); }
	static private void addProperty138() { addProperty("blk=ipa_ext", new int[] { 592,687 }); }
	static private void addProperty139() { addProperty("blk=modifier_letters", new int[] { 688,767 }); }
	static private void addProperty140() { addProperty("blk=diacriticals", new int[] { 768,879 }); }
	static private void addProperty141() { addProperty("blk=greek", new int[] { 880,1023 }); }
	static private void addProperty142() { addProperty("blk=cyrillic", new int[] { 1024,1279 }); }
	static private void addProperty143() { addProperty("blk=armenian", new int[] { 1328,1423 }); }
	static private void addProperty144() { addProperty("blk=hebrew", new int[] { 1424,1535 }); }
	static private void addProperty145() { addProperty("blk=arabic", new int[] { 1536,1791 }); }
	static private void addProperty146() { addProperty("blk=syriac", new int[] { 1792,1871 }); }
	static private void addProperty147() { addProperty("blk=thaana", new int[] { 1920,1983 }); }
	static private void addProperty148() { addProperty("blk=devanagari", new int[] { 2304,2431 }); }
	static private void addProperty149() { addProperty("blk=bengali", new int[] { 2432,2559 }); }
	static private void addProperty150() { addProperty("blk=gurmukhi", new int[] { 2560,2687 }); }
	static private void addProperty151() { addProperty("blk=gujarati", new int[] { 2688,2815 }); }
	static private void addProperty152() { addProperty("blk=oriya", new int[] { 2816,2943 }); }
	static private void addProperty153() { addProperty("blk=tamil", new int[] { 2944,3071 }); }
	static private void addProperty154() { addProperty("blk=telugu", new int[] { 3072,3199 }); }
	static private void addProperty155() { addProperty("blk=kannada", new int[] { 3200,3327 }); }
	static private void addProperty156() { addProperty("blk=malayalam", new int[] { 3328,3455 }); }
	static private void addProperty157() { addProperty("blk=sinhala", new int[] { 3456,3583 }); }
	static private void addProperty158() { addProperty("blk=thai", new int[] { 3584,3711 }); }
	static private void addProperty159() { addProperty("blk=lao", new int[] { 3712,3839 }); }
	static private void addProperty160() { addProperty("blk=tibetan", new int[] { 3840,4095 }); }
	static private void addProperty161() { addProperty("blk=myanmar", new int[] { 4096,4255 }); }
	static private void addProperty162() { addProperty("blk=georgian", new int[] { 4256,4351 }); }
	static private void addProperty163() { addProperty("blk=jamo", new int[] { 4352,4607 }); }
	static private void addProperty164() { addProperty("blk=ethiopic", new int[] { 4608,4991 }); }
	static private void addProperty165() { addProperty("blk=cherokee", new int[] { 5024,5119 }); }
	static private void addProperty166() { addProperty("blk=ucas", new int[] { 5120,5759 }); }
	static private void addProperty167() { addProperty("blk=ogham", new int[] { 5760,5791 }); }
	static private void addProperty168() { addProperty("blk=runic", new int[] { 5792,5887 }); }
	static private void addProperty169() { addProperty("blk=khmer", new int[] { 6016,6143 }); }
	static private void addProperty170() { addProperty("blk=mongolian", new int[] { 6144,6319 }); }
	static private void addProperty171() { addProperty("blk=latin_ext_additional", new int[] { 7680,7935 }); }
	static private void addProperty172() { addProperty("blk=greek_ext", new int[] { 7936,8191 }); }
	static private void addProperty173() { addProperty("blk=punctuation", new int[] { 8192,8303 }); }
	static private void addProperty174() { addProperty("blk=super_and_sub", new int[] { 8304,8351 }); }
	static private void addProperty175() { addProperty("blk=currency_symbols", new int[] { 8352,8399 }); }
	static private void addProperty176() { addProperty("blk=diacriticals_for_symbols", new int[] { 8400,8447 }); }
	static private void addProperty177() { addProperty("blk=letterlike_symbols", new int[] { 8448,8527 }); }
	static private void addProperty178() { addProperty("blk=number_forms", new int[] { 8528,8591 }); }
	static private void addProperty179() { addProperty("blk=arrows", new int[] { 8592,8703 }); }
	static private void addProperty180() { addProperty("blk=math_operators", new int[] { 8704,8959 }); }
	static private void addProperty181() { addProperty("blk=misc_technical", new int[] { 8960,9215 }); }
	static private void addProperty182() { addProperty("blk=control_pictures", new int[] { 9216,9279 }); }
	static private void addProperty183() { addProperty("blk=ocr", new int[] { 9280,9311 }); }
	static private void addProperty184() { addProperty("blk=enclosed_alphanum", new int[] { 9312,9471 }); }
	static private void addProperty185() { addProperty("blk=box_drawing", new int[] { 9472,9599 }); }
	static private void addProperty186() { addProperty("blk=block_elements", new int[] { 9600,9631 }); }
	static private void addProperty187() { addProperty("blk=geometric_shapes", new int[] { 9632,9727 }); }
	static private void addProperty188() { addProperty("blk=misc_symbols", new int[] { 9728,9983 }); }
	static private void addProperty189() { addProperty("blk=dingbats", new int[] { 9984,10175 }); }
	static private void addProperty190() { addProperty("blk=braille", new int[] { 10240,10495 }); }
	static private void addProperty191() { addProperty("blk=cjk_radicals_sup", new int[] { 11904,12031 }); }
	static private void addProperty192() { addProperty("blk=kangxi", new int[] { 12032,12255 }); }
	static private void addProperty193() { addProperty("blk=idc", new int[] { 12272,12287 }); }
	static private void addProperty194() { addProperty("blk=cjk_symbols", new int[] { 12288,12351 }); }
	static private void addProperty195() { addProperty("blk=hiragana", new int[] { 12352,12447 }); }
	static private void addProperty196() { addProperty("blk=katakana", new int[] { 12448,12543 }); }
	static private void addProperty197() { addProperty("blk=bopomofo", new int[] { 12544,12591 }); }
	static private void addProperty198() { addProperty("blk=compat_jamo", new int[] { 12592,12687 }); }
	static private void addProperty199() { addProperty("blk=kanbun", new int[] { 12688,12703 }); }
	static private void addProperty200() { addProperty("blk=bopomofo_ext", new int[] { 12704,12735 }); }
	static private void addProperty201() { addProperty("blk=enclosed_cjk", new int[] { 12800,13055 }); }
	static private void addProperty202() { addProperty("blk=cjk_compat", new int[] { 13056,13311 }); }
	static private void addProperty203() { addProperty("blk=cjk_ext_a", new int[] { 13312,19903 }); }
	static private void addProperty204() { addProperty("blk=cjk", new int[] { 19968,40959 }); }
	static private void addProperty205() { addProperty("blk=yi_syllables", new int[] { 40960,42127 }); }
	static private void addProperty206() { addProperty("blk=yi_radicals", new int[] { 42128,42191 }); }
	static private void addProperty207() { addProperty("blk=hangul", new int[] { 44032,55215 }); }
	static private void addProperty208() { addProperty("blk=high_surrogates", new int[] { 55296,56191 }); }
	static private void addProperty209() { addProperty("blk=high_pu_surrogates", new int[] { 56192,56319 }); }
	static private void addProperty210() { addProperty("blk=low_surrogates", new int[] { 56320,57343 }); }
	static private void addProperty211() { addProperty("blk=pua", new int[] { 57344,63743 }); }
	static private void addProperty212() { addProperty("blk=cjk_compat_ideographs", new int[] { 63744,64255 }); }
	static private void addProperty213() { addProperty("blk=alphabetic_pf", new int[] { 64256,64335 }); }
	static private void addProperty214() { addProperty("blk=arabic_pf_a", new int[] { 64336,65023 }); }
	static private void addProperty215() { addProperty("blk=half_marks", new int[] { 65056,65071 }); }
	static private void addProperty216() { addProperty("blk=cjk_compat_forms", new int[] { 65072,65103 }); }
	static private void addProperty217() { addProperty("blk=small_forms", new int[] { 65104,65135 }); }
	static private void addProperty218() { addProperty("blk=arabic_pf_b", new int[] { 65136,65279 }); }
	static private void addProperty219() { addProperty("blk=specials", new int[] { 65520,65535 }); }
	static private void addProperty220() { addProperty("blk=half_and_full_forms", new int[] { 65280,65519 }); }
	static private void addProperty221() { addProperty("blk=old_italic", new int[] { 66304,66351 }); }
	static private void addProperty222() { addProperty("blk=gothic", new int[] { 66352,66383 }); }
	static private void addProperty223() { addProperty("blk=deseret", new int[] { 66560,66639 }); }
	static private void addProperty224() { addProperty("blk=byzantine_music", new int[] { 118784,119039 }); }
	static private void addProperty225() { addProperty("blk=music", new int[] { 119040,119295 }); }
	static private void addProperty226() { addProperty("blk=math_alphanum", new int[] { 119808,120831 }); }
	static private void addProperty227() { addProperty("blk=cjk_ext_b", new int[] { 131072,173791 }); }
	static private void addProperty228() { addProperty("blk=cjk_compat_ideographs_sup", new int[] { 194560,195103 }); }
	static private void addProperty229() { addProperty("blk=tags", new int[] { 917504,917631 }); }
	static private void addProperty230() { addProperty("blk=cyrillic_sup", new int[] { 1280,1327 }); }
	static private void addProperty231() { addProperty("blk=tagalog", new int[] { 5888,5919 }); }
	static private void addProperty232() { addProperty("blk=hanunoo", new int[] { 5920,5951 }); }
	static private void addProperty233() { addProperty("blk=buhid", new int[] { 5952,5983 }); }
	static private void addProperty234() { addProperty("blk=tagbanwa", new int[] { 5984,6015 }); }
	static private void addProperty235() { addProperty("blk=misc_math_symbols_a", new int[] { 10176,10223 }); }
	static private void addProperty236() { addProperty("blk=sup_arrows_a", new int[] { 10224,10239 }); }
	static private void addProperty237() { addProperty("blk=sup_arrows_b", new int[] { 10496,10623 }); }
	static private void addProperty238() { addProperty("blk=misc_math_symbols_b", new int[] { 10624,10751 }); }
	static private void addProperty239() { addProperty("blk=sup_math_operators", new int[] { 10752,11007 }); }
	static private void addProperty240() { addProperty("blk=katakana_ext", new int[] { 12784,12799 }); }
	static private void addProperty241() { addProperty("blk=vs", new int[] { 65024,65039 }); }
	static private void addProperty242() { addProperty("blk=sup_pua_a", new int[] { 983040,1048575 }); }
	static private void addProperty243() { addProperty("blk=sup_pua_b", new int[] { 1048576,1114111 }); }
	static private void addProperty244() { addProperty("blk=limbu", new int[] { 6400,6479 }); }
	static private void addProperty245() { addProperty("blk=tai_le", new int[] { 6480,6527 }); }
	static private void addProperty246() { addProperty("blk=khmer_symbols", new int[] { 6624,6655 }); }
	static private void addProperty247() { addProperty("blk=phonetic_ext", new int[] { 7424,7551 }); }
	static private void addProperty248() { addProperty("blk=misc_arrows", new int[] { 11008,11263 }); }
	static private void addProperty249() { addProperty("blk=yijing", new int[] { 19904,19967 }); }
	static private void addProperty250() { addProperty("blk=linear_b_syllabary", new int[] { 65536,65663 }); }
	static private void addProperty251() { addProperty("blk=linear_b_ideograms", new int[] { 65664,65791 }); }
	static private void addProperty252() { addProperty("blk=aegean_numbers", new int[] { 65792,65855 }); }
	static private void addProperty253() { addProperty("blk=ugaritic", new int[] { 66432,66463 }); }
	static private void addProperty254() { addProperty("blk=shavian", new int[] { 66640,66687 }); }
	static private void addProperty255() { addProperty("blk=osmanya", new int[] { 66688,66735 }); }
	static private void addProperty256() { addProperty("blk=cypriot_syllabary", new int[] { 67584,67647 }); }
	static private void addProperty257() { addProperty("blk=tai_xuan_jing", new int[] { 119552,119647 }); }
	static private void addProperty258() { addProperty("blk=vs_sup", new int[] { 917760,917999 }); }
	static private void addProperty259() { addProperty("blk=ancient_greek_music", new int[] { 119296,119375 }); }
	static private void addProperty260() { addProperty("blk=ancient_greek_numbers", new int[] { 65856,65935 }); }
	static private void addProperty261() { addProperty("blk=arabic_sup", new int[] { 1872,1919 }); }
	static private void addProperty262() { addProperty("blk=buginese", new int[] { 6656,6687 }); }
	static private void addProperty263() { addProperty("blk=cjk_strokes", new int[] { 12736,12783 }); }
	static private void addProperty264() { addProperty("blk=diacriticals_sup", new int[] { 7616,7679 }); }
	static private void addProperty265() { addProperty("blk=coptic", new int[] { 11392,11519 }); }
	static private void addProperty266() { addProperty("blk=ethiopic_ext", new int[] { 11648,11743 }); }
	static private void addProperty267() { addProperty("blk=ethiopic_sup", new int[] { 4992,5023 }); }
	static private void addProperty268() { addProperty("blk=georgian_sup", new int[] { 11520,11567 }); }
	static private void addProperty269() { addProperty("blk=glagolitic", new int[] { 11264,11359 }); }
	static private void addProperty270() { addProperty("blk=kharoshthi", new int[] { 68096,68191 }); }
	static private void addProperty271() { addProperty("blk=modifier_tone_letters", new int[] { 42752,42783 }); }
	static private void addProperty272() { addProperty("blk=new_tai_lue", new int[] { 6528,6623 }); }
	static private void addProperty273() { addProperty("blk=old_persian", new int[] { 66464,66527 }); }
	static private void addProperty274() { addProperty("blk=phonetic_ext_sup", new int[] { 7552,7615 }); }
	static private void addProperty275() { addProperty("blk=sup_punctuation", new int[] { 11776,11903 }); }
	static private void addProperty276() { addProperty("blk=syloti_nagri", new int[] { 43008,43055 }); }
	static private void addProperty277() { addProperty("blk=tifinagh", new int[] { 11568,11647 }); }
	static private void addProperty278() { addProperty("blk=vertical_forms", new int[] { 65040,65055 }); }
	static private void addProperty279() { addProperty("blk=nko", new int[] { 1984,2047 }); }
	static private void addProperty280() { addProperty("blk=balinese", new int[] { 6912,7039 }); }
	static private void addProperty281() { addProperty("blk=latin_ext_c", new int[] { 11360,11391 }); }
	static private void addProperty282() { addProperty("blk=latin_ext_d", new int[] { 42784,43007 }); }
	static private void addProperty283() { addProperty("blk=phags_pa", new int[] { 43072,43135 }); }
	static private void addProperty284() { addProperty("blk=phoenician", new int[] { 67840,67871 }); }
	static private void addProperty285() { addProperty("blk=cuneiform", new int[] { 73728,74751 }); }
	static private void addProperty286() { addProperty("blk=cuneiform_numbers", new int[] { 74752,74879 }); }
	static private void addProperty287() { addProperty("blk=counting_rod", new int[] { 119648,119679 }); }
	static private void addProperty288() { addProperty("blk=sundanese", new int[] { 7040,7103 }); }
	static private void addProperty289() { addProperty("blk=lepcha", new int[] { 7168,7247 }); }
	static private void addProperty290() { addProperty("blk=ol_chiki", new int[] { 7248,7295 }); }
	static private void addProperty291() { addProperty("blk=cyrillic_ext_a", new int[] { 11744,11775 }); }
	static private void addProperty292() { addProperty("blk=vai", new int[] { 42240,42559 }); }
	static private void addProperty293() { addProperty("blk=cyrillic_ext_b", new int[] { 42560,42655 }); }
	static private void addProperty294() { addProperty("blk=saurashtra", new int[] { 43136,43231 }); }
	static private void addProperty295() { addProperty("blk=kayah_li", new int[] { 43264,43311 }); }
	static private void addProperty296() { addProperty("blk=rejang", new int[] { 43312,43359 }); }
	static private void addProperty297() { addProperty("blk=cham", new int[] { 43520,43615 }); }
	static private void addProperty298() { addProperty("blk=ancient_symbols", new int[] { 65936,65999 }); }
	static private void addProperty299() { addProperty("blk=phaistos", new int[] { 66000,66047 }); }
	static private void addProperty300() { addProperty("blk=lycian", new int[] { 66176,66207 }); }
	static private void addProperty301() { addProperty("blk=carian", new int[] { 66208,66271 }); }
	static private void addProperty302() { addProperty("blk=lydian", new int[] { 67872,67903 }); }
	static private void addProperty303() { addProperty("blk=mahjong", new int[] { 126976,127023 }); }
	static private void addProperty304() { addProperty("blk=domino", new int[] { 127024,127135 }); }
	static private void addProperty305() { addProperty("blk=samaritan", new int[] { 2048,2111 }); }
	static private void addProperty306() { addProperty("blk=ucas_ext", new int[] { 6320,6399 }); }
	static private void addProperty307() { addProperty("blk=tai_tham", new int[] { 6688,6831 }); }
	static private void addProperty308() { addProperty("blk=vedic_ext", new int[] { 7376,7423 }); }
	static private void addProperty309() { addProperty("blk=lisu", new int[] { 42192,42239 }); }
	static private void addProperty310() { addProperty("blk=bamum", new int[] { 42656,42751 }); }
	static private void addProperty311() { addProperty("blk=indic_number_forms", new int[] { 43056,43071 }); }
	static private void addProperty312() { addProperty("blk=devanagari_ext", new int[] { 43232,43263 }); }
	static private void addProperty313() { addProperty("blk=jamo_ext_a", new int[] { 43360,43391 }); }
	static private void addProperty314() { addProperty("blk=javanese", new int[] { 43392,43487 }); }
	static private void addProperty315() { addProperty("blk=myanmar_ext_a", new int[] { 43616,43647 }); }
	static private void addProperty316() { addProperty("blk=tai_viet", new int[] { 43648,43743 }); }
	static private void addProperty317() { addProperty("blk=meetei_mayek", new int[] { 43968,44031 }); }
	static private void addProperty318() { addProperty("blk=jamo_ext_b", new int[] { 55216,55295 }); }
	static private void addProperty319() { addProperty("blk=imperial_aramaic", new int[] { 67648,67679 }); }
	static private void addProperty320() { addProperty("blk=old_south_arabian", new int[] { 68192,68223 }); }
	static private void addProperty321() { addProperty("blk=avestan", new int[] { 68352,68415 }); }
	static private void addProperty322() { addProperty("blk=inscriptional_parthian", new int[] { 68416,68447 }); }
	static private void addProperty323() { addProperty("blk=inscriptional_pahlavi", new int[] { 68448,68479 }); }
	static private void addProperty324() { addProperty("blk=old_turkic", new int[] { 68608,68687 }); }
	static private void addProperty325() { addProperty("blk=rumi", new int[] { 69216,69247 }); }
	static private void addProperty326() { addProperty("blk=kaithi", new int[] { 69760,69839 }); }
	static private void addProperty327() { addProperty("blk=egyptian_hieroglyphs", new int[] { 77824,78895 }); }
	static private void addProperty328() { addProperty("blk=enclosed_alphanum_sup", new int[] { 127232,127487 }); }
	static private void addProperty329() { addProperty("blk=enclosed_ideographic_sup", new int[] { 127488,127743 }); }
	static private void addProperty330() { addProperty("blk=cjk_ext_c", new int[] { 173824,177983 }); }
	static private void addProperty331() { addProperty("blk=mandaic", new int[] { 2112,2143 }); }
	static private void addProperty332() { addProperty("blk=batak", new int[] { 7104,7167 }); }
	static private void addProperty333() { addProperty("blk=ethiopic_ext_a", new int[] { 43776,43823 }); }
	static private void addProperty334() { addProperty("blk=brahmi", new int[] { 69632,69759 }); }
	static private void addProperty335() { addProperty("blk=bamum_sup", new int[] { 92160,92735 }); }
	static private void addProperty336() { addProperty("blk=kana_sup", new int[] { 110592,110847 }); }
	static private void addProperty337() { addProperty("blk=playing_cards", new int[] { 127136,127231 }); }
	static private void addProperty338() { addProperty("blk=misc_pictographs", new int[] { 127744,128511 }); }
	static private void addProperty339() { addProperty("blk=emoticons", new int[] { 128512,128591 }); }
	static private void addProperty340() { addProperty("blk=transport_and_map", new int[] { 128640,128767 }); }
	static private void addProperty341() { addProperty("blk=alchemical", new int[] { 128768,128895 }); }
	static private void addProperty342() { addProperty("blk=cjk_ext_d", new int[] { 177984,178207 }); }
	static private void addProperty343() { addProperty("blk=arabic_ext_a", new int[] { 2208,2303 }); }
	static private void addProperty344() { addProperty("blk=arabic_math", new int[] { 126464,126719 }); }
	static private void addProperty345() { addProperty("blk=chakma", new int[] { 69888,69967 }); }
	static private void addProperty346() { addProperty("blk=meetei_mayek_ext", new int[] { 43744,43775 }); }
	static private void addProperty347() { addProperty("blk=meroitic_cursive", new int[] { 68000,68095 }); }
	static private void addProperty348() { addProperty("blk=meroitic_hieroglyphs", new int[] { 67968,67999 }); }
	static private void addProperty349() { addProperty("blk=miao", new int[] { 93952,94111 }); }
	static private void addProperty350() { addProperty("blk=sharada", new int[] { 70016,70111 }); }
	static private void addProperty351() { addProperty("blk=sora_sompeng", new int[] { 69840,69887 }); }
	static private void addProperty352() { addProperty("blk=sundanese_sup", new int[] { 7360,7375 }); }
	static private void addProperty353() { addProperty("blk=takri", new int[] { 71296,71375 }); }
	static private void addProperty354() { addProperty("blk=bassa_vah", new int[] { 92880,92927 }); }
	static private void addProperty355() { addProperty("blk=caucasian_albanian", new int[] { 66864,66927 }); }
	static private void addProperty356() { addProperty("blk=coptic_epact_numbers", new int[] { 66272,66303 }); }
	static private void addProperty357() { addProperty("blk=diacriticals_ext", new int[] { 6832,6911 }); }
	static private void addProperty358() { addProperty("blk=duployan", new int[] { 113664,113823 }); }
	static private void addProperty359() { addProperty("blk=elbasan", new int[] { 66816,66863 }); }
	static private void addProperty360() { addProperty("blk=geometric_shapes_ext", new int[] { 128896,129023 }); }
	static private void addProperty361() { addProperty("blk=grantha", new int[] { 70400,70527 }); }
	static private void addProperty362() { addProperty("blk=khojki", new int[] { 70144,70223 }); }
	static private void addProperty363() { addProperty("blk=khudawadi", new int[] { 70320,70399 }); }
	static private void addProperty364() { addProperty("blk=latin_ext_e", new int[] { 43824,43887 }); }
	static private void addProperty365() { addProperty("blk=linear_a", new int[] { 67072,67455 }); }
	static private void addProperty366() { addProperty("blk=mahajani", new int[] { 69968,70015 }); }
	static private void addProperty367() { addProperty("blk=manichaean", new int[] { 68288,68351 }); }
	static private void addProperty368() { addProperty("blk=mende_kikakui", new int[] { 124928,125151 }); }
	static private void addProperty369() { addProperty("blk=modi", new int[] { 71168,71263 }); }
	static private void addProperty370() { addProperty("blk=mro", new int[] { 92736,92783 }); }
	static private void addProperty371() { addProperty("blk=myanmar_ext_b", new int[] { 43488,43519 }); }
	static private void addProperty372() { addProperty("blk=nabataean", new int[] { 67712,67759 }); }
	static private void addProperty373() { addProperty("blk=old_north_arabian", new int[] { 68224,68255 }); }
	static private void addProperty374() { addProperty("blk=old_permic", new int[] { 66384,66431 }); }
	static private void addProperty375() { addProperty("blk=ornamental_dingbats", new int[] { 128592,128639 }); }
	static private void addProperty376() { addProperty("blk=pahawh_hmong", new int[] { 92928,93071 }); }
	static private void addProperty377() { addProperty("blk=palmyrene", new int[] { 67680,67711 }); }
	static private void addProperty378() { addProperty("blk=pau_cin_hau", new int[] { 72384,72447 }); }
	static private void addProperty379() { addProperty("blk=psalter_pahlavi", new int[] { 68480,68527 }); }
	static private void addProperty380() { addProperty("blk=shorthand_format_controls", new int[] { 113824,113839 }); }
	static private void addProperty381() { addProperty("blk=siddham", new int[] { 71040,71167 }); }
	static private void addProperty382() { addProperty("blk=sinhala_archaic_numbers", new int[] { 70112,70143 }); }
	static private void addProperty383() { addProperty("blk=sup_arrows_c", new int[] { 129024,129279 }); }
	static private void addProperty384() { addProperty("blk=tirhuta", new int[] { 70784,70879 }); }
	static private void addProperty385() { addProperty("blk=warang_citi", new int[] { 71840,71935 }); }
	static private void addProperty386() { addProperty("blk=ahom", new int[] { 71424,71503 }); }
	static private void addProperty387() { addProperty("blk=anatolian_hieroglyphs", new int[] { 82944,83583 }); }
	static private void addProperty388() { addProperty("blk=cherokee_sup", new int[] { 43888,43967 }); }
	static private void addProperty389() { addProperty("blk=cjk_ext_e", new int[] { 178208,183983 }); }
	static private void addProperty390() { addProperty("blk=early_dynastic_cuneiform", new int[] { 74880,75087 }); }
	static private void addProperty391() { addProperty("blk=hatran", new int[] { 67808,67839 }); }
	static private void addProperty392() { addProperty("blk=multani", new int[] { 70272,70319 }); }
	static private void addProperty393() { addProperty("blk=old_hungarian", new int[] { 68736,68863 }); }
	static private void addProperty394() { addProperty("blk=sup_symbols_and_pictographs", new int[] { 129280,129535 }); }
	static private void addProperty395() { addProperty("blk=sutton_signwriting", new int[] { 120832,121519 }); }
	static private void addProperty396() { addProperty("blk=adlam", new int[] { 125184,125279 }); }
	static private void addProperty397() { addProperty("blk=bhaiksuki", new int[] { 72704,72815 }); }
	static private void addProperty398() { addProperty("blk=cyrillic_ext_c", new int[] { 7296,7311 }); }
	static private void addProperty399() { addProperty("blk=glagolitic_sup", new int[] { 122880,122927 }); }
	static private void addProperty400() { addProperty("blk=ideographic_symbols", new int[] { 94176,94207 }); }
	static private void addProperty401() { addProperty("blk=marchen", new int[] { 72816,72895 }); }
	static private void addProperty402() { addProperty("blk=mongolian_sup", new int[] { 71264,71295 }); }
	static private void addProperty403() { addProperty("blk=newa", new int[] { 70656,70783 }); }
	static private void addProperty404() { addProperty("blk=osage", new int[] { 66736,66815 }); }
	static private void addProperty405() { addProperty("blk=tangut", new int[] { 94208,100351 }); }
	static private void addProperty406() { addProperty("blk=tangut_components", new int[] { 100352,101119 }); }
	static private void addProperty407() { addProperty("blk=cjk_ext_f", new int[] { 183984,191471 }); }
	static private void addProperty408() { addProperty("blk=kana_ext_a", new int[] { 110848,110895 }); }
	static private void addProperty409() { addProperty("blk=masaram_gondi", new int[] { 72960,73055 }); }
	static private void addProperty410() { addProperty("blk=nushu", new int[] { 110960,111359 }); }
	static private void addProperty411() { addProperty("blk=soyombo", new int[] { 72272,72367 }); }
	static private void addProperty412() { addProperty("blk=syriac_sup", new int[] { 2144,2159 }); }
	static private void addProperty413() { addProperty("blk=zanabazar_square", new int[] { 72192,72271 }); }
	static private void addProperty414() { addProperty("blk=chess_symbols", new int[] { 129536,129647 }); }
	static private void addProperty415() { addProperty("blk=dogra", new int[] { 71680,71759 }); }
	static private void addProperty416() { addProperty("blk=georgian_ext", new int[] { 7312,7359 }); }
	static private void addProperty417() { addProperty("blk=gunjala_gondi", new int[] { 73056,73135 }); }
	static private void addProperty418() { addProperty("blk=hanifi_rohingya", new int[] { 68864,68927 }); }
	static private void addProperty419() { addProperty("blk=indic_siyaq_numbers", new int[] { 126064,126143 }); }
	static private void addProperty420() { addProperty("blk=makasar", new int[] { 73440,73471 }); }
	static private void addProperty421() { addProperty("blk=mayan_numerals", new int[] { 119520,119551 }); }
	static private void addProperty422() { addProperty("blk=medefaidrin", new int[] { 93760,93855 }); }
	static private void addProperty423() { addProperty("blk=old_sogdian", new int[] { 69376,69423 }); }
	static private void addProperty424() { addProperty("blk=sogdian", new int[] { 69424,69487 }); }
	static private void addProperty425() { addProperty("blk=egyptian_hieroglyph_format_controls", new int[] { 78896,78943 }); }
	static private void addProperty426() { addProperty("blk=elymaic", new int[] { 69600,69631 }); }
	static private void addProperty427() { addProperty("blk=nandinagari", new int[] { 72096,72191 }); }
	static private void addProperty428() { addProperty("blk=nyiakeng_puachue_hmong", new int[] { 123136,123215 }); }
	static private void addProperty429() { addProperty("blk=ottoman_siyaq_numbers", new int[] { 126208,126287 }); }
	static private void addProperty430() { addProperty("blk=small_kana_ext", new int[] { 110896,110959 }); }
	static private void addProperty431() { addProperty("blk=symbols_and_pictographs_ext_a", new int[] { 129648,129791 }); }
	static private void addProperty432() { addProperty("blk=tamil_sup", new int[] { 73664,73727 }); }
	static private void addProperty433() { addProperty("blk=wancho", new int[] { 123584,123647 }); }
	static private void addProperty434() { addProperty("blk=chorasmian", new int[] { 69552,69599 }); }
	static private void addProperty435() { addProperty("blk=cjk_ext_g", new int[] { 196608,201551 }); }
	static private void addProperty436() { addProperty("blk=dives_akuru", new int[] { 71936,72031 }); }
	static private void addProperty437() { addProperty("blk=khitan_small_script", new int[] { 101120,101631 }); }
	static private void addProperty438() { addProperty("blk=lisu_sup", new int[] { 73648,73663 }); }
	static private void addProperty439() { addProperty("blk=symbols_for_legacy_computing", new int[] { 129792,130047 }); }
	static private void addProperty440() { addProperty("blk=tangut_sup", new int[] { 101632,101759 }); }
	static private void addProperty441() { addProperty("blk=yezidi", new int[] { 69248,69311 }); }
	static private void addProperty442() { addProperty("blk=arabic_ext_b", new int[] { 2160,2207 }); }
	static private void addProperty443() { addProperty("blk=cypro_minoan", new int[] { 77712,77823 }); }
	static private void addProperty444() { addProperty("blk=ethiopic_ext_b", new int[] { 124896,124927 }); }
	static private void addProperty445() { addProperty("blk=kana_ext_b", new int[] { 110576,110591 }); }
	static private void addProperty446() { addProperty("blk=latin_ext_f", new int[] { 67456,67519 }); }
	static private void addProperty447() { addProperty("blk=latin_ext_g", new int[] { 122624,122879 }); }
	static private void addProperty448() { addProperty("blk=old_uyghur", new int[] { 69488,69551 }); }
	static private void addProperty449() { addProperty("blk=tangsa", new int[] { 92784,92879 }); }
	static private void addProperty450() { addProperty("blk=toto", new int[] { 123536,123583 }); }
	static private void addProperty451() { addProperty("blk=ucas_ext_a", new int[] { 72368,72383 }); }
	static private void addProperty452() { addProperty("blk=vithkuqi", new int[] { 66928,67007 }); }
	static private void addProperty453() { addProperty("blk=znamenny_music", new int[] { 118528,118735 }); }
	static private void addProperty454() { addProperty("blk=arabic_ext_c", new int[] { 69312,69375 }); }
	static private void addProperty455() { addProperty("blk=cjk_ext_h", new int[] { 201552,205743 }); }
	static private void addProperty456() { addProperty("blk=cyrillic_ext_d", new int[] { 122928,123023 }); }
	static private void addProperty457() { addProperty("blk=devanagari_ext_a", new int[] { 72448,72543 }); }
	static private void addProperty458() { addProperty("blk=kaktovik_numerals", new int[] { 119488,119519 }); }
	static private void addProperty459() { addProperty("blk=kawi", new int[] { 73472,73567 }); }
	static private void addProperty460() { addProperty("blk=nag_mundari", new int[] { 124112,124159 }); }
	static private void addProperty461() { addProperty("ccc=nr", new int[] { 0,767,847,847,880,1154,1160,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1610,1632,1647,1649,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2363,2365,2380,2382,2384,2389,2491,2493,2508,2510,2557,2559,2619,2621,2636,2638,2747,2749,2764,2766,2875,2877,2892,2894,3020,3022,3131,3133,3148,3150,3156,3159,3259,3261,3276,3278,3386,3389,3404,3406,3529,3531,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3952,3955,3955,3957,3961,3966,3967,3969,3969,3973,3973,3976,4037,4039,4150,4152,4152,4155,4236,4238,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6963,6965,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7680,8399,8413,8416,8418,8420,8433,11502,11506,11646,11648,11743,11776,12329,12336,12440,12443,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,64285,64287,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69816,69819,69887,69891,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70476,70478,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70849,70852,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119140,119146,119148,119155,119162,119171,119172,119180,119209,119214,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,1114111 }); }
	static private void addProperty462() { addProperty("ccc=ov", new int[] { 820,824,7380,7380,7394,7400,8402,8403,8408,8410,8421,8422,8426,8427,68153,68153,92912,92916,113822,113822,119143,119145 }); }
	static private void addProperty463() { addProperty("ccc=null", new int[] {  }); }
	static private void addProperty464() { addProperty("ccc=hanr", new int[] { 94192,94193 }); }
	static private void addProperty465() { addProperty("ccc=nk", new int[] { 2364,2364,2492,2492,2620,2620,2748,2748,2876,2876,3132,3132,3260,3260,4151,4151,6964,6964,7142,7142,7223,7223,43443,43443,69818,69818,70003,70003,70090,70090,70198,70198,70377,70377,70459,70460,70726,70726,70851,70851,71104,71104,71351,71351,71738,71738,72003,72003,73026,73026,125258,125258 }); }
	static private void addProperty466() { addProperty("ccc=kv", new int[] { 12441,12442 }); }
	static private void addProperty467() { addProperty("ccc=vr", new int[] { 2381,2381,2509,2509,2637,2637,2765,2765,2893,2893,3021,3021,3149,3149,3277,3277,3387,3388,3405,3405,3530,3530,3642,3642,3770,3770,3972,3972,4153,4154,5908,5909,5940,5940,6098,6098,6752,6752,6980,6980,7082,7083,7154,7155,11647,11647,43014,43014,43052,43052,43204,43204,43347,43347,43456,43456,43766,43766,44013,44013,68159,68159,69702,69702,69744,69744,69759,69759,69817,69817,69939,69940,70080,70080,70197,70197,70378,70378,70477,70477,70722,70722,70850,70850,71103,71103,71231,71231,71350,71350,71467,71467,71737,71737,71997,71998,72160,72160,72244,72244,72263,72263,72345,72345,72767,72767,73028,73029,73111,73111,73537,73538 }); }
	static private void addProperty468() { addProperty("ccc=ccc10", new int[] { 1456,1456 }); }
	static private void addProperty469() { addProperty("ccc=ccc11", new int[] { 1457,1457 }); }
	static private void addProperty470() { addProperty("ccc=ccc12", new int[] { 1458,1458 }); }
	static private void addProperty471() { addProperty("ccc=ccc13", new int[] { 1459,1459 }); }
	static private void addProperty472() { addProperty("ccc=ccc14", new int[] { 1460,1460 }); }
	static private void addProperty473() { addProperty("ccc=ccc15", new int[] { 1461,1461 }); }
	static private void addProperty474() { addProperty("ccc=ccc16", new int[] { 1462,1462 }); }
	static private void addProperty475() { addProperty("ccc=ccc17", new int[] { 1463,1463 }); }
	static private void addProperty476() { addProperty("ccc=ccc18", new int[] { 1464,1464,1479,1479 }); }
	static private void addProperty477() { addProperty("ccc=ccc19", new int[] { 1465,1466 }); }
	static private void addProperty478() { addProperty("ccc=ccc20", new int[] { 1467,1467 }); }
	static private void addProperty479() { addProperty("ccc=ccc21", new int[] { 1468,1468 }); }
	static private void addProperty480() { addProperty("ccc=ccc22", new int[] { 1469,1469 }); }
	static private void addProperty481() { addProperty("ccc=ccc23", new int[] { 1471,1471 }); }
	static private void addProperty482() { addProperty("ccc=ccc24", new int[] { 1473,1473 }); }
	static private void addProperty483() { addProperty("ccc=ccc25", new int[] { 1474,1474 }); }
	static private void addProperty484() { addProperty("ccc=ccc26", new int[] { 64286,64286 }); }
	static private void addProperty485() { addProperty("ccc=ccc27", new int[] { 1611,1611,2288,2288 }); }
	static private void addProperty486() { addProperty("ccc=ccc28", new int[] { 1612,1612,2289,2289 }); }
	static private void addProperty487() { addProperty("ccc=ccc29", new int[] { 1613,1613,2290,2290 }); }
	static private void addProperty488() { addProperty("ccc=ccc30", new int[] { 1560,1560,1614,1614 }); }
	static private void addProperty489() { addProperty("ccc=ccc31", new int[] { 1561,1561,1615,1615 }); }
	static private void addProperty490() { addProperty("ccc=ccc32", new int[] { 1562,1562,1616,1616 }); }
	static private void addProperty491() { addProperty("ccc=ccc33", new int[] { 1617,1617 }); }
	static private void addProperty492() { addProperty("ccc=ccc34", new int[] { 1618,1618 }); }
	static private void addProperty493() { addProperty("ccc=ccc35", new int[] { 1648,1648 }); }
	static private void addProperty494() { addProperty("ccc=ccc36", new int[] { 1809,1809 }); }
	static private void addProperty495() { addProperty("ccc=ccc84", new int[] { 3157,3157 }); }
	static private void addProperty496() { addProperty("ccc=ccc91", new int[] { 3158,3158 }); }
	static private void addProperty497() { addProperty("ccc=ccc103", new int[] { 3640,3641 }); }
	static private void addProperty498() { addProperty("ccc=ccc107", new int[] { 3656,3659 }); }
	static private void addProperty499() { addProperty("ccc=ccc118", new int[] { 3768,3769 }); }
	static private void addProperty500() { addProperty("ccc=ccc122", new int[] { 3784,3787 }); }
	static private void addProperty501() { addProperty("ccc=ccc129", new int[] { 3953,3953 }); }
	static private void addProperty502() { addProperty("ccc=ccc130", new int[] { 3954,3954,3962,3965,3968,3968 }); }
	static private void addProperty503() { addProperty("ccc=ccc132", new int[] { 3956,3956 }); }
	static private void addProperty504() { addProperty("ccc=ccc133", new int[] {  }); }
	static private void addProperty505() { addProperty("ccc=atbl", new int[] {  }); }
	static private void addProperty506() { addProperty("ccc=atb", new int[] { 801,802,807,808,7632,7632 }); }
	static private void addProperty507() { addProperty("ccc=ata", new int[] { 7630,7630 }); }
	static private void addProperty508() { addProperty("ccc=atar", new int[] { 795,795,3897,3897,119141,119142,119150,119154 }); }
	static private void addProperty509() { addProperty("ccc=bl", new int[] { 7674,7674,12330,12330 }); }
	static private void addProperty510() { addProperty("ccc=b", new int[] { 790,793,796,800,803,806,809,819,825,828,839,841,845,846,851,854,857,858,1425,1425,1430,1430,1435,1435,1442,1447,1450,1450,1477,1477,1621,1622,1628,1628,1631,1631,1763,1763,1770,1770,1773,1773,1841,1841,1844,1844,1847,1849,1851,1852,1854,1854,1858,1858,1860,1860,1862,1862,1864,1864,2034,2034,2045,2045,2137,2139,2201,2203,2255,2259,2275,2275,2278,2278,2281,2281,2285,2287,2294,2294,2297,2298,2386,2386,3864,3865,3893,3893,3895,3895,4038,4038,4237,4237,6459,6459,6680,6680,6783,6783,6837,6842,6845,6845,6847,6848,6851,6852,6858,6858,7020,7020,7381,7385,7388,7391,7405,7405,7618,7618,7626,7626,7631,7631,7673,7673,7677,7677,7679,7679,8424,8424,8428,8431,43307,43309,43700,43700,65063,65069,66045,66045,66272,66272,68109,68109,68154,68154,68326,68326,69373,69375,69446,69447,69451,69451,69453,69456,69507,69507,69509,69509,119163,119170,119178,119179,124142,124142,125136,125142 }); }
	static private void addProperty511() { addProperty("ccc=br", new int[] { 1434,1434,1453,1453,6457,6457,12333,12333 }); }
	static private void addProperty512() { addProperty("ccc=l", new int[] { 12334,12335 }); }
	static private void addProperty513() { addProperty("ccc=r", new int[] { 119149,119149 }); }
	static private void addProperty514() { addProperty("ccc=al", new int[] { 1454,1454,6313,6313,7671,7672,12331,12331 }); }
	static private void addProperty515() { addProperty("ccc=a", new int[] { 768,788,829,836,838,838,842,844,848,850,855,855,859,859,867,879,1155,1159,1426,1429,1431,1433,1436,1441,1448,1449,1451,1452,1455,1455,1476,1476,1552,1559,1619,1620,1623,1627,1629,1630,1750,1756,1759,1762,1764,1764,1767,1768,1771,1772,1840,1840,1842,1843,1845,1846,1850,1850,1853,1853,1855,1857,1859,1859,1861,1861,1863,1863,1865,1866,2027,2033,2035,2035,2070,2073,2075,2083,2085,2087,2089,2093,2200,2200,2204,2207,2250,2254,2260,2273,2276,2277,2279,2280,2282,2284,2291,2293,2295,2296,2299,2303,2385,2385,2387,2388,2558,2558,3970,3971,3974,3975,4957,4959,6109,6109,6458,6458,6679,6679,6773,6780,6832,6836,6843,6844,6849,6850,6853,6857,6859,6862,7019,7019,7021,7027,7376,7378,7386,7387,7392,7392,7412,7412,7416,7417,7616,7617,7619,7625,7627,7628,7633,7669,7675,7675,7678,7678,8400,8401,8404,8407,8411,8412,8417,8417,8423,8423,8425,8425,8432,8432,11503,11505,11744,11775,42607,42607,42612,42621,42654,42655,42736,42737,43232,43249,43696,43696,43698,43699,43703,43704,43710,43711,43713,43713,65056,65062,65070,65071,66422,66426,68111,68111,68152,68152,68325,68325,68900,68903,69291,69292,69448,69450,69452,69452,69506,69506,69508,69508,69888,69890,70502,70508,70512,70516,70750,70750,92976,92982,119173,119177,119210,119213,119362,119364,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124143,124143,125252,125257 }); }
	static private void addProperty516() { addProperty("ccc=ar", new int[] { 789,789,794,794,856,856,7670,7670,12332,12332,124140,124141 }); }
	static private void addProperty517() { addProperty("ccc=db", new int[] { 860,860,863,863,866,866,7676,7676 }); }
	static private void addProperty518() { addProperty("ccc=da", new int[] { 861,862,864,865,7629,7629 }); }
	static private void addProperty519() { addProperty("ccc=is", new int[] { 837,837 }); }
	static private void addProperty520() { addProperty("dt=none", new int[] { 0,159,161,167,169,169,171,174,176,177,182,183,187,187,191,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,305,312,312,321,322,330,331,338,339,358,359,384,415,418,430,433,451,477,477,484,485,502,503,540,541,544,549,564,687,697,727,734,735,741,831,834,834,837,883,885,889,891,893,895,899,907,907,909,909,913,937,945,969,975,975,983,1007,1011,1011,1014,1016,1018,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1414,1416,1569,1575,1652,1657,1727,1729,1729,1731,1746,1748,2344,2346,2352,2354,2355,2357,2391,2400,2506,2509,2523,2526,2526,2528,2610,2612,2613,2615,2648,2652,2653,2655,2887,2889,2890,2893,2907,2910,2963,2965,3017,3021,3143,3145,3263,3265,3270,3273,3273,3276,3401,3405,3545,3547,3547,3551,3634,3636,3762,3764,3803,3806,3851,3853,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3954,3956,3956,3962,3968,3970,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4133,4135,4347,4349,6917,6919,6919,6921,6921,6923,6923,6925,6925,6927,6929,6931,6970,6972,6972,6974,6975,6978,6978,6980,7467,7471,7471,7483,7483,7502,7502,7531,7543,7545,7578,7616,7679,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8203,8208,8210,8214,8216,8227,8231,8238,8240,8242,8245,8245,8248,8251,8253,8253,8255,8262,8266,8278,8280,8286,8288,8303,8306,8307,8335,8335,8349,8359,8361,8447,8452,8452,8456,8456,8468,8468,8471,8472,8478,8479,8483,8483,8485,8485,8487,8487,8489,8489,8494,8494,8498,8498,8506,8506,8513,8516,8522,8527,8576,8584,8586,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8747,8750,8750,8753,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,9000,9003,9311,9451,10763,10765,10867,10871,10971,10973,11387,11390,11630,11632,11934,11936,12018,12020,12031,12246,12287,12289,12341,12343,12343,12347,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12442,12445,12445,12448,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12544,12592,12687,12689,12704,12799,12831,12831,12872,12879,12927,12927,13312,42651,42654,42863,42865,42993,42997,42999,43002,43867,43872,43880,43882,44031,55204,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64255,64263,64274,64280,64284,64286,64286,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65021,65039,65050,65071,65093,65094,65107,65107,65127,65127,65132,65135,65139,65139,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,67456,67462,67462,67505,67505,67515,69785,69787,69787,69789,69802,69804,69933,69936,70474,70477,70842,70845,70845,70847,71097,71100,71991,71993,119133,119141,119226,119233,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,120832,122927,122990,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127231,127243,127247,127279,127279,127312,127337,127341,127375,127377,127487,127491,127503,127548,127551,127561,127567,127570,130031,130042,194559,195102,1114111 }); }
	static private void addProperty521() { addProperty("dt=can", new int[] { 192,197,199,207,209,214,217,221,224,229,231,239,241,246,249,253,255,271,274,293,296,304,308,311,313,318,323,328,332,337,340,357,360,382,416,417,431,432,461,476,478,483,486,496,500,501,504,539,542,543,550,563,832,833,835,836,884,884,894,894,901,906,908,908,910,912,938,944,970,974,979,980,1024,1025,1027,1027,1031,1031,1036,1038,1049,1049,1081,1081,1104,1105,1107,1107,1111,1111,1116,1118,1142,1143,1217,1218,1232,1235,1238,1239,1242,1247,1250,1255,1258,1269,1272,1273,1570,1574,1728,1728,1730,1730,1747,1747,2345,2345,2353,2353,2356,2356,2392,2399,2507,2508,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2888,2888,2891,2892,2908,2909,2964,2964,3018,3020,3144,3144,3264,3264,3271,3272,3274,3275,3402,3404,3546,3546,3548,3550,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3958,3960,3960,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,4134,4134,6918,6918,6920,6920,6922,6922,6924,6924,6926,6926,6930,6930,6971,6971,6973,6973,6976,6977,6979,6979,7680,7833,7835,7835,7840,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8129,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8189,8192,8193,8486,8486,8490,8491,8602,8603,8622,8622,8653,8655,8708,8708,8713,8713,8716,8716,8740,8740,8742,8742,8769,8769,8772,8772,8775,8775,8777,8777,8800,8800,8802,8802,8813,8817,8820,8821,8824,8825,8832,8833,8836,8837,8840,8841,8876,8879,8928,8931,8938,8941,9001,9002,10972,10972,12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12386,12389,12389,12391,12391,12393,12393,12400,12401,12403,12404,12406,12407,12409,12410,12412,12413,12436,12436,12446,12446,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12482,12485,12485,12487,12487,12489,12489,12496,12497,12499,12500,12502,12503,12505,12506,12508,12509,12532,12532,12535,12538,12542,12542,44032,55203,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64285,64285,64287,64287,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64334,69786,69786,69788,69788,69803,69803,69934,69935,70475,70476,70843,70844,70846,70846,71098,71099,71992,71992,119134,119140,119227,119232,194560,195101 }); }
	static private void addProperty522() { addProperty("dt=com", new int[] { 168,168,175,175,180,181,184,184,306,307,319,320,329,329,383,383,452,460,497,499,728,733,890,890,900,900,976,978,981,982,1008,1010,1012,1013,1017,1017,1415,1415,1653,1656,3635,3635,3763,3763,3804,3805,3959,3959,3961,3961,7834,7834,8125,8125,8127,8128,8190,8190,8194,8198,8200,8202,8215,8215,8228,8230,8243,8244,8246,8247,8252,8252,8254,8254,8263,8265,8279,8279,8287,8287,8360,8360,8448,8449,8451,8451,8453,8455,8457,8457,8470,8470,8481,8481,8501,8504,8507,8507,8544,8575,8748,8749,8751,8752,9332,9397,10764,10764,10868,10870,11935,11935,12019,12019,12032,12245,12342,12342,12344,12346,12443,12444,12593,12686,12800,12830,12832,12867,12992,13003,13144,13168,13280,13310,64256,64262,64275,64279,64335,64335,65097,65103,127232,127242,127248,127274,127552,127560 }); }
	static private void addProperty523() { addProperty("dt=enc", new int[] { 9312,9331,9398,9450,12868,12871,12881,12926,12928,12991,13008,13054,127275,127278,127568,127569 }); }
	static private void addProperty524() { addProperty("dt=fin", new int[] { 64337,64337,64339,64339,64343,64343,64347,64347,64351,64351,64355,64355,64359,64359,64363,64363,64367,64367,64371,64371,64375,64375,64379,64379,64383,64383,64387,64387,64389,64389,64391,64391,64393,64393,64395,64395,64397,64397,64399,64399,64403,64403,64407,64407,64411,64411,64415,64415,64417,64417,64421,64421,64423,64423,64427,64427,64431,64431,64433,64433,64468,64468,64472,64472,64474,64474,64476,64476,64479,64479,64481,64481,64483,64483,64485,64485,64491,64491,64493,64493,64495,64495,64497,64497,64499,64499,64501,64501,64503,64503,64506,64506,64509,64509,64612,64662,64785,64812,64828,64828,64849,64849,64856,64856,64858,64859,64862,64863,64866,64866,64868,64868,64870,64871,64873,64874,64876,64876,64878,64879,64881,64881,64884,64886,64888,64892,64894,64898,64900,64901,64903,64903,64907,64907,64918,64919,64921,64924,64926,64947,64950,64951,64953,64953,64955,64962,64966,64967,65154,65154,65156,65156,65158,65158,65160,65160,65162,65162,65166,65166,65168,65168,65172,65172,65174,65174,65178,65178,65182,65182,65186,65186,65190,65190,65194,65194,65196,65196,65198,65198,65200,65200,65202,65202,65206,65206,65210,65210,65214,65214,65218,65218,65222,65222,65226,65226,65230,65230,65234,65234,65238,65238,65242,65242,65246,65246,65250,65250,65254,65254,65258,65258,65262,65262,65264,65264,65266,65266,65270,65270,65272,65272,65274,65274,65276,65276 }); }
	static private void addProperty525() { addProperty("dt=font", new int[] { 8450,8450,8458,8467,8469,8469,8473,8477,8484,8484,8488,8488,8492,8493,8495,8497,8499,8500,8505,8505,8508,8512,8517,8521,64288,64297,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,130032,130041 }); }
	static private void addProperty526() { addProperty("dt=fra", new int[] { 188,190,8528,8543,8585,8585 }); }
	static private void addProperty527() { addProperty("dt=init", new int[] { 64340,64340,64344,64344,64348,64348,64352,64352,64356,64356,64360,64360,64364,64364,64368,64368,64372,64372,64376,64376,64380,64380,64384,64384,64400,64400,64404,64404,64408,64408,64412,64412,64418,64418,64424,64424,64428,64428,64469,64469,64486,64486,64488,64488,64504,64504,64507,64507,64510,64510,64663,64734,64813,64819,64848,64848,64850,64855,64857,64857,64860,64861,64864,64865,64867,64867,64869,64869,64872,64872,64875,64875,64877,64877,64880,64880,64882,64883,64887,64887,64893,64893,64899,64899,64902,64902,64904,64906,64908,64911,64914,64917,64920,64920,64925,64925,64948,64949,64952,64952,64954,64954,64963,64965,65163,65163,65169,65169,65175,65175,65179,65179,65183,65183,65187,65187,65191,65191,65203,65203,65207,65207,65211,65211,65215,65215,65219,65219,65223,65223,65227,65227,65231,65231,65235,65235,65239,65239,65243,65243,65247,65247,65251,65251,65255,65255,65259,65259,65267,65267 }); }
	static private void addProperty528() { addProperty("dt=iso", new int[] { 64336,64336,64338,64338,64342,64342,64346,64346,64350,64350,64354,64354,64358,64358,64362,64362,64366,64366,64370,64370,64374,64374,64378,64378,64382,64382,64386,64386,64388,64388,64390,64390,64392,64392,64394,64394,64396,64396,64398,64398,64402,64402,64406,64406,64410,64410,64414,64414,64416,64416,64420,64420,64422,64422,64426,64426,64430,64430,64432,64432,64467,64467,64471,64471,64473,64473,64475,64475,64477,64478,64480,64480,64482,64482,64484,64484,64490,64490,64492,64492,64494,64494,64496,64496,64498,64498,64500,64500,64502,64502,64505,64505,64508,64508,64512,64611,64757,64784,64829,64829,65008,65020,65136,65136,65138,65138,65140,65140,65142,65142,65144,65144,65146,65146,65148,65148,65150,65150,65152,65153,65155,65155,65157,65157,65159,65159,65161,65161,65165,65165,65167,65167,65171,65171,65173,65173,65177,65177,65181,65181,65185,65185,65189,65189,65193,65193,65195,65195,65197,65197,65199,65199,65201,65201,65205,65205,65209,65209,65213,65213,65217,65217,65221,65221,65225,65225,65229,65229,65233,65233,65237,65237,65241,65241,65245,65245,65249,65249,65253,65253,65257,65257,65261,65261,65263,65263,65265,65265,65269,65269,65271,65271,65273,65273,65275,65275 }); }
	static private void addProperty529() { addProperty("dt=med", new int[] { 64341,64341,64345,64345,64349,64349,64353,64353,64357,64357,64361,64361,64365,64365,64369,64369,64373,64373,64377,64377,64381,64381,64385,64385,64401,64401,64405,64405,64409,64409,64413,64413,64419,64419,64425,64425,64429,64429,64470,64470,64487,64487,64489,64489,64511,64511,64735,64756,64820,64827,65137,65137,65143,65143,65145,65145,65147,65147,65149,65149,65151,65151,65164,65164,65170,65170,65176,65176,65180,65180,65184,65184,65188,65188,65192,65192,65204,65204,65208,65208,65212,65212,65216,65216,65220,65220,65224,65224,65228,65228,65232,65232,65236,65236,65240,65240,65244,65244,65248,65248,65252,65252,65256,65256,65260,65260,65268,65268 }); }
	static private void addProperty530() { addProperty("dt=nar", new int[] { 65377,65470,65474,65479,65482,65487,65490,65495,65498,65500,65512,65518 }); }
	static private void addProperty531() { addProperty("dt=nb", new int[] { 160,160,3852,3852,8199,8199,8209,8209,8239,8239 }); }
	static private void addProperty532() { addProperty("dt=sml", new int[] { 65104,65106,65108,65126,65128,65131 }); }
	static private void addProperty533() { addProperty("dt=sqr", new int[] { 12880,12880,13004,13007,13055,13143,13169,13279,13311,13311,127280,127311,127376,127376,127488,127490,127504,127547 }); }
	static private void addProperty534() { addProperty("dt=sub", new int[] { 7522,7530,8320,8334,8336,8348,11388,11388,122961,122986 }); }
	static private void addProperty535() { addProperty("dt=sup", new int[] { 170,170,178,179,185,186,688,696,736,740,4348,4348,7468,7470,7472,7482,7484,7501,7503,7521,7544,7544,7579,7615,8304,8305,8308,8319,8480,8480,8482,8482,11389,11389,11631,11631,12690,12703,42652,42653,42864,42864,42994,42996,43000,43001,43868,43871,43881,43881,67457,67461,67463,67504,67506,67514,122928,122960,122987,122989,127338,127340 }); }
	static private void addProperty536() { addProperty("dt=vert", new int[] { 12447,12447,12543,12543,65040,65049,65072,65092,65095,65096 }); }
	static private void addProperty537() { addProperty("dt=wide", new int[] { 12288,12288,65281,65376,65504,65510 }); }
	static private void addProperty538() { addProperty("ea=n", new int[] { 0,31,127,160,169,169,171,171,181,181,187,187,192,197,199,207,209,214,217,221,226,229,231,231,235,235,238,239,241,241,244,246,251,251,253,253,255,256,258,272,274,274,276,282,284,293,296,298,300,304,308,311,313,318,323,323,325,327,332,332,334,337,340,357,360,362,364,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,477,592,594,608,610,707,709,710,712,712,716,716,718,719,721,727,732,732,734,734,736,767,880,912,930,930,938,944,962,962,970,1024,1026,1039,1104,1104,1106,4351,4448,8207,8209,8210,8215,8215,8218,8219,8222,8223,8227,8227,8232,8239,8241,8241,8244,8244,8246,8250,8252,8253,8255,8307,8309,8318,8320,8320,8325,8360,8362,8363,8365,8450,8452,8452,8454,8456,8458,8466,8468,8469,8471,8480,8483,8485,8487,8490,8492,8530,8533,8538,8543,8543,8556,8559,8570,8584,8586,8591,8602,8631,8634,8657,8659,8659,8661,8678,8680,8703,8705,8705,8708,8710,8713,8714,8716,8718,8720,8720,8722,8724,8726,8729,8731,8732,8737,8738,8740,8740,8742,8742,8749,8749,8751,8755,8760,8763,8766,8775,8777,8779,8781,8785,8787,8799,8802,8803,8808,8809,8812,8813,8816,8833,8836,8837,8840,8852,8854,8856,8858,8868,8870,8894,8896,8977,8979,8985,8988,9000,9003,9192,9197,9199,9201,9202,9204,9311,9450,9450,9548,9551,9588,9599,9616,9617,9622,9631,9634,9634,9642,9649,9652,9653,9656,9659,9662,9663,9666,9669,9673,9674,9676,9677,9682,9697,9702,9710,9712,9724,9727,9732,9735,9736,9738,9741,9744,9747,9750,9755,9757,9757,9759,9791,9793,9793,9795,9799,9812,9823,9826,9826,9830,9830,9835,9835,9838,9838,9840,9854,9856,9874,9876,9885,9888,9888,9890,9897,9900,9916,9920,9923,9954,9954,9956,9959,9984,9988,9990,9993,9996,10023,10025,10044,10046,10059,10061,10061,10063,10066,10070,10070,10072,10101,10112,10132,10136,10159,10161,10174,10176,10213,10222,10628,10631,11034,11037,11087,11089,11092,11098,11903,11930,11930,12020,12031,12246,12271,12284,12287,12351,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,19904,19967,42125,42127,42183,43359,43389,44031,55204,57343,64256,65023,65050,65071,65107,65107,65127,65127,65132,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65532,65534,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,126979,126981,127182,127184,127231,127243,127247,127278,127279,127338,127343,127405,127487,127491,127503,127548,127551,127561,127567,127570,127583,127590,127743,127777,127788,127798,127798,127869,127869,127892,127903,127947,127950,127956,127967,127985,127987,127989,127991,128063,128063,128065,128065,128253,128254,128318,128330,128335,128335,128360,128377,128379,128404,128407,128419,128421,128506,128592,128639,128710,128715,128717,128719,128723,128724,128728,128731,128736,128746,128749,128755,128765,128991,129004,129007,129009,129291,129339,129339,129350,129350,129536,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,131071,196606,196607,262142,917759,918000,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty539() { addProperty("ea=a", new int[] { 161,161,164,164,167,168,170,170,173,174,176,180,182,186,188,191,198,198,208,208,215,216,222,225,230,230,232,234,236,237,240,240,242,243,247,250,252,252,254,254,257,257,273,273,275,275,283,283,294,295,299,299,305,307,312,312,319,322,324,324,328,331,333,333,338,339,358,359,363,363,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,476,593,593,609,609,708,708,711,711,713,715,717,717,720,720,728,731,733,733,735,735,768,879,913,929,931,937,945,961,963,969,1025,1025,1040,1103,1105,1105,8208,8208,8211,8214,8216,8217,8220,8221,8224,8226,8228,8231,8240,8240,8242,8243,8245,8245,8251,8251,8254,8254,8308,8308,8319,8319,8321,8324,8364,8364,8451,8451,8453,8453,8457,8457,8467,8467,8470,8470,8481,8482,8486,8486,8491,8491,8531,8532,8539,8542,8544,8555,8560,8569,8585,8585,8592,8601,8632,8633,8658,8658,8660,8660,8679,8679,8704,8704,8706,8707,8711,8712,8715,8715,8719,8719,8721,8721,8725,8725,8730,8730,8733,8736,8739,8739,8741,8741,8743,8748,8750,8750,8756,8759,8764,8765,8776,8776,8780,8780,8786,8786,8800,8801,8804,8807,8810,8811,8814,8815,8834,8835,8838,8839,8853,8853,8857,8857,8869,8869,8895,8895,8978,8978,9312,9449,9451,9547,9552,9587,9600,9615,9618,9621,9632,9633,9635,9641,9650,9651,9654,9655,9660,9661,9664,9665,9670,9672,9675,9675,9678,9681,9698,9701,9711,9711,9733,9734,9737,9737,9742,9743,9756,9756,9758,9758,9792,9792,9794,9794,9824,9825,9827,9829,9831,9834,9836,9837,9839,9839,9886,9887,9919,9919,9926,9933,9935,9939,9941,9953,9955,9955,9960,9961,9963,9969,9972,9972,9974,9977,9979,9980,9982,9983,10045,10045,10102,10111,11094,11097,12872,12879,57344,63743,65024,65039,65533,65533,127232,127242,127248,127277,127280,127337,127344,127373,127375,127376,127387,127404,917760,917999,983040,1048573,1048576,1114109 }); }
	static private void addProperty540() { addProperty("ea=h", new int[] { 8361,8361,65377,65470,65474,65479,65482,65487,65490,65495,65498,65500,65512,65518 }); }
	static private void addProperty541() { addProperty("ea=f", new int[] { 12288,12288,65281,65376,65504,65510 }); }
	static private void addProperty542() { addProperty("ea=na", new int[] { 32,126,162,163,165,166,172,172,175,175,10214,10221,10629,10630 }); }
	static private void addProperty543() { addProperty("ea=w", new int[] { 4352,4447,8986,8987,9001,9002,9193,9196,9200,9200,9203,9203,9725,9726,9748,9749,9800,9811,9855,9855,9875,9875,9889,9889,9898,9899,9917,9918,9924,9925,9934,9934,9940,9940,9962,9962,9970,9971,9973,9973,9978,9978,9981,9981,9989,9989,9994,9995,10024,10024,10060,10060,10062,10062,10067,10069,10071,10071,10133,10135,10160,10160,10175,10175,11035,11036,11088,11088,11093,11093,11904,11929,11931,12019,12032,12245,12272,12283,12289,12350,12353,12438,12441,12543,12549,12591,12593,12686,12688,12771,12784,12830,12832,12871,12880,19903,19968,42124,42128,42182,43360,43388,44032,55203,63744,64255,65040,65049,65072,65106,65108,65126,65128,65131,94176,94180,94192,94193,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,126980,126980,127183,127183,127374,127374,127377,127386,127488,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,127776,127789,127797,127799,127868,127870,127891,127904,127946,127951,127955,127968,127984,127988,127988,127992,128062,128064,128064,128066,128252,128255,128317,128331,128334,128336,128359,128378,128378,128405,128406,128420,128420,128507,128591,128640,128709,128716,128716,128720,128722,128725,128727,128732,128735,128747,128748,128756,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,131072,196605,196608,262141 }); }
	static private void addProperty544() { addProperty("gc=cn", new int[] { 888,889,896,899,907,907,909,909,930,930,1328,1328,1367,1368,1419,1420,1424,1424,1480,1487,1515,1518,1525,1535,1806,1806,1867,1868,1970,1983,2043,2044,2094,2095,2111,2111,2140,2141,2143,2143,2155,2159,2191,2191,2194,2199,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2679,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2802,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2936,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3067,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3190,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3408,3411,3428,3429,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3573,3584,3643,3646,3676,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3912,3912,3949,3952,3992,3992,4029,4029,4045,4045,4059,4095,4294,4294,4296,4300,4302,4303,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4989,4991,5018,5023,5110,5111,5118,5119,5789,5791,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6110,6111,6122,6127,6138,6143,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6463,6465,6467,6510,6511,6517,6527,6572,6575,6602,6607,6619,6621,6684,6685,6751,6751,6781,6782,6794,6799,6810,6815,6830,6831,6863,6911,6989,6991,7039,7039,7156,7163,7224,7226,7242,7244,7305,7311,7355,7356,7368,7375,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8293,8293,8306,8307,8335,8335,8349,8351,8385,8399,8433,8447,8588,8591,9255,9279,9291,9311,11124,11125,11158,11158,11508,11512,11558,11558,11560,11564,11566,11567,11624,11630,11633,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12352,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,42125,42127,42183,42191,42540,42559,42744,42751,42955,42959,42962,42962,42964,42964,42970,42993,43053,43055,43066,43071,43128,43135,43206,43213,43226,43231,43348,43358,43389,43391,43470,43470,43482,43485,43519,43519,43575,43583,43598,43599,43610,43611,43715,43738,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43884,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,55295,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64451,64466,64912,64913,64968,64974,64976,65007,65050,65055,65107,65107,65127,65127,65132,65135,65141,65141,65277,65278,65280,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65528,65534,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65791,65795,65798,65844,65846,65935,65935,65949,65951,65953,65999,66046,66175,66205,66207,66257,66271,66300,66303,66340,66348,66379,66383,66427,66431,66462,66462,66500,66503,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66926,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67670,67743,67750,67760,67807,67827,67827,67830,67834,67868,67870,67898,67902,67904,67967,68024,68027,68048,68049,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,68175,68185,68191,68256,68287,68327,68330,68343,68351,68406,68408,68438,68439,68467,68471,68498,68504,68509,68520,68528,68607,68681,68735,68787,68799,68851,68857,68904,68911,68922,69215,69247,69247,69290,69290,69294,69295,69298,69372,69416,69423,69466,69487,69514,69551,69580,69599,69623,69631,69710,69713,69750,69758,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69960,69967,70007,70015,70112,70112,70133,70143,70162,70162,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70748,70748,70754,70783,70856,70863,70874,71039,71094,71095,71134,71167,71237,71247,71258,71263,71277,71295,71354,71359,71370,71423,71451,71452,71468,71471,71495,71679,71740,71839,71923,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72007,72015,72026,72095,72104,72105,72152,72153,72165,72191,72264,72271,72355,72367,72441,72447,72458,72703,72713,72713,72759,72759,72774,72783,72813,72815,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73562,73647,73649,73663,73714,73726,74650,74751,74863,74863,74869,74879,75076,77711,77811,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92998,93007,93018,93018,93026,93026,93048,93052,93072,93759,93851,93951,94027,94030,94088,94094,94112,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113819,113828,118527,118574,118575,118599,118607,118724,118783,119030,119039,119079,119080,119275,119295,119366,119487,119508,119519,119540,119551,119639,119647,119673,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,121484,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123216,123535,123567,123583,123642,123646,123648,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125126,125143,125183,125260,125263,125274,125277,125280,126064,126133,126208,126270,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,126703,126706,126975,127020,127023,127124,127135,127151,127152,127168,127168,127184,127184,127222,127231,127406,127461,127491,127503,127548,127551,127561,127567,127570,127583,127590,127743,128728,128731,128749,128751,128765,128767,128887,128890,128986,128991,129004,129007,129009,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129199,129202,129279,129620,129631,129646,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,129791,129939,129939,129995,130031,130042,131071,173792,173823,177978,177983,178206,178207,183970,183983,191457,194559,195102,196607,201547,201551,205744,917504,917506,917535,917632,917759,918000,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty545() { addProperty("gc=lu", new int[] { 65,90,192,214,216,222,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,330,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,452,455,455,458,458,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,497,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,975,975,978,980,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1012,1012,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,4256,4293,4295,4295,4301,4301,5024,5109,7312,7354,7357,7359,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8120,8123,8136,8139,8152,8155,8168,8172,8184,8187,8450,8450,8455,8455,8459,8461,8464,8466,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8496,8499,8510,8511,8517,8517,8579,8579,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,119808,119833,119860,119885,119912,119937,119964,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119989,120016,120041,120068,120069,120071,120074,120077,120084,120086,120092,120120,120121,120123,120126,120128,120132,120134,120134,120138,120144,120172,120197,120224,120249,120276,120301,120328,120353,120380,120405,120432,120457,120488,120512,120546,120570,120604,120628,120662,120686,120720,120744,120778,120778,125184,125217 }); }
	static private void addProperty546() { addProperty("gc=ll", new int[] { 97,122,181,181,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,312,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,397,402,402,405,405,409,411,414,414,417,417,419,419,421,421,424,424,426,427,429,429,432,432,436,436,438,438,441,442,445,447,454,454,457,457,460,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,496,499,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,545,545,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,569,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,659,661,687,881,881,883,883,887,887,891,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1020,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1376,1416,4304,4346,4349,4351,5112,5117,7296,7304,7424,7467,7531,7543,7545,7578,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7837,7839,7839,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8071,8080,8087,8096,8103,8112,8116,8118,8119,8126,8126,8130,8132,8134,8135,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8458,8458,8462,8463,8467,8467,8495,8495,8500,8500,8505,8505,8508,8509,8518,8521,8526,8526,8580,8580,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11377,11377,11379,11380,11382,11387,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11492,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42651,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42801,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42863,42865,42872,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42894,42894,42897,42897,42899,42901,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42927,42927,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42963,42963,42965,42965,42967,42967,42969,42969,42998,42998,43002,43002,43824,43866,43872,43880,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,68800,68850,71872,71903,93792,93823,119834,119859,119886,119892,119894,119911,119938,119963,119990,119993,119995,119995,119997,120003,120005,120015,120042,120067,120094,120119,120146,120171,120198,120223,120250,120275,120302,120327,120354,120379,120406,120431,120458,120485,120514,120538,120540,120545,120572,120596,120598,120603,120630,120654,120656,120661,120688,120712,120714,120719,120746,120770,120772,120777,120779,120779,122624,122633,122635,122654,122661,122666,125218,125251 }); }
	static private void addProperty547() { addProperty("gc=lt", new int[] { 453,453,456,456,459,459,498,498,8072,8079,8088,8095,8104,8111,8124,8124,8140,8140,8188,8188 }); }
	static private void addProperty548() { addProperty("gc=lm", new int[] { 688,705,710,721,736,740,748,748,750,750,884,884,890,890,1369,1369,1600,1600,1765,1766,2036,2037,2042,2042,2074,2074,2084,2084,2088,2088,2249,2249,2417,2417,3654,3654,3782,3782,4348,4348,6103,6103,6211,6211,6823,6823,7288,7293,7468,7530,7544,7544,7579,7615,8305,8305,8319,8319,8336,8348,11388,11389,11631,11631,11823,11823,12293,12293,12337,12341,12347,12347,12445,12446,12540,12542,40981,40981,42232,42237,42508,42508,42623,42623,42652,42653,42775,42783,42864,42864,42888,42888,42994,42996,43000,43001,43471,43471,43494,43494,43632,43632,43741,43741,43763,43764,43868,43871,43881,43881,65392,65392,65438,65439,67456,67461,67463,67504,67506,67514,92992,92995,94099,94111,94176,94177,94179,94179,110576,110579,110581,110587,110589,110590,122928,122989,123191,123197,124139,124139,125259,125259 }); }
	static private void addProperty549() { addProperty("gc=lo", new int[] { 170,170,186,186,443,443,448,451,660,660,1488,1514,1519,1522,1568,1599,1601,1610,1646,1647,1649,1747,1749,1749,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2048,2069,2112,2136,2144,2154,2160,2183,2185,2190,2208,2248,2308,2361,2365,2365,2384,2384,2392,2401,2418,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3653,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4352,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5121,5740,5743,5759,5761,5786,5792,5866,5873,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6108,6108,6176,6210,6212,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7287,7401,7404,7406,7411,7413,7414,7418,7418,8501,8504,11568,11623,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,12294,12294,12348,12348,12353,12438,12447,12447,12449,12538,12543,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,40980,40982,42124,42192,42231,42240,42507,42512,42527,42538,42539,42606,42606,42656,42725,42895,42895,42999,42999,43003,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43488,43492,43495,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43631,43633,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43740,43744,43754,43762,43762,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43968,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65382,65391,65393,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,66176,66204,66208,66256,66304,66335,66349,66368,66370,66377,66384,66421,66432,66461,66464,66499,66504,66511,66640,66717,66816,66855,66864,66915,67072,67382,67392,67413,67424,67431,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,93027,93047,93053,93071,93952,94026,94032,94032,94208,100343,100352,101589,101632,101640,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,122634,122634,123136,123180,123214,123214,123536,123565,123584,123627,124112,124138,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty550() { addProperty("gc=mn", new int[] { 768,879,1155,1159,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2497,2500,2509,2509,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2879,2879,2881,2884,2893,2893,2901,2902,2914,2915,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3270,3270,3276,3277,3298,3299,3328,3329,3387,3388,3393,3396,3405,3405,3426,3427,3457,3457,3530,3530,3538,3540,3542,3542,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6845,6847,6862,6912,6915,6964,6964,6966,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8400,8412,8417,8417,8421,8432,11503,11505,11647,11647,11744,11775,12330,12333,12441,12442,42607,42607,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70464,70464,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70835,70840,70842,70842,70847,70848,70850,70851,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,118528,118573,118576,118598,119143,119145,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917760,917999 }); }
	static private void addProperty551() { addProperty("gc=me", new int[] { 1160,1161,6846,6846,8413,8416,8418,8420,42608,42610 }); }
	static private void addProperty552() { addProperty("gc=mc", new int[] { 2307,2307,2363,2363,2366,2368,2377,2380,2382,2383,2434,2435,2494,2496,2503,2504,2507,2508,2519,2519,2563,2563,2622,2624,2691,2691,2750,2752,2761,2761,2763,2764,2818,2819,2878,2878,2880,2880,2887,2888,2891,2892,2903,2903,3006,3007,3009,3010,3014,3016,3018,3020,3031,3031,3073,3075,3137,3140,3202,3203,3262,3262,3264,3268,3271,3272,3274,3275,3285,3286,3315,3315,3330,3331,3390,3392,3398,3400,3402,3404,3415,3415,3458,3459,3535,3537,3544,3551,3570,3571,3902,3903,3967,3967,4139,4140,4145,4145,4152,4152,4155,4156,4182,4183,4194,4196,4199,4205,4227,4228,4231,4236,4239,4239,4250,4252,5909,5909,5940,5940,6070,6070,6078,6085,6087,6088,6435,6438,6441,6443,6448,6449,6451,6456,6681,6682,6741,6741,6743,6743,6753,6753,6755,6756,6765,6770,6916,6916,6965,6965,6971,6971,6973,6977,6979,6980,7042,7042,7073,7073,7078,7079,7082,7082,7143,7143,7146,7148,7150,7150,7154,7155,7204,7211,7220,7221,7393,7393,7415,7415,12334,12335,43043,43044,43047,43047,43136,43137,43188,43203,43346,43347,43395,43395,43444,43445,43450,43451,43454,43456,43567,43568,43571,43572,43597,43597,43643,43643,43645,43645,43755,43755,43758,43759,43765,43765,44003,44004,44006,44007,44009,44010,44012,44012,69632,69632,69634,69634,69762,69762,69808,69810,69815,69816,69932,69932,69957,69958,70018,70018,70067,70069,70079,70080,70094,70094,70188,70190,70194,70195,70197,70197,70368,70370,70402,70403,70462,70463,70465,70468,70471,70472,70475,70477,70487,70487,70498,70499,70709,70711,70720,70721,70725,70725,70832,70834,70841,70841,70843,70846,70849,70849,71087,71089,71096,71099,71102,71102,71216,71218,71227,71228,71230,71230,71340,71340,71342,71343,71350,71350,71456,71457,71462,71462,71724,71726,71736,71736,71984,71989,71991,71992,71997,71997,72000,72000,72002,72002,72145,72147,72156,72159,72164,72164,72249,72249,72279,72280,72343,72343,72751,72751,72766,72766,72873,72873,72881,72881,72884,72884,73098,73102,73107,73108,73110,73110,73461,73462,73475,73475,73524,73525,73534,73535,73537,73537,94033,94087,94192,94193,119141,119142,119149,119154 }); }
	static private void addProperty553() { addProperty("gc=nd", new int[] { 48,57,1632,1641,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty554() { addProperty("gc=nl", new int[] { 5870,5872,8544,8578,8581,8584,12295,12295,12321,12329,12344,12346,42726,42735,65856,65908,66369,66369,66378,66378,66513,66517,74752,74862 }); }
	static private void addProperty555() { addProperty("gc=no", new int[] { 178,179,185,185,188,190,2548,2553,2930,2935,3056,3058,3192,3198,3416,3422,3440,3448,3882,3891,4969,4988,6128,6137,6618,6618,8304,8304,8308,8313,8320,8329,8528,8543,8585,8585,9312,9371,9450,9471,10102,10131,11517,11517,12690,12693,12832,12841,12872,12879,12881,12895,12928,12937,12977,12991,43056,43061,65799,65843,65909,65912,65930,65931,66273,66299,66336,66339,67672,67679,67705,67711,67751,67759,67835,67839,67862,67867,68028,68029,68032,68047,68050,68095,68160,68168,68221,68222,68253,68255,68331,68335,68440,68447,68472,68479,68521,68527,68858,68863,69216,69246,69405,69414,69457,69460,69573,69579,69714,69733,70113,70132,71482,71483,71914,71922,72794,72812,73664,73684,93019,93025,93824,93846,119488,119507,119520,119539,119648,119672,125127,125135,126065,126123,126125,126127,126129,126132,126209,126253,126255,126269,127232,127244 }); }
	static private void addProperty556() { addProperty("gc=zs", new int[] { 32,32,160,160,5760,5760,8192,8202,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty557() { addProperty("gc=zl", new int[] { 8232,8232 }); }
	static private void addProperty558() { addProperty("gc=zp", new int[] { 8233,8233 }); }
	static private void addProperty559() { addProperty("gc=cc", new int[] { 0,31,127,159 }); }
	static private void addProperty560() { addProperty("gc=cf", new int[] { 173,173,1536,1541,1564,1564,1757,1757,1807,1807,2192,2193,2274,2274,6158,6158,8203,8207,8234,8238,8288,8292,8294,8303,65279,65279,65529,65531,69821,69821,69837,69837,78896,78911,113824,113827,119155,119162,917505,917505,917536,917631 }); }
	static private void addProperty561() { addProperty("gc=co", new int[] { 57344,63743,983040,1048573,1048576,1114109 }); }
	static private void addProperty562() { addProperty("gc=cs", new int[] { 55296,57343 }); }
	static private void addProperty563() { addProperty("gc=pd", new int[] { 45,45,1418,1418,1470,1470,5120,5120,6150,6150,8208,8213,11799,11799,11802,11802,11834,11835,11840,11840,11869,11869,12316,12316,12336,12336,12448,12448,65073,65074,65112,65112,65123,65123,65293,65293,69293,69293 }); }
	static private void addProperty564() { addProperty("gc=ps", new int[] { 40,40,91,91,123,123,3898,3898,3900,3900,5787,5787,8218,8218,8222,8222,8261,8261,8317,8317,8333,8333,8968,8968,8970,8970,9001,9001,10088,10088,10090,10090,10092,10092,10094,10094,10096,10096,10098,10098,10100,10100,10181,10181,10214,10214,10216,10216,10218,10218,10220,10220,10222,10222,10627,10627,10629,10629,10631,10631,10633,10633,10635,10635,10637,10637,10639,10639,10641,10641,10643,10643,10645,10645,10647,10647,10712,10712,10714,10714,10748,10748,11810,11810,11812,11812,11814,11814,11816,11816,11842,11842,11861,11861,11863,11863,11865,11865,11867,11867,12296,12296,12298,12298,12300,12300,12302,12302,12304,12304,12308,12308,12310,12310,12312,12312,12314,12314,12317,12317,64831,64831,65047,65047,65077,65077,65079,65079,65081,65081,65083,65083,65085,65085,65087,65087,65089,65089,65091,65091,65095,65095,65113,65113,65115,65115,65117,65117,65288,65288,65339,65339,65371,65371,65375,65375,65378,65378 }); }
	static private void addProperty565() { addProperty("gc=pe", new int[] { 41,41,93,93,125,125,3899,3899,3901,3901,5788,5788,8262,8262,8318,8318,8334,8334,8969,8969,8971,8971,9002,9002,10089,10089,10091,10091,10093,10093,10095,10095,10097,10097,10099,10099,10101,10101,10182,10182,10215,10215,10217,10217,10219,10219,10221,10221,10223,10223,10628,10628,10630,10630,10632,10632,10634,10634,10636,10636,10638,10638,10640,10640,10642,10642,10644,10644,10646,10646,10648,10648,10713,10713,10715,10715,10749,10749,11811,11811,11813,11813,11815,11815,11817,11817,11862,11862,11864,11864,11866,11866,11868,11868,12297,12297,12299,12299,12301,12301,12303,12303,12305,12305,12309,12309,12311,12311,12313,12313,12315,12315,12318,12319,64830,64830,65048,65048,65078,65078,65080,65080,65082,65082,65084,65084,65086,65086,65088,65088,65090,65090,65092,65092,65096,65096,65114,65114,65116,65116,65118,65118,65289,65289,65341,65341,65373,65373,65376,65376,65379,65379 }); }
	static private void addProperty566() { addProperty("gc=pc", new int[] { 95,95,8255,8256,8276,8276,65075,65076,65101,65103,65343,65343 }); }
	static private void addProperty567() { addProperty("gc=po", new int[] { 33,35,37,39,42,42,44,44,46,47,58,59,63,64,92,92,161,161,167,167,182,183,191,191,894,894,903,903,1370,1375,1417,1417,1472,1472,1475,1475,1478,1478,1523,1524,1545,1546,1548,1549,1563,1563,1565,1567,1642,1645,1748,1748,1792,1805,2039,2041,2096,2110,2142,2142,2404,2405,2416,2416,2557,2557,2678,2678,2800,2800,3191,3191,3204,3204,3572,3572,3663,3663,3674,3675,3844,3858,3860,3860,3973,3973,4048,4052,4057,4058,4170,4175,4347,4347,4960,4968,5742,5742,5867,5869,5941,5942,6100,6102,6104,6106,6144,6149,6151,6154,6468,6469,6686,6687,6816,6822,6824,6829,7002,7008,7037,7038,7164,7167,7227,7231,7294,7295,7360,7367,7379,7379,8214,8215,8224,8231,8240,8248,8251,8254,8257,8259,8263,8273,8275,8275,8277,8286,11513,11516,11518,11519,11632,11632,11776,11777,11782,11784,11787,11787,11790,11798,11800,11801,11803,11803,11806,11807,11818,11822,11824,11833,11836,11839,11841,11841,11843,11855,11858,11860,12289,12291,12349,12349,12539,12539,42238,42239,42509,42511,42611,42611,42622,42622,42738,42743,43124,43127,43214,43215,43256,43258,43260,43260,43310,43311,43359,43359,43457,43469,43486,43487,43612,43615,43742,43743,43760,43761,44011,44011,65040,65046,65049,65049,65072,65072,65093,65094,65097,65100,65104,65106,65108,65111,65119,65121,65128,65128,65130,65131,65281,65283,65285,65287,65290,65290,65292,65292,65294,65295,65306,65307,65311,65312,65340,65340,65377,65377,65380,65381,65792,65794,66463,66463,66512,66512,66927,66927,67671,67671,67871,67871,67903,67903,68176,68184,68223,68223,68336,68342,68409,68415,68505,68508,69461,69465,69510,69513,69703,69709,69819,69820,69822,69825,69952,69955,70004,70005,70085,70088,70093,70093,70107,70107,70109,70111,70200,70205,70313,70313,70731,70735,70746,70747,70749,70749,70854,70854,71105,71127,71233,71235,71264,71276,71353,71353,71484,71486,71739,71739,72004,72006,72162,72162,72255,72262,72346,72348,72350,72354,72448,72457,72769,72773,72816,72817,73463,73464,73539,73551,73727,73727,74864,74868,77809,77810,92782,92783,92917,92917,92983,92987,92996,92996,93847,93850,94178,94178,113823,113823,121479,121483,125278,125279 }); }
	static private void addProperty568() { addProperty("gc=sm", new int[] { 43,43,60,62,124,124,126,126,172,172,177,177,215,215,247,247,1014,1014,1542,1544,8260,8260,8274,8274,8314,8316,8330,8332,8472,8472,8512,8516,8523,8523,8592,8596,8602,8603,8608,8608,8611,8611,8614,8614,8622,8622,8654,8655,8658,8658,8660,8660,8692,8959,8992,8993,9084,9084,9115,9139,9180,9185,9655,9655,9665,9665,9720,9727,9839,9839,10176,10180,10183,10213,10224,10239,10496,10626,10649,10711,10716,10747,10750,11007,11056,11076,11079,11084,64297,64297,65122,65122,65124,65126,65291,65291,65308,65310,65372,65372,65374,65374,65506,65506,65513,65516,120513,120513,120539,120539,120571,120571,120597,120597,120629,120629,120655,120655,120687,120687,120713,120713,120745,120745,120771,120771,126704,126705 }); }
	static private void addProperty569() { addProperty("gc=sc", new int[] { 36,36,162,165,1423,1423,1547,1547,2046,2047,2546,2547,2555,2555,2801,2801,3065,3065,3647,3647,6107,6107,8352,8384,43064,43064,65020,65020,65129,65129,65284,65284,65504,65505,65509,65510,73693,73696,123647,123647,126128,126128 }); }
	static private void addProperty570() { addProperty("gc=sk", new int[] { 94,94,96,96,168,168,175,175,180,180,184,184,706,709,722,735,741,747,749,749,751,767,885,885,900,901,2184,2184,8125,8125,8127,8129,8141,8143,8157,8159,8173,8175,8189,8190,12443,12444,42752,42774,42784,42785,42889,42890,43867,43867,43882,43883,64434,64450,65342,65342,65344,65344,65507,65507,127995,127999 }); }
	static private void addProperty571() { addProperty("gc=so", new int[] { 166,166,169,169,174,174,176,176,1154,1154,1421,1422,1550,1551,1758,1758,1769,1769,1789,1790,2038,2038,2554,2554,2928,2928,3059,3064,3066,3066,3199,3199,3407,3407,3449,3449,3841,3843,3859,3859,3861,3863,3866,3871,3892,3892,3894,3894,3896,3896,4030,4037,4039,4044,4046,4047,4053,4056,4254,4255,5008,5017,5741,5741,6464,6464,6622,6655,7009,7018,7028,7036,8448,8449,8451,8454,8456,8457,8468,8468,8470,8471,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8506,8507,8522,8522,8524,8525,8527,8527,8586,8587,8597,8601,8604,8607,8609,8610,8612,8613,8615,8621,8623,8653,8656,8657,8659,8659,8661,8691,8960,8967,8972,8991,8994,9000,9003,9083,9085,9114,9140,9179,9186,9254,9280,9290,9372,9449,9472,9654,9656,9664,9666,9719,9728,9838,9840,10087,10132,10175,10240,10495,11008,11055,11077,11078,11085,11123,11126,11157,11159,11263,11493,11498,11856,11857,11904,11929,11931,12019,12032,12245,12272,12283,12292,12292,12306,12307,12320,12320,12342,12343,12350,12351,12688,12689,12694,12703,12736,12771,12800,12830,12842,12871,12880,12880,12896,12927,12938,12976,12992,13311,19904,19967,42128,42182,43048,43051,43062,43063,43065,43065,43639,43641,64832,64847,64975,64975,65021,65023,65508,65508,65512,65512,65517,65518,65532,65533,65847,65855,65913,65929,65932,65934,65936,65948,65952,65952,66000,66044,67703,67704,68296,68296,71487,71487,73685,73692,73697,73713,92988,92991,92997,92997,113820,113820,118608,118723,118784,119029,119040,119078,119081,119140,119146,119148,119171,119172,119180,119209,119214,119274,119296,119361,119365,119365,119552,119638,120832,121343,121399,121402,121453,121460,121462,121475,121477,121478,123215,123215,126124,126124,126254,126254,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127245,127405,127462,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,127994,128000,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994 }); }
	static private void addProperty572() { addProperty("gc=pi", new int[] { 171,171,8216,8216,8219,8220,8223,8223,8249,8249,11778,11778,11780,11780,11785,11785,11788,11788,11804,11804,11808,11808 }); }
	static private void addProperty573() { addProperty("gc=pf", new int[] { 187,187,8217,8217,8221,8221,8250,8250,11779,11779,11781,11781,11786,11786,11789,11789,11805,11805,11809,11809 }); }
	static private void addProperty574() { addProperty("jg=no_joining_group", new int[] { 0,1567,1569,1569,1600,1600,1611,1645,1648,1648,1652,1652,1748,1748,1750,1773,1776,1785,1789,1790,1792,1807,1809,1809,1840,1868,1920,2143,2155,2159,2179,2181,2183,2184,2191,2207,2221,2221,2249,68287,68294,68294,68296,68296,68299,68300,68322,68323,68325,68330,68336,68865,68867,68872,68874,68888,68890,68891,68893,68893,68895,68895,68897,68898,68900,1114111 }); }
	static private void addProperty575() { addProperty("jg=ain", new int[] { 1593,1594,1696,1696,1788,1788,1885,1887,2227,2227,2243,2243 }); }
	static private void addProperty576() { addProperty("jg=alaph", new int[] { 1808,1808 }); }
	static private void addProperty577() { addProperty("jg=alef", new int[] { 1570,1571,1573,1573,1575,1575,1649,1651,1653,1653,1907,1908,2160,2178 }); }
	static private void addProperty578() { addProperty("jg=beh", new int[] { 1576,1576,1578,1579,1646,1646,1657,1664,1872,1878,2208,2209,2230,2232,2238,2240 }); }
	static private void addProperty579() { addProperty("jg=beth", new int[] { 1810,1810,1837,1837 }); }
	static private void addProperty580() { addProperty("jg=dal", new int[] { 1583,1584,1672,1680,1774,1774,1881,1882,2222,2222 }); }
	static private void addProperty581() { addProperty("jg=dalath_rish", new int[] { 1813,1814,1834,1834,1839,1839 }); }
	static private void addProperty582() { addProperty("jg=e", new int[] { 1829,1829 }); }
	static private void addProperty583() { addProperty("jg=feh", new int[] { 1601,1601,1697,1702,1888,1889,2212,2212 }); }
	static private void addProperty584() { addProperty("jg=final_semkath", new int[] { 1828,1828 }); }
	static private void addProperty585() { addProperty("jg=gaf", new int[] { 1595,1596,1705,1705,1707,1707,1711,1716,1890,1892,2189,2189,2224,2224,2242,2242,2248,2248 }); }
	static private void addProperty586() { addProperty("jg=gamal", new int[] { 1811,1812,1838,1838 }); }
	static private void addProperty587() { addProperty("jg=hah", new int[] { 1580,1582,1665,1671,1727,1727,1879,1880,1902,1903,1906,1906,1916,1916,2186,2186,2210,2210,2241,2241,2245,2246 }); }
	static private void addProperty588() { addProperty("jg=teh_marbuta_goal", new int[] { 1731,1731 }); }
	static private void addProperty589() { addProperty("jg=he", new int[] { 1815,1815 }); }
	static private void addProperty590() { addProperty("jg=heh", new int[] { 1607,1607 }); }
	static private void addProperty591() { addProperty("jg=heh_goal", new int[] { 1729,1730 }); }
	static private void addProperty592() { addProperty("jg=heth", new int[] { 1818,1818 }); }
	static private void addProperty593() { addProperty("jg=kaf", new int[] { 1603,1603,1708,1710,1919,1919,2228,2228 }); }
	static private void addProperty594() { addProperty("jg=kaph", new int[] { 1823,1823 }); }
	static private void addProperty595() { addProperty("jg=knotted_heh", new int[] { 1726,1726,1791,1791 }); }
	static private void addProperty596() { addProperty("jg=lam", new int[] { 1604,1604,1717,1720,1898,1898,2214,2214,2247,2247 }); }
	static private void addProperty597() { addProperty("jg=lamadh", new int[] { 1824,1824 }); }
	static private void addProperty598() { addProperty("jg=meem", new int[] { 1605,1605,1893,1894,2215,2215 }); }
	static private void addProperty599() { addProperty("jg=mim", new int[] { 1825,1825 }); }
	static private void addProperty600() { addProperty("jg=noon", new int[] { 1606,1606,1721,1724,1895,1897,2185,2185 }); }
	static private void addProperty601() { addProperty("jg=nun", new int[] { 1826,1826 }); }
	static private void addProperty602() { addProperty("jg=pe", new int[] { 1830,1830 }); }
	static private void addProperty603() { addProperty("jg=qaf", new int[] { 1602,1602,1647,1647,1703,1704,2213,2213,2229,2229 }); }
	static private void addProperty604() { addProperty("jg=qaph", new int[] { 1833,1833 }); }
	static private void addProperty605() { addProperty("jg=reh", new int[] { 1585,1586,1681,1689,1775,1775,1883,1883,1899,1900,1905,1905,2218,2218,2226,2226,2233,2233 }); }
	static private void addProperty606() { addProperty("jg=reversed_pe", new int[] { 1831,1831 }); }
	static private void addProperty607() { addProperty("jg=sad", new int[] { 1589,1590,1693,1694,1787,1787,2223,2223 }); }
	static private void addProperty608() { addProperty("jg=sadhe", new int[] { 1832,1832 }); }
	static private void addProperty609() { addProperty("jg=seen", new int[] { 1587,1588,1690,1692,1786,1786,1884,1884,1901,1901,1904,1904,1917,1918 }); }
	static private void addProperty610() { addProperty("jg=semkath", new int[] { 1827,1827 }); }
	static private void addProperty611() { addProperty("jg=shin", new int[] { 1835,1835 }); }
	static private void addProperty612() { addProperty("jg=swash_kaf", new int[] { 1706,1706 }); }
	static private void addProperty613() { addProperty("jg=syriac_waw", new int[] { 1816,1816 }); }
	static private void addProperty614() { addProperty("jg=tah", new int[] { 1591,1592,1695,1695,2187,2188,2211,2211 }); }
	static private void addProperty615() { addProperty("jg=taw", new int[] { 1836,1836 }); }
	static private void addProperty616() { addProperty("jg=teh_marbuta", new int[] { 1577,1577,1728,1728,1749,1749 }); }
	static private void addProperty617() { addProperty("jg=teth", new int[] { 1819,1820 }); }
	static private void addProperty618() { addProperty("jg=waw", new int[] { 1572,1572,1608,1608,1654,1655,1732,1739,1743,1743,1912,1913,2219,2219 }); }
	static private void addProperty619() { addProperty("jg=yeh", new int[] { 1568,1568,1574,1574,1609,1610,1656,1656,1744,1745,1911,1911,2216,2217,2234,2234 }); }
	static private void addProperty620() { addProperty("jg=yeh_barree", new int[] { 1746,1747 }); }
	static private void addProperty621() { addProperty("jg=yeh_with_tail", new int[] { 1741,1741 }); }
	static private void addProperty622() { addProperty("jg=yudh", new int[] { 1821,1821 }); }
	static private void addProperty623() { addProperty("jg=yudh_he", new int[] { 1822,1822 }); }
	static private void addProperty624() { addProperty("jg=zain", new int[] { 1817,1817 }); }
	static private void addProperty625() { addProperty("jg=fe", new int[] { 1871,1871 }); }
	static private void addProperty626() { addProperty("jg=khaph", new int[] { 1870,1870 }); }
	static private void addProperty627() { addProperty("jg=zhain", new int[] { 1869,1869 }); }
	static private void addProperty628() { addProperty("jg=burushaski_yeh_barree", new int[] { 1914,1915 }); }
	static private void addProperty629() { addProperty("jg=farsi_yeh", new int[] { 1597,1599,1740,1740,1742,1742,1909,1910 }); }
	static private void addProperty630() { addProperty("jg=nya", new int[] { 1725,1725 }); }
	static private void addProperty631() { addProperty("jg=rohingya_yeh", new int[] { 2220,2220 }); }
	static private void addProperty632() { addProperty("jg=manichaean_aleph", new int[] { 68288,68288 }); }
	static private void addProperty633() { addProperty("jg=manichaean_ayin", new int[] { 68313,68314 }); }
	static private void addProperty634() { addProperty("jg=manichaean_beth", new int[] { 68289,68290 }); }
	static private void addProperty635() { addProperty("jg=manichaean_daleth", new int[] { 68293,68293 }); }
	static private void addProperty636() { addProperty("jg=manichaean_dhamedh", new int[] { 68308,68308 }); }
	static private void addProperty637() { addProperty("jg=manichaean_five", new int[] { 68332,68332 }); }
	static private void addProperty638() { addProperty("jg=manichaean_gimel", new int[] { 68291,68292 }); }
	static private void addProperty639() { addProperty("jg=manichaean_heth", new int[] { 68301,68301 }); }
	static private void addProperty640() { addProperty("jg=manichaean_hundred", new int[] { 68335,68335 }); }
	static private void addProperty641() { addProperty("jg=manichaean_kaph", new int[] { 68304,68306 }); }
	static private void addProperty642() { addProperty("jg=manichaean_lamedh", new int[] { 68307,68307 }); }
	static private void addProperty643() { addProperty("jg=manichaean_mem", new int[] { 68310,68310 }); }
	static private void addProperty644() { addProperty("jg=manichaean_nun", new int[] { 68311,68311 }); }
	static private void addProperty645() { addProperty("jg=manichaean_one", new int[] { 68331,68331 }); }
	static private void addProperty646() { addProperty("jg=manichaean_pe", new int[] { 68315,68316 }); }
	static private void addProperty647() { addProperty("jg=manichaean_qoph", new int[] { 68318,68320 }); }
	static private void addProperty648() { addProperty("jg=manichaean_resh", new int[] { 68321,68321 }); }
	static private void addProperty649() { addProperty("jg=manichaean_sadhe", new int[] { 68317,68317 }); }
	static private void addProperty650() { addProperty("jg=manichaean_samekh", new int[] { 68312,68312 }); }
	static private void addProperty651() { addProperty("jg=manichaean_taw", new int[] { 68324,68324 }); }
	static private void addProperty652() { addProperty("jg=manichaean_ten", new int[] { 68333,68333 }); }
	static private void addProperty653() { addProperty("jg=manichaean_teth", new int[] { 68302,68302 }); }
	static private void addProperty654() { addProperty("jg=manichaean_thamedh", new int[] { 68309,68309 }); }
	static private void addProperty655() { addProperty("jg=manichaean_twenty", new int[] { 68334,68334 }); }
	static private void addProperty656() { addProperty("jg=manichaean_waw", new int[] { 68295,68295 }); }
	static private void addProperty657() { addProperty("jg=manichaean_yodh", new int[] { 68303,68303 }); }
	static private void addProperty658() { addProperty("jg=manichaean_zayin", new int[] { 68297,68298 }); }
	static private void addProperty659() { addProperty("jg=straight_waw", new int[] { 2225,2225 }); }
	static private void addProperty660() { addProperty("jg=african_feh", new int[] { 2235,2235 }); }
	static private void addProperty661() { addProperty("jg=african_noon", new int[] { 2237,2237 }); }
	static private void addProperty662() { addProperty("jg=african_qaf", new int[] { 2236,2236,2244,2244 }); }
	static private void addProperty663() { addProperty("jg=malayalam_bha", new int[] { 2150,2150 }); }
	static private void addProperty664() { addProperty("jg=malayalam_ja", new int[] { 2145,2145 }); }
	static private void addProperty665() { addProperty("jg=malayalam_lla", new int[] { 2152,2152 }); }
	static private void addProperty666() { addProperty("jg=malayalam_llla", new int[] { 2153,2153 }); }
	static private void addProperty667() { addProperty("jg=malayalam_nga", new int[] { 2144,2144 }); }
	static private void addProperty668() { addProperty("jg=malayalam_nna", new int[] { 2148,2148 }); }
	static private void addProperty669() { addProperty("jg=malayalam_nnna", new int[] { 2149,2149 }); }
	static private void addProperty670() { addProperty("jg=malayalam_nya", new int[] { 2146,2146 }); }
	static private void addProperty671() { addProperty("jg=malayalam_ra", new int[] { 2151,2151 }); }
	static private void addProperty672() { addProperty("jg=malayalam_ssa", new int[] { 2154,2154 }); }
	static private void addProperty673() { addProperty("jg=malayalam_tta", new int[] { 2147,2147 }); }
	static private void addProperty674() { addProperty("jg=hanifi_rohingya_kinna_ya", new int[] { 68889,68889,68894,68894,68896,68896,68899,68899 }); }
	static private void addProperty675() { addProperty("jg=hanifi_rohingya_pa", new int[] { 68866,68866,68873,68873,68892,68892 }); }
	static private void addProperty676() { addProperty("jg=thin_yeh", new int[] { 2182,2182 }); }
	static private void addProperty677() { addProperty("jg=vertical_tail", new int[] { 2190,2190 }); }
	static private void addProperty678() { addProperty("jt=u", new int[] { 0,172,174,767,880,1154,1162,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1563,1565,1567,1569,1569,1632,1645,1652,1652,1748,1748,1757,1758,1765,1766,1769,1769,1776,1785,1789,1790,1792,1806,1867,1868,1920,1957,1969,1993,2036,2041,2043,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2111,2140,2143,2145,2145,2150,2150,2155,2159,2183,2184,2191,2199,2221,2221,2249,2249,2274,2274,2307,2361,2363,2363,2365,2368,2377,2380,2382,2384,2392,2401,2404,2432,2434,2491,2493,2496,2501,2508,2510,2529,2532,2557,2559,2560,2563,2619,2621,2624,2627,2630,2633,2634,2638,2640,2642,2671,2674,2676,2678,2688,2691,2747,2749,2752,2758,2758,2761,2764,2766,2785,2788,2809,2816,2816,2818,2875,2877,2878,2880,2880,2885,2892,2894,2900,2903,2913,2916,2945,2947,3007,3009,3020,3022,3071,3073,3075,3077,3131,3133,3133,3137,3141,3145,3145,3150,3156,3159,3169,3172,3200,3202,3259,3261,3262,3264,3269,3271,3275,3278,3297,3300,3327,3330,3386,3389,3392,3397,3404,3406,3425,3428,3456,3458,3529,3531,3537,3541,3541,3543,3632,3634,3635,3643,3654,3663,3760,3762,3763,3773,3783,3791,3863,3866,3892,3894,3894,3896,3896,3898,3952,3967,3967,3973,3973,3976,3980,3992,3992,4029,4037,4039,4140,4145,4145,4152,4152,4155,4156,4159,4183,4186,4189,4193,4208,4213,4225,4227,4228,4231,4236,4238,4252,4254,4956,4960,5905,5909,5937,5940,5969,5972,6001,6004,6067,6070,6070,6078,6085,6087,6088,6100,6108,6110,6150,6152,6153,6158,6158,6160,6175,6265,6276,6315,6431,6435,6438,6441,6449,6451,6456,6460,6678,6681,6682,6684,6741,6743,6743,6751,6751,6753,6753,6755,6756,6765,6770,6781,6782,6784,6831,6863,6911,6916,6963,6965,6965,6971,6971,6973,6977,6979,7018,7028,7039,7042,7073,7078,7079,7082,7082,7086,7141,7143,7143,7146,7148,7150,7150,7154,7211,7220,7221,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7680,8202,8204,8204,8208,8233,8239,8287,8293,8297,8304,8399,8433,11502,11506,11646,11648,11743,11776,12329,12334,12440,12443,42606,42611,42611,42622,42653,42656,42735,42738,43009,43011,43013,43015,43018,43020,43044,43047,43051,43053,43071,43123,43203,43206,43231,43250,43262,43264,43301,43310,43334,43346,43391,43395,43442,43444,43445,43450,43451,43454,43492,43494,43560,43567,43568,43571,43572,43575,43586,43588,43595,43597,43643,43645,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43755,43758,43765,43767,44004,44006,44007,44009,44012,44014,64285,64287,65023,65040,65055,65072,65278,65280,65528,65532,66044,66046,66271,66273,66421,66427,68096,68100,68100,68103,68107,68112,68151,68155,68158,68160,68287,68294,68294,68296,68296,68299,68300,68322,68323,68327,68330,68336,68479,68498,68520,68527,68863,68904,69290,69293,69372,69376,69423,69445,69445,69461,69487,69510,69551,69553,69553,69559,69559,69568,69568,69573,69576,69580,69632,69634,69687,69703,69743,69745,69746,69749,69758,69762,69810,69815,69816,69819,69825,69827,69887,69891,69926,69932,69932,69941,70002,70004,70015,70018,70069,70079,70088,70093,70094,70096,70190,70194,70195,70197,70197,70200,70205,70207,70208,70210,70366,70368,70370,70379,70399,70402,70458,70461,70463,70465,70501,70509,70511,70517,70711,70720,70721,70725,70725,70727,70749,70751,70834,70841,70841,70843,70846,70849,70849,70852,71089,71094,71099,71102,71102,71105,71131,71134,71218,71227,71228,71230,71230,71233,71338,71340,71340,71342,71343,71350,71350,71352,71452,71456,71457,71462,71462,71468,71726,71736,71736,71739,71994,71997,71997,71999,72002,72004,72147,72152,72153,72156,72159,72161,72192,72203,72242,72249,72250,72255,72262,72264,72272,72279,72280,72284,72329,72343,72343,72346,72751,72759,72759,72766,72766,72768,72849,72872,72873,72881,72881,72884,72884,72887,73008,73015,73017,73019,73019,73022,73022,73030,73030,73032,73103,73106,73108,73110,73110,73112,73458,73461,73471,73474,73525,73531,73535,73537,73537,73539,78895,78913,78918,78934,92911,92917,92975,92983,94030,94032,94094,94099,94179,94181,113820,113823,113823,113828,118527,118574,118575,118599,119142,119146,119154,119171,119172,119180,119209,119214,119361,119365,121343,121399,121402,121453,121460,121462,121475,121477,121498,121504,121504,121520,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125183,125260,917504,917506,917535,917632,917759,918000,1114111 }); }
	static private void addProperty679() { addProperty("jt=c", new int[] { 1600,1600,2042,2042,2179,2181,6154,6154,8205,8205 }); }
	static private void addProperty680() { addProperty("jt=d", new int[] { 1568,1568,1574,1574,1576,1576,1578,1582,1587,1599,1601,1607,1609,1610,1646,1647,1656,1671,1690,1727,1729,1730,1740,1740,1742,1742,1744,1745,1786,1788,1791,1791,1810,1812,1818,1821,1823,1831,1833,1833,1835,1835,1837,1838,1870,1880,1884,1898,1901,1904,1906,1906,1909,1911,1914,1919,1994,2026,2113,2117,2120,2120,2122,2131,2133,2133,2144,2144,2146,2149,2152,2152,2182,2182,2185,2189,2208,2217,2223,2224,2227,2232,2234,2248,6151,6151,6176,6264,6279,6312,6314,6314,43072,43121,68288,68292,68307,68310,68312,68316,68318,68320,68331,68334,68480,68480,68482,68482,68486,68488,68490,68491,68493,68493,68496,68496,68525,68526,68865,68897,68899,68899,69424,69426,69428,69444,69457,69459,69488,69491,69494,69505,69552,69552,69554,69555,69560,69560,69563,69564,69566,69567,69569,69569,69572,69572,69578,69578,125184,125251 }); }
	static private void addProperty681() { addProperty("jt=l", new int[] { 43122,43122,68301,68301,68311,68311,68864,68864,69579,69579 }); }
	static private void addProperty682() { addProperty("jt=r", new int[] { 1570,1573,1575,1575,1577,1577,1583,1586,1608,1608,1649,1651,1653,1655,1672,1689,1728,1728,1731,1739,1741,1741,1743,1743,1746,1747,1749,1749,1774,1775,1808,1808,1813,1817,1822,1822,1832,1832,1834,1834,1836,1836,1839,1839,1869,1869,1881,1883,1899,1900,1905,1905,1907,1908,1912,1913,2112,2112,2118,2119,2121,2121,2132,2132,2134,2136,2151,2151,2153,2154,2160,2178,2190,2190,2218,2220,2222,2222,2225,2226,2233,2233,68293,68293,68295,68295,68297,68298,68302,68306,68317,68317,68321,68321,68324,68324,68335,68335,68481,68481,68483,68485,68489,68489,68492,68492,68494,68495,68497,68497,68521,68524,68898,68898,69427,69427,69460,69460,69492,69493,69556,69558,69561,69562,69565,69565,69570,69571,69577,69577 }); }
	static private void addProperty683() { addProperty("jt=t", new int[] { 173,173,768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1564,1564,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1807,1807,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2497,2500,2509,2509,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2879,2879,2881,2884,2893,2893,2901,2902,2914,2915,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3270,3270,3276,3277,3298,3299,3328,3329,3387,3388,3393,3396,3405,3405,3426,3427,3457,3457,3530,3530,3538,3540,3542,3542,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6862,6912,6915,6964,6964,6966,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8203,8203,8206,8207,8234,8238,8288,8292,8298,8303,8400,8432,11503,11505,11647,11647,11744,11775,12330,12333,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,65279,65279,65529,65531,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70464,70464,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70835,70840,70842,70842,70847,70848,70850,70851,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78896,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,113824,113827,118528,118573,118576,118598,119143,119145,119155,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125259,917505,917505,917536,917631,917760,917999 }); }
	static private void addProperty684() { addProperty("lb=xx", new int[] { 888,889,896,899,907,907,909,909,930,930,1328,1328,1367,1368,1419,1420,1424,1424,1480,1487,1515,1518,1525,1535,1806,1806,1867,1868,1970,1983,2043,2044,2094,2095,2111,2111,2140,2141,2143,2143,2155,2159,2191,2191,2194,2199,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2679,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2802,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2936,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3067,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3190,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3408,3411,3428,3429,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3573,3584,3643,3646,3676,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3912,3912,3949,3952,3992,3992,4029,4029,4045,4045,4059,4095,4294,4294,4296,4300,4302,4303,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4989,4991,5018,5023,5110,5111,5118,5119,5789,5791,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6110,6111,6122,6127,6138,6143,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6463,6465,6467,6510,6511,6517,6527,6572,6575,6602,6607,6619,6621,6684,6685,6751,6751,6781,6782,6794,6799,6810,6815,6830,6831,6863,6911,6989,6991,7039,7039,7156,7163,7224,7226,7242,7244,7305,7311,7355,7356,7368,7375,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8293,8293,8306,8307,8335,8335,8349,8351,8433,8447,8588,8591,9255,9279,9291,9311,11124,11125,11158,11158,11508,11512,11558,11558,11560,11564,11566,11567,11624,11630,11633,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12352,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,42125,42127,42183,42191,42540,42559,42744,42751,42955,42959,42962,42962,42964,42964,42970,42993,43053,43055,43066,43071,43128,43135,43206,43213,43226,43231,43348,43358,43389,43391,43470,43470,43482,43485,43519,43519,43575,43583,43598,43599,43610,43611,43715,43738,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43884,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,55295,57344,63743,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64451,64466,64912,64913,64968,64974,64976,65007,65050,65055,65107,65107,65127,65127,65132,65135,65141,65141,65277,65278,65280,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65528,65534,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65791,65795,65798,65844,65846,65935,65935,65949,65951,65953,65999,66046,66175,66205,66207,66257,66271,66300,66303,66340,66348,66379,66383,66427,66431,66462,66462,66500,66503,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66926,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67670,67743,67750,67760,67807,67827,67827,67830,67834,67868,67870,67898,67902,67904,67967,68024,68027,68048,68049,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,68175,68185,68191,68256,68287,68327,68330,68343,68351,68406,68408,68438,68439,68467,68471,68498,68504,68509,68520,68528,68607,68681,68735,68787,68799,68851,68857,68904,68911,68922,69215,69247,69247,69290,69290,69294,69295,69298,69372,69416,69423,69466,69487,69514,69551,69580,69599,69623,69631,69710,69713,69750,69758,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69960,69967,70007,70015,70112,70112,70133,70143,70162,70162,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70748,70748,70754,70783,70856,70863,70874,71039,71094,71095,71134,71167,71237,71247,71258,71263,71277,71295,71354,71359,71370,71423,71451,71452,71468,71471,71495,71679,71740,71839,71923,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72007,72015,72026,72095,72104,72105,72152,72153,72165,72191,72264,72271,72355,72367,72441,72447,72458,72703,72713,72713,72759,72759,72774,72783,72813,72815,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73562,73647,73649,73663,73714,73726,74650,74751,74863,74863,74869,74879,75076,77711,77811,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92998,93007,93018,93018,93026,93026,93048,93052,93072,93759,93851,93951,94027,94030,94088,94094,94112,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113819,113828,118527,118574,118575,118599,118607,118724,118783,119030,119039,119079,119080,119275,119295,119366,119487,119508,119519,119540,119551,119639,119647,119673,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,121484,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123216,123535,123567,123583,123642,123646,123648,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125126,125143,125183,125260,125263,125274,125277,125280,126064,126133,126208,126270,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,126703,126706,126975,129939,129939,129995,130031,130042,130047,131070,131071,196606,196607,262142,917504,917506,917535,917632,917759,918000,1114111 }); }
	static private void addProperty685() { addProperty("lb=ai", new int[] { 167,168,170,170,178,179,182,186,188,190,215,215,247,247,711,711,713,715,717,717,720,720,728,731,733,733,8213,8214,8224,8225,8251,8251,8308,8308,8319,8319,8321,8324,8453,8453,8467,8467,8481,8482,8491,8491,8532,8533,8539,8539,8542,8542,8544,8555,8560,8569,8585,8585,8592,8601,8658,8658,8660,8660,8704,8704,8706,8707,8711,8712,8715,8715,8719,8719,8721,8721,8725,8725,8730,8730,8733,8736,8739,8739,8741,8741,8743,8748,8750,8750,8756,8759,8764,8765,8776,8776,8780,8780,8786,8786,8800,8801,8804,8807,8810,8811,8814,8815,8834,8835,8838,8839,8853,8853,8857,8857,8869,8869,8895,8895,8978,8978,9312,9470,9472,9547,9552,9588,9600,9615,9618,9621,9632,9633,9635,9641,9650,9651,9654,9655,9660,9661,9664,9665,9670,9672,9675,9675,9678,9681,9698,9701,9711,9711,9733,9734,9737,9737,9742,9743,9750,9751,9792,9792,9794,9794,9824,9825,9827,9829,9831,9831,9833,9834,9836,9837,9839,9839,9886,9887,9929,9932,9938,9938,9941,9943,9946,9947,9949,9950,9955,9955,9960,9961,9963,9968,9974,9974,9979,9980,10071,10071,10102,10131,11093,11097,12872,12879,65533,65533,127232,127244,127248,127277,127280,127337,127344,127404 }); }
	static private void addProperty686() { addProperty("lb=al", new int[] { 35,35,38,38,42,42,60,62,64,90,94,122,126,126,166,166,169,169,172,172,174,175,181,181,192,214,216,246,248,710,718,719,721,727,732,732,734,734,736,767,880,887,890,893,895,895,900,906,908,908,910,929,931,1154,1162,1327,1329,1366,1369,1416,1421,1422,1472,1472,1475,1475,1523,1524,1536,1544,1550,1551,1568,1610,1645,1647,1649,1747,1749,1749,1757,1758,1765,1766,1769,1769,1774,1775,1786,1805,1807,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2039,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2096,2110,2112,2136,2142,2142,2144,2154,2160,2190,2192,2193,2208,2249,2274,2274,2308,2361,2365,2365,2384,2384,2392,2401,2416,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2548,2552,2554,2554,2556,2557,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2678,2678,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2800,2800,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2928,2935,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3056,3064,3066,3066,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3192,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3407,3412,3414,3416,3425,3440,3448,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3572,3572,3663,3663,3840,3840,3845,3845,3859,3859,3861,3863,3866,3871,3882,3891,3894,3894,3896,3896,3904,3911,3913,3948,3976,3980,4032,4037,4039,4044,4046,4047,4052,4056,4172,4175,4256,4293,4295,4295,4301,4301,4304,4351,4608,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4960,4960,4962,4988,4992,5017,5024,5109,5112,5117,5121,5759,5761,5786,5792,5866,5870,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6105,6105,6128,6137,6144,6145,6151,6151,6154,6154,6176,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6464,6464,6624,6678,6686,6687,6917,6963,6981,6988,7004,7004,7009,7018,7028,7036,7043,7072,7086,7087,7098,7141,7164,7203,7245,7247,7258,7293,7296,7304,7312,7354,7357,7367,7379,7379,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8188,8190,8190,8215,8215,8226,8227,8248,8248,8254,8259,8266,8277,8284,8284,8289,8292,8304,8305,8309,8316,8320,8320,8325,8332,8336,8348,8448,8450,8452,8452,8454,8456,8458,8466,8468,8469,8471,8480,8483,8490,8492,8531,8534,8538,8540,8541,8543,8543,8556,8559,8570,8584,8586,8587,8602,8657,8659,8659,8661,8703,8705,8705,8708,8710,8713,8714,8716,8718,8720,8720,8724,8724,8726,8729,8731,8732,8737,8738,8740,8740,8742,8742,8749,8749,8751,8755,8760,8763,8766,8775,8777,8779,8781,8785,8787,8799,8802,8803,8808,8809,8812,8813,8816,8833,8836,8837,8840,8852,8854,8856,8858,8868,8870,8894,8896,8942,8944,8967,8972,8977,8979,8985,8988,9000,9003,9199,9204,9254,9280,9290,9471,9471,9548,9551,9589,9599,9616,9617,9622,9631,9634,9634,9642,9649,9652,9653,9656,9659,9662,9663,9666,9669,9673,9674,9676,9677,9682,9697,9702,9710,9712,9727,9732,9732,9735,9736,9738,9741,9744,9747,9753,9753,9760,9784,9788,9791,9793,9793,9795,9823,9826,9826,9830,9830,9835,9835,9838,9838,9840,9854,9856,9885,9888,9916,9934,9934,9954,9954,9956,9959,9989,9991,9998,10070,10072,10074,10081,10081,10085,10087,10132,10180,10183,10213,10224,10626,10649,10711,10716,10747,10750,11092,11098,11123,11126,11157,11159,11502,11506,11507,11517,11517,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11798,11798,11802,11803,11806,11807,11823,11823,11826,11826,11829,11833,11839,11839,11851,11851,11853,11853,11856,11858,19904,19967,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42611,42611,42622,42653,42656,42735,42738,42738,42752,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43042,43048,43051,43056,43063,43065,43065,43072,43123,43138,43187,43250,43259,43261,43262,43274,43301,43312,43334,43359,43359,43396,43442,43457,43462,43466,43469,43471,43471,43486,43487,43520,43560,43584,43586,43588,43595,43612,43612,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43883,43888,44002,64256,64262,64275,64279,64297,64297,64336,64450,64467,64829,64832,64911,64914,64967,64975,64975,65008,65019,65021,65023,65136,65140,65142,65276,65512,65518,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65799,65843,65847,65934,65936,65948,65952,65952,66000,66044,66176,66204,66208,66256,66273,66299,66304,66339,66349,66378,66384,66421,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66927,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67672,67742,67751,67759,67808,67826,67828,67829,67835,67867,67872,67897,67903,67903,67968,68023,68028,68047,68050,68096,68112,68115,68117,68119,68121,68149,68160,68168,68184,68184,68192,68255,68288,68324,68331,68335,68352,68405,68416,68437,68440,68466,68472,68497,68505,68508,68521,68527,68608,68680,68736,68786,68800,68850,68858,68899,69216,69246,69248,69289,69296,69297,69376,69415,69424,69445,69457,69465,69488,69505,69510,69513,69552,69579,69600,69622,69635,69687,69705,69709,69714,69733,69745,69746,69749,69749,69763,69807,69819,69821,69837,69837,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70004,70004,70006,70006,70019,70066,70081,70084,70087,70087,70093,70093,70106,70106,70108,70108,70113,70132,70144,70161,70163,70187,70202,70202,70205,70205,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70735,70735,70749,70749,70751,70753,70784,70831,70852,70855,71040,71086,71110,71112,71128,71131,71168,71215,71235,71236,71296,71338,71352,71353,71680,71723,71739,71739,71840,71903,71914,71922,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72256,72256,72262,72262,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72794,72812,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73463,73464,73474,73474,73476,73488,73490,73523,73648,73648,73664,73692,73697,73713,73728,74649,74752,74862,74880,75075,77712,77810,77824,78423,78430,78465,78467,78469,78474,78712,78716,78895,78913,78918,82944,83405,83408,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92986,92995,92997,92997,93019,93025,93027,93047,93053,93071,93760,93846,93849,93850,93952,94026,94032,94032,94099,94111,101120,101589,110576,110579,110581,110587,110589,110590,113664,113770,113776,113788,113792,113800,113808,113817,113820,113820,118608,118723,118784,119029,119040,119078,119081,119140,119146,119148,119171,119172,119180,119209,119214,119274,119296,119361,119365,119365,119488,119507,119520,119539,119552,119638,119648,119672,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120832,121343,121399,121402,121453,121460,121462,121475,121477,121478,121483,121483,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123214,123215,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125127,125135,125184,125251,125259,125259,126065,126123,126125,126127,126129,126132,126209,126269,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705,127278,127279,127338,127340,127900,127901,127925,127926,127932,127932,128160,128160,128162,128162,128164,128164,128175,128175,128177,128178,128256,128262,128279,128292,128306,128329,128468,128475,128500,128505,128592,128629,128636,128639,128768,128883,128896,128980,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129280,129291,129536,129619,129792,129938,129940,129994 }); }
	static private void addProperty687() { addProperty("lb=b2", new int[] { 8212,8212,11834,11835 }); }
	static private void addProperty688() { addProperty("lb=ba", new int[] { 9,9,124,124,173,173,1418,1418,1470,1470,2404,2405,3674,3675,3851,3851,3892,3892,3967,3967,3973,3973,4030,4031,4050,4050,4170,4171,4961,4961,5120,5120,5760,5760,5867,5869,5941,5942,6100,6101,6104,6104,6106,6106,6148,6149,7002,7003,7005,7008,7037,7038,7227,7231,7294,7295,8192,8198,8200,8202,8208,8208,8210,8211,8231,8231,8278,8278,8280,8283,8285,8287,11514,11516,11519,11519,11632,11632,11790,11797,11799,11799,11801,11801,11818,11821,11824,11825,11827,11828,11836,11838,11840,11841,11843,11850,11852,11852,11854,11855,11869,11869,12288,12288,42238,42239,42509,42509,42511,42511,42739,42743,43214,43215,43310,43311,43463,43465,43613,43615,43760,43761,44011,44011,65792,65794,66463,66463,66512,66512,67671,67671,67871,67871,68176,68183,68336,68341,68409,68415,69293,69293,69703,69704,69822,69825,69952,69955,70085,70086,70088,70088,70109,70111,70200,70201,70203,70204,70313,70313,70731,70734,70746,70747,71106,71107,71113,71127,71233,71234,71484,71486,72004,72006,72257,72260,72346,72348,72353,72354,72769,72773,73539,73540,73727,73727,74864,74868,92782,92783,92917,92917,92983,92985,92996,92996,93847,93848,113823,113823,121479,121482 }); }
	static private void addProperty689() { addProperty("lb=bb", new int[] { 180,180,712,712,716,716,735,735,3191,3191,3204,3204,3841,3844,3846,3847,3849,3850,4048,4049,4051,4051,6150,6150,8189,8189,43124,43125,43260,43260,70005,70005,70107,70107,71105,71105,71264,71276,72162,72162,72255,72255,72261,72261,72350,72352,72448,72457,72816,72816 }); }
	static private void addProperty690() { addProperty("lb=bk", new int[] { 11,12,8232,8233 }); }
	static private void addProperty691() { addProperty("lb=cb", new int[] { 65532,65532 }); }
	static private void addProperty692() { addProperty("lb=cl", new int[] { 125,125,3899,3899,3901,3901,5788,5788,8262,8262,8318,8318,8334,8334,8969,8969,8971,8971,9002,9002,10089,10089,10091,10091,10093,10093,10095,10095,10097,10097,10099,10099,10101,10101,10182,10182,10215,10215,10217,10217,10219,10219,10221,10221,10223,10223,10628,10628,10630,10630,10632,10632,10634,10634,10636,10636,10638,10638,10640,10640,10642,10642,10644,10644,10646,10646,10648,10648,10713,10713,10715,10715,10749,10749,11811,11811,11813,11813,11815,11815,11817,11817,11862,11862,11864,11864,11866,11866,11868,11868,12289,12290,12297,12297,12299,12299,12301,12301,12303,12303,12305,12305,12309,12309,12311,12311,12313,12313,12315,12315,12318,12319,64830,64830,65041,65042,65048,65048,65078,65078,65080,65080,65082,65082,65084,65084,65086,65086,65088,65088,65090,65090,65092,65092,65096,65096,65104,65104,65106,65106,65114,65114,65116,65116,65118,65118,65289,65289,65292,65292,65294,65294,65341,65341,65373,65373,65376,65377,65379,65380,78427,78429,78466,78466,78471,78471,78473,78473,78714,78715,78904,78904,78909,78909,78911,78911,83407,83407 }); }
	static private void addProperty693() { addProperty("lb=cm", new int[] { 0,8,14,31,127,132,134,159,768,846,848,859,867,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1564,1564,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2307,2362,2364,2366,2383,2385,2391,2402,2403,2433,2435,2492,2492,2494,2500,2503,2504,2507,2509,2519,2519,2530,2531,2558,2558,2561,2563,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2691,2748,2748,2750,2757,2759,2761,2763,2765,2786,2787,2810,2815,2817,2819,2876,2876,2878,2884,2887,2888,2891,2893,2901,2903,2914,2915,2946,2946,3006,3010,3014,3016,3018,3021,3031,3031,3072,3076,3132,3132,3134,3140,3142,3144,3146,3149,3157,3158,3170,3171,3201,3203,3260,3260,3262,3268,3270,3272,3274,3277,3285,3286,3298,3299,3315,3315,3328,3331,3387,3388,3390,3396,3398,3400,3402,3405,3415,3415,3426,3427,3457,3459,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3864,3865,3893,3893,3895,3895,3897,3897,3902,3903,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4957,4959,5906,5909,5938,5940,5970,5971,6002,6003,6155,6157,6159,6159,6277,6278,6313,6313,6432,6443,6448,6459,6679,6683,6783,6783,6832,6862,6912,6916,6964,6980,7019,7027,7040,7042,7073,7085,7142,7155,7204,7223,7376,7378,7380,7400,7405,7405,7412,7412,7415,7417,7616,7628,7630,7675,7677,7679,8204,8204,8206,8207,8234,8238,8294,8303,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12341,12341,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43043,43047,43052,43052,43136,43137,43188,43205,43232,43249,43263,43263,43302,43309,43335,43347,43392,43395,43443,43456,43561,43574,43587,43587,43596,43597,43755,43759,43765,43766,44003,44010,44012,44013,64286,64286,65024,65039,65056,65071,65529,65531,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69632,69634,69688,69702,69744,69744,69747,69748,69759,69762,69808,69818,69826,69826,69888,69890,69927,69940,69957,69958,70003,70003,70016,70018,70067,70080,70089,70092,70094,70095,70188,70199,70206,70206,70209,70209,70367,70378,70400,70403,70459,70460,70462,70468,70471,70472,70475,70477,70487,70487,70498,70499,70502,70508,70512,70516,70709,70726,70750,70750,70832,70851,71087,71093,71096,71104,71132,71133,71216,71232,71339,71351,71724,71738,71984,71989,71991,71992,71995,71998,72000,72000,72002,72003,72145,72151,72154,72160,72164,72164,72193,72202,72243,72249,72251,72254,72263,72263,72273,72283,72330,72345,72751,72758,72760,72767,72850,72871,72873,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73098,73102,73104,73105,73107,73111,73459,73462,73472,73473,73475,73475,73524,73530,73534,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94033,94087,94095,94098,94192,94193,113821,113822,113824,113827,118528,118573,118576,118598,119141,119145,119149,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917505,917505,917536,917631,917760,917999 }); }
	static private void addProperty694() { addProperty("lb=cr", new int[] { 13,13 }); }
	static private void addProperty695() { addProperty("lb=ex", new int[] { 33,33,63,63,1478,1478,1563,1563,1565,1567,1748,1748,2041,2041,3853,3857,3860,3860,6146,6147,6152,6153,6468,6469,10082,10083,11513,11513,11518,11518,11822,11822,11859,11860,42510,42510,43126,43127,65045,65046,65110,65111,65281,65281,65311,65311,71108,71109,72817,72817 }); }
	static private void addProperty696() { addProperty("lb=gl", new int[] { 160,160,847,847,860,866,3848,3848,3852,3852,3858,3858,4057,4058,6158,6158,7629,7629,7676,7676,8199,8199,8209,8209,8239,8239,78896,78902,78905,78907,94180,94180 }); }
	static private void addProperty697() { addProperty("lb=hy", new int[] { 45,45 }); }
	static private void addProperty698() { addProperty("lb=id", new int[] { 8986,8987,9200,9203,9728,9731,9748,9749,9752,9752,9754,9756,9758,9759,9785,9787,9832,9832,9855,9855,9917,9928,9933,9933,9935,9937,9939,9940,9944,9945,9948,9948,9951,9953,9962,9962,9969,9973,9975,9976,9978,9978,9981,9988,9992,9993,10084,10084,11904,11929,11931,12019,12032,12245,12272,12283,12291,12292,12294,12295,12306,12307,12320,12329,12336,12340,12342,12346,12349,12351,12354,12354,12356,12356,12358,12358,12360,12360,12362,12386,12388,12418,12420,12420,12422,12422,12424,12429,12431,12436,12447,12447,12450,12450,12452,12452,12454,12454,12456,12456,12458,12482,12484,12514,12516,12516,12518,12518,12520,12525,12527,12532,12535,12538,12543,12543,12549,12591,12593,12686,12688,12771,12800,12830,12832,12871,12880,19903,19968,40980,40982,42124,42128,42182,63744,64255,65072,65076,65093,65094,65097,65103,65105,65105,65112,65112,65119,65126,65128,65128,65131,65131,65282,65283,65286,65287,65290,65291,65293,65293,65295,65305,65308,65310,65312,65338,65340,65340,65342,65370,65372,65372,65374,65374,65382,65382,65393,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65506,65508,73541,73551,94208,100343,100352,101119,101632,101640,110592,110882,110960,111355,126976,127231,127245,127247,127341,127343,127405,127461,127488,127876,127878,127899,127902,127924,127927,127931,127933,127937,127941,127942,127944,127945,127949,127994,128000,128065,128068,128069,128081,128101,128121,128123,128125,128128,128132,128132,128136,128142,128144,128144,128146,128159,128161,128161,128163,128163,128165,128169,128171,128174,128176,128176,128179,128255,128263,128278,128293,128305,128330,128371,128374,128377,128379,128399,128401,128404,128407,128467,128476,128499,128506,128580,128584,128586,128640,128674,128676,128691,128695,128703,128705,128715,128717,128767,128884,128895,128981,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129279,129293,129294,129296,129303,129312,129317,129319,129327,129338,129339,129343,129398,129400,129460,129463,129463,129466,129466,129468,129484,129488,129488,129502,129535,129620,129730,129734,129775,129785,129791,130048,131069,131072,196605,196608,262141 }); }
	static private void addProperty699() { addProperty("lb=in", new int[] { 8228,8230,8943,8943,65049,65049,68342,68342 }); }
	static private void addProperty700() { addProperty("lb=is", new int[] { 44,44,46,46,58,59,894,894,1417,1417,1548,1549,2040,2040,8260,8260,65040,65040,65043,65044 }); }
	static private void addProperty701() { addProperty("lb=lf", new int[] { 10,10 }); }
	static private void addProperty702() { addProperty("lb=ns", new int[] { 6102,6102,8252,8253,8263,8265,12293,12293,12316,12316,12347,12348,12443,12446,12448,12448,12539,12539,12541,12542,40981,40981,65108,65109,65306,65307,65381,65381,65438,65439,94176,94179,128633,128635 }); }
	static private void addProperty703() { addProperty("lb=nu", new int[] { 48,57,1632,1641,1643,1644,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty704() { addProperty("lb=op", new int[] { 40,40,91,91,123,123,161,161,191,191,3898,3898,3900,3900,5787,5787,8218,8218,8222,8222,8261,8261,8317,8317,8333,8333,8968,8968,8970,8970,9001,9001,10088,10088,10090,10090,10092,10092,10094,10094,10096,10096,10098,10098,10100,10100,10181,10181,10214,10214,10216,10216,10218,10218,10220,10220,10222,10222,10627,10627,10629,10629,10631,10631,10633,10633,10635,10635,10637,10637,10639,10639,10641,10641,10643,10643,10645,10645,10647,10647,10712,10712,10714,10714,10748,10748,11800,11800,11810,11810,11812,11812,11814,11814,11816,11816,11842,11842,11861,11861,11863,11863,11865,11865,11867,11867,12296,12296,12298,12298,12300,12300,12302,12302,12304,12304,12308,12308,12310,12310,12312,12312,12314,12314,12317,12317,64831,64831,65047,65047,65077,65077,65079,65079,65081,65081,65083,65083,65085,65085,65087,65087,65089,65089,65091,65091,65095,65095,65113,65113,65115,65115,65117,65117,65288,65288,65339,65339,65371,65371,65375,65375,65378,65378,78424,78426,78470,78470,78472,78472,78713,78713,78903,78903,78908,78908,78910,78910,83406,83406,125278,125279 }); }
	static private void addProperty705() { addProperty("lb=po", new int[] { 37,37,162,162,176,176,1545,1547,1642,1642,2546,2547,2553,2553,3449,3449,8240,8247,8279,8279,8359,8359,8374,8374,8379,8379,8382,8382,8384,8384,8451,8451,8457,8457,43064,43064,65020,65020,65130,65130,65285,65285,65504,65504,73693,73696,126124,126124,126128,126128 }); }
	static private void addProperty706() { addProperty("lb=pr", new int[] { 36,36,43,43,92,92,163,165,177,177,1423,1423,2046,2047,2555,2555,2801,2801,3065,3065,3647,3647,6107,6107,8352,8358,8360,8373,8375,8378,8380,8381,8383,8383,8385,8399,8470,8470,8722,8723,65129,65129,65284,65284,65505,65505,65509,65510,123647,123647 }); }
	static private void addProperty707() { addProperty("lb=qu", new int[] { 34,34,39,39,171,171,187,187,8216,8217,8219,8221,8223,8223,8249,8250,10075,10080,11776,11789,11804,11805,11808,11809,128630,128632 }); }
	static private void addProperty708() { addProperty("lb=sa", new int[] { 3585,3642,3648,3662,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3804,3807,4096,4159,4176,4239,4250,4255,6016,6099,6103,6103,6108,6109,6480,6509,6512,6516,6528,6571,6576,6601,6618,6618,6622,6623,6688,6750,6752,6780,6816,6829,43488,43503,43514,43518,43616,43714,43739,43743,71424,71450,71453,71467,71482,71483,71487,71494 }); }
	static private void addProperty709() { addProperty("lb=sg", new int[] { 55296,57343 }); }
	static private void addProperty710() { addProperty("lb=sp", new int[] { 32,32 }); }
	static private void addProperty711() { addProperty("lb=sy", new int[] { 47,47 }); }
	static private void addProperty712() { addProperty("lb=zw", new int[] { 8203,8203 }); }
	static private void addProperty713() { addProperty("lb=nl", new int[] { 133,133 }); }
	static private void addProperty714() { addProperty("lb=wj", new int[] { 8288,8288,65279,65279 }); }
	static private void addProperty715() { addProperty("lb=h2", new int[] { 44032,44032,44060,44060,44088,44088,44116,44116,44144,44144,44172,44172,44200,44200,44228,44228,44256,44256,44284,44284,44312,44312,44340,44340,44368,44368,44396,44396,44424,44424,44452,44452,44480,44480,44508,44508,44536,44536,44564,44564,44592,44592,44620,44620,44648,44648,44676,44676,44704,44704,44732,44732,44760,44760,44788,44788,44816,44816,44844,44844,44872,44872,44900,44900,44928,44928,44956,44956,44984,44984,45012,45012,45040,45040,45068,45068,45096,45096,45124,45124,45152,45152,45180,45180,45208,45208,45236,45236,45264,45264,45292,45292,45320,45320,45348,45348,45376,45376,45404,45404,45432,45432,45460,45460,45488,45488,45516,45516,45544,45544,45572,45572,45600,45600,45628,45628,45656,45656,45684,45684,45712,45712,45740,45740,45768,45768,45796,45796,45824,45824,45852,45852,45880,45880,45908,45908,45936,45936,45964,45964,45992,45992,46020,46020,46048,46048,46076,46076,46104,46104,46132,46132,46160,46160,46188,46188,46216,46216,46244,46244,46272,46272,46300,46300,46328,46328,46356,46356,46384,46384,46412,46412,46440,46440,46468,46468,46496,46496,46524,46524,46552,46552,46580,46580,46608,46608,46636,46636,46664,46664,46692,46692,46720,46720,46748,46748,46776,46776,46804,46804,46832,46832,46860,46860,46888,46888,46916,46916,46944,46944,46972,46972,47000,47000,47028,47028,47056,47056,47084,47084,47112,47112,47140,47140,47168,47168,47196,47196,47224,47224,47252,47252,47280,47280,47308,47308,47336,47336,47364,47364,47392,47392,47420,47420,47448,47448,47476,47476,47504,47504,47532,47532,47560,47560,47588,47588,47616,47616,47644,47644,47672,47672,47700,47700,47728,47728,47756,47756,47784,47784,47812,47812,47840,47840,47868,47868,47896,47896,47924,47924,47952,47952,47980,47980,48008,48008,48036,48036,48064,48064,48092,48092,48120,48120,48148,48148,48176,48176,48204,48204,48232,48232,48260,48260,48288,48288,48316,48316,48344,48344,48372,48372,48400,48400,48428,48428,48456,48456,48484,48484,48512,48512,48540,48540,48568,48568,48596,48596,48624,48624,48652,48652,48680,48680,48708,48708,48736,48736,48764,48764,48792,48792,48820,48820,48848,48848,48876,48876,48904,48904,48932,48932,48960,48960,48988,48988,49016,49016,49044,49044,49072,49072,49100,49100,49128,49128,49156,49156,49184,49184,49212,49212,49240,49240,49268,49268,49296,49296,49324,49324,49352,49352,49380,49380,49408,49408,49436,49436,49464,49464,49492,49492,49520,49520,49548,49548,49576,49576,49604,49604,49632,49632,49660,49660,49688,49688,49716,49716,49744,49744,49772,49772,49800,49800,49828,49828,49856,49856,49884,49884,49912,49912,49940,49940,49968,49968,49996,49996,50024,50024,50052,50052,50080,50080,50108,50108,50136,50136,50164,50164,50192,50192,50220,50220,50248,50248,50276,50276,50304,50304,50332,50332,50360,50360,50388,50388,50416,50416,50444,50444,50472,50472,50500,50500,50528,50528,50556,50556,50584,50584,50612,50612,50640,50640,50668,50668,50696,50696,50724,50724,50752,50752,50780,50780,50808,50808,50836,50836,50864,50864,50892,50892,50920,50920,50948,50948,50976,50976,51004,51004,51032,51032,51060,51060,51088,51088,51116,51116,51144,51144,51172,51172,51200,51200,51228,51228,51256,51256,51284,51284,51312,51312,51340,51340,51368,51368,51396,51396,51424,51424,51452,51452,51480,51480,51508,51508,51536,51536,51564,51564,51592,51592,51620,51620,51648,51648,51676,51676,51704,51704,51732,51732,51760,51760,51788,51788,51816,51816,51844,51844,51872,51872,51900,51900,51928,51928,51956,51956,51984,51984,52012,52012,52040,52040,52068,52068,52096,52096,52124,52124,52152,52152,52180,52180,52208,52208,52236,52236,52264,52264,52292,52292,52320,52320,52348,52348,52376,52376,52404,52404,52432,52432,52460,52460,52488,52488,52516,52516,52544,52544,52572,52572,52600,52600,52628,52628,52656,52656,52684,52684,52712,52712,52740,52740,52768,52768,52796,52796,52824,52824,52852,52852,52880,52880,52908,52908,52936,52936,52964,52964,52992,52992,53020,53020,53048,53048,53076,53076,53104,53104,53132,53132,53160,53160,53188,53188,53216,53216,53244,53244,53272,53272,53300,53300,53328,53328,53356,53356,53384,53384,53412,53412,53440,53440,53468,53468,53496,53496,53524,53524,53552,53552,53580,53580,53608,53608,53636,53636,53664,53664,53692,53692,53720,53720,53748,53748,53776,53776,53804,53804,53832,53832,53860,53860,53888,53888,53916,53916,53944,53944,53972,53972,54000,54000,54028,54028,54056,54056,54084,54084,54112,54112,54140,54140,54168,54168,54196,54196,54224,54224,54252,54252,54280,54280,54308,54308,54336,54336,54364,54364,54392,54392,54420,54420,54448,54448,54476,54476,54504,54504,54532,54532,54560,54560,54588,54588,54616,54616,54644,54644,54672,54672,54700,54700,54728,54728,54756,54756,54784,54784,54812,54812,54840,54840,54868,54868,54896,54896,54924,54924,54952,54952,54980,54980,55008,55008,55036,55036,55064,55064,55092,55092,55120,55120,55148,55148,55176,55176 }); }
	static private void addProperty716() { addProperty("lb=h3", new int[] { 44033,44059,44061,44087,44089,44115,44117,44143,44145,44171,44173,44199,44201,44227,44229,44255,44257,44283,44285,44311,44313,44339,44341,44367,44369,44395,44397,44423,44425,44451,44453,44479,44481,44507,44509,44535,44537,44563,44565,44591,44593,44619,44621,44647,44649,44675,44677,44703,44705,44731,44733,44759,44761,44787,44789,44815,44817,44843,44845,44871,44873,44899,44901,44927,44929,44955,44957,44983,44985,45011,45013,45039,45041,45067,45069,45095,45097,45123,45125,45151,45153,45179,45181,45207,45209,45235,45237,45263,45265,45291,45293,45319,45321,45347,45349,45375,45377,45403,45405,45431,45433,45459,45461,45487,45489,45515,45517,45543,45545,45571,45573,45599,45601,45627,45629,45655,45657,45683,45685,45711,45713,45739,45741,45767,45769,45795,45797,45823,45825,45851,45853,45879,45881,45907,45909,45935,45937,45963,45965,45991,45993,46019,46021,46047,46049,46075,46077,46103,46105,46131,46133,46159,46161,46187,46189,46215,46217,46243,46245,46271,46273,46299,46301,46327,46329,46355,46357,46383,46385,46411,46413,46439,46441,46467,46469,46495,46497,46523,46525,46551,46553,46579,46581,46607,46609,46635,46637,46663,46665,46691,46693,46719,46721,46747,46749,46775,46777,46803,46805,46831,46833,46859,46861,46887,46889,46915,46917,46943,46945,46971,46973,46999,47001,47027,47029,47055,47057,47083,47085,47111,47113,47139,47141,47167,47169,47195,47197,47223,47225,47251,47253,47279,47281,47307,47309,47335,47337,47363,47365,47391,47393,47419,47421,47447,47449,47475,47477,47503,47505,47531,47533,47559,47561,47587,47589,47615,47617,47643,47645,47671,47673,47699,47701,47727,47729,47755,47757,47783,47785,47811,47813,47839,47841,47867,47869,47895,47897,47923,47925,47951,47953,47979,47981,48007,48009,48035,48037,48063,48065,48091,48093,48119,48121,48147,48149,48175,48177,48203,48205,48231,48233,48259,48261,48287,48289,48315,48317,48343,48345,48371,48373,48399,48401,48427,48429,48455,48457,48483,48485,48511,48513,48539,48541,48567,48569,48595,48597,48623,48625,48651,48653,48679,48681,48707,48709,48735,48737,48763,48765,48791,48793,48819,48821,48847,48849,48875,48877,48903,48905,48931,48933,48959,48961,48987,48989,49015,49017,49043,49045,49071,49073,49099,49101,49127,49129,49155,49157,49183,49185,49211,49213,49239,49241,49267,49269,49295,49297,49323,49325,49351,49353,49379,49381,49407,49409,49435,49437,49463,49465,49491,49493,49519,49521,49547,49549,49575,49577,49603,49605,49631,49633,49659,49661,49687,49689,49715,49717,49743,49745,49771,49773,49799,49801,49827,49829,49855,49857,49883,49885,49911,49913,49939,49941,49967,49969,49995,49997,50023,50025,50051,50053,50079,50081,50107,50109,50135,50137,50163,50165,50191,50193,50219,50221,50247,50249,50275,50277,50303,50305,50331,50333,50359,50361,50387,50389,50415,50417,50443,50445,50471,50473,50499,50501,50527,50529,50555,50557,50583,50585,50611,50613,50639,50641,50667,50669,50695,50697,50723,50725,50751,50753,50779,50781,50807,50809,50835,50837,50863,50865,50891,50893,50919,50921,50947,50949,50975,50977,51003,51005,51031,51033,51059,51061,51087,51089,51115,51117,51143,51145,51171,51173,51199,51201,51227,51229,51255,51257,51283,51285,51311,51313,51339,51341,51367,51369,51395,51397,51423,51425,51451,51453,51479,51481,51507,51509,51535,51537,51563,51565,51591,51593,51619,51621,51647,51649,51675,51677,51703,51705,51731,51733,51759,51761,51787,51789,51815,51817,51843,51845,51871,51873,51899,51901,51927,51929,51955,51957,51983,51985,52011,52013,52039,52041,52067,52069,52095,52097,52123,52125,52151,52153,52179,52181,52207,52209,52235,52237,52263,52265,52291,52293,52319,52321,52347,52349,52375,52377,52403,52405,52431,52433,52459,52461,52487,52489,52515,52517,52543,52545,52571,52573,52599,52601,52627,52629,52655,52657,52683,52685,52711,52713,52739,52741,52767,52769,52795,52797,52823,52825,52851,52853,52879,52881,52907,52909,52935,52937,52963,52965,52991,52993,53019,53021,53047,53049,53075,53077,53103,53105,53131,53133,53159,53161,53187,53189,53215,53217,53243,53245,53271,53273,53299,53301,53327,53329,53355,53357,53383,53385,53411,53413,53439,53441,53467,53469,53495,53497,53523,53525,53551,53553,53579,53581,53607,53609,53635,53637,53663,53665,53691,53693,53719,53721,53747,53749,53775,53777,53803,53805,53831,53833,53859,53861,53887,53889,53915,53917,53943,53945,53971,53973,53999,54001,54027,54029,54055,54057,54083,54085,54111,54113,54139,54141,54167,54169,54195,54197,54223,54225,54251,54253,54279,54281,54307,54309,54335,54337,54363,54365,54391,54393,54419,54421,54447,54449,54475,54477,54503,54505,54531,54533,54559,54561,54587,54589,54615,54617,54643,54645,54671,54673,54699,54701,54727,54729,54755,54757,54783,54785,54811,54813,54839,54841,54867,54869,54895,54897,54923,54925,54951,54953,54979,54981,55007,55009,55035,55037,55063,55065,55091,55093,55119,55121,55147,55149,55175,55177,55203 }); }
	static private void addProperty717() { addProperty("lb=jl", new int[] { 4352,4447,43360,43388 }); }
	static private void addProperty718() { addProperty("lb=jt", new int[] { 4520,4607,55243,55291 }); }
	static private void addProperty719() { addProperty("lb=jv", new int[] { 4448,4519,55216,55238 }); }
	static private void addProperty720() { addProperty("lb=cp", new int[] { 41,41,93,93 }); }
	static private void addProperty721() { addProperty("lb=cj", new int[] { 12353,12353,12355,12355,12357,12357,12359,12359,12361,12361,12387,12387,12419,12419,12421,12421,12423,12423,12430,12430,12437,12438,12449,12449,12451,12451,12453,12453,12455,12455,12457,12457,12483,12483,12515,12515,12517,12517,12519,12519,12526,12526,12533,12534,12540,12540,12784,12799,65383,65392,110898,110898,110928,110930,110933,110933,110948,110951 }); }
	static private void addProperty722() { addProperty("lb=hl", new int[] { 1488,1514,1519,1522,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64335 }); }
	static private void addProperty723() { addProperty("lb=ri", new int[] { 127462,127487 }); }
	static private void addProperty724() { addProperty("lb=eb", new int[] { 9757,9757,9977,9977,9994,9997,127877,127877,127938,127940,127943,127943,127946,127948,128066,128067,128070,128080,128102,128120,128124,128124,128129,128131,128133,128135,128143,128143,128145,128145,128170,128170,128372,128373,128378,128378,128400,128400,128405,128406,128581,128583,128587,128591,128675,128675,128692,128694,128704,128704,128716,128716,129292,129292,129295,129295,129304,129311,129318,129318,129328,129337,129340,129342,129399,129399,129461,129462,129464,129465,129467,129467,129485,129487,129489,129501,129731,129733,129776,129784 }); }
	static private void addProperty725() { addProperty("lb=em", new int[] { 127995,127999 }); }
	static private void addProperty726() { addProperty("lb=zwj", new int[] { 8205,8205 }); }
	static private void addProperty727() { addProperty("nt=none", new int[] { 0,47,58,177,180,184,186,187,191,1631,1642,1775,1786,1983,1994,2405,2416,2533,2544,2547,2554,2661,2672,2789,2800,2917,2928,2929,2936,3045,3059,3173,3184,3191,3199,3301,3312,3415,3423,3429,3449,3557,3568,3663,3674,3791,3802,3871,3892,4159,4170,4239,4250,4968,4989,5869,5873,6111,6122,6127,6138,6159,6170,6469,6480,6607,6619,6783,6794,6799,6810,6991,7002,7087,7098,7231,7242,7247,7258,8303,8305,8307,8314,8319,8330,8527,8579,8580,8586,9311,9372,9449,9472,10101,10132,11516,11518,12294,12296,12320,12330,12343,12347,12689,12694,12831,12842,12871,12880,12880,12896,12927,12938,12976,12992,13316,13318,13442,13444,14377,14379,15180,15182,19967,19969,19970,19972,19974,19976,19976,19978,20060,20062,20107,20109,20115,20117,20117,20119,20158,20161,20190,20192,20199,20201,20236,20238,20335,20337,20739,20741,20805,20807,20840,20842,20842,20844,20844,20846,21312,21314,21314,21318,21323,21325,21440,21445,22234,22236,22768,22770,22776,22778,24185,24187,24317,24320,24331,24335,24335,24337,25341,25343,25419,25421,26577,26579,28421,28423,29589,29591,30333,30335,32901,32903,33835,33837,36013,36015,36018,36020,36143,36145,38432,38434,38469,38471,38475,38477,38519,38521,38645,38647,42527,42538,42725,42736,43055,43062,43215,43226,43263,43274,43471,43482,43503,43514,43599,43610,44015,44026,63850,63852,63858,63860,63863,63865,63921,63923,63952,63954,63954,63956,63996,63998,65295,65306,65798,65844,65855,65913,65929,65932,66272,66300,66335,66340,66368,66370,66377,66379,66512,66518,66719,66730,67671,67680,67704,67712,67750,67760,67834,67840,67861,67868,68027,68030,68031,68048,68049,68096,68159,68169,68220,68223,68252,68256,68330,68336,68439,68448,68471,68480,68520,68528,68857,68864,68911,68922,69215,69247,69404,69415,69456,69461,69572,69580,69713,69744,69871,69882,69941,69952,70095,70106,70112,70133,70383,70394,70735,70746,70863,70874,71247,71258,71359,71370,71471,71484,71903,71923,72015,72026,72783,72813,73039,73050,73119,73130,73551,73562,73663,73685,74751,74863,92767,92778,92863,92874,93007,93018,93018,93026,93823,93847,119487,119508,119519,119540,119647,119673,120781,120832,123199,123210,123631,123642,124143,124154,125126,125136,125263,125274,126064,126124,126124,126128,126128,126133,126208,126254,126254,126270,127231,127245,130031,130042,131072,131074,131171,131173,131297,131299,131360,131362,133417,133419,133506,133508,133515,133517,133531,133533,133865,133867,133884,133886,133912,133914,140175,140177,141719,141721,146202,146204,156268,156270,194703,194705,1114111 }); }
	static private void addProperty728() { addProperty("nt=de", new int[] { 48,57,1632,1641,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty729() { addProperty("nt=di", new int[] { 178,179,185,185,4969,4977,6618,6618,8304,8304,8308,8313,8320,8329,9312,9320,9332,9340,9352,9360,9450,9450,9461,9469,9471,9471,10102,10110,10112,10120,10122,10130,68160,68163,69216,69224,69714,69722,127232,127242 }); }
	static private void addProperty730() { addProperty("nt=nu", new int[] { 188,190,2548,2553,2930,2935,3056,3058,3192,3198,3416,3422,3440,3448,3882,3891,4978,4988,5870,5872,6128,6137,8528,8578,8581,8585,9321,9331,9341,9351,9361,9371,9451,9460,9470,9470,10111,10111,10121,10121,10131,10131,11517,11517,12295,12295,12321,12329,12344,12346,12690,12693,12832,12841,12872,12879,12881,12895,12928,12937,12977,12991,13317,13317,13443,13443,14378,14378,15181,15181,19968,19968,19971,19971,19975,19975,19977,19977,20061,20061,20108,20108,20116,20116,20118,20118,20159,20160,20191,20191,20200,20200,20237,20237,20336,20336,20740,20740,20806,20806,20841,20841,20843,20843,20845,20845,21313,21313,21315,21317,21324,21324,21441,21444,22235,22235,22769,22769,22777,22777,24186,24186,24318,24319,24332,24334,24336,24336,25342,25342,25420,25420,26578,26578,28422,28422,29590,29590,30334,30334,32902,32902,33836,33836,36014,36014,36019,36019,36144,36144,38433,38433,38470,38470,38476,38476,38520,38520,38646,38646,42726,42735,43056,43061,63851,63851,63859,63859,63864,63864,63922,63922,63953,63953,63955,63955,63997,63997,65799,65843,65856,65912,65930,65931,66273,66299,66336,66339,66369,66369,66378,66378,66513,66517,67672,67679,67705,67711,67751,67759,67835,67839,67862,67867,68028,68029,68032,68047,68050,68095,68164,68168,68221,68222,68253,68255,68331,68335,68440,68447,68472,68479,68521,68527,68858,68863,69225,69246,69405,69414,69457,69460,69573,69579,69723,69733,70113,70132,71482,71483,71914,71922,72794,72812,73664,73684,74752,74862,93019,93025,93824,93846,119488,119507,119520,119539,119648,119672,125127,125135,126065,126123,126125,126127,126129,126132,126209,126253,126255,126269,127243,127244,131073,131073,131172,131172,131298,131298,131361,131361,133418,133418,133507,133507,133516,133516,133532,133532,133866,133866,133885,133885,133913,133913,140176,140176,141720,141720,146203,146203,156269,156269,194704,194704 }); }
	static private void addProperty731() { addProperty("sc=zyyy", new int[] { 0,64,91,96,123,169,171,185,187,191,215,215,247,247,697,735,741,745,748,767,884,884,894,894,901,901,903,903,1541,1541,1548,1548,1563,1563,1567,1567,1600,1600,1757,1757,2274,2274,2404,2405,3647,3647,4053,4056,4347,4347,5867,5869,5941,5942,6146,6147,6149,6149,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7418,8192,8203,8206,8292,8294,8304,8308,8318,8320,8334,8352,8384,8448,8485,8487,8489,8492,8497,8499,8525,8527,8543,8585,8587,8592,9254,9280,9290,9312,10239,10496,11123,11126,11157,11159,11263,11776,11869,12272,12283,12288,12292,12294,12294,12296,12320,12336,12343,12348,12351,12443,12444,12448,12448,12539,12540,12688,12703,12736,12771,12832,12895,12927,13007,13055,13055,13144,13311,19904,19967,42752,42785,42888,42890,43056,43065,43310,43310,43471,43471,43867,43867,43882,43883,64830,64831,65040,65049,65072,65106,65108,65126,65128,65131,65279,65279,65281,65312,65339,65344,65371,65381,65392,65392,65438,65439,65504,65510,65512,65518,65529,65533,65792,65794,65799,65843,65847,65855,65936,65948,66000,66044,66273,66299,113824,113827,118608,118723,118784,119029,119040,119078,119081,119142,119146,119162,119171,119172,119180,119209,119214,119274,119488,119507,119520,119539,119552,119638,119648,119672,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,126065,126132,126209,126269,126976,127019,127024,127123,127136,127150,127153,127167,127169,127183,127185,127221,127232,127405,127462,127487,127489,127490,127504,127547,127552,127560,127568,127569,127584,127589,127744,128727,128732,128748,128752,128764,128768,128886,128891,128985,128992,129003,129008,129008,129024,129035,129040,129095,129104,129113,129120,129159,129168,129197,129200,129201,129280,129619,129632,129645,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784,129792,129938,129940,129994,130032,130041,917505,917505,917536,917631 }); }
	static private void addProperty732() { addProperty("sc=zinh", new int[] { 768,879,1157,1158,1611,1621,1648,1648,2385,2388,6832,6862,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8204,8205,8400,8432,12330,12333,12441,12442,65024,65039,65056,65069,66045,66045,66272,66272,70459,70459,118528,118573,118576,118598,119143,119145,119163,119170,119173,119179,119210,119213,917760,917999 }); }
	static private void addProperty733() { addProperty("sc=arab", new int[] { 1536,1540,1542,1547,1549,1562,1564,1566,1568,1599,1601,1610,1622,1647,1649,1756,1758,1791,1872,1919,2160,2190,2192,2193,2200,2273,2275,2303,64336,64450,64467,64829,64832,64911,64914,64967,64975,64975,65008,65023,65136,65140,65142,65276,69216,69246,69373,69375,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,126704,126705 }); }
	static private void addProperty734() { addProperty("sc=armn", new int[] { 1329,1366,1369,1418,1421,1423,64275,64279 }); }
	static private void addProperty735() { addProperty("sc=beng", new int[] { 2432,2435,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2492,2500,2503,2504,2507,2510,2519,2519,2524,2525,2527,2531,2534,2558 }); }
	static private void addProperty736() { addProperty("sc=bopo", new int[] { 746,747,12549,12591,12704,12735 }); }
	static private void addProperty737() { addProperty("sc=cher", new int[] { 5024,5109,5112,5117,43888,43967 }); }
	static private void addProperty738() { addProperty("sc=copt", new int[] { 994,1007,11392,11507,11513,11519 }); }
	static private void addProperty739() { addProperty("sc=cyrl", new int[] { 1024,1156,1159,1327,7296,7304,7467,7467,7544,7544,11744,11775,42560,42655,65070,65071,122928,122989,123023,123023 }); }
	static private void addProperty740() { addProperty("sc=dsrt", new int[] { 66560,66639 }); }
	static private void addProperty741() { addProperty("sc=deva", new int[] { 2304,2384,2389,2403,2406,2431,43232,43263,72448,72457 }); }
	static private void addProperty742() { addProperty("sc=ethi", new int[] { 4608,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4957,4988,4992,5017,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,124896,124902,124904,124907,124909,124910,124912,124926 }); }
	static private void addProperty743() { addProperty("sc=geor", new int[] { 4256,4293,4295,4295,4301,4301,4304,4346,4348,4351,7312,7354,7357,7359,11520,11557,11559,11559,11565,11565 }); }
	static private void addProperty744() { addProperty("sc=goth", new int[] { 66352,66378 }); }
	static private void addProperty745() { addProperty("sc=grek", new int[] { 880,883,885,887,890,893,895,895,900,900,902,902,904,906,908,908,910,929,931,993,1008,1023,7462,7466,7517,7521,7526,7530,7615,7615,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8190,8486,8486,43877,43877,65856,65934,65952,65952,119296,119365 }); }
	static private void addProperty746() { addProperty("sc=gujr", new int[] { 2689,2691,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2748,2757,2759,2761,2763,2765,2768,2768,2784,2787,2790,2801,2809,2815 }); }
	static private void addProperty747() { addProperty("sc=guru", new int[] { 2561,2563,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2649,2652,2654,2654,2662,2678 }); }
	static private void addProperty748() { addProperty("sc=hani", new int[] { 11904,11929,11931,12019,12032,12245,12293,12293,12295,12295,12321,12329,12344,12347,13312,19903,19968,40959,63744,64109,64112,64217,94178,94179,94192,94193,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty749() { addProperty("sc=hang", new int[] { 4352,4607,12334,12335,12593,12686,12800,12830,12896,12926,43360,43388,44032,55203,55216,55238,55243,55291,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500 }); }
	static private void addProperty750() { addProperty("sc=hebr", new int[] { 1425,1479,1488,1514,1519,1524,64285,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64335 }); }
	static private void addProperty751() { addProperty("sc=hira", new int[] { 12353,12438,12445,12447,110593,110879,110898,110898,110928,110930,127488,127488 }); }
	static private void addProperty752() { addProperty("sc=knda", new int[] { 3200,3212,3214,3216,3218,3240,3242,3251,3253,3257,3260,3268,3270,3272,3274,3277,3285,3286,3293,3294,3296,3299,3302,3311,3313,3315 }); }
	static private void addProperty753() { addProperty("sc=kana", new int[] { 12449,12538,12541,12543,12784,12799,13008,13054,13056,13143,65382,65391,65393,65437,110576,110579,110581,110587,110589,110590,110592,110592,110880,110882,110933,110933,110948,110951 }); }
	static private void addProperty754() { addProperty("sc=khmr", new int[] { 6016,6109,6112,6121,6128,6137,6624,6655 }); }
	static private void addProperty755() { addProperty("sc=laoo", new int[] { 3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3773,3776,3780,3782,3782,3784,3790,3792,3801,3804,3807 }); }
	static private void addProperty756() { addProperty("sc=latn", new int[] { 65,90,97,122,170,170,186,186,192,214,216,246,248,696,736,740,7424,7461,7468,7516,7522,7525,7531,7543,7545,7614,7680,7935,8305,8305,8319,8319,8336,8348,8490,8491,8498,8498,8526,8526,8544,8584,11360,11391,42786,42887,42891,42954,42960,42961,42963,42963,42965,42969,42994,43007,43824,43866,43868,43876,43878,43881,64256,64262,65313,65338,65345,65370,67456,67461,67463,67504,67506,67514,122624,122654,122661,122666 }); }
	static private void addProperty757() { addProperty("sc=mlym", new int[] { 3328,3340,3342,3344,3346,3396,3398,3400,3402,3407,3412,3427,3430,3455 }); }
	static private void addProperty758() { addProperty("sc=mong", new int[] { 6144,6145,6148,6148,6150,6169,6176,6264,6272,6314,71264,71276 }); }
	static private void addProperty759() { addProperty("sc=mymr", new int[] { 4096,4255,43488,43518,43616,43647 }); }
	static private void addProperty760() { addProperty("sc=ogam", new int[] { 5760,5788 }); }
	static private void addProperty761() { addProperty("sc=ital", new int[] { 66304,66339,66349,66351 }); }
	static private void addProperty762() { addProperty("sc=orya", new int[] { 2817,2819,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2876,2884,2887,2888,2891,2893,2901,2903,2908,2909,2911,2915,2918,2935 }); }
	static private void addProperty763() { addProperty("sc=runr", new int[] { 5792,5866,5870,5880 }); }
	static private void addProperty764() { addProperty("sc=sinh", new int[] { 3457,3459,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3530,3530,3535,3540,3542,3542,3544,3551,3558,3567,3570,3572,70113,70132 }); }
	static private void addProperty765() { addProperty("sc=syrc", new int[] { 1792,1805,1807,1866,1869,1871,2144,2154 }); }
	static private void addProperty766() { addProperty("sc=taml", new int[] { 2946,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3006,3010,3014,3016,3018,3021,3024,3024,3031,3031,3046,3066,73664,73713,73727,73727 }); }
	static private void addProperty767() { addProperty("sc=telu", new int[] { 3072,3084,3086,3088,3090,3112,3114,3129,3132,3140,3142,3144,3146,3149,3157,3158,3160,3162,3165,3165,3168,3171,3174,3183,3191,3199 }); }
	static private void addProperty768() { addProperty("sc=thaa", new int[] { 1920,1969 }); }
	static private void addProperty769() { addProperty("sc=thai", new int[] { 3585,3642,3648,3675 }); }
	static private void addProperty770() { addProperty("sc=tibt", new int[] { 3840,3911,3913,3948,3953,3991,3993,4028,4030,4044,4046,4052,4057,4058 }); }
	static private void addProperty771() { addProperty("sc=cans", new int[] { 5120,5759,6320,6389,72368,72383 }); }
	static private void addProperty772() { addProperty("sc=yiii", new int[] { 40960,42124,42128,42182 }); }
	static private void addProperty773() { addProperty("sc=tglg", new int[] { 5888,5909,5919,5919 }); }
	static private void addProperty774() { addProperty("sc=hano", new int[] { 5920,5940 }); }
	static private void addProperty775() { addProperty("sc=buhd", new int[] { 5952,5971 }); }
	static private void addProperty776() { addProperty("sc=tagb", new int[] { 5984,5996,5998,6000,6002,6003 }); }
	static private void addProperty777() { addProperty("sc=brai", new int[] { 10240,10495 }); }
	static private void addProperty778() { addProperty("sc=cprt", new int[] { 67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67647 }); }
	static private void addProperty779() { addProperty("sc=limb", new int[] { 6400,6430,6432,6443,6448,6459,6464,6464,6468,6479 }); }
	static private void addProperty780() { addProperty("sc=linb", new int[] { 65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786 }); }
	static private void addProperty781() { addProperty("sc=osma", new int[] { 66688,66717,66720,66729 }); }
	static private void addProperty782() { addProperty("sc=shaw", new int[] { 66640,66687 }); }
	static private void addProperty783() { addProperty("sc=tale", new int[] { 6480,6509,6512,6516 }); }
	static private void addProperty784() { addProperty("sc=ugar", new int[] { 66432,66461,66463,66463 }); }
	static private void addProperty785() { addProperty("sc=hrkt", new int[] {  }); }
	static private void addProperty786() { addProperty("sc=bugi", new int[] { 6656,6683,6686,6687 }); }
	static private void addProperty787() { addProperty("sc=glag", new int[] { 11264,11359,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922 }); }
	static private void addProperty788() { addProperty("sc=khar", new int[] { 68096,68099,68101,68102,68108,68115,68117,68119,68121,68149,68152,68154,68159,68168,68176,68184 }); }
	static private void addProperty789() { addProperty("sc=sylo", new int[] { 43008,43052 }); }
	static private void addProperty790() { addProperty("sc=talu", new int[] { 6528,6571,6576,6601,6608,6618,6622,6623 }); }
	static private void addProperty791() { addProperty("sc=tfng", new int[] { 11568,11623,11631,11632,11647,11647 }); }
	static private void addProperty792() { addProperty("sc=xpeo", new int[] { 66464,66499,66504,66517 }); }
	static private void addProperty793() { addProperty("sc=bali", new int[] { 6912,6988,6992,7038 }); }
	static private void addProperty794() { addProperty("sc=batk", new int[] { 7104,7155,7164,7167 }); }
	static private void addProperty795() { addProperty("sc=blis", new int[] {  }); }
	static private void addProperty796() { addProperty("sc=brah", new int[] { 69632,69709,69714,69749,69759,69759 }); }
	static private void addProperty797() { addProperty("sc=cham", new int[] { 43520,43574,43584,43597,43600,43609,43612,43615 }); }
	static private void addProperty798() { addProperty("sc=cirt", new int[] {  }); }
	static private void addProperty799() { addProperty("sc=cyrs", new int[] {  }); }
	static private void addProperty800() { addProperty("sc=egyd", new int[] {  }); }
	static private void addProperty801() { addProperty("sc=egyh", new int[] {  }); }
	static private void addProperty802() { addProperty("sc=egyp", new int[] { 77824,78933 }); }
	static private void addProperty803() { addProperty("sc=geok", new int[] {  }); }
	static private void addProperty804() { addProperty("sc=hans", new int[] {  }); }
	static private void addProperty805() { addProperty("sc=hant", new int[] {  }); }
	static private void addProperty806() { addProperty("sc=hmng", new int[] { 92928,92997,93008,93017,93019,93025,93027,93047,93053,93071 }); }
	static private void addProperty807() { addProperty("sc=hung", new int[] { 68736,68786,68800,68850,68858,68863 }); }
	static private void addProperty808() { addProperty("sc=inds", new int[] {  }); }
	static private void addProperty809() { addProperty("sc=java", new int[] { 43392,43469,43472,43481,43486,43487 }); }
	static private void addProperty810() { addProperty("sc=kali", new int[] { 43264,43309,43311,43311 }); }
	static private void addProperty811() { addProperty("sc=latf", new int[] {  }); }
	static private void addProperty812() { addProperty("sc=latg", new int[] {  }); }
	static private void addProperty813() { addProperty("sc=lepc", new int[] { 7168,7223,7227,7241,7245,7247 }); }
	static private void addProperty814() { addProperty("sc=lina", new int[] { 67072,67382,67392,67413,67424,67431 }); }
	static private void addProperty815() { addProperty("sc=mand", new int[] { 2112,2139,2142,2142 }); }
	static private void addProperty816() { addProperty("sc=maya", new int[] {  }); }
	static private void addProperty817() { addProperty("sc=mero", new int[] { 67968,67999 }); }
	static private void addProperty818() { addProperty("sc=nkoo", new int[] { 1984,2042,2045,2047 }); }
	static private void addProperty819() { addProperty("sc=orkh", new int[] { 68608,68680 }); }
	static private void addProperty820() { addProperty("sc=perm", new int[] { 66384,66426 }); }
	static private void addProperty821() { addProperty("sc=phag", new int[] { 43072,43127 }); }
	static private void addProperty822() { addProperty("sc=phnx", new int[] { 67840,67867,67871,67871 }); }
	static private void addProperty823() { addProperty("sc=plrd", new int[] { 93952,94026,94031,94087,94095,94111 }); }
	static private void addProperty824() { addProperty("sc=roro", new int[] {  }); }
	static private void addProperty825() { addProperty("sc=sara", new int[] {  }); }
	static private void addProperty826() { addProperty("sc=syre", new int[] {  }); }
	static private void addProperty827() { addProperty("sc=syrj", new int[] {  }); }
	static private void addProperty828() { addProperty("sc=syrn", new int[] {  }); }
	static private void addProperty829() { addProperty("sc=teng", new int[] {  }); }
	static private void addProperty830() { addProperty("sc=vaii", new int[] { 42240,42539 }); }
	static private void addProperty831() { addProperty("sc=visp", new int[] {  }); }
	static private void addProperty832() { addProperty("sc=xsux", new int[] { 73728,74649,74752,74862,74864,74868,74880,75075 }); }
	static private void addProperty833() { addProperty("sc=zxxx", new int[] {  }); }
	static private void addProperty834() { addProperty("sc=zzzz", new int[] { 888,889,896,899,907,907,909,909,930,930,1328,1328,1367,1368,1419,1420,1424,1424,1480,1487,1515,1518,1525,1535,1806,1806,1867,1868,1970,1983,2043,2044,2094,2095,2111,2111,2140,2141,2143,2143,2155,2159,2191,2191,2194,2199,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2679,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2802,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2936,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3067,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3190,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3408,3411,3428,3429,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3573,3584,3643,3646,3676,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3912,3912,3949,3952,3992,3992,4029,4029,4045,4045,4059,4095,4294,4294,4296,4300,4302,4303,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4989,4991,5018,5023,5110,5111,5118,5119,5789,5791,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6110,6111,6122,6127,6138,6143,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6463,6465,6467,6510,6511,6517,6527,6572,6575,6602,6607,6619,6621,6684,6685,6751,6751,6781,6782,6794,6799,6810,6815,6830,6831,6863,6911,6989,6991,7039,7039,7156,7163,7224,7226,7242,7244,7305,7311,7355,7356,7368,7375,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8293,8293,8306,8307,8335,8335,8349,8351,8385,8399,8433,8447,8588,8591,9255,9279,9291,9311,11124,11125,11158,11158,11508,11512,11558,11558,11560,11564,11566,11567,11624,11630,11633,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11870,11903,11930,11930,12020,12031,12246,12271,12284,12287,12352,12352,12439,12440,12544,12548,12592,12592,12687,12687,12772,12783,12831,12831,42125,42127,42183,42191,42540,42559,42744,42751,42955,42959,42962,42962,42964,42964,42970,42993,43053,43055,43066,43071,43128,43135,43206,43213,43226,43231,43348,43358,43389,43391,43470,43470,43482,43485,43519,43519,43575,43583,43598,43599,43610,43611,43715,43738,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43884,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,63743,64110,64111,64218,64255,64263,64274,64280,64284,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64451,64466,64912,64913,64968,64974,64976,65007,65050,65055,65107,65107,65127,65127,65132,65135,65141,65141,65277,65278,65280,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,65528,65534,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65791,65795,65798,65844,65846,65935,65935,65949,65951,65953,65999,66046,66175,66205,66207,66257,66271,66300,66303,66340,66348,66379,66383,66427,66431,66462,66462,66500,66503,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66926,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67670,67743,67750,67760,67807,67827,67827,67830,67834,67868,67870,67898,67902,67904,67967,68024,68027,68048,68049,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,68175,68185,68191,68256,68287,68327,68330,68343,68351,68406,68408,68438,68439,68467,68471,68498,68504,68509,68520,68528,68607,68681,68735,68787,68799,68851,68857,68904,68911,68922,69215,69247,69247,69290,69290,69294,69295,69298,69372,69416,69423,69466,69487,69514,69551,69580,69599,69623,69631,69710,69713,69750,69758,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69960,69967,70007,70015,70112,70112,70133,70143,70162,70162,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70748,70748,70754,70783,70856,70863,70874,71039,71094,71095,71134,71167,71237,71247,71258,71263,71277,71295,71354,71359,71370,71423,71451,71452,71468,71471,71495,71679,71740,71839,71923,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72007,72015,72026,72095,72104,72105,72152,72153,72165,72191,72264,72271,72355,72367,72441,72447,72458,72703,72713,72713,72759,72759,72774,72783,72813,72815,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73562,73647,73649,73663,73714,73726,74650,74751,74863,74863,74869,74879,75076,77711,77811,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92998,93007,93018,93018,93026,93026,93048,93052,93072,93759,93851,93951,94027,94030,94088,94094,94112,94175,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113819,113828,118527,118574,118575,118599,118607,118724,118783,119030,119039,119079,119080,119275,119295,119366,119487,119508,119519,119540,119551,119639,119647,119673,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,121484,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123216,123535,123567,123583,123642,123646,123648,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125126,125143,125183,125260,125263,125274,125277,125280,126064,126133,126208,126270,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,126703,126706,126975,127020,127023,127124,127135,127151,127152,127168,127168,127184,127184,127222,127231,127406,127461,127491,127503,127548,127551,127561,127567,127570,127583,127590,127743,128728,128731,128749,128751,128765,128767,128887,128890,128986,128991,129004,129007,129009,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129199,129202,129279,129620,129631,129646,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,129791,129939,129939,129995,130031,130042,131071,173792,173823,177978,177983,178206,178207,183970,183983,191457,194559,195102,196607,201547,201551,205744,917504,917506,917535,917632,917759,918000,1114111 }); }
	static private void addProperty835() { addProperty("sc=cari", new int[] { 66208,66256 }); }
	static private void addProperty836() { addProperty("sc=jpan", new int[] {  }); }
	static private void addProperty837() { addProperty("sc=lana", new int[] { 6688,6750,6752,6780,6783,6793,6800,6809,6816,6829 }); }
	static private void addProperty838() { addProperty("sc=lyci", new int[] { 66176,66204 }); }
	static private void addProperty839() { addProperty("sc=lydi", new int[] { 67872,67897,67903,67903 }); }
	static private void addProperty840() { addProperty("sc=olck", new int[] { 7248,7295 }); }
	static private void addProperty841() { addProperty("sc=rjng", new int[] { 43312,43347,43359,43359 }); }
	static private void addProperty842() { addProperty("sc=saur", new int[] { 43136,43205,43214,43225 }); }
	static private void addProperty843() { addProperty("sc=sgnw", new int[] { 120832,121483,121499,121503,121505,121519 }); }
	static private void addProperty844() { addProperty("sc=sund", new int[] { 7040,7103,7360,7367 }); }
	static private void addProperty845() { addProperty("sc=moon", new int[] {  }); }
	static private void addProperty846() { addProperty("sc=mtei", new int[] { 43744,43766,43968,44013,44016,44025 }); }
	static private void addProperty847() { addProperty("sc=armi", new int[] { 67648,67669,67671,67679 }); }
	static private void addProperty848() { addProperty("sc=avst", new int[] { 68352,68405,68409,68415 }); }
	static private void addProperty849() { addProperty("sc=cakm", new int[] { 69888,69940,69942,69959 }); }
	static private void addProperty850() { addProperty("sc=kore", new int[] {  }); }
	static private void addProperty851() { addProperty("sc=kthi", new int[] { 69760,69826,69837,69837 }); }
	static private void addProperty852() { addProperty("sc=mani", new int[] { 68288,68326,68331,68342 }); }
	static private void addProperty853() { addProperty("sc=phli", new int[] { 68448,68466,68472,68479 }); }
	static private void addProperty854() { addProperty("sc=phlp", new int[] { 68480,68497,68505,68508,68521,68527 }); }
	static private void addProperty855() { addProperty("sc=phlv", new int[] {  }); }
	static private void addProperty856() { addProperty("sc=prti", new int[] { 68416,68437,68440,68447 }); }
	static private void addProperty857() { addProperty("sc=samr", new int[] { 2048,2093,2096,2110 }); }
	static private void addProperty858() { addProperty("sc=tavt", new int[] { 43648,43714,43739,43743 }); }
	static private void addProperty859() { addProperty("sc=zmth", new int[] {  }); }
	static private void addProperty860() { addProperty("sc=zsym", new int[] {  }); }
	static private void addProperty861() { addProperty("sc=bamu", new int[] { 42656,42743,92160,92728 }); }
	static private void addProperty862() { addProperty("sc=lisu", new int[] { 42192,42239,73648,73648 }); }
	static private void addProperty863() { addProperty("sc=nkgb", new int[] {  }); }
	static private void addProperty864() { addProperty("sc=sarb", new int[] { 68192,68223 }); }
	static private void addProperty865() { addProperty("sc=bass", new int[] { 92880,92909,92912,92917 }); }
	static private void addProperty866() { addProperty("sc=dupl", new int[] { 113664,113770,113776,113788,113792,113800,113808,113817,113820,113823 }); }
	static private void addProperty867() { addProperty("sc=elba", new int[] { 66816,66855 }); }
	static private void addProperty868() { addProperty("sc=gran", new int[] { 70400,70403,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70460,70468,70471,70472,70475,70477,70480,70480,70487,70487,70493,70499,70502,70508,70512,70516 }); }
	static private void addProperty869() { addProperty("sc=kpel", new int[] {  }); }
	static private void addProperty870() { addProperty("sc=loma", new int[] {  }); }
	static private void addProperty871() { addProperty("sc=mend", new int[] { 124928,125124,125127,125142 }); }
	static private void addProperty872() { addProperty("sc=merc", new int[] { 68000,68023,68028,68047,68050,68095 }); }
	static private void addProperty873() { addProperty("sc=narb", new int[] { 68224,68255 }); }
	static private void addProperty874() { addProperty("sc=nbat", new int[] { 67712,67742,67751,67759 }); }
	static private void addProperty875() { addProperty("sc=palm", new int[] { 67680,67711 }); }
	static private void addProperty876() { addProperty("sc=sind", new int[] { 70320,70378,70384,70393 }); }
	static private void addProperty877() { addProperty("sc=wara", new int[] { 71840,71922,71935,71935 }); }
	static private void addProperty878() { addProperty("sc=afak", new int[] {  }); }
	static private void addProperty879() { addProperty("sc=jurc", new int[] {  }); }
	static private void addProperty880() { addProperty("sc=mroo", new int[] { 92736,92766,92768,92777,92782,92783 }); }
	static private void addProperty881() { addProperty("sc=nshu", new int[] { 94177,94177,110960,111355 }); }
	static private void addProperty882() { addProperty("sc=shrd", new int[] { 70016,70111 }); }
	static private void addProperty883() { addProperty("sc=sora", new int[] { 69840,69864,69872,69881 }); }
	static private void addProperty884() { addProperty("sc=takr", new int[] { 71296,71353,71360,71369 }); }
	static private void addProperty885() { addProperty("sc=tang", new int[] { 94176,94176,94208,100343,100352,101119,101632,101640 }); }
	static private void addProperty886() { addProperty("sc=wole", new int[] {  }); }
	static private void addProperty887() { addProperty("sc=hluw", new int[] { 82944,83526 }); }
	static private void addProperty888() { addProperty("sc=khoj", new int[] { 70144,70161,70163,70209 }); }
	static private void addProperty889() { addProperty("sc=tirh", new int[] { 70784,70855,70864,70873 }); }
	static private void addProperty890() { addProperty("sc=aghb", new int[] { 66864,66915,66927,66927 }); }
	static private void addProperty891() { addProperty("sc=mahj", new int[] { 69968,70006 }); }
	static private void addProperty892() { addProperty("sc=ahom", new int[] { 71424,71450,71453,71467,71472,71494 }); }
	static private void addProperty893() { addProperty("sc=hatr", new int[] { 67808,67826,67828,67829,67835,67839 }); }
	static private void addProperty894() { addProperty("sc=modi", new int[] { 71168,71236,71248,71257 }); }
	static private void addProperty895() { addProperty("sc=mult", new int[] { 70272,70278,70280,70280,70282,70285,70287,70301,70303,70313 }); }
	static private void addProperty896() { addProperty("sc=pauc", new int[] { 72384,72440 }); }
	static private void addProperty897() { addProperty("sc=sidd", new int[] { 71040,71093,71096,71133 }); }
	static private void addProperty898() { addProperty("sc=adlm", new int[] { 125184,125259,125264,125273,125278,125279 }); }
	static private void addProperty899() { addProperty("sc=bhks", new int[] { 72704,72712,72714,72758,72760,72773,72784,72812 }); }
	static private void addProperty900() { addProperty("sc=marc", new int[] { 72816,72847,72850,72871,72873,72886 }); }
	static private void addProperty901() { addProperty("sc=newa", new int[] { 70656,70747,70749,70753 }); }
	static private void addProperty902() { addProperty("sc=osge", new int[] { 66736,66771,66776,66811 }); }
	static private void addProperty903() { addProperty("sc=hanb", new int[] {  }); }
	static private void addProperty904() { addProperty("sc=jamo", new int[] {  }); }
	static private void addProperty905() { addProperty("sc=zsye", new int[] {  }); }
	static private void addProperty906() { addProperty("sc=gonm", new int[] { 72960,72966,72968,72969,72971,73014,73018,73018,73020,73021,73023,73031,73040,73049 }); }
	static private void addProperty907() { addProperty("sc=soyo", new int[] { 72272,72354 }); }
	static private void addProperty908() { addProperty("sc=zanb", new int[] { 72192,72263 }); }
	static private void addProperty909() { addProperty("sc=dogr", new int[] { 71680,71739 }); }
	static private void addProperty910() { addProperty("sc=gong", new int[] { 73056,73061,73063,73064,73066,73102,73104,73105,73107,73112,73120,73129 }); }
	static private void addProperty911() { addProperty("sc=maka", new int[] { 73440,73464 }); }
	static private void addProperty912() { addProperty("sc=medf", new int[] { 93760,93850 }); }
	static private void addProperty913() { addProperty("sc=rohg", new int[] { 68864,68903,68912,68921 }); }
	static private void addProperty914() { addProperty("sc=sogd", new int[] { 69424,69465 }); }
	static private void addProperty915() { addProperty("sc=sogo", new int[] { 69376,69415 }); }
	static private void addProperty916() { addProperty("sc=elym", new int[] { 69600,69622 }); }
	static private void addProperty917() { addProperty("sc=hmnp", new int[] { 123136,123180,123184,123197,123200,123209,123214,123215 }); }
	static private void addProperty918() { addProperty("sc=nand", new int[] { 72096,72103,72106,72151,72154,72164 }); }
	static private void addProperty919() { addProperty("sc=wcho", new int[] { 123584,123641,123647,123647 }); }
	static private void addProperty920() { addProperty("sc=chrs", new int[] { 69552,69579 }); }
	static private void addProperty921() { addProperty("sc=diak", new int[] { 71936,71942,71945,71945,71948,71955,71957,71958,71960,71989,71991,71992,71995,72006,72016,72025 }); }
	static private void addProperty922() { addProperty("sc=kits", new int[] { 94180,94180,101120,101589 }); }
	static private void addProperty923() { addProperty("sc=yezi", new int[] { 69248,69289,69291,69293,69296,69297 }); }
	static private void addProperty924() { addProperty("sc=cpmn", new int[] { 77712,77810 }); }
	static private void addProperty925() { addProperty("sc=ougr", new int[] { 69488,69513 }); }
	static private void addProperty926() { addProperty("sc=tnsa", new int[] { 92784,92862,92864,92873 }); }
	static private void addProperty927() { addProperty("sc=toto", new int[] { 123536,123566 }); }
	static private void addProperty928() { addProperty("sc=vith", new int[] { 66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004 }); }
	static private void addProperty929() { addProperty("sc=kawi", new int[] { 73472,73488,73490,73530,73534,73561 }); }
	static private void addProperty930() { addProperty("sc=nagm", new int[] { 124112,124153 }); }
	static private void addProperty931() { addProperty("hst=na", new int[] { 0,4351,4608,43359,43389,44031,55204,55215,55239,55242,55292,1114111 }); }
	static private void addProperty932() { addProperty("hst=l", new int[] { 4352,4447,43360,43388 }); }
	static private void addProperty933() { addProperty("hst=v", new int[] { 4448,4519,55216,55238 }); }
	static private void addProperty934() { addProperty("hst=t", new int[] { 4520,4607,55243,55291 }); }
	static private void addProperty935() { addProperty("hst=lv", new int[] { 44032,44032,44060,44060,44088,44088,44116,44116,44144,44144,44172,44172,44200,44200,44228,44228,44256,44256,44284,44284,44312,44312,44340,44340,44368,44368,44396,44396,44424,44424,44452,44452,44480,44480,44508,44508,44536,44536,44564,44564,44592,44592,44620,44620,44648,44648,44676,44676,44704,44704,44732,44732,44760,44760,44788,44788,44816,44816,44844,44844,44872,44872,44900,44900,44928,44928,44956,44956,44984,44984,45012,45012,45040,45040,45068,45068,45096,45096,45124,45124,45152,45152,45180,45180,45208,45208,45236,45236,45264,45264,45292,45292,45320,45320,45348,45348,45376,45376,45404,45404,45432,45432,45460,45460,45488,45488,45516,45516,45544,45544,45572,45572,45600,45600,45628,45628,45656,45656,45684,45684,45712,45712,45740,45740,45768,45768,45796,45796,45824,45824,45852,45852,45880,45880,45908,45908,45936,45936,45964,45964,45992,45992,46020,46020,46048,46048,46076,46076,46104,46104,46132,46132,46160,46160,46188,46188,46216,46216,46244,46244,46272,46272,46300,46300,46328,46328,46356,46356,46384,46384,46412,46412,46440,46440,46468,46468,46496,46496,46524,46524,46552,46552,46580,46580,46608,46608,46636,46636,46664,46664,46692,46692,46720,46720,46748,46748,46776,46776,46804,46804,46832,46832,46860,46860,46888,46888,46916,46916,46944,46944,46972,46972,47000,47000,47028,47028,47056,47056,47084,47084,47112,47112,47140,47140,47168,47168,47196,47196,47224,47224,47252,47252,47280,47280,47308,47308,47336,47336,47364,47364,47392,47392,47420,47420,47448,47448,47476,47476,47504,47504,47532,47532,47560,47560,47588,47588,47616,47616,47644,47644,47672,47672,47700,47700,47728,47728,47756,47756,47784,47784,47812,47812,47840,47840,47868,47868,47896,47896,47924,47924,47952,47952,47980,47980,48008,48008,48036,48036,48064,48064,48092,48092,48120,48120,48148,48148,48176,48176,48204,48204,48232,48232,48260,48260,48288,48288,48316,48316,48344,48344,48372,48372,48400,48400,48428,48428,48456,48456,48484,48484,48512,48512,48540,48540,48568,48568,48596,48596,48624,48624,48652,48652,48680,48680,48708,48708,48736,48736,48764,48764,48792,48792,48820,48820,48848,48848,48876,48876,48904,48904,48932,48932,48960,48960,48988,48988,49016,49016,49044,49044,49072,49072,49100,49100,49128,49128,49156,49156,49184,49184,49212,49212,49240,49240,49268,49268,49296,49296,49324,49324,49352,49352,49380,49380,49408,49408,49436,49436,49464,49464,49492,49492,49520,49520,49548,49548,49576,49576,49604,49604,49632,49632,49660,49660,49688,49688,49716,49716,49744,49744,49772,49772,49800,49800,49828,49828,49856,49856,49884,49884,49912,49912,49940,49940,49968,49968,49996,49996,50024,50024,50052,50052,50080,50080,50108,50108,50136,50136,50164,50164,50192,50192,50220,50220,50248,50248,50276,50276,50304,50304,50332,50332,50360,50360,50388,50388,50416,50416,50444,50444,50472,50472,50500,50500,50528,50528,50556,50556,50584,50584,50612,50612,50640,50640,50668,50668,50696,50696,50724,50724,50752,50752,50780,50780,50808,50808,50836,50836,50864,50864,50892,50892,50920,50920,50948,50948,50976,50976,51004,51004,51032,51032,51060,51060,51088,51088,51116,51116,51144,51144,51172,51172,51200,51200,51228,51228,51256,51256,51284,51284,51312,51312,51340,51340,51368,51368,51396,51396,51424,51424,51452,51452,51480,51480,51508,51508,51536,51536,51564,51564,51592,51592,51620,51620,51648,51648,51676,51676,51704,51704,51732,51732,51760,51760,51788,51788,51816,51816,51844,51844,51872,51872,51900,51900,51928,51928,51956,51956,51984,51984,52012,52012,52040,52040,52068,52068,52096,52096,52124,52124,52152,52152,52180,52180,52208,52208,52236,52236,52264,52264,52292,52292,52320,52320,52348,52348,52376,52376,52404,52404,52432,52432,52460,52460,52488,52488,52516,52516,52544,52544,52572,52572,52600,52600,52628,52628,52656,52656,52684,52684,52712,52712,52740,52740,52768,52768,52796,52796,52824,52824,52852,52852,52880,52880,52908,52908,52936,52936,52964,52964,52992,52992,53020,53020,53048,53048,53076,53076,53104,53104,53132,53132,53160,53160,53188,53188,53216,53216,53244,53244,53272,53272,53300,53300,53328,53328,53356,53356,53384,53384,53412,53412,53440,53440,53468,53468,53496,53496,53524,53524,53552,53552,53580,53580,53608,53608,53636,53636,53664,53664,53692,53692,53720,53720,53748,53748,53776,53776,53804,53804,53832,53832,53860,53860,53888,53888,53916,53916,53944,53944,53972,53972,54000,54000,54028,54028,54056,54056,54084,54084,54112,54112,54140,54140,54168,54168,54196,54196,54224,54224,54252,54252,54280,54280,54308,54308,54336,54336,54364,54364,54392,54392,54420,54420,54448,54448,54476,54476,54504,54504,54532,54532,54560,54560,54588,54588,54616,54616,54644,54644,54672,54672,54700,54700,54728,54728,54756,54756,54784,54784,54812,54812,54840,54840,54868,54868,54896,54896,54924,54924,54952,54952,54980,54980,55008,55008,55036,55036,55064,55064,55092,55092,55120,55120,55148,55148,55176,55176 }); }
	static private void addProperty936() { addProperty("hst=lvt", new int[] { 44033,44059,44061,44087,44089,44115,44117,44143,44145,44171,44173,44199,44201,44227,44229,44255,44257,44283,44285,44311,44313,44339,44341,44367,44369,44395,44397,44423,44425,44451,44453,44479,44481,44507,44509,44535,44537,44563,44565,44591,44593,44619,44621,44647,44649,44675,44677,44703,44705,44731,44733,44759,44761,44787,44789,44815,44817,44843,44845,44871,44873,44899,44901,44927,44929,44955,44957,44983,44985,45011,45013,45039,45041,45067,45069,45095,45097,45123,45125,45151,45153,45179,45181,45207,45209,45235,45237,45263,45265,45291,45293,45319,45321,45347,45349,45375,45377,45403,45405,45431,45433,45459,45461,45487,45489,45515,45517,45543,45545,45571,45573,45599,45601,45627,45629,45655,45657,45683,45685,45711,45713,45739,45741,45767,45769,45795,45797,45823,45825,45851,45853,45879,45881,45907,45909,45935,45937,45963,45965,45991,45993,46019,46021,46047,46049,46075,46077,46103,46105,46131,46133,46159,46161,46187,46189,46215,46217,46243,46245,46271,46273,46299,46301,46327,46329,46355,46357,46383,46385,46411,46413,46439,46441,46467,46469,46495,46497,46523,46525,46551,46553,46579,46581,46607,46609,46635,46637,46663,46665,46691,46693,46719,46721,46747,46749,46775,46777,46803,46805,46831,46833,46859,46861,46887,46889,46915,46917,46943,46945,46971,46973,46999,47001,47027,47029,47055,47057,47083,47085,47111,47113,47139,47141,47167,47169,47195,47197,47223,47225,47251,47253,47279,47281,47307,47309,47335,47337,47363,47365,47391,47393,47419,47421,47447,47449,47475,47477,47503,47505,47531,47533,47559,47561,47587,47589,47615,47617,47643,47645,47671,47673,47699,47701,47727,47729,47755,47757,47783,47785,47811,47813,47839,47841,47867,47869,47895,47897,47923,47925,47951,47953,47979,47981,48007,48009,48035,48037,48063,48065,48091,48093,48119,48121,48147,48149,48175,48177,48203,48205,48231,48233,48259,48261,48287,48289,48315,48317,48343,48345,48371,48373,48399,48401,48427,48429,48455,48457,48483,48485,48511,48513,48539,48541,48567,48569,48595,48597,48623,48625,48651,48653,48679,48681,48707,48709,48735,48737,48763,48765,48791,48793,48819,48821,48847,48849,48875,48877,48903,48905,48931,48933,48959,48961,48987,48989,49015,49017,49043,49045,49071,49073,49099,49101,49127,49129,49155,49157,49183,49185,49211,49213,49239,49241,49267,49269,49295,49297,49323,49325,49351,49353,49379,49381,49407,49409,49435,49437,49463,49465,49491,49493,49519,49521,49547,49549,49575,49577,49603,49605,49631,49633,49659,49661,49687,49689,49715,49717,49743,49745,49771,49773,49799,49801,49827,49829,49855,49857,49883,49885,49911,49913,49939,49941,49967,49969,49995,49997,50023,50025,50051,50053,50079,50081,50107,50109,50135,50137,50163,50165,50191,50193,50219,50221,50247,50249,50275,50277,50303,50305,50331,50333,50359,50361,50387,50389,50415,50417,50443,50445,50471,50473,50499,50501,50527,50529,50555,50557,50583,50585,50611,50613,50639,50641,50667,50669,50695,50697,50723,50725,50751,50753,50779,50781,50807,50809,50835,50837,50863,50865,50891,50893,50919,50921,50947,50949,50975,50977,51003,51005,51031,51033,51059,51061,51087,51089,51115,51117,51143,51145,51171,51173,51199,51201,51227,51229,51255,51257,51283,51285,51311,51313,51339,51341,51367,51369,51395,51397,51423,51425,51451,51453,51479,51481,51507,51509,51535,51537,51563,51565,51591,51593,51619,51621,51647,51649,51675,51677,51703,51705,51731,51733,51759,51761,51787,51789,51815,51817,51843,51845,51871,51873,51899,51901,51927,51929,51955,51957,51983,51985,52011,52013,52039,52041,52067,52069,52095,52097,52123,52125,52151,52153,52179,52181,52207,52209,52235,52237,52263,52265,52291,52293,52319,52321,52347,52349,52375,52377,52403,52405,52431,52433,52459,52461,52487,52489,52515,52517,52543,52545,52571,52573,52599,52601,52627,52629,52655,52657,52683,52685,52711,52713,52739,52741,52767,52769,52795,52797,52823,52825,52851,52853,52879,52881,52907,52909,52935,52937,52963,52965,52991,52993,53019,53021,53047,53049,53075,53077,53103,53105,53131,53133,53159,53161,53187,53189,53215,53217,53243,53245,53271,53273,53299,53301,53327,53329,53355,53357,53383,53385,53411,53413,53439,53441,53467,53469,53495,53497,53523,53525,53551,53553,53579,53581,53607,53609,53635,53637,53663,53665,53691,53693,53719,53721,53747,53749,53775,53777,53803,53805,53831,53833,53859,53861,53887,53889,53915,53917,53943,53945,53971,53973,53999,54001,54027,54029,54055,54057,54083,54085,54111,54113,54139,54141,54167,54169,54195,54197,54223,54225,54251,54253,54279,54281,54307,54309,54335,54337,54363,54365,54391,54393,54419,54421,54447,54449,54475,54477,54503,54505,54531,54533,54559,54561,54587,54589,54615,54617,54643,54645,54671,54673,54699,54701,54727,54729,54755,54757,54783,54785,54811,54813,54839,54841,54867,54869,54895,54897,54923,54925,54951,54953,54979,54981,55007,55009,55035,55037,55063,55065,55091,55093,55119,55121,55147,55149,55175,55177,55203 }); }
	static private void addProperty937() { addProperty("nfd_qc=n", new int[] { 192,197,199,207,209,214,217,221,224,229,231,239,241,246,249,253,255,271,274,293,296,304,308,311,313,318,323,328,332,337,340,357,360,382,416,417,431,432,461,476,478,483,486,496,500,501,504,539,542,543,550,563,832,833,835,836,884,884,894,894,901,906,908,908,910,912,938,944,970,974,979,980,1024,1025,1027,1027,1031,1031,1036,1038,1049,1049,1081,1081,1104,1105,1107,1107,1111,1111,1116,1118,1142,1143,1217,1218,1232,1235,1238,1239,1242,1247,1250,1255,1258,1269,1272,1273,1570,1574,1728,1728,1730,1730,1747,1747,2345,2345,2353,2353,2356,2356,2392,2399,2507,2508,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2888,2888,2891,2892,2908,2909,2964,2964,3018,3020,3144,3144,3264,3264,3271,3272,3274,3275,3402,3404,3546,3546,3548,3550,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3958,3960,3960,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,4134,4134,6918,6918,6920,6920,6922,6922,6924,6924,6926,6926,6930,6930,6971,6971,6973,6973,6976,6977,6979,6979,7680,7833,7835,7835,7840,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8129,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8189,8192,8193,8486,8486,8490,8491,8602,8603,8622,8622,8653,8655,8708,8708,8713,8713,8716,8716,8740,8740,8742,8742,8769,8769,8772,8772,8775,8775,8777,8777,8800,8800,8802,8802,8813,8817,8820,8821,8824,8825,8832,8833,8836,8837,8840,8841,8876,8879,8928,8931,8938,8941,9001,9002,10972,10972,12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12386,12389,12389,12391,12391,12393,12393,12400,12401,12403,12404,12406,12407,12409,12410,12412,12413,12436,12436,12446,12446,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12482,12485,12485,12487,12487,12489,12489,12496,12497,12499,12500,12502,12503,12505,12506,12508,12509,12532,12532,12535,12538,12542,12542,44032,55203,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64285,64285,64287,64287,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64334,69786,69786,69788,69788,69803,69803,69934,69935,70475,70476,70843,70844,70846,70846,71098,71099,71992,71992,119134,119140,119227,119232,194560,195101 }); }
	static private void addProperty938() { addProperty("nfd_qc=y", new int[] { 0,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,307,312,312,319,322,329,331,338,339,358,359,383,415,418,430,433,460,477,477,484,485,497,499,502,503,540,541,544,549,564,831,834,834,837,883,885,893,895,900,907,907,909,909,913,937,945,969,975,978,981,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1569,1575,1727,1729,1729,1731,1746,1748,2344,2346,2352,2354,2355,2357,2391,2400,2506,2509,2523,2526,2526,2528,2610,2612,2613,2615,2648,2652,2653,2655,2887,2889,2890,2893,2907,2910,2963,2965,3017,3021,3143,3145,3263,3265,3270,3273,3273,3276,3401,3405,3545,3547,3547,3551,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3954,3956,3956,3959,3959,3961,3968,3970,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4133,4135,6917,6919,6919,6921,6921,6923,6923,6925,6925,6927,6929,6931,6970,6972,6972,6974,6975,6978,6978,6980,7679,7834,7834,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8125,8125,8127,8128,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8190,8191,8194,8485,8487,8489,8492,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,9000,9003,10971,10973,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12445,12447,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12543,44031,55204,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64284,64286,64286,64288,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64335,69785,69787,69787,69789,69802,69804,69933,69936,70474,70477,70842,70845,70845,70847,71097,71100,71991,71993,119133,119141,119226,119233,194559,195102,1114111 }); }
	static private void addProperty939() { addProperty("nfkd_qc=n", new int[] { 160,160,168,168,170,170,175,175,178,181,184,186,188,190,192,197,199,207,209,214,217,221,224,229,231,239,241,246,249,253,255,271,274,293,296,304,306,311,313,320,323,329,332,337,340,357,360,383,416,417,431,432,452,476,478,483,486,501,504,539,542,543,550,563,688,696,728,733,736,740,832,833,835,836,884,884,890,890,894,894,900,906,908,908,910,912,938,944,970,974,976,982,1008,1010,1012,1013,1017,1017,1024,1025,1027,1027,1031,1031,1036,1038,1049,1049,1081,1081,1104,1105,1107,1107,1111,1111,1116,1118,1142,1143,1217,1218,1232,1235,1238,1239,1242,1247,1250,1255,1258,1269,1272,1273,1415,1415,1570,1574,1653,1656,1728,1728,1730,1730,1747,1747,2345,2345,2353,2353,2356,2356,2392,2399,2507,2508,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2888,2888,2891,2892,2908,2909,2964,2964,3018,3020,3144,3144,3264,3264,3271,3272,3274,3275,3402,3404,3546,3546,3548,3550,3635,3635,3763,3763,3804,3805,3852,3852,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3961,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,4134,4134,4348,4348,6918,6918,6920,6920,6922,6922,6924,6924,6926,6926,6930,6930,6971,6971,6973,6973,6976,6977,6979,6979,7468,7470,7472,7482,7484,7501,7503,7530,7544,7544,7579,7615,7680,7835,7840,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8132,8134,8147,8150,8155,8157,8175,8178,8180,8182,8190,8192,8202,8209,8209,8215,8215,8228,8230,8239,8239,8243,8244,8246,8247,8252,8252,8254,8254,8263,8265,8279,8279,8287,8287,8304,8305,8308,8334,8336,8348,8360,8360,8448,8451,8453,8455,8457,8467,8469,8470,8473,8477,8480,8482,8484,8484,8486,8486,8488,8488,8490,8493,8495,8497,8499,8505,8507,8512,8517,8521,8528,8575,8585,8585,8602,8603,8622,8622,8653,8655,8708,8708,8713,8713,8716,8716,8740,8740,8742,8742,8748,8749,8751,8752,8769,8769,8772,8772,8775,8775,8777,8777,8800,8800,8802,8802,8813,8817,8820,8821,8824,8825,8832,8833,8836,8837,8840,8841,8876,8879,8928,8931,8938,8941,9001,9002,9312,9450,10764,10764,10868,10870,10972,10972,11388,11389,11631,11631,11935,11935,12019,12019,12032,12245,12288,12288,12342,12342,12344,12346,12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12386,12389,12389,12391,12391,12393,12393,12400,12401,12403,12404,12406,12407,12409,12410,12412,12413,12436,12436,12443,12444,12446,12447,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12482,12485,12485,12487,12487,12489,12489,12496,12497,12499,12500,12502,12503,12505,12506,12508,12509,12532,12532,12535,12538,12542,12543,12593,12686,12690,12703,12800,12830,12832,12871,12880,12926,12928,13311,42652,42653,42864,42864,42994,42996,43000,43001,43868,43871,43881,43881,44032,55203,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65020,65040,65049,65072,65092,65095,65106,65108,65126,65128,65131,65136,65138,65140,65140,65142,65276,65281,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,67457,67461,67463,67504,67506,67514,69786,69786,69788,69788,69803,69803,69934,69935,70475,70476,70843,70844,70846,70846,71098,71099,71992,71992,119134,119140,119227,119232,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,122928,122989,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127232,127242,127248,127278,127280,127311,127338,127340,127376,127376,127488,127490,127504,127547,127552,127560,127568,127569,130032,130041,194560,195101 }); }
	static private void addProperty940() { addProperty("nfkd_qc=y", new int[] { 0,159,161,167,169,169,171,174,176,177,182,183,187,187,191,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,305,312,312,321,322,330,331,338,339,358,359,384,415,418,430,433,451,477,477,484,485,502,503,540,541,544,549,564,687,697,727,734,735,741,831,834,834,837,883,885,889,891,893,895,899,907,907,909,909,913,937,945,969,975,975,983,1007,1011,1011,1014,1016,1018,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1414,1416,1569,1575,1652,1657,1727,1729,1729,1731,1746,1748,2344,2346,2352,2354,2355,2357,2391,2400,2506,2509,2523,2526,2526,2528,2610,2612,2613,2615,2648,2652,2653,2655,2887,2889,2890,2893,2907,2910,2963,2965,3017,3021,3143,3145,3263,3265,3270,3273,3273,3276,3401,3405,3545,3547,3547,3551,3634,3636,3762,3764,3803,3806,3851,3853,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3954,3956,3956,3962,3968,3970,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4133,4135,4347,4349,6917,6919,6919,6921,6921,6923,6923,6925,6925,6927,6929,6931,6970,6972,6972,6974,6975,6978,6978,6980,7467,7471,7471,7483,7483,7502,7502,7531,7543,7545,7578,7616,7679,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8133,8133,8148,8149,8156,8156,8176,8177,8181,8181,8191,8191,8203,8208,8210,8214,8216,8227,8231,8238,8240,8242,8245,8245,8248,8251,8253,8253,8255,8262,8266,8278,8280,8286,8288,8303,8306,8307,8335,8335,8349,8359,8361,8447,8452,8452,8456,8456,8468,8468,8471,8472,8478,8479,8483,8483,8485,8485,8487,8487,8489,8489,8494,8494,8498,8498,8506,8506,8513,8516,8522,8527,8576,8584,8586,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8747,8750,8750,8753,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,9000,9003,9311,9451,10763,10765,10867,10871,10971,10973,11387,11390,11630,11632,11934,11936,12018,12020,12031,12246,12287,12289,12341,12343,12343,12347,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12442,12445,12445,12448,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12544,12592,12687,12689,12704,12799,12831,12831,12872,12879,12927,12927,13312,42651,42654,42863,42865,42993,42997,42999,43002,43867,43872,43880,43882,44031,55204,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64255,64263,64274,64280,64284,64286,64286,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65021,65039,65050,65071,65093,65094,65107,65107,65127,65127,65132,65135,65139,65139,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,67456,67462,67462,67505,67505,67515,69785,69787,69787,69789,69802,69804,69933,69936,70474,70477,70842,70845,70845,70847,71097,71100,71991,71993,119133,119141,119226,119233,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,120832,122927,122990,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127231,127243,127247,127279,127279,127312,127337,127341,127375,127377,127487,127491,127503,127548,127551,127561,127567,127570,130031,130042,194559,195102,1114111 }); }
	static private void addProperty941() { addProperty("nfc_qc=n", new int[] { 832,833,835,836,884,884,894,894,903,903,2392,2399,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2908,2909,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3958,3960,3960,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,8049,8049,8051,8051,8053,8053,8055,8055,8057,8057,8059,8059,8061,8061,8123,8123,8126,8126,8137,8137,8139,8139,8147,8147,8155,8155,8163,8163,8171,8171,8174,8175,8185,8185,8187,8187,8189,8189,8192,8193,8486,8486,8490,8491,9001,9002,10972,10972,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64285,64285,64287,64287,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64334,119134,119140,119227,119232,194560,195101 }); }
	static private void addProperty942() { addProperty("nfc_qc=y", new int[] { 0,767,773,773,781,782,784,784,786,786,789,794,796,802,809,812,815,815,818,823,825,831,838,883,885,893,895,902,904,1618,1622,2363,2365,2391,2400,2493,2495,2518,2520,2523,2526,2526,2528,2610,2612,2613,2615,2648,2652,2653,2655,2877,2879,2901,2904,2907,2910,3005,3007,3030,3032,3157,3159,3265,3267,3284,3287,3389,3391,3414,3416,3529,3531,3534,3536,3550,3552,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3954,3956,3956,3959,3959,3961,3968,3970,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4141,4143,4448,4470,4519,4547,6964,6966,8048,8050,8050,8052,8052,8054,8054,8056,8056,8058,8058,8060,8060,8062,8122,8124,8125,8127,8136,8138,8138,8140,8146,8148,8154,8156,8162,8164,8170,8172,8173,8176,8184,8186,8186,8188,8188,8190,8191,8194,8485,8487,8489,8492,9000,9003,10971,10973,12440,12443,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64284,64286,64286,64288,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64335,69817,69819,69926,69928,70461,70463,70486,70488,70831,70833,70841,70843,70844,70846,71086,71088,71983,71985,119133,119141,119226,119233,194559,195102,1114111 }); }
	static private void addProperty943() { addProperty("nfc_qc=m", new int[] { 768,772,774,780,783,783,785,785,787,788,795,795,803,808,813,814,816,817,824,824,834,834,837,837,1619,1621,2364,2364,2494,2494,2519,2519,2878,2878,2902,2903,3006,3006,3031,3031,3158,3158,3266,3266,3285,3286,3390,3390,3415,3415,3530,3530,3535,3535,3551,3551,4142,4142,4449,4469,4520,4546,6965,6965,12441,12442,69818,69818,69927,69927,70462,70462,70487,70487,70832,70832,70842,70842,70845,70845,71087,71087,71984,71984 }); }
	static private void addProperty944() { addProperty("nfkc_qc=n", new int[] { 160,160,168,168,170,170,175,175,178,181,184,186,188,190,306,307,319,320,329,329,383,383,452,460,497,499,688,696,728,733,736,740,832,833,835,836,884,884,890,890,894,894,900,901,903,903,976,982,1008,1010,1012,1013,1017,1017,1415,1415,1653,1656,2392,2399,2524,2525,2527,2527,2611,2611,2614,2614,2649,2651,2654,2654,2908,2909,3635,3635,3763,3763,3804,3805,3852,3852,3907,3907,3917,3917,3922,3922,3927,3927,3932,3932,3945,3945,3955,3955,3957,3961,3969,3969,3987,3987,3997,3997,4002,4002,4007,4007,4012,4012,4025,4025,4348,4348,7468,7470,7472,7482,7484,7501,7503,7530,7544,7544,7579,7615,7834,7835,8049,8049,8051,8051,8053,8053,8055,8055,8057,8057,8059,8059,8061,8061,8123,8123,8125,8129,8137,8137,8139,8139,8141,8143,8147,8147,8155,8155,8157,8159,8163,8163,8171,8171,8173,8175,8185,8185,8187,8187,8189,8190,8192,8202,8209,8209,8215,8215,8228,8230,8239,8239,8243,8244,8246,8247,8252,8252,8254,8254,8263,8265,8279,8279,8287,8287,8304,8305,8308,8334,8336,8348,8360,8360,8448,8451,8453,8455,8457,8467,8469,8470,8473,8477,8480,8482,8484,8484,8486,8486,8488,8488,8490,8493,8495,8497,8499,8505,8507,8512,8517,8521,8528,8575,8585,8585,8748,8749,8751,8752,9001,9002,9312,9450,10764,10764,10868,10870,10972,10972,11388,11389,11631,11631,11935,11935,12019,12019,12032,12245,12288,12288,12342,12342,12344,12346,12443,12444,12447,12447,12543,12543,12593,12686,12690,12703,12800,12830,12832,12871,12880,12926,12928,13311,42652,42653,42864,42864,42994,42996,43000,43001,43868,43871,43881,43881,63744,64013,64016,64016,64018,64018,64021,64030,64032,64032,64034,64034,64037,64038,64042,64109,64112,64217,64256,64262,64275,64279,64285,64285,64287,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65020,65040,65049,65072,65092,65095,65106,65108,65126,65128,65131,65136,65138,65140,65140,65142,65276,65281,65470,65474,65479,65482,65487,65490,65495,65498,65500,65504,65510,65512,65518,67457,67461,67463,67504,67506,67514,119134,119140,119227,119232,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120779,120782,120831,122928,122989,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127232,127242,127248,127278,127280,127311,127338,127340,127376,127376,127488,127490,127504,127547,127552,127560,127568,127569,130032,130041,194560,195101 }); }
	static private void addProperty945() { addProperty("nfkc_qc=y", new int[] { 0,159,161,167,169,169,171,174,176,177,182,183,187,187,191,305,308,318,321,328,330,382,384,451,461,496,500,687,697,727,734,735,741,767,773,773,781,782,784,784,786,786,789,794,796,802,809,812,815,815,818,823,825,831,838,883,885,889,891,893,895,899,902,902,904,975,983,1007,1011,1011,1014,1016,1018,1414,1416,1618,1622,1652,1657,2363,2365,2391,2400,2493,2495,2518,2520,2523,2526,2526,2528,2610,2612,2613,2615,2648,2652,2653,2655,2877,2879,2901,2904,2907,2910,3005,3007,3030,3032,3157,3159,3265,3267,3284,3287,3389,3391,3414,3416,3529,3531,3534,3536,3550,3552,3634,3636,3762,3764,3803,3806,3851,3853,3906,3908,3916,3918,3921,3923,3926,3928,3931,3933,3944,3946,3954,3956,3956,3962,3968,3970,3986,3988,3996,3998,4001,4003,4006,4008,4011,4013,4024,4026,4141,4143,4347,4349,4448,4470,4519,4547,6964,6966,7467,7471,7471,7483,7483,7502,7502,7531,7543,7545,7578,7616,7833,7836,8048,8050,8050,8052,8052,8054,8054,8056,8056,8058,8058,8060,8060,8062,8122,8124,8124,8130,8136,8138,8138,8140,8140,8144,8146,8148,8154,8156,8156,8160,8162,8164,8170,8172,8172,8176,8184,8186,8186,8188,8188,8191,8191,8203,8208,8210,8214,8216,8227,8231,8238,8240,8242,8245,8245,8248,8251,8253,8253,8255,8262,8266,8278,8280,8286,8288,8303,8306,8307,8335,8335,8349,8359,8361,8447,8452,8452,8456,8456,8468,8468,8471,8472,8478,8479,8483,8483,8485,8485,8487,8487,8489,8489,8494,8494,8498,8498,8506,8506,8513,8516,8522,8527,8576,8584,8586,8747,8750,8750,8753,9000,9003,9311,9451,10763,10765,10867,10871,10971,10973,11387,11390,11630,11632,11934,11936,12018,12020,12031,12246,12287,12289,12341,12343,12343,12347,12440,12445,12446,12448,12542,12544,12592,12687,12689,12704,12799,12831,12831,12872,12879,12927,12927,13312,42651,42654,42863,42865,42993,42997,42999,43002,43867,43872,43880,43882,63743,64014,64015,64017,64017,64019,64020,64031,64031,64033,64033,64035,64036,64039,64041,64110,64111,64218,64255,64263,64274,64280,64284,64286,64286,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65021,65039,65050,65071,65093,65094,65107,65107,65127,65127,65132,65135,65139,65139,65141,65141,65277,65280,65471,65473,65480,65481,65488,65489,65496,65497,65501,65503,65511,65511,65519,67456,67462,67462,67505,67505,67515,69817,69819,69926,69928,70461,70463,70486,70488,70831,70833,70841,70843,70844,70846,71086,71088,71983,71985,119133,119141,119226,119233,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120780,120781,120832,122927,122990,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127231,127243,127247,127279,127279,127312,127337,127341,127375,127377,127487,127491,127503,127548,127551,127561,127567,127570,130031,130042,194559,195102,1114111 }); }
	static private void addProperty946() { addProperty("nfkc_qc=m", new int[] { 768,772,774,780,783,783,785,785,787,788,795,795,803,808,813,814,816,817,824,824,834,834,837,837,1619,1621,2364,2364,2494,2494,2519,2519,2878,2878,2902,2903,3006,3006,3031,3031,3158,3158,3266,3266,3285,3286,3390,3390,3415,3415,3530,3530,3535,3535,3551,3551,4142,4142,4449,4469,4520,4546,6965,6965,12441,12442,69818,69818,69927,69927,70462,70462,70487,70487,70832,70832,70842,70842,70845,70845,71087,71087,71984,71984 }); }
	static private void addProperty947() { addProperty("lccc=nr", new int[] { 0,767,847,847,880,1154,1160,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1610,1632,1647,1649,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2363,2365,2380,2382,2384,2389,2491,2493,2508,2510,2557,2559,2619,2621,2636,2638,2747,2749,2764,2766,2875,2877,2892,2894,3020,3022,3131,3133,3148,3150,3156,3159,3259,3261,3276,3278,3386,3389,3404,3406,3529,3531,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3952,3958,3961,3966,3967,3973,3973,3976,4037,4039,4150,4152,4152,4155,4236,4238,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6963,6965,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7680,8399,8413,8416,8418,8420,8433,11502,11506,11646,11648,11743,11776,12329,12336,12440,12443,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,64285,64287,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69816,69819,69887,69891,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70476,70478,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70849,70852,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119140,119146,119148,119155,119162,119171,119172,119180,119209,119214,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,1114111 }); }
	static private void addProperty948() { addProperty("lccc=ov", new int[] { 820,824,7380,7380,7394,7400,8402,8403,8408,8410,8421,8422,8426,8427,68153,68153,92912,92916,113822,113822,119143,119145 }); }
	static private void addProperty949() { addProperty("lccc=null", new int[] {  }); }
	static private void addProperty950() { addProperty("lccc=hanr", new int[] { 94192,94193 }); }
	static private void addProperty951() { addProperty("lccc=nk", new int[] { 2364,2364,2492,2492,2620,2620,2748,2748,2876,2876,3132,3132,3260,3260,4151,4151,6964,6964,7142,7142,7223,7223,43443,43443,69818,69818,70003,70003,70090,70090,70198,70198,70377,70377,70459,70460,70726,70726,70851,70851,71104,71104,71351,71351,71738,71738,72003,72003,73026,73026,125258,125258 }); }
	static private void addProperty952() { addProperty("lccc=kv", new int[] { 12441,12442 }); }
	static private void addProperty953() { addProperty("lccc=vr", new int[] { 2381,2381,2509,2509,2637,2637,2765,2765,2893,2893,3021,3021,3149,3149,3277,3277,3387,3388,3405,3405,3530,3530,3642,3642,3770,3770,3972,3972,4153,4154,5908,5909,5940,5940,6098,6098,6752,6752,6980,6980,7082,7083,7154,7155,11647,11647,43014,43014,43052,43052,43204,43204,43347,43347,43456,43456,43766,43766,44013,44013,68159,68159,69702,69702,69744,69744,69759,69759,69817,69817,69939,69940,70080,70080,70197,70197,70378,70378,70477,70477,70722,70722,70850,70850,71103,71103,71231,71231,71350,71350,71467,71467,71737,71737,71997,71998,72160,72160,72244,72244,72263,72263,72345,72345,72767,72767,73028,73029,73111,73111,73537,73538 }); }
	static private void addProperty954() { addProperty("lccc=ccc10", new int[] { 1456,1456 }); }
	static private void addProperty955() { addProperty("lccc=ccc11", new int[] { 1457,1457 }); }
	static private void addProperty956() { addProperty("lccc=ccc12", new int[] { 1458,1458 }); }
	static private void addProperty957() { addProperty("lccc=ccc13", new int[] { 1459,1459 }); }
	static private void addProperty958() { addProperty("lccc=ccc14", new int[] { 1460,1460 }); }
	static private void addProperty959() { addProperty("lccc=ccc15", new int[] { 1461,1461 }); }
	static private void addProperty960() { addProperty("lccc=ccc16", new int[] { 1462,1462 }); }
	static private void addProperty961() { addProperty("lccc=ccc17", new int[] { 1463,1463 }); }
	static private void addProperty962() { addProperty("lccc=ccc18", new int[] { 1464,1464,1479,1479 }); }
	static private void addProperty963() { addProperty("lccc=ccc19", new int[] { 1465,1466 }); }
	static private void addProperty964() { addProperty("lccc=ccc20", new int[] { 1467,1467 }); }
	static private void addProperty965() { addProperty("lccc=ccc21", new int[] { 1468,1468 }); }
	static private void addProperty966() { addProperty("lccc=ccc22", new int[] { 1469,1469 }); }
	static private void addProperty967() { addProperty("lccc=ccc23", new int[] { 1471,1471 }); }
	static private void addProperty968() { addProperty("lccc=ccc24", new int[] { 1473,1473 }); }
	static private void addProperty969() { addProperty("lccc=ccc25", new int[] { 1474,1474 }); }
	static private void addProperty970() { addProperty("lccc=ccc26", new int[] { 64286,64286 }); }
	static private void addProperty971() { addProperty("lccc=ccc27", new int[] { 1611,1611,2288,2288 }); }
	static private void addProperty972() { addProperty("lccc=ccc28", new int[] { 1612,1612,2289,2289 }); }
	static private void addProperty973() { addProperty("lccc=ccc29", new int[] { 1613,1613,2290,2290 }); }
	static private void addProperty974() { addProperty("lccc=ccc30", new int[] { 1560,1560,1614,1614 }); }
	static private void addProperty975() { addProperty("lccc=ccc31", new int[] { 1561,1561,1615,1615 }); }
	static private void addProperty976() { addProperty("lccc=ccc32", new int[] { 1562,1562,1616,1616 }); }
	static private void addProperty977() { addProperty("lccc=ccc33", new int[] { 1617,1617 }); }
	static private void addProperty978() { addProperty("lccc=ccc34", new int[] { 1618,1618 }); }
	static private void addProperty979() { addProperty("lccc=ccc35", new int[] { 1648,1648 }); }
	static private void addProperty980() { addProperty("lccc=ccc36", new int[] { 1809,1809 }); }
	static private void addProperty981() { addProperty("lccc=ccc84", new int[] { 3157,3157 }); }
	static private void addProperty982() { addProperty("lccc=ccc91", new int[] { 3158,3158 }); }
	static private void addProperty983() { addProperty("lccc=ccc103", new int[] { 3640,3641 }); }
	static private void addProperty984() { addProperty("lccc=ccc107", new int[] { 3656,3659 }); }
	static private void addProperty985() { addProperty("lccc=ccc118", new int[] { 3768,3769 }); }
	static private void addProperty986() { addProperty("lccc=ccc122", new int[] { 3784,3787 }); }
	static private void addProperty987() { addProperty("lccc=ccc129", new int[] { 3953,3953,3955,3955,3957,3957,3969,3969 }); }
	static private void addProperty988() { addProperty("lccc=ccc130", new int[] { 3954,3954,3962,3965,3968,3968 }); }
	static private void addProperty989() { addProperty("lccc=ccc132", new int[] { 3956,3956 }); }
	static private void addProperty990() { addProperty("lccc=ccc133", new int[] {  }); }
	static private void addProperty991() { addProperty("lccc=atbl", new int[] {  }); }
	static private void addProperty992() { addProperty("lccc=atb", new int[] { 801,802,807,808,7632,7632 }); }
	static private void addProperty993() { addProperty("lccc=ata", new int[] { 7630,7630 }); }
	static private void addProperty994() { addProperty("lccc=atar", new int[] { 795,795,3897,3897,119141,119142,119150,119154 }); }
	static private void addProperty995() { addProperty("lccc=bl", new int[] { 7674,7674,12330,12330 }); }
	static private void addProperty996() { addProperty("lccc=b", new int[] { 790,793,796,800,803,806,809,819,825,828,839,841,845,846,851,854,857,858,1425,1425,1430,1430,1435,1435,1442,1447,1450,1450,1477,1477,1621,1622,1628,1628,1631,1631,1763,1763,1770,1770,1773,1773,1841,1841,1844,1844,1847,1849,1851,1852,1854,1854,1858,1858,1860,1860,1862,1862,1864,1864,2034,2034,2045,2045,2137,2139,2201,2203,2255,2259,2275,2275,2278,2278,2281,2281,2285,2287,2294,2294,2297,2298,2386,2386,3864,3865,3893,3893,3895,3895,4038,4038,4237,4237,6459,6459,6680,6680,6783,6783,6837,6842,6845,6845,6847,6848,6851,6852,6858,6858,7020,7020,7381,7385,7388,7391,7405,7405,7618,7618,7626,7626,7631,7631,7673,7673,7677,7677,7679,7679,8424,8424,8428,8431,43307,43309,43700,43700,65063,65069,66045,66045,66272,66272,68109,68109,68154,68154,68326,68326,69373,69375,69446,69447,69451,69451,69453,69456,69507,69507,69509,69509,119163,119170,119178,119179,124142,124142,125136,125142 }); }
	static private void addProperty997() { addProperty("lccc=br", new int[] { 1434,1434,1453,1453,6457,6457,12333,12333 }); }
	static private void addProperty998() { addProperty("lccc=l", new int[] { 12334,12335 }); }
	static private void addProperty999() { addProperty("lccc=r", new int[] { 119149,119149 }); }
	static private void addProperty1000() { addProperty("lccc=al", new int[] { 1454,1454,6313,6313,7671,7672,12331,12331 }); }
	static private void addProperty1001() { addProperty("lccc=a", new int[] { 768,788,829,836,838,838,842,844,848,850,855,855,859,859,867,879,1155,1159,1426,1429,1431,1433,1436,1441,1448,1449,1451,1452,1455,1455,1476,1476,1552,1559,1619,1620,1623,1627,1629,1630,1750,1756,1759,1762,1764,1764,1767,1768,1771,1772,1840,1840,1842,1843,1845,1846,1850,1850,1853,1853,1855,1857,1859,1859,1861,1861,1863,1863,1865,1866,2027,2033,2035,2035,2070,2073,2075,2083,2085,2087,2089,2093,2200,2200,2204,2207,2250,2254,2260,2273,2276,2277,2279,2280,2282,2284,2291,2293,2295,2296,2299,2303,2385,2385,2387,2388,2558,2558,3970,3971,3974,3975,4957,4959,6109,6109,6458,6458,6679,6679,6773,6780,6832,6836,6843,6844,6849,6850,6853,6857,6859,6862,7019,7019,7021,7027,7376,7378,7386,7387,7392,7392,7412,7412,7416,7417,7616,7617,7619,7625,7627,7628,7633,7669,7675,7675,7678,7678,8400,8401,8404,8407,8411,8412,8417,8417,8423,8423,8425,8425,8432,8432,11503,11505,11744,11775,42607,42607,42612,42621,42654,42655,42736,42737,43232,43249,43696,43696,43698,43699,43703,43704,43710,43711,43713,43713,65056,65062,65070,65071,66422,66426,68111,68111,68152,68152,68325,68325,68900,68903,69291,69292,69448,69450,69452,69452,69506,69506,69508,69508,69888,69890,70502,70508,70512,70516,70750,70750,92976,92982,119173,119177,119210,119213,119362,119364,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124143,124143,125252,125257 }); }
	static private void addProperty1002() { addProperty("lccc=ar", new int[] { 789,789,794,794,856,856,7670,7670,12332,12332,124140,124141 }); }
	static private void addProperty1003() { addProperty("lccc=db", new int[] { 860,860,863,863,866,866,7676,7676 }); }
	static private void addProperty1004() { addProperty("lccc=da", new int[] { 861,862,864,865,7629,7629 }); }
	static private void addProperty1005() { addProperty("lccc=is", new int[] { 837,837 }); }
	static private void addProperty1006() { addProperty("tccc=nr", new int[] { 0,191,198,198,208,208,215,216,222,223,230,230,240,240,247,248,254,254,272,273,294,295,305,307,312,312,319,322,329,331,338,339,358,359,383,415,418,430,433,460,477,477,484,485,497,499,502,503,540,541,544,549,564,767,847,847,880,900,903,903,907,907,909,909,913,937,945,969,975,978,981,1023,1026,1026,1028,1030,1032,1035,1039,1048,1050,1080,1082,1103,1106,1106,1108,1110,1112,1115,1119,1141,1144,1154,1160,1216,1219,1231,1236,1237,1240,1241,1248,1249,1256,1257,1270,1271,1274,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1551,1563,1569,1575,1610,1632,1647,1649,1727,1729,1729,1731,1746,1748,1749,1757,1758,1765,1766,1769,1769,1774,1808,1810,1839,1867,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2199,2208,2249,2274,2274,2304,2344,2346,2352,2354,2355,2357,2363,2365,2380,2382,2384,2389,2391,2400,2491,2493,2508,2510,2523,2526,2526,2528,2557,2559,2610,2612,2613,2615,2619,2621,2636,2638,2648,2652,2653,2655,2747,2749,2764,2766,2875,2877,2892,2894,2907,2910,3020,3022,3131,3133,3143,3145,3148,3150,3156,3159,3259,3261,3276,3278,3386,3389,3404,3406,3529,3531,3545,3547,3548,3550,3639,3643,3655,3660,3767,3771,3783,3788,3863,3866,3892,3894,3894,3896,3896,3898,3952,3959,3959,3961,3961,3966,3967,3973,3973,3976,4037,4039,4150,4152,4152,4155,4236,4238,4956,4960,5907,5910,5939,5941,6097,6099,6108,6110,6312,6314,6456,6460,6678,6681,6751,6753,6772,6781,6782,6784,6831,6846,6846,6863,6963,6965,6979,6981,7018,7028,7081,7084,7141,7143,7153,7156,7222,7224,7375,7379,7379,7393,7393,7401,7404,7406,7411,7413,7415,7418,7615,7834,7834,7836,7839,7930,7935,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8125,8128,8133,8133,8148,8149,8156,8156,8175,8177,8181,8181,8189,8399,8413,8416,8418,8420,8433,8490,8492,8601,8604,8621,8623,8652,8656,8707,8709,8712,8714,8715,8717,8739,8741,8741,8743,8768,8770,8771,8773,8774,8776,8776,8778,8799,8801,8801,8803,8812,8818,8819,8822,8823,8826,8831,8834,8835,8838,8839,8842,8875,8880,8927,8932,8937,8942,10971,10973,11502,11506,11646,11648,11743,11776,12329,12336,12363,12365,12365,12367,12367,12369,12369,12371,12371,12373,12373,12375,12375,12377,12377,12379,12379,12381,12381,12383,12383,12385,12385,12387,12388,12390,12390,12392,12392,12394,12399,12402,12402,12405,12405,12408,12408,12411,12411,12414,12435,12437,12440,12443,12445,12447,12459,12461,12461,12463,12463,12465,12465,12467,12467,12469,12469,12471,12471,12473,12473,12475,12475,12477,12477,12479,12479,12481,12481,12483,12484,12486,12486,12488,12488,12490,12495,12498,12498,12501,12501,12504,12504,12507,12507,12510,12531,12533,12534,12539,12541,12543,42606,42608,42611,42622,42653,42656,42735,42738,43013,43015,43051,43053,43203,43205,43231,43250,43306,43310,43346,43348,43442,43444,43455,43457,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43765,43767,44012,44014,64284,64288,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64335,65055,65072,66044,66046,66271,66273,66421,66427,68108,68110,68110,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69701,69703,69743,69745,69758,69760,69785,69787,69787,69789,69802,69804,69816,69819,69887,69891,69938,69941,70002,70004,70079,70081,70089,70091,70196,70199,70376,70379,70458,70461,70476,70478,70501,70509,70511,70517,70721,70723,70725,70727,70749,70751,70849,70852,71102,71105,71230,71232,71349,71352,71466,71468,71736,71739,71996,71999,72002,72004,72159,72161,72243,72245,72262,72264,72344,72346,72766,72768,73025,73027,73027,73030,73110,73112,73536,73539,92911,92917,92975,92983,94191,94194,113821,113823,119133,119146,119148,119155,119162,119171,119172,119180,119209,119214,119226,119233,119361,119365,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,1114111 }); }
	static private void addProperty1007() { addProperty("tccc=ov", new int[] { 820,824,7380,7380,7394,7400,8402,8403,8408,8410,8421,8422,8426,8427,8602,8603,8622,8622,8653,8655,8708,8708,8713,8713,8716,8716,8740,8740,8742,8742,8769,8769,8772,8772,8775,8775,8777,8777,8800,8800,8802,8802,8813,8817,8820,8821,8824,8825,8832,8833,8836,8837,8840,8841,8876,8879,8928,8931,8938,8941,10972,10972,68153,68153,92912,92916,113822,113822,119143,119145 }); }
	static private void addProperty1008() { addProperty("tccc=null", new int[] {  }); }
	static private void addProperty1009() { addProperty("tccc=hanr", new int[] { 94192,94193 }); }
	static private void addProperty1010() { addProperty("tccc=nk", new int[] { 2345,2345,2353,2353,2356,2356,2364,2364,2392,2399,2492,2492,2524,2525,2527,2527,2611,2611,2614,2614,2620,2620,2649,2651,2654,2654,2748,2748,2876,2876,2908,2909,3132,3132,3260,3260,4151,4151,6964,6964,7142,7142,7223,7223,43443,43443,69786,69786,69788,69788,69803,69803,69818,69818,70003,70003,70090,70090,70198,70198,70377,70377,70459,70460,70726,70726,70851,70851,71104,71104,71351,71351,71738,71738,72003,72003,73026,73026,125258,125258 }); }
	static private void addProperty1011() { addProperty("tccc=kv", new int[] { 12364,12364,12366,12366,12368,12368,12370,12370,12372,12372,12374,12374,12376,12376,12378,12378,12380,12380,12382,12382,12384,12384,12386,12386,12389,12389,12391,12391,12393,12393,12400,12401,12403,12404,12406,12407,12409,12410,12412,12413,12436,12436,12441,12442,12446,12446,12460,12460,12462,12462,12464,12464,12466,12466,12468,12468,12470,12470,12472,12472,12474,12474,12476,12476,12478,12478,12480,12480,12482,12482,12485,12485,12487,12487,12489,12489,12496,12497,12499,12500,12502,12503,12505,12506,12508,12509,12532,12532,12535,12538,12542,12542 }); }
	static private void addProperty1012() { addProperty("tccc=vr", new int[] { 2381,2381,2509,2509,2637,2637,2765,2765,2893,2893,3021,3021,3149,3149,3277,3277,3387,3388,3405,3405,3530,3530,3546,3546,3549,3549,3642,3642,3770,3770,3972,3972,4153,4154,5908,5909,5940,5940,6098,6098,6752,6752,6980,6980,7082,7083,7154,7155,11647,11647,43014,43014,43052,43052,43204,43204,43347,43347,43456,43456,43766,43766,44013,44013,68159,68159,69702,69702,69744,69744,69759,69759,69817,69817,69939,69940,70080,70080,70197,70197,70378,70378,70477,70477,70722,70722,70850,70850,71103,71103,71231,71231,71350,71350,71467,71467,71737,71737,71997,71998,72160,72160,72244,72244,72263,72263,72345,72345,72767,72767,73028,73029,73111,73111,73537,73538 }); }
	static private void addProperty1013() { addProperty("tccc=ccc10", new int[] { 1456,1456 }); }
	static private void addProperty1014() { addProperty("tccc=ccc11", new int[] { 1457,1457 }); }
	static private void addProperty1015() { addProperty("tccc=ccc12", new int[] { 1458,1458 }); }
	static private void addProperty1016() { addProperty("tccc=ccc13", new int[] { 1459,1459 }); }
	static private void addProperty1017() { addProperty("tccc=ccc14", new int[] { 1460,1460,64285,64285 }); }
	static private void addProperty1018() { addProperty("tccc=ccc15", new int[] { 1461,1461 }); }
	static private void addProperty1019() { addProperty("tccc=ccc16", new int[] { 1462,1462 }); }
	static private void addProperty1020() { addProperty("tccc=ccc17", new int[] { 1463,1463,64287,64287,64302,64302 }); }
	static private void addProperty1021() { addProperty("tccc=ccc18", new int[] { 1464,1464,1479,1479,64303,64303 }); }
	static private void addProperty1022() { addProperty("tccc=ccc19", new int[] { 1465,1466,64331,64331 }); }
	static private void addProperty1023() { addProperty("tccc=ccc20", new int[] { 1467,1467 }); }
	static private void addProperty1024() { addProperty("tccc=ccc21", new int[] { 1468,1468,64304,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64330 }); }
	static private void addProperty1025() { addProperty("tccc=ccc22", new int[] { 1469,1469 }); }
	static private void addProperty1026() { addProperty("tccc=ccc23", new int[] { 1471,1471,64332,64334 }); }
	static private void addProperty1027() { addProperty("tccc=ccc24", new int[] { 1473,1473,64298,64298,64300,64300 }); }
	static private void addProperty1028() { addProperty("tccc=ccc25", new int[] { 1474,1474,64299,64299,64301,64301 }); }
	static private void addProperty1029() { addProperty("tccc=ccc26", new int[] { 64286,64286 }); }
	static private void addProperty1030() { addProperty("tccc=ccc27", new int[] { 1611,1611,2288,2288 }); }
	static private void addProperty1031() { addProperty("tccc=ccc28", new int[] { 1612,1612,2289,2289 }); }
	static private void addProperty1032() { addProperty("tccc=ccc29", new int[] { 1613,1613,2290,2290 }); }
	static private void addProperty1033() { addProperty("tccc=ccc30", new int[] { 1560,1560,1614,1614 }); }
	static private void addProperty1034() { addProperty("tccc=ccc31", new int[] { 1561,1561,1615,1615 }); }
	static private void addProperty1035() { addProperty("tccc=ccc32", new int[] { 1562,1562,1616,1616 }); }
	static private void addProperty1036() { addProperty("tccc=ccc33", new int[] { 1617,1617 }); }
	static private void addProperty1037() { addProperty("tccc=ccc34", new int[] { 1618,1618 }); }
	static private void addProperty1038() { addProperty("tccc=ccc35", new int[] { 1648,1648 }); }
	static private void addProperty1039() { addProperty("tccc=ccc36", new int[] { 1809,1809 }); }
	static private void addProperty1040() { addProperty("tccc=ccc84", new int[] { 3157,3157 }); }
	static private void addProperty1041() { addProperty("tccc=ccc91", new int[] { 3144,3144,3158,3158 }); }
	static private void addProperty1042() { addProperty("tccc=ccc103", new int[] { 3640,3641 }); }
	static private void addProperty1043() { addProperty("tccc=ccc107", new int[] { 3656,3659 }); }
	static private void addProperty1044() { addProperty("tccc=ccc118", new int[] { 3768,3769 }); }
	static private void addProperty1045() { addProperty("tccc=ccc122", new int[] { 3784,3787 }); }
	static private void addProperty1046() { addProperty("tccc=ccc129", new int[] { 3953,3953 }); }
	static private void addProperty1047() { addProperty("tccc=ccc130", new int[] { 3954,3955,3958,3958,3960,3960,3962,3965,3968,3969 }); }
	static private void addProperty1048() { addProperty("tccc=ccc132", new int[] { 3956,3957 }); }
	static private void addProperty1049() { addProperty("tccc=ccc133", new int[] {  }); }
	static private void addProperty1050() { addProperty("tccc=atbl", new int[] {  }); }
	static private void addProperty1051() { addProperty("tccc=atb", new int[] { 199,199,231,231,260,261,280,281,290,291,302,303,310,311,315,316,325,326,342,343,350,351,354,355,370,371,490,491,552,553,801,802,807,808,7632,7632,7696,7697,7720,7721 }); }
	static private void addProperty1052() { addProperty("tccc=ata", new int[] { 7630,7630 }); }
	static private void addProperty1053() { addProperty("tccc=atar", new int[] { 416,417,431,432,795,795,3897,3897,119134,119142,119150,119154,119227,119232 }); }
	static private void addProperty1054() { addProperty("tccc=bl", new int[] { 7674,7674,12330,12330 }); }
	static private void addProperty1055() { addProperty("tccc=b", new int[] { 536,539,790,793,796,800,803,806,809,819,825,828,839,841,845,846,851,854,857,858,1425,1425,1430,1430,1435,1435,1442,1447,1450,1450,1477,1477,1573,1573,1621,1622,1628,1628,1631,1631,1763,1763,1770,1770,1773,1773,1841,1841,1844,1844,1847,1849,1851,1852,1854,1854,1858,1858,1860,1860,1862,1862,1864,1864,2034,2034,2045,2045,2137,2139,2201,2203,2255,2259,2275,2275,2278,2278,2281,2281,2285,2287,2294,2294,2297,2298,2386,2386,3864,3865,3893,3893,3895,3895,4038,4038,4237,4237,6459,6459,6680,6680,6783,6783,6837,6842,6845,6845,6847,6848,6851,6852,6858,6858,7020,7020,7381,7385,7388,7391,7405,7405,7618,7618,7626,7626,7631,7631,7673,7673,7677,7677,7679,7681,7684,7687,7692,7695,7698,7699,7704,7707,7716,7717,7722,7725,7730,7735,7738,7741,7746,7747,7750,7755,7770,7771,7774,7775,7778,7779,7788,7799,7806,7807,7816,7817,7826,7830,7840,7841,7864,7865,7882,7885,7906,7909,7920,7921,7924,7925,8424,8424,8428,8431,43307,43309,43700,43700,65063,65069,66045,66045,66272,66272,68109,68109,68154,68154,68326,68326,69373,69375,69446,69447,69451,69451,69453,69456,69507,69507,69509,69509,119163,119170,119178,119179,124142,124142,125136,125142 }); }
	static private void addProperty1056() { addProperty("tccc=br", new int[] { 1434,1434,1453,1453,6457,6457,12333,12333 }); }
	static private void addProperty1057() { addProperty("tccc=l", new int[] { 12334,12335 }); }
	static private void addProperty1058() { addProperty("tccc=r", new int[] { 119149,119149 }); }
	static private void addProperty1059() { addProperty("tccc=al", new int[] { 1454,1454,6313,6313,7671,7672,12331,12331 }); }
	static private void addProperty1060() { addProperty("tccc=a", new int[] { 192,197,200,207,209,214,217,221,224,229,232,239,241,246,249,253,255,259,262,271,274,279,282,289,292,293,296,301,304,304,308,309,313,314,317,318,323,324,327,328,332,337,340,341,344,349,352,353,356,357,360,369,372,382,461,476,478,483,486,489,492,496,500,501,504,535,542,543,550,551,554,563,768,788,829,836,838,838,842,844,848,850,855,855,859,859,867,879,901,902,904,906,908,908,910,912,938,944,970,974,979,980,1024,1025,1027,1027,1031,1031,1036,1038,1049,1049,1081,1081,1104,1105,1107,1107,1111,1111,1116,1118,1142,1143,1155,1159,1217,1218,1232,1235,1238,1239,1242,1247,1250,1255,1258,1269,1272,1273,1426,1429,1431,1433,1436,1441,1448,1449,1451,1452,1455,1455,1476,1476,1552,1559,1570,1572,1574,1574,1619,1620,1623,1627,1629,1630,1728,1728,1730,1730,1747,1747,1750,1756,1759,1762,1764,1764,1767,1768,1771,1772,1840,1840,1842,1843,1845,1846,1850,1850,1853,1853,1855,1857,1859,1859,1861,1861,1863,1863,1865,1866,2027,2033,2035,2035,2070,2073,2075,2083,2085,2087,2089,2093,2200,2200,2204,2207,2250,2254,2260,2273,2276,2277,2279,2280,2282,2284,2291,2293,2295,2296,2299,2303,2385,2385,2387,2388,2558,2558,3970,3971,3974,3975,4957,4959,6109,6109,6458,6458,6679,6679,6773,6780,6832,6836,6843,6844,6849,6850,6853,6857,6859,6862,7019,7019,7021,7027,7376,7378,7386,7387,7392,7392,7412,7412,7416,7417,7616,7617,7619,7625,7627,7628,7633,7669,7675,7675,7678,7678,7682,7683,7688,7691,7700,7703,7708,7715,7718,7719,7726,7729,7736,7737,7742,7745,7748,7749,7756,7769,7772,7773,7776,7777,7780,7787,7800,7805,7808,7815,7818,7825,7831,7833,7835,7835,7842,7863,7866,7881,7886,7905,7910,7919,7922,7923,7926,7929,7936,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8112,8113,8118,8118,8120,8123,8129,8129,8134,8134,8136,8139,8141,8147,8150,8155,8157,8174,8182,8182,8184,8187,8400,8401,8404,8407,8411,8412,8417,8417,8423,8423,8425,8425,8432,8432,8491,8491,11503,11505,11744,11775,42607,42607,42612,42621,42654,42655,42736,42737,43232,43249,43696,43696,43698,43699,43703,43704,43710,43711,43713,43713,65056,65062,65070,65071,66422,66426,68111,68111,68152,68152,68325,68325,68900,68903,69291,69292,69448,69450,69452,69452,69506,69506,69508,69508,69888,69890,70502,70508,70512,70516,70750,70750,92976,92982,119173,119177,119210,119213,119362,119364,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124143,124143,125252,125257 }); }
	static private void addProperty1061() { addProperty("tccc=ar", new int[] { 789,789,794,794,856,856,7670,7670,12332,12332,124140,124141 }); }
	static private void addProperty1062() { addProperty("tccc=db", new int[] { 860,860,863,863,866,866,7676,7676 }); }
	static private void addProperty1063() { addProperty("tccc=da", new int[] { 861,862,864,865,7629,7629 }); }
	static private void addProperty1064() { addProperty("tccc=is", new int[] { 837,837,8064,8111,8114,8116,8119,8119,8124,8124,8130,8132,8135,8135,8140,8140,8178,8180,8183,8183,8188,8188 }); }
	static private void addProperty1065() { addProperty("gcb=xx", new int[] { 32,126,160,172,174,767,880,1154,1162,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1535,1542,1551,1563,1563,1565,1610,1632,1647,1649,1749,1758,1758,1765,1766,1769,1769,1774,1806,1808,1808,1810,1839,1867,1957,1969,2026,2036,2044,2046,2069,2074,2074,2084,2084,2088,2088,2094,2136,2140,2191,2194,2199,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2404,2432,2436,2491,2493,2493,2501,2502,2505,2506,2510,2518,2520,2529,2532,2557,2559,2560,2564,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2671,2674,2676,2678,2688,2692,2747,2749,2749,2758,2758,2762,2762,2766,2785,2788,2809,2816,2816,2820,2875,2877,2877,2885,2886,2889,2890,2894,2900,2904,2913,2916,2945,2947,3005,3011,3013,3017,3017,3022,3030,3032,3071,3077,3131,3133,3133,3141,3141,3145,3145,3150,3156,3159,3169,3172,3200,3204,3259,3261,3261,3269,3269,3273,3273,3278,3284,3287,3297,3300,3314,3316,3327,3332,3386,3389,3389,3397,3397,3401,3401,3407,3414,3416,3425,3428,3456,3460,3529,3531,3534,3541,3541,3543,3543,3552,3569,3572,3632,3634,3634,3643,3654,3663,3760,3762,3762,3773,3783,3791,3863,3866,3892,3894,3894,3896,3896,3898,3901,3904,3952,3973,3973,3976,3980,3992,3992,4029,4037,4039,4140,4152,4152,4159,4181,4186,4189,4193,4208,4213,4225,4227,4227,4231,4236,4238,4252,4254,4351,4608,4956,4960,5905,5910,5937,5941,5969,5972,6001,6004,6067,6100,6108,6110,6154,6160,6276,6279,6312,6314,6431,6444,6447,6460,6678,6684,6740,6751,6751,6753,6753,6755,6756,6781,6782,6784,6831,6863,6911,6917,6963,6981,7018,7028,7039,7043,7072,7086,7141,7156,7203,7224,7375,7379,7379,7401,7404,7406,7411,7413,7414,7418,7615,7680,8202,8208,8231,8239,8287,8304,8399,8433,11502,11506,11646,11648,11743,11776,12329,12336,12440,12443,42606,42611,42611,42622,42653,42656,42735,42738,43009,43011,43013,43015,43018,43020,43042,43048,43051,43053,43135,43138,43187,43206,43231,43250,43262,43264,43301,43310,43334,43348,43359,43389,43391,43396,43442,43457,43492,43494,43560,43575,43586,43588,43595,43598,43643,43645,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43754,43760,43764,43767,44002,44011,44011,44014,44031,55204,55215,55239,55242,55292,64285,64287,65023,65040,65055,65072,65278,65280,65437,65440,65519,65532,66044,66046,66271,66273,66421,66427,68096,68100,68100,68103,68107,68112,68151,68155,68158,68160,68324,68327,68899,68904,69290,69293,69372,69376,69445,69457,69505,69510,69631,69635,69687,69703,69743,69745,69746,69749,69758,69763,69807,69819,69820,69822,69825,69827,69836,69838,69887,69891,69926,69941,69956,69959,70002,70004,70015,70019,70066,70081,70081,70084,70088,70093,70093,70096,70187,70200,70205,70207,70208,70210,70366,70379,70399,70404,70458,70461,70461,70469,70470,70473,70474,70478,70486,70488,70497,70500,70501,70509,70511,70517,70708,70727,70749,70751,70831,70852,71086,71094,71095,71105,71131,71134,71215,71233,71338,71352,71452,71456,71457,71468,71723,71739,71983,71990,71990,71993,71994,72004,72144,72152,72153,72161,72163,72165,72192,72203,72242,72255,72262,72264,72272,72284,72323,72346,72750,72759,72759,72768,72849,72872,72872,72887,73008,73015,73017,73019,73019,73022,73022,73032,73097,73103,73103,73106,73106,73112,73458,73463,73471,73476,73523,73531,73533,73539,78895,78913,78918,78934,92911,92917,92975,92983,94030,94032,94032,94088,94094,94099,94179,94181,94191,94194,113820,113823,113823,113828,118527,118574,118575,118599,119140,119146,119148,119171,119172,119180,119209,119214,119361,119365,121343,121399,121402,121453,121460,121462,121475,121477,121498,121504,121504,121520,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,123022,123024,123183,123191,123565,123567,123627,123632,124139,124144,125135,125143,125251,125259,127461,127488,127994,128000,917503,921600,1114111 }); }
	static private void addProperty1066() { addProperty("gcb=cn", new int[] { 0,9,11,12,14,31,127,159,173,173,1564,1564,6158,6158,8203,8203,8206,8207,8232,8238,8288,8303,65279,65279,65520,65531,78896,78911,113824,113827,119155,119162,917504,917535,917632,917759,918000,921599 }); }
	static private void addProperty1067() { addProperty("gcb=cr", new int[] { 13,13 }); }
	static private void addProperty1068() { addProperty("gcb=ex", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2306,2362,2362,2364,2364,2369,2376,2381,2381,2385,2391,2402,2403,2433,2433,2492,2492,2494,2494,2497,2500,2509,2509,2519,2519,2530,2531,2558,2558,2561,2562,2620,2620,2625,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2690,2748,2748,2753,2757,2759,2760,2765,2765,2786,2787,2810,2815,2817,2817,2876,2876,2878,2879,2881,2884,2893,2893,2901,2903,2914,2915,2946,2946,3006,3006,3008,3008,3021,3021,3031,3031,3072,3072,3076,3076,3132,3132,3134,3136,3142,3144,3146,3149,3157,3158,3170,3171,3201,3201,3260,3260,3263,3263,3266,3266,3270,3270,3276,3277,3285,3286,3298,3299,3328,3329,3387,3388,3390,3390,3393,3396,3405,3405,3415,3415,3426,3427,3457,3457,3530,3530,3535,3535,3538,3540,3542,3542,3551,3551,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3953,3966,3968,3972,3974,3975,3981,3991,3993,4028,4038,4038,4141,4144,4146,4151,4153,4154,4157,4158,4184,4185,4190,4192,4209,4212,4226,4226,4229,4230,4237,4237,4253,4253,4957,4959,5906,5908,5938,5939,5970,5971,6002,6003,6068,6069,6071,6077,6086,6086,6089,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6434,6439,6440,6450,6450,6457,6459,6679,6680,6683,6683,6742,6742,6744,6750,6752,6752,6754,6754,6757,6764,6771,6780,6783,6783,6832,6862,6912,6915,6964,6970,6972,6972,6978,6978,7019,7027,7040,7041,7074,7077,7080,7081,7083,7085,7142,7142,7144,7145,7149,7149,7151,7153,7212,7219,7222,7223,7376,7378,7380,7392,7394,7400,7405,7405,7412,7412,7416,7417,7616,7679,8204,8204,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43045,43046,43052,43052,43204,43205,43232,43249,43263,43263,43302,43309,43335,43345,43392,43394,43443,43443,43446,43449,43452,43453,43493,43493,43561,43566,43569,43570,43573,43574,43587,43587,43596,43596,43644,43644,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43756,43757,43766,43766,44005,44005,44008,44008,44013,44013,64286,64286,65024,65039,65056,65071,65438,65439,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69633,69633,69688,69702,69744,69744,69747,69748,69759,69761,69811,69814,69817,69818,69826,69826,69888,69890,69927,69931,69933,69940,70003,70003,70016,70017,70070,70078,70089,70092,70095,70095,70191,70193,70196,70196,70198,70199,70206,70206,70209,70209,70367,70367,70371,70378,70400,70401,70459,70460,70462,70462,70464,70464,70487,70487,70502,70508,70512,70516,70712,70719,70722,70724,70726,70726,70750,70750,70832,70832,70835,70840,70842,70842,70845,70845,70847,70848,70850,70851,71087,71087,71090,71093,71100,71101,71103,71104,71132,71133,71219,71226,71229,71229,71231,71232,71339,71339,71341,71341,71344,71349,71351,71351,71453,71455,71458,71461,71463,71467,71727,71735,71737,71738,71984,71984,71995,71996,71998,71998,72003,72003,72148,72151,72154,72155,72160,72160,72193,72202,72243,72248,72251,72254,72263,72263,72273,72278,72281,72283,72330,72342,72344,72345,72752,72758,72760,72765,72767,72767,72850,72871,72874,72880,72882,72883,72885,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73104,73105,73109,73109,73111,73111,73459,73460,73472,73473,73526,73530,73536,73536,73538,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94095,94098,94180,94180,113821,113822,118528,118573,118576,118598,119141,119141,119143,119145,119150,119154,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,127995,127999,917536,917631,917760,917999 }); }
	static private void addProperty1069() { addProperty("gcb=l", new int[] { 4352,4447,43360,43388 }); }
	static private void addProperty1070() { addProperty("gcb=lf", new int[] { 10,10 }); }
	static private void addProperty1071() { addProperty("gcb=lv", new int[] { 44032,44032,44060,44060,44088,44088,44116,44116,44144,44144,44172,44172,44200,44200,44228,44228,44256,44256,44284,44284,44312,44312,44340,44340,44368,44368,44396,44396,44424,44424,44452,44452,44480,44480,44508,44508,44536,44536,44564,44564,44592,44592,44620,44620,44648,44648,44676,44676,44704,44704,44732,44732,44760,44760,44788,44788,44816,44816,44844,44844,44872,44872,44900,44900,44928,44928,44956,44956,44984,44984,45012,45012,45040,45040,45068,45068,45096,45096,45124,45124,45152,45152,45180,45180,45208,45208,45236,45236,45264,45264,45292,45292,45320,45320,45348,45348,45376,45376,45404,45404,45432,45432,45460,45460,45488,45488,45516,45516,45544,45544,45572,45572,45600,45600,45628,45628,45656,45656,45684,45684,45712,45712,45740,45740,45768,45768,45796,45796,45824,45824,45852,45852,45880,45880,45908,45908,45936,45936,45964,45964,45992,45992,46020,46020,46048,46048,46076,46076,46104,46104,46132,46132,46160,46160,46188,46188,46216,46216,46244,46244,46272,46272,46300,46300,46328,46328,46356,46356,46384,46384,46412,46412,46440,46440,46468,46468,46496,46496,46524,46524,46552,46552,46580,46580,46608,46608,46636,46636,46664,46664,46692,46692,46720,46720,46748,46748,46776,46776,46804,46804,46832,46832,46860,46860,46888,46888,46916,46916,46944,46944,46972,46972,47000,47000,47028,47028,47056,47056,47084,47084,47112,47112,47140,47140,47168,47168,47196,47196,47224,47224,47252,47252,47280,47280,47308,47308,47336,47336,47364,47364,47392,47392,47420,47420,47448,47448,47476,47476,47504,47504,47532,47532,47560,47560,47588,47588,47616,47616,47644,47644,47672,47672,47700,47700,47728,47728,47756,47756,47784,47784,47812,47812,47840,47840,47868,47868,47896,47896,47924,47924,47952,47952,47980,47980,48008,48008,48036,48036,48064,48064,48092,48092,48120,48120,48148,48148,48176,48176,48204,48204,48232,48232,48260,48260,48288,48288,48316,48316,48344,48344,48372,48372,48400,48400,48428,48428,48456,48456,48484,48484,48512,48512,48540,48540,48568,48568,48596,48596,48624,48624,48652,48652,48680,48680,48708,48708,48736,48736,48764,48764,48792,48792,48820,48820,48848,48848,48876,48876,48904,48904,48932,48932,48960,48960,48988,48988,49016,49016,49044,49044,49072,49072,49100,49100,49128,49128,49156,49156,49184,49184,49212,49212,49240,49240,49268,49268,49296,49296,49324,49324,49352,49352,49380,49380,49408,49408,49436,49436,49464,49464,49492,49492,49520,49520,49548,49548,49576,49576,49604,49604,49632,49632,49660,49660,49688,49688,49716,49716,49744,49744,49772,49772,49800,49800,49828,49828,49856,49856,49884,49884,49912,49912,49940,49940,49968,49968,49996,49996,50024,50024,50052,50052,50080,50080,50108,50108,50136,50136,50164,50164,50192,50192,50220,50220,50248,50248,50276,50276,50304,50304,50332,50332,50360,50360,50388,50388,50416,50416,50444,50444,50472,50472,50500,50500,50528,50528,50556,50556,50584,50584,50612,50612,50640,50640,50668,50668,50696,50696,50724,50724,50752,50752,50780,50780,50808,50808,50836,50836,50864,50864,50892,50892,50920,50920,50948,50948,50976,50976,51004,51004,51032,51032,51060,51060,51088,51088,51116,51116,51144,51144,51172,51172,51200,51200,51228,51228,51256,51256,51284,51284,51312,51312,51340,51340,51368,51368,51396,51396,51424,51424,51452,51452,51480,51480,51508,51508,51536,51536,51564,51564,51592,51592,51620,51620,51648,51648,51676,51676,51704,51704,51732,51732,51760,51760,51788,51788,51816,51816,51844,51844,51872,51872,51900,51900,51928,51928,51956,51956,51984,51984,52012,52012,52040,52040,52068,52068,52096,52096,52124,52124,52152,52152,52180,52180,52208,52208,52236,52236,52264,52264,52292,52292,52320,52320,52348,52348,52376,52376,52404,52404,52432,52432,52460,52460,52488,52488,52516,52516,52544,52544,52572,52572,52600,52600,52628,52628,52656,52656,52684,52684,52712,52712,52740,52740,52768,52768,52796,52796,52824,52824,52852,52852,52880,52880,52908,52908,52936,52936,52964,52964,52992,52992,53020,53020,53048,53048,53076,53076,53104,53104,53132,53132,53160,53160,53188,53188,53216,53216,53244,53244,53272,53272,53300,53300,53328,53328,53356,53356,53384,53384,53412,53412,53440,53440,53468,53468,53496,53496,53524,53524,53552,53552,53580,53580,53608,53608,53636,53636,53664,53664,53692,53692,53720,53720,53748,53748,53776,53776,53804,53804,53832,53832,53860,53860,53888,53888,53916,53916,53944,53944,53972,53972,54000,54000,54028,54028,54056,54056,54084,54084,54112,54112,54140,54140,54168,54168,54196,54196,54224,54224,54252,54252,54280,54280,54308,54308,54336,54336,54364,54364,54392,54392,54420,54420,54448,54448,54476,54476,54504,54504,54532,54532,54560,54560,54588,54588,54616,54616,54644,54644,54672,54672,54700,54700,54728,54728,54756,54756,54784,54784,54812,54812,54840,54840,54868,54868,54896,54896,54924,54924,54952,54952,54980,54980,55008,55008,55036,55036,55064,55064,55092,55092,55120,55120,55148,55148,55176,55176 }); }
	static private void addProperty1072() { addProperty("gcb=lvt", new int[] { 44033,44059,44061,44087,44089,44115,44117,44143,44145,44171,44173,44199,44201,44227,44229,44255,44257,44283,44285,44311,44313,44339,44341,44367,44369,44395,44397,44423,44425,44451,44453,44479,44481,44507,44509,44535,44537,44563,44565,44591,44593,44619,44621,44647,44649,44675,44677,44703,44705,44731,44733,44759,44761,44787,44789,44815,44817,44843,44845,44871,44873,44899,44901,44927,44929,44955,44957,44983,44985,45011,45013,45039,45041,45067,45069,45095,45097,45123,45125,45151,45153,45179,45181,45207,45209,45235,45237,45263,45265,45291,45293,45319,45321,45347,45349,45375,45377,45403,45405,45431,45433,45459,45461,45487,45489,45515,45517,45543,45545,45571,45573,45599,45601,45627,45629,45655,45657,45683,45685,45711,45713,45739,45741,45767,45769,45795,45797,45823,45825,45851,45853,45879,45881,45907,45909,45935,45937,45963,45965,45991,45993,46019,46021,46047,46049,46075,46077,46103,46105,46131,46133,46159,46161,46187,46189,46215,46217,46243,46245,46271,46273,46299,46301,46327,46329,46355,46357,46383,46385,46411,46413,46439,46441,46467,46469,46495,46497,46523,46525,46551,46553,46579,46581,46607,46609,46635,46637,46663,46665,46691,46693,46719,46721,46747,46749,46775,46777,46803,46805,46831,46833,46859,46861,46887,46889,46915,46917,46943,46945,46971,46973,46999,47001,47027,47029,47055,47057,47083,47085,47111,47113,47139,47141,47167,47169,47195,47197,47223,47225,47251,47253,47279,47281,47307,47309,47335,47337,47363,47365,47391,47393,47419,47421,47447,47449,47475,47477,47503,47505,47531,47533,47559,47561,47587,47589,47615,47617,47643,47645,47671,47673,47699,47701,47727,47729,47755,47757,47783,47785,47811,47813,47839,47841,47867,47869,47895,47897,47923,47925,47951,47953,47979,47981,48007,48009,48035,48037,48063,48065,48091,48093,48119,48121,48147,48149,48175,48177,48203,48205,48231,48233,48259,48261,48287,48289,48315,48317,48343,48345,48371,48373,48399,48401,48427,48429,48455,48457,48483,48485,48511,48513,48539,48541,48567,48569,48595,48597,48623,48625,48651,48653,48679,48681,48707,48709,48735,48737,48763,48765,48791,48793,48819,48821,48847,48849,48875,48877,48903,48905,48931,48933,48959,48961,48987,48989,49015,49017,49043,49045,49071,49073,49099,49101,49127,49129,49155,49157,49183,49185,49211,49213,49239,49241,49267,49269,49295,49297,49323,49325,49351,49353,49379,49381,49407,49409,49435,49437,49463,49465,49491,49493,49519,49521,49547,49549,49575,49577,49603,49605,49631,49633,49659,49661,49687,49689,49715,49717,49743,49745,49771,49773,49799,49801,49827,49829,49855,49857,49883,49885,49911,49913,49939,49941,49967,49969,49995,49997,50023,50025,50051,50053,50079,50081,50107,50109,50135,50137,50163,50165,50191,50193,50219,50221,50247,50249,50275,50277,50303,50305,50331,50333,50359,50361,50387,50389,50415,50417,50443,50445,50471,50473,50499,50501,50527,50529,50555,50557,50583,50585,50611,50613,50639,50641,50667,50669,50695,50697,50723,50725,50751,50753,50779,50781,50807,50809,50835,50837,50863,50865,50891,50893,50919,50921,50947,50949,50975,50977,51003,51005,51031,51033,51059,51061,51087,51089,51115,51117,51143,51145,51171,51173,51199,51201,51227,51229,51255,51257,51283,51285,51311,51313,51339,51341,51367,51369,51395,51397,51423,51425,51451,51453,51479,51481,51507,51509,51535,51537,51563,51565,51591,51593,51619,51621,51647,51649,51675,51677,51703,51705,51731,51733,51759,51761,51787,51789,51815,51817,51843,51845,51871,51873,51899,51901,51927,51929,51955,51957,51983,51985,52011,52013,52039,52041,52067,52069,52095,52097,52123,52125,52151,52153,52179,52181,52207,52209,52235,52237,52263,52265,52291,52293,52319,52321,52347,52349,52375,52377,52403,52405,52431,52433,52459,52461,52487,52489,52515,52517,52543,52545,52571,52573,52599,52601,52627,52629,52655,52657,52683,52685,52711,52713,52739,52741,52767,52769,52795,52797,52823,52825,52851,52853,52879,52881,52907,52909,52935,52937,52963,52965,52991,52993,53019,53021,53047,53049,53075,53077,53103,53105,53131,53133,53159,53161,53187,53189,53215,53217,53243,53245,53271,53273,53299,53301,53327,53329,53355,53357,53383,53385,53411,53413,53439,53441,53467,53469,53495,53497,53523,53525,53551,53553,53579,53581,53607,53609,53635,53637,53663,53665,53691,53693,53719,53721,53747,53749,53775,53777,53803,53805,53831,53833,53859,53861,53887,53889,53915,53917,53943,53945,53971,53973,53999,54001,54027,54029,54055,54057,54083,54085,54111,54113,54139,54141,54167,54169,54195,54197,54223,54225,54251,54253,54279,54281,54307,54309,54335,54337,54363,54365,54391,54393,54419,54421,54447,54449,54475,54477,54503,54505,54531,54533,54559,54561,54587,54589,54615,54617,54643,54645,54671,54673,54699,54701,54727,54729,54755,54757,54783,54785,54811,54813,54839,54841,54867,54869,54895,54897,54923,54925,54951,54953,54979,54981,55007,55009,55035,55037,55063,55065,55091,55093,55119,55121,55147,55149,55175,55177,55203 }); }
	static private void addProperty1073() { addProperty("gcb=t", new int[] { 4520,4607,55243,55291 }); }
	static private void addProperty1074() { addProperty("gcb=v", new int[] { 4448,4519,55216,55238 }); }
	static private void addProperty1075() { addProperty("gcb=sm", new int[] { 2307,2307,2363,2363,2366,2368,2377,2380,2382,2383,2434,2435,2495,2496,2503,2504,2507,2508,2563,2563,2622,2624,2691,2691,2750,2752,2761,2761,2763,2764,2818,2819,2880,2880,2887,2888,2891,2892,3007,3007,3009,3010,3014,3016,3018,3020,3073,3075,3137,3140,3202,3203,3262,3262,3264,3265,3267,3268,3271,3272,3274,3275,3315,3315,3330,3331,3391,3392,3398,3400,3402,3404,3458,3459,3536,3537,3544,3550,3570,3571,3635,3635,3763,3763,3902,3903,3967,3967,4145,4145,4155,4156,4182,4183,4228,4228,5909,5909,5940,5940,6070,6070,6078,6085,6087,6088,6435,6438,6441,6443,6448,6449,6451,6456,6681,6682,6741,6741,6743,6743,6765,6770,6916,6916,6971,6971,6973,6977,6979,6980,7042,7042,7073,7073,7078,7079,7082,7082,7143,7143,7146,7148,7150,7150,7154,7155,7204,7211,7220,7221,7393,7393,7415,7415,43043,43044,43047,43047,43136,43137,43188,43203,43346,43347,43395,43395,43444,43445,43450,43451,43454,43456,43567,43568,43571,43572,43597,43597,43755,43755,43758,43759,43765,43765,44003,44004,44006,44007,44009,44010,44012,44012,69632,69632,69634,69634,69762,69762,69808,69810,69815,69816,69932,69932,69957,69958,70018,70018,70067,70069,70079,70080,70094,70094,70188,70190,70194,70195,70197,70197,70368,70370,70402,70403,70463,70463,70465,70468,70471,70472,70475,70477,70498,70499,70709,70711,70720,70721,70725,70725,70833,70834,70841,70841,70843,70844,70846,70846,70849,70849,71088,71089,71096,71099,71102,71102,71216,71218,71227,71228,71230,71230,71340,71340,71342,71343,71350,71350,71462,71462,71724,71726,71736,71736,71985,71989,71991,71992,71997,71997,72000,72000,72002,72002,72145,72147,72156,72159,72164,72164,72249,72249,72279,72280,72343,72343,72751,72751,72766,72766,72873,72873,72881,72881,72884,72884,73098,73102,73107,73108,73110,73110,73461,73462,73475,73475,73524,73525,73534,73535,73537,73537,94033,94087,94192,94193,119142,119142,119149,119149 }); }
	static private void addProperty1076() { addProperty("gcb=pp", new int[] { 1536,1541,1757,1757,1807,1807,2192,2193,2274,2274,3406,3406,69821,69821,69837,69837,70082,70083,71999,71999,72001,72001,72250,72250,72324,72329,73030,73030,73474,73474 }); }
	static private void addProperty1077() { addProperty("gcb=ri", new int[] { 127462,127487 }); }
	static private void addProperty1078() { addProperty("gcb=eb", new int[] {  }); }
	static private void addProperty1079() { addProperty("gcb=ebg", new int[] {  }); }
	static private void addProperty1080() { addProperty("gcb=em", new int[] {  }); }
	static private void addProperty1081() { addProperty("gcb=gaz", new int[] {  }); }
	static private void addProperty1082() { addProperty("gcb=zwj", new int[] { 8205,8205 }); }
	static private void addProperty1083() { addProperty("sb=xx", new int[] { 0,8,14,31,35,38,42,43,47,47,59,62,64,64,92,92,94,96,124,124,126,132,134,159,161,169,172,172,174,180,182,185,188,191,215,215,247,247,706,709,722,735,741,747,749,749,751,767,885,885,888,889,894,894,896,901,903,903,907,907,909,909,930,930,1014,1014,1154,1154,1328,1328,1367,1368,1370,1372,1374,1375,1418,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1487,1515,1518,1524,1535,1542,1547,1550,1551,1563,1563,1642,1642,1645,1645,1758,1758,1769,1769,1789,1790,1795,1806,1867,1868,1970,1983,2038,2039,2043,2044,2046,2047,2094,2102,2104,2104,2106,2108,2111,2111,2140,2143,2155,2159,2184,2184,2191,2191,2194,2199,2416,2416,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2546,2555,2557,2557,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2678,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2800,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2928,2928,2930,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3056,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3199,3204,3204,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3407,3411,3416,3422,3428,3429,3440,3449,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3572,3584,3643,3647,3663,3663,3674,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3774,3775,3781,3781,3783,3783,3791,3791,3802,3803,3808,3839,3841,3863,3866,3871,3882,3892,3894,3894,3896,3896,3912,3912,3949,3952,3973,3973,3992,3992,4029,4037,4039,4095,4172,4175,4254,4255,4294,4294,4296,4300,4302,4303,4347,4347,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4960,4961,4963,4966,4969,4991,5008,5023,5110,5111,5118,5120,5741,5741,5789,5791,5867,5869,5881,5887,5910,5918,5943,5951,5972,5983,5997,5997,6001,6001,6004,6015,6100,6102,6104,6107,6110,6111,6122,6145,6148,6151,6154,6154,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6467,6510,6511,6517,6527,6572,6575,6602,6607,6618,6655,6684,6687,6751,6751,6781,6782,6794,6799,6810,6822,6828,6831,6863,6911,6989,6991,7004,7005,7008,7018,7028,7036,7039,7039,7156,7167,7224,7226,7229,7231,7242,7244,7305,7311,7355,7356,7360,7375,7379,7379,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8125,8125,8127,8129,8133,8133,8141,8143,8148,8149,8156,8159,8173,8177,8181,8181,8189,8191,8208,8210,8213,8215,8224,8227,8229,8231,8240,8248,8251,8251,8254,8260,8266,8286,8293,8293,8304,8304,8306,8316,8320,8332,8335,8335,8349,8399,8433,8449,8451,8454,8456,8457,8468,8468,8470,8472,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8506,8507,8512,8516,8522,8525,8527,8543,8585,8967,8972,9000,9003,9397,9450,10074,10081,10087,10102,10180,10183,10213,10224,10626,10649,10711,10716,10747,10750,11263,11493,11498,11508,11519,11558,11558,11560,11564,11566,11567,11624,11630,11632,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11790,11803,11806,11807,11818,11821,11824,11835,11837,11841,11843,11858,11869,12287,12291,12292,12306,12307,12316,12316,12320,12320,12336,12336,12342,12343,12349,12352,12439,12440,12443,12444,12448,12448,12539,12539,12544,12548,12592,12592,12687,12703,12736,12783,12800,13311,19904,19967,42125,42191,42238,42238,42509,42509,42540,42559,42611,42611,42622,42622,42738,42738,42740,42742,42744,42774,42784,42785,42889,42890,42955,42959,42962,42962,42964,42964,42970,42993,43048,43051,43053,43071,43124,43125,43128,43135,43206,43213,43226,43231,43256,43258,43260,43260,43310,43310,43348,43359,43389,43391,43457,43463,43466,43470,43482,43487,43519,43519,43575,43583,43598,43599,43610,43612,43639,43641,43715,43738,43742,43743,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43867,43867,43882,43887,44014,44015,44026,44031,55204,55215,55239,55242,55292,63743,64110,64111,64218,64255,64263,64274,64280,64284,64297,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64832,64847,64912,64913,64968,65007,65020,65023,65042,65042,65044,65046,65049,65055,65072,65072,65075,65076,65093,65094,65097,65103,65107,65108,65119,65122,65124,65135,65141,65141,65277,65278,65280,65280,65282,65287,65290,65291,65295,65295,65307,65310,65312,65312,65340,65340,65342,65344,65372,65372,65374,65374,65381,65381,65471,65473,65480,65481,65488,65489,65496,65497,65501,65528,65532,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65855,65909,66044,66046,66175,66205,66207,66257,66271,66273,66303,66336,66348,66379,66383,66427,66431,66462,66463,66500,66503,66512,66512,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66927,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67679,67703,67711,67743,67807,67827,67827,67830,67839,67862,67871,67898,67967,68024,68029,68032,68095,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68160,68181,68184,68191,68221,68223,68253,68287,68296,68296,68327,68351,68406,68415,68438,68447,68467,68479,68498,68607,68681,68735,68787,68799,68851,68863,68904,68911,68922,69247,69290,69290,69293,69295,69298,69372,69405,69414,69416,69423,69457,69460,69466,69487,69514,69551,69573,69599,69623,69631,69705,69733,69750,69758,69819,69820,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69952,69952,69960,69967,70004,70005,70007,70015,70087,70088,70107,70107,70109,70109,70112,70143,70162,70162,70202,70202,70205,70205,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70314,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70733,70735,70746,70749,70754,70783,70854,70854,70856,70863,70874,71039,71094,71095,71105,71105,71108,71112,71134,71167,71235,71235,71237,71247,71258,71295,71353,71359,71370,71423,71451,71452,71468,71471,71482,71483,71487,71487,71495,71679,71739,71839,71914,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72005,72005,72007,72015,72026,72095,72104,72105,72152,72153,72162,72162,72165,72191,72255,72257,72260,72262,72264,72271,72346,72346,72350,72367,72441,72703,72713,72713,72759,72759,72771,72783,72794,72817,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73465,73471,73489,73489,73531,73533,73541,73551,73562,73647,73649,73727,74650,74751,74863,74879,75076,77711,77809,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92781,92863,92863,92874,92879,92910,92911,92918,92927,92985,92991,92997,93007,93018,93026,93048,93052,93072,93759,93824,93847,93849,93951,94027,94030,94088,94094,94112,94175,94178,94178,94181,94191,94194,94207,100344,100351,101590,101631,101641,110575,110580,110580,110588,110588,110591,110591,110883,110897,110899,110927,110931,110932,110934,110947,110952,110959,111356,113663,113771,113775,113789,113791,113801,113807,113818,113820,113828,118527,118574,118575,118599,119140,119146,119148,119171,119172,119180,119209,119214,119361,119365,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120513,120513,120539,120539,120571,120571,120597,120597,120629,120629,120655,120655,120687,120687,120713,120713,120745,120745,120771,120771,120780,120781,120832,121343,121399,121402,121453,121460,121462,121475,121477,121479,121481,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123215,123535,123567,123583,123642,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125135,125143,125183,125260,125263,125274,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127279,127306,127311,127338,127343,127370,128629,128633,130031,130042,131071,173792,173823,177978,177983,178206,178207,183970,183983,191457,194559,195102,196607,201547,201551,205744,917504,917506,917535,917632,917759,918000,1114111 }); }
	static private void addProperty1084() { addProperty("sb=at", new int[] { 46,46,8228,8228,65106,65106,65294,65294 }); }
	static private void addProperty1085() { addProperty("sb=cl", new int[] { 34,34,39,41,91,91,93,93,123,123,125,125,171,171,187,187,3898,3901,5787,5788,8216,8223,8249,8250,8261,8262,8317,8318,8333,8334,8968,8971,9001,9002,10075,10080,10088,10101,10181,10182,10214,10223,10627,10648,10712,10715,10748,10749,11776,11789,11804,11805,11808,11817,11842,11842,11861,11868,12296,12305,12308,12315,12317,12319,64830,64831,65047,65048,65077,65092,65095,65096,65113,65118,65288,65289,65339,65339,65341,65341,65371,65371,65373,65373,65375,65376,65378,65379,128630,128632 }); }
	static private void addProperty1086() { addProperty("sb=fo", new int[] { 173,173,1536,1541,1564,1564,1757,1757,1807,1807,2192,2193,2274,2274,6158,6158,8203,8203,8206,8207,8234,8238,8288,8292,8294,8303,65279,65279,65529,65531,69821,69821,69837,69837,78896,78911,113824,113827,119155,119162,917505,917505 }); }
	static private void addProperty1087() { addProperty("sb=lo", new int[] { 97,122,170,170,181,181,186,186,223,246,248,255,257,257,259,259,261,261,263,263,265,265,267,267,269,269,271,271,273,273,275,275,277,277,279,279,281,281,283,283,285,285,287,287,289,289,291,291,293,293,295,295,297,297,299,299,301,301,303,303,305,305,307,307,309,309,311,312,314,314,316,316,318,318,320,320,322,322,324,324,326,326,328,329,331,331,333,333,335,335,337,337,339,339,341,341,343,343,345,345,347,347,349,349,351,351,353,353,355,355,357,357,359,359,361,361,363,363,365,365,367,367,369,369,371,371,373,373,375,375,378,378,380,380,382,384,387,387,389,389,392,392,396,397,402,402,405,405,409,411,414,414,417,417,419,419,421,421,424,424,426,427,429,429,432,432,436,436,438,438,441,442,445,447,454,454,457,457,460,460,462,462,464,464,466,466,468,468,470,470,472,472,474,474,476,477,479,479,481,481,483,483,485,485,487,487,489,489,491,491,493,493,495,496,499,499,501,501,505,505,507,507,509,509,511,511,513,513,515,515,517,517,519,519,521,521,523,523,525,525,527,527,529,529,531,531,533,533,535,535,537,537,539,539,541,541,543,543,545,545,547,547,549,549,551,551,553,553,555,555,557,557,559,559,561,561,563,569,572,572,575,576,578,578,583,583,585,585,587,587,589,589,591,659,661,696,704,705,736,740,881,881,883,883,887,887,890,893,912,912,940,974,976,977,981,983,985,985,987,987,989,989,991,991,993,993,995,995,997,997,999,999,1001,1001,1003,1003,1005,1005,1007,1011,1013,1013,1016,1016,1019,1020,1072,1119,1121,1121,1123,1123,1125,1125,1127,1127,1129,1129,1131,1131,1133,1133,1135,1135,1137,1137,1139,1139,1141,1141,1143,1143,1145,1145,1147,1147,1149,1149,1151,1151,1153,1153,1163,1163,1165,1165,1167,1167,1169,1169,1171,1171,1173,1173,1175,1175,1177,1177,1179,1179,1181,1181,1183,1183,1185,1185,1187,1187,1189,1189,1191,1191,1193,1193,1195,1195,1197,1197,1199,1199,1201,1201,1203,1203,1205,1205,1207,1207,1209,1209,1211,1211,1213,1213,1215,1215,1218,1218,1220,1220,1222,1222,1224,1224,1226,1226,1228,1228,1230,1231,1233,1233,1235,1235,1237,1237,1239,1239,1241,1241,1243,1243,1245,1245,1247,1247,1249,1249,1251,1251,1253,1253,1255,1255,1257,1257,1259,1259,1261,1261,1263,1263,1265,1265,1267,1267,1269,1269,1271,1271,1273,1273,1275,1275,1277,1277,1279,1279,1281,1281,1283,1283,1285,1285,1287,1287,1289,1289,1291,1291,1293,1293,1295,1295,1297,1297,1299,1299,1301,1301,1303,1303,1305,1305,1307,1307,1309,1309,1311,1311,1313,1313,1315,1315,1317,1317,1319,1319,1321,1321,1323,1323,1325,1325,1327,1327,1376,1416,4348,4348,5112,5117,7296,7304,7424,7615,7681,7681,7683,7683,7685,7685,7687,7687,7689,7689,7691,7691,7693,7693,7695,7695,7697,7697,7699,7699,7701,7701,7703,7703,7705,7705,7707,7707,7709,7709,7711,7711,7713,7713,7715,7715,7717,7717,7719,7719,7721,7721,7723,7723,7725,7725,7727,7727,7729,7729,7731,7731,7733,7733,7735,7735,7737,7737,7739,7739,7741,7741,7743,7743,7745,7745,7747,7747,7749,7749,7751,7751,7753,7753,7755,7755,7757,7757,7759,7759,7761,7761,7763,7763,7765,7765,7767,7767,7769,7769,7771,7771,7773,7773,7775,7775,7777,7777,7779,7779,7781,7781,7783,7783,7785,7785,7787,7787,7789,7789,7791,7791,7793,7793,7795,7795,7797,7797,7799,7799,7801,7801,7803,7803,7805,7805,7807,7807,7809,7809,7811,7811,7813,7813,7815,7815,7817,7817,7819,7819,7821,7821,7823,7823,7825,7825,7827,7827,7829,7837,7839,7839,7841,7841,7843,7843,7845,7845,7847,7847,7849,7849,7851,7851,7853,7853,7855,7855,7857,7857,7859,7859,7861,7861,7863,7863,7865,7865,7867,7867,7869,7869,7871,7871,7873,7873,7875,7875,7877,7877,7879,7879,7881,7881,7883,7883,7885,7885,7887,7887,7889,7889,7891,7891,7893,7893,7895,7895,7897,7897,7899,7899,7901,7901,7903,7903,7905,7905,7907,7907,7909,7909,7911,7911,7913,7913,7915,7915,7917,7917,7919,7919,7921,7921,7923,7923,7925,7925,7927,7927,7929,7929,7931,7931,7933,7933,7935,7943,7952,7957,7968,7975,7984,7991,8000,8005,8016,8023,8032,8039,8048,8061,8064,8071,8080,8087,8096,8103,8112,8116,8118,8119,8126,8126,8130,8132,8134,8135,8144,8147,8150,8151,8160,8167,8178,8180,8182,8183,8305,8305,8319,8319,8336,8348,8458,8458,8462,8463,8467,8467,8495,8495,8500,8500,8505,8505,8508,8509,8518,8521,8526,8526,8560,8575,8580,8580,9424,9449,11312,11359,11361,11361,11365,11366,11368,11368,11370,11370,11372,11372,11377,11377,11379,11380,11382,11389,11393,11393,11395,11395,11397,11397,11399,11399,11401,11401,11403,11403,11405,11405,11407,11407,11409,11409,11411,11411,11413,11413,11415,11415,11417,11417,11419,11419,11421,11421,11423,11423,11425,11425,11427,11427,11429,11429,11431,11431,11433,11433,11435,11435,11437,11437,11439,11439,11441,11441,11443,11443,11445,11445,11447,11447,11449,11449,11451,11451,11453,11453,11455,11455,11457,11457,11459,11459,11461,11461,11463,11463,11465,11465,11467,11467,11469,11469,11471,11471,11473,11473,11475,11475,11477,11477,11479,11479,11481,11481,11483,11483,11485,11485,11487,11487,11489,11489,11491,11492,11500,11500,11502,11502,11507,11507,11520,11557,11559,11559,11565,11565,42561,42561,42563,42563,42565,42565,42567,42567,42569,42569,42571,42571,42573,42573,42575,42575,42577,42577,42579,42579,42581,42581,42583,42583,42585,42585,42587,42587,42589,42589,42591,42591,42593,42593,42595,42595,42597,42597,42599,42599,42601,42601,42603,42603,42605,42605,42625,42625,42627,42627,42629,42629,42631,42631,42633,42633,42635,42635,42637,42637,42639,42639,42641,42641,42643,42643,42645,42645,42647,42647,42649,42649,42651,42653,42787,42787,42789,42789,42791,42791,42793,42793,42795,42795,42797,42797,42799,42801,42803,42803,42805,42805,42807,42807,42809,42809,42811,42811,42813,42813,42815,42815,42817,42817,42819,42819,42821,42821,42823,42823,42825,42825,42827,42827,42829,42829,42831,42831,42833,42833,42835,42835,42837,42837,42839,42839,42841,42841,42843,42843,42845,42845,42847,42847,42849,42849,42851,42851,42853,42853,42855,42855,42857,42857,42859,42859,42861,42861,42863,42872,42874,42874,42876,42876,42879,42879,42881,42881,42883,42883,42885,42885,42887,42887,42892,42892,42894,42894,42897,42897,42899,42901,42903,42903,42905,42905,42907,42907,42909,42909,42911,42911,42913,42913,42915,42915,42917,42917,42919,42919,42921,42921,42927,42927,42933,42933,42935,42935,42937,42937,42939,42939,42941,42941,42943,42943,42945,42945,42947,42947,42952,42952,42954,42954,42961,42961,42963,42963,42965,42965,42967,42967,42969,42969,42994,42996,42998,42998,43000,43002,43824,43866,43868,43881,43888,43967,64256,64262,64275,64279,65345,65370,66600,66639,66776,66811,66967,66977,66979,66993,66995,67001,67003,67004,67456,67456,67459,67461,67463,67504,67506,67514,68800,68850,71872,71903,93792,93823,119834,119859,119886,119892,119894,119911,119938,119963,119990,119993,119995,119995,119997,120003,120005,120015,120042,120067,120094,120119,120146,120171,120198,120223,120250,120275,120302,120327,120354,120379,120406,120431,120458,120485,120514,120538,120540,120545,120572,120596,120598,120603,120630,120654,120656,120661,120688,120712,120714,120719,120746,120770,120772,120777,120779,120779,122624,122633,122635,122654,122661,122666,122928,122989,125218,125251 }); }
	static private void addProperty1088() { addProperty("sb=nu", new int[] { 48,57,1632,1641,1643,1644,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty1089() { addProperty("sb=le", new int[] { 443,443,448,451,660,660,697,703,710,721,748,748,750,750,884,884,1369,1369,1488,1514,1519,1523,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2417,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3585,3632,3634,3635,3648,3654,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3760,3762,3763,3773,3773,3776,3780,3782,3782,3804,3807,3840,3840,3904,3911,3913,3948,3976,3980,4096,4138,4159,4159,4176,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4304,4346,4349,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6016,6067,6103,6103,6108,6108,6176,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6480,6509,6512,6516,6528,6571,6576,6601,6656,6678,6688,6740,6823,6823,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,8501,8504,8576,8578,8581,8584,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11823,11823,12293,12295,12321,12329,12337,12341,12344,12348,12353,12438,12445,12447,12449,12538,12540,12543,12549,12591,12593,12686,12704,12735,12784,12799,13312,19903,19968,42124,42192,42237,42240,42508,42512,42527,42538,42539,42606,42606,42623,42623,42656,42735,42775,42783,42888,42888,42895,42895,42999,42999,43003,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43488,43492,43494,43503,43514,43518,43520,43560,43584,43586,43588,43595,43616,43638,43642,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43714,43739,43741,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43968,44002,44032,55203,55216,55238,55243,55291,63744,64109,64112,64217,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65382,65437,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66421,66432,66461,66464,66499,66504,66511,66513,66517,66640,66717,66816,66855,66864,66915,67072,67382,67392,67413,67424,67431,67457,67458,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71424,71450,71488,71494,71680,71723,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93952,94026,94032,94032,94099,94111,94176,94177,94179,94179,94208,100343,100352,101589,101632,101640,110576,110579,110581,110587,110589,110590,110592,110882,110898,110898,110928,110930,110933,110933,110948,110951,110960,111355,113664,113770,113776,113788,113792,113800,113808,113817,122634,122634,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,131072,173791,173824,177977,177984,178205,178208,183969,183984,191456,194560,195101,196608,201546,201552,205743 }); }
	static private void addProperty1090() { addProperty("sb=se", new int[] { 133,133,8232,8233 }); }
	static private void addProperty1091() { addProperty("sb=sp", new int[] { 9,9,11,12,32,32,160,160,5760,5760,8192,8202,8239,8239,8287,8287,12288,12288 }); }
	static private void addProperty1092() { addProperty("sb=st", new int[] { 33,33,63,63,1417,1417,1565,1567,1748,1748,1792,1794,2041,2041,2103,2103,2105,2105,2109,2110,2404,2405,4170,4171,4962,4962,4967,4968,5742,5742,5941,5942,6147,6147,6153,6153,6468,6469,6824,6827,7002,7003,7006,7007,7037,7038,7227,7228,7294,7295,8252,8253,8263,8265,11822,11822,11836,11836,11859,11860,12290,12290,42239,42239,42510,42511,42739,42739,42743,42743,43126,43127,43214,43215,43311,43311,43464,43465,43613,43615,43760,43761,44011,44011,65110,65111,65281,65281,65311,65311,65377,65377,68182,68183,69461,69465,69510,69513,69703,69704,69822,69825,69953,69955,70085,70086,70093,70093,70110,70111,70200,70201,70203,70204,70313,70313,70731,70732,71106,71107,71113,71127,71233,71234,71484,71486,72004,72004,72006,72006,72258,72259,72347,72348,72769,72770,73463,73464,73539,73540,92782,92783,92917,92917,92983,92984,92996,92996,93848,93848,113823,113823,121480,121480 }); }
	static private void addProperty1093() { addProperty("sb=up", new int[] { 65,90,192,214,216,222,256,256,258,258,260,260,262,262,264,264,266,266,268,268,270,270,272,272,274,274,276,276,278,278,280,280,282,282,284,284,286,286,288,288,290,290,292,292,294,294,296,296,298,298,300,300,302,302,304,304,306,306,308,308,310,310,313,313,315,315,317,317,319,319,321,321,323,323,325,325,327,327,330,330,332,332,334,334,336,336,338,338,340,340,342,342,344,344,346,346,348,348,350,350,352,352,354,354,356,356,358,358,360,360,362,362,364,364,366,366,368,368,370,370,372,372,374,374,376,377,379,379,381,381,385,386,388,388,390,391,393,395,398,401,403,404,406,408,412,413,415,416,418,418,420,420,422,423,425,425,428,428,430,431,433,435,437,437,439,440,444,444,452,453,455,456,458,459,461,461,463,463,465,465,467,467,469,469,471,471,473,473,475,475,478,478,480,480,482,482,484,484,486,486,488,488,490,490,492,492,494,494,497,498,500,500,502,504,506,506,508,508,510,510,512,512,514,514,516,516,518,518,520,520,522,522,524,524,526,526,528,528,530,530,532,532,534,534,536,536,538,538,540,540,542,542,544,544,546,546,548,548,550,550,552,552,554,554,556,556,558,558,560,560,562,562,570,571,573,574,577,577,579,582,584,584,586,586,588,588,590,590,880,880,882,882,886,886,895,895,902,902,904,906,908,908,910,911,913,929,931,939,975,975,978,980,984,984,986,986,988,988,990,990,992,992,994,994,996,996,998,998,1000,1000,1002,1002,1004,1004,1006,1006,1012,1012,1015,1015,1017,1018,1021,1071,1120,1120,1122,1122,1124,1124,1126,1126,1128,1128,1130,1130,1132,1132,1134,1134,1136,1136,1138,1138,1140,1140,1142,1142,1144,1144,1146,1146,1148,1148,1150,1150,1152,1152,1162,1162,1164,1164,1166,1166,1168,1168,1170,1170,1172,1172,1174,1174,1176,1176,1178,1178,1180,1180,1182,1182,1184,1184,1186,1186,1188,1188,1190,1190,1192,1192,1194,1194,1196,1196,1198,1198,1200,1200,1202,1202,1204,1204,1206,1206,1208,1208,1210,1210,1212,1212,1214,1214,1216,1217,1219,1219,1221,1221,1223,1223,1225,1225,1227,1227,1229,1229,1232,1232,1234,1234,1236,1236,1238,1238,1240,1240,1242,1242,1244,1244,1246,1246,1248,1248,1250,1250,1252,1252,1254,1254,1256,1256,1258,1258,1260,1260,1262,1262,1264,1264,1266,1266,1268,1268,1270,1270,1272,1272,1274,1274,1276,1276,1278,1278,1280,1280,1282,1282,1284,1284,1286,1286,1288,1288,1290,1290,1292,1292,1294,1294,1296,1296,1298,1298,1300,1300,1302,1302,1304,1304,1306,1306,1308,1308,1310,1310,1312,1312,1314,1314,1316,1316,1318,1318,1320,1320,1322,1322,1324,1324,1326,1326,1329,1366,4256,4293,4295,4295,4301,4301,5024,5109,7680,7680,7682,7682,7684,7684,7686,7686,7688,7688,7690,7690,7692,7692,7694,7694,7696,7696,7698,7698,7700,7700,7702,7702,7704,7704,7706,7706,7708,7708,7710,7710,7712,7712,7714,7714,7716,7716,7718,7718,7720,7720,7722,7722,7724,7724,7726,7726,7728,7728,7730,7730,7732,7732,7734,7734,7736,7736,7738,7738,7740,7740,7742,7742,7744,7744,7746,7746,7748,7748,7750,7750,7752,7752,7754,7754,7756,7756,7758,7758,7760,7760,7762,7762,7764,7764,7766,7766,7768,7768,7770,7770,7772,7772,7774,7774,7776,7776,7778,7778,7780,7780,7782,7782,7784,7784,7786,7786,7788,7788,7790,7790,7792,7792,7794,7794,7796,7796,7798,7798,7800,7800,7802,7802,7804,7804,7806,7806,7808,7808,7810,7810,7812,7812,7814,7814,7816,7816,7818,7818,7820,7820,7822,7822,7824,7824,7826,7826,7828,7828,7838,7838,7840,7840,7842,7842,7844,7844,7846,7846,7848,7848,7850,7850,7852,7852,7854,7854,7856,7856,7858,7858,7860,7860,7862,7862,7864,7864,7866,7866,7868,7868,7870,7870,7872,7872,7874,7874,7876,7876,7878,7878,7880,7880,7882,7882,7884,7884,7886,7886,7888,7888,7890,7890,7892,7892,7894,7894,7896,7896,7898,7898,7900,7900,7902,7902,7904,7904,7906,7906,7908,7908,7910,7910,7912,7912,7914,7914,7916,7916,7918,7918,7920,7920,7922,7922,7924,7924,7926,7926,7928,7928,7930,7930,7932,7932,7934,7934,7944,7951,7960,7965,7976,7983,7992,7999,8008,8013,8025,8025,8027,8027,8029,8029,8031,8031,8040,8047,8072,8079,8088,8095,8104,8111,8120,8124,8136,8140,8152,8155,8168,8172,8184,8188,8450,8450,8455,8455,8459,8461,8464,8466,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8496,8499,8510,8511,8517,8517,8544,8559,8579,8579,9398,9423,11264,11311,11360,11360,11362,11364,11367,11367,11369,11369,11371,11371,11373,11376,11378,11378,11381,11381,11390,11392,11394,11394,11396,11396,11398,11398,11400,11400,11402,11402,11404,11404,11406,11406,11408,11408,11410,11410,11412,11412,11414,11414,11416,11416,11418,11418,11420,11420,11422,11422,11424,11424,11426,11426,11428,11428,11430,11430,11432,11432,11434,11434,11436,11436,11438,11438,11440,11440,11442,11442,11444,11444,11446,11446,11448,11448,11450,11450,11452,11452,11454,11454,11456,11456,11458,11458,11460,11460,11462,11462,11464,11464,11466,11466,11468,11468,11470,11470,11472,11472,11474,11474,11476,11476,11478,11478,11480,11480,11482,11482,11484,11484,11486,11486,11488,11488,11490,11490,11499,11499,11501,11501,11506,11506,42560,42560,42562,42562,42564,42564,42566,42566,42568,42568,42570,42570,42572,42572,42574,42574,42576,42576,42578,42578,42580,42580,42582,42582,42584,42584,42586,42586,42588,42588,42590,42590,42592,42592,42594,42594,42596,42596,42598,42598,42600,42600,42602,42602,42604,42604,42624,42624,42626,42626,42628,42628,42630,42630,42632,42632,42634,42634,42636,42636,42638,42638,42640,42640,42642,42642,42644,42644,42646,42646,42648,42648,42650,42650,42786,42786,42788,42788,42790,42790,42792,42792,42794,42794,42796,42796,42798,42798,42802,42802,42804,42804,42806,42806,42808,42808,42810,42810,42812,42812,42814,42814,42816,42816,42818,42818,42820,42820,42822,42822,42824,42824,42826,42826,42828,42828,42830,42830,42832,42832,42834,42834,42836,42836,42838,42838,42840,42840,42842,42842,42844,42844,42846,42846,42848,42848,42850,42850,42852,42852,42854,42854,42856,42856,42858,42858,42860,42860,42862,42862,42873,42873,42875,42875,42877,42878,42880,42880,42882,42882,42884,42884,42886,42886,42891,42891,42893,42893,42896,42896,42898,42898,42902,42902,42904,42904,42906,42906,42908,42908,42910,42910,42912,42912,42914,42914,42916,42916,42918,42918,42920,42920,42922,42926,42928,42932,42934,42934,42936,42936,42938,42938,42940,42940,42942,42942,42944,42944,42946,42946,42948,42951,42953,42953,42960,42960,42966,42966,42968,42968,42997,42997,65313,65338,66560,66599,66736,66771,66928,66938,66940,66954,66956,66962,66964,66965,68736,68786,71840,71871,93760,93791,119808,119833,119860,119885,119912,119937,119964,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119989,120016,120041,120068,120069,120071,120074,120077,120084,120086,120092,120120,120121,120123,120126,120128,120132,120134,120134,120138,120144,120172,120197,120224,120249,120276,120301,120328,120353,120380,120405,120432,120457,120488,120512,120546,120570,120604,120628,120662,120686,120720,120744,120778,120778,125184,125217,127280,127305,127312,127337,127344,127369 }); }
	static private void addProperty1094() { addProperty("sb=cr", new int[] { 13,13 }); }
	static private void addProperty1095() { addProperty("sb=ex", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2307,2362,2364,2366,2383,2385,2391,2402,2403,2433,2435,2492,2492,2494,2500,2503,2504,2507,2509,2519,2519,2530,2531,2558,2558,2561,2563,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2691,2748,2748,2750,2757,2759,2761,2763,2765,2786,2787,2810,2815,2817,2819,2876,2876,2878,2884,2887,2888,2891,2893,2901,2903,2914,2915,2946,2946,3006,3010,3014,3016,3018,3021,3031,3031,3072,3076,3132,3132,3134,3140,3142,3144,3146,3149,3157,3158,3170,3171,3201,3203,3260,3260,3262,3268,3270,3272,3274,3277,3285,3286,3298,3299,3315,3315,3328,3331,3387,3388,3390,3396,3398,3400,3402,3405,3415,3415,3426,3427,3457,3459,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3902,3903,3953,3972,3974,3975,3981,3991,3993,4028,4038,4038,4139,4158,4182,4185,4190,4192,4194,4196,4199,4205,4209,4212,4226,4237,4239,4239,4250,4253,4957,4959,5906,5909,5938,5940,5970,5971,6002,6003,6068,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6443,6448,6459,6679,6683,6741,6750,6752,6780,6783,6783,6832,6862,6912,6916,6964,6980,7019,7027,7040,7042,7073,7085,7142,7155,7204,7223,7376,7378,7380,7400,7405,7405,7412,7412,7415,7417,7616,7679,8204,8205,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43043,43047,43052,43052,43136,43137,43188,43205,43232,43249,43263,43263,43302,43309,43335,43347,43392,43395,43443,43456,43493,43493,43561,43574,43587,43587,43596,43597,43643,43645,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43755,43759,43765,43766,44003,44010,44012,44013,64286,64286,65024,65039,65056,65071,65438,65439,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69632,69634,69688,69702,69744,69744,69747,69748,69759,69762,69808,69818,69826,69826,69888,69890,69927,69940,69957,69958,70003,70003,70016,70018,70067,70080,70089,70092,70094,70095,70188,70199,70206,70206,70209,70209,70367,70378,70400,70403,70459,70460,70462,70468,70471,70472,70475,70477,70487,70487,70498,70499,70502,70508,70512,70516,70709,70726,70750,70750,70832,70851,71087,71093,71096,71104,71132,71133,71216,71232,71339,71351,71453,71467,71724,71738,71984,71989,71991,71992,71995,71998,72000,72000,72002,72003,72145,72151,72154,72160,72164,72164,72193,72202,72243,72249,72251,72254,72263,72263,72273,72283,72330,72345,72751,72758,72760,72767,72850,72871,72873,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73098,73102,73104,73105,73107,73111,73459,73462,73472,73473,73475,73475,73524,73530,73534,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94033,94087,94095,94098,94180,94180,94192,94193,113821,113822,118528,118573,118576,118598,119141,119145,119149,119154,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,917536,917631,917760,917999 }); }
	static private void addProperty1096() { addProperty("sb=lf", new int[] { 10,10 }); }
	static private void addProperty1097() { addProperty("sb=sc", new int[] { 44,45,58,58,1373,1373,1548,1549,2040,2040,6146,6146,6152,6152,8211,8212,12289,12289,65040,65041,65043,65043,65073,65074,65104,65105,65109,65109,65112,65112,65123,65123,65292,65293,65306,65306,65380,65380 }); }
	static private void addProperty1098() { addProperty("wb=xx", new int[] { 0,9,14,31,33,33,35,38,40,43,45,45,47,47,60,64,91,94,96,96,123,132,134,169,171,172,174,180,182,182,184,185,187,191,215,215,247,247,728,733,885,885,888,889,896,901,907,907,909,909,930,930,1014,1014,1154,1154,1328,1328,1367,1368,1373,1373,1419,1424,1470,1470,1472,1472,1475,1475,1478,1478,1480,1487,1515,1518,1525,1535,1542,1547,1550,1551,1563,1563,1565,1567,1642,1642,1645,1645,1748,1748,1758,1758,1769,1769,1789,1790,1792,1806,1867,1868,1970,1983,2038,2039,2041,2041,2043,2044,2046,2047,2094,2111,2140,2143,2155,2159,2184,2184,2191,2191,2194,2199,2404,2405,2416,2416,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2546,2555,2557,2557,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2678,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2767,2769,2783,2788,2789,2800,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2928,2928,2930,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3023,3025,3030,3032,3045,3056,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3199,3204,3204,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3407,3411,3416,3422,3428,3429,3440,3449,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3572,3632,3634,3635,3643,3654,3663,3663,3674,3760,3762,3763,3773,3783,3791,3791,3802,3839,3841,3863,3866,3871,3882,3892,3894,3894,3896,3896,3898,3901,3912,3912,3949,3952,3973,3973,3992,3992,4029,4037,4039,4138,4159,4159,4170,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4254,4255,4294,4294,4296,4300,4302,4303,4347,4347,4681,4681,4686,4687,4695,4695,4697,4697,4702,4703,4745,4745,4750,4751,4785,4785,4790,4791,4799,4799,4801,4801,4806,4807,4823,4823,4881,4881,4886,4887,4955,4956,4960,4991,5008,5023,5110,5111,5118,5120,5741,5742,5787,5791,5867,5869,5881,5887,5910,5918,5941,5951,5972,5983,5997,5997,6001,6001,6004,6067,6100,6108,6110,6111,6122,6154,6170,6175,6265,6271,6315,6319,6390,6399,6431,6431,6444,6447,6460,6469,6480,6607,6618,6655,6684,6740,6751,6751,6781,6782,6794,6799,6810,6831,6863,6911,6989,6991,7002,7018,7028,7039,7156,7167,7224,7231,7242,7244,7294,7295,7305,7311,7355,7356,7360,7375,7379,7379,7419,7423,7958,7959,7966,7967,8006,8007,8014,8015,8024,8024,8026,8026,8028,8028,8030,8030,8062,8063,8117,8117,8125,8125,8127,8129,8133,8133,8141,8143,8148,8149,8156,8159,8173,8177,8181,8181,8189,8191,8199,8199,8203,8203,8208,8215,8218,8227,8229,8230,8240,8254,8257,8259,8261,8275,8277,8286,8293,8293,8304,8304,8306,8318,8320,8335,8349,8399,8433,8449,8451,8454,8456,8457,8468,8468,8470,8472,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8506,8507,8512,8516,8522,8525,8527,8543,8585,9397,9450,11263,11493,11498,11508,11519,11558,11558,11560,11564,11566,11567,11624,11630,11632,11646,11671,11679,11687,11687,11695,11695,11703,11703,11711,11711,11719,11719,11727,11727,11735,11735,11743,11743,11776,11822,11824,12287,12289,12292,12294,12329,12336,12336,12342,12346,12349,12440,12445,12447,12539,12539,12544,12548,12592,12592,12687,12703,12736,12783,12800,13007,13055,13055,13144,40959,42125,42191,42238,42239,42509,42511,42540,42559,42611,42611,42622,42622,42738,42759,42955,42959,42962,42962,42964,42964,42970,42993,43048,43051,43053,43071,43124,43135,43206,43215,43226,43231,43256,43258,43260,43260,43310,43311,43348,43359,43389,43391,43457,43470,43482,43492,43494,43503,43514,43519,43575,43583,43598,43599,43610,43642,43646,43695,43697,43697,43701,43702,43705,43709,43712,43712,43714,43743,43760,43761,43767,43776,43783,43784,43791,43792,43799,43807,43815,43815,43823,43823,43882,43887,44011,44011,44014,44015,44026,44031,55204,55215,55239,55242,55292,64255,64263,64274,64280,64284,64297,64297,64311,64311,64317,64317,64319,64319,64322,64322,64325,64325,64434,64466,64830,64847,64912,64913,64968,65007,65020,65023,65041,65042,65045,65055,65072,65074,65077,65100,65105,65105,65107,65107,65110,65135,65141,65141,65277,65278,65280,65286,65288,65291,65293,65293,65295,65295,65308,65312,65339,65342,65344,65344,65371,65381,65471,65473,65480,65481,65488,65489,65496,65497,65501,65528,65532,65535,65548,65548,65575,65575,65595,65595,65598,65598,65614,65615,65630,65663,65787,65855,65909,66044,66046,66175,66205,66207,66257,66271,66273,66303,66336,66348,66379,66383,66427,66431,66462,66463,66500,66503,66512,66512,66518,66559,66718,66719,66730,66735,66772,66775,66812,66815,66856,66863,66916,66927,66939,66939,66955,66955,66963,66963,66966,66966,66978,66978,66994,66994,67002,67002,67005,67071,67383,67391,67414,67423,67432,67455,67462,67462,67505,67505,67515,67583,67590,67591,67593,67593,67638,67638,67641,67643,67645,67646,67670,67679,67703,67711,67743,67807,67827,67827,67830,67839,67862,67871,67898,67967,68024,68029,68032,68095,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68160,68191,68221,68223,68253,68287,68296,68296,68327,68351,68406,68415,68438,68447,68467,68479,68498,68607,68681,68735,68787,68799,68851,68863,68904,68911,68922,69247,69290,69290,69293,69295,69298,69372,69405,69414,69416,69423,69457,69487,69510,69551,69573,69599,69623,69631,69703,69733,69750,69758,69819,69820,69822,69825,69827,69836,69838,69839,69865,69871,69882,69887,69941,69941,69952,69955,69960,69967,70004,70005,70007,70015,70085,70088,70093,70093,70107,70107,70109,70143,70162,70162,70200,70205,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70313,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70479,70481,70486,70488,70492,70500,70501,70509,70511,70517,70655,70731,70735,70746,70749,70754,70783,70854,70854,70856,70863,70874,71039,71094,71095,71105,71127,71134,71167,71233,71235,71237,71247,71258,71295,71353,71359,71370,71452,71468,71471,71482,71679,71739,71839,71914,71934,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72004,72015,72026,72095,72104,72105,72152,72153,72162,72162,72165,72191,72255,72262,72264,72271,72346,72348,72350,72367,72441,72703,72713,72713,72759,72759,72769,72783,72794,72817,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73113,73119,73130,73439,73463,73471,73489,73489,73531,73533,73539,73551,73562,73647,73649,73727,74650,74751,74863,74879,75076,77711,77809,77823,78934,82943,83527,92159,92729,92735,92767,92767,92778,92783,92863,92863,92874,92879,92910,92911,92917,92927,92983,92991,92996,93007,93018,93026,93048,93052,93072,93759,93824,93951,94027,94030,94088,94094,94112,94175,94178,94178,94181,94191,94194,110575,110580,110580,110588,110588,110591,110591,110593,110879,110883,110932,110934,110947,110952,113663,113771,113775,113789,113791,113801,113807,113818,113820,113823,113823,113828,118527,118574,118575,118599,119140,119146,119148,119171,119172,119180,119209,119214,119361,119365,119807,119893,119893,119965,119965,119968,119969,119971,119972,119975,119976,119981,119981,119994,119994,119996,119996,120004,120004,120070,120070,120075,120076,120085,120085,120093,120093,120122,120122,120127,120127,120133,120133,120135,120137,120145,120145,120486,120487,120513,120513,120539,120539,120571,120571,120597,120597,120629,120629,120655,120655,120687,120687,120713,120713,120745,120745,120771,120771,120780,120781,120832,121343,121399,121402,121453,121460,121462,121475,121477,121498,121504,121504,121520,122623,122655,122660,122667,122879,122887,122887,122905,122906,122914,122914,122917,122917,122923,122927,122990,123022,123024,123135,123181,123183,123198,123199,123210,123213,123215,123535,123567,123583,123642,124111,124154,124895,124903,124903,124908,124908,124911,124911,124927,124927,125125,125135,125143,125183,125260,125263,125274,126463,126468,126468,126496,126496,126499,126499,126501,126502,126504,126504,126515,126515,126520,126520,126522,126522,126524,126529,126531,126534,126536,126536,126538,126538,126540,126540,126544,126544,126547,126547,126549,126550,126552,126552,126554,126554,126556,126556,126558,126558,126560,126560,126563,126563,126565,126566,126571,126571,126579,126579,126584,126584,126589,126589,126591,126591,126602,126602,126620,126624,126628,126628,126634,126634,126652,127279,127306,127311,127338,127343,127370,127461,127488,127994,128000,130031,130042,917504,917506,917535,917632,917759,918000,1114111 }); }
	static private void addProperty1099() { addProperty("wb=le", new int[] { 65,90,97,122,170,170,181,181,186,186,192,214,216,246,248,727,734,767,880,884,886,887,890,893,895,895,902,902,904,906,908,908,910,929,931,1013,1015,1153,1162,1327,1329,1366,1369,1372,1374,1374,1376,1416,1418,1418,1523,1523,1568,1610,1646,1647,1649,1747,1749,1749,1765,1766,1774,1775,1786,1788,1791,1791,1808,1808,1810,1839,1869,1957,1969,1969,1994,2026,2036,2037,2042,2042,2048,2069,2074,2074,2084,2084,2088,2088,2112,2136,2144,2154,2160,2183,2185,2190,2208,2249,2308,2361,2365,2365,2384,2384,2392,2401,2417,2432,2437,2444,2447,2448,2451,2472,2474,2480,2482,2482,2486,2489,2493,2493,2510,2510,2524,2525,2527,2529,2544,2545,2556,2556,2565,2570,2575,2576,2579,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2674,2676,2693,2701,2703,2705,2707,2728,2730,2736,2738,2739,2741,2745,2749,2749,2768,2768,2784,2785,2809,2809,2821,2828,2831,2832,2835,2856,2858,2864,2866,2867,2869,2873,2877,2877,2908,2909,2911,2913,2929,2929,2947,2947,2949,2954,2958,2960,2962,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3024,3024,3077,3084,3086,3088,3090,3112,3114,3129,3133,3133,3160,3162,3165,3165,3168,3169,3200,3200,3205,3212,3214,3216,3218,3240,3242,3251,3253,3257,3261,3261,3293,3294,3296,3297,3313,3314,3332,3340,3342,3344,3346,3386,3389,3389,3406,3406,3412,3414,3423,3425,3450,3455,3461,3478,3482,3505,3507,3515,3517,3517,3520,3526,3840,3840,3904,3911,3913,3948,3976,3980,4256,4293,4295,4295,4301,4301,4304,4346,4348,4680,4682,4685,4688,4694,4696,4696,4698,4701,4704,4744,4746,4749,4752,4784,4786,4789,4792,4798,4800,4800,4802,4805,4808,4822,4824,4880,4882,4885,4888,4954,4992,5007,5024,5109,5112,5117,5121,5740,5743,5759,5761,5786,5792,5866,5870,5880,5888,5905,5919,5937,5952,5969,5984,5996,5998,6000,6176,6264,6272,6276,6279,6312,6314,6314,6320,6389,6400,6430,6656,6678,6917,6963,6981,6988,7043,7072,7086,7087,7098,7141,7168,7203,7245,7247,7258,7293,7296,7304,7312,7354,7357,7359,7401,7404,7406,7411,7413,7414,7418,7418,7424,7615,7680,7957,7960,7965,7968,8005,8008,8013,8016,8023,8025,8025,8027,8027,8029,8029,8031,8061,8064,8116,8118,8124,8126,8126,8130,8132,8134,8140,8144,8147,8150,8155,8160,8172,8178,8180,8182,8188,8305,8305,8319,8319,8336,8348,8450,8450,8455,8455,8458,8467,8469,8469,8473,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8505,8508,8511,8517,8521,8526,8526,8544,8584,9398,9449,11264,11492,11499,11502,11506,11507,11520,11557,11559,11559,11565,11565,11568,11623,11631,11631,11648,11670,11680,11686,11688,11694,11696,11702,11704,11710,11712,11718,11720,11726,11728,11734,11736,11742,11823,11823,12293,12293,12347,12348,12549,12591,12593,12686,12704,12735,40960,42124,42192,42237,42240,42508,42512,42527,42538,42539,42560,42606,42623,42653,42656,42735,42760,42954,42960,42961,42963,42963,42965,42969,42994,43009,43011,43013,43015,43018,43020,43042,43072,43123,43138,43187,43250,43255,43259,43259,43261,43262,43274,43301,43312,43334,43360,43388,43396,43442,43471,43471,43520,43560,43584,43586,43588,43595,43744,43754,43762,43764,43777,43782,43785,43790,43793,43798,43808,43814,43816,43822,43824,43881,43888,44002,44032,55203,55216,55238,55243,55291,64256,64262,64275,64279,64336,64433,64467,64829,64848,64911,64914,64967,65008,65019,65136,65140,65142,65276,65313,65338,65345,65370,65440,65470,65474,65479,65482,65487,65490,65495,65498,65500,65536,65547,65549,65574,65576,65594,65596,65597,65599,65613,65616,65629,65664,65786,65856,65908,66176,66204,66208,66256,66304,66335,66349,66378,66384,66421,66432,66461,66464,66499,66504,66511,66513,66517,66560,66717,66736,66771,66776,66811,66816,66855,66864,66915,66928,66938,66940,66954,66956,66962,66964,66965,66967,66977,66979,66993,66995,67001,67003,67004,67072,67382,67392,67413,67424,67431,67456,67461,67463,67504,67506,67514,67584,67589,67592,67592,67594,67637,67639,67640,67644,67644,67647,67669,67680,67702,67712,67742,67808,67826,67828,67829,67840,67861,67872,67897,67968,68023,68030,68031,68096,68096,68112,68115,68117,68119,68121,68149,68192,68220,68224,68252,68288,68295,68297,68324,68352,68405,68416,68437,68448,68466,68480,68497,68608,68680,68736,68786,68800,68850,68864,68899,69248,69289,69296,69297,69376,69404,69415,69415,69424,69445,69488,69505,69552,69572,69600,69622,69635,69687,69745,69746,69749,69749,69763,69807,69840,69864,69891,69926,69956,69956,69959,69959,69968,70002,70006,70006,70019,70066,70081,70084,70106,70106,70108,70108,70144,70161,70163,70187,70207,70208,70272,70278,70280,70280,70282,70285,70287,70301,70303,70312,70320,70366,70405,70412,70415,70416,70419,70440,70442,70448,70450,70451,70453,70457,70461,70461,70480,70480,70493,70497,70656,70708,70727,70730,70751,70753,70784,70831,70852,70853,70855,70855,71040,71086,71128,71131,71168,71215,71236,71236,71296,71338,71352,71352,71680,71723,71840,71903,71935,71942,71945,71945,71948,71955,71957,71958,71960,71983,71999,71999,72001,72001,72096,72103,72106,72144,72161,72161,72163,72163,72192,72192,72203,72242,72250,72250,72272,72272,72284,72329,72349,72349,72368,72440,72704,72712,72714,72750,72768,72768,72818,72847,72960,72966,72968,72969,72971,73008,73030,73030,73056,73061,73063,73064,73066,73097,73112,73112,73440,73458,73474,73474,73476,73488,73490,73523,73648,73648,73728,74649,74752,74862,74880,75075,77712,77808,77824,78895,78913,78918,82944,83526,92160,92728,92736,92766,92784,92862,92880,92909,92928,92975,92992,92995,93027,93047,93053,93071,93760,93823,93952,94026,94032,94032,94099,94111,94176,94177,94179,94179,113664,113770,113776,113788,113792,113800,113808,113817,119808,119892,119894,119964,119966,119967,119970,119970,119973,119974,119977,119980,119982,119993,119995,119995,119997,120003,120005,120069,120071,120074,120077,120084,120086,120092,120094,120121,120123,120126,120128,120132,120134,120134,120138,120144,120146,120485,120488,120512,120514,120538,120540,120570,120572,120596,120598,120628,120630,120654,120656,120686,120688,120712,120714,120744,120746,120770,120772,120779,122624,122654,122661,122666,122928,122989,123136,123180,123191,123197,123214,123214,123536,123565,123584,123627,124112,124139,124896,124902,124904,124907,124909,124910,124912,124926,124928,125124,125184,125251,125259,125259,126464,126467,126469,126495,126497,126498,126500,126500,126503,126503,126505,126514,126516,126519,126521,126521,126523,126523,126530,126530,126535,126535,126537,126537,126539,126539,126541,126543,126545,126546,126548,126548,126551,126551,126553,126553,126555,126555,126557,126557,126559,126559,126561,126562,126564,126564,126567,126570,126572,126578,126580,126583,126585,126588,126590,126590,126592,126601,126603,126619,126625,126627,126629,126633,126635,126651,127280,127305,127312,127337,127344,127369 }); }
	static private void addProperty1100() { addProperty("wb=fo", new int[] { 173,173,1536,1541,1564,1564,1757,1757,1807,1807,2192,2193,2274,2274,6158,6158,8206,8207,8234,8238,8288,8292,8294,8303,65279,65279,65529,65531,69821,69821,69837,69837,78896,78911,113824,113827,119155,119162,917505,917505 }); }
	static private void addProperty1101() { addProperty("wb=ka", new int[] { 12337,12341,12443,12444,12448,12538,12540,12543,12784,12799,13008,13054,13056,13143,65382,65437,110576,110579,110581,110587,110589,110590,110592,110592,110880,110882,110933,110933,110948,110951 }); }
	static private void addProperty1102() { addProperty("wb=ml", new int[] { 58,58,183,183,903,903,1375,1375,1524,1524,8231,8231,65043,65043,65109,65109,65306,65306 }); }
	static private void addProperty1103() { addProperty("wb=mn", new int[] { 44,44,59,59,894,894,1417,1417,1548,1549,1644,1644,2040,2040,8260,8260,65040,65040,65044,65044,65104,65104,65108,65108,65292,65292,65307,65307 }); }
	static private void addProperty1104() { addProperty("wb=nu", new int[] { 48,57,1632,1641,1643,1643,1776,1785,1984,1993,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3881,4160,4169,4240,4249,6112,6121,6160,6169,6470,6479,6608,6617,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,7248,7257,42528,42537,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,65296,65305,66720,66729,68912,68921,69734,69743,69872,69881,69942,69951,70096,70105,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71481,71904,71913,72016,72025,72784,72793,73040,73049,73120,73129,73552,73561,92768,92777,92864,92873,93008,93017,120782,120831,123200,123209,123632,123641,124144,124153,125264,125273,130032,130041 }); }
	static private void addProperty1105() { addProperty("wb=ex", new int[] { 95,95,8239,8239,8255,8256,8276,8276,65075,65076,65101,65103,65343,65343 }); }
	static private void addProperty1106() { addProperty("wb=cr", new int[] { 13,13 }); }
	static private void addProperty1107() { addProperty("wb=extend", new int[] { 768,879,1155,1161,1425,1469,1471,1471,1473,1474,1476,1477,1479,1479,1552,1562,1611,1631,1648,1648,1750,1756,1759,1764,1767,1768,1770,1773,1809,1809,1840,1866,1958,1968,2027,2035,2045,2045,2070,2073,2075,2083,2085,2087,2089,2093,2137,2139,2200,2207,2250,2273,2275,2307,2362,2364,2366,2383,2385,2391,2402,2403,2433,2435,2492,2492,2494,2500,2503,2504,2507,2509,2519,2519,2530,2531,2558,2558,2561,2563,2620,2620,2622,2626,2631,2632,2635,2637,2641,2641,2672,2673,2677,2677,2689,2691,2748,2748,2750,2757,2759,2761,2763,2765,2786,2787,2810,2815,2817,2819,2876,2876,2878,2884,2887,2888,2891,2893,2901,2903,2914,2915,2946,2946,3006,3010,3014,3016,3018,3021,3031,3031,3072,3076,3132,3132,3134,3140,3142,3144,3146,3149,3157,3158,3170,3171,3201,3203,3260,3260,3262,3268,3270,3272,3274,3277,3285,3286,3298,3299,3315,3315,3328,3331,3387,3388,3390,3396,3398,3400,3402,3405,3415,3415,3426,3427,3457,3459,3530,3530,3535,3540,3542,3542,3544,3551,3570,3571,3633,3633,3636,3642,3655,3662,3761,3761,3764,3772,3784,3790,3864,3865,3893,3893,3895,3895,3897,3897,3902,3903,3953,3972,3974,3975,3981,3991,3993,4028,4038,4038,4139,4158,4182,4185,4190,4192,4194,4196,4199,4205,4209,4212,4226,4237,4239,4239,4250,4253,4957,4959,5906,5909,5938,5940,5970,5971,6002,6003,6068,6099,6109,6109,6155,6157,6159,6159,6277,6278,6313,6313,6432,6443,6448,6459,6679,6683,6741,6750,6752,6780,6783,6783,6832,6862,6912,6916,6964,6980,7019,7027,7040,7042,7073,7085,7142,7155,7204,7223,7376,7378,7380,7400,7405,7405,7412,7412,7415,7417,7616,7679,8204,8204,8400,8432,11503,11505,11647,11647,11744,11775,12330,12335,12441,12442,42607,42610,42612,42621,42654,42655,42736,42737,43010,43010,43014,43014,43019,43019,43043,43047,43052,43052,43136,43137,43188,43205,43232,43249,43263,43263,43302,43309,43335,43347,43392,43395,43443,43456,43493,43493,43561,43574,43587,43587,43596,43597,43643,43645,43696,43696,43698,43700,43703,43704,43710,43711,43713,43713,43755,43759,43765,43766,44003,44010,44012,44013,64286,64286,65024,65039,65056,65071,65438,65439,66045,66045,66272,66272,66422,66426,68097,68099,68101,68102,68108,68111,68152,68154,68159,68159,68325,68326,68900,68903,69291,69292,69373,69375,69446,69456,69506,69509,69632,69634,69688,69702,69744,69744,69747,69748,69759,69762,69808,69818,69826,69826,69888,69890,69927,69940,69957,69958,70003,70003,70016,70018,70067,70080,70089,70092,70094,70095,70188,70199,70206,70206,70209,70209,70367,70378,70400,70403,70459,70460,70462,70468,70471,70472,70475,70477,70487,70487,70498,70499,70502,70508,70512,70516,70709,70726,70750,70750,70832,70851,71087,71093,71096,71104,71132,71133,71216,71232,71339,71351,71453,71467,71724,71738,71984,71989,71991,71992,71995,71998,72000,72000,72002,72003,72145,72151,72154,72160,72164,72164,72193,72202,72243,72249,72251,72254,72263,72263,72273,72283,72330,72345,72751,72758,72760,72767,72850,72871,72873,72886,73009,73014,73018,73018,73020,73021,73023,73029,73031,73031,73098,73102,73104,73105,73107,73111,73459,73462,73472,73473,73475,73475,73524,73530,73534,73538,78912,78912,78919,78933,92912,92916,92976,92982,94031,94031,94033,94087,94095,94098,94180,94180,94192,94193,113821,113822,118528,118573,118576,118598,119141,119145,119149,119154,119163,119170,119173,119179,119210,119213,119362,119364,121344,121398,121403,121452,121461,121461,121476,121476,121499,121503,121505,121519,122880,122886,122888,122904,122907,122913,122915,122916,122918,122922,123023,123023,123184,123190,123566,123566,123628,123631,124140,124143,125136,125142,125252,125258,127995,127999,917536,917631,917760,917999 }); }
	static private void addProperty1108() { addProperty("wb=lf", new int[] { 10,10 }); }
	static private void addProperty1109() { addProperty("wb=mb", new int[] { 46,46,8216,8217,8228,8228,65106,65106,65287,65287,65294,65294 }); }
	static private void addProperty1110() { addProperty("wb=nl", new int[] { 11,12,133,133,8232,8233 }); }
	static private void addProperty1111() { addProperty("wb=ri", new int[] { 127462,127487 }); }
	static private void addProperty1112() { addProperty("wb=hl", new int[] { 1488,1514,1519,1522,64285,64285,64287,64296,64298,64310,64312,64316,64318,64318,64320,64321,64323,64324,64326,64335 }); }
	static private void addProperty1113() { addProperty("wb=sq", new int[] { 39,39 }); }
	static private void addProperty1114() { addProperty("wb=dq", new int[] { 34,34 }); }
	static private void addProperty1115() { addProperty("wb=eb", new int[] {  }); }
	static private void addProperty1116() { addProperty("wb=ebg", new int[] {  }); }
	static private void addProperty1117() { addProperty("wb=em", new int[] {  }); }
	static private void addProperty1118() { addProperty("wb=gaz", new int[] {  }); }
	static private void addProperty1119() { addProperty("wb=zwj", new int[] { 8205,8205 }); }
	static private void addProperty1120() { addProperty("wb=wsegspace", new int[] { 32,32,5760,5760,8192,8198,8200,8202,8287,8287,12288,12288 }); }
	static private void addProperty1121() { addProperty("bpt=n", new int[] { 0,39,42,90,92,92,94,122,124,124,126,3897,3902,5786,5789,8260,8263,8316,8319,8332,8335,8967,8972,9000,9003,10087,10102,10180,10183,10213,10224,10626,10649,10711,10716,10747,10750,11809,11818,11860,11869,12295,12306,12307,12316,65112,65119,65287,65290,65338,65340,65340,65342,65370,65372,65372,65374,65374,65377,65377,65380,1114111 }); }
	static private void addProperty1122() { addProperty("bpt=o", new int[] { 40,40,91,91,123,123,3898,3898,3900,3900,5787,5787,8261,8261,8317,8317,8333,8333,8968,8968,8970,8970,9001,9001,10088,10088,10090,10090,10092,10092,10094,10094,10096,10096,10098,10098,10100,10100,10181,10181,10214,10214,10216,10216,10218,10218,10220,10220,10222,10222,10627,10627,10629,10629,10631,10631,10633,10633,10635,10635,10637,10637,10639,10639,10641,10641,10643,10643,10645,10645,10647,10647,10712,10712,10714,10714,10748,10748,11810,11810,11812,11812,11814,11814,11816,11816,11861,11861,11863,11863,11865,11865,11867,11867,12296,12296,12298,12298,12300,12300,12302,12302,12304,12304,12308,12308,12310,12310,12312,12312,12314,12314,65113,65113,65115,65115,65117,65117,65288,65288,65339,65339,65371,65371,65375,65375,65378,65378 }); }
	static private void addProperty1123() { addProperty("bpt=c", new int[] { 41,41,93,93,125,125,3899,3899,3901,3901,5788,5788,8262,8262,8318,8318,8334,8334,8969,8969,8971,8971,9002,9002,10089,10089,10091,10091,10093,10093,10095,10095,10097,10097,10099,10099,10101,10101,10182,10182,10215,10215,10217,10217,10219,10219,10221,10221,10223,10223,10628,10628,10630,10630,10632,10632,10634,10634,10636,10636,10638,10638,10640,10640,10642,10642,10644,10644,10646,10646,10648,10648,10713,10713,10715,10715,10749,10749,11811,11811,11813,11813,11815,11815,11817,11817,11862,11862,11864,11864,11866,11866,11868,11868,12297,12297,12299,12299,12301,12301,12303,12303,12305,12305,12309,12309,12311,12311,12313,12313,12315,12315,65114,65114,65116,65116,65118,65118,65289,65289,65341,65341,65373,65373,65376,65376,65379,65379 }); }
	static private void addProperty1124() { addProperty("inpc=na", new int[] { 0,2303,2308,2361,2365,2365,2384,2384,2387,2388,2392,2401,2404,2432,2436,2491,2493,2493,2501,2502,2505,2506,2510,2518,2520,2529,2532,2557,2559,2560,2564,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2671,2674,2676,2678,2688,2692,2747,2749,2749,2758,2758,2762,2762,2766,2785,2788,2809,2816,2816,2820,2875,2877,2877,2885,2886,2889,2890,2894,2900,2904,2913,2916,2945,2947,3005,3011,3013,3017,3017,3022,3030,3032,3071,3077,3131,3133,3133,3141,3141,3145,3145,3150,3156,3159,3169,3172,3200,3204,3259,3261,3261,3269,3269,3273,3273,3278,3284,3287,3297,3300,3314,3316,3327,3332,3386,3389,3389,3397,3397,3401,3401,3407,3414,3416,3425,3428,3456,3460,3529,3531,3534,3541,3541,3543,3543,3552,3569,3572,3631,3643,3647,3654,3654,3663,3759,3773,3775,3781,3783,3791,3863,3866,3892,3894,3894,3896,3896,3898,3901,3904,3952,3973,3973,3976,3980,3992,3992,4029,4037,4039,4138,4153,4153,4159,4181,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,4240,4249,4254,5905,5910,5937,5941,5969,5972,6001,6004,6069,6098,6098,6100,6108,6110,6431,6444,6447,6460,6575,6593,6599,6602,6678,6684,6740,6751,6752,6781,6782,6784,6911,6917,6963,6981,7018,7028,7039,7043,7072,7083,7083,7086,7141,7156,7203,7224,7375,7379,7379,7401,7404,7406,7411,7413,7414,7416,7674,7676,8431,8433,43009,43011,43013,43015,43018,43020,43042,43048,43051,43053,43135,43138,43187,43206,43231,43250,43262,43264,43301,43310,43334,43348,43391,43396,43442,43457,43492,43494,43560,43575,43586,43588,43595,43598,43642,43646,43695,43712,43712,43714,43754,43760,43764,43766,44002,44011,44011,44014,68096,68100,68100,68103,68107,68112,68151,68155,69631,69635,69687,69703,69743,69745,69746,69749,69759,69763,69807,69819,69825,69827,69887,69891,69926,69939,69939,69941,69956,69959,70002,70004,70015,70019,70066,70081,70081,70084,70088,70093,70093,70096,70187,70200,70205,70207,70208,70210,70366,70379,70399,70404,70458,70461,70461,70469,70470,70473,70474,70478,70486,70488,70497,70500,70501,70509,70511,70517,70708,70727,70749,70751,70831,70852,71086,71094,71095,71105,71131,71134,71215,71233,71338,71352,71452,71468,71723,71739,71983,71990,71990,71993,71994,71998,71998,72004,72144,72152,72153,72161,72163,72165,72192,72203,72242,72255,72272,72284,72323,72345,72750,72759,72759,72768,72849,72872,72872,72887,73008,73015,73017,73019,73019,73022,73022,73029,73029,73032,73097,73103,73103,73106,73106,73111,73458,73463,73471,73476,73523,73531,73533,73538,1114111 }); }
	static private void addProperty1125() { addProperty("inpc=bottom", new int[] { 2364,2364,2369,2372,2381,2381,2386,2386,2390,2391,2402,2403,2492,2492,2497,2500,2509,2509,2530,2531,2620,2620,2625,2626,2637,2637,2641,2641,2677,2677,2748,2748,2753,2756,2765,2765,2786,2787,2876,2876,2881,2884,2893,2893,2914,2915,3132,3132,3158,3158,3170,3171,3260,3260,3298,3299,3395,3396,3426,3427,3540,3540,3542,3542,3640,3642,3768,3770,3772,3772,3864,3865,3893,3893,3895,3895,3953,3953,3956,3957,3972,3972,3981,3991,3993,4028,4038,4038,4143,4144,4151,4151,4157,4158,4184,4185,4190,4192,4226,4226,4237,4237,5907,5908,5939,5939,5971,5971,6003,6003,6075,6077,6434,6434,6450,6450,6457,6457,6459,6459,6680,6680,6742,6742,6747,6750,6761,6762,6764,6764,6783,6783,6968,6970,7020,7020,7074,7075,7077,7077,7084,7085,7212,7212,7223,7223,7381,7385,7388,7391,7405,7405,43045,43045,43052,43052,43204,43204,43307,43309,43335,43337,43339,43342,43448,43449,43453,43453,43565,43565,43570,43570,43573,43574,43700,43700,43756,43756,44008,44008,44013,44013,68098,68099,68108,68110,68153,68154,69692,69697,69811,69812,69817,69818,69826,69826,69930,69931,69937,69938,70003,70003,70070,70075,70089,70090,70092,70092,70191,70191,70209,70209,70371,70372,70377,70378,70459,70460,70712,70717,70722,70722,70726,70726,70835,70840,70850,70851,71090,71093,71103,71104,71132,71133,71219,71224,71231,71231,71344,71345,71351,71351,71453,71453,71460,71461,71464,71464,71727,71730,71737,71738,72003,72003,72148,72151,72160,72160,72194,72195,72202,72202,72243,72244,72251,72254,72274,72275,72281,72283,72330,72341,72754,72758,72767,72767,72850,72871,72874,72880,72882,72882,73014,73014,73026,73026,73028,73028,73031,73031,73460,73460,73528,73530 }); }
	static private void addProperty1126() { addProperty("inpc=bottom_and_left", new int[] { 43455,43455 }); }
	static private void addProperty1127() { addProperty("inpc=bottom_and_right", new int[] { 6971,6971,43454,43454,43456,43456,72002,72002 }); }
	static private void addProperty1128() { addProperty("inpc=left", new int[] { 2367,2367,2382,2382,2495,2495,2503,2504,2623,2623,2751,2751,2887,2887,3014,3016,3398,3400,3545,3545,3547,3547,3903,3903,4145,4145,4228,4228,6081,6083,6681,6681,6741,6741,6766,6770,6974,6975,7078,7078,7207,7208,7220,7221,43450,43451,43567,43568,43572,43572,43755,43755,43758,43758,69809,69809,69932,69932,70068,70068,70094,70094,70369,70369,70471,70472,70710,70710,70833,70833,70841,70841,71088,71088,71096,71096,71342,71342,71462,71462,71725,71725,71989,71989,71991,71991,72146,72146,72164,72164,72881,72881,73461,73461,73534,73535 }); }
	static private void addProperty1129() { addProperty("inpc=left_and_right", new int[] { 2507,2508,2891,2891,3018,3020,3402,3404,3548,3548,3550,3550,6080,6080,6084,6085,6976,6977,70475,70476,70844,70844,70846,70846,71098,71098,71992,71992 }); }
	static private void addProperty1130() { addProperty("inpc=overstruck", new int[] { 7380,7380,7394,7400,68097,68097,68102,68102 }); }
	static private void addProperty1131() { addProperty("inpc=right", new int[] { 2307,2307,2363,2363,2366,2366,2368,2368,2377,2380,2383,2383,2434,2435,2494,2494,2496,2496,2519,2519,2563,2563,2622,2622,2624,2624,2691,2691,2750,2750,2752,2752,2763,2764,2818,2819,2878,2878,2880,2880,3006,3007,3009,3010,3031,3031,3073,3075,3137,3140,3202,3203,3262,3262,3265,3268,3285,3286,3315,3315,3330,3331,3390,3394,3415,3415,3458,3459,3535,3537,3544,3544,3551,3551,3570,3571,3632,3632,3634,3635,3653,3653,3760,3760,3762,3763,3902,3902,3967,3967,4139,4140,4152,4152,4155,4155,4182,4183,4194,4196,4199,4205,4227,4227,4231,4236,4239,4239,4250,4252,5909,5909,5940,5940,6070,6070,6087,6088,6435,6436,6441,6443,6448,6449,6451,6456,6576,6580,6584,6585,6587,6592,6600,6601,6682,6682,6743,6743,6753,6753,6755,6756,6765,6765,6916,6916,6965,6965,6980,6980,7042,7042,7073,7073,7079,7079,7082,7082,7143,7143,7146,7148,7150,7150,7154,7155,7204,7206,7210,7211,7393,7393,7415,7415,43043,43044,43047,43047,43136,43137,43188,43203,43346,43347,43395,43395,43444,43445,43571,43571,43597,43597,43643,43643,43645,43645,43697,43697,43706,43706,43709,43709,43759,43759,43765,43765,44003,44004,44006,44007,44009,44010,44012,44012,69632,69632,69634,69634,69762,69762,69808,69808,69810,69810,69815,69816,69957,69958,70018,70018,70067,70067,70069,70069,70080,70080,70188,70190,70197,70197,70368,70368,70370,70370,70402,70403,70462,70463,70465,70468,70477,70477,70487,70487,70498,70499,70709,70709,70711,70711,70720,70721,70725,70725,70832,70832,70834,70834,70845,70845,70849,70849,71087,71087,71089,71089,71102,71102,71216,71218,71227,71228,71230,71230,71340,71340,71343,71343,71350,71350,71456,71457,71724,71724,71726,71726,71736,71736,71984,71988,71997,71997,72000,72000,72145,72145,72147,72147,72156,72159,72249,72249,72279,72280,72343,72343,72751,72751,72766,72766,72873,72873,72884,72884,73030,73030,73098,73102,73107,73108,73110,73110,73462,73462,73475,73475,73524,73525,73537,73537 }); }
	static private void addProperty1132() { addProperty("inpc=top", new int[] { 2304,2306,2362,2362,2373,2376,2385,2385,2389,2389,2433,2433,2558,2558,2561,2562,2631,2632,2635,2636,2672,2673,2689,2690,2757,2757,2759,2760,2810,2815,2817,2817,2879,2879,2901,2902,2946,2946,3008,3008,3021,3021,3072,3072,3076,3076,3134,3136,3142,3143,3146,3149,3157,3157,3201,3201,3263,3263,3270,3270,3276,3277,3328,3329,3387,3388,3405,3406,3457,3457,3530,3530,3538,3539,3633,3633,3636,3639,3655,3662,3761,3761,3764,3767,3771,3771,3784,3790,3897,3897,3954,3954,3962,3966,3968,3968,3970,3971,3974,3975,4141,4142,4146,4150,4154,4154,4209,4212,4229,4230,4253,4253,5906,5906,5938,5938,5970,5970,6002,6002,6071,6074,6086,6086,6089,6097,6099,6099,6109,6109,6432,6433,6439,6440,6458,6458,6679,6679,6683,6683,6744,6746,6754,6754,6757,6760,6763,6763,6771,6780,6912,6915,6964,6964,6966,6967,6978,6978,7019,7019,7021,7027,7040,7041,7076,7076,7080,7081,7142,7142,7144,7145,7149,7149,7151,7153,7213,7219,7222,7222,7376,7378,7386,7387,7392,7392,7412,7412,7675,7675,8432,8432,43010,43010,43014,43014,43019,43019,43046,43046,43205,43205,43232,43249,43263,43263,43302,43306,43338,43338,43343,43345,43392,43394,43443,43443,43446,43447,43452,43452,43493,43493,43561,43564,43566,43566,43569,43569,43587,43587,43596,43596,43644,43644,43696,43696,43698,43699,43703,43704,43710,43711,43713,43713,43757,43757,44005,44005,68101,68101,68111,68111,68152,68152,69633,69633,69688,69691,69698,69702,69744,69744,69747,69748,69760,69761,69813,69814,69888,69890,69927,69929,69933,69933,69936,69936,69940,69940,70016,70017,70076,70078,70082,70083,70091,70091,70095,70095,70192,70193,70196,70196,70198,70199,70206,70206,70367,70367,70373,70376,70400,70401,70464,70464,70502,70508,70512,70516,70718,70719,70723,70724,70750,70750,70842,70842,70847,70848,71100,71101,71225,71226,71229,71229,71232,71232,71339,71339,71341,71341,71346,71349,71455,71455,71458,71459,71463,71463,71465,71467,71731,71735,71995,71996,71999,71999,72001,72001,72154,72155,72193,72193,72196,72201,72245,72248,72250,72250,72273,72273,72276,72278,72324,72329,72342,72342,72344,72344,72752,72753,72760,72765,72883,72883,72885,72886,73009,73013,73018,73018,73020,73021,73023,73025,73027,73027,73104,73105,73109,73109,73459,73459,73472,73474,73526,73527,73536,73536 }); }
	static private void addProperty1133() { addProperty("inpc=top_and_bottom", new int[] { 3144,3144,3955,3955,3958,3961,3969,3969,6972,6972,69934,69935 }); }
	static private void addProperty1134() { addProperty("inpc=top_and_bottom_and_right", new int[] { 6973,6973 }); }
	static private void addProperty1135() { addProperty("inpc=top_and_left", new int[] { 2888,2888,3546,3546,6078,6078,7209,7209,70843,70843,71097,71097 }); }
	static private void addProperty1136() { addProperty("inpc=top_and_left_and_right", new int[] { 2892,2892,3549,3549,6079,6079,71099,71099 }); }
	static private void addProperty1137() { addProperty("inpc=top_and_right", new int[] { 2761,2761,2903,2903,3264,3264,3271,3272,3274,3275,6437,6438,6979,6979,70079,70079,70194,70195 }); }
	static private void addProperty1138() { addProperty("inpc=visual_order_left", new int[] { 3648,3652,3776,3780,6581,6583,6586,6586,43701,43702,43705,43705,43707,43708 }); }
	static private void addProperty1139() { addProperty("inpc=top_and_bottom_and_left", new int[] { 4156,4156,71454,71454 }); }
	static private void addProperty1140() { addProperty("insc=other", new int[] { 0,44,46,47,58,159,161,177,180,214,216,2303,2384,2384,2387,2388,2404,2405,2416,2417,2436,2436,2445,2446,2449,2450,2473,2473,2481,2481,2483,2485,2490,2491,2501,2502,2505,2506,2511,2518,2520,2523,2526,2526,2532,2533,2546,2555,2557,2557,2559,2560,2564,2564,2571,2574,2577,2578,2601,2601,2609,2609,2612,2612,2615,2615,2618,2619,2621,2621,2627,2630,2633,2634,2638,2640,2642,2648,2653,2653,2655,2661,2676,2676,2678,2688,2692,2692,2702,2702,2706,2706,2729,2729,2737,2737,2740,2740,2746,2747,2758,2758,2762,2762,2766,2783,2788,2789,2800,2808,2816,2816,2820,2820,2829,2830,2833,2834,2857,2857,2865,2865,2868,2868,2874,2875,2885,2886,2889,2890,2894,2900,2904,2907,2910,2910,2916,2917,2928,2928,2930,2945,2948,2948,2955,2957,2961,2961,2966,2968,2971,2971,2973,2973,2976,2978,2981,2983,2987,2989,3002,3005,3011,3013,3017,3017,3022,3030,3032,3045,3056,3071,3085,3085,3089,3089,3113,3113,3130,3131,3141,3141,3145,3145,3150,3156,3159,3159,3163,3164,3166,3167,3172,3173,3184,3199,3204,3204,3213,3213,3217,3217,3241,3241,3252,3252,3258,3259,3269,3269,3273,3273,3278,3284,3287,3292,3295,3295,3300,3301,3312,3312,3316,3327,3341,3341,3345,3345,3397,3397,3401,3401,3407,3411,3416,3422,3428,3429,3440,3449,3456,3456,3460,3460,3479,3481,3506,3506,3516,3516,3518,3519,3527,3529,3531,3534,3541,3541,3543,3543,3552,3557,3568,3569,3572,3584,3631,3631,3643,3647,3654,3654,3663,3663,3674,3712,3715,3715,3717,3717,3723,3723,3748,3748,3750,3750,3759,3759,3774,3775,3781,3783,3788,3788,3791,3791,3802,3803,3808,3871,3892,3892,3894,3894,3896,3896,3898,3903,3912,3912,3949,3952,3974,3975,3992,3992,4029,4037,4039,4095,4170,4170,4172,4173,4175,4175,4254,5887,5910,5918,5941,5951,5972,5983,5997,5997,6001,6001,6004,6015,6068,6069,6100,6107,6110,6111,6122,6399,6431,6431,6444,6447,6460,6469,6510,6511,6517,6527,6572,6575,6602,6607,6619,6655,6684,6687,6751,6751,6781,6782,6794,6799,6810,6911,6989,6991,7002,7039,7156,7167,7224,7231,7242,7244,7248,7375,7379,7379,7394,7409,7419,7674,7676,8203,8206,8207,8213,8307,8309,8321,8325,8431,8433,9675,9677,43007,43048,43051,43053,43071,43124,43135,43206,43215,43226,43231,43252,43261,43310,43311,43348,43391,43457,43471,43482,43487,43494,43494,43519,43519,43575,43583,43598,43599,43610,43615,43632,43632,43639,43641,43715,43743,43760,43764,43767,43967,44011,44011,44014,44015,44026,68095,68100,68100,68103,68107,68116,68116,68120,68120,68150,68151,68155,68158,68169,69631,69703,69713,69750,69758,69819,69825,69827,69887,69941,69941,69952,69955,69960,69967,70004,70015,70084,70088,70093,70093,70106,70112,70133,70143,70162,70162,70200,70205,70210,70271,70279,70279,70281,70281,70286,70286,70302,70302,70313,70319,70379,70383,70394,70399,70404,70404,70413,70414,70417,70418,70441,70441,70449,70449,70452,70452,70458,70458,70469,70470,70473,70474,70478,70486,70488,70493,70500,70501,70509,70511,70517,70655,70728,70735,70746,70749,70754,70784,70853,70863,70874,71039,71094,71095,71105,71127,71134,71167,71233,71247,71258,71295,71353,71359,71370,71423,71451,71452,71468,71471,71484,71487,71495,71679,71739,71935,71943,71944,71946,71947,71956,71956,71959,71959,71990,71990,71993,71994,72004,72015,72026,72095,72104,72105,72152,72153,72162,72163,72165,72191,72256,72260,72262,72262,72264,72271,72346,72348,72350,72703,72713,72713,72759,72759,72769,72783,72813,72817,72848,72849,72872,72872,72887,72959,72967,72967,72970,72970,73015,73017,73019,73019,73022,73022,73032,73039,73050,73055,73062,73062,73065,73065,73103,73103,73106,73106,73112,73119,73130,73439,73463,73471,73489,73489,73531,73533,73539,73551,73562,1114111 }); }
	static private void addProperty1141() { addProperty("insc=avagraha", new int[] { 2365,2365,2493,2493,2749,2749,2877,2877,3133,3133,3261,3261,3389,3389,3973,3973,6108,6108,7098,7098,70081,70081,70461,70461,70727,70727,70852,70852,72161,72161,72349,72349,72768,72768 }); }
	static private void addProperty1142() { addProperty("insc=bindu", new int[] { 2304,2306,2433,2434,2556,2556,2561,2562,2672,2672,2689,2690,2817,2818,2946,2946,3072,3074,3076,3076,3200,3202,3315,3315,3328,3330,3332,3332,3457,3458,3661,3661,3789,3789,3966,3966,3970,3971,4150,4150,6086,6086,6450,6450,6772,6772,6912,6914,7040,7040,7220,7221,43019,43019,43123,43123,43136,43136,43205,43205,43250,43251,43392,43393,68110,68110,69632,69633,69760,69761,69888,69889,70016,70017,70095,70095,70196,70196,70367,70367,70400,70402,70494,70495,70723,70724,70751,70751,70847,70848,71100,71101,71229,71229,71339,71339,71735,71735,71995,71996,72158,72158,72245,72248,72342,72342,72764,72765,72885,72886,73024,73024,73109,73109,73472,73473 }); }
	static private void addProperty1143() { addProperty("insc=brahmi_joining_number", new int[] { 69714,69733 }); }
	static private void addProperty1144() { addProperty("insc=cantillation_mark", new int[] { 2385,2386,2641,2641,2810,2810,2812,2812,7376,7378,7380,7393,7412,7412,7415,7417,8432,8432,43232,43249,70206,70206,70502,70508,70512,70516 }); }
	static private void addProperty1145() { addProperty("insc=consonant", new int[] { 2325,2361,2392,2399,2424,2431,2453,2472,2474,2480,2482,2482,2486,2489,2524,2525,2527,2527,2544,2545,2581,2600,2602,2608,2610,2611,2613,2614,2616,2617,2649,2652,2654,2654,2709,2728,2730,2736,2738,2739,2741,2745,2809,2809,2837,2856,2858,2864,2866,2867,2869,2873,2908,2909,2911,2911,2929,2929,2965,2965,2969,2970,2972,2972,2974,2975,2979,2980,2984,2986,2990,3001,3093,3112,3114,3129,3160,3162,3221,3240,3242,3251,3253,3257,3294,3294,3349,3386,3482,3505,3507,3515,3517,3517,3520,3526,3585,3630,3713,3714,3716,3716,3718,3722,3724,3747,3749,3749,3751,3758,3804,3807,3904,3911,3913,3948,4096,4128,4159,4159,4176,4177,4186,4189,4193,4193,4197,4198,4206,4208,4213,4225,4238,4238,5891,5905,5919,5919,5923,5937,5955,5969,5987,5996,5998,6000,6016,6050,6401,6430,6480,6498,6528,6571,6656,6678,6688,6732,6739,6740,6931,6963,6981,6988,7050,7072,7086,7087,7099,7101,7104,7139,7168,7203,7245,7247,43015,43018,43020,43042,43072,43101,43106,43109,43113,43120,43122,43122,43154,43187,43274,43297,43312,43334,43401,43403,43407,43442,43488,43492,43495,43503,43514,43518,43526,43560,43616,43631,43633,43635,43642,43642,43646,43695,43746,43754,43968,43981,43984,43984,43986,43994,68096,68096,68112,68115,68117,68119,68121,68149,69651,69687,69749,69749,69773,69807,69895,69926,69956,69956,69959,69959,69973,70002,70033,70066,70152,70161,70163,70187,70207,70207,70276,70278,70280,70280,70282,70285,70287,70301,70303,70312,70330,70366,70421,70440,70442,70448,70450,70451,70453,70457,70670,70708,70799,70831,71054,71086,71182,71215,71306,71338,71352,71352,71424,71450,71488,71494,71690,71723,71948,71955,71957,71958,71960,71983,72110,72144,72203,72242,72284,72323,72718,72750,72818,72847,72972,73008,73068,73097,73440,73457,73490,73523 }); }
	static private void addProperty1146() { addProperty("insc=consonant_dead", new int[] { 2510,2510,3165,3165,3293,3293,3412,3414,3450,3455,7410,7411 }); }
	static private void addProperty1147() { addProperty("insc=consonant_final", new int[] { 6448,6449,6451,6457,6593,6599,6744,6745,6915,6915,7041,7041,7102,7103,7152,7153,7213,7219,43343,43346,43394,43394,43584,43597,43995,44002,72330,72341 }); }
	static private void addProperty1148() { addProperty("insc=consonant_head_letter", new int[] { 3976,3980 }); }
	static private void addProperty1149() { addProperty("insc=consonant_initial_postfixed", new int[] { 6746,6746 }); }
	static private void addProperty1150() { addProperty("insc=consonant_killer", new int[] { 3660,3660,6093,6093 }); }
	static private void addProperty1151() { addProperty("insc=consonant_medial", new int[] { 2677,2677,3772,3773,4155,4158,4190,4192,4226,4226,6741,6742,43188,43188,43453,43455,43571,43574,71453,71455,72000,72000,72002,72002,72251,72254,73031,73031 }); }
	static private void addProperty1152() { addProperty("insc=consonant_placeholder", new int[] { 45,45,160,160,215,215,2432,2432,2674,2675,4171,4171,4174,4174,6400,6400,7418,7418,8208,8212,9676,9676,43636,43638,72255,72255,72261,72261,73458,73458 }); }
	static private void addProperty1153() { addProperty("insc=consonant_preceding_repha", new int[] { 3406,3406,72001,72001,73030,73030,73474,73474 }); }
	static private void addProperty1154() { addProperty("insc=consonant_prefixed", new int[] { 70082,70083,71999,71999,72250,72250,72324,72329 }); }
	static private void addProperty1155() { addProperty("insc=consonant_subjoined", new int[] { 3981,3991,3993,4028,6441,6443,6743,6743,6747,6750,7073,7075,7084,7085,7204,7205,43111,43112,43121,43121,72850,72871,72873,72879 }); }
	static private void addProperty1156() { addProperty("insc=consonant_succeeding_repha", new int[] { 6092,6092 }); }
	static private void addProperty1157() { addProperty("insc=consonant_with_stacker", new int[] { 3313,3314,7413,7414,69635,69636,70752,70753 }); }
	static private void addProperty1158() { addProperty("insc=gemination_mark", new int[] { 2673,2673,2811,2811,70199,70199,72344,72344 }); }
	static private void addProperty1159() { addProperty("insc=invisible_stacker", new int[] { 4153,4153,6098,6098,6752,6752,7083,7083,43766,43766,68159,68159,69939,69939,71998,71998,72263,72263,72345,72345,73029,73029,73111,73111,73538,73538 }); }
	static private void addProperty1160() { addProperty("insc=joiner", new int[] { 8205,8205 }); }
	static private void addProperty1161() { addProperty("insc=modifying_letter", new int[] { 2947,2947 }); }
	static private void addProperty1162() { addProperty("insc=non_joiner", new int[] { 8204,8204 }); }
	static private void addProperty1163() { addProperty("insc=nukta", new int[] { 2364,2364,2492,2492,2620,2620,2748,2748,2813,2815,2876,2876,3132,3132,3260,3260,3897,3897,6964,6964,7142,7142,7223,7223,43443,43443,68152,68154,69818,69818,70003,70003,70090,70090,70198,70198,70377,70377,70459,70460,70726,70726,70851,70851,71104,71104,71351,71351,71738,71738,72003,72003,73026,73026 }); }
	static private void addProperty1164() { addProperty("insc=number", new int[] { 48,57,2406,2415,2534,2543,2662,2671,2790,2799,2918,2927,3046,3055,3174,3183,3302,3311,3430,3439,3558,3567,3664,3673,3792,3801,3872,3891,4160,4169,4240,4249,6112,6121,6470,6479,6608,6618,6784,6793,6800,6809,6992,7001,7088,7097,7232,7241,43216,43225,43264,43273,43472,43481,43504,43513,43600,43609,44016,44025,68160,68168,69734,69743,69942,69951,70096,70105,70113,70132,70384,70393,70736,70745,70864,70873,71248,71257,71360,71369,71472,71483,72016,72025,72784,72812,73040,73049,73120,73129,73552,73561 }); }
	static private void addProperty1165() { addProperty("insc=number_joiner", new int[] { 69759,69759 }); }
	static private void addProperty1166() { addProperty("insc=pure_killer", new int[] { 3387,3388,3642,3642,3662,3662,3770,3770,3972,3972,4154,4154,5908,5909,5940,5940,6097,6097,6778,6778,7082,7082,7154,7155,43052,43052,43347,43347,44013,44013,69744,69744,69940,69940,70378,70378,71467,71467,71997,71997,72244,72244,73028,73028,73537,73537 }); }
	static private void addProperty1167() { addProperty("insc=register_shifter", new int[] { 6089,6090 }); }
	static private void addProperty1168() { addProperty("insc=syllable_modifier", new int[] { 178,179,2558,2558,3790,3790,3893,3893,3895,3895,4038,4038,6091,6091,6094,6096,6099,6099,6109,6109,6459,6459,6779,6780,6783,6783,7222,7222,7675,7675,8308,8308,8322,8324,70089,70089,70750,70750,72243,72243 }); }
	static private void addProperty1169() { addProperty("insc=tone_letter", new int[] { 6512,6516,43712,43712,43714,43714 }); }
	static private void addProperty1170() { addProperty("insc=tone_mark", new int[] { 3656,3659,3784,3787,4151,4151,4195,4196,4201,4205,4231,4237,4239,4239,4250,4251,6600,6601,6773,6777,43307,43309,43643,43645,43711,43711,43713,43713,44012,44012 }); }
	static private void addProperty1171() { addProperty("insc=virama", new int[] { 2381,2381,2509,2509,2637,2637,2765,2765,2893,2893,3021,3021,3149,3149,3277,3277,3405,3405,3530,3530,6980,6980,43014,43014,43204,43204,43456,43456,69702,69702,69817,69817,70080,70080,70197,70197,70477,70477,70722,70722,70850,70850,71103,71103,71231,71231,71350,71350,71737,71737,72160,72160,72767,72767 }); }
	static private void addProperty1172() { addProperty("insc=visarga", new int[] { 2307,2307,2435,2435,2563,2563,2691,2691,2819,2819,3075,3075,3203,3203,3331,3331,3459,3459,3967,3967,4152,4152,6087,6087,6916,6916,7042,7042,43137,43137,43395,43395,43765,43765,68111,68111,69634,69634,69762,69762,69890,69890,70018,70018,70403,70403,70725,70725,70849,70849,71102,71102,71230,71230,71340,71340,71736,71736,72159,72159,72249,72249,72343,72343,72766,72766,73025,73025,73110,73110,73475,73475 }); }
	static private void addProperty1173() { addProperty("insc=vowel", new int[] { 6499,6509,43102,43105,43110,43110,43298,43306,69968,69972 }); }
	static private void addProperty1174() { addProperty("insc=vowel_dependent", new int[] { 2362,2363,2366,2380,2382,2383,2389,2391,2402,2403,2494,2500,2503,2504,2507,2508,2519,2519,2530,2531,2622,2626,2631,2632,2635,2636,2750,2757,2759,2761,2763,2764,2786,2787,2878,2884,2887,2888,2891,2892,2901,2903,2914,2915,3006,3010,3014,3016,3018,3020,3031,3031,3134,3140,3142,3144,3146,3148,3157,3158,3170,3171,3262,3268,3270,3272,3274,3276,3285,3286,3298,3299,3390,3396,3398,3400,3402,3404,3415,3415,3426,3427,3535,3540,3542,3542,3544,3551,3570,3571,3632,3641,3648,3653,3655,3655,3760,3769,3771,3771,3776,3780,3953,3965,3968,3969,4139,4149,4182,4185,4194,4194,4199,4200,4209,4212,4227,4230,4252,4253,5906,5907,5938,5939,5970,5971,6002,6003,6070,6085,6088,6088,6432,6440,6458,6458,6576,6592,6679,6683,6753,6771,6965,6979,7076,7081,7143,7151,7206,7212,43010,43010,43043,43047,43189,43203,43263,43263,43335,43342,43444,43452,43493,43493,43561,43570,43696,43710,43755,43759,44003,44010,68097,68099,68101,68102,68108,68109,69688,69701,69747,69748,69808,69816,69826,69826,69927,69938,69957,69958,70067,70079,70091,70092,70094,70094,70188,70195,70209,70209,70368,70376,70462,70468,70471,70472,70475,70476,70487,70487,70498,70499,70709,70721,70832,70846,71087,71093,71096,71099,71132,71133,71216,71228,71232,71232,71341,71349,71456,71466,71724,71734,71984,71989,71991,71992,72145,72151,72154,72157,72164,72164,72193,72202,72273,72283,72751,72758,72760,72763,72880,72884,73009,73014,73018,73018,73020,73021,73023,73023,73027,73027,73098,73102,73104,73105,73107,73108,73459,73462,73524,73530,73534,73536 }); }
	static private void addProperty1175() { addProperty("insc=vowel_independent", new int[] { 2308,2324,2400,2401,2418,2423,2437,2444,2447,2448,2451,2452,2528,2529,2565,2570,2575,2576,2579,2580,2693,2701,2703,2705,2707,2708,2784,2785,2821,2828,2831,2832,2835,2836,2912,2913,2949,2954,2958,2960,2962,2964,3077,3084,3086,3088,3090,3092,3168,3169,3205,3212,3214,3216,3218,3220,3296,3297,3333,3340,3342,3344,3346,3348,3423,3425,3461,3478,4129,4138,4178,4181,5888,5890,5920,5922,5952,5954,5984,5986,6051,6067,6733,6738,6917,6930,7043,7049,7140,7141,43008,43009,43011,43013,43138,43153,43262,43262,43396,43400,43404,43406,43520,43525,43744,43745,43982,43983,43985,43985,69637,69650,69745,69746,69763,69772,69891,69894,70019,70032,70144,70151,70208,70208,70272,70275,70320,70329,70405,70412,70415,70416,70419,70420,70496,70497,70656,70669,70785,70798,71040,71053,71128,71131,71168,71181,71296,71305,71680,71689,71936,71942,71945,71945,72096,72103,72106,72109,72192,72192,72272,72272,72704,72712,72714,72717,72960,72966,72968,72969,72971,72971,73056,73061,73063,73064,73066,73067,73476,73488 }); }
	static private void addProperty1176() { addProperty("vo=r", new int[] { 0,166,168,168,170,173,175,176,178,187,191,214,216,246,248,745,748,4351,4608,5120,5760,6319,6400,8213,8215,8223,8226,8239,8242,8250,8253,8257,8259,8262,8266,8272,8274,8292,8294,8412,8417,8417,8421,8447,8450,8450,8458,8462,8464,8466,8469,8469,8472,8477,8484,8484,8486,8486,8488,8488,8490,8493,8495,8500,8512,8516,8523,8523,8526,8526,8586,8587,8592,8733,8735,8755,8758,8959,8968,8971,8992,8995,9004,9084,9115,9149,9166,9166,9168,9168,9180,9185,9251,9251,9472,9631,9754,9759,10088,10101,10132,11025,11056,11087,11098,11158,11160,11191,11218,11218,11244,11247,11264,11855,11858,11903,42192,43359,43392,44031,55296,57343,64256,65039,65056,65071,65097,65103,65112,65112,65123,65126,65136,65280,65293,65293,65308,65310,65377,65503,65512,65519,65529,65531,65534,67967,68000,71039,71168,72191,72384,77823,78944,82943,83584,94175,101760,110575,111360,118527,118736,118783,119296,119519,119680,120831,121520,126975,129024,129279,129792,131071,196606,196607,262142,983039,1048574,1048575,1114110,1114111 }); }
	static private void addProperty1177() { addProperty("vo=tr", new int[] { 9001,9002,12296,12305,12308,12319,12336,12336,12448,12448,12540,12540,65113,65118,65288,65289,65306,65307,65339,65339,65341,65341,65343,65343,65371,65376,65507,65507 }); }
	static private void addProperty1178() { addProperty("vo=tu", new int[] { 12289,12290,12353,12353,12355,12355,12357,12357,12359,12359,12361,12361,12387,12387,12419,12419,12421,12421,12423,12423,12430,12430,12437,12438,12443,12444,12449,12449,12451,12451,12453,12453,12455,12455,12457,12457,12483,12483,12515,12515,12517,12517,12519,12519,12526,12526,12533,12534,12583,12583,12784,12799,13055,13143,13179,13183,65104,65106,65281,65281,65292,65292,65294,65294,65311,65311,127488,127489 }); }
	static private void addProperty1179() { addProperty("vo=u", new int[] { 167,167,169,169,174,174,177,177,188,190,215,215,247,247,746,747,4352,4607,5121,5759,6320,6399,8214,8214,8224,8225,8240,8241,8251,8252,8258,8258,8263,8265,8273,8273,8293,8293,8413,8416,8418,8420,8448,8449,8451,8457,8463,8463,8467,8468,8470,8471,8478,8483,8485,8485,8487,8487,8489,8489,8494,8494,8501,8511,8517,8522,8524,8525,8527,8585,8588,8591,8734,8734,8756,8757,8960,8967,8972,8991,8996,9000,9003,9003,9085,9114,9150,9165,9167,9167,9169,9179,9186,9250,9252,9471,9632,9753,9760,10087,10102,10131,11026,11055,11088,11097,11159,11159,11192,11217,11219,11243,11248,11263,11856,11857,11904,12288,12291,12295,12306,12307,12320,12335,12337,12352,12354,12354,12356,12356,12358,12358,12360,12360,12362,12386,12388,12418,12420,12420,12422,12422,12424,12429,12431,12436,12439,12442,12445,12447,12450,12450,12452,12452,12454,12454,12456,12456,12458,12482,12484,12514,12516,12516,12518,12518,12520,12525,12527,12532,12535,12539,12541,12582,12584,12783,12800,13054,13144,13178,13184,42191,43360,43391,44032,55295,57344,64255,65040,65055,65072,65096,65107,65111,65119,65122,65127,65135,65282,65287,65290,65291,65295,65305,65312,65338,65340,65340,65342,65342,65344,65370,65504,65506,65508,65511,65520,65528,65532,65533,67968,67999,71040,71167,72192,72383,77824,78943,82944,83583,94176,101759,110576,111359,118528,118735,118784,119295,119520,119679,120832,121519,126976,127487,127490,129023,129280,129791,131072,196605,196608,262141,983040,1048573,1048576,1114109 }); }
	static private void addProperty1180() { addProperty("extended_pictographic", new int[] { 9096,9096,9733,9733,9735,9741,9743,9744,9746,9746,9750,9751,9753,9756,9758,9759,9761,9761,9764,9765,9767,9769,9771,9773,9776,9783,9787,9799,9812,9823,9825,9826,9828,9828,9831,9831,9833,9850,9852,9854,9856,9873,9877,9877,9880,9880,9882,9882,9885,9887,9890,9897,9900,9903,9906,9916,9919,9923,9926,9927,9929,9933,9936,9936,9938,9938,9941,9960,9963,9967,9974,9974,9979,9980,9982,9985,9987,9988,9998,9998,10000,10001,10085,10087,126976,126979,126981,127231,127245,127247,127279,127279,127340,127343,127405,127461,127491,127503,127548,127551,127561,127567,127570,127743,127778,127779,127892,127893,127896,127896,127900,127901,127985,127986,127990,127990,128254,128254,128318,128328,128335,128335,128360,128366,128369,128370,128379,128390,128392,128393,128398,128399,128401,128404,128407,128419,128422,128423,128425,128432,128435,128443,128445,128449,128453,128464,128468,128475,128479,128480,128482,128482,128484,128487,128489,128494,128496,128498,128500,128505,128710,128714,128723,128735,128742,128744,128746,128746,128749,128751,128753,128754,128759,128767,128884,128895,128981,129023,129036,129039,129096,129103,129114,129119,129160,129167,129198,129295,129311,129311,129320,129327,129329,129330,129343,129343,129356,129359,129375,129407,129426,129471,129473,131069 }); }
	static private void addProperty1181() { addProperty("emojirk", new int[] { 35,35,42,42,48,57,169,169,174,174,8482,8482,12336,12336,12349,12349,127462,127487 }); }
	static private void addProperty1182() { addProperty("emojinrk", new int[] { 8252,8252,8265,8265,8505,8505,8596,8601,8617,8618,8986,8987,9000,9000,9167,9167,9193,9203,9208,9210,9410,9410,9642,9643,9654,9654,9664,9664,9723,9726,9728,9732,9742,9742,9745,9745,9748,9749,9752,9752,9757,9757,9760,9760,9762,9763,9766,9766,9770,9770,9774,9775,9784,9786,9792,9792,9794,9794,9800,9811,9823,9824,9827,9827,9829,9830,9832,9832,9851,9851,9854,9855,9874,9879,9881,9881,9883,9884,9888,9889,9895,9895,9898,9899,9904,9905,9917,9918,9924,9925,9928,9928,9934,9935,9937,9937,9939,9940,9961,9962,9968,9973,9975,9978,9981,9981,9986,9986,9989,9989,9992,9997,9999,9999,10002,10002,10004,10004,10006,10006,10013,10013,10017,10017,10024,10024,10035,10036,10052,10052,10055,10055,10060,10060,10062,10062,10067,10069,10071,10071,10083,10084,10133,10135,10145,10145,10160,10160,10175,10175,10548,10549,11013,11015,11035,11036,11088,11088,11093,11093,12951,12951,12953,12953,126980,126980,127183,127183,127344,127345,127358,127359,127374,127374,127377,127386,127489,127490,127514,127514,127535,127535,127538,127546,127568,127569,127744,127777,127780,127891,127894,127895,127897,127899,127902,127984,127987,127989,127991,128253,128255,128317,128329,128334,128336,128359,128367,128368,128371,128378,128391,128391,128394,128397,128400,128400,128405,128406,128420,128421,128424,128424,128433,128434,128444,128444,128450,128452,128465,128467,128476,128478,128481,128481,128483,128483,128488,128488,128495,128495,128499,128499,128506,128591,128640,128709,128715,128722,128725,128727,128732,128741,128745,128745,128747,128748,128752,128752,128755,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty1183() { addProperty("emojipresentation=emojidefault", new int[] { 8986,8987,9193,9196,9200,9200,9203,9203,9725,9726,9748,9749,9800,9811,9855,9855,9875,9875,9889,9889,9898,9899,9917,9918,9924,9925,9934,9934,9940,9940,9962,9962,9970,9971,9973,9973,9978,9978,9981,9981,9989,9989,9994,9995,10024,10024,10060,10060,10062,10062,10067,10069,10071,10071,10133,10135,10160,10160,10175,10175,11035,11036,11088,11088,11093,11093,126980,126980,127183,127183,127374,127374,127377,127386,127462,127487,127489,127489,127514,127514,127535,127535,127538,127542,127544,127546,127568,127569,127744,127776,127789,127797,127799,127868,127870,127891,127904,127946,127951,127955,127968,127984,127988,127988,127992,128062,128064,128064,128066,128252,128255,128317,128331,128334,128336,128359,128378,128378,128405,128406,128420,128420,128507,128591,128640,128709,128716,128716,128720,128722,128725,128727,128732,128735,128747,128748,128756,128764,128992,129003,129008,129008,129292,129338,129340,129349,129351,129535,129648,129660,129664,129672,129680,129725,129727,129733,129742,129755,129760,129768,129776,129784 }); }
	static private void addProperty1184() { addProperty("emojipresentation=textdefault", new int[] { 35,35,42,42,48,57,169,169,174,174,8252,8252,8265,8265,8482,8482,8505,8505,8596,8601,8617,8618,9000,9000,9167,9167,9197,9199,9201,9202,9208,9210,9410,9410,9642,9643,9654,9654,9664,9664,9723,9724,9728,9732,9742,9742,9745,9745,9752,9752,9757,9757,9760,9760,9762,9763,9766,9766,9770,9770,9774,9775,9784,9786,9792,9792,9794,9794,9823,9824,9827,9827,9829,9830,9832,9832,9851,9851,9854,9854,9874,9874,9876,9879,9881,9881,9883,9884,9888,9888,9895,9895,9904,9905,9928,9928,9935,9935,9937,9937,9939,9939,9961,9961,9968,9969,9972,9972,9975,9977,9986,9986,9992,9993,9996,9997,9999,9999,10002,10002,10004,10004,10006,10006,10013,10013,10017,10017,10035,10036,10052,10052,10055,10055,10083,10084,10145,10145,10548,10549,11013,11015,12336,12336,12349,12349,12951,12951,12953,12953,127344,127345,127358,127359,127490,127490,127543,127543,127777,127777,127780,127788,127798,127798,127869,127869,127894,127895,127897,127899,127902,127903,127947,127950,127956,127967,127987,127987,127989,127989,127991,127991,128063,128063,128065,128065,128253,128253,128329,128330,128367,128368,128371,128377,128391,128391,128394,128397,128400,128400,128421,128421,128424,128424,128433,128434,128444,128444,128450,128452,128465,128467,128476,128478,128481,128481,128483,128483,128488,128488,128495,128495,128499,128499,128506,128506,128715,128715,128717,128719,128736,128741,128745,128745,128752,128752,128755,128755 }); }
	static private void addProperty1185() { addProperty("emojipresentation=text", new int[] { 0,34,36,41,43,47,58,168,170,173,175,8251,8253,8264,8266,8481,8483,8504,8506,8595,8602,8616,8619,8985,8988,8999,9001,9166,9168,9192,9204,9207,9211,9409,9411,9641,9644,9653,9655,9663,9665,9722,9727,9727,9733,9741,9743,9744,9746,9747,9750,9751,9753,9756,9758,9759,9761,9761,9764,9765,9767,9769,9771,9773,9776,9783,9787,9791,9793,9793,9795,9799,9812,9822,9825,9826,9828,9828,9831,9831,9833,9850,9852,9853,9856,9873,9880,9880,9882,9882,9885,9887,9890,9894,9896,9897,9900,9903,9906,9916,9919,9923,9926,9927,9929,9933,9936,9936,9938,9938,9941,9960,9963,9967,9974,9974,9979,9980,9982,9985,9987,9988,9990,9991,9998,9998,10000,10001,10003,10003,10005,10005,10007,10012,10014,10016,10018,10023,10025,10034,10037,10051,10053,10054,10056,10059,10061,10061,10063,10066,10070,10070,10072,10082,10085,10132,10136,10144,10146,10159,10161,10174,10176,10547,10550,11012,11016,11034,11037,11087,11089,11092,11094,12335,12337,12348,12350,12950,12952,12952,12954,126979,126981,127182,127184,127343,127346,127357,127360,127373,127375,127376,127387,127461,127488,127488,127491,127513,127515,127534,127536,127537,127547,127567,127570,127743,127778,127779,127892,127893,127896,127896,127900,127901,127985,127986,127990,127990,128254,128254,128318,128328,128335,128335,128360,128366,128369,128370,128379,128390,128392,128393,128398,128399,128401,128404,128407,128419,128422,128423,128425,128432,128435,128443,128445,128449,128453,128464,128468,128475,128479,128480,128482,128482,128484,128487,128489,128494,128496,128498,128500,128505,128592,128639,128710,128714,128723,128724,128728,128731,128742,128744,128746,128746,128749,128751,128753,128754,128765,128991,129004,129007,129009,129291,129339,129339,129350,129350,129536,129647,129661,129663,129673,129679,129726,129726,129734,129741,129756,129759,129769,129775,129785,1114111 }); }

	static private void addPropertyAliases() {
		String[] rawAliases = new String[] { "control","c","cntrl","cc","space_separator","zs","other_punctuation","po","currency_symbol","sc","open_punctuation","ps","close_punctuation","pe","math_symbol","sm","dash_punctuation","pd","decimal_number","nd","digit","nd","uppercase_letter","lu","modifier_symbol","sk","connector_punctuation","pc","lowercase_letter","ll","other_symbol","so","other_letter","lo","initial_punctuation","pi","format","cf","other_number","no","final_punctuation","pf","titlecase_letter","lt","modifier_letter","lm","nonspacing_mark","mn","unassigned","cn","enclosing_mark","me","spacing_mark","mc","letter_number","nl","line_separator","zl","paragraph_separator","zp","surrogate","cs","private_use","co","letter","l","number","n","mark","m","punctuation","p","symbol","s","space","z","alphabetic","alpha","ascii_hex_digit","ahex","bidi_control","bidi_c","bidi_mirrored","bidi_m","dash","dash","default_ignorable_code_point","di","deprecated","dep","diacritic","dia","extender","ext","full_composition_exclusion","comp_ex","grapheme_base","gr_base","grapheme_extend","gr_ext","grapheme_link","gr_link","hex_digit","hex","hyphen","hyphen","id_continue","idc","id_start","ids","ideographic","ideo","ids_binary_operator","idsb","ids_trinary_operator","idst","join_control","join_c","logical_order_exception","loe","lowercase","lower","math","math","noncharacter_code_point","nchar","quotation_mark","qmark","radical","radical","soft_dotted","sd","terminal_punctuation","term","unified_ideograph","uideo","uppercase","upper","white_space","wspace","space","wspace","xid_continue","xidc","xid_start","xids","case_sensitive","sensitive","sentence_terminal","sterm","variation_selector","vs","nfd_inert","nfdinert","nfkd_inert","nfkdinert","nfc_inert","nfcinert","nfkc_inert","nfkcinert","segment_starter","segstart","pattern_syntax","pat_syn","pattern_white_space","pat_ws","alnum","alnum","blank","blank","graph","graph","print","print","xdigit","xdigit","cased","cased","case_ignorable","ci","changes_when_lowercased","cwl","changes_when_uppercased","cwu","changes_when_titlecased","cwt","changes_when_casefolded","cwcf","changes_when_casemapped","cwcm","changes_when_nfkc_casefolded","cwkcf","emoji","emoji","emoji_presentation","epres","emoji_modifier","emod","emoji_modifier_base","ebase","emoji_component","ecomp","regional_indicator","ri","prepended_concatenation_mark","pcm","extended_pictographic","extpict","basic_emoji","basic_emoji","emoji_keycap_sequence","emoji_keycap_sequence","rgi_emoji_modifier_sequence","rgi_emoji_modifier_sequence","rgi_emoji_flag_sequence","rgi_emoji_flag_sequence","rgi_emoji_tag_sequence","rgi_emoji_tag_sequence","rgi_emoji_zwj_sequence","rgi_emoji_zwj_sequence","rgi_emoji","rgi_emoji","zyyy","sc=zyyy","common","sc=zyyy","zinh","sc=zinh","inherited","sc=zinh","qaai","sc=zinh","arab","sc=arab","arabic","sc=arab","armn","sc=armn","armenian","sc=armn","beng","sc=beng","bengali","sc=beng","bopo","sc=bopo","bopomofo","sc=bopo","cher","sc=cher","cherokee","sc=cher","copt","sc=copt","coptic","sc=copt","qaac","sc=copt","cyrl","sc=cyrl","cyrillic","sc=cyrl","dsrt","sc=dsrt","deseret","sc=dsrt","deva","sc=deva","devanagari","sc=deva","ethi","sc=ethi","ethiopic","sc=ethi","geor","sc=geor","georgian","sc=geor","goth","sc=goth","gothic","sc=goth","grek","sc=grek","greek","sc=grek","gujr","sc=gujr","gujarati","sc=gujr","guru","sc=guru","gurmukhi","sc=guru","hani","sc=hani","han","sc=hani","hang","sc=hang","hangul","sc=hang","hebr","sc=hebr","hebrew","sc=hebr","hira","sc=hira","hiragana","sc=hira","knda","sc=knda","kannada","sc=knda","kana","sc=kana","katakana","sc=kana","khmr","sc=khmr","khmer","sc=khmr","laoo","sc=laoo","lao","sc=laoo","latn","sc=latn","latin","sc=latn","mlym","sc=mlym","malayalam","sc=mlym","mong","sc=mong","mongolian","sc=mong","mymr","sc=mymr","myanmar","sc=mymr","ogam","sc=ogam","ogham","sc=ogam","ital","sc=ital","old_italic","sc=ital","orya","sc=orya","oriya","sc=orya","runr","sc=runr","runic","sc=runr","sinh","sc=sinh","sinhala","sc=sinh","syrc","sc=syrc","syriac","sc=syrc","taml","sc=taml","tamil","sc=taml","telu","sc=telu","telugu","sc=telu","thaa","sc=thaa","thaana","sc=thaa","thai","sc=thai","tibt","sc=tibt","tibetan","sc=tibt","cans","sc=cans","canadian_aboriginal","sc=cans","yiii","sc=yiii","yi","sc=yiii","tglg","sc=tglg","tagalog","sc=tglg","hano","sc=hano","hanunoo","sc=hano","buhd","sc=buhd","buhid","sc=buhd","tagb","sc=tagb","tagbanwa","sc=tagb","brai","sc=brai","braille","sc=brai","cprt","sc=cprt","cypriot","sc=cprt","limb","sc=limb","limbu","sc=limb","linb","sc=linb","linear_b","sc=linb","osma","sc=osma","osmanya","sc=osma","shaw","sc=shaw","shavian","sc=shaw","tale","sc=tale","tai_le","sc=tale","ugar","sc=ugar","ugaritic","sc=ugar","hrkt","sc=hrkt","katakana_or_hiragana","sc=hrkt","bugi","sc=bugi","buginese","sc=bugi","glag","sc=glag","glagolitic","sc=glag","khar","sc=khar","kharoshthi","sc=khar","sylo","sc=sylo","syloti_nagri","sc=sylo","talu","sc=talu","new_tai_lue","sc=talu","tfng","sc=tfng","tifinagh","sc=tfng","xpeo","sc=xpeo","old_persian","sc=xpeo","bali","sc=bali","balinese","sc=bali","batk","sc=batk","batak","sc=batk","blis","sc=blis","brah","sc=brah","brahmi","sc=brah","cham","sc=cham","cirt","sc=cirt","cyrs","sc=cyrs","egyd","sc=egyd","egyh","sc=egyh","egyp","sc=egyp","egyptian_hieroglyphs","sc=egyp","geok","sc=geok","hans","sc=hans","hant","sc=hant","hmng","sc=hmng","pahawh_hmong","sc=hmng","hung","sc=hung","old_hungarian","sc=hung","inds","sc=inds","java","sc=java","javanese","sc=java","kali","sc=kali","kayah_li","sc=kali","latf","sc=latf","latg","sc=latg","lepc","sc=lepc","lepcha","sc=lepc","lina","sc=lina","linear_a","sc=lina","mand","sc=mand","mandaic","sc=mand","maya","sc=maya","mero","sc=mero","meroitic_hieroglyphs","sc=mero","nkoo","sc=nkoo","nko","sc=nkoo","orkh","sc=orkh","old_turkic","sc=orkh","perm","sc=perm","old_permic","sc=perm","phag","sc=phag","phags_pa","sc=phag","phnx","sc=phnx","phoenician","sc=phnx","plrd","sc=plrd","miao","sc=plrd","roro","sc=roro","sara","sc=sara","syre","sc=syre","syrj","sc=syrj","syrn","sc=syrn","teng","sc=teng","vaii","sc=vaii","vai","sc=vaii","visp","sc=visp","xsux","sc=xsux","cuneiform","sc=xsux","zxxx","sc=zxxx","zzzz","sc=zzzz","unknown","sc=zzzz","cari","sc=cari","carian","sc=cari","jpan","sc=jpan","lana","sc=lana","tai_tham","sc=lana","lyci","sc=lyci","lycian","sc=lyci","lydi","sc=lydi","lydian","sc=lydi","olck","sc=olck","ol_chiki","sc=olck","rjng","sc=rjng","rejang","sc=rjng","saur","sc=saur","saurashtra","sc=saur","sgnw","sc=sgnw","signwriting","sc=sgnw","sund","sc=sund","sundanese","sc=sund","moon","sc=moon","mtei","sc=mtei","meetei_mayek","sc=mtei","armi","sc=armi","imperial_aramaic","sc=armi","avst","sc=avst","avestan","sc=avst","cakm","sc=cakm","chakma","sc=cakm","kore","sc=kore","kthi","sc=kthi","kaithi","sc=kthi","mani","sc=mani","manichaean","sc=mani","phli","sc=phli","inscriptional_pahlavi","sc=phli","phlp","sc=phlp","psalter_pahlavi","sc=phlp","phlv","sc=phlv","prti","sc=prti","inscriptional_parthian","sc=prti","samr","sc=samr","samaritan","sc=samr","tavt","sc=tavt","tai_viet","sc=tavt","zmth","sc=zmth","zsym","sc=zsym","bamu","sc=bamu","bamum","sc=bamu","lisu","sc=lisu","nkgb","sc=nkgb","sarb","sc=sarb","old_south_arabian","sc=sarb","bass","sc=bass","bassa_vah","sc=bass","dupl","sc=dupl","duployan","sc=dupl","elba","sc=elba","elbasan","sc=elba","gran","sc=gran","grantha","sc=gran","kpel","sc=kpel","loma","sc=loma","mend","sc=mend","mende_kikakui","sc=mend","merc","sc=merc","meroitic_cursive","sc=merc","narb","sc=narb","old_north_arabian","sc=narb","nbat","sc=nbat","nabataean","sc=nbat","palm","sc=palm","palmyrene","sc=palm","sind","sc=sind","khudawadi","sc=sind","wara","sc=wara","warang_citi","sc=wara","afak","sc=afak","jurc","sc=jurc","mroo","sc=mroo","mro","sc=mroo","nshu","sc=nshu","nushu","sc=nshu","shrd","sc=shrd","sharada","sc=shrd","sora","sc=sora","sora_sompeng","sc=sora","takr","sc=takr","takri","sc=takr","tang","sc=tang","tangut","sc=tang","wole","sc=wole","hluw","sc=hluw","anatolian_hieroglyphs","sc=hluw","khoj","sc=khoj","khojki","sc=khoj","tirh","sc=tirh","tirhuta","sc=tirh","aghb","sc=aghb","caucasian_albanian","sc=aghb","mahj","sc=mahj","mahajani","sc=mahj","ahom","sc=ahom","hatr","sc=hatr","hatran","sc=hatr","modi","sc=modi","mult","sc=mult","multani","sc=mult","pauc","sc=pauc","pau_cin_hau","sc=pauc","sidd","sc=sidd","siddham","sc=sidd","adlm","sc=adlm","adlam","sc=adlm","bhks","sc=bhks","bhaiksuki","sc=bhks","marc","sc=marc","marchen","sc=marc","newa","sc=newa","osge","sc=osge","osage","sc=osge","hanb","sc=hanb","jamo","sc=jamo","zsye","sc=zsye","gonm","sc=gonm","masaram_gondi","sc=gonm","soyo","sc=soyo","soyombo","sc=soyo","zanb","sc=zanb","zanabazar_square","sc=zanb","dogr","sc=dogr","dogra","sc=dogr","gong","sc=gong","gunjala_gondi","sc=gong","maka","sc=maka","makasar","sc=maka","medf","sc=medf","medefaidrin","sc=medf","rohg","sc=rohg","hanifi_rohingya","sc=rohg","sogd","sc=sogd","sogdian","sc=sogd","sogo","sc=sogo","old_sogdian","sc=sogo","elym","sc=elym","elymaic","sc=elym","hmnp","sc=hmnp","nyiakeng_puachue_hmong","sc=hmnp","nand","sc=nand","nandinagari","sc=nand","wcho","sc=wcho","wancho","sc=wcho","chrs","sc=chrs","chorasmian","sc=chrs","diak","sc=diak","dives_akuru","sc=diak","kits","sc=kits","khitan_small_script","sc=kits","yezi","sc=yezi","yezidi","sc=yezi","cpmn","sc=cpmn","cypro_minoan","sc=cpmn","ougr","sc=ougr","old_uyghur","sc=ougr","tnsa","sc=tnsa","tangsa","sc=tnsa","toto","sc=toto","vith","sc=vith","vithkuqi","sc=vith","kawi","sc=kawi","nagm","sc=nagm","nag_mundari","sc=nagm","innb","blk=nb","inno_block","blk=nb","inascii","blk=ascii","inbasic_latin","blk=ascii","inlatin_1_sup","blk=latin_1_sup","inlatin_1_supplement","blk=latin_1_sup","inlatin_1","blk=latin_1_sup","inlatin_ext_a","blk=latin_ext_a","inlatin_extended_a","blk=latin_ext_a","inlatin_ext_b","blk=latin_ext_b","inlatin_extended_b","blk=latin_ext_b","inipa_ext","blk=ipa_ext","inipa_extensions","blk=ipa_ext","inmodifier_letters","blk=modifier_letters","inspacing_modifier_letters","blk=modifier_letters","indiacriticals","blk=diacriticals","incombining_diacritical_marks","blk=diacriticals","ingreek","blk=greek","ingreek_and_coptic","blk=greek","incyrillic","blk=cyrillic","inarmenian","blk=armenian","inhebrew","blk=hebrew","inarabic","blk=arabic","insyriac","blk=syriac","inthaana","blk=thaana","indevanagari","blk=devanagari","inbengali","blk=bengali","ingurmukhi","blk=gurmukhi","ingujarati","blk=gujarati","inoriya","blk=oriya","intamil","blk=tamil","intelugu","blk=telugu","inkannada","blk=kannada","inmalayalam","blk=malayalam","insinhala","blk=sinhala","inthai","blk=thai","inlao","blk=lao","intibetan","blk=tibetan","inmyanmar","blk=myanmar","ingeorgian","blk=georgian","injamo","blk=jamo","inhangul_jamo","blk=jamo","inethiopic","blk=ethiopic","incherokee","blk=cherokee","inucas","blk=ucas","inunified_canadian_aboriginal_syllabics","blk=ucas","incanadian_syllabics","blk=ucas","inogham","blk=ogham","inrunic","blk=runic","inkhmer","blk=khmer","inmongolian","blk=mongolian","inlatin_ext_additional","blk=latin_ext_additional","inlatin_extended_additional","blk=latin_ext_additional","ingreek_ext","blk=greek_ext","ingreek_extended","blk=greek_ext","inpunctuation","blk=punctuation","ingeneral_punctuation","blk=punctuation","insuper_and_sub","blk=super_and_sub","insuperscripts_and_subscripts","blk=super_and_sub","incurrency_symbols","blk=currency_symbols","indiacriticals_for_symbols","blk=diacriticals_for_symbols","incombining_diacritical_marks_for_symbols","blk=diacriticals_for_symbols","incombining_marks_for_symbols","blk=diacriticals_for_symbols","inletterlike_symbols","blk=letterlike_symbols","innumber_forms","blk=number_forms","inarrows","blk=arrows","inmath_operators","blk=math_operators","inmathematical_operators","blk=math_operators","inmisc_technical","blk=misc_technical","inmiscellaneous_technical","blk=misc_technical","incontrol_pictures","blk=control_pictures","inocr","blk=ocr","inoptical_character_recognition","blk=ocr","inenclosed_alphanum","blk=enclosed_alphanum","inenclosed_alphanumerics","blk=enclosed_alphanum","inbox_drawing","blk=box_drawing","inblock_elements","blk=block_elements","ingeometric_shapes","blk=geometric_shapes","inmisc_symbols","blk=misc_symbols","inmiscellaneous_symbols","blk=misc_symbols","indingbats","blk=dingbats","inbraille","blk=braille","inbraille_patterns","blk=braille","incjk_radicals_sup","blk=cjk_radicals_sup","incjk_radicals_supplement","blk=cjk_radicals_sup","inkangxi","blk=kangxi","inkangxi_radicals","blk=kangxi","inidc","blk=idc","inideographic_description_characters","blk=idc","incjk_symbols","blk=cjk_symbols","incjk_symbols_and_punctuation","blk=cjk_symbols","inhiragana","blk=hiragana","inkatakana","blk=katakana","inbopomofo","blk=bopomofo","incompat_jamo","blk=compat_jamo","inhangul_compatibility_jamo","blk=compat_jamo","inkanbun","blk=kanbun","inbopomofo_ext","blk=bopomofo_ext","inbopomofo_extended","blk=bopomofo_ext","inenclosed_cjk","blk=enclosed_cjk","inenclosed_cjk_letters_and_months","blk=enclosed_cjk","incjk_compat","blk=cjk_compat","incjk_compatibility","blk=cjk_compat","incjk_ext_a","blk=cjk_ext_a","incjk_unified_ideographs_extension_a","blk=cjk_ext_a","incjk","blk=cjk","incjk_unified_ideographs","blk=cjk","inyi_syllables","blk=yi_syllables","inyi_radicals","blk=yi_radicals","inhangul","blk=hangul","inhangul_syllables","blk=hangul","inhigh_surrogates","blk=high_surrogates","inhigh_pu_surrogates","blk=high_pu_surrogates","inhigh_private_use_surrogates","blk=high_pu_surrogates","inlow_surrogates","blk=low_surrogates","inpua","blk=pua","inprivate_use_area","blk=pua","inprivate_use","blk=pua","incjk_compat_ideographs","blk=cjk_compat_ideographs","incjk_compatibility_ideographs","blk=cjk_compat_ideographs","inalphabetic_pf","blk=alphabetic_pf","inalphabetic_presentation_forms","blk=alphabetic_pf","inarabic_pf_a","blk=arabic_pf_a","inarabic_presentation_forms_a","blk=arabic_pf_a","inarabic_presentation_forms-a","blk=arabic_pf_a","inhalf_marks","blk=half_marks","incombining_half_marks","blk=half_marks","incjk_compat_forms","blk=cjk_compat_forms","incjk_compatibility_forms","blk=cjk_compat_forms","insmall_forms","blk=small_forms","insmall_form_variants","blk=small_forms","inarabic_pf_b","blk=arabic_pf_b","inarabic_presentation_forms_b","blk=arabic_pf_b","inspecials","blk=specials","inhalf_and_full_forms","blk=half_and_full_forms","inhalfwidth_and_fullwidth_forms","blk=half_and_full_forms","inold_italic","blk=old_italic","ingothic","blk=gothic","indeseret","blk=deseret","inbyzantine_music","blk=byzantine_music","inbyzantine_musical_symbols","blk=byzantine_music","inmusic","blk=music","inmusical_symbols","blk=music","inmath_alphanum","blk=math_alphanum","inmathematical_alphanumeric_symbols","blk=math_alphanum","incjk_ext_b","blk=cjk_ext_b","incjk_unified_ideographs_extension_b","blk=cjk_ext_b","incjk_compat_ideographs_sup","blk=cjk_compat_ideographs_sup","incjk_compatibility_ideographs_supplement","blk=cjk_compat_ideographs_sup","intags","blk=tags","incyrillic_sup","blk=cyrillic_sup","incyrillic_supplement","blk=cyrillic_sup","incyrillic_supplementary","blk=cyrillic_sup","intagalog","blk=tagalog","inhanunoo","blk=hanunoo","inbuhid","blk=buhid","intagbanwa","blk=tagbanwa","inmisc_math_symbols_a","blk=misc_math_symbols_a","inmiscellaneous_mathematical_symbols_a","blk=misc_math_symbols_a","insup_arrows_a","blk=sup_arrows_a","insupplemental_arrows_a","blk=sup_arrows_a","insup_arrows_b","blk=sup_arrows_b","insupplemental_arrows_b","blk=sup_arrows_b","inmisc_math_symbols_b","blk=misc_math_symbols_b","inmiscellaneous_mathematical_symbols_b","blk=misc_math_symbols_b","insup_math_operators","blk=sup_math_operators","insupplemental_mathematical_operators","blk=sup_math_operators","inkatakana_ext","blk=katakana_ext","inkatakana_phonetic_extensions","blk=katakana_ext","invs","blk=vs","invariation_selectors","blk=vs","insup_pua_a","blk=sup_pua_a","insupplementary_private_use_area_a","blk=sup_pua_a","insup_pua_b","blk=sup_pua_b","insupplementary_private_use_area_b","blk=sup_pua_b","inlimbu","blk=limbu","intai_le","blk=tai_le","inkhmer_symbols","blk=khmer_symbols","inphonetic_ext","blk=phonetic_ext","inphonetic_extensions","blk=phonetic_ext","inmisc_arrows","blk=misc_arrows","inmiscellaneous_symbols_and_arrows","blk=misc_arrows","inyijing","blk=yijing","inyijing_hexagram_symbols","blk=yijing","inlinear_b_syllabary","blk=linear_b_syllabary","inlinear_b_ideograms","blk=linear_b_ideograms","inaegean_numbers","blk=aegean_numbers","inugaritic","blk=ugaritic","inshavian","blk=shavian","inosmanya","blk=osmanya","incypriot_syllabary","blk=cypriot_syllabary","intai_xuan_jing","blk=tai_xuan_jing","intai_xuan_jing_symbols","blk=tai_xuan_jing","invs_sup","blk=vs_sup","invariation_selectors_supplement","blk=vs_sup","inancient_greek_music","blk=ancient_greek_music","inancient_greek_musical_notation","blk=ancient_greek_music","inancient_greek_numbers","blk=ancient_greek_numbers","inarabic_sup","blk=arabic_sup","inarabic_supplement","blk=arabic_sup","inbuginese","blk=buginese","incjk_strokes","blk=cjk_strokes","indiacriticals_sup","blk=diacriticals_sup","incombining_diacritical_marks_supplement","blk=diacriticals_sup","incoptic","blk=coptic","inethiopic_ext","blk=ethiopic_ext","inethiopic_extended","blk=ethiopic_ext","inethiopic_sup","blk=ethiopic_sup","inethiopic_supplement","blk=ethiopic_sup","ingeorgian_sup","blk=georgian_sup","ingeorgian_supplement","blk=georgian_sup","inglagolitic","blk=glagolitic","inkharoshthi","blk=kharoshthi","inmodifier_tone_letters","blk=modifier_tone_letters","innew_tai_lue","blk=new_tai_lue","inold_persian","blk=old_persian","inphonetic_ext_sup","blk=phonetic_ext_sup","inphonetic_extensions_supplement","blk=phonetic_ext_sup","insup_punctuation","blk=sup_punctuation","insupplemental_punctuation","blk=sup_punctuation","insyloti_nagri","blk=syloti_nagri","intifinagh","blk=tifinagh","invertical_forms","blk=vertical_forms","innko","blk=nko","inbalinese","blk=balinese","inlatin_ext_c","blk=latin_ext_c","inlatin_extended_c","blk=latin_ext_c","inlatin_ext_d","blk=latin_ext_d","inlatin_extended_d","blk=latin_ext_d","inphags_pa","blk=phags_pa","inphoenician","blk=phoenician","incuneiform","blk=cuneiform","incuneiform_numbers","blk=cuneiform_numbers","incuneiform_numbers_and_punctuation","blk=cuneiform_numbers","incounting_rod","blk=counting_rod","incounting_rod_numerals","blk=counting_rod","insundanese","blk=sundanese","inlepcha","blk=lepcha","inol_chiki","blk=ol_chiki","incyrillic_ext_a","blk=cyrillic_ext_a","incyrillic_extended_a","blk=cyrillic_ext_a","invai","blk=vai","incyrillic_ext_b","blk=cyrillic_ext_b","incyrillic_extended_b","blk=cyrillic_ext_b","insaurashtra","blk=saurashtra","inkayah_li","blk=kayah_li","inrejang","blk=rejang","incham","blk=cham","inancient_symbols","blk=ancient_symbols","inphaistos","blk=phaistos","inphaistos_disc","blk=phaistos","inlycian","blk=lycian","incarian","blk=carian","inlydian","blk=lydian","inmahjong","blk=mahjong","inmahjong_tiles","blk=mahjong","indomino","blk=domino","indomino_tiles","blk=domino","insamaritan","blk=samaritan","inucas_ext","blk=ucas_ext","inunified_canadian_aboriginal_syllabics_extended","blk=ucas_ext","intai_tham","blk=tai_tham","invedic_ext","blk=vedic_ext","invedic_extensions","blk=vedic_ext","inlisu","blk=lisu","inbamum","blk=bamum","inindic_number_forms","blk=indic_number_forms","incommon_indic_number_forms","blk=indic_number_forms","indevanagari_ext","blk=devanagari_ext","indevanagari_extended","blk=devanagari_ext","injamo_ext_a","blk=jamo_ext_a","inhangul_jamo_extended_a","blk=jamo_ext_a","injavanese","blk=javanese","inmyanmar_ext_a","blk=myanmar_ext_a","inmyanmar_extended_a","blk=myanmar_ext_a","intai_viet","blk=tai_viet","inmeetei_mayek","blk=meetei_mayek","injamo_ext_b","blk=jamo_ext_b","inhangul_jamo_extended_b","blk=jamo_ext_b","inimperial_aramaic","blk=imperial_aramaic","inold_south_arabian","blk=old_south_arabian","inavestan","blk=avestan","ininscriptional_parthian","blk=inscriptional_parthian","ininscriptional_pahlavi","blk=inscriptional_pahlavi","inold_turkic","blk=old_turkic","inrumi","blk=rumi","inrumi_numeral_symbols","blk=rumi","inkaithi","blk=kaithi","inegyptian_hieroglyphs","blk=egyptian_hieroglyphs","inenclosed_alphanum_sup","blk=enclosed_alphanum_sup","inenclosed_alphanumeric_supplement","blk=enclosed_alphanum_sup","inenclosed_ideographic_sup","blk=enclosed_ideographic_sup","inenclosed_ideographic_supplement","blk=enclosed_ideographic_sup","incjk_ext_c","blk=cjk_ext_c","incjk_unified_ideographs_extension_c","blk=cjk_ext_c","inmandaic","blk=mandaic","inbatak","blk=batak","inethiopic_ext_a","blk=ethiopic_ext_a","inethiopic_extended_a","blk=ethiopic_ext_a","inbrahmi","blk=brahmi","inbamum_sup","blk=bamum_sup","inbamum_supplement","blk=bamum_sup","inkana_sup","blk=kana_sup","inkana_supplement","blk=kana_sup","inplaying_cards","blk=playing_cards","inmisc_pictographs","blk=misc_pictographs","inmiscellaneous_symbols_and_pictographs","blk=misc_pictographs","inemoticons","blk=emoticons","intransport_and_map","blk=transport_and_map","intransport_and_map_symbols","blk=transport_and_map","inalchemical","blk=alchemical","inalchemical_symbols","blk=alchemical","incjk_ext_d","blk=cjk_ext_d","incjk_unified_ideographs_extension_d","blk=cjk_ext_d","inarabic_ext_a","blk=arabic_ext_a","inarabic_extended_a","blk=arabic_ext_a","inarabic_math","blk=arabic_math","inarabic_mathematical_alphabetic_symbols","blk=arabic_math","inchakma","blk=chakma","inmeetei_mayek_ext","blk=meetei_mayek_ext","inmeetei_mayek_extensions","blk=meetei_mayek_ext","inmeroitic_cursive","blk=meroitic_cursive","inmeroitic_hieroglyphs","blk=meroitic_hieroglyphs","inmiao","blk=miao","insharada","blk=sharada","insora_sompeng","blk=sora_sompeng","insundanese_sup","blk=sundanese_sup","insundanese_supplement","blk=sundanese_sup","intakri","blk=takri","inbassa_vah","blk=bassa_vah","incaucasian_albanian","blk=caucasian_albanian","incoptic_epact_numbers","blk=coptic_epact_numbers","indiacriticals_ext","blk=diacriticals_ext","incombining_diacritical_marks_extended","blk=diacriticals_ext","induployan","blk=duployan","inelbasan","blk=elbasan","ingeometric_shapes_ext","blk=geometric_shapes_ext","ingeometric_shapes_extended","blk=geometric_shapes_ext","ingrantha","blk=grantha","inkhojki","blk=khojki","inkhudawadi","blk=khudawadi","inlatin_ext_e","blk=latin_ext_e","inlatin_extended_e","blk=latin_ext_e","inlinear_a","blk=linear_a","inmahajani","blk=mahajani","inmanichaean","blk=manichaean","inmende_kikakui","blk=mende_kikakui","inmodi","blk=modi","inmro","blk=mro","inmyanmar_ext_b","blk=myanmar_ext_b","inmyanmar_extended_b","blk=myanmar_ext_b","innabataean","blk=nabataean","inold_north_arabian","blk=old_north_arabian","inold_permic","blk=old_permic","inornamental_dingbats","blk=ornamental_dingbats","inpahawh_hmong","blk=pahawh_hmong","inpalmyrene","blk=palmyrene","inpau_cin_hau","blk=pau_cin_hau","inpsalter_pahlavi","blk=psalter_pahlavi","inshorthand_format_controls","blk=shorthand_format_controls","insiddham","blk=siddham","insinhala_archaic_numbers","blk=sinhala_archaic_numbers","insup_arrows_c","blk=sup_arrows_c","insupplemental_arrows_c","blk=sup_arrows_c","intirhuta","blk=tirhuta","inwarang_citi","blk=warang_citi","inahom","blk=ahom","inanatolian_hieroglyphs","blk=anatolian_hieroglyphs","incherokee_sup","blk=cherokee_sup","incherokee_supplement","blk=cherokee_sup","incjk_ext_e","blk=cjk_ext_e","incjk_unified_ideographs_extension_e","blk=cjk_ext_e","inearly_dynastic_cuneiform","blk=early_dynastic_cuneiform","inhatran","blk=hatran","inmultani","blk=multani","inold_hungarian","blk=old_hungarian","insup_symbols_and_pictographs","blk=sup_symbols_and_pictographs","insupplemental_symbols_and_pictographs","blk=sup_symbols_and_pictographs","insutton_signwriting","blk=sutton_signwriting","inadlam","blk=adlam","inbhaiksuki","blk=bhaiksuki","incyrillic_ext_c","blk=cyrillic_ext_c","incyrillic_extended_c","blk=cyrillic_ext_c","inglagolitic_sup","blk=glagolitic_sup","inglagolitic_supplement","blk=glagolitic_sup","inideographic_symbols","blk=ideographic_symbols","inideographic_symbols_and_punctuation","blk=ideographic_symbols","inmarchen","blk=marchen","inmongolian_sup","blk=mongolian_sup","inmongolian_supplement","blk=mongolian_sup","innewa","blk=newa","inosage","blk=osage","intangut","blk=tangut","intangut_components","blk=tangut_components","incjk_ext_f","blk=cjk_ext_f","incjk_unified_ideographs_extension_f","blk=cjk_ext_f","inkana_ext_a","blk=kana_ext_a","inkana_extended_a","blk=kana_ext_a","inmasaram_gondi","blk=masaram_gondi","innushu","blk=nushu","insoyombo","blk=soyombo","insyriac_sup","blk=syriac_sup","insyriac_supplement","blk=syriac_sup","inzanabazar_square","blk=zanabazar_square","inchess_symbols","blk=chess_symbols","indogra","blk=dogra","ingeorgian_ext","blk=georgian_ext","ingeorgian_extended","blk=georgian_ext","ingunjala_gondi","blk=gunjala_gondi","inhanifi_rohingya","blk=hanifi_rohingya","inindic_siyaq_numbers","blk=indic_siyaq_numbers","inmakasar","blk=makasar","inmayan_numerals","blk=mayan_numerals","inmedefaidrin","blk=medefaidrin","inold_sogdian","blk=old_sogdian","insogdian","blk=sogdian","inegyptian_hieroglyph_format_controls","blk=egyptian_hieroglyph_format_controls","inelymaic","blk=elymaic","innandinagari","blk=nandinagari","innyiakeng_puachue_hmong","blk=nyiakeng_puachue_hmong","inottoman_siyaq_numbers","blk=ottoman_siyaq_numbers","insmall_kana_ext","blk=small_kana_ext","insmall_kana_extension","blk=small_kana_ext","insymbols_and_pictographs_ext_a","blk=symbols_and_pictographs_ext_a","insymbols_and_pictographs_extended_a","blk=symbols_and_pictographs_ext_a","intamil_sup","blk=tamil_sup","intamil_supplement","blk=tamil_sup","inwancho","blk=wancho","inchorasmian","blk=chorasmian","incjk_ext_g","blk=cjk_ext_g","incjk_unified_ideographs_extension_g","blk=cjk_ext_g","indives_akuru","blk=dives_akuru","inkhitan_small_script","blk=khitan_small_script","inlisu_sup","blk=lisu_sup","inlisu_supplement","blk=lisu_sup","insymbols_for_legacy_computing","blk=symbols_for_legacy_computing","intangut_sup","blk=tangut_sup","intangut_supplement","blk=tangut_sup","inyezidi","blk=yezidi","inarabic_ext_b","blk=arabic_ext_b","inarabic_extended_b","blk=arabic_ext_b","incypro_minoan","blk=cypro_minoan","inethiopic_ext_b","blk=ethiopic_ext_b","inethiopic_extended_b","blk=ethiopic_ext_b","inkana_ext_b","blk=kana_ext_b","inkana_extended_b","blk=kana_ext_b","inlatin_ext_f","blk=latin_ext_f","inlatin_extended_f","blk=latin_ext_f","inlatin_ext_g","blk=latin_ext_g","inlatin_extended_g","blk=latin_ext_g","inold_uyghur","blk=old_uyghur","intangsa","blk=tangsa","intoto","blk=toto","inucas_ext_a","blk=ucas_ext_a","inunified_canadian_aboriginal_syllabics_extended_a","blk=ucas_ext_a","invithkuqi","blk=vithkuqi","inznamenny_music","blk=znamenny_music","inznamenny_musical_notation","blk=znamenny_music","inarabic_ext_c","blk=arabic_ext_c","inarabic_extended_c","blk=arabic_ext_c","incjk_ext_h","blk=cjk_ext_h","incjk_unified_ideographs_extension_h","blk=cjk_ext_h","incyrillic_ext_d","blk=cyrillic_ext_d","incyrillic_extended_d","blk=cyrillic_ext_d","indevanagari_ext_a","blk=devanagari_ext_a","indevanagari_extended_a","blk=devanagari_ext_a","inkaktovik_numerals","blk=kaktovik_numerals","inkawi","blk=kawi","innag_mundari","blk=nag_mundari","bidi_class=l","bc=l","bidi_class=left_to_right","bc=l","bidi_class=r","bc=r","bidi_class=right_to_left","bc=r","bidi_class=en","bc=en","bidi_class=european_number","bc=en","bidi_class=es","bc=es","bidi_class=european_separator","bc=es","bidi_class=et","bc=et","bidi_class=european_terminator","bc=et","bidi_class=an","bc=an","bidi_class=arabic_number","bc=an","bidi_class=cs","bc=cs","bidi_class=common_separator","bc=cs","bidi_class=b","bc=b","bidi_class=paragraph_separator","bc=b","bidi_class=s","bc=s","bidi_class=segment_separator","bc=s","bidi_class=ws","bc=ws","bidi_class=white_space","bc=ws","bidi_class=on","bc=on","bidi_class=other_neutral","bc=on","bidi_class=lre","bc=lre","bidi_class=left_to_right_embedding","bc=lre","bidi_class=lro","bc=lro","bidi_class=left_to_right_override","bc=lro","bidi_class=al","bc=al","bidi_class=arabic_letter","bc=al","bidi_class=rle","bc=rle","bidi_class=right_to_left_embedding","bc=rle","bidi_class=rlo","bc=rlo","bidi_class=right_to_left_override","bc=rlo","bidi_class=pdf","bc=pdf","bidi_class=pop_directional_format","bc=pdf","bidi_class=nsm","bc=nsm","bidi_class=nonspacing_mark","bc=nsm","bidi_class=bn","bc=bn","bidi_class=boundary_neutral","bc=bn","bidi_class=fsi","bc=fsi","bidi_class=first_strong_isolate","bc=fsi","bidi_class=lri","bc=lri","bidi_class=left_to_right_isolate","bc=lri","bidi_class=rli","bc=rli","bidi_class=right_to_left_isolate","bc=rli","bidi_class=pdi","bc=pdi","bidi_class=pop_directional_isolate","bc=pdi","block=nb","blk=nb","block=no_block","blk=nb","block=ascii","blk=ascii","block=basic_latin","blk=ascii","block=latin_1_sup","blk=latin_1_sup","block=latin_1_supplement","blk=latin_1_sup","block=latin_1","blk=latin_1_sup","block=latin_ext_a","blk=latin_ext_a","block=latin_extended_a","blk=latin_ext_a","block=latin_ext_b","blk=latin_ext_b","block=latin_extended_b","blk=latin_ext_b","block=ipa_ext","blk=ipa_ext","block=ipa_extensions","blk=ipa_ext","block=modifier_letters","blk=modifier_letters","block=spacing_modifier_letters","blk=modifier_letters","block=diacriticals","blk=diacriticals","block=combining_diacritical_marks","blk=diacriticals","block=greek","blk=greek","block=greek_and_coptic","blk=greek","block=cyrillic","blk=cyrillic","block=armenian","blk=armenian","block=hebrew","blk=hebrew","block=arabic","blk=arabic","block=syriac","blk=syriac","block=thaana","blk=thaana","block=devanagari","blk=devanagari","block=bengali","blk=bengali","block=gurmukhi","blk=gurmukhi","block=gujarati","blk=gujarati","block=oriya","blk=oriya","block=tamil","blk=tamil","block=telugu","blk=telugu","block=kannada","blk=kannada","block=malayalam","blk=malayalam","block=sinhala","blk=sinhala","block=thai","blk=thai","block=lao","blk=lao","block=tibetan","blk=tibetan","block=myanmar","blk=myanmar","block=georgian","blk=georgian","block=jamo","blk=jamo","block=hangul_jamo","blk=jamo","block=ethiopic","blk=ethiopic","block=cherokee","blk=cherokee","block=ucas","blk=ucas","block=unified_canadian_aboriginal_syllabics","blk=ucas","block=canadian_syllabics","blk=ucas","block=ogham","blk=ogham","block=runic","blk=runic","block=khmer","blk=khmer","block=mongolian","blk=mongolian","block=latin_ext_additional","blk=latin_ext_additional","block=latin_extended_additional","blk=latin_ext_additional","block=greek_ext","blk=greek_ext","block=greek_extended","blk=greek_ext","block=punctuation","blk=punctuation","block=general_punctuation","blk=punctuation","block=super_and_sub","blk=super_and_sub","block=superscripts_and_subscripts","blk=super_and_sub","block=currency_symbols","blk=currency_symbols","block=diacriticals_for_symbols","blk=diacriticals_for_symbols","block=combining_diacritical_marks_for_symbols","blk=diacriticals_for_symbols","block=combining_marks_for_symbols","blk=diacriticals_for_symbols","block=letterlike_symbols","blk=letterlike_symbols","block=number_forms","blk=number_forms","block=arrows","blk=arrows","block=math_operators","blk=math_operators","block=mathematical_operators","blk=math_operators","block=misc_technical","blk=misc_technical","block=miscellaneous_technical","blk=misc_technical","block=control_pictures","blk=control_pictures","block=ocr","blk=ocr","block=optical_character_recognition","blk=ocr","block=enclosed_alphanum","blk=enclosed_alphanum","block=enclosed_alphanumerics","blk=enclosed_alphanum","block=box_drawing","blk=box_drawing","block=block_elements","blk=block_elements","block=geometric_shapes","blk=geometric_shapes","block=misc_symbols","blk=misc_symbols","block=miscellaneous_symbols","blk=misc_symbols","block=dingbats","blk=dingbats","block=braille","blk=braille","block=braille_patterns","blk=braille","block=cjk_radicals_sup","blk=cjk_radicals_sup","block=cjk_radicals_supplement","blk=cjk_radicals_sup","block=kangxi","blk=kangxi","block=kangxi_radicals","blk=kangxi","block=idc","blk=idc","block=ideographic_description_characters","blk=idc","block=cjk_symbols","blk=cjk_symbols","block=cjk_symbols_and_punctuation","blk=cjk_symbols","block=hiragana","blk=hiragana","block=katakana","blk=katakana","block=bopomofo","blk=bopomofo","block=compat_jamo","blk=compat_jamo","block=hangul_compatibility_jamo","blk=compat_jamo","block=kanbun","blk=kanbun","block=bopomofo_ext","blk=bopomofo_ext","block=bopomofo_extended","blk=bopomofo_ext","block=enclosed_cjk","blk=enclosed_cjk","block=enclosed_cjk_letters_and_months","blk=enclosed_cjk","block=cjk_compat","blk=cjk_compat","block=cjk_compatibility","blk=cjk_compat","block=cjk_ext_a","blk=cjk_ext_a","block=cjk_unified_ideographs_extension_a","blk=cjk_ext_a","block=cjk","blk=cjk","block=cjk_unified_ideographs","blk=cjk","block=yi_syllables","blk=yi_syllables","block=yi_radicals","blk=yi_radicals","block=hangul","blk=hangul","block=hangul_syllables","blk=hangul","block=high_surrogates","blk=high_surrogates","block=high_pu_surrogates","blk=high_pu_surrogates","block=high_private_use_surrogates","blk=high_pu_surrogates","block=low_surrogates","blk=low_surrogates","block=pua","blk=pua","block=private_use_area","blk=pua","block=private_use","blk=pua","block=cjk_compat_ideographs","blk=cjk_compat_ideographs","block=cjk_compatibility_ideographs","blk=cjk_compat_ideographs","block=alphabetic_pf","blk=alphabetic_pf","block=alphabetic_presentation_forms","blk=alphabetic_pf","block=arabic_pf_a","blk=arabic_pf_a","block=arabic_presentation_forms_a","blk=arabic_pf_a","block=arabic_presentation_forms-a","blk=arabic_pf_a","block=half_marks","blk=half_marks","block=combining_half_marks","blk=half_marks","block=cjk_compat_forms","blk=cjk_compat_forms","block=cjk_compatibility_forms","blk=cjk_compat_forms","block=small_forms","blk=small_forms","block=small_form_variants","blk=small_forms","block=arabic_pf_b","blk=arabic_pf_b","block=arabic_presentation_forms_b","blk=arabic_pf_b","block=specials","blk=specials","block=half_and_full_forms","blk=half_and_full_forms","block=halfwidth_and_fullwidth_forms","blk=half_and_full_forms","block=old_italic","blk=old_italic","block=gothic","blk=gothic","block=deseret","blk=deseret","block=byzantine_music","blk=byzantine_music","block=byzantine_musical_symbols","blk=byzantine_music","block=music","blk=music","block=musical_symbols","blk=music","block=math_alphanum","blk=math_alphanum","block=mathematical_alphanumeric_symbols","blk=math_alphanum","block=cjk_ext_b","blk=cjk_ext_b","block=cjk_unified_ideographs_extension_b","blk=cjk_ext_b","block=cjk_compat_ideographs_sup","blk=cjk_compat_ideographs_sup","block=cjk_compatibility_ideographs_supplement","blk=cjk_compat_ideographs_sup","block=tags","blk=tags","block=cyrillic_sup","blk=cyrillic_sup","block=cyrillic_supplement","blk=cyrillic_sup","block=cyrillic_supplementary","blk=cyrillic_sup","block=tagalog","blk=tagalog","block=hanunoo","blk=hanunoo","block=buhid","blk=buhid","block=tagbanwa","blk=tagbanwa","block=misc_math_symbols_a","blk=misc_math_symbols_a","block=miscellaneous_mathematical_symbols_a","blk=misc_math_symbols_a","block=sup_arrows_a","blk=sup_arrows_a","block=supplemental_arrows_a","blk=sup_arrows_a","block=sup_arrows_b","blk=sup_arrows_b","block=supplemental_arrows_b","blk=sup_arrows_b","block=misc_math_symbols_b","blk=misc_math_symbols_b","block=miscellaneous_mathematical_symbols_b","blk=misc_math_symbols_b","block=sup_math_operators","blk=sup_math_operators","block=supplemental_mathematical_operators","blk=sup_math_operators","block=katakana_ext","blk=katakana_ext","block=katakana_phonetic_extensions","blk=katakana_ext","block=vs","blk=vs","block=variation_selectors","blk=vs","block=sup_pua_a","blk=sup_pua_a","block=supplementary_private_use_area_a","blk=sup_pua_a","block=sup_pua_b","blk=sup_pua_b","block=supplementary_private_use_area_b","blk=sup_pua_b","block=limbu","blk=limbu","block=tai_le","blk=tai_le","block=khmer_symbols","blk=khmer_symbols","block=phonetic_ext","blk=phonetic_ext","block=phonetic_extensions","blk=phonetic_ext","block=misc_arrows","blk=misc_arrows","block=miscellaneous_symbols_and_arrows","blk=misc_arrows","block=yijing","blk=yijing","block=yijing_hexagram_symbols","blk=yijing","block=linear_b_syllabary","blk=linear_b_syllabary","block=linear_b_ideograms","blk=linear_b_ideograms","block=aegean_numbers","blk=aegean_numbers","block=ugaritic","blk=ugaritic","block=shavian","blk=shavian","block=osmanya","blk=osmanya","block=cypriot_syllabary","blk=cypriot_syllabary","block=tai_xuan_jing","blk=tai_xuan_jing","block=tai_xuan_jing_symbols","blk=tai_xuan_jing","block=vs_sup","blk=vs_sup","block=variation_selectors_supplement","blk=vs_sup","block=ancient_greek_music","blk=ancient_greek_music","block=ancient_greek_musical_notation","blk=ancient_greek_music","block=ancient_greek_numbers","blk=ancient_greek_numbers","block=arabic_sup","blk=arabic_sup","block=arabic_supplement","blk=arabic_sup","block=buginese","blk=buginese","block=cjk_strokes","blk=cjk_strokes","block=diacriticals_sup","blk=diacriticals_sup","block=combining_diacritical_marks_supplement","blk=diacriticals_sup","block=coptic","blk=coptic","block=ethiopic_ext","blk=ethiopic_ext","block=ethiopic_extended","blk=ethiopic_ext","block=ethiopic_sup","blk=ethiopic_sup","block=ethiopic_supplement","blk=ethiopic_sup","block=georgian_sup","blk=georgian_sup","block=georgian_supplement","blk=georgian_sup","block=glagolitic","blk=glagolitic","block=kharoshthi","blk=kharoshthi","block=modifier_tone_letters","blk=modifier_tone_letters","block=new_tai_lue","blk=new_tai_lue","block=old_persian","blk=old_persian","block=phonetic_ext_sup","blk=phonetic_ext_sup","block=phonetic_extensions_supplement","blk=phonetic_ext_sup","block=sup_punctuation","blk=sup_punctuation","block=supplemental_punctuation","blk=sup_punctuation","block=syloti_nagri","blk=syloti_nagri","block=tifinagh","blk=tifinagh","block=vertical_forms","blk=vertical_forms","block=nko","blk=nko","block=balinese","blk=balinese","block=latin_ext_c","blk=latin_ext_c","block=latin_extended_c","blk=latin_ext_c","block=latin_ext_d","blk=latin_ext_d","block=latin_extended_d","blk=latin_ext_d","block=phags_pa","blk=phags_pa","block=phoenician","blk=phoenician","block=cuneiform","blk=cuneiform","block=cuneiform_numbers","blk=cuneiform_numbers","block=cuneiform_numbers_and_punctuation","blk=cuneiform_numbers","block=counting_rod","blk=counting_rod","block=counting_rod_numerals","blk=counting_rod","block=sundanese","blk=sundanese","block=lepcha","blk=lepcha","block=ol_chiki","blk=ol_chiki","block=cyrillic_ext_a","blk=cyrillic_ext_a","block=cyrillic_extended_a","blk=cyrillic_ext_a","block=vai","blk=vai","block=cyrillic_ext_b","blk=cyrillic_ext_b","block=cyrillic_extended_b","blk=cyrillic_ext_b","block=saurashtra","blk=saurashtra","block=kayah_li","blk=kayah_li","block=rejang","blk=rejang","block=cham","blk=cham","block=ancient_symbols","blk=ancient_symbols","block=phaistos","blk=phaistos","block=phaistos_disc","blk=phaistos","block=lycian","blk=lycian","block=carian","blk=carian","block=lydian","blk=lydian","block=mahjong","blk=mahjong","block=mahjong_tiles","blk=mahjong","block=domino","blk=domino","block=domino_tiles","blk=domino","block=samaritan","blk=samaritan","block=ucas_ext","blk=ucas_ext","block=unified_canadian_aboriginal_syllabics_extended","blk=ucas_ext","block=tai_tham","blk=tai_tham","block=vedic_ext","blk=vedic_ext","block=vedic_extensions","blk=vedic_ext","block=lisu","blk=lisu","block=bamum","blk=bamum","block=indic_number_forms","blk=indic_number_forms","block=common_indic_number_forms","blk=indic_number_forms","block=devanagari_ext","blk=devanagari_ext","block=devanagari_extended","blk=devanagari_ext","block=jamo_ext_a","blk=jamo_ext_a","block=hangul_jamo_extended_a","blk=jamo_ext_a","block=javanese","blk=javanese","block=myanmar_ext_a","blk=myanmar_ext_a","block=myanmar_extended_a","blk=myanmar_ext_a","block=tai_viet","blk=tai_viet","block=meetei_mayek","blk=meetei_mayek","block=jamo_ext_b","blk=jamo_ext_b","block=hangul_jamo_extended_b","blk=jamo_ext_b","block=imperial_aramaic","blk=imperial_aramaic","block=old_south_arabian","blk=old_south_arabian","block=avestan","blk=avestan","block=inscriptional_parthian","blk=inscriptional_parthian","block=inscriptional_pahlavi","blk=inscriptional_pahlavi","block=old_turkic","blk=old_turkic","block=rumi","blk=rumi","block=rumi_numeral_symbols","blk=rumi","block=kaithi","blk=kaithi","block=egyptian_hieroglyphs","blk=egyptian_hieroglyphs","block=enclosed_alphanum_sup","blk=enclosed_alphanum_sup","block=enclosed_alphanumeric_supplement","blk=enclosed_alphanum_sup","block=enclosed_ideographic_sup","blk=enclosed_ideographic_sup","block=enclosed_ideographic_supplement","blk=enclosed_ideographic_sup","block=cjk_ext_c","blk=cjk_ext_c","block=cjk_unified_ideographs_extension_c","blk=cjk_ext_c","block=mandaic","blk=mandaic","block=batak","blk=batak","block=ethiopic_ext_a","blk=ethiopic_ext_a","block=ethiopic_extended_a","blk=ethiopic_ext_a","block=brahmi","blk=brahmi","block=bamum_sup","blk=bamum_sup","block=bamum_supplement","blk=bamum_sup","block=kana_sup","blk=kana_sup","block=kana_supplement","blk=kana_sup","block=playing_cards","blk=playing_cards","block=misc_pictographs","blk=misc_pictographs","block=miscellaneous_symbols_and_pictographs","blk=misc_pictographs","block=emoticons","blk=emoticons","block=transport_and_map","blk=transport_and_map","block=transport_and_map_symbols","blk=transport_and_map","block=alchemical","blk=alchemical","block=alchemical_symbols","blk=alchemical","block=cjk_ext_d","blk=cjk_ext_d","block=cjk_unified_ideographs_extension_d","blk=cjk_ext_d","block=arabic_ext_a","blk=arabic_ext_a","block=arabic_extended_a","blk=arabic_ext_a","block=arabic_math","blk=arabic_math","block=arabic_mathematical_alphabetic_symbols","blk=arabic_math","block=chakma","blk=chakma","block=meetei_mayek_ext","blk=meetei_mayek_ext","block=meetei_mayek_extensions","blk=meetei_mayek_ext","block=meroitic_cursive","blk=meroitic_cursive","block=meroitic_hieroglyphs","blk=meroitic_hieroglyphs","block=miao","blk=miao","block=sharada","blk=sharada","block=sora_sompeng","blk=sora_sompeng","block=sundanese_sup","blk=sundanese_sup","block=sundanese_supplement","blk=sundanese_sup","block=takri","blk=takri","block=bassa_vah","blk=bassa_vah","block=caucasian_albanian","blk=caucasian_albanian","block=coptic_epact_numbers","blk=coptic_epact_numbers","block=diacriticals_ext","blk=diacriticals_ext","block=combining_diacritical_marks_extended","blk=diacriticals_ext","block=duployan","blk=duployan","block=elbasan","blk=elbasan","block=geometric_shapes_ext","blk=geometric_shapes_ext","block=geometric_shapes_extended","blk=geometric_shapes_ext","block=grantha","blk=grantha","block=khojki","blk=khojki","block=khudawadi","blk=khudawadi","block=latin_ext_e","blk=latin_ext_e","block=latin_extended_e","blk=latin_ext_e","block=linear_a","blk=linear_a","block=mahajani","blk=mahajani","block=manichaean","blk=manichaean","block=mende_kikakui","blk=mende_kikakui","block=modi","blk=modi","block=mro","blk=mro","block=myanmar_ext_b","blk=myanmar_ext_b","block=myanmar_extended_b","blk=myanmar_ext_b","block=nabataean","blk=nabataean","block=old_north_arabian","blk=old_north_arabian","block=old_permic","blk=old_permic","block=ornamental_dingbats","blk=ornamental_dingbats","block=pahawh_hmong","blk=pahawh_hmong","block=palmyrene","blk=palmyrene","block=pau_cin_hau","blk=pau_cin_hau","block=psalter_pahlavi","blk=psalter_pahlavi","block=shorthand_format_controls","blk=shorthand_format_controls","block=siddham","blk=siddham","block=sinhala_archaic_numbers","blk=sinhala_archaic_numbers","block=sup_arrows_c","blk=sup_arrows_c","block=supplemental_arrows_c","blk=sup_arrows_c","block=tirhuta","blk=tirhuta","block=warang_citi","blk=warang_citi","block=ahom","blk=ahom","block=anatolian_hieroglyphs","blk=anatolian_hieroglyphs","block=cherokee_sup","blk=cherokee_sup","block=cherokee_supplement","blk=cherokee_sup","block=cjk_ext_e","blk=cjk_ext_e","block=cjk_unified_ideographs_extension_e","blk=cjk_ext_e","block=early_dynastic_cuneiform","blk=early_dynastic_cuneiform","block=hatran","blk=hatran","block=multani","blk=multani","block=old_hungarian","blk=old_hungarian","block=sup_symbols_and_pictographs","blk=sup_symbols_and_pictographs","block=supplemental_symbols_and_pictographs","blk=sup_symbols_and_pictographs","block=sutton_signwriting","blk=sutton_signwriting","block=adlam","blk=adlam","block=bhaiksuki","blk=bhaiksuki","block=cyrillic_ext_c","blk=cyrillic_ext_c","block=cyrillic_extended_c","blk=cyrillic_ext_c","block=glagolitic_sup","blk=glagolitic_sup","block=glagolitic_supplement","blk=glagolitic_sup","block=ideographic_symbols","blk=ideographic_symbols","block=ideographic_symbols_and_punctuation","blk=ideographic_symbols","block=marchen","blk=marchen","block=mongolian_sup","blk=mongolian_sup","block=mongolian_supplement","blk=mongolian_sup","block=newa","blk=newa","block=osage","blk=osage","block=tangut","blk=tangut","block=tangut_components","blk=tangut_components","block=cjk_ext_f","blk=cjk_ext_f","block=cjk_unified_ideographs_extension_f","blk=cjk_ext_f","block=kana_ext_a","blk=kana_ext_a","block=kana_extended_a","blk=kana_ext_a","block=masaram_gondi","blk=masaram_gondi","block=nushu","blk=nushu","block=soyombo","blk=soyombo","block=syriac_sup","blk=syriac_sup","block=syriac_supplement","blk=syriac_sup","block=zanabazar_square","blk=zanabazar_square","block=chess_symbols","blk=chess_symbols","block=dogra","blk=dogra","block=georgian_ext","blk=georgian_ext","block=georgian_extended","blk=georgian_ext","block=gunjala_gondi","blk=gunjala_gondi","block=hanifi_rohingya","blk=hanifi_rohingya","block=indic_siyaq_numbers","blk=indic_siyaq_numbers","block=makasar","blk=makasar","block=mayan_numerals","blk=mayan_numerals","block=medefaidrin","blk=medefaidrin","block=old_sogdian","blk=old_sogdian","block=sogdian","blk=sogdian","block=egyptian_hieroglyph_format_controls","blk=egyptian_hieroglyph_format_controls","block=elymaic","blk=elymaic","block=nandinagari","blk=nandinagari","block=nyiakeng_puachue_hmong","blk=nyiakeng_puachue_hmong","block=ottoman_siyaq_numbers","blk=ottoman_siyaq_numbers","block=small_kana_ext","blk=small_kana_ext","block=small_kana_extension","blk=small_kana_ext","block=symbols_and_pictographs_ext_a","blk=symbols_and_pictographs_ext_a","block=symbols_and_pictographs_extended_a","blk=symbols_and_pictographs_ext_a","block=tamil_sup","blk=tamil_sup","block=tamil_supplement","blk=tamil_sup","block=wancho","blk=wancho","block=chorasmian","blk=chorasmian","block=cjk_ext_g","blk=cjk_ext_g","block=cjk_unified_ideographs_extension_g","blk=cjk_ext_g","block=dives_akuru","blk=dives_akuru","block=khitan_small_script","blk=khitan_small_script","block=lisu_sup","blk=lisu_sup","block=lisu_supplement","blk=lisu_sup","block=symbols_for_legacy_computing","blk=symbols_for_legacy_computing","block=tangut_sup","blk=tangut_sup","block=tangut_supplement","blk=tangut_sup","block=yezidi","blk=yezidi","block=arabic_ext_b","blk=arabic_ext_b","block=arabic_extended_b","blk=arabic_ext_b","block=cypro_minoan","blk=cypro_minoan","block=ethiopic_ext_b","blk=ethiopic_ext_b","block=ethiopic_extended_b","blk=ethiopic_ext_b","block=kana_ext_b","blk=kana_ext_b","block=kana_extended_b","blk=kana_ext_b","block=latin_ext_f","blk=latin_ext_f","block=latin_extended_f","blk=latin_ext_f","block=latin_ext_g","blk=latin_ext_g","block=latin_extended_g","blk=latin_ext_g","block=old_uyghur","blk=old_uyghur","block=tangsa","blk=tangsa","block=toto","blk=toto","block=ucas_ext_a","blk=ucas_ext_a","block=unified_canadian_aboriginal_syllabics_extended_a","blk=ucas_ext_a","block=vithkuqi","blk=vithkuqi","block=znamenny_music","blk=znamenny_music","block=znamenny_musical_notation","blk=znamenny_music","block=arabic_ext_c","blk=arabic_ext_c","block=arabic_extended_c","blk=arabic_ext_c","block=cjk_ext_h","blk=cjk_ext_h","block=cjk_unified_ideographs_extension_h","blk=cjk_ext_h","block=cyrillic_ext_d","blk=cyrillic_ext_d","block=cyrillic_extended_d","blk=cyrillic_ext_d","block=devanagari_ext_a","blk=devanagari_ext_a","block=devanagari_extended_a","blk=devanagari_ext_a","block=kaktovik_numerals","blk=kaktovik_numerals","block=kawi","blk=kawi","block=nag_mundari","blk=nag_mundari","canonical_combining_class=nr","ccc=nr","canonical_combining_class=not_reordered","ccc=nr","canonical_combining_class=ov","ccc=ov","canonical_combining_class=overlay","ccc=ov","canonical_combining_class=null","ccc=null","canonical_combining_class=hanr","ccc=hanr","canonical_combining_class=han_reading","ccc=hanr","canonical_combining_class=nk","ccc=nk","canonical_combining_class=nukta","ccc=nk","canonical_combining_class=kv","ccc=kv","canonical_combining_class=kana_voicing","ccc=kv","canonical_combining_class=vr","ccc=vr","canonical_combining_class=virama","ccc=vr","canonical_combining_class=ccc10","ccc=ccc10","canonical_combining_class=ccc11","ccc=ccc11","canonical_combining_class=ccc12","ccc=ccc12","canonical_combining_class=ccc13","ccc=ccc13","canonical_combining_class=ccc14","ccc=ccc14","canonical_combining_class=ccc15","ccc=ccc15","canonical_combining_class=ccc16","ccc=ccc16","canonical_combining_class=ccc17","ccc=ccc17","canonical_combining_class=ccc18","ccc=ccc18","canonical_combining_class=ccc19","ccc=ccc19","canonical_combining_class=ccc20","ccc=ccc20","canonical_combining_class=ccc21","ccc=ccc21","canonical_combining_class=ccc22","ccc=ccc22","canonical_combining_class=ccc23","ccc=ccc23","canonical_combining_class=ccc24","ccc=ccc24","canonical_combining_class=ccc25","ccc=ccc25","canonical_combining_class=ccc26","ccc=ccc26","canonical_combining_class=ccc27","ccc=ccc27","canonical_combining_class=ccc28","ccc=ccc28","canonical_combining_class=ccc29","ccc=ccc29","canonical_combining_class=ccc30","ccc=ccc30","canonical_combining_class=ccc31","ccc=ccc31","canonical_combining_class=ccc32","ccc=ccc32","canonical_combining_class=ccc33","ccc=ccc33","canonical_combining_class=ccc34","ccc=ccc34","canonical_combining_class=ccc35","ccc=ccc35","canonical_combining_class=ccc36","ccc=ccc36","canonical_combining_class=ccc84","ccc=ccc84","canonical_combining_class=ccc91","ccc=ccc91","canonical_combining_class=ccc103","ccc=ccc103","canonical_combining_class=ccc107","ccc=ccc107","canonical_combining_class=ccc118","ccc=ccc118","canonical_combining_class=ccc122","ccc=ccc122","canonical_combining_class=ccc129","ccc=ccc129","canonical_combining_class=ccc130","ccc=ccc130","canonical_combining_class=ccc132","ccc=ccc132","canonical_combining_class=ccc133","ccc=ccc133","canonical_combining_class=atbl","ccc=atbl","canonical_combining_class=attached_below_left","ccc=atbl","canonical_combining_class=atb","ccc=atb","canonical_combining_class=attached_below","ccc=atb","canonical_combining_class=ata","ccc=ata","canonical_combining_class=attached_above","ccc=ata","canonical_combining_class=atar","ccc=atar","canonical_combining_class=attached_above_right","ccc=atar","canonical_combining_class=bl","ccc=bl","canonical_combining_class=below_left","ccc=bl","canonical_combining_class=b","ccc=b","canonical_combining_class=below","ccc=b","canonical_combining_class=br","ccc=br","canonical_combining_class=below_right","ccc=br","canonical_combining_class=l","ccc=l","canonical_combining_class=left","ccc=l","canonical_combining_class=r","ccc=r","canonical_combining_class=right","ccc=r","canonical_combining_class=al","ccc=al","canonical_combining_class=above_left","ccc=al","canonical_combining_class=a","ccc=a","canonical_combining_class=above","ccc=a","canonical_combining_class=ar","ccc=ar","canonical_combining_class=above_right","ccc=ar","canonical_combining_class=db","ccc=db","canonical_combining_class=double_below","ccc=db","canonical_combining_class=da","ccc=da","canonical_combining_class=double_above","ccc=da","canonical_combining_class=is","ccc=is","canonical_combining_class=iota_subscript","ccc=is","decomposition_type=none","dt=none","decomposition_type=none","dt=none","decomposition_type=can","dt=can","decomposition_type=canonical","dt=can","decomposition_type=can","dt=can","decomposition_type=com","dt=com","decomposition_type=compat","dt=com","decomposition_type=com","dt=com","decomposition_type=enc","dt=enc","decomposition_type=circle","dt=enc","decomposition_type=enc","dt=enc","decomposition_type=fin","dt=fin","decomposition_type=final","dt=fin","decomposition_type=fin","dt=fin","decomposition_type=font","dt=font","decomposition_type=font","dt=font","decomposition_type=fra","dt=fra","decomposition_type=fraction","dt=fra","decomposition_type=fra","dt=fra","decomposition_type=init","dt=init","decomposition_type=initial","dt=init","decomposition_type=init","dt=init","decomposition_type=iso","dt=iso","decomposition_type=isolated","dt=iso","decomposition_type=iso","dt=iso","decomposition_type=med","dt=med","decomposition_type=medial","dt=med","decomposition_type=med","dt=med","decomposition_type=nar","dt=nar","decomposition_type=narrow","dt=nar","decomposition_type=nar","dt=nar","decomposition_type=nb","dt=nb","decomposition_type=nobreak","dt=nb","decomposition_type=nb","dt=nb","decomposition_type=sml","dt=sml","decomposition_type=small","dt=sml","decomposition_type=sml","dt=sml","decomposition_type=sqr","dt=sqr","decomposition_type=square","dt=sqr","decomposition_type=sqr","dt=sqr","decomposition_type=sub","dt=sub","decomposition_type=sub","dt=sub","decomposition_type=sup","dt=sup","decomposition_type=super","dt=sup","decomposition_type=sup","dt=sup","decomposition_type=vert","dt=vert","decomposition_type=vertical","dt=vert","decomposition_type=vert","dt=vert","decomposition_type=wide","dt=wide","decomposition_type=wide","dt=wide","east_asian_width=n","ea=n","east_asian_width=neutral","ea=n","east_asian_width=a","ea=a","east_asian_width=ambiguous","ea=a","east_asian_width=h","ea=h","east_asian_width=halfwidth","ea=h","east_asian_width=f","ea=f","east_asian_width=fullwidth","ea=f","east_asian_width=na","ea=na","east_asian_width=narrow","ea=na","east_asian_width=w","ea=w","east_asian_width=wide","ea=w","general_category=cn","gc=cn","general_category=unassigned","gc=cn","general_category=lu","gc=lu","general_category=uppercase_letter","gc=lu","general_category=ll","gc=ll","general_category=lowercase_letter","gc=ll","general_category=lt","gc=lt","general_category=titlecase_letter","gc=lt","general_category=lm","gc=lm","general_category=modifier_letter","gc=lm","general_category=lo","gc=lo","general_category=other_letter","gc=lo","general_category=mn","gc=mn","general_category=nonspacing_mark","gc=mn","general_category=me","gc=me","general_category=enclosing_mark","gc=me","general_category=mc","gc=mc","general_category=spacing_mark","gc=mc","general_category=nd","gc=nd","general_category=decimal_number","gc=nd","general_category=digit","gc=nd","general_category=nl","gc=nl","general_category=letter_number","gc=nl","general_category=no","gc=no","general_category=other_number","gc=no","general_category=zs","gc=zs","general_category=space_separator","gc=zs","general_category=zl","gc=zl","general_category=line_separator","gc=zl","general_category=zp","gc=zp","general_category=paragraph_separator","gc=zp","general_category=cc","gc=cc","general_category=control","gc=cc","general_category=cntrl","gc=cc","general_category=cf","gc=cf","general_category=format","gc=cf","general_category=co","gc=co","general_category=private_use","gc=co","general_category=cs","gc=cs","general_category=surrogate","gc=cs","general_category=pd","gc=pd","general_category=dash_punctuation","gc=pd","general_category=ps","gc=ps","general_category=open_punctuation","gc=ps","general_category=pe","gc=pe","general_category=close_punctuation","gc=pe","general_category=pc","gc=pc","general_category=connector_punctuation","gc=pc","general_category=po","gc=po","general_category=other_punctuation","gc=po","general_category=sm","gc=sm","general_category=math_symbol","gc=sm","general_category=sc","gc=sc","general_category=currency_symbol","gc=sc","general_category=sk","gc=sk","general_category=modifier_symbol","gc=sk","general_category=so","gc=so","general_category=other_symbol","gc=so","general_category=pi","gc=pi","general_category=initial_punctuation","gc=pi","general_category=pf","gc=pf","general_category=final_punctuation","gc=pf","joining_group=no_joining_group","jg=no_joining_group","joining_group=ain","jg=ain","joining_group=alaph","jg=alaph","joining_group=alef","jg=alef","joining_group=beh","jg=beh","joining_group=beth","jg=beth","joining_group=dal","jg=dal","joining_group=dalath_rish","jg=dalath_rish","joining_group=e","jg=e","joining_group=feh","jg=feh","joining_group=final_semkath","jg=final_semkath","joining_group=gaf","jg=gaf","joining_group=gamal","jg=gamal","joining_group=hah","jg=hah","joining_group=teh_marbuta_goal","jg=teh_marbuta_goal","joining_group=hamza_on_heh_goal","jg=teh_marbuta_goal","joining_group=he","jg=he","joining_group=heh","jg=heh","joining_group=heh_goal","jg=heh_goal","joining_group=heth","jg=heth","joining_group=kaf","jg=kaf","joining_group=kaph","jg=kaph","joining_group=knotted_heh","jg=knotted_heh","joining_group=lam","jg=lam","joining_group=lamadh","jg=lamadh","joining_group=meem","jg=meem","joining_group=mim","jg=mim","joining_group=noon","jg=noon","joining_group=nun","jg=nun","joining_group=pe","jg=pe","joining_group=qaf","jg=qaf","joining_group=qaph","jg=qaph","joining_group=reh","jg=reh","joining_group=reversed_pe","jg=reversed_pe","joining_group=sad","jg=sad","joining_group=sadhe","jg=sadhe","joining_group=seen","jg=seen","joining_group=semkath","jg=semkath","joining_group=shin","jg=shin","joining_group=swash_kaf","jg=swash_kaf","joining_group=syriac_waw","jg=syriac_waw","joining_group=tah","jg=tah","joining_group=taw","jg=taw","joining_group=teh_marbuta","jg=teh_marbuta","joining_group=teth","jg=teth","joining_group=waw","jg=waw","joining_group=yeh","jg=yeh","joining_group=yeh_barree","jg=yeh_barree","joining_group=yeh_with_tail","jg=yeh_with_tail","joining_group=yudh","jg=yudh","joining_group=yudh_he","jg=yudh_he","joining_group=zain","jg=zain","joining_group=fe","jg=fe","joining_group=khaph","jg=khaph","joining_group=zhain","jg=zhain","joining_group=burushaski_yeh_barree","jg=burushaski_yeh_barree","joining_group=farsi_yeh","jg=farsi_yeh","joining_group=nya","jg=nya","joining_group=rohingya_yeh","jg=rohingya_yeh","joining_group=manichaean_aleph","jg=manichaean_aleph","joining_group=manichaean_ayin","jg=manichaean_ayin","joining_group=manichaean_beth","jg=manichaean_beth","joining_group=manichaean_daleth","jg=manichaean_daleth","joining_group=manichaean_dhamedh","jg=manichaean_dhamedh","joining_group=manichaean_five","jg=manichaean_five","joining_group=manichaean_gimel","jg=manichaean_gimel","joining_group=manichaean_heth","jg=manichaean_heth","joining_group=manichaean_hundred","jg=manichaean_hundred","joining_group=manichaean_kaph","jg=manichaean_kaph","joining_group=manichaean_lamedh","jg=manichaean_lamedh","joining_group=manichaean_mem","jg=manichaean_mem","joining_group=manichaean_nun","jg=manichaean_nun","joining_group=manichaean_one","jg=manichaean_one","joining_group=manichaean_pe","jg=manichaean_pe","joining_group=manichaean_qoph","jg=manichaean_qoph","joining_group=manichaean_resh","jg=manichaean_resh","joining_group=manichaean_sadhe","jg=manichaean_sadhe","joining_group=manichaean_samekh","jg=manichaean_samekh","joining_group=manichaean_taw","jg=manichaean_taw","joining_group=manichaean_ten","jg=manichaean_ten","joining_group=manichaean_teth","jg=manichaean_teth","joining_group=manichaean_thamedh","jg=manichaean_thamedh","joining_group=manichaean_twenty","jg=manichaean_twenty","joining_group=manichaean_waw","jg=manichaean_waw","joining_group=manichaean_yodh","jg=manichaean_yodh","joining_group=manichaean_zayin","jg=manichaean_zayin","joining_group=straight_waw","jg=straight_waw","joining_group=african_feh","jg=african_feh","joining_group=african_noon","jg=african_noon","joining_group=african_qaf","jg=african_qaf","joining_group=malayalam_bha","jg=malayalam_bha","joining_group=malayalam_ja","jg=malayalam_ja","joining_group=malayalam_lla","jg=malayalam_lla","joining_group=malayalam_llla","jg=malayalam_llla","joining_group=malayalam_nga","jg=malayalam_nga","joining_group=malayalam_nna","jg=malayalam_nna","joining_group=malayalam_nnna","jg=malayalam_nnna","joining_group=malayalam_nya","jg=malayalam_nya","joining_group=malayalam_ra","jg=malayalam_ra","joining_group=malayalam_ssa","jg=malayalam_ssa","joining_group=malayalam_tta","jg=malayalam_tta","joining_group=hanifi_rohingya_kinna_ya","jg=hanifi_rohingya_kinna_ya","joining_group=hanifi_rohingya_pa","jg=hanifi_rohingya_pa","joining_group=thin_yeh","jg=thin_yeh","joining_group=vertical_tail","jg=vertical_tail","joining_type=u","jt=u","joining_type=non_joining","jt=u","joining_type=c","jt=c","joining_type=join_causing","jt=c","joining_type=d","jt=d","joining_type=dual_joining","jt=d","joining_type=l","jt=l","joining_type=left_joining","jt=l","joining_type=r","jt=r","joining_type=right_joining","jt=r","joining_type=t","jt=t","joining_type=transparent","jt=t","line_break=xx","lb=xx","line_break=unknown","lb=xx","line_break=ai","lb=ai","line_break=ambiguous","lb=ai","line_break=al","lb=al","line_break=alphabetic","lb=al","line_break=b2","lb=b2","line_break=break_both","lb=b2","line_break=ba","lb=ba","line_break=break_after","lb=ba","line_break=bb","lb=bb","line_break=break_before","lb=bb","line_break=bk","lb=bk","line_break=mandatory_break","lb=bk","line_break=cb","lb=cb","line_break=contingent_break","lb=cb","line_break=cl","lb=cl","line_break=close_punctuation","lb=cl","line_break=cm","lb=cm","line_break=combining_mark","lb=cm","line_break=cr","lb=cr","line_break=carriage_return","lb=cr","line_break=ex","lb=ex","line_break=exclamation","lb=ex","line_break=gl","lb=gl","line_break=glue","lb=gl","line_break=hy","lb=hy","line_break=hyphen","lb=hy","line_break=id","lb=id","line_break=ideographic","lb=id","line_break=in","lb=in","line_break=inseparable","lb=in","line_break=inseperable","lb=in","line_break=is","lb=is","line_break=infix_numeric","lb=is","line_break=lf","lb=lf","line_break=line_feed","lb=lf","line_break=ns","lb=ns","line_break=nonstarter","lb=ns","line_break=nu","lb=nu","line_break=numeric","lb=nu","line_break=op","lb=op","line_break=open_punctuation","lb=op","line_break=po","lb=po","line_break=postfix_numeric","lb=po","line_break=pr","lb=pr","line_break=prefix_numeric","lb=pr","line_break=qu","lb=qu","line_break=quotation","lb=qu","line_break=sa","lb=sa","line_break=complex_context","lb=sa","line_break=sg","lb=sg","line_break=surrogate","lb=sg","line_break=sp","lb=sp","line_break=space","lb=sp","line_break=sy","lb=sy","line_break=break_symbols","lb=sy","line_break=zw","lb=zw","line_break=zwspace","lb=zw","line_break=nl","lb=nl","line_break=next_line","lb=nl","line_break=wj","lb=wj","line_break=word_joiner","lb=wj","line_break=h2","lb=h2","line_break=h3","lb=h3","line_break=jl","lb=jl","line_break=jt","lb=jt","line_break=jv","lb=jv","line_break=cp","lb=cp","line_break=close_parenthesis","lb=cp","line_break=cj","lb=cj","line_break=conditional_japanese_starter","lb=cj","line_break=hl","lb=hl","line_break=hebrew_letter","lb=hl","line_break=ri","lb=ri","line_break=regional_indicator","lb=ri","line_break=eb","lb=eb","line_break=e_base","lb=eb","line_break=em","lb=em","line_break=e_modifier","lb=em","line_break=zwj","lb=zwj","numeric_type=none","nt=none","numeric_type=de","nt=de","numeric_type=decimal","nt=de","numeric_type=di","nt=di","numeric_type=digit","nt=di","numeric_type=nu","nt=nu","numeric_type=numeric","nt=nu","script=zyyy","sc=zyyy","script=common","sc=zyyy","script=zinh","sc=zinh","script=inherited","sc=zinh","script=qaai","sc=zinh","script=arab","sc=arab","script=arabic","sc=arab","script=armn","sc=armn","script=armenian","sc=armn","script=beng","sc=beng","script=bengali","sc=beng","script=bopo","sc=bopo","script=bopomofo","sc=bopo","script=cher","sc=cher","script=cherokee","sc=cher","script=copt","sc=copt","script=coptic","sc=copt","script=qaac","sc=copt","script=cyrl","sc=cyrl","script=cyrillic","sc=cyrl","script=dsrt","sc=dsrt","script=deseret","sc=dsrt","script=deva","sc=deva","script=devanagari","sc=deva","script=ethi","sc=ethi","script=ethiopic","sc=ethi","script=geor","sc=geor","script=georgian","sc=geor","script=goth","sc=goth","script=gothic","sc=goth","script=grek","sc=grek","script=greek","sc=grek","script=gujr","sc=gujr","script=gujarati","sc=gujr","script=guru","sc=guru","script=gurmukhi","sc=guru","script=hani","sc=hani","script=han","sc=hani","script=hang","sc=hang","script=hangul","sc=hang","script=hebr","sc=hebr","script=hebrew","sc=hebr","script=hira","sc=hira","script=hiragana","sc=hira","script=knda","sc=knda","script=kannada","sc=knda","script=kana","sc=kana","script=katakana","sc=kana","script=khmr","sc=khmr","script=khmer","sc=khmr","script=laoo","sc=laoo","script=lao","sc=laoo","script=latn","sc=latn","script=latin","sc=latn","script=mlym","sc=mlym","script=malayalam","sc=mlym","script=mong","sc=mong","script=mongolian","sc=mong","script=mymr","sc=mymr","script=myanmar","sc=mymr","script=ogam","sc=ogam","script=ogham","sc=ogam","script=ital","sc=ital","script=old_italic","sc=ital","script=orya","sc=orya","script=oriya","sc=orya","script=runr","sc=runr","script=runic","sc=runr","script=sinh","sc=sinh","script=sinhala","sc=sinh","script=syrc","sc=syrc","script=syriac","sc=syrc","script=taml","sc=taml","script=tamil","sc=taml","script=telu","sc=telu","script=telugu","sc=telu","script=thaa","sc=thaa","script=thaana","sc=thaa","script=thai","sc=thai","script=tibt","sc=tibt","script=tibetan","sc=tibt","script=cans","sc=cans","script=canadian_aboriginal","sc=cans","script=yiii","sc=yiii","script=yi","sc=yiii","script=tglg","sc=tglg","script=tagalog","sc=tglg","script=hano","sc=hano","script=hanunoo","sc=hano","script=buhd","sc=buhd","script=buhid","sc=buhd","script=tagb","sc=tagb","script=tagbanwa","sc=tagb","script=brai","sc=brai","script=braille","sc=brai","script=cprt","sc=cprt","script=cypriot","sc=cprt","script=limb","sc=limb","script=limbu","sc=limb","script=linb","sc=linb","script=linear_b","sc=linb","script=osma","sc=osma","script=osmanya","sc=osma","script=shaw","sc=shaw","script=shavian","sc=shaw","script=tale","sc=tale","script=tai_le","sc=tale","script=ugar","sc=ugar","script=ugaritic","sc=ugar","script=hrkt","sc=hrkt","script=katakana_or_hiragana","sc=hrkt","script=bugi","sc=bugi","script=buginese","sc=bugi","script=glag","sc=glag","script=glagolitic","sc=glag","script=khar","sc=khar","script=kharoshthi","sc=khar","script=sylo","sc=sylo","script=syloti_nagri","sc=sylo","script=talu","sc=talu","script=new_tai_lue","sc=talu","script=tfng","sc=tfng","script=tifinagh","sc=tfng","script=xpeo","sc=xpeo","script=old_persian","sc=xpeo","script=bali","sc=bali","script=balinese","sc=bali","script=batk","sc=batk","script=batak","sc=batk","script=blis","sc=blis","script=brah","sc=brah","script=brahmi","sc=brah","script=cham","sc=cham","script=cirt","sc=cirt","script=cyrs","sc=cyrs","script=egyd","sc=egyd","script=egyh","sc=egyh","script=egyp","sc=egyp","script=egyptian_hieroglyphs","sc=egyp","script=geok","sc=geok","script=hans","sc=hans","script=hant","sc=hant","script=hmng","sc=hmng","script=pahawh_hmong","sc=hmng","script=hung","sc=hung","script=old_hungarian","sc=hung","script=inds","sc=inds","script=java","sc=java","script=javanese","sc=java","script=kali","sc=kali","script=kayah_li","sc=kali","script=latf","sc=latf","script=latg","sc=latg","script=lepc","sc=lepc","script=lepcha","sc=lepc","script=lina","sc=lina","script=linear_a","sc=lina","script=mand","sc=mand","script=mandaic","sc=mand","script=maya","sc=maya","script=mero","sc=mero","script=meroitic_hieroglyphs","sc=mero","script=nkoo","sc=nkoo","script=nko","sc=nkoo","script=orkh","sc=orkh","script=old_turkic","sc=orkh","script=perm","sc=perm","script=old_permic","sc=perm","script=phag","sc=phag","script=phags_pa","sc=phag","script=phnx","sc=phnx","script=phoenician","sc=phnx","script=plrd","sc=plrd","script=miao","sc=plrd","script=roro","sc=roro","script=sara","sc=sara","script=syre","sc=syre","script=syrj","sc=syrj","script=syrn","sc=syrn","script=teng","sc=teng","script=vaii","sc=vaii","script=vai","sc=vaii","script=visp","sc=visp","script=xsux","sc=xsux","script=cuneiform","sc=xsux","script=zxxx","sc=zxxx","script=zzzz","sc=zzzz","script=unknown","sc=zzzz","script=cari","sc=cari","script=carian","sc=cari","script=jpan","sc=jpan","script=lana","sc=lana","script=tai_tham","sc=lana","script=lyci","sc=lyci","script=lycian","sc=lyci","script=lydi","sc=lydi","script=lydian","sc=lydi","script=olck","sc=olck","script=ol_chiki","sc=olck","script=rjng","sc=rjng","script=rejang","sc=rjng","script=saur","sc=saur","script=saurashtra","sc=saur","script=sgnw","sc=sgnw","script=signwriting","sc=sgnw","script=sund","sc=sund","script=sundanese","sc=sund","script=moon","sc=moon","script=mtei","sc=mtei","script=meetei_mayek","sc=mtei","script=armi","sc=armi","script=imperial_aramaic","sc=armi","script=avst","sc=avst","script=avestan","sc=avst","script=cakm","sc=cakm","script=chakma","sc=cakm","script=kore","sc=kore","script=kthi","sc=kthi","script=kaithi","sc=kthi","script=mani","sc=mani","script=manichaean","sc=mani","script=phli","sc=phli","script=inscriptional_pahlavi","sc=phli","script=phlp","sc=phlp","script=psalter_pahlavi","sc=phlp","script=phlv","sc=phlv","script=prti","sc=prti","script=inscriptional_parthian","sc=prti","script=samr","sc=samr","script=samaritan","sc=samr","script=tavt","sc=tavt","script=tai_viet","sc=tavt","script=zmth","sc=zmth","script=zsym","sc=zsym","script=bamu","sc=bamu","script=bamum","sc=bamu","script=lisu","sc=lisu","script=nkgb","sc=nkgb","script=sarb","sc=sarb","script=old_south_arabian","sc=sarb","script=bass","sc=bass","script=bassa_vah","sc=bass","script=dupl","sc=dupl","script=duployan","sc=dupl","script=elba","sc=elba","script=elbasan","sc=elba","script=gran","sc=gran","script=grantha","sc=gran","script=kpel","sc=kpel","script=loma","sc=loma","script=mend","sc=mend","script=mende_kikakui","sc=mend","script=merc","sc=merc","script=meroitic_cursive","sc=merc","script=narb","sc=narb","script=old_north_arabian","sc=narb","script=nbat","sc=nbat","script=nabataean","sc=nbat","script=palm","sc=palm","script=palmyrene","sc=palm","script=sind","sc=sind","script=khudawadi","sc=sind","script=wara","sc=wara","script=warang_citi","sc=wara","script=afak","sc=afak","script=jurc","sc=jurc","script=mroo","sc=mroo","script=mro","sc=mroo","script=nshu","sc=nshu","script=nushu","sc=nshu","script=shrd","sc=shrd","script=sharada","sc=shrd","script=sora","sc=sora","script=sora_sompeng","sc=sora","script=takr","sc=takr","script=takri","sc=takr","script=tang","sc=tang","script=tangut","sc=tang","script=wole","sc=wole","script=hluw","sc=hluw","script=anatolian_hieroglyphs","sc=hluw","script=khoj","sc=khoj","script=khojki","sc=khoj","script=tirh","sc=tirh","script=tirhuta","sc=tirh","script=aghb","sc=aghb","script=caucasian_albanian","sc=aghb","script=mahj","sc=mahj","script=mahajani","sc=mahj","script=ahom","sc=ahom","script=hatr","sc=hatr","script=hatran","sc=hatr","script=modi","sc=modi","script=mult","sc=mult","script=multani","sc=mult","script=pauc","sc=pauc","script=pau_cin_hau","sc=pauc","script=sidd","sc=sidd","script=siddham","sc=sidd","script=adlm","sc=adlm","script=adlam","sc=adlm","script=bhks","sc=bhks","script=bhaiksuki","sc=bhks","script=marc","sc=marc","script=marchen","sc=marc","script=newa","sc=newa","script=osge","sc=osge","script=osage","sc=osge","script=hanb","sc=hanb","script=jamo","sc=jamo","script=zsye","sc=zsye","script=gonm","sc=gonm","script=masaram_gondi","sc=gonm","script=soyo","sc=soyo","script=soyombo","sc=soyo","script=zanb","sc=zanb","script=zanabazar_square","sc=zanb","script=dogr","sc=dogr","script=dogra","sc=dogr","script=gong","sc=gong","script=gunjala_gondi","sc=gong","script=maka","sc=maka","script=makasar","sc=maka","script=medf","sc=medf","script=medefaidrin","sc=medf","script=rohg","sc=rohg","script=hanifi_rohingya","sc=rohg","script=sogd","sc=sogd","script=sogdian","sc=sogd","script=sogo","sc=sogo","script=old_sogdian","sc=sogo","script=elym","sc=elym","script=elymaic","sc=elym","script=hmnp","sc=hmnp","script=nyiakeng_puachue_hmong","sc=hmnp","script=nand","sc=nand","script=nandinagari","sc=nand","script=wcho","sc=wcho","script=wancho","sc=wcho","script=chrs","sc=chrs","script=chorasmian","sc=chrs","script=diak","sc=diak","script=dives_akuru","sc=diak","script=kits","sc=kits","script=khitan_small_script","sc=kits","script=yezi","sc=yezi","script=yezidi","sc=yezi","script=cpmn","sc=cpmn","script=cypro_minoan","sc=cpmn","script=ougr","sc=ougr","script=old_uyghur","sc=ougr","script=tnsa","sc=tnsa","script=tangsa","sc=tnsa","script=toto","sc=toto","script=vith","sc=vith","script=vithkuqi","sc=vith","script=kawi","sc=kawi","script=nagm","sc=nagm","script=nag_mundari","sc=nagm","hangul_syllable_type=na","hst=na","hangul_syllable_type=not_applicable","hst=na","hangul_syllable_type=l","hst=l","hangul_syllable_type=leading_jamo","hst=l","hangul_syllable_type=v","hst=v","hangul_syllable_type=vowel_jamo","hst=v","hangul_syllable_type=t","hst=t","hangul_syllable_type=trailing_jamo","hst=t","hangul_syllable_type=lv","hst=lv","hangul_syllable_type=lv_syllable","hst=lv","hangul_syllable_type=lvt","hst=lvt","hangul_syllable_type=lvt_syllable","hst=lvt","nfd_quick_check=n","nfd_qc=n","nfd_quick_check=no","nfd_qc=n","nfd_quick_check=y","nfd_qc=y","nfd_quick_check=yes","nfd_qc=y","nfkd_quick_check=n","nfkd_qc=n","nfkd_quick_check=no","nfkd_qc=n","nfkd_quick_check=y","nfkd_qc=y","nfkd_quick_check=yes","nfkd_qc=y","nfc_quick_check=n","nfc_qc=n","nfc_quick_check=no","nfc_qc=n","nfc_quick_check=y","nfc_qc=y","nfc_quick_check=yes","nfc_qc=y","nfc_quick_check=m","nfc_qc=m","nfc_quick_check=maybe","nfc_qc=m","nfkc_quick_check=n","nfkc_qc=n","nfkc_quick_check=no","nfkc_qc=n","nfkc_quick_check=y","nfkc_qc=y","nfkc_quick_check=yes","nfkc_qc=y","nfkc_quick_check=m","nfkc_qc=m","nfkc_quick_check=maybe","nfkc_qc=m","lead_canonical_combining_class=nr","lccc=nr","lead_canonical_combining_class=not_reordered","lccc=nr","lead_canonical_combining_class=ov","lccc=ov","lead_canonical_combining_class=overlay","lccc=ov","lead_canonical_combining_class=null","lccc=null","lead_canonical_combining_class=hanr","lccc=hanr","lead_canonical_combining_class=han_reading","lccc=hanr","lead_canonical_combining_class=nk","lccc=nk","lead_canonical_combining_class=nukta","lccc=nk","lead_canonical_combining_class=kv","lccc=kv","lead_canonical_combining_class=kana_voicing","lccc=kv","lead_canonical_combining_class=vr","lccc=vr","lead_canonical_combining_class=virama","lccc=vr","lead_canonical_combining_class=ccc10","lccc=ccc10","lead_canonical_combining_class=ccc11","lccc=ccc11","lead_canonical_combining_class=ccc12","lccc=ccc12","lead_canonical_combining_class=ccc13","lccc=ccc13","lead_canonical_combining_class=ccc14","lccc=ccc14","lead_canonical_combining_class=ccc15","lccc=ccc15","lead_canonical_combining_class=ccc16","lccc=ccc16","lead_canonical_combining_class=ccc17","lccc=ccc17","lead_canonical_combining_class=ccc18","lccc=ccc18","lead_canonical_combining_class=ccc19","lccc=ccc19","lead_canonical_combining_class=ccc20","lccc=ccc20","lead_canonical_combining_class=ccc21","lccc=ccc21","lead_canonical_combining_class=ccc22","lccc=ccc22","lead_canonical_combining_class=ccc23","lccc=ccc23","lead_canonical_combining_class=ccc24","lccc=ccc24","lead_canonical_combining_class=ccc25","lccc=ccc25","lead_canonical_combining_class=ccc26","lccc=ccc26","lead_canonical_combining_class=ccc27","lccc=ccc27","lead_canonical_combining_class=ccc28","lccc=ccc28","lead_canonical_combining_class=ccc29","lccc=ccc29","lead_canonical_combining_class=ccc30","lccc=ccc30","lead_canonical_combining_class=ccc31","lccc=ccc31","lead_canonical_combining_class=ccc32","lccc=ccc32","lead_canonical_combining_class=ccc33","lccc=ccc33","lead_canonical_combining_class=ccc34","lccc=ccc34","lead_canonical_combining_class=ccc35","lccc=ccc35","lead_canonical_combining_class=ccc36","lccc=ccc36","lead_canonical_combining_class=ccc84","lccc=ccc84","lead_canonical_combining_class=ccc91","lccc=ccc91","lead_canonical_combining_class=ccc103","lccc=ccc103","lead_canonical_combining_class=ccc107","lccc=ccc107","lead_canonical_combining_class=ccc118","lccc=ccc118","lead_canonical_combining_class=ccc122","lccc=ccc122","lead_canonical_combining_class=ccc129","lccc=ccc129","lead_canonical_combining_class=ccc130","lccc=ccc130","lead_canonical_combining_class=ccc132","lccc=ccc132","lead_canonical_combining_class=ccc133","lccc=ccc133","lead_canonical_combining_class=atbl","lccc=atbl","lead_canonical_combining_class=attached_below_left","lccc=atbl","lead_canonical_combining_class=atb","lccc=atb","lead_canonical_combining_class=attached_below","lccc=atb","lead_canonical_combining_class=ata","lccc=ata","lead_canonical_combining_class=attached_above","lccc=ata","lead_canonical_combining_class=atar","lccc=atar","lead_canonical_combining_class=attached_above_right","lccc=atar","lead_canonical_combining_class=bl","lccc=bl","lead_canonical_combining_class=below_left","lccc=bl","lead_canonical_combining_class=b","lccc=b","lead_canonical_combining_class=below","lccc=b","lead_canonical_combining_class=br","lccc=br","lead_canonical_combining_class=below_right","lccc=br","lead_canonical_combining_class=l","lccc=l","lead_canonical_combining_class=left","lccc=l","lead_canonical_combining_class=r","lccc=r","lead_canonical_combining_class=right","lccc=r","lead_canonical_combining_class=al","lccc=al","lead_canonical_combining_class=above_left","lccc=al","lead_canonical_combining_class=a","lccc=a","lead_canonical_combining_class=above","lccc=a","lead_canonical_combining_class=ar","lccc=ar","lead_canonical_combining_class=above_right","lccc=ar","lead_canonical_combining_class=db","lccc=db","lead_canonical_combining_class=double_below","lccc=db","lead_canonical_combining_class=da","lccc=da","lead_canonical_combining_class=double_above","lccc=da","lead_canonical_combining_class=is","lccc=is","lead_canonical_combining_class=iota_subscript","lccc=is","trail_canonical_combining_class=nr","tccc=nr","trail_canonical_combining_class=not_reordered","tccc=nr","trail_canonical_combining_class=ov","tccc=ov","trail_canonical_combining_class=overlay","tccc=ov","trail_canonical_combining_class=null","tccc=null","trail_canonical_combining_class=hanr","tccc=hanr","trail_canonical_combining_class=han_reading","tccc=hanr","trail_canonical_combining_class=nk","tccc=nk","trail_canonical_combining_class=nukta","tccc=nk","trail_canonical_combining_class=kv","tccc=kv","trail_canonical_combining_class=kana_voicing","tccc=kv","trail_canonical_combining_class=vr","tccc=vr","trail_canonical_combining_class=virama","tccc=vr","trail_canonical_combining_class=ccc10","tccc=ccc10","trail_canonical_combining_class=ccc11","tccc=ccc11","trail_canonical_combining_class=ccc12","tccc=ccc12","trail_canonical_combining_class=ccc13","tccc=ccc13","trail_canonical_combining_class=ccc14","tccc=ccc14","trail_canonical_combining_class=ccc15","tccc=ccc15","trail_canonical_combining_class=ccc16","tccc=ccc16","trail_canonical_combining_class=ccc17","tccc=ccc17","trail_canonical_combining_class=ccc18","tccc=ccc18","trail_canonical_combining_class=ccc19","tccc=ccc19","trail_canonical_combining_class=ccc20","tccc=ccc20","trail_canonical_combining_class=ccc21","tccc=ccc21","trail_canonical_combining_class=ccc22","tccc=ccc22","trail_canonical_combining_class=ccc23","tccc=ccc23","trail_canonical_combining_class=ccc24","tccc=ccc24","trail_canonical_combining_class=ccc25","tccc=ccc25","trail_canonical_combining_class=ccc26","tccc=ccc26","trail_canonical_combining_class=ccc27","tccc=ccc27","trail_canonical_combining_class=ccc28","tccc=ccc28","trail_canonical_combining_class=ccc29","tccc=ccc29","trail_canonical_combining_class=ccc30","tccc=ccc30","trail_canonical_combining_class=ccc31","tccc=ccc31","trail_canonical_combining_class=ccc32","tccc=ccc32","trail_canonical_combining_class=ccc33","tccc=ccc33","trail_canonical_combining_class=ccc34","tccc=ccc34","trail_canonical_combining_class=ccc35","tccc=ccc35","trail_canonical_combining_class=ccc36","tccc=ccc36","trail_canonical_combining_class=ccc84","tccc=ccc84","trail_canonical_combining_class=ccc91","tccc=ccc91","trail_canonical_combining_class=ccc103","tccc=ccc103","trail_canonical_combining_class=ccc107","tccc=ccc107","trail_canonical_combining_class=ccc118","tccc=ccc118","trail_canonical_combining_class=ccc122","tccc=ccc122","trail_canonical_combining_class=ccc129","tccc=ccc129","trail_canonical_combining_class=ccc130","tccc=ccc130","trail_canonical_combining_class=ccc132","tccc=ccc132","trail_canonical_combining_class=ccc133","tccc=ccc133","trail_canonical_combining_class=atbl","tccc=atbl","trail_canonical_combining_class=attached_below_left","tccc=atbl","trail_canonical_combining_class=atb","tccc=atb","trail_canonical_combining_class=attached_below","tccc=atb","trail_canonical_combining_class=ata","tccc=ata","trail_canonical_combining_class=attached_above","tccc=ata","trail_canonical_combining_class=atar","tccc=atar","trail_canonical_combining_class=attached_above_right","tccc=atar","trail_canonical_combining_class=bl","tccc=bl","trail_canonical_combining_class=below_left","tccc=bl","trail_canonical_combining_class=b","tccc=b","trail_canonical_combining_class=below","tccc=b","trail_canonical_combining_class=br","tccc=br","trail_canonical_combining_class=below_right","tccc=br","trail_canonical_combining_class=l","tccc=l","trail_canonical_combining_class=left","tccc=l","trail_canonical_combining_class=r","tccc=r","trail_canonical_combining_class=right","tccc=r","trail_canonical_combining_class=al","tccc=al","trail_canonical_combining_class=above_left","tccc=al","trail_canonical_combining_class=a","tccc=a","trail_canonical_combining_class=above","tccc=a","trail_canonical_combining_class=ar","tccc=ar","trail_canonical_combining_class=above_right","tccc=ar","trail_canonical_combining_class=db","tccc=db","trail_canonical_combining_class=double_below","tccc=db","trail_canonical_combining_class=da","tccc=da","trail_canonical_combining_class=double_above","tccc=da","trail_canonical_combining_class=is","tccc=is","trail_canonical_combining_class=iota_subscript","tccc=is","grapheme_cluster_break=xx","gcb=xx","grapheme_cluster_break=other","gcb=xx","grapheme_cluster_break=cn","gcb=cn","grapheme_cluster_break=control","gcb=cn","grapheme_cluster_break=cr","gcb=cr","grapheme_cluster_break=ex","gcb=ex","grapheme_cluster_break=extend","gcb=ex","grapheme_cluster_break=l","gcb=l","grapheme_cluster_break=lf","gcb=lf","grapheme_cluster_break=lv","gcb=lv","grapheme_cluster_break=lvt","gcb=lvt","grapheme_cluster_break=t","gcb=t","grapheme_cluster_break=v","gcb=v","grapheme_cluster_break=sm","gcb=sm","grapheme_cluster_break=spacingmark","gcb=sm","grapheme_cluster_break=pp","gcb=pp","grapheme_cluster_break=prepend","gcb=pp","grapheme_cluster_break=ri","gcb=ri","grapheme_cluster_break=regional_indicator","gcb=ri","grapheme_cluster_break=eb","gcb=eb","grapheme_cluster_break=e_base","gcb=eb","grapheme_cluster_break=ebg","gcb=ebg","grapheme_cluster_break=e_base_gaz","gcb=ebg","grapheme_cluster_break=em","gcb=em","grapheme_cluster_break=e_modifier","gcb=em","grapheme_cluster_break=gaz","gcb=gaz","grapheme_cluster_break=glue_after_zwj","gcb=gaz","grapheme_cluster_break=zwj","gcb=zwj","sentence_break=xx","sb=xx","sentence_break=other","sb=xx","sentence_break=at","sb=at","sentence_break=aterm","sb=at","sentence_break=cl","sb=cl","sentence_break=close","sb=cl","sentence_break=fo","sb=fo","sentence_break=format","sb=fo","sentence_break=lo","sb=lo","sentence_break=lower","sb=lo","sentence_break=nu","sb=nu","sentence_break=numeric","sb=nu","sentence_break=le","sb=le","sentence_break=oletter","sb=le","sentence_break=se","sb=se","sentence_break=sep","sb=se","sentence_break=sp","sb=sp","sentence_break=sp","sb=sp","sentence_break=st","sb=st","sentence_break=sterm","sb=st","sentence_break=up","sb=up","sentence_break=upper","sb=up","sentence_break=cr","sb=cr","sentence_break=ex","sb=ex","sentence_break=extend","sb=ex","sentence_break=lf","sb=lf","sentence_break=sc","sb=sc","sentence_break=scontinue","sb=sc","word_break=xx","wb=xx","word_break=other","wb=xx","word_break=le","wb=le","word_break=aletter","wb=le","word_break=fo","wb=fo","word_break=format","wb=fo","word_break=ka","wb=ka","word_break=katakana","wb=ka","word_break=ml","wb=ml","word_break=midletter","wb=ml","word_break=mn","wb=mn","word_break=midnum","wb=mn","word_break=nu","wb=nu","word_break=numeric","wb=nu","word_break=ex","wb=ex","word_break=extendnumlet","wb=ex","word_break=cr","wb=cr","word_break=extend","wb=extend","word_break=lf","wb=lf","word_break=mb","wb=mb","word_break=midnumlet","wb=mb","word_break=nl","wb=nl","word_break=newline","wb=nl","word_break=ri","wb=ri","word_break=regional_indicator","wb=ri","word_break=hl","wb=hl","word_break=hebrew_letter","wb=hl","word_break=sq","wb=sq","word_break=single_quote","wb=sq","word_break=dq","wb=dq","word_break=double_quote","wb=dq","word_break=eb","wb=eb","word_break=e_base","wb=eb","word_break=ebg","wb=ebg","word_break=e_base_gaz","wb=ebg","word_break=em","wb=em","word_break=e_modifier","wb=em","word_break=gaz","wb=gaz","word_break=glue_after_zwj","wb=gaz","word_break=zwj","wb=zwj","word_break=wsegspace","wb=wsegspace","bidi_paired_bracket_type=n","bpt=n","bidi_paired_bracket_type=none","bpt=n","bidi_paired_bracket_type=o","bpt=o","bidi_paired_bracket_type=open","bpt=o","bidi_paired_bracket_type=c","bpt=c","bidi_paired_bracket_type=close","bpt=c","indic_positional_category=na","inpc=na","indic_positional_category=bottom","inpc=bottom","indic_positional_category=bottom_and_left","inpc=bottom_and_left","indic_positional_category=bottom_and_right","inpc=bottom_and_right","indic_positional_category=left","inpc=left","indic_positional_category=left_and_right","inpc=left_and_right","indic_positional_category=overstruck","inpc=overstruck","indic_positional_category=right","inpc=right","indic_positional_category=top","inpc=top","indic_positional_category=top_and_bottom","inpc=top_and_bottom","indic_positional_category=top_and_bottom_and_right","inpc=top_and_bottom_and_right","indic_positional_category=top_and_left","inpc=top_and_left","indic_positional_category=top_and_left_and_right","inpc=top_and_left_and_right","indic_positional_category=top_and_right","inpc=top_and_right","indic_positional_category=visual_order_left","inpc=visual_order_left","indic_positional_category=top_and_bottom_and_left","inpc=top_and_bottom_and_left","indic_syllabic_category=other","insc=other","indic_syllabic_category=avagraha","insc=avagraha","indic_syllabic_category=bindu","insc=bindu","indic_syllabic_category=brahmi_joining_number","insc=brahmi_joining_number","indic_syllabic_category=cantillation_mark","insc=cantillation_mark","indic_syllabic_category=consonant","insc=consonant","indic_syllabic_category=consonant_dead","insc=consonant_dead","indic_syllabic_category=consonant_final","insc=consonant_final","indic_syllabic_category=consonant_head_letter","insc=consonant_head_letter","indic_syllabic_category=consonant_initial_postfixed","insc=consonant_initial_postfixed","indic_syllabic_category=consonant_killer","insc=consonant_killer","indic_syllabic_category=consonant_medial","insc=consonant_medial","indic_syllabic_category=consonant_placeholder","insc=consonant_placeholder","indic_syllabic_category=consonant_preceding_repha","insc=consonant_preceding_repha","indic_syllabic_category=consonant_prefixed","insc=consonant_prefixed","indic_syllabic_category=consonant_subjoined","insc=consonant_subjoined","indic_syllabic_category=consonant_succeeding_repha","insc=consonant_succeeding_repha","indic_syllabic_category=consonant_with_stacker","insc=consonant_with_stacker","indic_syllabic_category=gemination_mark","insc=gemination_mark","indic_syllabic_category=invisible_stacker","insc=invisible_stacker","indic_syllabic_category=joiner","insc=joiner","indic_syllabic_category=modifying_letter","insc=modifying_letter","indic_syllabic_category=non_joiner","insc=non_joiner","indic_syllabic_category=nukta","insc=nukta","indic_syllabic_category=number","insc=number","indic_syllabic_category=number_joiner","insc=number_joiner","indic_syllabic_category=pure_killer","insc=pure_killer","indic_syllabic_category=register_shifter","insc=register_shifter","indic_syllabic_category=syllable_modifier","insc=syllable_modifier","indic_syllabic_category=tone_letter","insc=tone_letter","indic_syllabic_category=tone_mark","insc=tone_mark","indic_syllabic_category=virama","insc=virama","indic_syllabic_category=visarga","insc=visarga","indic_syllabic_category=vowel","insc=vowel","indic_syllabic_category=vowel_dependent","insc=vowel_dependent","indic_syllabic_category=vowel_independent","insc=vowel_independent","vertical_orientation=r","vo=r","vertical_orientation=rotated","vo=r","vertical_orientation=tr","vo=tr","vertical_orientation=transformed_rotated","vo=tr","vertical_orientation=tu","vo=tu","vertical_orientation=transformed_upright","vo=tu","vertical_orientation=u","vo=u","vertical_orientation=upright","vo=u","ep","extended_pictographic" };
		for (int i = 0; i < rawAliases.length; i += 2) {
			propertyAliases.put(rawAliases[i], rawAliases[i + 1]);
		}
	}

	static {
		addProperty1();
		addProperty2();
		addProperty3();
		addProperty4();
		addProperty5();
		addProperty6();
		addProperty7();
		addProperty8();
		addProperty9();
		addProperty10();
		addProperty11();
		addProperty12();
		addProperty13();
		addProperty14();
		addProperty15();
		addProperty16();
		addProperty17();
		addProperty18();
		addProperty19();
		addProperty20();
		addProperty21();
		addProperty22();
		addProperty23();
		addProperty24();
		addProperty25();
		addProperty26();
		addProperty27();
		addProperty28();
		addProperty29();
		addProperty30();
		addProperty31();
		addProperty32();
		addProperty33();
		addProperty34();
		addProperty35();
		addProperty36();
		addProperty37();
		addProperty38();
		addProperty39();
		addProperty40();
		addProperty41();
		addProperty42();
		addProperty43();
		addProperty44();
		addProperty45();
		addProperty46();
		addProperty47();
		addProperty48();
		addProperty49();
		addProperty50();
		addProperty51();
		addProperty52();
		addProperty53();
		addProperty54();
		addProperty55();
		addProperty56();
		addProperty57();
		addProperty58();
		addProperty59();
		addProperty60();
		addProperty61();
		addProperty62();
		addProperty63();
		addProperty64();
		addProperty65();
		addProperty66();
		addProperty67();
		addProperty68();
		addProperty69();
		addProperty70();
		addProperty71();
		addProperty72();
		addProperty73();
		addProperty74();
		addProperty75();
		addProperty76();
		addProperty77();
		addProperty78();
		addProperty79();
		addProperty80();
		addProperty81();
		addProperty82();
		addProperty83();
		addProperty84();
		addProperty85();
		addProperty86();
		addProperty87();
		addProperty88();
		addProperty89();
		addProperty90();
		addProperty91();
		addProperty92();
		addProperty93();
		addProperty94();
		addProperty95();
		addProperty96();
		addProperty97();
		addProperty98();
		addProperty99();
		addProperty100();
		addProperty101();
		addProperty102();
		addProperty103();
		addProperty104();
		addProperty105();
		addProperty106();
		addProperty107();
		addProperty108();
		addProperty109();
		addProperty110();
		addProperty111();
		addProperty112();
		addProperty113();
		addProperty114();
		addProperty115();
		addProperty116();
		addProperty117();
		addProperty118();
		addProperty119();
		addProperty120();
		addProperty121();
		addProperty122();
		addProperty123();
		addProperty124();
		addProperty125();
		addProperty126();
		addProperty127();
		addProperty128();
		addProperty129();
		addProperty130();
		addProperty131();
		addProperty132();
		addProperty133();
		addProperty134();
		addProperty135();
		addProperty136();
		addProperty137();
		addProperty138();
		addProperty139();
		addProperty140();
		addProperty141();
		addProperty142();
		addProperty143();
		addProperty144();
		addProperty145();
		addProperty146();
		addProperty147();
		addProperty148();
		addProperty149();
		addProperty150();
		addProperty151();
		addProperty152();
		addProperty153();
		addProperty154();
		addProperty155();
		addProperty156();
		addProperty157();
		addProperty158();
		addProperty159();
		addProperty160();
		addProperty161();
		addProperty162();
		addProperty163();
		addProperty164();
		addProperty165();
		addProperty166();
		addProperty167();
		addProperty168();
		addProperty169();
		addProperty170();
		addProperty171();
		addProperty172();
		addProperty173();
		addProperty174();
		addProperty175();
		addProperty176();
		addProperty177();
		addProperty178();
		addProperty179();
		addProperty180();
		addProperty181();
		addProperty182();
		addProperty183();
		addProperty184();
		addProperty185();
		addProperty186();
		addProperty187();
		addProperty188();
		addProperty189();
		addProperty190();
		addProperty191();
		addProperty192();
		addProperty193();
		addProperty194();
		addProperty195();
		addProperty196();
		addProperty197();
		addProperty198();
		addProperty199();
		addProperty200();
		addProperty201();
		addProperty202();
		addProperty203();
		addProperty204();
		addProperty205();
		addProperty206();
		addProperty207();
		addProperty208();
		addProperty209();
		addProperty210();
		addProperty211();
		addProperty212();
		addProperty213();
		addProperty214();
		addProperty215();
		addProperty216();
		addProperty217();
		addProperty218();
		addProperty219();
		addProperty220();
		addProperty221();
		addProperty222();
		addProperty223();
		addProperty224();
		addProperty225();
		addProperty226();
		addProperty227();
		addProperty228();
		addProperty229();
		addProperty230();
		addProperty231();
		addProperty232();
		addProperty233();
		addProperty234();
		addProperty235();
		addProperty236();
		addProperty237();
		addProperty238();
		addProperty239();
		addProperty240();
		addProperty241();
		addProperty242();
		addProperty243();
		addProperty244();
		addProperty245();
		addProperty246();
		addProperty247();
		addProperty248();
		addProperty249();
		addProperty250();
		addProperty251();
		addProperty252();
		addProperty253();
		addProperty254();
		addProperty255();
		addProperty256();
		addProperty257();
		addProperty258();
		addProperty259();
		addProperty260();
		addProperty261();
		addProperty262();
		addProperty263();
		addProperty264();
		addProperty265();
		addProperty266();
		addProperty267();
		addProperty268();
		addProperty269();
		addProperty270();
		addProperty271();
		addProperty272();
		addProperty273();
		addProperty274();
		addProperty275();
		addProperty276();
		addProperty277();
		addProperty278();
		addProperty279();
		addProperty280();
		addProperty281();
		addProperty282();
		addProperty283();
		addProperty284();
		addProperty285();
		addProperty286();
		addProperty287();
		addProperty288();
		addProperty289();
		addProperty290();
		addProperty291();
		addProperty292();
		addProperty293();
		addProperty294();
		addProperty295();
		addProperty296();
		addProperty297();
		addProperty298();
		addProperty299();
		addProperty300();
		addProperty301();
		addProperty302();
		addProperty303();
		addProperty304();
		addProperty305();
		addProperty306();
		addProperty307();
		addProperty308();
		addProperty309();
		addProperty310();
		addProperty311();
		addProperty312();
		addProperty313();
		addProperty314();
		addProperty315();
		addProperty316();
		addProperty317();
		addProperty318();
		addProperty319();
		addProperty320();
		addProperty321();
		addProperty322();
		addProperty323();
		addProperty324();
		addProperty325();
		addProperty326();
		addProperty327();
		addProperty328();
		addProperty329();
		addProperty330();
		addProperty331();
		addProperty332();
		addProperty333();
		addProperty334();
		addProperty335();
		addProperty336();
		addProperty337();
		addProperty338();
		addProperty339();
		addProperty340();
		addProperty341();
		addProperty342();
		addProperty343();
		addProperty344();
		addProperty345();
		addProperty346();
		addProperty347();
		addProperty348();
		addProperty349();
		addProperty350();
		addProperty351();
		addProperty352();
		addProperty353();
		addProperty354();
		addProperty355();
		addProperty356();
		addProperty357();
		addProperty358();
		addProperty359();
		addProperty360();
		addProperty361();
		addProperty362();
		addProperty363();
		addProperty364();
		addProperty365();
		addProperty366();
		addProperty367();
		addProperty368();
		addProperty369();
		addProperty370();
		addProperty371();
		addProperty372();
		addProperty373();
		addProperty374();
		addProperty375();
		addProperty376();
		addProperty377();
		addProperty378();
		addProperty379();
		addProperty380();
		addProperty381();
		addProperty382();
		addProperty383();
		addProperty384();
		addProperty385();
		addProperty386();
		addProperty387();
		addProperty388();
		addProperty389();
		addProperty390();
		addProperty391();
		addProperty392();
		addProperty393();
		addProperty394();
		addProperty395();
		addProperty396();
		addProperty397();
		addProperty398();
		addProperty399();
		addProperty400();
		addProperty401();
		addProperty402();
		addProperty403();
		addProperty404();
		addProperty405();
		addProperty406();
		addProperty407();
		addProperty408();
		addProperty409();
		addProperty410();
		addProperty411();
		addProperty412();
		addProperty413();
		addProperty414();
		addProperty415();
		addProperty416();
		addProperty417();
		addProperty418();
		addProperty419();
		addProperty420();
		addProperty421();
		addProperty422();
		addProperty423();
		addProperty424();
		addProperty425();
		addProperty426();
		addProperty427();
		addProperty428();
		addProperty429();
		addProperty430();
		addProperty431();
		addProperty432();
		addProperty433();
		addProperty434();
		addProperty435();
		addProperty436();
		addProperty437();
		addProperty438();
		addProperty439();
		addProperty440();
		addProperty441();
		addProperty442();
		addProperty443();
		addProperty444();
		addProperty445();
		addProperty446();
		addProperty447();
		addProperty448();
		addProperty449();
		addProperty450();
		addProperty451();
		addProperty452();
		addProperty453();
		addProperty454();
		addProperty455();
		addProperty456();
		addProperty457();
		addProperty458();
		addProperty459();
		addProperty460();
		addProperty461();
		addProperty462();
		addProperty463();
		addProperty464();
		addProperty465();
		addProperty466();
		addProperty467();
		addProperty468();
		addProperty469();
		addProperty470();
		addProperty471();
		addProperty472();
		addProperty473();
		addProperty474();
		addProperty475();
		addProperty476();
		addProperty477();
		addProperty478();
		addProperty479();
		addProperty480();
		addProperty481();
		addProperty482();
		addProperty483();
		addProperty484();
		addProperty485();
		addProperty486();
		addProperty487();
		addProperty488();
		addProperty489();
		addProperty490();
		addProperty491();
		addProperty492();
		addProperty493();
		addProperty494();
		addProperty495();
		addProperty496();
		addProperty497();
		addProperty498();
		addProperty499();
		addProperty500();
		addProperty501();
		addProperty502();
		addProperty503();
		addProperty504();
		addProperty505();
		addProperty506();
		addProperty507();
		addProperty508();
		addProperty509();
		addProperty510();
		addProperty511();
		addProperty512();
		addProperty513();
		addProperty514();
		addProperty515();
		addProperty516();
		addProperty517();
		addProperty518();
		addProperty519();
		addProperty520();
		addProperty521();
		addProperty522();
		addProperty523();
		addProperty524();
		addProperty525();
		addProperty526();
		addProperty527();
		addProperty528();
		addProperty529();
		addProperty530();
		addProperty531();
		addProperty532();
		addProperty533();
		addProperty534();
		addProperty535();
		addProperty536();
		addProperty537();
		addProperty538();
		addProperty539();
		addProperty540();
		addProperty541();
		addProperty542();
		addProperty543();
		addProperty544();
		addProperty545();
		addProperty546();
		addProperty547();
		addProperty548();
		addProperty549();
		addProperty550();
		addProperty551();
		addProperty552();
		addProperty553();
		addProperty554();
		addProperty555();
		addProperty556();
		addProperty557();
		addProperty558();
		addProperty559();
		addProperty560();
		addProperty561();
		addProperty562();
		addProperty563();
		addProperty564();
		addProperty565();
		addProperty566();
		addProperty567();
		addProperty568();
		addProperty569();
		addProperty570();
		addProperty571();
		addProperty572();
		addProperty573();
		addProperty574();
		addProperty575();
		addProperty576();
		addProperty577();
		addProperty578();
		addProperty579();
		addProperty580();
		addProperty581();
		addProperty582();
		addProperty583();
		addProperty584();
		addProperty585();
		addProperty586();
		addProperty587();
		addProperty588();
		addProperty589();
		addProperty590();
		addProperty591();
		addProperty592();
		addProperty593();
		addProperty594();
		addProperty595();
		addProperty596();
		addProperty597();
		addProperty598();
		addProperty599();
		addProperty600();
		addProperty601();
		addProperty602();
		addProperty603();
		addProperty604();
		addProperty605();
		addProperty606();
		addProperty607();
		addProperty608();
		addProperty609();
		addProperty610();
		addProperty611();
		addProperty612();
		addProperty613();
		addProperty614();
		addProperty615();
		addProperty616();
		addProperty617();
		addProperty618();
		addProperty619();
		addProperty620();
		addProperty621();
		addProperty622();
		addProperty623();
		addProperty624();
		addProperty625();
		addProperty626();
		addProperty627();
		addProperty628();
		addProperty629();
		addProperty630();
		addProperty631();
		addProperty632();
		addProperty633();
		addProperty634();
		addProperty635();
		addProperty636();
		addProperty637();
		addProperty638();
		addProperty639();
		addProperty640();
		addProperty641();
		addProperty642();
		addProperty643();
		addProperty644();
		addProperty645();
		addProperty646();
		addProperty647();
		addProperty648();
		addProperty649();
		addProperty650();
		addProperty651();
		addProperty652();
		addProperty653();
		addProperty654();
		addProperty655();
		addProperty656();
		addProperty657();
		addProperty658();
		addProperty659();
		addProperty660();
		addProperty661();
		addProperty662();
		addProperty663();
		addProperty664();
		addProperty665();
		addProperty666();
		addProperty667();
		addProperty668();
		addProperty669();
		addProperty670();
		addProperty671();
		addProperty672();
		addProperty673();
		addProperty674();
		addProperty675();
		addProperty676();
		addProperty677();
		addProperty678();
		addProperty679();
		addProperty680();
		addProperty681();
		addProperty682();
		addProperty683();
		addProperty684();
		addProperty685();
		addProperty686();
		addProperty687();
		addProperty688();
		addProperty689();
		addProperty690();
		addProperty691();
		addProperty692();
		addProperty693();
		addProperty694();
		addProperty695();
		addProperty696();
		addProperty697();
		addProperty698();
		addProperty699();
		addProperty700();
		addProperty701();
		addProperty702();
		addProperty703();
		addProperty704();
		addProperty705();
		addProperty706();
		addProperty707();
		addProperty708();
		addProperty709();
		addProperty710();
		addProperty711();
		addProperty712();
		addProperty713();
		addProperty714();
		addProperty715();
		addProperty716();
		addProperty717();
		addProperty718();
		addProperty719();
		addProperty720();
		addProperty721();
		addProperty722();
		addProperty723();
		addProperty724();
		addProperty725();
		addProperty726();
		addProperty727();
		addProperty728();
		addProperty729();
		addProperty730();
		addProperty731();
		addProperty732();
		addProperty733();
		addProperty734();
		addProperty735();
		addProperty736();
		addProperty737();
		addProperty738();
		addProperty739();
		addProperty740();
		addProperty741();
		addProperty742();
		addProperty743();
		addProperty744();
		addProperty745();
		addProperty746();
		addProperty747();
		addProperty748();
		addProperty749();
		addProperty750();
		addProperty751();
		addProperty752();
		addProperty753();
		addProperty754();
		addProperty755();
		addProperty756();
		addProperty757();
		addProperty758();
		addProperty759();
		addProperty760();
		addProperty761();
		addProperty762();
		addProperty763();
		addProperty764();
		addProperty765();
		addProperty766();
		addProperty767();
		addProperty768();
		addProperty769();
		addProperty770();
		addProperty771();
		addProperty772();
		addProperty773();
		addProperty774();
		addProperty775();
		addProperty776();
		addProperty777();
		addProperty778();
		addProperty779();
		addProperty780();
		addProperty781();
		addProperty782();
		addProperty783();
		addProperty784();
		addProperty785();
		addProperty786();
		addProperty787();
		addProperty788();
		addProperty789();
		addProperty790();
		addProperty791();
		addProperty792();
		addProperty793();
		addProperty794();
		addProperty795();
		addProperty796();
		addProperty797();
		addProperty798();
		addProperty799();
		addProperty800();
		addProperty801();
		addProperty802();
		addProperty803();
		addProperty804();
		addProperty805();
		addProperty806();
		addProperty807();
		addProperty808();
		addProperty809();
		addProperty810();
		addProperty811();
		addProperty812();
		addProperty813();
		addProperty814();
		addProperty815();
		addProperty816();
		addProperty817();
		addProperty818();
		addProperty819();
		addProperty820();
		addProperty821();
		addProperty822();
		addProperty823();
		addProperty824();
		addProperty825();
		addProperty826();
		addProperty827();
		addProperty828();
		addProperty829();
		addProperty830();
		addProperty831();
		addProperty832();
		addProperty833();
		addProperty834();
		addProperty835();
		addProperty836();
		addProperty837();
		addProperty838();
		addProperty839();
		addProperty840();
		addProperty841();
		addProperty842();
		addProperty843();
		addProperty844();
		addProperty845();
		addProperty846();
		addProperty847();
		addProperty848();
		addProperty849();
		addProperty850();
		addProperty851();
		addProperty852();
		addProperty853();
		addProperty854();
		addProperty855();
		addProperty856();
		addProperty857();
		addProperty858();
		addProperty859();
		addProperty860();
		addProperty861();
		addProperty862();
		addProperty863();
		addProperty864();
		addProperty865();
		addProperty866();
		addProperty867();
		addProperty868();
		addProperty869();
		addProperty870();
		addProperty871();
		addProperty872();
		addProperty873();
		addProperty874();
		addProperty875();
		addProperty876();
		addProperty877();
		addProperty878();
		addProperty879();
		addProperty880();
		addProperty881();
		addProperty882();
		addProperty883();
		addProperty884();
		addProperty885();
		addProperty886();
		addProperty887();
		addProperty888();
		addProperty889();
		addProperty890();
		addProperty891();
		addProperty892();
		addProperty893();
		addProperty894();
		addProperty895();
		addProperty896();
		addProperty897();
		addProperty898();
		addProperty899();
		addProperty900();
		addProperty901();
		addProperty902();
		addProperty903();
		addProperty904();
		addProperty905();
		addProperty906();
		addProperty907();
		addProperty908();
		addProperty909();
		addProperty910();
		addProperty911();
		addProperty912();
		addProperty913();
		addProperty914();
		addProperty915();
		addProperty916();
		addProperty917();
		addProperty918();
		addProperty919();
		addProperty920();
		addProperty921();
		addProperty922();
		addProperty923();
		addProperty924();
		addProperty925();
		addProperty926();
		addProperty927();
		addProperty928();
		addProperty929();
		addProperty930();
		addProperty931();
		addProperty932();
		addProperty933();
		addProperty934();
		addProperty935();
		addProperty936();
		addProperty937();
		addProperty938();
		addProperty939();
		addProperty940();
		addProperty941();
		addProperty942();
		addProperty943();
		addProperty944();
		addProperty945();
		addProperty946();
		addProperty947();
		addProperty948();
		addProperty949();
		addProperty950();
		addProperty951();
		addProperty952();
		addProperty953();
		addProperty954();
		addProperty955();
		addProperty956();
		addProperty957();
		addProperty958();
		addProperty959();
		addProperty960();
		addProperty961();
		addProperty962();
		addProperty963();
		addProperty964();
		addProperty965();
		addProperty966();
		addProperty967();
		addProperty968();
		addProperty969();
		addProperty970();
		addProperty971();
		addProperty972();
		addProperty973();
		addProperty974();
		addProperty975();
		addProperty976();
		addProperty977();
		addProperty978();
		addProperty979();
		addProperty980();
		addProperty981();
		addProperty982();
		addProperty983();
		addProperty984();
		addProperty985();
		addProperty986();
		addProperty987();
		addProperty988();
		addProperty989();
		addProperty990();
		addProperty991();
		addProperty992();
		addProperty993();
		addProperty994();
		addProperty995();
		addProperty996();
		addProperty997();
		addProperty998();
		addProperty999();
		addProperty1000();
		addProperty1001();
		addProperty1002();
		addProperty1003();
		addProperty1004();
		addProperty1005();
		addProperty1006();
		addProperty1007();
		addProperty1008();
		addProperty1009();
		addProperty1010();
		addProperty1011();
		addProperty1012();
		addProperty1013();
		addProperty1014();
		addProperty1015();
		addProperty1016();
		addProperty1017();
		addProperty1018();
		addProperty1019();
		addProperty1020();
		addProperty1021();
		addProperty1022();
		addProperty1023();
		addProperty1024();
		addProperty1025();
		addProperty1026();
		addProperty1027();
		addProperty1028();
		addProperty1029();
		addProperty1030();
		addProperty1031();
		addProperty1032();
		addProperty1033();
		addProperty1034();
		addProperty1035();
		addProperty1036();
		addProperty1037();
		addProperty1038();
		addProperty1039();
		addProperty1040();
		addProperty1041();
		addProperty1042();
		addProperty1043();
		addProperty1044();
		addProperty1045();
		addProperty1046();
		addProperty1047();
		addProperty1048();
		addProperty1049();
		addProperty1050();
		addProperty1051();
		addProperty1052();
		addProperty1053();
		addProperty1054();
		addProperty1055();
		addProperty1056();
		addProperty1057();
		addProperty1058();
		addProperty1059();
		addProperty1060();
		addProperty1061();
		addProperty1062();
		addProperty1063();
		addProperty1064();
		addProperty1065();
		addProperty1066();
		addProperty1067();
		addProperty1068();
		addProperty1069();
		addProperty1070();
		addProperty1071();
		addProperty1072();
		addProperty1073();
		addProperty1074();
		addProperty1075();
		addProperty1076();
		addProperty1077();
		addProperty1078();
		addProperty1079();
		addProperty1080();
		addProperty1081();
		addProperty1082();
		addProperty1083();
		addProperty1084();
		addProperty1085();
		addProperty1086();
		addProperty1087();
		addProperty1088();
		addProperty1089();
		addProperty1090();
		addProperty1091();
		addProperty1092();
		addProperty1093();
		addProperty1094();
		addProperty1095();
		addProperty1096();
		addProperty1097();
		addProperty1098();
		addProperty1099();
		addProperty1100();
		addProperty1101();
		addProperty1102();
		addProperty1103();
		addProperty1104();
		addProperty1105();
		addProperty1106();
		addProperty1107();
		addProperty1108();
		addProperty1109();
		addProperty1110();
		addProperty1111();
		addProperty1112();
		addProperty1113();
		addProperty1114();
		addProperty1115();
		addProperty1116();
		addProperty1117();
		addProperty1118();
		addProperty1119();
		addProperty1120();
		addProperty1121();
		addProperty1122();
		addProperty1123();
		addProperty1124();
		addProperty1125();
		addProperty1126();
		addProperty1127();
		addProperty1128();
		addProperty1129();
		addProperty1130();
		addProperty1131();
		addProperty1132();
		addProperty1133();
		addProperty1134();
		addProperty1135();
		addProperty1136();
		addProperty1137();
		addProperty1138();
		addProperty1139();
		addProperty1140();
		addProperty1141();
		addProperty1142();
		addProperty1143();
		addProperty1144();
		addProperty1145();
		addProperty1146();
		addProperty1147();
		addProperty1148();
		addProperty1149();
		addProperty1150();
		addProperty1151();
		addProperty1152();
		addProperty1153();
		addProperty1154();
		addProperty1155();
		addProperty1156();
		addProperty1157();
		addProperty1158();
		addProperty1159();
		addProperty1160();
		addProperty1161();
		addProperty1162();
		addProperty1163();
		addProperty1164();
		addProperty1165();
		addProperty1166();
		addProperty1167();
		addProperty1168();
		addProperty1169();
		addProperty1170();
		addProperty1171();
		addProperty1172();
		addProperty1173();
		addProperty1174();
		addProperty1175();
		addProperty1176();
		addProperty1177();
		addProperty1178();
		addProperty1179();
		addProperty1180();
		addProperty1181();
		addProperty1182();
		addProperty1183();
		addProperty1184();
		addProperty1185();
		addPropertyAliases();
	}

	private static String normalize(String propertyCodeOrAlias) {
		return propertyCodeOrAlias.toLowerCase(Locale.US).replace('-', '_');
	}

	/**
	 * Given a Unicode property (general category code, binary property name, or script name),
	 * returns the {@link IntervalSet} of Unicode code point ranges which have that property.
	 */
	public static IntervalSet getPropertyCodePoints(String propertyCodeOrAlias) {
		String normalizedPropertyCodeOrAlias = normalize(propertyCodeOrAlias);
		IntervalSet result = propertyCodePointRanges.get(normalizedPropertyCodeOrAlias);
		if (result == null) {
			String propertyCode = propertyAliases.get(normalizedPropertyCodeOrAlias);
			result = propertyCodePointRanges.get(propertyCode);
		}
		return result;
	}
}