/*
 * Copyright (C) 2002  Free Software Foundation, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

package javax.crypto.interfaces;

/**
 * An interface to a key used in <i>password-based encryption</i>
 * (<b>PBE</b>). Typically, keys that are known to be derived from
 * passwords can be cast to instances of a PBEKey.
 *
 * @since JDK 1.4
 * @see javax.crypto.SecretKey
 * @see javax.crypto.spec.PBEKeySpec
 */
public interface PBEKey extends javax.crypto.SecretKey
{

  // Constant.
  // ------------------------------------------------------------------------

  /** Compatible with JDK1.4. */
  static final long serialVersionUID = -1430015993304333921L;  

  // Abstract methods.
  // ------------------------------------------------------------------------

  /**
   * Returns the iteration count, or 0 if not specified.
   *
   * @return The iteration count.
   */
  int getIterationCount();

  /**
   * Returns a copy of the password as a character array. It is the
   * caller's responsibility to keep this password safe and to zero-out
   * the password when it is no longer in use.
   *
   * <p>Although it is not specified in the documentation,
   * implementations should not copy or clone the password array, but
   * rather return the reference to the array itself, so the caller has
   * the ability to erase the password.
   *
   * @return The password.
   */
  char[] getPassword();

  /**
   * Returns the salt. The semantics that apply to the password array
   * also apply here (though the salt need not necessarily be kept
   * secret).
   *
   * @return The salt.
   */
  byte[] getSalt();
}
