/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CoolItemInfo;
import org.eclipse.wb.internal.xwt.support.ControlSupport;

public final class CoolBarInfo
extends CompositeInfo {
    public CoolBarInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
    }

    public boolean isHorizontal() {
        return ControlSupport.hasStyle((Widget)this.getControl(), 256);
    }

    public List<CoolItemInfo> getItems() {
        return this.getChildren(CoolItemInfo.class);
    }

    @Override
    protected void refresh_afterCreate() throws Exception {
        super.refresh_afterCreate();
        for (CoolItemInfo itemInfo : this.getItems()) {
            CoolItem item = (CoolItem)itemInfo.getObject();
            if (CoolBarInfo.hasExplicitSize(itemInfo)) continue;
            Control control = item.getControl();
            if (control == null) {
                item.setSize(20, 25);
                continue;
            }
            Point control_preferredSize = control.computeSize(-1, -1);
            Point item_preferredSize = item.computeSize(control_preferredSize.x, control_preferredSize.y);
            item.setSize(item_preferredSize);
        }
    }

    private static boolean hasExplicitSize(CoolItemInfo item) {
        DocumentElement element = item.getCreationSupport().getElement();
        return element.getAttribute("size") != null || element.getAttribute("preferredSize") != null;
    }
}

