/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.rules;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.digester3.Rule;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.model.property.accessor.SetterAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.xml.sax.Attributes;

public final class StandardBeanPropertiesRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        ComponentDescription componentDescription = (ComponentDescription)this.getDigester().peek();
        List descriptors = ReflectionUtils.getPropertyDescriptors((BeanInfo)componentDescription.getBeanInfo(), componentDescription.getComponentClass());
        componentDescription.setPropertyDescriptors(descriptors);
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            String propertyName = propertyDescriptor.getName();
            Method setMethod = ReflectionUtils.getWriteMethod((PropertyDescriptor)propertyDescriptor);
            Method getMethod = ReflectionUtils.getReadMethod((PropertyDescriptor)propertyDescriptor);
            if (setMethod == null) continue;
            GenericPropertyDescription propertyDescription = StandardBeanPropertiesRule.addSingleProperty(componentDescription, propertyName, setMethod, getMethod);
            StandardBeanPropertiesRule.tryToSetPropertyEditorAWT(propertyDescriptor, propertyDescription);
            if (!propertyDescriptor.isPreferred()) continue;
            propertyDescription.setCategory(PropertyCategory.PREFERRED);
        }
    }

    private static void tryToSetPropertyEditorAWT(PropertyDescriptor propertyDescriptor, GenericPropertyDescription propertyDescription) throws Exception {
        PropertyEditor editor = DescriptionPropertiesHelper.getEditorForPropertyDescriptor(propertyDescriptor);
        if (editor != null) {
            propertyDescription.setEditor(editor);
            return;
        }
        Class<?> propertyEditorType = propertyDescriptor.getPropertyEditorClass();
        if (propertyEditorType != null) {
            PropertyEditor editor2 = DescriptionPropertiesHelper.getEditorForEditorType(propertyEditorType);
            propertyDescription.setEditor(editor2);
        }
    }

    static GenericPropertyDescription addSingleProperty(ComponentDescription componentDescription, String title, Method setMethod, Method getMethod) throws Exception {
        MethodDescription methodDescription = componentDescription.addMethod(setMethod);
        ParameterDescription parameter = methodDescription.getParameter(0);
        parameter.setName(title);
        String id = StandardBeanPropertiesRule.getId(setMethod);
        Class<?> type = parameter.getType();
        SetterAccessor accessor = new SetterAccessor(setMethod, getMethod);
        ExpressionConverter converter = parameter.getConverter();
        PropertyEditor editor = parameter.getEditor();
        GenericPropertyDescription propertyDescription = new GenericPropertyDescription(id, title, type);
        propertyDescription.addAccessor(accessor);
        propertyDescription.setConverter(converter);
        propertyDescription.setEditor(editor);
        componentDescription.addProperty(propertyDescription);
        return propertyDescription;
    }

    public static String getId(Method setMethod) {
        return ReflectionUtils.getMethodSignature((Method)setMethod);
    }
}

