/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.policies;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;

public class CompoundSelectionEditPolicy
extends SelectionEditPolicy {
    private final List<SelectionEditPolicy> m_policies;

    public CompoundSelectionEditPolicy(List<SelectionEditPolicy> policies) {
        this.m_policies = policies;
    }

    @Override
    public void setHost(EditPart host) {
        super.setHost(host);
        for (SelectionEditPolicy policy : this.m_policies) {
            policy.setHost(host);
        }
    }

    @Override
    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        for (SelectionEditPolicy policy : this.m_policies) {
            policy.createSelectionHandles();
        }
        return handles;
    }

    @Override
    protected void showSelection() {
        for (SelectionEditPolicy policy : this.m_policies) {
            policy.showSelection();
        }
    }

    @Override
    protected void hideSelection() {
        for (SelectionEditPolicy policy : this.m_policies) {
            policy.hideSelection();
        }
    }

    @Override
    public void showSourceFeedback(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            if (!policy.understandsRequest(request)) continue;
            policy.showSourceFeedback(request);
        }
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            if (!policy.understandsRequest(request)) continue;
            policy.eraseSourceFeedback(request);
        }
    }

    @Override
    public void performRequest(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            policy.performRequest(request);
        }
    }

    @Override
    public boolean understandsRequest(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            if (!policy.understandsRequest(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            EditPart targetEditPart = policy.getTargetEditPart(request);
            if (targetEditPart == null) continue;
            return targetEditPart;
        }
        return null;
    }

    @Override
    public Command getCommand(Request request) {
        for (SelectionEditPolicy policy : this.m_policies) {
            Command command;
            if (!policy.understandsRequest(request) || (command = policy.getCommand(request)) == null) continue;
            return command;
        }
        return null;
    }
}

