/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;

public abstract class Tool {
    private boolean m_active;
    private IEditPartViewer m_viewer;
    private EditDomain m_domain;
    private boolean m_canUnload = true;
    private List<EditPart> m_operationSet;
    private Command m_command;
    private Cursor m_defaultCursor;
    private Cursor m_disabledCursor;
    protected static final int STATE_NONE = 0;
    protected static final int STATE_INIT = 1;
    protected static final int STATE_DRAG = 2;
    protected static final int STATE_DRAG_IN_PROGRESS = 3;
    protected static final int STATE_INVALID = 4;
    private static final int DRAG_THRESHOLD = 5;
    protected int m_currentScreenX;
    protected int m_currentScreenY;
    protected int m_stateMask;
    protected int m_button;
    protected int m_startScreenX;
    protected int m_startScreenY;
    protected int m_state;
    private boolean m_canPastThreshold;

    public void activate() {
        this.resetState();
        this.m_state = 1;
        this.m_active = true;
    }

    public void deactivate() {
        this.m_active = false;
        this.setCommand(null);
        this.m_operationSet = null;
    }

    public final boolean isActive() {
        return this.m_active;
    }

    public final IEditPartViewer getViewer() {
        return this.m_viewer;
    }

    public final void setViewer(IEditPartViewer viewer) {
        if (this.m_viewer != viewer) {
            this.setCursor(null);
            this.m_viewer = viewer;
            if (this.m_viewer != null) {
                Point mouseLocation = this.m_viewer.getControl().toControl(Display.getCurrent().getCursorLocation());
                this.m_currentScreenX = mouseLocation.x;
                this.m_currentScreenY = mouseLocation.y;
            }
            this.refreshCursor();
        }
    }

    public final EditDomain getDomain() {
        return this.m_domain;
    }

    public final void setDomain(EditDomain domain) {
        this.m_domain = domain;
    }

    protected final boolean unloadWhenFinished() {
        return this.m_canUnload;
    }

    public final void setUnloadWhenFinished(boolean value) {
        this.m_canUnload = value;
    }

    protected void handleFinished() {
        if (this.m_canUnload) {
            this.m_domain.loadDefaultTool();
        } else {
            Event event = null;
            if (this.m_viewer != null) {
                event = new Event();
                event.display = Display.getCurrent();
                event.widget = this.m_viewer.getControl();
                event.type = 5;
                event.x = this.m_currentScreenX;
                event.y = this.m_currentScreenY;
                event.button = this.m_button;
                event.stateMask = this.m_stateMask;
            }
            this.deactivate();
            this.activate();
            if (this.m_viewer != null) {
                this.mouseMove(new MouseEvent(event), this.m_viewer);
            }
        }
    }

    protected final List<EditPart> getOperationSet() {
        if (this.m_operationSet == null) {
            this.m_operationSet = this.createOperationSet();
        }
        return this.m_operationSet;
    }

    protected List<EditPart> createOperationSet() {
        return new ArrayList<EditPart>(this.m_viewer.getSelectedEditParts());
    }

    protected final void executeCommand() {
        if (this.m_command != null) {
            Command command = this.m_command;
            this.setCommand(null);
            this.m_domain.executeCommand(command);
        }
    }

    protected final void setCommand(Command command) {
        this.m_command = command;
        this.refreshCursor();
    }

    protected Command getCommand() {
        return null;
    }

    protected final void updateCommand() {
        this.setCommand(this.getCommand());
    }

    protected Cursor getDefaultCursor() {
        return this.m_defaultCursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        if (this.m_defaultCursor != cursor) {
            this.m_defaultCursor = cursor;
            this.refreshCursor();
        }
    }

    protected Cursor getDisabledCursor() {
        return this.m_disabledCursor == null ? this.getDefaultCursor() : this.m_disabledCursor;
    }

    public void setDisabledCursor(Cursor cursor) {
        if (this.m_disabledCursor != cursor) {
            this.m_disabledCursor = cursor;
            this.refreshCursor();
        }
    }

    protected Cursor calculateCursor() {
        if (this.m_state == 0) {
            return null;
        }
        if (this.m_command == null) {
            return this.getDisabledCursor();
        }
        return this.getDefaultCursor();
    }

    protected void setCursor(Cursor cursor) {
        if (this.m_viewer != null) {
            this.m_viewer.setCursor(cursor);
        }
    }

    public void refreshCursor() {
        if (this.isActive()) {
            this.setCursor(this.calculateCursor());
        }
    }

    private void setEvent(MouseEvent event) {
        this.m_currentScreenX = event.x;
        this.m_currentScreenY = event.y;
        this.m_stateMask = event.stateMask;
        this.m_button = event.button;
    }

    private boolean movedPastThreshold() {
        if (!this.m_canPastThreshold) {
            this.m_canPastThreshold = Math.abs(this.m_startScreenX - this.m_currentScreenX) > 5 || Math.abs(this.m_startScreenY - this.m_currentScreenY) > 5;
        }
        return this.m_canPastThreshold;
    }

    public void mouseDown(MouseEvent event, IEditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.m_startScreenX = event.x;
        this.m_startScreenY = event.y;
        this.handleButtonDown(event.button);
    }

    public void mouseUp(MouseEvent event, IEditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.handleButtonUp(event.button);
    }

    public void mouseDrag(MouseEvent event, IEditPartViewer viewer) {
        this.setViewer(viewer);
        boolean wasDragging = this.movedPastThreshold();
        this.setEvent(event);
        this.handleDrag();
        if (this.movedPastThreshold()) {
            if (!wasDragging) {
                this.handleDragStarted();
            }
            this.handleDragInProgress();
        }
    }

    public void mouseMove(MouseEvent event, IEditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        if (this.m_state == 3) {
            this.handleDragInProgress();
        } else {
            this.handleMove();
        }
    }

    public void mouseDoubleClick(MouseEvent event, IEditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.handleDoubleClick(event.button);
    }

    public void viewerEntered(MouseEvent event, IEditPartViewer viewer) {
        this.setEvent(event);
        if (this.m_viewer != null) {
            this.handleViewerExited();
        }
        this.setViewer(viewer);
        this.handleViewerEntered();
    }

    public void viewerExited(MouseEvent event, IEditPartViewer viewer) {
        if (this.m_viewer == viewer) {
            this.setEvent(event);
            this.handleViewerExited();
            this.setViewer(null);
        }
    }

    protected void handleButtonDown(int button) {
    }

    protected void handleButtonUp(int button) {
    }

    protected void handleMove() {
    }

    protected void handleDrag() {
    }

    protected void handleDragStarted() {
    }

    protected void handleDragInProgress() {
    }

    protected void handleDoubleClick(int button) {
    }

    protected void handleViewerEntered() {
    }

    protected void handleViewerExited() {
    }

    public final org.eclipse.wb.draw2d.geometry.Point getLocation() {
        return new org.eclipse.wb.draw2d.geometry.Point(this.m_currentScreenX + this.m_viewer.getHOffset(), this.m_currentScreenY + this.m_viewer.getVOffset());
    }

    protected org.eclipse.wb.draw2d.geometry.Point getStartLocation() {
        return new org.eclipse.wb.draw2d.geometry.Point(this.m_startScreenX + this.m_viewer.getHOffset(), this.m_startScreenY + this.m_viewer.getVOffset());
    }

    protected Dimension getDragMoveDelta() {
        return this.getLocation().getDifference(this.getStartLocation());
    }

    protected void resetState() {
        this.m_currentScreenX = 0;
        this.m_currentScreenY = 0;
        this.m_stateMask = 0;
        this.m_button = 0;
        this.m_startScreenX = 0;
        this.m_startScreenY = 0;
        this.m_canPastThreshold = false;
    }

    public void keyPressed(KeyEvent event, IEditPartViewer viewer) {
    }

    public void keyReleased(KeyEvent event, IEditPartViewer viewer) {
    }
}

