/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.forms.layout.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildGraphical;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.util.grid.GridAlignmentHelper;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.IPreferenceConstants;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.ITableWrapDataInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.ITableWrapLayoutInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapColumnInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapData2;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayout2;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutAssistant;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutConverter;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapLayoutSupport;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.TableWrapRowInfo;
import org.eclipse.wb.internal.rcp.model.forms.layout.table.actions.SelectionActionsSupport;
import org.eclipse.wb.internal.swt.model.layout.ILayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.support.LabelSupport;
import org.eclipse.wb.internal.xwt.model.forms.layout.table.TableWrapDataInfo;
import org.eclipse.wb.internal.xwt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.LayoutDataClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public final class TableWrapLayoutInfo
extends LayoutInfo
implements ITableWrapLayoutInfo<ControlInfo>,
IPreferenceConstants {
    private boolean m_replaceWithFillers = true;
    private TableWrapDataInfo m_removingLayoutData;
    private final List<TableWrapColumnInfo<ControlInfo>> m_columns = Lists.newArrayList();
    private final List<TableWrapRowInfo<ControlInfo>> m_rows = Lists.newArrayList();
    private IGridInfo m_gridInfo;
    private int[] m_columnOrigins;
    private int[] m_rowOrigins;
    private int[] m_columnWidths;
    private int[] m_rowHeights;

    public TableWrapLayoutInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        new TableWrapLayoutAssistant((ILayoutInfo)this);
        new SelectionActionsSupport((ITableWrapLayoutInfo)this);
    }

    @Override
    public void onSet() throws Exception {
        super.onSet();
        this.getRoot().refreshLight();
        TableWrapLayoutConverter.convert((ICompositeInfo)this.getComposite(), (ITableWrapLayoutInfo)this);
    }

    @Override
    protected void onDelete() throws Exception {
        for (ControlInfo control : this.getControls()) {
            if (!this.isFiller(control)) continue;
            control.delete();
        }
        super.onDelete();
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new ObjectInfoChildTree(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof ControlInfo) {
                    visible[0] = visible[0] & !TableWrapLayoutInfo.this.isFiller((ControlInfo)object);
                }
            }
        });
        this.addBroadcastListener(new ObjectInfoChildGraphical(){

            public void invoke(ObjectInfo object, boolean[] visible) throws Exception {
                if (object instanceof ControlInfo) {
                    visible[0] = visible[0] & !TableWrapLayoutInfo.this.isFiller((ControlInfo)object);
                }
            }
        });
    }

    public void refresh_dispose() throws Exception {
        this.m_gridInfo = null;
        super.refresh_dispose();
    }

    protected void refresh_afterCreate() throws Exception {
        this.replaceLayoutObjects();
        super.refresh_afterCreate();
        this.fixEmptyColumns();
    }

    private void fixEmptyColumns() throws Exception {
        this.fetchLayoutDataValues();
        ControlInfo[][] grid = this.getControlsGrid();
        int columnCount = grid.length != 0 ? grid[0].length : 0;
        this.m_columnWidths = TableWrapLayoutSupport.getColumnWidths((Object)this.getObject());
        int column = 0;
        while (column < columnCount) {
            int width = this.m_columnWidths[column];
            if (width == 0) {
                int row = 0;
                while (row < grid.length) {
                    ControlInfo control = grid[row][column];
                    if (control != null && this.isFiller(control)) {
                        LabelSupport.setText((Object)control.getObject(), (String)"      ");
                    }
                    ++row;
                }
            }
            ++column;
        }
    }

    private void fetchLayoutDataValues() throws Exception {
        for (ControlInfo control : this.getControls()) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            layoutData.refresh_fetch();
        }
    }

    protected void refresh_fetch() throws Exception {
        super.refresh_fetch();
        Object layoutObject = this.getObject();
        this.m_columnOrigins = TableWrapLayoutSupport.getColumnOrigins((Object)layoutObject);
        this.m_rowOrigins = TableWrapLayoutSupport.getRowOrigins((Object)layoutObject);
        this.m_columnWidths = TableWrapLayoutSupport.getColumnWidths((Object)layoutObject);
        this.m_rowHeights = TableWrapLayoutSupport.getRowHeights((Object)layoutObject);
    }

    private void replaceLayoutObjects() throws Exception {
        Composite composite = (Composite)this.getComposite().getObject();
        Layout layout = composite.getLayout();
        if (layout.getClass().getName().equals("org.eclipse.ui.forms.widgets.TableWrapLayout")) {
            TableWrapLayout2 newLayout = new TableWrapLayout2();
            TableWrapLayoutInfo.copyFields(layout, newLayout);
            composite.setLayout((Layout)newLayout);
            this.setObject(newLayout);
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Object layoutData = child.getLayoutData();
            if (layoutData != null && layoutData.getClass().getName().equals("org.eclipse.ui.forms.widgets.TableWrapData")) {
                TableWrapData2 newLayoutData = new TableWrapData2();
                TableWrapLayoutInfo.copyFields(layoutData, newLayoutData);
                child.setLayoutData((Object)newLayoutData);
            }
            ++n2;
        }
        composite.layout();
        for (ControlInfo controlInfo : this.getControls()) {
            Control control = (Control)controlInfo.getObject();
            Object layoutData = control.getLayoutData();
            if (layoutData == null) continue;
            TableWrapDataInfo layoutDataInfo = this.getTableWrapData(controlInfo);
            layoutDataInfo.setObject(layoutData);
        }
    }

    private static void copyFields(Object source, Object target) throws Exception {
        Field[] fieldArray = source.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                Object value = field.get(source);
                ReflectionUtils.setField((Object)target, (String)field.getName(), (Object)value);
            }
            ++n2;
        }
    }

    @Override
    protected void onControlRemoveBefore(ControlInfo control) throws Exception {
        this.m_removingLayoutData = this.getTableWrapData(control);
        super.onControlRemoveBefore(control);
    }

    @Override
    protected void onControlRemoveAfter(ControlInfo control) throws Exception {
        if (this.m_replaceWithFillers && !this.isFiller(control)) {
            TableWrapDataInfo layoutData = this.m_removingLayoutData;
            int x = layoutData.x;
            while (x < layoutData.x + layoutData.width) {
                int y = layoutData.y;
                while (y < layoutData.y + layoutData.height) {
                    this.addFiller(x, y);
                    ++y;
                }
                ++x;
            }
            this.deleteEmptyColumnsRows(this.m_removingLayoutData);
            this.m_removingLayoutData = null;
        }
        super.onControlRemoveAfter(control);
    }

    public ITableWrapDataInfo getTableWrapData2(ControlInfo control) {
        return this.getTableWrapData(control);
    }

    public TableWrapDataInfo getTableWrapData(final ControlInfo control) {
        return (TableWrapDataInfo)((Object)ExecutionUtils.runObject((RunnableObjectEx)new RunnableObjectEx<TableWrapDataInfo>(){

            public TableWrapDataInfo runObject() throws Exception {
                TableWrapDataInfo layoutData = (TableWrapDataInfo)TableWrapLayoutInfo.getLayoutData(control);
                layoutData.initialize(TableWrapLayoutInfo.this, control);
                return layoutData;
            }
        }));
    }

    void deleteEmptyColumnsRows(TableWrapDataInfo removingData) throws Exception {
        this.deleteEmptyColumns(removingData);
        this.deleteEmptyRows(removingData);
    }

    private void deleteEmptyColumns(TableWrapDataInfo removingData) throws Exception {
        ControlInfo[][] grid = this.getControlsGrid();
        boolean deleteOnlyIfIsRemovingColumn = false;
        int column = grid[0].length - 1;
        while (column >= 0) {
            boolean isRemovingColumn = removingData != null && removingData.x <= column && column < removingData.x + removingData.width;
            boolean isEmpty = true;
            int row = 0;
            while (row < grid.length) {
                ControlInfo control = grid[row][column];
                isEmpty &= this.isFiller(control);
                ++row;
            }
            if (isEmpty && (!deleteOnlyIfIsRemovingColumn || isRemovingColumn)) {
                this.command_deleteColumn(column, false);
            } else {
                deleteOnlyIfIsRemovingColumn = true;
            }
            --column;
        }
    }

    private void deleteEmptyRows(TableWrapDataInfo removingData) throws Exception {
        ControlInfo[][] grid = this.getControlsGrid();
        boolean deleteOnlyIfIsRemovingRow = false;
        int row = grid.length - 1;
        while (row >= 0) {
            boolean isRemovingRow = removingData != null && removingData.y <= row && row < removingData.y + removingData.height;
            boolean isEmpty = true;
            int column = 0;
            while (column < grid[row].length) {
                ControlInfo control = grid[row][column];
                isEmpty &= this.isFiller(control);
                ++column;
            }
            if (isEmpty && (!deleteOnlyIfIsRemovingRow || isRemovingRow)) {
                this.command_deleteRow(row, false);
            } else {
                deleteOnlyIfIsRemovingRow = true;
            }
            --row;
        }
    }

    public void command_deleteColumn(int column, boolean deleteEmptyRows) throws Exception {
        int columnCount = this.getControlsGridSize().width;
        this.m_replaceWithFillers = false;
        try {
            for (ControlInfo control : this.getControls()) {
                TableWrapDataInfo layoutData = this.getTableWrapData(control);
                if (layoutData.x == column) {
                    control.delete();
                    continue;
                }
                if (layoutData.x > column) {
                    --layoutData.x;
                    continue;
                }
                if (layoutData.x + layoutData.width <= column) continue;
                layoutData.setHorizontalSpan(layoutData.width - 1);
            }
        }
        finally {
            this.m_replaceWithFillers = true;
        }
        if (columnCount >= 2) {
            this.getPropertyByTitle("numColumns").setValue((Object)(columnCount - 1));
        }
        if (deleteEmptyRows) {
            this.deleteEmptyRows(null);
        }
    }

    public void command_deleteRow(int row, boolean deleteEmptyColumn) throws Exception {
        this.m_replaceWithFillers = false;
        try {
            for (ControlInfo control : this.getControls()) {
                TableWrapDataInfo layoutData = this.getTableWrapData(control);
                if (layoutData.y == row) {
                    control.delete();
                    continue;
                }
                if (layoutData.y > row) {
                    --layoutData.y;
                    continue;
                }
                if (layoutData.y + layoutData.height <= row) continue;
                layoutData.setVerticalSpan(layoutData.height - 1);
            }
        }
        finally {
            this.m_replaceWithFillers = true;
        }
        if (deleteEmptyColumn) {
            this.deleteEmptyColumns(null);
        }
    }

    public void command_MOVE_COLUMN(int fromIndex, int toIndex) throws Exception {
        this.fixGrid();
        this.getColumns();
        TableWrapColumnInfo<ControlInfo> column = this.m_columns.remove(fromIndex);
        if (fromIndex < toIndex) {
            this.m_columns.add(toIndex - 1, column);
        } else {
            this.m_columns.add(toIndex, column);
        }
        this.prepareCell(toIndex, true, -1, false);
        if (toIndex < fromIndex) {
            ++fromIndex;
        }
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            if (layoutData.x != fromIndex) continue;
            this.command_setCells(control, new Rectangle(toIndex, layoutData.y, 1, layoutData.height), true);
        }
        this.command_deleteColumn(fromIndex, false);
        this.deleteEmptyColumnsRows(null);
    }

    public void command_MOVE_ROW(int fromIndex, int toIndex) throws Exception {
        this.fixGrid();
        this.getRows();
        TableWrapRowInfo<ControlInfo> row = this.m_rows.remove(fromIndex);
        if (fromIndex < toIndex) {
            this.m_rows.add(toIndex - 1, row);
        } else {
            this.m_rows.add(toIndex, row);
        }
        this.prepareCell(-1, false, toIndex, true);
        if (toIndex < fromIndex) {
            ++fromIndex;
        }
        for (ControlInfo control : this.getControls()) {
            if (this.isFiller(control)) continue;
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            if (layoutData.y != fromIndex) continue;
            this.command_setCells(control, new Rectangle(layoutData.x, toIndex, layoutData.width, 1), true);
        }
        this.command_deleteRow(fromIndex, false);
        this.deleteEmptyColumnsRows(null);
    }

    public List<TableWrapColumnInfo<ControlInfo>> getColumns() {
        Dimension size = this.getControlsGridSize();
        if (this.m_columns.size() != size.width) {
            this.m_columns.clear();
            int i = 0;
            while (i < size.width) {
                this.m_columns.add((TableWrapColumnInfo<ControlInfo>)new TableWrapColumnInfo((ITableWrapLayoutInfo)this));
                ++i;
            }
        }
        return this.m_columns;
    }

    public List<TableWrapRowInfo<ControlInfo>> getRows() {
        Dimension size = this.getControlsGridSize();
        if (this.m_rows.size() != size.height) {
            this.m_rows.clear();
            int i = 0;
            while (i < size.height) {
                this.m_rows.add((TableWrapRowInfo<ControlInfo>)new TableWrapRowInfo((ITableWrapLayoutInfo)this));
                ++i;
            }
        }
        return this.m_rows;
    }

    public void command_CREATE(ControlInfo newControl, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.command_CREATE(newControl, null);
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(newControl, new Rectangle(column, row, 1, 1), false);
            this.doAutomaticAlignment(newControl);
        }
        finally {
            this.endEdit();
        }
    }

    public void command_MOVE(ControlInfo control, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(control, new Rectangle(column, row, 1, 1), true);
            this.deleteEmptyColumnsRows(null);
        }
        finally {
            this.endEdit();
        }
    }

    public void command_ADD(ControlInfo control, int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        this.startEdit();
        try {
            this.command_MOVE(control, null);
            this.prepareCell(column, insertColumn, row, insertRow);
            this.command_setCells(control, new Rectangle(column, row, 1, 1), false);
        }
        finally {
            this.endEdit();
        }
    }

    private void prepareCell(int column, boolean insertColumn, int row, boolean insertRow) throws Exception {
        int i;
        Dimension gridSize = this.getControlsGridSize();
        int columnCount = gridSize.width;
        int rowCount = gridSize.height;
        int newColumnCount = Math.max(columnCount, 1 + column);
        int newRowCount = Math.max(rowCount, 1 + row);
        int newRow = rowCount;
        while (newRow <= row) {
            int columnIndex = 0;
            while (columnIndex < newColumnCount) {
                this.addFiller(columnIndex, newRow);
                ++columnIndex;
            }
            ++newRow;
        }
        this.getPropertyByTitle("numColumns").setValue((Object)newColumnCount);
        int newColumn = columnCount;
        while (newColumn <= column) {
            int rowIndex = 0;
            while (rowIndex < rowCount) {
                this.addFiller(newColumn, rowIndex);
                ++rowIndex;
            }
            ++newColumn;
        }
        columnCount = newColumnCount;
        rowCount = newRowCount;
        if (insertRow) {
            ++rowCount;
            boolean[] columnsToIgnore = new boolean[columnCount];
            for (ControlInfo control : this.getControls()) {
                TableWrapDataInfo layoutData = this.getTableWrapData(control);
                if (layoutData.y >= row) {
                    ++layoutData.y;
                    continue;
                }
                if (layoutData.y + layoutData.height <= row) continue;
                layoutData.setVerticalSpan(layoutData.height + 1);
                i = layoutData.x;
                while (i < layoutData.x + layoutData.width) {
                    columnsToIgnore[i] = true;
                    ++i;
                }
            }
            int i2 = 0;
            while (i2 < columnCount) {
                if (!columnsToIgnore[i2]) {
                    this.addFiller(i2, row);
                }
                ++i2;
            }
        }
        if (insertColumn) {
            boolean[] rowsToIgnore = new boolean[rowCount];
            for (ControlInfo control : this.getControls()) {
                TableWrapDataInfo layoutData = this.getTableWrapData(control);
                if (layoutData.x >= column) {
                    ++layoutData.x;
                    continue;
                }
                if (layoutData.x + layoutData.width <= column) continue;
                layoutData.setHorizontalSpan(layoutData.width + 1);
                i = layoutData.y;
                while (i < layoutData.y + layoutData.height) {
                    rowsToIgnore[i] = true;
                    ++i;
                }
            }
            this.getPropertyByTitle("numColumns").setValue((Object)(columnCount + 1));
            int i3 = 0;
            while (i3 < rowCount) {
                if (!rowsToIgnore[i3]) {
                    this.addFiller(column, i3);
                }
                ++i3;
            }
        }
    }

    public void command_setCells(ControlInfo control, Rectangle cells, boolean forMove) throws Exception {
        Point cell;
        int y;
        int x;
        TableWrapDataInfo layoutData = this.getTableWrapData(control);
        this.fixGrid();
        ControlInfo[][] grid = this.getControlsGrid();
        HashSet cellsToAddFillers = Sets.newHashSet();
        HashSet cellsToRemoveFillers = Sets.newHashSet();
        if (forMove) {
            x = layoutData.x;
            while (x < layoutData.x + layoutData.width) {
                y = layoutData.y;
                while (y < layoutData.y + layoutData.height) {
                    cell = new Point(x, y);
                    cellsToAddFillers.add(cell);
                    ++y;
                }
                ++x;
            }
        }
        x = cells.x;
        while (x < cells.right()) {
            y = cells.y;
            while (y < cells.bottom()) {
                cell = new Point(x, y);
                cellsToAddFillers.remove(cell);
                if (this.isFiller(grid[y][x])) {
                    cellsToRemoveFillers.add(cell);
                }
                ++y;
            }
            ++x;
        }
        this.startEdit();
        try {
            if (layoutData.x != cells.x || layoutData.y != cells.y) {
                layoutData.x = cells.x;
                layoutData.y = cells.y;
                ControlInfo reference = this.getReferenceControl(cells.y, cells.x, control);
                this.command_MOVE(control, reference);
            }
            layoutData.setHorizontalSpan(cells.width);
            layoutData.setVerticalSpan(cells.height);
            for (Point cell2 : cellsToRemoveFillers) {
                ControlInfo filler = grid[cell2.y][cell2.x];
                filler.delete();
            }
            for (Point cell3 : cellsToAddFillers) {
                this.addFiller(cell3.x, cell3.y);
            }
        }
        finally {
            this.endEdit();
        }
    }

    public void command_setHeightHint(ControlInfo control, int size) throws Exception {
        this.startEdit();
        try {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            layoutData.setHeightHint(size);
        }
        finally {
            this.endEdit();
        }
    }

    private Dimension getControlsGridSize() {
        int columnCount = 0;
        int rowCount = 0;
        for (ControlInfo control : this.getControls()) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            columnCount = Math.max(columnCount, layoutData.x + layoutData.width);
            rowCount = Math.max(rowCount, layoutData.y + layoutData.height);
        }
        return new Dimension(columnCount, rowCount);
    }

    private ControlInfo[][] getControlsGrid() throws Exception {
        Dimension gridSize = this.getControlsGridSize();
        ControlInfo[][] grid = new ControlInfo[gridSize.height][];
        int rowIndex = 0;
        while (rowIndex < grid.length) {
            grid[rowIndex] = new ControlInfo[gridSize.width];
            ++rowIndex;
        }
        for (ControlInfo control : this.getControls()) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            Rectangle cells = new Rectangle(layoutData.x, layoutData.y, layoutData.width, layoutData.height);
            int x = cells.x;
            while (x < cells.right()) {
                int y = cells.y;
                while (y < cells.bottom()) {
                    if (x != -1 && y != -1) {
                        grid[y][x] = control;
                    }
                    ++y;
                }
                ++x;
            }
        }
        return grid;
    }

    public void fixGrid() throws Exception {
        ControlInfo[][] grid = this.getControlsGrid();
        int row = 0;
        while (row < grid.length) {
            int column = 0;
            while (column < grid[row].length) {
                if (grid[row][column] == null) {
                    this.addFiller(column, row);
                }
                ++column;
            }
            ++row;
        }
    }

    private ControlInfo getReferenceControl(int row, int column, ControlInfo exclude) throws Exception {
        for (ControlInfo control : this.getControls()) {
            if (control == exclude) continue;
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            if (layoutData.y <= row && (layoutData.y != row || layoutData.x < column)) continue;
            return control;
        }
        return null;
    }

    private void addFiller(int column, int row) throws Exception {
        ElementCreationSupport creationSupport = new ElementCreationSupport(null, false);
        ControlInfo filler = (ControlInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), Label.class, (CreationSupport)creationSupport);
        ControlInfo reference = this.getReferenceControl(row, column, null);
        XmlObjectUtils.add((XmlObjectInfo)filler, (Association)Associations.direct(), (XmlObjectInfo)this.getComposite(), (XmlObjectInfo)reference);
        TableWrapDataInfo layoutData = this.getTableWrapData(filler);
        layoutData.x = column;
        layoutData.y = row;
    }

    private void doAutomaticAlignment(ControlInfo control) throws Exception {
        final IPreferenceStore preferences = this.getDescription().getToolkit().getPreferences();
        GridAlignmentHelper.doAutomaticAlignment((IAbstractComponentInfo)control, (GridAlignmentHelper.IAlignmentProcessor)new GridAlignmentHelper.IAlignmentProcessor<ControlInfo>(){

            public boolean grabEnabled() {
                return preferences.getBoolean("TableWrapLayout.enableGrab");
            }

            public boolean rightEnabled() {
                return preferences.getBoolean("TableWrapLayout.enableRightAlignment");
            }

            public ControlInfo getComponentAtLeft(ControlInfo component) {
                TableWrapDataInfo layoutData = TableWrapLayoutInfo.this.getTableWrapData(component);
                return TableWrapLayoutInfo.this.getControlAt(layoutData.x - 1, layoutData.y);
            }

            public ControlInfo getComponentAtRight(ControlInfo component) {
                TableWrapDataInfo layoutData = TableWrapLayoutInfo.this.getTableWrapData(component);
                return TableWrapLayoutInfo.this.getControlAt(layoutData.x + 1, layoutData.y);
            }

            public void setGrabFill(ControlInfo component, boolean horizontal) throws Exception {
                TableWrapDataInfo layoutData = TableWrapLayoutInfo.this.getTableWrapData(component);
                if (horizontal) {
                    layoutData.setHorizontalGrab(true);
                    layoutData.setHorizontalAlignment(128);
                } else {
                    layoutData.setVerticalGrab(true);
                    layoutData.setVerticalAlignment(128);
                }
            }

            public void setRightAlignment(ControlInfo component) throws Exception {
                TableWrapDataInfo layoutData = TableWrapLayoutInfo.this.getTableWrapData(component);
                layoutData.setHorizontalAlignment(8);
            }
        });
    }

    private ControlInfo getControlAt(int x, int y) {
        for (ControlInfo control : this.getControls()) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            if (layoutData.x != x || layoutData.y != y) continue;
            return control;
        }
        return null;
    }

    public IGridInfo getGridInfo() {
        if (this.m_gridInfo == null) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    TableWrapLayoutInfo.this.createGridInfo();
                }
            });
        }
        return this.m_gridInfo;
    }

    public int[] getColumnOrigins() {
        return this.m_columnOrigins;
    }

    public int[] getRowOrigins() {
        return this.m_rowOrigins;
    }

    private void createGridInfo() throws Exception {
        final Interval[] columnIntervals = TableWrapLayoutInfo.getIntervals(this.m_columnOrigins, this.m_columnWidths);
        final Interval[] rowIntervals = TableWrapLayoutInfo.getIntervals(this.m_rowOrigins, this.m_rowHeights);
        final HashMap componentToCells = Maps.newHashMap();
        final HashMap occupiedCells = Maps.newHashMap();
        for (ControlInfo control : this.getControls()) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            Rectangle cells = new Rectangle(layoutData.x, layoutData.y, layoutData.width, layoutData.height);
            componentToCells.put(control, cells);
            if (this.isFiller(control)) continue;
            int x = cells.x;
            while (x < cells.right()) {
                int y = cells.y;
                while (y < cells.bottom()) {
                    occupiedCells.put(new Point(x, y), control);
                    ++y;
                }
                ++x;
            }
        }
        this.m_gridInfo = new IGridInfo(){

            public int getColumnCount() {
                return columnIntervals.length;
            }

            public int getRowCount() {
                return rowIntervals.length;
            }

            public Interval[] getColumnIntervals() {
                return columnIntervals;
            }

            public Interval[] getRowIntervals() {
                return rowIntervals;
            }

            public Rectangle getComponentCells(IAbstractComponentInfo component) {
                Assert.instanceOf(ControlInfo.class, (Object)component);
                return (Rectangle)componentToCells.get(component);
            }

            public Rectangle getCellsRectangle(Rectangle cells) {
                int x = columnIntervals[cells.x].begin;
                int y = rowIntervals[cells.y].begin;
                int w = columnIntervals[cells.right() - 1].end() - x;
                int h = rowIntervals[cells.bottom() - 1].end() - y;
                return new Rectangle(x, y, w, h);
            }

            public boolean isRTL() {
                return false;
            }

            public Insets getInsets() {
                return new Insets();
            }

            public boolean hasVirtualColumns() {
                return true;
            }

            public int getVirtualColumnSize() {
                return 25;
            }

            public int getVirtualColumnGap() {
                return 5;
            }

            public boolean hasVirtualRows() {
                return true;
            }

            public int getVirtualRowSize() {
                return 25;
            }

            public int getVirtualRowGap() {
                return 5;
            }

            public IAbstractComponentInfo getOccupied(int column, int row) {
                return (IAbstractComponentInfo)occupiedCells.get(new Point(column, row));
            }
        };
    }

    private static Interval[] getIntervals(int[] origins, int[] sizes) {
        Interval[] intervals = new Interval[origins.length];
        int i = 0;
        while (i < intervals.length) {
            intervals[i] = new Interval(origins[i], sizes[i]);
            ++i;
        }
        return intervals;
    }

    public boolean isFiller(ControlInfo control) {
        return TableWrapLayoutInfo.isLabel(control) && control.getCreationSupport().getElement().getDocumentAttributes().isEmpty();
    }

    private static boolean isLabel(ControlInfo control) {
        Class componentClass = control.getDescription().getComponentClass();
        return componentClass.getName().equals("org.eclipse.swt.widgets.Label");
    }

    @Override
    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
        if (!this.isFiller(control)) {
            TableWrapDataInfo layoutData = this.getTableWrapData(control);
            final int column = layoutData.x;
            final int row = layoutData.y;
            commands.add(new LayoutClipboardCommand<TableWrapLayoutInfo>(control){
                private static final long serialVersionUID = 0L;

                @Override
                protected void add(TableWrapLayoutInfo layout, ControlInfo control) throws Exception {
                    layout.command_CREATE(control, column, false, row, false);
                }
            });
            commands.add(new LayoutDataClipboardCommand(this, control));
        }
    }
}

