/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.rcp.model.rcp.PdeUtils;
import org.eclipse.wb.internal.rcp.wizards.RcpWizard;
import org.eclipse.wb.internal.xwt.Activator;
import org.eclipse.wb.internal.xwt.wizards.XwtWizardPage;
import org.osgi.framework.Bundle;

public abstract class XwtWizard
extends RcpWizard {
    private XwtWizardPage m_page;

    public void addPages() {
        super.addPages();
        this.m_page = (XwtWizardPage)this.m_mainPage;
    }

    protected abstract XwtWizardPage createMainPage();

    protected void finishPage(IProgressMonitor monitor) throws Exception {
        this.ensureXWTLibraries();
        super.finishPage(monitor);
        this.m_page.createXWT();
    }

    protected void openEditor() {
        this.openResource(this.m_page.getFileJava(), "org.eclipse.jdt.ui.CompilationUnitEditor");
        this.openResource(this.m_page.getFileXWT(), "org.eclipse.wb.xwt.editor.XwtEditor");
    }

    private void ensureXWTLibraries() throws Exception {
        String srcName;
        String jarName;
        String name;
        IJavaProject javaProject = this.m_page.getJavaProject();
        if (!ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.pushingpixels.trident.Timeline")) {
            name = "org.pushingpixels.trident";
            jarName = XwtWizard.copyJar(javaProject, String.valueOf(name) + "_1.2.0.v20100204-1500.jar");
            srcName = XwtWizard.copyJar(javaProject, String.valueOf(name) + ".source_1.2.0.v20100204-1500.jar");
            XwtWizard.addLibrary(javaProject, jarName, srcName);
        }
        if (!ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.e4.xwt.XWT")) {
            name = "org.eclipse.e4.xwt";
            jarName = XwtWizard.copyJar(javaProject, String.valueOf(name) + "_0.9.1.SNAPSHOT.jar");
            srcName = XwtWizard.copyJar(javaProject, String.valueOf(name) + ".source_0.9.1.SNAPSHOT.jar");
            XwtWizard.addLibrary(javaProject, jarName, srcName);
        }
        if (!ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.eclipse.e4.xwt.forms.XWTForms")) {
            name = "org.eclipse.e4.xwt.forms";
            jarName = XwtWizard.copyJar(javaProject, String.valueOf(name) + "_0.9.1.SNAPSHOT.jar");
            srcName = XwtWizard.copyJar(javaProject, String.valueOf(name) + ".source_0.9.1.SNAPSHOT.jar");
            XwtWizard.addLibrary(javaProject, jarName, srcName);
        }
        this.addPlugin(javaProject, "org.eclipse.core.databinding.Binding", "org.eclipse.core.databinding");
        this.addPlugin(javaProject, "org.eclipse.core.databinding.observable.IObservable", "org.eclipse.core.databinding.observable");
        this.addPlugin(javaProject, "org.eclipse.jface.databinding.swt.SWTObservables", "org.eclipse.jface.databinding");
    }

    private void addPlugin(IJavaProject javaProject, String typeName, String pluginId) throws Exception {
        if (!ProjectUtils.hasType((IJavaProject)javaProject, (String)typeName)) {
            IProject project = javaProject.getProject();
            if (PdeUtils.hasPDENature((IProject)project)) {
                PdeUtils.get((IProject)project).addPluginImport(new String[]{pluginId});
            } else {
                ProjectUtils.addPluginLibraries((IJavaProject)javaProject, (String)pluginId);
            }
        }
    }

    private static String copyJar(IJavaProject javaProject, String name) throws Exception {
        Bundle bundle = Activator.getDefault().getBundle();
        return ProjectUtils.copyFile((IJavaProject)javaProject, (Bundle)bundle, (String)("lib/" + name));
    }

    private static void addLibrary(IJavaProject javaProject, String jarName, String srcName) throws Exception {
        ProjectUtils.addClasspathEntry((IJavaProject)javaProject, (String)jarName, (String)srcName);
    }
}

