/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.edit;

import com.jgoodies.forms.layout.RowSpec;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.FormLayout.Activator;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.actions.SetGrowAction;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.RowEditDialog;

public class RowHeaderEditPart
extends DimensionHeaderEditPart<FormRowInfo> {
    private final FormRowInfo m_row;

    public RowHeaderEditPart(FormLayoutInfo layout, FormRowInfo row, Figure containerFigure) {
        super(layout, row, containerFigure);
        this.m_row = row;
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Image image;
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(IColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.right(), r.y);
                graphics.drawLine(r.x, r.bottom() - 1, r.right(), r.bottom() - 1);
                String title = "" + (1 + RowHeaderEditPart.this.getIndex());
                Dimension textExtents = graphics.getTextExtent(title);
                if (r.height < textExtents.height) {
                    return;
                }
                int titleTop = r.y + (r.height - textExtents.height) / 2;
                int titleBottom = titleTop + textExtents.height;
                int x = r.x + (r.width - textExtents.width) / 2;
                graphics.setForegroundColor(IColorConstants.black);
                graphics.drawText(title, x, titleTop);
                if (titleTop - r.y > 13) {
                    image = ((FormRowInfo)RowHeaderEditPart.this.m_dimension).getAlignment() == RowSpec.TOP ? this.getImage("top.gif") : (((FormRowInfo)RowHeaderEditPart.this.m_dimension).getAlignment() == RowSpec.BOTTOM ? this.getImage("bottom.gif") : (((FormRowInfo)RowHeaderEditPart.this.m_dimension).getAlignment() == RowSpec.CENTER ? this.getImage("center.gif") : this.getImage("fill.gif")));
                    int y = r.y + 2;
                    this.drawCentered(graphics, image, y);
                }
                if (((FormRowInfo)RowHeaderEditPart.this.m_dimension).hasGrow() && titleBottom + 3 + 7 + 3 < r.bottom()) {
                    image = this.getImage("grow.gif");
                    this.drawCentered(graphics, image, r.bottom() - 3 - image.getBounds().height);
                }
            }

            private Image getImage(String name) {
                return RowHeaderEditPart.this.getImage("alignment/v/" + name);
            }

            private void drawCentered(Graphics graphics, Image image, int y) {
                int x = (this.getBounds().width - image.getBounds().width) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        int index = this.getIndex();
        Interval interval = this.m_layout.getGridInfo().getRowIntervals()[index];
        Rectangle bounds = new Rectangle(0, interval.begin, ((GraphicalEditPart)this.getParent()).getFigure().getSize().width, interval.length + 1);
        bounds.translate(0, this.getOffset().y);
        this.getFigure().setBounds(bounds);
    }

    @Override
    public int getIndex() {
        return this.m_layout.getRows().indexOf(this.m_row);
    }

    public void buildContextMenu(IMenuManager manager) {
        if (!this.m_layout.canChangeDimensions()) {
            return;
        }
        manager.add((IAction)new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_insertRow){

            @Override
            protected void run(FormRowInfo dimension) throws Exception {
                int index = RowHeaderEditPart.this.m_layout.getRows().indexOf(dimension);
                RowHeaderEditPart.this.m_layout.insertRow(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_appendRow){

            @Override
            protected void run(FormRowInfo dimension) throws Exception {
                int index = RowHeaderEditPart.this.m_layout.getRows().indexOf(dimension);
                RowHeaderEditPart.this.m_layout.insertRow(index + 1);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_deleteRow){

            @Override
            protected void run(FormRowInfo dimension) throws Exception {
                int index = RowHeaderEditPart.this.m_layout.getRows().indexOf(dimension);
                RowHeaderEditPart.this.m_layout.deleteRow(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_deleteContents){

            @Override
            protected void run(FormRowInfo dimension) throws Exception {
                int index = RowHeaderEditPart.this.m_layout.getRows().indexOf(dimension);
                RowHeaderEditPart.this.m_layout.deleteRowContents(index);
            }
        });
        manager.add((IAction)new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_splitRow){

            @Override
            protected void run(FormRowInfo dimension) throws Exception {
                int index = RowHeaderEditPart.this.m_layout.getRows().indexOf(dimension);
                RowHeaderEditPart.this.m_layout.splitRow(index);
            }
        });
        manager.add((IContributionItem)new Separator());
        manager.add(new SetAlignmentAction<FormRowInfo>(this, GefMessages.RowHeaderEditPart_vaTop, Activator.getImageDescriptor("alignment/v/menu/top.gif"), RowSpec.TOP));
        manager.add(new SetAlignmentAction<FormRowInfo>(this, GefMessages.RowHeaderEditPart_vaCenter, Activator.getImageDescriptor("alignment/v/menu/center.gif"), RowSpec.CENTER));
        manager.add(new SetAlignmentAction<FormRowInfo>(this, GefMessages.RowHeaderEditPart_vaBottom, Activator.getImageDescriptor("alignment/v/menu/bottom.gif"), RowSpec.BOTTOM));
        manager.add(new SetAlignmentAction<FormRowInfo>(this, GefMessages.RowHeaderEditPart_vaFill, Activator.getImageDescriptor("alignment/v/menu/fill.gif"), RowSpec.FILL));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetGrowAction<FormRowInfo>(this, GefMessages.RowHeaderEditPart_grow, Activator.getImageDescriptor("alignment/h/menu/grow.gif")));
        manager.add((IContributionItem)new Separator());
        this.addTemplateActions(manager, ((FormRowInfo)this.m_dimension).getTemplates(true));
        MenuManager otherManager = new MenuManager(GefMessages.RowHeaderEditPart_otherTemplates);
        manager.add((IContributionItem)otherManager);
        this.addTemplateActions((IMenuManager)otherManager, ((FormRowInfo)this.m_dimension).getTemplates(false));
        manager.add((IContributionItem)new Separator());
        DimensionHeaderAction<FormRowInfo> action = new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_group){

            @Override
            protected void run(List<FormRowInfo> dimensions) throws Exception {
                RowHeaderEditPart.this.m_layout.groupRows(dimensions);
            }
        };
        action.setEnabled(this.getViewer().getSelectedEditParts().size() >= 2);
        manager.add((IAction)action);
        action = new DimensionHeaderAction<FormRowInfo>((DimensionHeaderEditPart)this, GefMessages.RowHeaderEditPart_unGroup){

            @Override
            protected void run(List<FormRowInfo> dimensions) throws Exception {
                RowHeaderEditPart.this.m_layout.unGroupRows(dimensions);
            }
        };
        manager.add((IAction)action);
        boolean hasGroup = false;
        for (EditPart editPart : this.getViewer().getSelectedEditParts()) {
            RowHeaderEditPart headerEditPart = (RowHeaderEditPart)editPart;
            if (this.m_layout.getRowGroup(headerEditPart.m_row) == null) continue;
            hasGroup = true;
            break;
        }
        action.setEnabled(hasGroup);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ObjectInfoAction((ObjectInfo)this.m_layout, GefMessages.RowHeaderEditPart_properties){

            protected void runEx() throws Exception {
                RowHeaderEditPart.this.editDimension();
            }
        });
    }

    @Override
    protected void editDimension() {
        new RowEditDialog(DesignerPlugin.getShell(), this.m_layout, this.m_row).open();
    }
}

