/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewPropertySetNode;

public class SystemTeamViewInputProvider
implements IAdaptable,
ISystemViewInputProvider {
    private Viewer viewer;

    public Object[] getRoots() {
        Object[] roots = SystemProfileManager.getDefault().getSystemProfiles();
        return roots;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public Object[] getSystemViewRoots() {
        return this.getRoots();
    }

    public boolean hasSystemViewRoots() {
        return true;
    }

    public boolean showingConnections() {
        return true;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        IPropertySet[] propertySets = selectedConnection.getPropertySets();
        if (propertySets == null || propertySets.length == 0) {
            return new SystemTeamViewPropertySetNode[0];
        }
        ArrayList<SystemTeamViewPropertySetNode> nodes = new ArrayList<SystemTeamViewPropertySetNode>();
        int i = 0;
        while (i < propertySets.length) {
            nodes.add(new SystemTeamViewPropertySetNode((IPropertySetContainer)selectedConnection, propertySets[i]));
            ++i;
        }
        Object[] result = new SystemTeamViewPropertySetNode[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        IPropertySet[] sets = selectedConnection.getPropertySets();
        return sets != null && sets.length != 0;
    }

    public void setViewer(Object viewer) {
        this.viewer = (Viewer)viewer;
    }

    public Object getViewer() {
        return this.viewer;
    }
}

