/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.filters.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterNewFilterPoolWizardDefaultMainPage;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterNewFilterPoolWizardMainPageInterface;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.filters.SystemFilterPoolDialogOutputs;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolAction;
import org.eclipse.rse.ui.filters.dialogs.SystemFilterPoolWizardInterface;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;

public class SystemFilterNewFilterPoolWizard
extends AbstractSystemWizard
implements SystemFilterPoolWizardInterface {
    protected SystemFilterNewFilterPoolWizardMainPageInterface mainPage;
    protected ValidatorFolderName usv;
    protected SystemFilterPoolDialogOutputs output;
    protected SystemFilterAbstractFilterPoolAction caller;
    protected ISystemFilterPoolManager[] mgrs;

    public SystemFilterNewFilterPoolWizard() {
        this(SystemResources.RESID_NEWFILTERPOOL_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfilterpool_wizBannerIcon"));
    }

    public SystemFilterNewFilterPoolWizard(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void setHelpContextId(String id) {
        super.setHelp(id);
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage();
            this.addPage((IWizardPage)((WizardPage)this.mainPage));
        }
        catch (Exception exc) {
            System.out.println("Unexpected error in addPages of NewFilterPoolWizard: " + exc.getMessage() + ", " + exc.getClass().getName());
        }
    }

    protected SystemFilterNewFilterPoolWizardMainPageInterface createMainPage() {
        this.mainPage = new SystemFilterNewFilterPoolWizardDefaultMainPage(this, this.caller.getDialogTitle(), this.caller.getDialogPrompt());
        this.mgrs = this.caller.getFilterPoolManagers();
        if (this.mgrs != null) {
            this.mainPage.setFilterPoolManagers(this.mgrs);
            this.mainPage.setFilterPoolManagerNameSelectionIndex(this.caller.getFilterPoolManagerNameSelectionIndex());
        }
        return this.mainPage;
    }

    public boolean performFinish() {
        if (this.mainPage.performFinish()) {
            ISystemFilterPoolManager mgr;
            block7: {
                this.output = this.mainPage.getFilterPoolDialogOutputs();
                String mgrName = this.output.filterPoolManagerName;
                mgr = null;
                try {
                    if (mgrName != null) {
                        int idx = 0;
                        while (mgr == null && idx < this.mgrs.length) {
                            if (this.mgrs[idx].getName().equalsIgnoreCase(mgrName)) {
                                mgr = this.mgrs[idx];
                            }
                            ++idx;
                        }
                    }
                    if (mgr != null) break block7;
                    System.out.println("Unexpected problem in performFinish of filter pool wizard: no match for selected profile name " + mgrName);
                    return false;
                }
                catch (Exception exc) {
                    SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1003");
                    msg.makeSubstitution((Object)exc);
                    SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), msg);
                    msgDlg.openWithDetails();
                    return false;
                }
            }
            String poolName = this.mainPage.getPoolName();
            this.output.newPool = this.createFilterPool(mgr, poolName);
            return this.output.newPool != null;
        }
        return false;
    }

    protected ISystemFilterPool createFilterPool(ISystemFilterPoolManager selectedManager, String poolName) throws Exception {
        ISystemFilterPool newFilterPool = null;
        if (selectedManager != null) {
            newFilterPool = selectedManager.createSystemFilterPool(poolName, true);
        }
        return newFilterPool;
    }

    public SystemFilterPoolDialogOutputs getFilterPoolDialogOutputs() {
        return this.output;
    }

    public void setFilterPoolDialogActionCaller(SystemFilterAbstractFilterPoolAction caller) {
        this.caller = caller;
    }

    public SystemFilterAbstractFilterPoolAction getFilterPoolDialogActionCaller() {
        return this.caller;
    }
}

