/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.Pair;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.views.HierarchyViewInput;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.ui.PlatformUI;

public class TypeHierarchyViewContentProvider
implements ITreeContentProvider {
    private TreeViewer treeViewer;
    private LanguageServerWrapper languageServerWrapper;
    private List<TypeHierarchyItem> hierarchyItems;
    public boolean showSuperTypes = true;

    public Object[] getElements(Object inputElement) {
        if (this.hierarchyItems != null) {
            if (this.hierarchyItems.isEmpty()) {
                return new Object[]{Messages.TH_no_type_hierarchy};
            }
            return this.hierarchyItems.toArray();
        }
        return new Object[]{Messages.TH_finding_types};
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        Object object = parentElement;
        if (object instanceof TypeHierarchyItem) {
            TypeHierarchyItem typeHierarchyItem = (TypeHierarchyItem)object;
            TypeHierarchyItem cfr_ignored_0 = (TypeHierarchyItem)object;
            try {
                void parentItem;
                return (Object[])((CompletableFuture)this.languageServerWrapper.execute(arg_0 -> this.lambda$0((TypeHierarchyItem)parentItem, arg_0)).thenApply(list -> list == null ? new Object[]{} : list.toArray(Object[]::new))).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.treeViewer = (TreeViewer)viewer;
        Object object = newInput;
        if (object instanceof HierarchyViewInput) {
            void viewInput;
            HierarchyViewInput hierarchyViewInput = (HierarchyViewInput)object;
            HierarchyViewInput cfr_ignored_0 = (HierarchyViewInput)object;
            this.hierarchyItems = null;
            IDocument document = viewInput.getDocument();
            if (document != null) {
                try {
                    this.initialise(document, viewInput.getOffset());
                }
                catch (BadLocationException e) {
                    this.handleRootError();
                }
            } else {
                this.handleRootError();
            }
        } else {
            this.handleRootError();
        }
    }

    private void initialise(@NonNull IDocument document, int offset) throws BadLocationException {
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getTypeHierarchyProvider);
        if (!executor.anyMatching()) {
            this.handleRootError();
            return;
        }
        TypeHierarchyPrepareParams prepareParams = TypeHierarchyViewContentProvider.toTypeHierarchyPrepareParams(offset, document);
        ((CompletableFuture)executor.computeFirst((w, ls) -> ls.getTextDocumentService().prepareTypeHierarchy(prepareParams).thenApply(result -> new Pair<LanguageServerWrapper, List>((LanguageServerWrapper)w, (List)result))).thenAccept(o -> o.ifPresentOrElse(p -> {
            this.languageServerWrapper = (LanguageServerWrapper)p.getFirst();
            this.hierarchyItems = (List)p.getSecond();
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (this.treeViewer != null) {
                    this.treeViewer.refresh();
                    this.treeViewer.getControl().setEnabled(true);
                    this.treeViewer.expandToLevel(2);
                }
            });
        }, this::handleRootError))).handle((result, error) -> {
            if (error != null) {
                this.handleRootError();
            }
            return result;
        });
    }

    private static TypeHierarchyPrepareParams toTypeHierarchyPrepareParams(int offset, @NonNull IDocument document) throws BadLocationException {
        Position position = LSPEclipseUtils.toPosition(offset, document);
        TextDocumentIdentifier documentIdentifier = LSPEclipseUtils.toTextDocumentIdentifier(document);
        return new TypeHierarchyPrepareParams(documentIdentifier, position);
    }

    private void handleRootError() {
        this.hierarchyItems = Collections.emptyList();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.treeViewer != null) {
                this.treeViewer.refresh();
            }
        });
    }

    public void dispose() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
            this.treeViewer = null;
        }
    }

    private /* synthetic */ CompletableFuture lambda$0(TypeHierarchyItem typeHierarchyItem, LanguageServer ls) {
        TextDocumentService textDocumentService = ls.getTextDocumentService();
        return this.showSuperTypes ? textDocumentService.typeHierarchySupertypes(new TypeHierarchySupertypesParams(typeHierarchyItem)) : textDocumentService.typeHierarchySubtypes(new TypeHierarchySubtypesParams(typeHierarchyItem));
    }
}

