/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    NSWindow[] windows;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        if (this.parent != null) {
            Point pt = this.parent.toDisplay(newX, newY);
            newX = pt.x;
            newY = pt.y;
        }
        this.display.setCursorLocation(newX, newY);
        return new Point(newX, newY);
    }

    Point adjustResizeCursor(boolean movePointer) {
        if (this.bounds == null) {
            return null;
        }
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            Point pt = this.parent.toDisplay(newX, newY);
            newX = pt.x;
            newY = pt.y;
        }
        if (movePointer) {
            this.display.setCursorLocation(newX, newY);
        }
        if (this.clientCursor == null) {
            Cursor newCursor = null;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    newCursor = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    newCursor = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    newCursor = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    newCursor = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    newCursor = new Cursor(this.display, 5);
                }
            }
            this.display.lockCursor = false;
            newCursor.handle.set();
            this.display.lockCursor = true;
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = newCursor;
        }
        return new Point(newX, newY);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int i = 0;
            while (i < rects.length) {
                int x = 0;
                int y = 0;
                int width = 0;
                int height = 0;
                if (this.bounds.width != 0) {
                    x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                    width = rects[i].width * 100 / this.bounds.width;
                } else {
                    width = 100;
                }
                if (this.bounds.height != 0) {
                    y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                    height = rects[i].height * 100 / this.bounds.height;
                } else {
                    height = 100;
                }
                result[i] = new Rectangle(x, y, width, height);
                ++i;
            }
        }
        return result;
    }

    void drawRectangles(NSWindow window, Rectangle[] rects, boolean erase) {
        NSGraphicsContext context = window.graphicsContext();
        if (context == null) {
            long width = (long)window.frame().width;
            long height = (long)window.frame().height;
            NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 1L, width * 4L, 32L);
            context = NSGraphicsContext.graphicsContextWithBitmapImageRep(rep);
            rep.release();
        }
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(context);
        context.saveGraphicsState();
        Point parentOrigin = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new Point(0, 0);
        context.setCompositingOperation(erase ? 0 : 2);
        NSRect rectFrame = new NSRect();
        NSPoint globalPoint = new NSPoint();
        double screenHeight = this.display.getPrimaryFrame().height;
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            rectFrame.x = rect.x + parentOrigin.x;
            rectFrame.y = screenHeight - (double)(rect.y + parentOrigin.y + rect.height);
            rectFrame.width = rect.width;
            rectFrame.height = rect.height;
            globalPoint.x = rectFrame.x;
            globalPoint.y = rectFrame.y;
            globalPoint = window.convertScreenToBase(globalPoint);
            rectFrame.x = globalPoint.x;
            rectFrame.y = globalPoint.y;
            if (erase) {
                rectFrame.width += 1.0;
                rectFrame.height += 1.0;
                NSBezierPath.fillRect(rectFrame);
            } else {
                rectFrame.x += 0.5;
                rectFrame.y += 0.5;
                NSBezierPath.strokeRect(rectFrame);
            }
            ++i;
        }
        if (!erase) {
            context.flushGraphics();
        }
        context.restoreGraphicsState();
        NSGraphicsContext.static_restoreGraphicsState();
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] result = new Rectangle[this.rectangles.length];
        int i = 0;
        while (i < this.rectangles.length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void mouse(NSEvent nsEvent) {
        NSPoint location;
        if (nsEvent == null || nsEvent.type() == 5L) {
            location = NSEvent.mouseLocation();
        } else {
            location = nsEvent.locationInWindow();
            location = nsEvent.window().convertBaseToScreen(location);
        }
        location.y = this.display.getPrimaryFrame().height - location.y;
        int newX = (int)location.x;
        int newY = (int)location.y;
        if (newX != this.oldX || newY != this.oldY) {
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                Point cursorPos;
                boolean orientationInit = this.resizeRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i3 = 0;
                    while (i3 < this.windows.length) {
                        this.drawRectangles(this.windows[i3], rectsToErase, true);
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < this.windows.length) {
                        this.drawRectangles(this.windows[i3], this.rectangles, false);
                        ++i3;
                    }
                }
                if ((cursorPos = this.adjustResizeCursor(orientationInit)) != null) {
                    newX = cursorPos.x;
                    newY = cursorPos.y;
                }
            } else {
                this.moveRectangles(newX - this.oldX, newY - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i4 = 0;
                        while (i4 < length) {
                            if (!this.rectangles[i4].equals(rectsToErase[i4])) {
                                draw = true;
                                break;
                            }
                            ++i4;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i5 = 0;
                    while (i5 < this.windows.length) {
                        this.drawRectangles(this.windows[i5], rectsToErase, true);
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < this.windows.length) {
                        this.drawRectangles(this.windows[i5], this.rectangles, false);
                        ++i5;
                    }
                }
            }
            this.oldX = newX;
            this.oldY = newY;
        }
        switch ((int)nsEvent.type()) {
            case 2: 
            case 4: 
            case 26: {
                this.tracking = false;
            }
        }
    }

    void key(NSEvent nsEvent) {
        int nsType = (int)nsEvent.type();
        long modifierFlags = nsEvent.modifierFlags();
        short nsKeyCode = nsEvent.keyCode();
        int keyCode = Display.translateKey(nsKeyCode);
        switch (nsType) {
            case 10: 
            case 11: {
                int type;
                Event event = new Event();
                event.keyCode = keyCode;
                int n = type = nsType == 10 ? 1 : 2;
                if (!this.setKeyState(event, type, nsEvent) || this.sendKeyEvent(type, event)) break;
                return;
            }
            case 12: {
                int mask = 0;
                switch (keyCode) {
                    case 65536: {
                        mask = 524288;
                        break;
                    }
                    case 262144: {
                        mask = 262144;
                        break;
                    }
                    case 0x400000: {
                        mask = 0x100000;
                        break;
                    }
                    case 131072: {
                        mask = 131072;
                        break;
                    }
                    case 16777298: {
                        Event event = new Event();
                        event.keyCode = keyCode;
                        this.setInputState(event, nsEvent, 1);
                        this.sendKeyEvent(1, event);
                        this.setInputState(event, nsEvent, 2);
                        this.sendKeyEvent(2, event);
                    }
                }
                if (mask == 0) break;
                int type = ((long)mask & modifierFlags) != 0L ? 1 : 2;
                Event event = new Event();
                event.keyCode = keyCode;
                this.setLocationMask(event, nsEvent);
                this.setInputState(event, nsEvent, type);
                if (this.sendKeyEvent(type, event)) break;
                return;
            }
        }
        int stepSize = (modifierFlags & 0x40000L) != 0L ? 1 : 9;
        int xChange = 0;
        int yChange = 0;
        switch (nsKeyCode) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                xChange = -stepSize;
                break;
            }
            case 124: {
                xChange = stepSize;
                break;
            }
            case 126: {
                yChange = -stepSize;
                break;
            }
            case 125: {
                yChange = stepSize;
            }
        }
        if (xChange != 0 || yChange != 0) {
            Point cursorPos;
            Rectangle[] oldRectangles = this.rectangles;
            Rectangle[] rectsToErase = new Rectangle[this.rectangles.length];
            int i = 0;
            while (i < this.rectangles.length) {
                Rectangle current = this.rectangles[i];
                rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                ++i;
            }
            Event event = new Event();
            int newX = this.oldX + xChange;
            int newY = this.oldY + yChange;
            event.x = newX;
            event.y = newY;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i2 = 0;
                        while (i2 < length) {
                            if (!this.rectangles[i2].equals(rectsToErase[i2])) {
                                draw = true;
                                break;
                            }
                            ++i2;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i3 = 0;
                    while (i3 < this.windows.length) {
                        this.drawRectangles(this.windows[i3], rectsToErase, true);
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < this.windows.length) {
                        this.drawRectangles(this.windows[i3], this.rectangles, false);
                        ++i3;
                    }
                }
                cursorPos = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(xChange, yChange);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean draw = false;
                if (this.rectangles != oldRectangles) {
                    int length = this.rectangles.length;
                    if (length != rectsToErase.length) {
                        draw = true;
                    } else {
                        int i4 = 0;
                        while (i4 < length) {
                            if (!this.rectangles[i4].equals(rectsToErase[i4])) {
                                draw = true;
                                break;
                            }
                            ++i4;
                        }
                    }
                } else {
                    draw = true;
                }
                if (draw) {
                    int i5 = 0;
                    while (i5 < this.windows.length) {
                        this.drawRectangles(this.windows[i5], rectsToErase, true);
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < this.windows.length) {
                        this.drawRectangles(this.windows[i5], this.rectangles, false);
                        ++i5;
                    }
                }
                cursorPos = this.adjustMoveCursor();
            }
            if (cursorPos != null) {
                this.oldX = cursorPos.x;
                this.oldY = cursorPos.y;
            }
        }
    }

    void moveRectangles(int xChange, int yChange) {
        if (this.bounds == null) {
            return;
        }
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    public boolean open() {
        Point cursorPos;
        int hStyle;
        this.checkWidget();
        Display display = this.display;
        this.cancelled = false;
        this.tracking = true;
        NSArray screens = NSScreen.screens();
        int count = (int)screens.count();
        this.windows = new NSWindow[count];
        int i = 0;
        while (i < count) {
            NSScreen screen = new NSScreen(screens.objectAtIndex(i));
            NSRect frame = screen.frame();
            NSWindow window = (NSWindow)new NSWindow().alloc();
            window = window.initWithContentRect(frame, 0L, 2L, false);
            window.setOpaque(false);
            window.setLevel(25L);
            window.setContentView(null);
            window.setBackgroundColor(NSColor.clearColor());
            NSGraphicsContext context = window.graphicsContext();
            if (context == null) {
                long width = (long)window.frame().width;
                long height = (long)window.frame().height;
                NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
                rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 1L, width * 4L, 32L);
                context = NSGraphicsContext.graphicsContextWithBitmapImageRep(rep);
                rep.release();
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(context);
            context.setCompositingOperation(0L);
            frame.y = 0.0;
            frame.x = 0.0;
            NSBezierPath.fillRect(frame);
            NSGraphicsContext.static_restoreGraphicsState();
            window.orderFrontRegardless();
            this.windows[i] = window;
            ++i;
        }
        i = 0;
        while (i < this.windows.length) {
            this.drawRectangles(this.windows[i], this.rectangles, false);
            ++i;
        }
        int vStyle = this.style & 0x480;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 0x24000) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        boolean down = false;
        NSApplication application = NSApplication.sharedApplication();
        NSEvent currentEvent = application.currentEvent();
        if (currentEvent != null) {
            switch ((int)currentEvent.type()) {
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 25: 
                case 27: {
                    down = true;
                }
            }
        }
        if ((cursorPos = down ? display.getCursorLocation() : ((this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor())) != null) {
            this.oldX = cursorPos.x;
            this.oldY = cursorPos.y;
        }
        Control oldTrackingControl = display.trackingControl;
        display.trackingControl = null;
        while (this.tracking && !this.cancelled) {
            display.addPool();
            try {
                if (this.parent != null && this.parent.isDisposed()) break;
                display.runSkin();
                display.runDeferredLayouts();
                NSEvent event = application.nextEventMatchingMask(-1L, NSDate.distantFuture(), OS.NSDefaultRunLoopMode, true);
                if (event == null) continue;
                int type = (int)event.type();
                switch (type) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 26: 
                    case 27: {
                        this.mouse(event);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        this.key(event);
                    }
                }
                boolean dispatch = true;
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 26: 
                    case 27: {
                        dispatch = false;
                    }
                }
                if (dispatch) {
                    application.sendEvent(event);
                }
                if (this.clientCursor != null && this.resizeCursor == null) {
                    display.lockCursor = false;
                    this.clientCursor.handle.set();
                    display.lockCursor = true;
                }
                display.runAsyncMessages(false);
            }
            finally {
                display.removePool();
            }
        }
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        if (oldTrackingControl != null && !oldTrackingControl.isDisposed()) {
            display.trackingControl = oldTrackingControl;
        }
        display.setCursor(display.findControl(true));
        if (!this.isDisposed()) {
            int i2 = 0;
            while (i2 < this.windows.length) {
                this.drawRectangles(this.windows[i2], this.rectangles, true);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < this.windows.length) {
            if (this.windows[i3] != null) {
                this.windows[i3].close();
                this.windows[i3] = null;
            }
            ++i3;
        }
        this.tracking = false;
        this.windows = null;
        return !this.cancelled;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    boolean resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (this.bounds == null) {
            return false;
        }
        boolean orientationInit = false;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            orientationInit = true;
        }
        if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            orientationInit = true;
        }
        if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            orientationInit = true;
        }
        if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            orientationInit = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return orientationInit;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return orientationInit;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
        return orientationInit;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = newCursor;
        if (newCursor != null) {
            this.display.lockCursor = false;
            if (this.inEvent) {
                newCursor.handle.set();
            }
            this.display.lockCursor = true;
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

