/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class StateStack
implements IStateStack {
    public static final StateStack NULL = new StateStack(null, RuleId.NO_RULE, 0, 0, false, null, AttributedScopeStack.createRoot("", 0), AttributedScopeStack.createRoot("", 0));
    private int _enterPos;
    private int _anchorPos;
    private final int depth;
    private final @Nullable StateStack parent;
    private final RuleId ruleId;
    final boolean beginRuleCapturedEOL;
    final @Nullable String endRule;
    final AttributedScopeStack nameScopesList;
    final AttributedScopeStack contentNameScopesList;

    StateStack(@Nullable StateStack parent, RuleId ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, AttributedScopeStack nameScopesList, AttributedScopeStack contentNameScopesList) {
        this.parent = parent;
        this.ruleId = ruleId;
        this.depth = this.parent != null ? this.parent.depth + 1 : 1;
        this._enterPos = enterPos;
        this._anchorPos = anchorPos;
        this.beginRuleCapturedEOL = beginRuleCapturedEOL;
        this.endRule = endRule;
        this.nameScopesList = nameScopesList;
        this.contentNameScopesList = contentNameScopesList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        void var3_2;
        StateStack stateStack;
        Object object = other;
        if (object instanceof StateStack && (stateStack = (StateStack)object) == (StateStack)var3_2) {
            void otherState;
            return StateStack._equals(this, (StateStack)otherState);
        }
        return false;
    }

    private static boolean _equals(StateStack a, StateStack b) {
        if (a == b) {
            return true;
        }
        if (!StateStack._structuralEquals(a, b)) {
            return false;
        }
        return a.contentNameScopesList.equals(b.contentNameScopesList);
    }

    private static boolean _structuralEquals(@Nullable StateStack a, @Nullable StateStack b) {
        while (a != b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a.depth != b.depth || !Objects.equals(a.ruleId, b.ruleId) || !Objects.equals(a.endRule, b.endRule)) {
                return false;
            }
            a = a.parent;
            b = b.parent;
        }
        return true;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.endRule, this.parent, this.contentNameScopesList, this.ruleId);
        result = 31 * result + this.depth;
        return result;
    }

    void reset() {
        StateStack el = this;
        while (el != null) {
            el._enterPos = -1;
            el._anchorPos = -1;
            el = el.parent;
        }
    }

    @Nullable StateStack pop() {
        return this.parent;
    }

    StateStack safePop() {
        if (this.parent != null) {
            return this.parent;
        }
        return this;
    }

    StateStack push(RuleId ruleId, int enterPos, int anchorPos, boolean beginRuleCapturedEOL, @Nullable String endRule, AttributedScopeStack nameScopesList, AttributedScopeStack contentNameScopesList) {
        return new StateStack(this, ruleId, enterPos, anchorPos, beginRuleCapturedEOL, endRule, nameScopesList, contentNameScopesList);
    }

    int getEnterPos() {
        return this._enterPos;
    }

    int getAnchorPos() {
        return this._anchorPos;
    }

    Rule getRule(IRuleRegistry grammar) {
        return grammar.getRule(this.ruleId);
    }

    public String toString() {
        ArrayList<String> r = new ArrayList<String>();
        this._writeString(r);
        return String.valueOf('[') + String.join((CharSequence)", ", r) + ']';
    }

    private void _writeString(List<String> res) {
        if (this.parent != null) {
            this.parent._writeString(res);
        }
        res.add("(" + this.ruleId + ")");
    }

    StateStack withContentNameScopesList(AttributedScopeStack contentNameScopesList) {
        if (this.contentNameScopesList.equals(contentNameScopesList)) {
            return this;
        }
        return NullSafetyHelper.castNonNull(this.parent).push(this.ruleId, this._enterPos, this._anchorPos, this.beginRuleCapturedEOL, this.endRule, this.nameScopesList, contentNameScopesList);
    }

    StateStack withEndRule(String endRule) {
        if (this.endRule != null && this.endRule.equals(endRule)) {
            return this;
        }
        return new StateStack(this.parent, this.ruleId, this._enterPos, this._anchorPos, this.beginRuleCapturedEOL, endRule, this.nameScopesList, this.contentNameScopesList);
    }

    boolean hasSameRuleAs(StateStack other) {
        StateStack el = this;
        while (el != null && el._enterPos == other._enterPos) {
            if (el.ruleId == other.ruleId) {
                return true;
            }
            el = el.parent;
        }
        return false;
    }
}

