/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.model;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.model.ModelTokensChangedEventBuilder;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.model.AbstractLineList;
import org.eclipse.tm4e.core.model.IModelLines;
import org.eclipse.tm4e.core.model.IModelTokensChangedListener;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.LineTokens;
import org.eclipse.tm4e.core.model.ModelLine;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.TMState;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.core.model.Tokenizer;

public class TMModel
implements ITMModel {
    private static final System.Logger LOGGER = System.getLogger(TMModel.class.getName());
    private @Nullable IGrammar grammar;
    private final Set<IModelTokensChangedListener> listeners = new CopyOnWriteArraySet<IModelTokensChangedListener>();
    private @Nullable Tokenizer tokenizer;
    private volatile @Nullable TokenizerThread fThread;
    private final IModelLines lines;
    private final PriorityBlockingQueue<Integer> invalidLines = new PriorityBlockingQueue();

    public TMModel(IModelLines lines) {
        this.lines = lines;
        if (lines instanceof AbstractLineList) {
            ((AbstractLineList)lines).setModel(this);
        }
        lines.forEach(ModelLine::resetTokenizationState);
        this.invalidateLine(0);
    }

    @Override
    public @Nullable IGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    public void setGrammar(IGrammar grammar) {
        if (!Objects.equals(grammar, this.grammar)) {
            this.grammar = grammar;
            Tokenizer tokenizer = this.tokenizer = new Tokenizer(grammar);
            this.lines.get(0).setState(tokenizer.getInitialState());
        }
    }

    @Override
    public synchronized void addModelTokensChangedListener(IModelTokensChangedListener listener) {
        this.listeners.add(listener);
        TokenizerThread fThread = this.fThread;
        if (fThread == null || fThread.isInterrupted()) {
            fThread = this.fThread = new TokenizerThread(this.getClass().getName(), this);
        }
        if (!fThread.isAlive()) {
            fThread.start();
        }
    }

    @Override
    public synchronized void removeModelTokensChangedListener(IModelTokensChangedListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void dispose() {
        this.stop();
        this.lines.dispose();
    }

    private synchronized void stop() {
        TokenizerThread fThread = this.fThread;
        if (fThread == null) {
            return;
        }
        fThread.interrupt();
        this.fThread = null;
    }

    private void buildAndEmitEvent(Consumer<ModelTokensChangedEventBuilder> callback) {
        ModelTokensChangedEventBuilder eventBuilder = new ModelTokensChangedEventBuilder(this);
        callback.accept(eventBuilder);
        ModelTokensChangedEvent event = eventBuilder.build();
        if (event != null) {
            this.emit(event);
        }
    }

    private void emit(ModelTokensChangedEvent e) {
        for (IModelTokensChangedListener listener : this.listeners) {
            listener.modelTokensChanged(e);
        }
    }

    @Override
    public void forceTokenization(int lineNumber) {
        TokenizerThread tokenizerThread = this.fThread;
        if (tokenizerThread == null) {
            return;
        }
        this.buildAndEmitEvent(eventBuilder -> {
            int n2 = tokenizerThread.updateTokensInRange((ModelTokensChangedEventBuilder)eventBuilder, lineNumber, lineNumber);
        });
    }

    @Override
    public @Nullable List<TMToken> getLineTokens(int lineNumber) {
        return this.lines.get((int)lineNumber).tokens;
    }

    public boolean isLineInvalid(int lineNumber) {
        return this.lines.get((int)lineNumber).isInvalid;
    }

    void invalidateLine(int lineIndex) {
        this.lines.get((int)lineIndex).isInvalid = true;
        this.invalidLines.add(lineIndex);
    }

    private static final class TokenizerThread
    extends Thread {
        private final TMModel model;
        private @Nullable TMState lastState;

        TokenizerThread(String name, TMModel model) {
            super(name);
            this.model = model;
            this.setPriority(1);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.isInterrupted() && this.model.fThread == this) {
                try {
                    int toProcess = this.model.invalidLines.take();
                    if (!this.model.lines.get((int)toProcess).isInvalid) continue;
                    try {
                        this.revalidateTokensNow(toProcess, null);
                    }
                    catch (Exception ex) {
                        LOGGER.log(System.Logger.Level.ERROR, ex.getMessage());
                        if (toProcess >= this.model.lines.getNumberOfLines()) continue;
                        this.model.invalidateLine(toProcess);
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }

        private void revalidateTokensNow(int startLine, @Nullable Integer toLineIndexOrNull) {
            this.model.buildAndEmitEvent(eventBuilder -> {
                int toLineIndex = toLineIndexOrNull == null || toLineIndexOrNull >= this.model.lines.getNumberOfLines() ? this.model.lines.getNumberOfLines() - 1 : toLineIndexOrNull;
                long tokenizedChars = 0L;
                long currentCharsToTokenize = 0L;
                long MAX_ALLOWED_TIME = 20L;
                long currentEstimatedTimeToTokenize = 0L;
                long startTime = System.currentTimeMillis();
                int lineIndex = startLine;
                while (lineIndex <= toLineIndex && lineIndex < this.model.lines.getNumberOfLines()) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (elapsedTime > 20L) {
                        this.model.invalidateLine(lineIndex);
                        return;
                    }
                    try {
                        currentCharsToTokenize = this.model.lines.getLineLength(lineIndex);
                    }
                    catch (Exception ex) {
                        LOGGER.log(System.Logger.Level.ERROR, ex.getMessage());
                    }
                    if (tokenizedChars > 0L && elapsedTime + (currentEstimatedTimeToTokenize = (long)((double)elapsedTime / (double)tokenizedChars) * currentCharsToTokenize) > 20L) {
                        this.model.invalidateLine(lineIndex);
                        return;
                    }
                    lineIndex = this.updateTokensInRange((ModelTokensChangedEventBuilder)eventBuilder, lineIndex, lineIndex) + 1;
                    tokenizedChars += currentCharsToTokenize;
                }
            });
        }

        private int updateTokensInRange(ModelTokensChangedEventBuilder eventBuilder, int startIndex, int endLineIndex) {
            int stopLineTokenizationAfter = 1000000000;
            int nextInvalidLineIndex = startIndex;
            int lineIndex = startIndex;
            while (lineIndex <= endLineIndex && lineIndex < this.model.lines.getNumberOfLines()) {
                int endStateIndex = lineIndex + 1;
                LineTokens r = null;
                String text = null;
                ModelLine modeLine = this.model.lines.get(lineIndex);
                try {
                    text = this.model.lines.getLineText(lineIndex);
                    r = NullSafetyHelper.castNonNull(this.model.tokenizer).tokenize(text, modeLine.state, 0, 1000000000);
                }
                catch (Exception ex) {
                    LOGGER.log(System.Logger.Level.ERROR, ex.toString());
                    return nextInvalidLineIndex;
                }
                if (!r.tokens.isEmpty()) {
                    r.actualStopOffset = Math.max(r.actualStopOffset, MoreCollections.getLastElement(r.tokens).startIndex + 1);
                }
                if (r.actualStopOffset < text.length()) {
                    r.tokens.add(new TMToken(r.actualStopOffset, ""));
                    r.endState = modeLine.getState();
                }
                modeLine.setTokens(r.tokens);
                eventBuilder.registerChangedTokens(lineIndex + 1);
                modeLine.isInvalid = false;
                if (endStateIndex < this.model.lines.getNumberOfLines()) {
                    ModelLine endStateLine = NullSafetyHelper.castNonNull(this.model.lines.get(endStateIndex));
                    if (endStateLine.getState() != null && Objects.equals(endStateLine.getState(), r.endState)) {
                        nextInvalidLineIndex = lineIndex + 1;
                        while (nextInvalidLineIndex < this.model.lines.getNumberOfLines()) {
                            boolean isLastLine;
                            if (this.model.lines.get((int)nextInvalidLineIndex).isInvalid) break;
                            boolean bl = isLastLine = nextInvalidLineIndex + 1 >= this.model.lines.getNumberOfLines();
                            if (isLastLine ? this.lastState == null : this.model.lines.get(nextInvalidLineIndex + 1).getState() == null) break;
                            ++nextInvalidLineIndex;
                        }
                        lineIndex = nextInvalidLineIndex;
                        continue;
                    }
                    endStateLine.setState(r.endState);
                    ++lineIndex;
                    continue;
                }
                this.lastState = r.endState;
                ++lineIndex;
            }
            return nextInvalidLineIndex;
        }
    }
}

