/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.ServerUIPreferences;

public class LaunchingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected ServerPreferences preferences = ServerPreferences.getInstance();
    protected ServerUIPreferences uiPreferences = ServerUIPlugin.getPreferences();
    protected Button publishBeforeStart;
    protected byte saveEditors;
    protected Button[] saveButtons;
    protected int launchMode;
    protected Button[] launchModeButtons;
    protected int launchMode2;
    protected Button[] launchMode2Buttons;
    protected int breakpointEnablement;
    protected Button[] breakpointButtons;
    protected int restartEnablement;
    protected Button[] restartButtons;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)parent, "org.eclipse.wst.server.ui.spge0000");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        this.publishBeforeStart = new Button(composite, 32);
        this.publishBeforeStart.setText(Messages.prefAutoPublish);
        data = new GridData(256);
        data.horizontalSpan = 3;
        this.publishBeforeStart.setLayoutData((Object)data);
        this.publishBeforeStart.setSelection(this.preferences.isAutoPublishing());
        whs.setHelp((Control)this.publishBeforeStart, "org.eclipse.wst.server.ui.spge0012");
        Label label = new Label(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.createSaveEditorGroup(composite);
        this.createLaunchModeGroup(composite);
        this.createLaunchMode2Group(composite);
        this.createBreakpointsGroup(composite);
        this.createRestartGroup(composite);
        this.setSaveEditorStatus(this.uiPreferences.getSaveEditors());
        this.setLaunchModeStatus(this.uiPreferences.getLaunchMode());
        this.setLaunchMode2Status(this.uiPreferences.getLaunchMode2());
        this.setBreakpointsStatus(this.uiPreferences.getEnableBreakpoints());
        this.setRestartStatus(this.uiPreferences.getRestart());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createSaveEditorGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.prefSaveEditors);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        String[] messages = new String[]{Messages.prefSaveEditorsAlways, Messages.prefSaveEditorsNever, Messages.prefSaveEditorsPrompt};
        byte[] byArray = new byte[3];
        byArray[0] = 2;
        byArray[2] = 1;
        final byte[] options = byArray;
        Button[] buttons = new Button[3];
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        int i = 0;
        while (i < 3) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(messages[i]);
            final int b = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LaunchingPreferencePage.this.saveEditors = options[b];
                }
            });
            whs.setHelp((Control)buttons[i], "org.eclipse.wst.server.ui.spge0024");
            ++i;
        }
        this.saveButtons = buttons;
    }

    protected void setSaveEditorStatus(byte status) {
        this.saveEditors = status;
        this.saveButtons[0].setSelection(this.saveEditors == 2);
        this.saveButtons[1].setSelection(this.saveEditors == 0);
        this.saveButtons[2].setSelection(this.saveEditors == 1);
    }

    protected void createLaunchModeGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.prefLaunchMode);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        String[] messages = new String[]{Messages.prefLaunchModeRestart, Messages.prefLaunchModeContinue, Messages.prefLaunchModePrompt};
        byte[] byArray = new byte[3];
        byArray[0] = 2;
        byArray[1] = 1;
        final byte[] options = byArray;
        Button[] buttons = new Button[3];
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        int i = 0;
        while (i < 3) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(messages[i]);
            final int b = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LaunchingPreferencePage.this.launchMode = options[b];
                }
            });
            whs.setHelp((Control)buttons[i], "org.eclipse.wst.server.ui.spge0030");
            ++i;
        }
        this.launchModeButtons = buttons;
    }

    protected void setLaunchModeStatus(int mode) {
        this.launchMode = mode;
        this.launchModeButtons[0].setSelection(this.launchMode == 2);
        this.launchModeButtons[1].setSelection(this.launchMode == 1);
        this.launchModeButtons[2].setSelection(this.launchMode == 0);
    }

    protected void createLaunchMode2Group(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.prefLaunchMode2);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        String[] messages = new String[]{Messages.prefLaunchMode2Restart, Messages.prefLaunchMode2Breakpoints, Messages.prefLaunchMode2Continue, Messages.prefLaunchMode2Prompt};
        byte[] byArray = new byte[4];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 1;
        final byte[] options = byArray;
        Button[] buttons = new Button[4];
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        int i = 0;
        while (i < 4) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(messages[i]);
            final int b = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LaunchingPreferencePage.this.launchMode2 = options[b];
                }
            });
            whs.setHelp((Control)buttons[i], "org.eclipse.wst.server.ui.spge0031");
            ++i;
        }
        this.launchMode2Buttons = buttons;
    }

    protected void setLaunchMode2Status(int mode) {
        this.launchMode2 = mode;
        this.launchMode2Buttons[0].setSelection(this.launchMode2 == 2);
        this.launchMode2Buttons[1].setSelection(this.launchMode2 == 3);
        this.launchMode2Buttons[2].setSelection(this.launchMode2 == 1);
        this.launchMode2Buttons[3].setSelection(this.launchMode2 == 0);
    }

    protected void createBreakpointsGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.prefBreakpoints);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        String[] messages = new String[]{Messages.prefBreakpointsAlways, Messages.prefBreakpointsNever, Messages.prefBreakpointsPrompt};
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[1] = 2;
        final byte[] options = byArray;
        Button[] buttons = new Button[3];
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        int i = 0;
        while (i < 3) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(messages[i]);
            final int b = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LaunchingPreferencePage.this.breakpointEnablement = options[b];
                }
            });
            whs.setHelp((Control)buttons[i], "org.eclipse.wst.server.ui.spge0032");
            ++i;
        }
        this.breakpointButtons = buttons;
    }

    protected void setBreakpointsStatus(int mode) {
        this.breakpointEnablement = mode;
        this.breakpointButtons[0].setSelection(this.breakpointEnablement == 1);
        this.breakpointButtons[1].setSelection(this.breakpointEnablement == 2);
        this.breakpointButtons[2].setSelection(this.breakpointEnablement == 0);
    }

    protected void createRestartGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(Messages.prefRestart);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        String[] messages = new String[]{Messages.prefRestartAlways, Messages.prefRestartNever, Messages.prefRestartPrompt};
        byte[] byArray = new byte[3];
        byArray[0] = 1;
        byArray[1] = 2;
        final byte[] options = byArray;
        Button[] buttons = new Button[3];
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        int i = 0;
        while (i < 3) {
            buttons[i] = new Button((Composite)group, 16);
            buttons[i].setText(messages[i]);
            final int b = i;
            buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LaunchingPreferencePage.this.restartEnablement = options[b];
                }
            });
            whs.setHelp((Control)buttons[i], "org.eclipse.wst.server.ui.spge0034");
            ++i;
        }
        this.restartButtons = buttons;
    }

    protected void setRestartStatus(int mode) {
        this.restartEnablement = mode;
        this.restartButtons[0].setSelection(this.restartEnablement == 1);
        this.restartButtons[1].setSelection(this.restartEnablement == 2);
        this.restartButtons[2].setSelection(this.restartEnablement == 0);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.publishBeforeStart.setSelection(this.preferences.isDefaultAutoPublishing());
        this.setSaveEditorStatus(this.uiPreferences.getDefaultSaveEditors());
        this.setLaunchModeStatus(this.uiPreferences.getDefaultLaunchMode());
        this.setLaunchMode2Status(this.uiPreferences.getDefaultLaunchMode2());
        this.setBreakpointsStatus(this.uiPreferences.getDefaultEnableBreakpoints());
        this.setRestartStatus(this.uiPreferences.getDefaultRestart());
        super.performDefaults();
    }

    public boolean performOk() {
        this.preferences.setAutoPublishing(this.publishBeforeStart.getSelection());
        this.uiPreferences.setSaveEditors(this.saveEditors);
        this.uiPreferences.setLaunchMode(this.launchMode);
        this.uiPreferences.setLaunchMode2(this.launchMode2);
        this.uiPreferences.setEnableBreakpoints(this.breakpointEnablement);
        this.uiPreferences.setRestart(this.restartEnablement);
        return true;
    }
}

