/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder.api;

import org.eclipse.wtp.releng.wtpbuilder.AbstractBuilder;
import org.eclipse.wtp.releng.wtpbuilder.Build;
import org.eclipse.wtp.releng.wtpbuilder.CommandOptionParser;
import org.eclipse.wtp.releng.wtpbuilder.Main;

public class AdopterBreakageBuilder
extends AbstractBuilder {
    private static final String ADOPTER_BREAKAGE_COMPLETED_BUILDS_FILE = "adopter_breakage_completed_builds.properties";
    private static final String BUILD_SCRIPT = "/releng.wtpbuilder/distribution/wtp.adopters/build.xml";
    private static final String USAGE = "Usage: java org.eclipse.wtp.releng.wtpbuilder.api.AdopterBreakageBuilder -baseos <baseos> -basews <basews> -basearch <basearch>";

    public AdopterBreakageBuilder(String completedBuildsFile) {
        super(completedBuildsFile);
    }

    public boolean build(Build build) {
        System.setProperty("buildType", build.getType());
        System.setProperty("buildId", build.getId());
        System.setProperty("timestamp", build.getDate() + build.getTime());
        System.setProperty("build.stream", build.getStream());
        System.setProperty("buildBranch", build.getStream());
        if (!build.isPublicBuild()) {
            System.setProperty("build.committers", Boolean.TRUE.toString());
        }
        String buildScript = System.getProperty("build.home") + BUILD_SCRIPT;
        Main.main(new String[]{"-f", buildScript});
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser parser = new CommandOptionParser(args);
        String baseos = parser.getOptionAsString("baseos");
        String basews = parser.getOptionAsString("basews");
        String basearch = parser.getOptionAsString("basearch");
        String login = parser.getOptionAsString("login");
        String minTS = parser.getOptionAsString("minTS");
        String buildHome = parser.getOptionAsString("build.home");
        if (baseos == null || basews == null || basearch == null) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        AdopterBreakageBuilder adopterBreakageBuilder = new AdopterBreakageBuilder(ADOPTER_BREAKAGE_COMPLETED_BUILDS_FILE);
        adopterBreakageBuilder.setBaseos(baseos);
        adopterBreakageBuilder.setBasews(basews);
        adopterBreakageBuilder.setBasearch(basearch);
        adopterBreakageBuilder.setLogin(login);
        System.setProperty("build.home", buildHome);
        if (minTS != null) {
            adopterBreakageBuilder.setMinTS(Long.parseLong(minTS));
        }
        adopterBreakageBuilder.main();
    }
}

