/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.wtpbuilder.api;

import org.eclipse.wtp.releng.wtpbuilder.AbstractBuilder;
import org.eclipse.wtp.releng.wtpbuilder.Build;
import org.eclipse.wtp.releng.wtpbuilder.CommandOptionParser;
import org.eclipse.wtp.releng.wtpbuilder.Main;

public class APIBuilder
extends AbstractBuilder {
    private static final String API_COMPLETED_BUILDS_FILE = "api_completed_builds.properties";
    private static final String USAGE = "Usage: java org.eclipse.wtp.releng.wtpbuilder.api.APIBuilder -baseos <baseos> -basews <basews> -basearch <basearch> -build.home <buildHome>";
    private static final String BUILD_SCRIPT = "/releng.wtpbuilder/distribution/wtp.api/build.xml";

    public APIBuilder(String completedBuildsFile) {
        super(completedBuildsFile);
    }

    protected boolean acceptCommitterBuilds() {
        return false;
    }

    public boolean build(Build build) {
        System.setProperty("buildType", build.getType());
        System.setProperty("buildId", build.getId());
        System.setProperty("timestamp", build.getDate() + build.getTime());
        System.setProperty("build.stream", build.getStream());
        System.setProperty("buildBranch", build.getStream());
        if (!build.isPublicBuild()) {
            System.setProperty("build.committers", Boolean.TRUE.toString());
        }
        String buildScript = System.getProperty("build.home") + BUILD_SCRIPT;
        Main.main(new String[]{"-f", buildScript});
        Main.main(new String[]{"-f", buildScript, "clean"});
        return true;
    }

    public static void main(String[] args) {
        CommandOptionParser parser = new CommandOptionParser(args);
        String baseos = parser.getOptionAsString("baseos");
        String basews = parser.getOptionAsString("basews");
        String basearch = parser.getOptionAsString("basearch");
        String login = parser.getOptionAsString("login");
        String minTS = parser.getOptionAsString("minTS");
        String buildHome = parser.getOptionAsString("build.home");
        String filename = parser.getOptionAsString("filename");
        if (baseos == null || basews == null || basearch == null || buildHome == null) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        APIBuilder apiBuilder = filename != null && filename.length() > 0 ? new APIBuilder(filename) : new APIBuilder(API_COMPLETED_BUILDS_FILE);
        apiBuilder.setBaseos(baseos);
        apiBuilder.setBasews(basews);
        apiBuilder.setBasearch(basearch);
        apiBuilder.setLogin(login);
        System.setProperty("build.home", buildHome);
        System.setProperty("display", "localhost:0");
        if (minTS != null) {
            apiBuilder.setMinTS(Long.parseLong(minTS));
        }
        apiBuilder.main();
    }
}

