/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.osgi.framework.Bundle;

public class PluginDialog
extends Dialog
implements ITreeContentProvider {
    private List ignoreNames;
    private Tree plugins;
    private String[] pluginIds;

    public PluginDialog(Shell shell, List ignoreNames) {
        super(shell);
        this.ignoreNames = ignoreNames != null ? ignoreNames : new ArrayList(0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ComponentManager.getManager().getMessage("DIALOG_TITLE_ADD_PLUGINS"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)gd);
        this.plugins = new Tree(composite, 2818);
        this.plugins.setLayout((Layout)gl);
        this.plugins.setLayoutData((Object)new GridData(1808));
        TreeViewer pluginsViewer = new TreeViewer(this.plugins);
        pluginsViewer.setContentProvider((IContentProvider)this);
        pluginsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        pluginsViewer.setInput((Object)new byte[0]);
        return composite;
    }

    protected void okPressed() {
        TreeItem[] items = this.plugins.getSelection();
        this.pluginIds = new String[items.length];
        int i = 0;
        while (i < this.pluginIds.length) {
            this.pluginIds[i] = items[i].getText();
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.pluginIds = new String[0];
        super.cancelPressed();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<String> names = new ArrayList<String>();
        IBundleGroupProvider[] bundleProviders = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < bundleProviders.length) {
            IBundleGroup[] bundleGroups = bundleProviders[i].getBundleGroups();
            int j = 0;
            while (j < bundleGroups.length) {
                Bundle[] bundles = bundleGroups[j].getBundles();
                int k = 0;
                while (k < bundles.length) {
                    String symbolicName = bundles[k].getSymbolicName();
                    if (!this.ignoreNames.contains(symbolicName)) {
                        names.add(symbolicName);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            String projectName;
            IResource res = projects[i2].findMember("plugin.xml");
            if (res != null && res.getType() == 1 && !this.ignoreNames.contains(projectName = projects[i2].getName())) {
                names.add(projectName);
            }
            ++i2;
        }
        return names.toArray(new String[0]);
    }

    public String[] getPluginIds() {
        return this.pluginIds;
    }
}

