/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests.testcase;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.wst.xsl.launching.tests.AbstractLaunchingTest;
import org.eclipse.wst.xsl.launching.tests.MockXSLLaunchShortCut;

public class LaunchShortcutTests
extends AbstractLaunchingTest {
    public LaunchShortcutTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IPath path = this.folder.getFullPath();
        this.copyConfigurationToWorkspace(path, "SimpleTransform.launch");
    }

    protected void tearDown() throws Exception {
        this.env.dispose();
        super.tearDown();
    }

    public void testShortcutExtensionPointConfigured() {
        LaunchShortcutExtension ext = this.getLaunchShortcutExtension("org.eclipse.wst.xsl.debug.ui.launchshortcut");
        LaunchShortcutTests.assertNotNull((String)"XSLT stylesheet shortcut not found", (Object)ext);
    }

    public void testXSLLaunchConfigTypeDefined() {
        MockXSLLaunchShortCut shortCut = new MockXSLLaunchShortCut();
        String typeid = "org.eclipse.wst.xsl.launching.launchConfigurationType";
        LaunchShortcutTests.assertEquals((String)"Unexpected shortcut Type", (String)typeid, (String)shortCut.testGetConfigurationType().getIdentifier());
    }

    public void testAssociatedConfigurationTypeNotSupported() {
        LaunchShortcutExtension ext = this.getLaunchShortcutExtension("org.eclipse.wst.xsl.debug.ui.launchshortcut");
        LaunchShortcutTests.assertNotNull((String)"XSLT shortcut not found", (Object)ext);
        String typeid = "org.eclipse.jdt.launching.foo";
        LaunchShortcutTests.assertTrue((String)"local xslt app shortcut should not support foo", (!ext.getAssociatedConfigurationTypes().contains(typeid) ? 1 : 0) != 0);
    }

    public List getApplicableLaunchShortcuts(String typeid) {
        ArrayList<LaunchShortcutExtension> list = new ArrayList<LaunchShortcutExtension>();
        LaunchShortcutExtension ext = null;
        List shortcuts = this.getLaunchConfigurationManager().getLaunchShortcuts();
        int i = 0;
        while (i < shortcuts.size()) {
            ext = (LaunchShortcutExtension)shortcuts.get(i);
            if (ext.getAssociatedConfigurationTypes().contains(typeid) && !WorkbenchActivityHelper.filterItem((Object)ext)) {
                list.add(ext);
            }
            ++i;
        }
        return list;
    }
}

