/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.actions.XSDEditNamespacesAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNamespaceInformationCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.nsedit.TargetNamespaceChangeHandler;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.w3c.dom.Element;

public class XSDSchemaSection
extends AbstractSection {
    IWorkbenchPart part;
    Text prefixText;
    Text targetNamespaceText;
    Button editButton;
    StyledText errorText;
    Color red;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_PREFIX"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        prefixLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "", 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.prefixText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.prefixText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.prefixText, "org.eclipse.wst.xsd.ui.xsdup0200");
        CLabel targetNamespaceLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_TARGET_NAME_SPACE"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        targetNamespaceLabel.setLayoutData((Object)data);
        this.targetNamespaceText = this.getWidgetFactory().createText(this.composite, "", 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.targetNamespaceText.setLayoutData((Object)data);
        this.applyAllListeners((Control)this.targetNamespaceText);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.targetNamespaceText, "org.eclipse.wst.xsd.ui.xsdup0210");
        this.editButton = this.getWidgetFactory().createButton(this.composite, XSDEditorPlugin.getXSDString("_UI_ACTION_EDIT_NAMESPACES"), 8);
        data = new GridData(0x1000008, 0x1000000, true, false);
        data.horizontalSpan = 2;
        this.editButton.setLayoutData((Object)data);
        this.editButton.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.editButton, "org.eclipse.wst.xsd.ui.xsdup0220");
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)parent);
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        Element element = this.xsdSchema.getElement();
        if (element != null) {
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            String aPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
            if (aPrefix != null && aPrefix.length() > 0) {
                this.prefixText.setText(aPrefix);
            } else {
                this.prefixText.setText("");
            }
            String tns = element.getAttribute("targetNamespace");
            if (tns != null && tns.length() > 0) {
                String processedString = TextProcessor.process((String)tns);
                this.targetNamespaceText.setText(processedString);
            } else {
                this.targetNamespaceText.setText("");
            }
            this.errorText.setText("");
        }
        this.setListenerEnabled(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void doHandleEvent(Event event) {
        this.errorText.setText("");
        String prefixValue = this.prefixText.getText();
        String tnsValue = this.targetNamespaceText.getText();
        Element element = this.xsdSchema.getElement();
        TypesHelper helper = new TypesHelper(this.xsdSchema);
        String currentPrefix = helper.getPrefix(element.getAttribute("targetNamespace"), false);
        String currentNamespace = this.xsdSchema.getTargetNamespace();
        if (tnsValue.trim().length() == 0 && prefixValue.trim().length() > 0) {
            this.errorText.setText(XSDEditorPlugin.getXSDString("_ERROR_TARGET_NAMESPACE_AND_PREFIX"));
            int length = this.errorText.getText().length();
            this.red = new Color(null, 255, 0, 0);
            StyleRange style = new StyleRange(0, length, this.red, this.targetNamespaceText.getBackground());
            this.errorText.setStyleRange(style);
            return;
        }
        if (event.widget == this.prefixText) {
            if (prefixValue.equals(currentPrefix)) {
                return;
            }
            this.updateNamespaceInfo(prefixValue, tnsValue);
            return;
        }
        if (event.widget != this.targetNamespaceText) return;
        if (tnsValue.equals(currentNamespace)) {
            return;
        }
        DOMNamespaceInfoManager namespaceInfoManager = new DOMNamespaceInfoManager();
        List namespaceInfoList = namespaceInfoManager.getNamespaceInfoList(this.xsdSchema.getElement());
        Element xsdSchemaElement = this.xsdSchema.getElement();
        DocumentImpl doc = (DocumentImpl)xsdSchemaElement.getOwnerDocument();
        try {
            try {
                doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_NAMESPACE_CHANGE"));
                if (tnsValue.trim().length() == 0) {
                    xsdSchemaElement.removeAttribute("targetNamespace");
                    Object var14_14 = null;
                    try {
                        this.xsdSchema.update();
                        Object var16_21 = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_20 = null;
                        doc.getModel().endRecording((Object)this);
                        throw throwable;
                    }
                    doc.getModel().endRecording((Object)this);
                    return;
                }
                Iterator i = namespaceInfoList.iterator();
                while (true) {
                    if (!i.hasNext()) {
                        this.xsdSchema.setIncrementalUpdate(false);
                        namespaceInfoManager.removeNamespaceInfo(element);
                        namespaceInfoManager.addNamespaceInfo(element, namespaceInfoList, false);
                        this.xsdSchema.setIncrementalUpdate(true);
                        this.xsdSchema.setTargetNamespace(tnsValue);
                        TargetNamespaceChangeHandler targetNamespaceChangeHandler = new TargetNamespaceChangeHandler(this.xsdSchema, currentNamespace, tnsValue);
                        targetNamespaceChangeHandler.resolve();
                        break;
                    }
                    NamespaceInfo info = (NamespaceInfo)i.next();
                    if (!info.uri.equals(currentNamespace)) continue;
                    info.uri = tnsValue;
                }
            }
            catch (Exception exception) {}
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {}
            catch (Throwable throwable2) {
                Object var16_22 = null;
                doc.getModel().endRecording((Object)this);
                throw throwable2;
            }
            this.xsdSchema.update();
            Object var16_23 = null;
            doc.getModel().endRecording((Object)this);
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            Object var16_24 = null;
            doc.getModel().endRecording((Object)this);
            throw throwable;
        }
        this.xsdSchema.update();
        Object var16_25 = null;
        doc.getModel().endRecording((Object)this);
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.editButton) {
            XSDEditNamespacesAction nsAction = new XSDEditNamespacesAction(XSDEditorPlugin.getXSDString("_UI_ACTION_EDIT_NAMESPACES"), this.xsdSchema.getElement(), null, this.xsdSchema);
            nsAction.run();
            this.refresh();
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    private void updateNamespaceInfo(String newPrefix, String newTargetNamespace) {
        UpdateNamespaceInformationCommand command = new UpdateNamespaceInformationCommand(Messages._UI_ACTION_NAMESPACE_INFORMATION_CHANGE, this.xsdSchema, newPrefix, newTargetNamespace);
        this.getCommandStack().execute((Command)command);
    }

    public void dispose() {
        if (this.prefixText != null && !this.prefixText.isDisposed()) {
            this.removeListeners((Control)this.prefixText);
        }
        if (this.targetNamespaceText != null && !this.targetNamespaceText.isDisposed()) {
            this.removeListeners((Control)this.targetNamespaceText);
        }
        if (this.red != null) {
            this.red.dispose();
            this.red = null;
        }
        super.dispose();
    }

    protected boolean validatePrefix(String prefix) {
        return true;
    }
}

