/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.ComboBoxCellEditorManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.ElementReferenceDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.LabelEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.directedit.TypeReferenceDirectEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseTypeConnectingEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CenteredConnectionAnchor;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.IAutoDirectEdit;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.INamedEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.SectionEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TypeReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.FocusTypeColumn;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTSelectionFeedbackEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.IADTUpdateCommand;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFieldFigure;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ConnectableEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.model.TargetConnectionSpaceFiller;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.GraphNodeDragTracker;
import org.eclipse.xsd.XSDNamedComponent;

public class BaseFieldEditPart
extends BaseTypeConnectingEditPart
implements INamedEditPart,
IAutoDirectEdit {
    protected TypeReferenceConnection connectionFigure;
    protected ADTDirectEditPolicy adtDirectEditPolicy = new ADTDirectEditPolicy();
    protected TypeReferenceConnection connectionFeedbackFigure;

    protected IFigure createFigure() {
        IFieldFigure figure = this.getFigureFactory().createFieldFigure(this.getModel());
        figure.setForegroundColor(ColorConstants.black);
        return figure;
    }

    public IFieldFigure getFieldFigure() {
        return (IFieldFigure)this.figure;
    }

    protected boolean shouldDrawConnection() {
        boolean result = false;
        EditPart parent = this.getParent();
        while (parent != null) {
            if (parent.getModel() instanceof FocusTypeColumn) {
                result = true;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    private EditPart getTargetEditPart(IType type) {
        EditPart parent;
        List columns;
        int index;
        ColumnEditPart columnEditPart = null;
        BaseFieldEditPart editPart = this;
        while (editPart != null) {
            if (editPart instanceof ColumnEditPart) {
                columnEditPart = (ColumnEditPart)((Object)editPart);
                break;
            }
            editPart = editPart.getParent();
        }
        if (columnEditPart != null && (index = (columns = (parent = columnEditPart.getParent()).getChildren()).indexOf(columnEditPart)) + 1 < columns.size()) {
            EditPart nextColumn = (EditPart)columns.get(index + 1);
            Iterator i = nextColumn.getChildren().iterator();
            while (i.hasNext()) {
                EditPart child = (EditPart)i.next();
                if (child.getModel() != type) continue;
                return child;
            }
        }
        return null;
    }

    private EditPart getTargetConnectionEditPart() {
        EditPart result = null;
        IField field = (IField)this.getModel();
        IType type = field.getType();
        if (type != null) {
            result = this.getTargetEP(type);
        }
        return result;
    }

    protected EditPart getTargetEP(IType type) {
        return this.getTargetEditPart(type);
    }

    public TypeReferenceConnection createConnectionFigure() {
        this.connectionFigure = null;
        AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getTargetConnectionEditPart();
        if (referenceTypePart != null) {
            this.connectionFigure = new TypeReferenceConnection();
            if (this.getFigure().getParent() == referenceTypePart.getFigure()) {
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 2, 1));
            } else {
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 3, 5));
            }
            int targetAnchorYOffset = 8;
            this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(referenceTypePart.getFigure(), 4, 0, targetAnchorYOffset));
            this.connectionFigure.setHighlight(false);
        }
        return this.connectionFigure;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.adtDirectEditPolicy);
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ADTSelectionFeedbackEditPolicy());
    }

    public EditPart doGetRelativeEditPart(EditPart editPart, int direction) {
        Object result = null;
        if (direction == 16) {
            result = this.getTargetConnectionEditPart();
        } else if (direction == 8) {
            Iterator iter = this.getParent().getChildren().iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof SectionEditPart)) continue;
                SectionEditPart groups = (SectionEditPart)child;
                Iterator i = groups.getChildren().iterator();
                while (i.hasNext()) {
                    Object groupChild = i.next();
                    ConnectableEditPart connectable = this.getParentConnectableEditPart((EditPart)groupChild);
                    if (connectable == null) continue;
                    result = connectable;
                }
            }
            if (result == null) {
                result = this;
            }
        } else {
            result = super.doGetRelativeEditPart(editPart, direction);
            if (result == null) {
                result = ((BaseEditPart)this.getParent()).doGetRelativeEditPart(editPart, direction);
            }
        }
        return result;
    }

    protected ConnectableEditPart getParentConnectableEditPart(EditPart connectable) {
        TargetConnectionSpaceFiller space;
        if (connectable instanceof TargetConnectionSpacingFigureEditPart && (space = (TargetConnectionSpaceFiller)((TargetConnectionSpacingFigureEditPart)connectable).getModel()).getAdapter() == this.getModel()) {
            return (ConnectableEditPart)connectable;
        }
        Iterator i = connectable.getChildren().iterator();
        while (i.hasNext()) {
            TargetConnectionSpaceFiller space2;
            Object child = i.next();
            if (child instanceof ConnectableEditPart) {
                ConnectableEditPart r = this.getParentConnectableEditPart((EditPart)child);
                if (r == null) continue;
                return r;
            }
            if (!(child instanceof TargetConnectionSpacingFigureEditPart) || (space2 = (TargetConnectionSpaceFiller)((TargetConnectionSpacingFigureEditPart)child).getModel()).getAdapter() != this.getModel() || !(connectable instanceof ConnectableEditPart)) continue;
            return (ConnectableEditPart)connectable;
        }
        return null;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFieldFigure figure = this.getFieldFigure();
        IField field = (IField)this.getModel();
        figure.getNameLabel().setText(field.getName());
        figure.getTypeLabel().setText(field.getTypeName());
        figure.refreshVisuals(this.getModel());
        figure.recomputeLayout();
        ((GraphicalEditPart)this.getRoot()).getFigure().invalidateTree();
    }

    public DragTracker getDragTracker(Request request) {
        return new GraphNodeDragTracker((EditPart)this);
    }

    public Label getNameLabelFigure() {
        return this.getFieldFigure().getNameLabel();
    }

    public void performDirectEdit(Point cursorLocation) {
    }

    public void performRequest(Request request) {
        if (((IADTObject)this.getModel()).isReadOnly() || this.isFileReadOnly()) {
            return;
        }
        if (request.getType() == "direct edit" || request.getType() == "open") {
            IFieldFigure fieldFigure = this.getFieldFigure();
            Object model = this.getModel();
            if (request instanceof LocationRequest) {
                LocationRequest locationRequest = (LocationRequest)request;
                Point p = locationRequest.getLocation();
                if (this.hitTest((IFigure)fieldFigure.getTypeLabel(), p)) {
                    TypeReferenceDirectEditManager manager = new TypeReferenceDirectEditManager((IField)model, this, fieldFigure.getTypeLabel());
                    TypeUpdateCommand typeUpdateCommand = new TypeUpdateCommand();
                    typeUpdateCommand.setDelegate(manager);
                    this.adtDirectEditPolicy.setUpdateCommand(typeUpdateCommand);
                    manager.show();
                } else if (this.hitTest((IFigure)fieldFigure.getNameLabel(), p)) {
                    this.directEditNameField();
                }
            } else {
                this.directEditNameField();
            }
        }
    }

    protected void directEditNameField() {
        if (this.isFileReadOnly()) {
            return;
        }
        Object model = this.getModel();
        IFieldFigure fieldFigure = this.getFieldFigure();
        if (model instanceof IField) {
            IField field = (IField)model;
            if (field.isReference()) {
                ElementReferenceDirectEditManager manager = new ElementReferenceDirectEditManager((IField)model, this, fieldFigure.getNameLabel());
                ReferenceUpdateCommand elementUpdateCommand = new ReferenceUpdateCommand();
                elementUpdateCommand.setDelegate(manager);
                this.adtDirectEditPolicy.setUpdateCommand(elementUpdateCommand);
                manager.show();
            } else {
                LabelEditManager manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, null));
                NameUpdateCommandWrapper wrapper = new NameUpdateCommandWrapper();
                this.adtDirectEditPolicy.setUpdateCommand(wrapper);
                manager.show();
            }
        }
    }

    public void doEditName(boolean addFromDesign) {
        if (!addFromDesign) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Notifier object = ((XSDBaseAdapter)BaseFieldEditPart.this.getModel()).getTarget();
                if (object instanceof XSDNamedComponent) {
                    Point p = BaseFieldEditPart.this.getNameLabelFigure().getLocation();
                    LabelEditManager manager = new LabelEditManager((GraphicalEditPart)BaseFieldEditPart.this, new LabelCellEditorLocator(BaseFieldEditPart.this, p));
                    NameUpdateCommandWrapper wrapper = new NameUpdateCommandWrapper();
                    BaseFieldEditPart.this.adtDirectEditPolicy.setUpdateCommand(wrapper);
                    manager.show();
                }
            }
        };
        Display.getCurrent().asyncExec(runnable);
    }

    public void addFeedback() {
        if (this.connectionFigure != null && !this.isSelected) {
            this.connectionFeedbackFigure = new TypeReferenceConnection();
            this.connectionFeedbackFigure.setSourceAnchor(this.connectionFigure.getSourceAnchor());
            this.connectionFeedbackFigure.setTargetAnchor(this.connectionFigure.getTargetAnchor());
            this.connectionFeedbackFigure.setHighlight(true);
            this.getLayer("Feedback Layer").add((IFigure)this.connectionFeedbackFigure);
        }
        super.addFeedback();
        this.getFieldFigure().addSelectionFeedback();
    }

    public void removeFeedback() {
        if (this.connectionFeedbackFigure != null) {
            this.connectionFeedbackFigure.setHighlight(false);
            this.getLayer("Feedback Layer").remove((IFigure)this.connectionFeedbackFigure);
        }
        this.connectionFeedbackFigure = null;
        super.removeFeedback();
        this.getFieldFigure().removeSelectionFeedback();
    }

    protected class NameUpdateCommandWrapper
    extends Command
    implements IADTUpdateCommand {
        Command command;
        protected DirectEditRequest request;

        public NameUpdateCommandWrapper() {
            super(Messages._UI_ACTION_UPDATE_NAME);
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            IField field = (IField)BaseFieldEditPart.this.getModel();
            Object newValue = this.request.getCellEditor().getValue();
            if (newValue instanceof String) {
                this.command = field.getUpdateNameCommand((String)newValue);
            }
            if (this.command != null) {
                this.command.execute();
            }
        }
    }

    protected class ReferenceUpdateCommand
    extends Command
    implements IADTUpdateCommand {
        protected ComboBoxCellEditorManager delegate;
        protected DirectEditRequest request;

        public ReferenceUpdateCommand() {
            super(Messages._UI_ACTION_UPDATE_ELEMENT_REFERENCE);
        }

        public void setDelegate(ComboBoxCellEditorManager delegate) {
            this.delegate = delegate;
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            if (this.delegate != null) {
                this.delegate.performEdit(this.request.getCellEditor());
            }
        }

        public boolean canExecute() {
            return true;
        }
    }

    class TypeUpdateCommand
    extends Command
    implements IADTUpdateCommand {
        protected ComboBoxCellEditorManager delegate;
        protected DirectEditRequest request;

        public TypeUpdateCommand() {
            super(Messages._UI_ACTION_UPDATE_TYPE);
        }

        public void setDelegate(ComboBoxCellEditorManager delegate) {
            this.delegate = delegate;
        }

        public void setRequest(DirectEditRequest request) {
            this.request = request;
        }

        public void execute() {
            if (this.delegate != null) {
                this.delegate.performEdit(this.request.getCellEditor());
            }
        }

        public boolean canExecute() {
            IField field = (IField)BaseFieldEditPart.this.getModel();
            String newValue = ((CCombo)this.request.getCellEditor().getControl()).getText();
            if (newValue instanceof String) {
                return !newValue.equals(field.getTypeName());
            }
            return true;
        }
    }
}

