/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.consumption.core.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.internal.cxf.consumption.core.CXFConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.JavaResourceChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.CommandLineUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WSDL2JavaClientCommand
extends AbstractDataModelOperation {
    public static final String CXF_TOOL_CLASS_NAME = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    private WSDL2JavaDataModel model;
    private JavaResourceChangeListener javaResourceChangeListener;

    public WSDL2JavaClientCommand(WSDL2JavaDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.javaResourceChangeListener = new JavaResourceChangeListener(this.model.getJavaSourceFolder());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener, 1);
        String[] progArgs = CommandLineUtils.getWSDL2JavaGenerateClientArguments((WSDL2JavaDataModel)this.model);
        try {
            String projectName = this.model.getProjectName();
            IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
            LaunchUtils.launch((IJavaProject)javaProject, (String)CXF_TOOL_CLASS_NAME, (String[])progArgs);
            FileUtils.copyW2JFilesFromTmp((WSDL2JavaDataModel)this.model);
        }
        catch (CoreException ce) {
            status = ce.getStatus();
            CXFConsumptionCorePlugin.log(status);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.javaResourceChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFConsumptionCorePlugin.log(status);
                }
            }
        }
        return status;
    }
}

