/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core.processor;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.util.SourcePosition;
import java.util.Collection;
import org.eclipse.jdt.apt.core.util.EclipseMessager;

public abstract class AbstractAnnotationProcessor
implements AnnotationProcessor {
    protected AnnotationProcessorEnvironment environment;

    public void setAnnotationProcessorEnvironment(AnnotationProcessorEnvironment environment) {
        this.environment = environment;
    }

    public abstract void process();

    protected void printError(AnnotationTypeDeclaration annotationDeclaration, MethodDeclaration methodDeclaration, String errorMessage) {
        Collection annotationMirrors = methodDeclaration.getAnnotationMirrors();
        for (AnnotationMirror mirror : annotationMirrors) {
            if (!mirror.getAnnotationType().toString().equals(annotationDeclaration.getQualifiedName())) continue;
            this.environment.getMessager().printError(mirror.getPosition(), errorMessage);
        }
    }

    protected void printError(SourcePosition position, String message) {
        this.environment.getMessager().printError(position, message);
    }

    protected void printError(String message) {
        this.environment.getMessager().printError(message);
    }

    protected void printWarning(SourcePosition position, String message) {
        this.environment.getMessager().printWarning(position, message);
    }

    protected void printWarning(String message) {
        this.environment.getMessager().printWarning(message);
    }

    protected void printNotice(SourcePosition position, String message) {
        this.environment.getMessager().printNotice(position, message);
    }

    protected void printNotice(String message) {
        this.environment.getMessager().printNotice(message);
    }

    protected void printFixableError(SourcePosition position, String message) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableError(position, message, "", message);
    }

    protected void printFixableError(SourcePosition position, String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableError(position, message, pluginId, errorId);
    }

    protected void printFixableError(String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableError(message, pluginId, errorId);
    }

    protected void printFixableWarning(SourcePosition position, String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableWarning(position, message, pluginId, errorId);
    }

    protected void printFixableWarning(String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableWarning(message, pluginId, errorId);
    }

    protected void printFixableNotice(SourcePosition position, String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableNotice(position, message, pluginId, errorId);
    }

    protected void printFixableNotice(String message, String pluginId, String errorId) {
        EclipseMessager messager = (EclipseMessager)this.environment.getMessager();
        messager.printFixableNotice(message, pluginId, errorId);
    }
}

