/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.swing;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.jpt.utility.internal.model.listener.awt.AWTListChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.model.listener.awt.AWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.swing.ColumnAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelAdapter<E>
extends AbstractTableModel {
    private ListValueModel<? extends E> listHolder;
    private final ListChangeListener listChangeListener;
    private final ArrayList<WritablePropertyValueModel<Object>[]> rows;
    private final ColumnAdapter columnAdapter;
    private final PropertyChangeListener cellListener;

    public TableModelAdapter(ListValueModel<? extends E> listHolder, ColumnAdapter columnAdapter) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.columnAdapter = columnAdapter;
        this.listChangeListener = this.buildListChangeListener();
        this.rows = new ArrayList();
        this.cellListener = this.buildCellListener();
    }

    public TableModelAdapter(CollectionValueModel<? extends E> collectionHolder, ColumnAdapter columnAdapter) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), columnAdapter);
    }

    protected ListChangeListener buildListChangeListener() {
        return new AWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            @Override
            public void itemsAdded(ListChangeEvent event) {
                TableModelAdapter.this.addRows(event.getIndex(), event.itemsSize(), this.items(event));
            }

            @Override
            public void itemsRemoved(ListChangeEvent event) {
                TableModelAdapter.this.removeRows(event.getIndex(), event.itemsSize());
            }

            @Override
            public void itemsReplaced(ListChangeEvent event) {
                TableModelAdapter.this.replaceRows(event.getIndex(), this.items(event));
            }

            @Override
            public void itemsMoved(ListChangeEvent event) {
                TableModelAdapter.this.moveRows(event.getTargetIndex(), event.getSourceIndex(), event.getMoveLength());
            }

            @Override
            public void listCleared(ListChangeEvent event) {
                TableModelAdapter.this.clearTable();
            }

            @Override
            public void listChanged(ListChangeEvent event) {
                TableModelAdapter.this.rebuildTable();
            }

            protected Iterator<Object> items(ListChangeEvent event) {
                return event.items();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    protected PropertyChangeListener buildCellListener() {
        return new AWTPropertyChangeListenerWrapper(this.buildCellListener_());
    }

    protected PropertyChangeListener buildCellListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TableModelAdapter.this.cellChanged((WritablePropertyValueModel)event.getSource());
            }

            public String toString() {
                return "cell listener";
            }
        };
    }

    @Override
    public int getColumnCount() {
        return this.columnAdapter.columnCount();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnAdapter.columnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnAdapter.columnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnAdapter.columnIsEditable(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        WritablePropertyValueModel<Object>[] row = this.rows.get(rowIndex);
        return row[columnIndex].getValue();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        WritablePropertyValueModel<Object>[] row = this.rows.get(rowIndex);
        row[columnIndex].setValue(value);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.hasNoTableModelListeners()) {
            this.engageModel();
        }
        super.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
        if (this.hasNoTableModelListeners()) {
            this.disengageModel();
        }
    }

    public ListValueModel<? extends E> getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel<E> listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasTableModelListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.fireTableDataChanged();
        }
    }

    public void setModel(CollectionValueModel<E> collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter<E>(collectionHolder));
    }

    protected boolean hasNoTableModelListeners() {
        return this.listenerList.getListenerCount(TableModelListener.class) == 0;
    }

    protected boolean hasTableModelListeners() {
        return !this.hasNoTableModelListeners();
    }

    private void engageModel() {
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.engageAllCells();
    }

    private void engageAllCells() {
        this.rows.ensureCapacity(this.listHolder.size());
        Iterator<E> stream = this.listHolder.iterator();
        while (stream.hasNext()) {
            WritablePropertyValueModel<Object>[] row = this.columnAdapter.cellModels(stream.next());
            this.engageRow(row);
            this.rows.add(row);
        }
    }

    private void engageRow(WritablePropertyValueModel<Object>[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].addPropertyChangeListener("value", this.cellListener);
        }
    }

    private void disengageModel() {
        this.disengageAllCells();
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    private void disengageAllCells() {
        for (WritablePropertyValueModel<Object>[] row : this.rows) {
            this.disengageRow(row);
        }
        this.rows.clear();
    }

    private void disengageRow(WritablePropertyValueModel<Object>[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].removePropertyChangeListener("value", this.cellListener);
        }
    }

    void cellChanged(WritablePropertyValueModel<Object> cellHolder) {
        int i = this.rows.size();
        while (i-- > 0) {
            WritablePropertyValueModel<Object>[] row = this.rows.get(i);
            int j = row.length;
            while (j-- > 0) {
                if (row[j] != cellHolder) continue;
                this.fireTableCellUpdated(i, j);
            }
        }
    }

    void addRows(int index, int size, Iterator<Object> items) {
        ArrayList<WritablePropertyValueModel<Object>[]> newRows = new ArrayList<WritablePropertyValueModel<Object>[]>(size);
        while (items.hasNext()) {
            WritablePropertyValueModel<Object>[] row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            newRows.add(row);
        }
        this.rows.addAll(index, newRows);
        this.fireTableRowsInserted(index, index + size - 1);
    }

    void removeRows(int index, int size) {
        int i = 0;
        while (i < size) {
            this.disengageRow(this.rows.remove(index));
            ++i;
        }
        this.fireTableRowsDeleted(index, index + size - 1);
    }

    void replaceRows(int index, Iterator<Object> items) {
        int i = index;
        while (items.hasNext()) {
            WritablePropertyValueModel<Object>[] row = this.rows.get(i);
            this.disengageRow(row);
            row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            this.rows.set(i, row);
            ++i;
        }
        this.fireTableRowsUpdated(index, i - 1);
    }

    void moveRows(int targetIndex, int sourceIndex, int length) {
        ArrayList<WritablePropertyValueModel<Object>[]> temp = new ArrayList<WritablePropertyValueModel<Object>[]>(length);
        int i = 0;
        while (i < length) {
            temp.add(this.rows.remove(sourceIndex));
            ++i;
        }
        this.rows.addAll(targetIndex, temp);
        int start = Math.min(targetIndex, sourceIndex);
        int end = Math.max(targetIndex, sourceIndex) + length - 1;
        this.fireTableRowsUpdated(start, end);
    }

    void clearTable() {
        this.disengageAllCells();
        this.fireTableDataChanged();
    }

    void rebuildTable() {
        this.disengageAllCells();
        this.engageAllCells();
        this.fireTableDataChanged();
    }
}

