/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value.prefs;

import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.jpt.utility.internal.BidiStringConverter;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencePropertyValueModel<P>
extends AspectAdapter<Preferences>
implements WritablePropertyValueModel<P> {
    protected final String key;
    protected P value;
    protected final P defaultValue;
    protected final BidiStringConverter<P> converter;
    protected final PreferenceChangeListener preferenceChangeListener;

    public PreferencePropertyValueModel(Preferences preferences, String key) {
        this(preferences, key, null);
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, P defaultValue) {
        this(preferences, key, defaultValue, BidiStringConverter.Default.instance());
    }

    public PreferencePropertyValueModel(Preferences preferences, String key, P defaultValue, BidiStringConverter<P> converter) {
        this(new StaticPropertyValueModel<Preferences>(preferences), key, defaultValue, converter);
    }

    public static PreferencePropertyValueModel<Boolean> forBoolean(Preferences preferences, String key, boolean defaultValue) {
        return new PreferencePropertyValueModel<Boolean>(preferences, key, defaultValue ? Boolean.TRUE : Boolean.FALSE, BidiStringConverter.BooleanConverter.instance());
    }

    public static PreferencePropertyValueModel<Integer> forInteger(Preferences preferences, String key, int defaultValue) {
        return new PreferencePropertyValueModel<Integer>(preferences, key, new Integer(defaultValue), BidiStringConverter.IntegerConverter.instance());
    }

    public PreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesHolder, String key) {
        this(preferencesHolder, key, null);
    }

    public PreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesHolder, String key, P defaultValue) {
        this(preferencesHolder, key, defaultValue, BidiStringConverter.Default.instance());
    }

    public PreferencePropertyValueModel(PropertyValueModel<? extends Preferences> preferencesHolder, String key, P defaultValue, BidiStringConverter<P> converter) {
        super(preferencesHolder);
        this.key = key;
        this.defaultValue = defaultValue;
        this.converter = converter;
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
        this.value = null;
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent event) {
                PreferencePropertyValueModel.this.preferenceChanged(event.getKey(), event.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    @Override
    public synchronized P getValue() {
        return this.value;
    }

    @Override
    public synchronized void setValue(P value) {
        if (this.hasNoListeners()) {
            return;
        }
        P old = this.value;
        this.value = value;
        this.fireAspectChange(old, value);
        if (this.subject != null && this.shouldSetPreference(old, value)) {
            this.setValue_(value);
        }
    }

    @Override
    protected Class<? extends ChangeListener> getListenerClass() {
        return PropertyChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "value";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected void engageSubject_() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        this.value = this.buildValue();
    }

    @Override
    protected void disengageSubject_() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Node has been removed.")) break block2;
                throw ex;
            }
        }
        this.value = null;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.key);
        sb.append(" => ");
        sb.append(this.value);
    }

    public String getKey() {
        return this.key;
    }

    protected P buildValue() {
        return this.subject == null ? null : (P)this.buildValue_();
    }

    protected P buildValue_() {
        return this.convertToObject(((Preferences)this.subject).get(this.key, this.convertToString(this.defaultValue)));
    }

    protected void setValue_(P value) {
        ((Preferences)this.subject).put(this.key, this.convertToString(value));
    }

    protected boolean shouldSetPreference(Object oldValue, Object newValue) {
        return this.attributeValueHasChanged(oldValue, newValue);
    }

    protected String convertToString(P o) {
        return this.converter.convertToString(o);
    }

    protected P convertToObject(String s) {
        return this.converter.convertToObject(s);
    }

    protected void preferenceChanged(String prefKey, String newValue) {
        if (prefKey.equals(this.key)) {
            this.preferenceChanged();
        }
    }

    protected synchronized void preferenceChanged() {
        P old = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(old, this.value);
    }
}

