/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.persistence.details;

import java.util.ListIterator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaPageComposite;
import org.eclipse.jpt.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveTablePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitPropertiesComposite
extends Pane<PersistenceUnit>
implements JpaPageComposite {
    private WritablePropertyValueModel<PersistenceUnit.Property> propertyHolder;
    private TablePane tablePane;

    public PersistenceUnitPropertiesComposite(PropertyValueModel<PersistenceUnit> subjectHolder, Composite container, WidgetFactory widgetFactory) {
        super(subjectHolder, container, widgetFactory);
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertiesListHolder() {
        return new ListAspectAdapter<PersistenceUnit, PersistenceUnit.Property>(this.getSubjectHolder(), new String[]{"properties"}){

            protected ListIterator<PersistenceUnit.Property> listIterator_() {
                return ((PersistenceUnit)this.subject).properties();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).propertiesSize();
            }
        };
    }

    private ITableLabelProvider buildPropertyLabelProvider() {
        return new TableLabelProvider();
    }

    private AddRemovePane.Adapter buildTableAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                PersistenceUnit.Property property = ((PersistenceUnit)PersistenceUnitPropertiesComposite.this.getSubject()).addProperty();
                PersistenceUnitPropertiesComposite.this.propertyHolder.setValue((Object)property);
                int index = ((PersistenceUnit)PersistenceUnitPropertiesComposite.this.getSubject()).propertiesSize() - 1;
                TableItem tableItem = PersistenceUnitPropertiesComposite.this.tablePane.getMainControl().getItem(index);
                PersistenceUnitPropertiesComposite.this.tablePane.getMainControl().showItem(tableItem);
                PersistenceUnitPropertiesComposite.this.tablePane.getTableViewer().editElement((Object)property, 1);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((PersistenceUnit)PersistenceUnitPropertiesComposite.this.getSubject()).removeProperty((PersistenceUnit.Property)item);
                    ++n2;
                }
            }
        };
    }

    @Override
    public String getHelpID() {
        return "org.eclipse.jpt.ui.persistence_properties";
    }

    @Override
    public Image getPageImage() {
        return null;
    }

    @Override
    public String getPageText() {
        return JptUiPersistenceMessages.PersistenceUnitPropertiesComposite_properties;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.propertyHolder = new SimplePropertyValueModel();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptUiPersistenceMessages.PersistenceUnitPropertiesComposite_properties_description);
        this.tablePane = new TablePane(container);
        container.setLayoutData((Object)new GridData(1808));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyColumnAdapter
    implements ColumnAdapter<PersistenceUnit.Property> {
        public static final int COLUMN_COUNT = 3;
        public static final int NAME_COLUMN = 1;
        public static final int SELECTION_COLUMN = 0;
        public static final int VALUE_COLUMN = 2;

        private PropertyColumnAdapter() {
        }

        private WritablePropertyValueModel<String> buildNameHolder(PersistenceUnit.Property subject) {
            return new PropertyAspectAdapter<PersistenceUnit.Property, String>("name", subject){

                protected String buildValue_() {
                    return ((PersistenceUnit.Property)this.subject).getName();
                }

                protected void setValue_(String value) {
                    ((PersistenceUnit.Property)this.subject).setName(value);
                }
            };
        }

        private WritablePropertyValueModel<String> buildValueHolder(PersistenceUnit.Property subject) {
            return new PropertyAspectAdapter<PersistenceUnit.Property, String>("value", subject){

                protected String buildValue_() {
                    return ((PersistenceUnit.Property)this.subject).getValue();
                }

                protected void setValue_(String value) {
                    ((PersistenceUnit.Property)this.subject).setValue(value);
                }
            };
        }

        @Override
        public WritablePropertyValueModel<?>[] cellModels(PersistenceUnit.Property subject) {
            WritablePropertyValueModel[] holders = new WritablePropertyValueModel[]{new SimplePropertyValueModel(), this.buildNameHolder(subject), this.buildValueHolder(subject)};
            return holders;
        }

        @Override
        public int columnCount() {
            return 3;
        }

        @Override
        public String columnName(int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    return JptUiPersistenceMessages.PersistenceUnitPropertiesComposite_nameColumn;
                }
                case 2: {
                    return JptUiPersistenceMessages.PersistenceUnitPropertiesComposite_valueColumn;
                }
            }
            return null;
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PersistenceUnit.Property property = (PersistenceUnit.Property)element;
            String value = null;
            switch (columnIndex) {
                case 1: {
                    value = property.getName();
                    break;
                }
                case 2: {
                    value = property.getValue();
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TablePane
    extends AddRemoveTablePane<PersistenceUnit> {
        private final String SELECTION_COLUMN = "selection";
        private TableViewer tableViewer;

        private TablePane(Composite parent) {
            super(PersistenceUnitPropertiesComposite.this, parent, PersistenceUnitPropertiesComposite.this.buildTableAdapter(), PersistenceUnitPropertiesComposite.this.buildPropertiesListHolder(), PersistenceUnitPropertiesComposite.this.propertyHolder, PersistenceUnitPropertiesComposite.this.buildPropertyLabelProvider());
            this.SELECTION_COLUMN = "selection";
        }

        @Override
        protected Composite addContainer(Composite parent) {
            Composite container = super.addContainer(parent);
            container.setLayoutData((Object)new GridData(1808));
            return container;
        }

        private CellEditor[] buildCellEditors(Table table) {
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = new TextCellEditor((Composite)table);
            cellEditorArray[2] = new TextCellEditor((Composite)table);
            return cellEditorArray;
        }

        private ICellModifier buildCellModifier() {
            return new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return !"selection".equals(property);
                }

                public Object getValue(Object element, String property) {
                    PersistenceUnit.Property propertyModel = (PersistenceUnit.Property)element;
                    String value = null;
                    if (property == "name") {
                        value = propertyModel.getName();
                    } else if (property == "value") {
                        value = propertyModel.getValue();
                    }
                    if (value == null) {
                        value = "";
                    }
                    return value;
                }

                public void modify(Object element, String property, Object value) {
                    PersistenceUnit.Property propertyModel;
                    if (element instanceof TableItem) {
                        TableItem tableItem = (TableItem)element;
                        propertyModel = (PersistenceUnit.Property)tableItem.getData();
                    } else {
                        propertyModel = (PersistenceUnit.Property)element;
                    }
                    if (property == "name") {
                        propertyModel.setName(value.toString());
                    } else if (property == "value") {
                        propertyModel.setValue(value.toString());
                    }
                }
            };
        }

        @Override
        protected ColumnAdapter<?> buildColumnAdapter() {
            return new PropertyColumnAdapter();
        }

        private String[] buildColumnProperties() {
            return new String[]{"selection", "name", "value"};
        }

        TableViewer getTableViewer() {
            return this.tableViewer;
        }

        @Override
        protected void initializeMainComposite(Composite container, AddRemovePane.Adapter adapter, ListValueModel<?> listHolder, WritablePropertyValueModel<?> selectedItemHolder, IBaseLabelProvider labelProvider, String helpId) {
            super.initializeMainComposite(container, adapter, listHolder, selectedItemHolder, labelProvider, helpId);
            Table table = this.getMainControl();
            table.setLayoutData((Object)new GridData(1808));
            TableColumn selectionColumn = table.getColumn(0);
            selectionColumn.setResizable(false);
            selectionColumn.setWidth(20);
            this.tableViewer = new TableViewer(table);
            this.tableViewer.setCellEditors(this.buildCellEditors(table));
            this.tableViewer.setCellModifier(this.buildCellModifier());
            this.tableViewer.setColumnProperties(this.buildColumnProperties());
        }

        @Override
        protected void itemsAdded(ListChangeEvent e) {
            super.itemsAdded(e);
            this.revalidateLayout();
        }

        @Override
        protected void itemsRemoved(ListChangeEvent e) {
            super.itemsRemoved(e);
            this.revalidateLayout();
        }

        @Override
        protected void listChanged(ListChangeEvent e) {
            super.listChanged(e);
            this.revalidateLayout();
        }

        private void revalidateLayout() {
            SWTUtil.asyncExec(new Runnable(){

                public void run() {
                    Table table = TablePane.this.getMainControl();
                    if (!table.isDisposed()) {
                        SWTUtil.reflow((Composite)table);
                    }
                }
            });
        }
    }
}

