/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;

public class RemoveModuleAction
extends Action {
    protected IServer server;
    protected IModule[] module;
    protected Shell shell;
    CoreException saveServerException = null;

    public RemoveModuleAction(Shell shell, IServer server, IModule module) {
        this(shell, server, new IModule[]{module});
    }

    public RemoveModuleAction(Shell shell, IServer server, IModule[] module) {
        super(Messages.actionRemove);
        this.shell = shell;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.server = server;
        this.module = module;
    }

    public void run() {
        String message;
        String string = message = this.module.length == 1 ? Messages.dialogRemoveModuleConfirm : Messages.dialogRemoveModulesConfirm;
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)message)) {
            int i = 0;
            while (i < this.module.length) {
                this.handleRemoveOneModule(this.module[i]);
                ++i;
            }
        }
    }

    protected void handleRemoveOneModule(final IModule mod) {
        block4: {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
                dialog.setBlockOnOpen(false);
                dialog.setCancelable(true);
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            IServerWorkingCopy wc = RemoveModuleAction.this.server.createWorkingCopy();
                            if (monitor.isCanceled()) {
                                return;
                            }
                            wc.modifyModules(null, new IModule[]{mod}, monitor);
                            if (monitor.isCanceled()) {
                                return;
                            }
                            RemoveModuleAction.this.server = wc.save(true, monitor);
                            if (Trace.INFO) {
                                Trace.trace("/info", "Done save server configuration in RemoveModuleAction.");
                            }
                        }
                        catch (CoreException e) {
                            if (Trace.WARNING) {
                                Trace.trace("/warning", "Failed to save server configuration. Could not remove module", e);
                            }
                            RemoveModuleAction.this.saveServerException = e;
                        }
                    }
                };
                dialog.run(true, true, runnable);
                if (this.saveServerException != null) {
                    return;
                }
                if (this.server.getServerState() != 4 && ServerUIPlugin.getPreferences().getPublishOnAddRemoveModule()) {
                    IAdaptable info = new IAdaptable(){

                        public Object getAdapter(Class adapter) {
                            if (Shell.class.equals((Object)adapter)) {
                                return RemoveModuleAction.this.shell;
                            }
                            if (String.class.equals((Object)adapter)) {
                                return "user";
                            }
                            return null;
                        }
                    };
                    this.server.publish(1, null, info, null);
                }
            }
            catch (Exception e) {
                if (!Trace.WARNING) break block4;
                Trace.trace("/warning", "Could not remove module", e);
            }
        }
    }
}

