/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EARComponentSaveStrategyImpl
extends ComponentSaveStrategyImpl {
    public EARComponentSaveStrategyImpl(IVirtualComponent component) {
        super(component);
    }

    public void setDataModel(IDataModel dataModel) {
        super.setDataModel(dataModel);
    }

    protected EARFile getEARFile() {
        return (EARFile)this.getArchive();
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return null;
    }

    public void save() throws SaveFailureException {
        this.saveFiles();
        this.saveManifest();
        this.saveMofResources();
        this.progressMonitor.subTask(EARArchiveOpsResourceHandler.Updating_project_classpath_UI_);
    }

    public void save(Archive anArchive) throws SaveFailureException {
        this.progressMonitor.subTask(anArchive.getURI());
        this.saveArchiveAsJARInEAR(anArchive);
    }

    protected void saveArchiveAsJARInEAR(Archive anArchive) throws SaveFailureException {
        try {
            anArchive.save(this.createNestedSaveStrategy(anArchive));
            this.progressMonitor.worked(1);
        }
        catch (IOException e) {
            throw new SaveFailureException(anArchive.getURI(), (Exception)e);
        }
    }

    protected SubProgressMonitor subMonitor() {
        return new SubProgressMonitor(this.progressMonitor, 10);
    }

    public void setMonitor(IProgressMonitor newMonitor) {
        this.progressMonitor = newMonitor;
    }

    protected boolean shouldSave(File aFile) {
        if (aFile.isArchive()) {
            return this.getFilter().shouldSave(aFile.getURI(), this.getArchive());
        }
        return super.shouldSave(aFile);
    }

    protected boolean shouldLinkAsComponentRef(Archive archive) {
        return true;
    }

    protected boolean shouldSave(String uri) {
        if (this.overwriteHandler != null) {
            if (this.overwriteHandler.isOverwriteNone()) {
                return false;
            }
            return super.shouldSave(uri) && (this.overwriteHandler.isOverwriteAll() || this.overwriteHandler.isOverwriteResources() || this.overwriteHandler.shouldOverwrite(uri));
        }
        return true;
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualFile vFile = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile iFile = vFile.getUnderlyingFile();
        this.validateEdit(iFile);
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(iFile);
        try {
            try {
                aManifest.write((OutputStream)out);
            }
            catch (IOException e) {
                J2EEPlugin.logError(e);
                try {
                    out.close();
                }
                catch (IOException e2) {
                    J2EEPlugin.logError(e2);
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                J2EEPlugin.logError(e);
            }
        }
    }
}

