/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.utility.swt;

import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BooleanButtonModelBinding {
    private final WritablePropertyValueModel<Boolean> booleanModel;
    private final PropertyChangeListener booleanChangeListener;
    private final boolean defaultValue;
    private final Button button;
    private final SelectionListener buttonSelectionListener;
    private final DisposeListener buttonDisposeListener;

    BooleanButtonModelBinding(WritablePropertyValueModel<Boolean> booleanModel, Button button, boolean defaultValue) {
        if (booleanModel == null || button == null) {
            throw new NullPointerException();
        }
        this.booleanModel = booleanModel;
        this.button = button;
        this.defaultValue = defaultValue;
        this.booleanChangeListener = this.buildBooleanChangeListener();
        this.booleanModel.addPropertyChangeListener("value", this.booleanChangeListener);
        this.buttonSelectionListener = this.buildButtonSelectionListener();
        this.button.addSelectionListener(this.buttonSelectionListener);
        this.buttonDisposeListener = this.buildButtonDisposeListener();
        this.button.addDisposeListener(this.buttonDisposeListener);
        this.setButtonSelection((Boolean)this.booleanModel.getValue());
    }

    private PropertyChangeListener buildBooleanChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildBooleanChangeListener_());
    }

    private PropertyChangeListener buildBooleanChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                BooleanButtonModelBinding.this.booleanChanged(event);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    private SelectionListener buildButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BooleanButtonModelBinding.this.buttonSelected();
            }

            public String toString() {
                return "button selection listener";
            }
        };
    }

    private DisposeListener buildButtonDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BooleanButtonModelBinding.this.buttonDisposed();
            }

            public String toString() {
                return "button dispose listener";
            }
        };
    }

    void booleanChanged(PropertyChangeEvent event) {
        this.setButtonSelection((Boolean)event.getNewValue());
    }

    private void setButtonSelection(Boolean b) {
        if (!this.button.isDisposed()) {
            this.button.setSelection(this.booleanValue(b));
        }
    }

    private boolean booleanValue(Boolean b) {
        return b != null ? b : this.defaultValue;
    }

    void buttonSelected() {
        if (!this.button.isDisposed()) {
            this.booleanModel.setValue((Object)this.button.getSelection());
        }
    }

    void buttonDisposed() {
        this.button.removeSelectionListener(this.buttonSelectionListener);
        this.button.removeDisposeListener(this.buttonDisposeListener);
        this.booleanModel.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.booleanModel);
    }
}

