/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.ReferenceTable;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmReferenceTable;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlReferenceTable;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericOrmReferenceTable
extends AbstractOrmTable
implements OrmReferenceTable {
    protected OrmJoinColumn defaultJoinColumn;
    protected final Vector<OrmJoinColumn> specifiedJoinColumns = new Vector();
    protected final OrmJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();

    protected GenericOrmReferenceTable(XmlContextNode parent) {
        super(parent);
    }

    protected abstract OrmJoinColumn.Owner buildJoinColumnOwner();

    public void initializeFrom(ReferenceTable oldReferenceTable) {
        super.initializeFrom(oldReferenceTable);
        ListIterator stream = oldReferenceTable.specifiedJoinColumns();
        while (stream.hasNext()) {
            this.addSpecifiedJoinColumnFrom((OrmJoinColumn)stream.next());
        }
    }

    protected void initialize(AbstractXmlReferenceTable xmlReferenceTable) {
        super.initialize(xmlReferenceTable);
        this.initializeSpecifiedJoinColumns(xmlReferenceTable);
        this.initializeDefaultJoinColumn();
    }

    public void update() {
        this.update(this.getResourceTable());
    }

    protected void update(AbstractXmlReferenceTable xmlReferenceTable) {
        super.update(xmlReferenceTable);
        this.updateSpecifiedJoinColumns(xmlReferenceTable);
        this.updateDefaultJoinColumn();
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    protected abstract AbstractXmlReferenceTable getResourceTable();

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedJoinColumn() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn defaultJoinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = defaultJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, defaultJoinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void initializeDefaultJoinColumn() {
        if (this.shouldBuildDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.shouldBuildDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update(null);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    protected void addSpecifiedJoinColumnFrom(OrmJoinColumn oldJoinColumn) {
        OrmJoinColumn newJoinColumn = this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size());
        newJoinColumn.initializeFrom(oldJoinColumn);
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        if (this.getResourceTable() == null) {
            this.addResourceTable();
        }
        XmlJoinColumn xmlJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumn();
        OrmJoinColumn joinColumn = this.buildJoinColumn(xmlJoinColumn);
        this.specifiedJoinColumns.add(index, joinColumn);
        this.getResourceTable().getJoinColumns().add(index, (Object)xmlJoinColumn);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.hasSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        this.getResourceTable().getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.getResourceTable().getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        this.specifiedJoinColumns.clear();
        this.defaultJoinColumn = this.buildJoinColumn(null);
        this.getResourceTable().getJoinColumns().clear();
        this.fireListCleared("specifiedJoinColumns");
        this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.buildJoinColumn(resourceJoinColumn, this.joinColumnOwner);
    }

    protected void initializeSpecifiedJoinColumns(AbstractXmlReferenceTable xmlReferenceTable) {
        if (xmlReferenceTable != null) {
            for (XmlJoinColumn xmlJoinColumn : xmlReferenceTable.getJoinColumns()) {
                this.specifiedJoinColumns.add(this.buildJoinColumn(xmlJoinColumn));
            }
        }
    }

    protected void updateSpecifiedJoinColumns(AbstractXmlReferenceTable xmlReferenceTable) {
        Iterator<XmlJoinColumn> xmlJoinColumns = this.xmlJoinColumns(xmlReferenceTable);
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextJoinColumn = (OrmJoinColumn)contextJoinColumns.next();
            if (xmlJoinColumns.hasNext()) {
                contextJoinColumn.update(xmlJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(contextJoinColumn);
        }
        while (xmlJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn(xmlJoinColumns.next()));
        }
    }

    protected Iterator<XmlJoinColumn> xmlJoinColumns(AbstractXmlReferenceTable xmlReferenceTable) {
        return xmlReferenceTable == null ? EmptyIterator.instance() : new CloneIterator(xmlReferenceTable.getJoinColumns());
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn, OrmJoinColumn.Owner owner) {
        return this.getXmlContextNodeFactory().buildOrmJoinColumn(this, owner, resourceJoinColumn);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        boolean continueValidating = true;
        if (this.shouldValidateAgainstDatabase()) {
            continueValidating = this.validateAgainstDatabase(messages, reporter);
        }
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected abstract boolean shouldValidateAgainstDatabase();

    protected boolean validateAgainstDatabase(List<IMessage> messages, IReporter reporter) {
        PersistentAttribute persistentAttribute = this.getPersistentAttribute();
        if (!this.hasResolvedCatalog()) {
            if (persistentAttribute.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnresolvedCatalogMessageId(), new String[]{persistentAttribute.getName(), this.getCatalog(), this.getName()}, this, this.getCatalogTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedCatalogMessageId(), new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange()));
            }
            return false;
        }
        if (!this.hasResolvedSchema()) {
            if (persistentAttribute.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnresolvedSchemaMessageId(), new String[]{persistentAttribute.getName(), this.getSchema(), this.getName()}, this, this.getSchemaTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedSchemaMessageId(), new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange()));
            }
            return false;
        }
        if (!this.isResolved()) {
            if (this.getName() != null) {
                if (persistentAttribute.isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeUnresolvedNameMessageId(), new String[]{persistentAttribute.getName(), this.getName()}, this, this.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, this.getUnresolvedNameMessageId(), new String[]{this.getName()}, this, this.getNameTextRange()));
                }
            }
            return false;
        }
        return true;
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateJoinColumns(this.joinColumns(), messages, reporter);
    }

    protected void validateJoinColumns(Iterator<OrmJoinColumn> joinColumns, List<IMessage> messages, IReporter reporter) {
        while (joinColumns.hasNext()) {
            joinColumns.next().validate(messages, reporter);
        }
    }

    protected abstract String getUnresolvedCatalogMessageId();

    protected abstract String getUnresolvedSchemaMessageId();

    protected abstract String getUnresolvedNameMessageId();

    protected abstract String getVirtualAttributeUnresolvedCatalogMessageId();

    protected abstract String getVirtualAttributeUnresolvedSchemaMessageId();

    protected abstract String getVirtualAttributeUnresolvedNameMessageId();
}

