/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import com.ibm.icu.util.StringTokenizer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.w3c.dom.Node;

public class HTMLFormattingUtil {
    private Set fInlineElements = HTMLFormattingUtil.getInlineSet();

    public boolean isInline(Node node) {
        return node != null && this.fInlineElements.contains(node.getNodeName().toLowerCase(Locale.US));
    }

    public boolean shouldSkipIndentForNode(Node node) {
        return this.isInline(node.getParentNode());
    }

    public static Object[] getInlineElements() {
        return HTMLFormattingUtil.getInlineSet().toArray();
    }

    public static void exportToPreferences(Object[] elements) {
        if (elements != null) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < elements.length) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(elements[i]);
                ++i;
            }
            HTMLCorePlugin.getDefault().getPluginPreferences().setValue("inlineElements", buffer.toString());
        }
    }

    public static Object[] getDefaultInlineElements() {
        String inline = HTMLCorePlugin.getDefault().getPluginPreferences().getDefaultString("inlineElements");
        HashSet<String> defaults = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(inline, ",");
        while (tokenizer.hasMoreTokens()) {
            defaults.add(tokenizer.nextToken());
        }
        return defaults.toArray();
    }

    private static Set getInlineSet() {
        String inline = HTMLCorePlugin.getDefault().getPluginPreferences().getString("inlineElements");
        HashSet<String> elements = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(inline, ",");
        while (tokenizer.hasMoreTokens()) {
            elements.add(tokenizer.nextToken());
        }
        return elements;
    }
}

