/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateSessionBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.LocalBusinessInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.LocalComponentInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.LocalHomeInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewEnterpriseBeanClassOperation;
import org.eclipse.jst.j2ee.ejb.internal.operations.RemoteBusinessInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.RemoteComponentInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.RemoteHomeInterfaceTemplate;
import org.eclipse.jst.j2ee.ejb.internal.operations.SessionBeanTemplate;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.EJBUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public class NewSessionBeanClassOperation
extends NewEnterpriseBeanClassOperation {
    protected static final String TEMPLATE_FILE = "/templates/sessionBean.javajet";
    protected static final String TEMPLATE_LOCAL_FILE = "/templates/localBusinessInterface.javajet";
    protected static final String TEMPLATE_REMOTE_FILE = "/templates/remoteBusinessInterface.javajet";
    protected static final String TEMPLATE_LOCALHOME_FILE = "/templates/localHomeInterface.javajet";
    protected static final String TEMPLATE_REMOTEHOME_FILE = "/templates/remoteHomeInterface.javajet";
    protected static final String TEMPLATE_LOCALCOMPONENT_FILE = "/templates/localComponentInterface.javajet";
    protected static final String TEMPLATE_REMOTECOMPONENT_FILE = "/templates/remoteComponentInterface.javajet";
    protected IPackageFragment clientPack;
    protected IPackageFragment pack;

    public NewSessionBeanClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        this.pack = this.createJavaPackage(packageName);
        if (this.hasInterfacesToGenerate() && EJBUtilities.hasEJBClientJARProject((IProject)this.getTargetProject())) {
            this.createJavaSourceFolderInClientJar();
            this.clientPack = this.createJavaPackageInClientJar(packageName);
        }
        return super.doExecute(monitor, info);
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        this.generateUsingTemplates(monitor, this.pack, this.clientPack);
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment, IPackageFragment clientFragment) throws WFTWrappedException, CoreException {
        CreateSessionBeanTemplateModel tempModel = this.createTemplateModel();
        this.getTargetProject();
        try {
            if (fragment != null) {
                if (this.hasInterfacesToGenerate() && EJBUtilities.hasEJBClientJARProject((IProject)this.getTargetProject())) {
                    this.generateInterfacesUsingTemplates(monitor, clientFragment, tempModel);
                } else {
                    this.generateInterfacesUsingTemplates(monitor, fragment, tempModel);
                }
                SessionBeanTemplate tempImpl = SessionBeanTemplate.create(null);
                String source = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_FILE, tempImpl, monitor);
                String javaFileName = String.valueOf(tempModel.getClassName()) + ".java";
                this.createJavaFile(monitor, fragment, source, javaFileName);
            }
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
    }

    protected void generateInterfacesUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment, CreateSessionBeanTemplateModel tempModel) throws JETException, JavaModelException {
        Object tempImpl;
        String fileComponentName;
        Object tempImpl2;
        String src;
        String fileName;
        IType type;
        IJavaProject javaProject;
        IProject project = this.getTargetProject();
        boolean useClientJar = false;
        if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            useClientJar = EJBUtilities.hasEJBClientJARProject((IProject)this.getTargetProject());
        }
        List<BusinessInterface> interfaces = tempModel.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            String fileName2;
            String src2;
            Object tempImpl3;
            if (iface.exists()) continue;
            tempModel.setCurrentBusinessInterface(iface);
            if (iface.isLocal()) {
                tempImpl3 = LocalBusinessInterfaceTemplate.create(null);
                src2 = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_LOCAL_FILE, tempImpl3, monitor);
                fileName2 = String.valueOf(iface.getSimpleName()) + ".java";
                this.createJavaFile(monitor, this.getPackageFragment(useClientJar, iface.getFullyQualifiedName()), src2, fileName2);
                continue;
            }
            if (!iface.isRemote()) continue;
            tempImpl3 = RemoteBusinessInterfaceTemplate.create(null);
            src2 = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_REMOTE_FILE, tempImpl3, monitor);
            fileName2 = String.valueOf(iface.getSimpleName()) + ".java";
            this.createJavaFile(monitor, this.getPackageFragment(useClientJar, iface.getFullyQualifiedName()), src2, fileName2);
        }
        if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
            String remoteFullName = this.model.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE");
            String remoteComponentFullName = this.model.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_COMPONENT_INTERFACE");
            javaProject = JavaCore.create((IProject)project);
            type = javaProject.findType(remoteFullName);
            IPackageFragment remoteFragment = null;
            fileName = String.valueOf(Signature.getSimpleName((String)remoteFullName)) + ".java";
            tempModel.setRemoteHomeClassName(remoteFullName);
            tempModel.setRemoteComponentClassName(remoteComponentFullName);
            src = "";
            if (type == null) {
                remoteFragment = this.getPackageFragment(useClientJar, remoteFullName);
                tempImpl2 = RemoteHomeInterfaceTemplate.create(null);
                src = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_REMOTEHOME_FILE, tempImpl2, monitor);
                this.createJavaFile(monitor, remoteFragment, src, fileName);
            }
            fileComponentName = String.valueOf(Signature.getSimpleName((String)remoteComponentFullName)) + ".java";
            type = javaProject.findType(remoteComponentFullName);
            if (type == null) {
                IPackageFragment remoteComponentFragment = this.getPackageFragment(useClientJar, remoteComponentFullName);
                tempImpl = RemoteComponentInterfaceTemplate.create(null);
                src = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_REMOTECOMPONENT_FILE, tempImpl, monitor);
                this.createJavaFile(monitor, remoteComponentFragment, src, fileComponentName);
            }
        }
        if (this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME")) {
            String localFullName = this.model.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE");
            String localComponentFullName = this.model.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_COMPONENT_INTERFACE");
            javaProject = JavaCore.create((IProject)project);
            type = javaProject.findType(localFullName);
            IPackageFragment localFragment = null;
            fileName = String.valueOf(Signature.getSimpleName((String)localFullName)) + ".java";
            tempModel.setLocalHomeClassName(localFullName);
            tempModel.setLocalComponentClassName(localComponentFullName);
            src = "";
            if (type == null) {
                localFragment = this.getPackageFragment(useClientJar, localFullName);
                tempImpl2 = LocalHomeInterfaceTemplate.create(null);
                src = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_LOCALHOME_FILE, tempImpl2, monitor);
                this.createJavaFile(monitor, localFragment, src, fileName);
            }
            fileComponentName = String.valueOf(Signature.getSimpleName((String)localComponentFullName)) + ".java";
            type = javaProject.findType(localComponentFullName);
            if (type == null) {
                IPackageFragment localComponentFragment = this.getPackageFragment(useClientJar, localComponentFullName);
                tempImpl = LocalComponentInterfaceTemplate.create(null);
                src = this.generateTemplateSource(EjbPlugin.getPlugin(), tempModel, TEMPLATE_LOCALCOMPONENT_FILE, tempImpl, monitor);
                this.createJavaFile(monitor, localComponentFragment, src, fileComponentName);
            }
        }
    }

    protected IPackageFragment getPackageFragment(boolean useClientJar, String fullName) {
        String packageName = Signature.getQualifier((String)fullName);
        IPackageFragment fragment = useClientJar ? this.createJavaPackageInClientJar(packageName) : this.createJavaPackage(packageName);
        return fragment;
    }

    protected IFolder createJavaSourceFolderInClientJar() {
        IFolder folder = this.getClientSourceFolder();
        if (!folder.exists()) {
            try {
                NewSessionBeanClassOperation.createFolder(folder, false);
            }
            catch (CoreException e) {
                EjbPlugin.logError(e);
            }
            IProject clientProject = EJBUtilities.getEJBClientJar((IProject)this.getTargetProject()).getProject();
            IJavaProject jProject = JavaCore.create((IProject)clientProject);
            if (jProject != null) {
                IClasspathEntry newEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
                ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>();
                try {
                    IClasspathEntry[] classPath = jProject.getRawClasspath();
                    cp.addAll(Arrays.asList(classPath));
                    cp.add(newEntry);
                    jProject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
                }
                catch (JavaModelException e) {
                    EjbPlugin.logError((CoreException)((Object)e));
                }
            }
        }
        return folder;
    }

    protected IPackageFragment createJavaPackageInClientJar(String packageName) {
        IPackageFragmentRoot packRoot = this.getClientPackageFragmentRoot();
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                EjbPlugin.logError((CoreException)((Object)e));
            }
        }
        return pack;
    }

    private CreateSessionBeanTemplateModel createTemplateModel() {
        CreateSessionBeanTemplateModel templateModel = new CreateSessionBeanTemplateModel(this.model);
        return templateModel;
    }

    private boolean hasInterfacesToGenerate() {
        List businessInterfaces = (List)this.model.getProperty("NewJavaClassDataModel.INTERFACES");
        boolean remoteHome = this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
        boolean localHome = this.model.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
        return businessInterfaces.size() > 0 || remoteHome || localHome;
    }

    private IFolder getClientSourceFolder() {
        IFolder folder = this.getSourceFolder();
        IPath folderRelativePath = folder.getProjectRelativePath();
        IPath clientProjectPath = EJBUtilities.getEJBClientJar((IProject)this.getTargetProject()).getProject().getFullPath();
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(clientProjectPath.append(folderRelativePath));
    }

    private IPackageFragmentRoot getClientPackageFragmentRoot() {
        IFolder folder = this.getClientSourceFolder();
        IProject clientProject = EJBUtilities.getEJBClientJar((IProject)this.getTargetProject()).getProject();
        IJavaProject clientJavaProject = JavaCore.create((IProject)clientProject);
        return clientJavaProject.getPackageFragmentRoot((IResource)folder);
    }

    protected IPackageFragment createJavaPackage(String packageName) {
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                J2EEPlugin.logError((CoreException)((Object)e));
            }
        }
        return pack;
    }

    private static void createFolder(IFolder folder, boolean isDerived) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                NewSessionBeanClassOperation.createFolder((IFolder)parent, isDerived);
            }
            folder.create(true, true, null);
            folder.setDerived(isDerived);
        }
    }
}

