/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.ICommonEMFModule;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.EarFacetRuntimeHandler;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsOp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;

public class AddComponentToEnterpriseApplicationOp
extends CreateReferenceComponentsOp {
    public static final String metaInfFolderDeployPath = "/";

    public AddComponentToEnterpriseApplicationOp(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (monitor != null) {
            monitor.beginTask("", 4);
        }
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            IStatus status = this.validateEditEAR();
            if (status.isOK()) {
                status = super.execute(AddComponentToEnterpriseApplicationOp.submon(monitor, 1), info);
                if (!status.isOK()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.updateEARDD(AddComponentToEnterpriseApplicationOp.submon(monitor, 1));
                this.updateModuleRuntimes(AddComponentToEnterpriseApplicationOp.submon(monitor, 1));
                this.moduleClasspathForceUpdate(AddComponentToEnterpriseApplicationOp.submon(monitor, 1));
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    protected void updateEARDD(IProgressMonitor monitor) {
        block20: {
            StructureEdit se = null;
            try {
                try {
                    IVirtualReference[] refs;
                    IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                    final IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(sourceComp.getProject());
                    final IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                    final IProject earpj = ear.getProject();
                    se = StructureEdit.getStructureEditForWrite((IProject)sourceComp.getProject());
                    if (earModel == null) break block20;
                    ArrayList<IVirtualComponent> list = (ArrayList<IVirtualComponent>)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    if (list == null) {
                        list = new ArrayList<IVirtualComponent>();
                    }
                    if (list.isEmpty() && (refs = J2EEProjectUtilities.getJ2EEModuleReferences(ear)) != null && refs.length > 0) {
                        list = new ArrayList();
                        int i = 0;
                        while (i < refs.length) {
                            list.add(refs[i].getReferencedComponent());
                            ++i;
                        }
                    }
                    final Map map = (Map)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
                    final Map deployMap = (Map)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP");
                    if (list.size() <= 0) break block20;
                    int i = 0;
                    while (i < list.size()) {
                        final IVirtualComponent wc = (IVirtualComponent)list.get(i);
                        boolean linkedToEAR = true;
                        try {
                            if (wc.isBinary()) {
                                linkedToEAR = ((J2EEModuleVirtualArchiveComponent)wc).isLinkedToEAR();
                                ((J2EEModuleVirtualArchiveComponent)wc).setLinkedToEAR(false);
                            }
                            WorkbenchComponent earwc = se.getComponent();
                            StructureEdit compse = null;
                            try {
                                compse = StructureEdit.getStructureEditForWrite((IProject)wc.getProject());
                                final ReferencedComponent ref = AddComponentToEnterpriseApplicationOp.findReferencedComponent(earwc, wc, se, compse);
                                earModel.modify(new Runnable(){

                                    public void run() {
                                        ICommonApplication application = (ICommonApplication)earModel.getModelObject();
                                        if (application != null) {
                                            Resource theResource;
                                            ICommonModule mod;
                                            String name = (String)map.get(wc);
                                            if (deployMap.containsKey(wc)) {
                                                String deployPath = (String)deployMap.get(wc);
                                                if (name != null && !deployPath.equals(AddComponentToEnterpriseApplicationOp.metaInfFolderDeployPath)) {
                                                    name = new Path(deployPath).append(name).toString();
                                                }
                                                String libDir = EarUtilities.getEARLibDir(ear);
                                                IPath libDirPath = null;
                                                if (libDir != null) {
                                                    libDirPath = new Path(libDir).makeRelative();
                                                }
                                                if (libDirPath != null && !libDirPath.isEmpty() && new Path(deployPath).makeRelative().equals((Object)libDirPath)) {
                                                    return;
                                                }
                                            }
                                            if (name != null) {
                                                name = new Path(name).makeRelative().toString();
                                            }
                                            if ((mod = AddComponentToEnterpriseApplicationOp.this.addModule(application, wc, name)) == null) {
                                                return;
                                            }
                                            if (ref != null) {
                                                ref.setDependentObject((EObject)mod);
                                            }
                                            if (JavaEEProjectUtilities.isStaticWebProject(wc.getProject()) || JavaEEProjectUtilities.isDynamicWebComponent(wc)) {
                                                AddComponentToEnterpriseApplicationOp.this.updateContextRoot(earpj, wc, mod);
                                            }
                                            if ((theResource = ((EObject)mod).eResource()) != null) {
                                                String frag = null;
                                                if (theResource instanceof CompatibilityXMIResource) {
                                                    frag = theResource.getURIFragment((EObject)mod);
                                                }
                                                ((ICommonEMFModule)mod).setId(frag);
                                            }
                                        }
                                    }
                                }, null);
                            }
                            finally {
                                if (compse != null) {
                                    compse.saveIfNecessary(monitor);
                                    compse.dispose();
                                }
                            }
                        }
                        finally {
                            if (wc.isBinary()) {
                                ((J2EEModuleVirtualArchiveComponent)wc).setLinkedToEAR(linkedToEAR);
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    J2EEPlugin.logError(e);
                    if (se != null) {
                        se.saveIfNecessary(monitor);
                        se.dispose();
                    }
                }
            }
            finally {
                if (se != null) {
                    se.saveIfNecessary(monitor);
                    se.dispose();
                }
            }
        }
    }

    private void updateContextRoot(IProject earpj, IVirtualComponent wc, ICommonModule mod) {
        String earDDVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion(earpj);
        boolean useNewModel = earDDVersion.equals("5.0") || earDDVersion.equals("6.0");
        String contextroot = null;
        if (wc.isBinary()) {
            IPath path = (IPath)wc.getAdapter(IPath.class);
            contextroot = path.removeFileExtension().lastSegment();
        } else {
            contextroot = ComponentUtilities.getServerContextRoot((IProject)wc.getProject());
        }
        if (contextroot == null) {
            contextroot = wc.getProject().getName();
        }
        if (useNewModel) {
            if (mod instanceof Module) {
                Web web = ((Module)mod).getWeb();
                web.setContextRoot(contextroot);
            }
        } else if ((JavaEEProjectUtilities.isStaticWebProject(wc.getProject()) || JavaEEProjectUtilities.isDynamicWebComponent(wc)) && mod instanceof WebModule) {
            ((WebModule)mod).setContextRoot(contextroot);
        }
    }

    protected ICommonModule createNewModule(IVirtualComponent wc, String name) {
        boolean useNewModel;
        ICommonModule newModule = null;
        IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        IProject earpj = ear.getProject();
        String earDDVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion(earpj);
        boolean bl = useNewModel = earDDVersion.equals("5.0") || earDDVersion.equals("6.0");
        if (wc.isBinary()) {
            JavaEEBinaryComponentHelper.openArchive(wc, useNewModel);
        }
        if (JavaEEProjectUtilities.isDynamicWebComponent(wc)) {
            if (useNewModel) {
                Web web = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createWeb();
                web.setWebUri(name);
                Module webModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                webModule.setWeb(web);
                newModule = (ICommonModule)webModule;
            } else {
                WebModule webModule = ApplicationFactory.eINSTANCE.createWebModule();
                webModule.setUri(name);
                newModule = (ICommonModule)webModule;
            }
            this.updateContextRoot(earpj, wc, newModule);
            return newModule;
        }
        if (JavaEEProjectUtilities.isEJBComponent(wc)) {
            if (useNewModel) {
                Module ejbModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                ejbModule.setEjb(name);
                newModule = (ICommonModule)ejbModule;
            } else {
                EjbModule ejbModule = ApplicationFactory.eINSTANCE.createEjbModule();
                ejbModule.setUri(name);
                newModule = (ICommonModule)ejbModule;
            }
            return newModule;
        }
        if (JavaEEProjectUtilities.isApplicationClientComponent(wc)) {
            if (useNewModel) {
                Module appClientModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                appClientModule.setJava(name);
                newModule = (ICommonModule)appClientModule;
            } else {
                JavaClientModule appClientModule = ApplicationFactory.eINSTANCE.createJavaClientModule();
                appClientModule.setUri(name);
                newModule = (ICommonModule)appClientModule;
            }
            return newModule;
        }
        if (JavaEEProjectUtilities.isJCAComponent(wc)) {
            if (useNewModel) {
                Module j2cModule = org.eclipse.jst.javaee.application.ApplicationFactory.eINSTANCE.createModule();
                j2cModule.setConnector(name);
                newModule = (ICommonModule)j2cModule;
            } else {
                ConnectorModule j2cModule = ApplicationFactory.eINSTANCE.createConnectorModule();
                j2cModule.setUri(name);
                newModule = (ICommonModule)j2cModule;
            }
            return newModule;
        }
        return null;
    }

    protected ICommonModule addModule(ICommonApplication application, IVirtualComponent wc, String name) {
        ICommonApplication dd = application;
        ICommonModule existingModule = dd.getFirstEARModule(name);
        if (existingModule == null && (existingModule = this.createNewModule(wc, name)) != null) {
            existingModule.setUri(name);
            dd.getEARModules().add(existingModule);
        }
        return existingModule;
    }

    private void updateModuleRuntimes(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 10);
        }
        try {
            try {
                IVirtualComponent ear = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
                IProject earpj = ear.getProject();
                List moduleComponents = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                HashSet<IProject> moduleProjects = new HashSet<IProject>();
                Iterator itr = moduleComponents.iterator();
                while (itr.hasNext()) {
                    moduleProjects.add(((IVirtualComponent)itr.next()).getProject());
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                EarFacetRuntimeHandler.updateModuleProjectRuntime(earpj, moduleProjects, AddComponentToEnterpriseApplicationOp.submon(monitor, 9));
            }
            catch (Exception e) {
                J2EEPlugin.logError(e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void moduleClasspathForceUpdate(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IVirtualComponent component = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
            EARVirtualComponent ear = (EARVirtualComponent)component.getComponent();
            if (JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)ear, 1)) {
                String deployPath = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
                String libDir = EarUtilities.getEARLibDir((IVirtualComponent)ear);
                IPath libDirPath = null;
                if (libDir != null) {
                    libDirPath = new Path(libDir).makeRelative();
                }
                if (libDirPath != null && deployPath != null && !libDirPath.isEmpty() && libDirPath.equals((Object)new Path(deployPath).makeRelative())) {
                    IVirtualReference[] refs = ear.getReferences();
                    HashSet<IProject> projects = new HashSet<IProject>();
                    IVirtualReference[] iVirtualReferenceArray = refs;
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVirtualReference ref = iVirtualReferenceArray[n2];
                        projects.add(ref.getReferencedComponent().getProject());
                        ++n2;
                    }
                    J2EEComponentClasspathUpdater.getInstance().forceUpdate(projects);
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    public static ReferencedComponent findReferencedComponent(WorkbenchComponent aComponent, IVirtualComponent aReferencedComponent, StructureEdit se, StructureEdit compse) {
        if (aComponent == null || aReferencedComponent == null) {
            return null;
        }
        if (aReferencedComponent.isBinary()) {
            EList referencedComponents = aComponent.getReferencedComponents();
            String name = null;
            if (aReferencedComponent.getName() != null) {
                name = new Path(aReferencedComponent.getName()).lastSegment();
            }
            if (name != null) {
                for (ReferencedComponent referencedComponent : referencedComponents) {
                    URI uri = referencedComponent.getHandle();
                    if (uri == null || !name.equals(uri.lastSegment())) continue;
                    return referencedComponent;
                }
            }
        } else {
            WorkbenchComponent refwc = compse.getComponent();
            return se.findReferencedComponent(aComponent, refwc);
        }
        return null;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    protected IStatus validateEditEAR() {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        IProject project = sourceComp.getProject();
        IModelProvider provider = ModelProviderManager.getModelProvider(project);
        if (provider != null) {
            return provider.validateEdit(null, null);
        }
        return OK_STATUS;
    }

    protected IStatus validateEdit() {
        return this.validateEditEAR();
    }
}

