/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<T extends XmlTypeMapping>
extends AbstractOrmXmlContextNode
implements OrmTypeMapping {
    protected String class_;
    public boolean defaultMetadataComplete;
    protected Boolean specifiedMetadataComplete;
    protected final T resourceTypeMapping;

    protected AbstractOrmTypeMapping(OrmPersistentType parent, T resourceMapping) {
        super(parent);
        this.resourceTypeMapping = resourceMapping;
        this.class_ = this.getResourceClassName();
        this.specifiedMetadataComplete = this.getResourceMetadataComplete();
        this.defaultMetadataComplete = this.getPersistentType().isDefaultMetadataComplete();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return this.getParent();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getPersistentType().getJavaPersistentType();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public JavaPersistentType getIdClass() {
        return null;
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String newClass) {
        String oldClass = this.class_;
        this.class_ = newClass;
        this.resourceTypeMapping.setClassName(newClass);
        this.firePropertyChanged("class", oldClass, newClass);
        this.getPersistentType().classChanged(oldClass, newClass);
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.isDefaultMetadataComplete()) {
            return true;
        }
        return this.getSpecifiedMetadataComplete() == null ? this.isDefaultMetadataComplete() : this.getSpecifiedMetadataComplete().booleanValue();
    }

    @Override
    public boolean isDefaultMetadataComplete() {
        return this.defaultMetadataComplete;
    }

    protected void setDefaultMetadataComplete(boolean newDefaultMetadataComplete) {
        boolean oldMetadataComplete = this.defaultMetadataComplete;
        this.defaultMetadataComplete = newDefaultMetadataComplete;
        this.firePropertyChanged("defaultMetadataComplete", oldMetadataComplete, newDefaultMetadataComplete);
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean newSpecifiedMetadataComplete) {
        Boolean oldMetadataComplete = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = newSpecifiedMetadataComplete;
        this.resourceTypeMapping.setMetadataComplete(newSpecifiedMetadataComplete);
        this.firePropertyChanged("specifiedMetadataComplete", oldMetadataComplete, newSpecifiedMetadataComplete);
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setClass(oldMapping.getClass_());
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setDefaultMetadataComplete(oldMapping.isDefaultMetadataComplete());
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table getDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterator<OrmAttributeMapping> attributeMappings() {
        return new TransformationIterator<OrmPersistentAttribute, OrmAttributeMapping>(this.getPersistentType().attributes()){

            protected OrmAttributeMapping transform(OrmPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    public Iterable<OrmAttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<OrmAttributeMapping>((Iterable)CollectionTools.collection(this.attributeMappings())){

            protected boolean accept(OrmAttributeMapping o) {
                return StringTools.stringsAreEqual((String)o.getKey(), (String)mappingKey);
            }
        };
    }

    @Override
    public Iterator<AttributeMapping> allAttributeMappings() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<AttributeMapping>>(this.inheritanceHierarchy()){

            protected Iterator<AttributeMapping> transform(TypeMapping typeMapping) {
                return typeMapping.attributeMappings();
            }
        });
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>((Iterable)CollectionTools.collection(this.allAttributeMappings())){

            protected boolean accept(AttributeMapping o) {
                return StringTools.stringsAreEqual((String)o.getKey(), (String)mappingKey);
            }
        };
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        return this.getPersistentType().getSuperPersistentType() == null ? null : this.getPersistentType().getSuperPersistentType().getMapping();
    }

    @Override
    public Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<String> overridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.attributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAttributeNames();
            }
        });
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            Column resolvedColumn = attributeMapping.resolveOverriddenColumn(attributeName);
            if (resolvedColumn == null) continue;
            return resolvedColumn;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    public Iterator<String> overridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.attributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAssociationNames();
            }
        });
    }

    @Override
    public RelationshipReference resolveRelationshipReference(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : CollectionTools.iterable(this.attributeMappings())) {
            RelationshipReference resolvedRelationshipReference = attributeMapping.resolveRelationshipReference(attributeName);
            if (resolvedRelationshipReference == null) continue;
            return resolvedRelationshipReference;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveRelationshipReference(attributeName);
        }
        return null;
    }

    public T getResourceTypeMapping() {
        return this.resourceTypeMapping;
    }

    @Override
    public void update() {
        this.setClass(this.getResourceClassName());
        this.setSpecifiedMetadataComplete(this.getResourceMetadataComplete());
        this.setDefaultMetadataComplete(this.getPersistentType().isDefaultMetadataComplete());
    }

    protected String getResourceClassName() {
        return this.resourceTypeMapping.getClassName();
    }

    protected Boolean getResourceMetadataComplete() {
        return this.resourceTypeMapping.getMetadataComplete();
    }

    public JpaStructureNode getStructureNode(int offset) {
        if (this.resourceTypeMapping.containsOffset(offset)) {
            return this.getPersistentType();
        }
        return null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.resourceTypeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getClassTextRange() {
        return this.resourceTypeMapping.getClassTextRange();
    }

    @Override
    public TextRange getAttributesTextRange() {
        return this.resourceTypeMapping.getAttributesTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.resourceTypeMapping != null && this.resourceTypeMapping.containsOffset(textOffset);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
    }

    protected void validateClass(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.class_)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", this, this.getClassTextRange()));
            return;
        }
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getPersistenceUnit().shouldValidateAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceTypeMapping.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }
}

