/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlAligner {
    private boolean autoValidate;
    private Collection<Listener> changeSupport;
    private Listener listener;
    private boolean locked;
    private int maximumWidth;
    private Collection<Wrapper> wrappers;
    private static final Point DEFAULT_SIZE = new Point(-1, -1);
    private static final int[] EVENT_TYPES = new int[]{12, 23, 11, 22};

    public ControlAligner() {
        this.initialize();
    }

    public ControlAligner(Collection<? extends Control> controls) {
        this();
        this.addAllControls(controls);
    }

    public void add(Control control) {
        Assert.isNotNull((Object)control, (String)"Can't add null to this ControlAligner");
        Wrapper wrapper = this.buildWrapper(control);
        wrapper.addListener(this.listener);
        this.wrappers.add(wrapper);
        this.revalidate(false);
    }

    public void add(ControlAligner controlAligner) {
        Assert.isNotNull((Object)controlAligner, (String)"Can't add null to this ControlAligner");
        Assert.isLegal((controlAligner != this ? 1 : 0) != 0, (String)"Can't add the ControlAligner to itself");
        Wrapper wrapper = this.buildWrapper(controlAligner);
        wrapper.addListener(this.listener);
        this.wrappers.add(wrapper);
        if (!controlAligner.wrappers.isEmpty()) {
            this.revalidate(false);
        }
    }

    public void addAllControlAligners(Collection<ControlAligner> aligners) {
        boolean oldAutoValidate = this.autoValidate;
        this.autoValidate = false;
        for (ControlAligner aligner : aligners) {
            this.add(aligner);
        }
        this.autoValidate = oldAutoValidate;
        this.revalidate(false);
    }

    public void addAllControls(Collection<? extends Control> controls) {
        boolean oldAutoValidate = this.autoValidate;
        this.autoValidate = false;
        for (Control control : controls) {
            this.add(control);
        }
        this.autoValidate = oldAutoValidate;
        this.revalidate(false);
    }

    private void addListener(Listener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new ArrayList<Listener>();
        }
        this.changeSupport.add(listener);
    }

    private Wrapper buildWrapper(Control control) {
        return new ControlWrapper(control);
    }

    private Wrapper buildWrapper(ControlAligner ControlAligner2) {
        return new ControlAlignerWrapper(ControlAligner2);
    }

    private int calculateWidth(boolean recalculateSize) {
        int width = 0;
        for (Wrapper wrapper : this.wrappers) {
            Point size = wrapper.cachedSize();
            if (recalculateSize || size.x == 0) {
                size = wrapper.calculateSize();
            }
            width = Math.max(size.x, width);
        }
        return width;
    }

    private void controlResized(int oldValue, int newValue) {
        if (this.changeSupport != null && oldValue != newValue) {
            Event event = new Event();
            event.widget = SWTUtil.getShell();
            event.data = this;
            for (Listener listener : this.changeSupport) {
                listener.handleEvent(event);
            }
        }
    }

    public void dispose() {
        Iterator<Wrapper> iter = this.wrappers.iterator();
        while (iter.hasNext()) {
            Wrapper wrapper = iter.next();
            wrapper.removeListener(this.listener);
            iter.remove();
        }
        this.wrappers.clear();
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    private void initialize() {
        this.autoValidate = true;
        this.maximumWidth = 0;
        this.listener = new ListenerHandler();
        this.wrappers = new ArrayList<Wrapper>();
    }

    private void invalidate(Object source) {
        Wrapper wrapper = this.retrieveWrapper(source);
        if (!wrapper.locked()) {
            Point size = wrapper.cachedSize();
            size.y = 0;
            size.x = 0;
            wrapper.setSize(DEFAULT_SIZE);
        }
    }

    private void recalculateWidth(boolean recalculateSize) {
        int width = this.calculateWidth(recalculateSize);
        try {
            this.locked = true;
            this.setMaximumWidth(width);
        }
        finally {
            this.locked = false;
        }
    }

    public void remove(Control control) {
        Assert.isNotNull((Object)control, (String)"The Control to remove cannot be null");
        Wrapper wrapper = this.retrieveWrapper(control);
        wrapper.removeListener(this.listener);
        this.wrappers.remove(wrapper);
        this.revalidate(true);
    }

    public void remove(ControlAligner controlAligner) {
        Assert.isNotNull((Object)controlAligner, (String)"The ControlAligner to remove cannot be null");
        Wrapper wrapper = this.retrieveWrapper(controlAligner);
        wrapper.removeListener(this.listener);
        this.wrappers.remove(wrapper);
        this.revalidate(true);
    }

    private void removeListener(Listener listener) {
        this.changeSupport.remove(listener);
        if (this.changeSupport.isEmpty()) {
            this.changeSupport = null;
        }
    }

    private Wrapper retrieveWrapper(Object source) {
        for (Wrapper wrapper : this.wrappers) {
            if (wrapper.source() != source) continue;
            return wrapper;
        }
        throw new IllegalArgumentException("Can't retrieve the Wrapper for " + source);
    }

    private void revalidate(boolean recalculateSize) {
        if (this.autoValidate) {
            this.recalculateWidth(recalculateSize);
            this.updateWrapperSize(recalculateSize);
        }
    }

    private void revalidate(Event event) {
        Object source;
        if (this.locked) {
            return;
        }
        if (event.widget != SWTUtil.getShell()) {
            source = event.widget;
            Control control = (Control)source;
            if (control == control.getShell()) {
                if (event.type == 12) {
                    return;
                }
                source = null;
            }
        } else {
            source = event.data;
        }
        if (source != null) {
            if (event.type == 12) {
                Wrapper wrapper = this.retrieveWrapper(source);
                this.wrappers.remove(wrapper);
            } else {
                this.invalidate(source);
            }
        }
        this.revalidate(true);
    }

    private void setMaximumWidth(int maximumWidth) {
        int oldMaximumWidth = this.maximumWidth;
        this.maximumWidth = maximumWidth;
        this.controlResized(oldMaximumWidth, maximumWidth);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("maximumWidth=");
        sb.append(this.maximumWidth);
        sb.append(", wrappers=");
        sb.append(this.wrappers);
        return StringTools.buildToStringFor((Object)this, (Object)sb);
    }

    private void updateWrapperSize(boolean forceRevalidate) {
        for (Wrapper wrapper : this.wrappers) {
            Point cachedSize = wrapper.cachedSize();
            if (!forceRevalidate && cachedSize.x == this.maximumWidth) continue;
            Point size = new Point(this.maximumWidth, cachedSize.y);
            wrapper.setSize(size);
        }
    }

    private class ControlAlignerWrapper
    implements Wrapper {
        private final Point cachedSize;
        private final ControlAligner controlAligner;

        private ControlAlignerWrapper(ControlAligner controlAligner2) {
            this.controlAligner = controlAligner2;
            this.cachedSize = new Point(controlAligner2.maximumWidth, 0);
        }

        public void addListener(Listener listener) {
            this.controlAligner.addListener(listener);
        }

        public Point cachedSize() {
            this.cachedSize.x = this.controlAligner.maximumWidth;
            return this.cachedSize;
        }

        public Point calculateSize() {
            Point size = new Point(this.controlAligner.calculateWidth(false), 0);
            this.cachedSize.x = size.x != -1 ? size.x : 0;
            this.cachedSize.y = size.y != -1 ? size.y : 0;
            return size;
        }

        public boolean locked() {
            return this.controlAligner.locked;
        }

        public void removeListener(Listener listener) {
            this.controlAligner.removeListener(listener);
        }

        public void setSize(Point size) {
            if (size == DEFAULT_SIZE) {
                this.controlAligner.maximumWidth = 0;
            } else if (this.controlAligner.maximumWidth != size.x) {
                this.controlAligner.maximumWidth = size.x;
                this.controlAligner.updateWrapperSize(true);
            }
        }

        public Object source() {
            return this.controlAligner;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Cached size=");
            sb.append(this.cachedSize);
            sb.append(", ControlAligner=");
            sb.append(this.controlAligner);
            return StringTools.buildToStringFor((Object)this, (Object)sb);
        }
    }

    private class ControlWrapper
    implements Wrapper {
        private Point cachedSize;
        private final Control control;

        private ControlWrapper(Control control) {
            this.control = control;
            this.cachedSize = new Point(0, 0);
        }

        public void addListener(Listener listener) {
            int[] nArray = EVENT_TYPES;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int eventType = nArray[n2];
                this.control.addListener(eventType, listener);
                ++n2;
            }
        }

        public Point cachedSize() {
            return this.cachedSize;
        }

        public Point calculateSize() {
            this.cachedSize = this.control.computeSize(-1, -1, true);
            GridData gridData = (GridData)this.control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData(32);
                this.control.setLayoutData((Object)gridData);
            }
            gridData.widthHint = this.cachedSize.x;
            gridData.heightHint = this.cachedSize.y;
            if (this.cachedSize.x == -1) {
                this.cachedSize.x = 0;
            }
            if (this.cachedSize.y == -1) {
                this.cachedSize.y = 0;
            }
            return this.cachedSize;
        }

        public boolean locked() {
            return false;
        }

        public void removeListener(Listener listener) {
            int[] nArray = EVENT_TYPES;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int eventType = nArray[n2];
                this.control.removeListener(eventType, listener);
                ++n2;
            }
        }

        public void setSize(Point size) {
            if (this.control.isDisposed()) {
                return;
            }
            GridData gridData = (GridData)this.control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData(32);
                this.control.setLayoutData((Object)gridData);
            }
            gridData.widthHint = size.x;
            gridData.heightHint = size.y;
            if (size.x > 0) {
                Rectangle bounds = this.control.getBounds();
                if (bounds.width != size.x) {
                    ControlAligner.this.locked = true;
                    try {
                        this.control.getParent().layout(true);
                    }
                    finally {
                        ControlAligner.this.locked = false;
                    }
                }
            }
        }

        public Control source() {
            return this.control;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Cached size=");
            sb.append(this.cachedSize);
            sb.append(", Control=");
            sb.append(this.control);
            return StringTools.buildToStringFor((Object)this, (Object)sb);
        }
    }

    private class ListenerHandler
    implements Listener {
        private ListenerHandler() {
        }

        public void handleEvent(Event event) {
            ControlAligner.this.revalidate(event);
        }
    }

    private static interface Wrapper {
        public void addListener(Listener var1);

        public Point cachedSize();

        public Point calculateSize();

        public boolean locked();

        public void removeListener(Listener var1);

        public void setSize(Point var1);

        public Object source();
    }
}

