/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryContainer;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmQueryContainer
extends AbstractOrmXmlContextNode
implements OrmQueryContainer {
    protected final XmlQueryContainer resourceQueryContainer;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;

    public GenericOrmQueryContainer(XmlContextNode parent, XmlQueryContainer resourceQueryContainer) {
        super(parent);
        this.resourceQueryContainer = resourceQueryContainer;
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
        this.initializeNamedQueries();
        this.initializeNamedNativeQueries();
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        XmlNamedQuery resourceNamedQuery = OrmFactory.eINSTANCE.createXmlNamedQuery();
        OrmNamedQuery contextNamedQuery = this.buildNamedQuery(resourceNamedQuery);
        this.namedQueries.add(index, contextNamedQuery);
        this.resourceQueryContainer.getNamedQueries().add(index, (Object)resourceNamedQuery);
        this.fireItemAdded("namedQueries", index, contextNamedQuery);
        return contextNamedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueries");
    }

    protected void addNamedQuery(OrmNamedQuery namedQuery) {
        this.addNamedQuery(this.namedQueries.size(), namedQuery);
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        this.resourceQueryContainer.getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueries", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueries");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        this.resourceQueryContainer.getNamedQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedQueries", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        XmlNamedNativeQuery resourceNamedNativeQuery = OrmFactory.eINSTANCE.createXmlNamedNativeQuery();
        OrmNamedNativeQuery contextNamedNativeQuery = this.buildNamedNativeQuery(resourceNamedNativeQuery);
        this.namedNativeQueries.add(index, contextNamedNativeQuery);
        this.resourceQueryContainer.getNamedNativeQueries().add(index, (Object)resourceNamedNativeQuery);
        this.fireItemAdded("namedNativeQueries", index, contextNamedNativeQuery);
        return contextNamedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    protected void addNamedNativeQuery(OrmNamedNativeQuery namedNativeQuery) {
        this.addNamedNativeQuery(this.namedNativeQueries.size(), namedNativeQuery);
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        this.resourceQueryContainer.getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueries", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueries");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        this.resourceQueryContainer.getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedNativeQueries", targetIndex, sourceIndex);
    }

    protected void initializeNamedQueries() {
        for (XmlNamedQuery namedQuery : this.resourceQueryContainer.getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries() {
        for (XmlNamedNativeQuery namedNativeQuery : this.resourceQueryContainer.getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    @Override
    public void update() {
        this.updateNamedQueries();
        this.updateNamedNativeQueries();
    }

    protected void updateNamedQueries() {
        CloneIterator xmlQueries = new CloneIterator(this.resourceQueryContainer.getNamedQueries());
        ListIterator<OrmNamedQuery> contextQueries = this.namedQueries();
        while (contextQueries.hasNext()) {
            OrmNamedQuery contextQuery = (OrmNamedQuery)contextQueries.next();
            if (xmlQueries.hasNext()) {
                contextQuery.update((XmlNamedQuery)xmlQueries.next());
                continue;
            }
            this.removeNamedQuery_(contextQuery);
        }
        while (xmlQueries.hasNext()) {
            this.addNamedQuery(this.buildNamedQuery((XmlNamedQuery)xmlQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery resourceNamedQuery) {
        return this.getXmlContextNodeFactory().buildOrmNamedQuery(this, resourceNamedQuery);
    }

    protected void updateNamedNativeQueries() {
        CloneIterator xmlQueries = new CloneIterator(this.resourceQueryContainer.getNamedNativeQueries());
        ListIterator<OrmNamedNativeQuery> contextQueries = this.namedNativeQueries();
        while (contextQueries.hasNext()) {
            OrmNamedNativeQuery contextQuery = (OrmNamedNativeQuery)contextQueries.next();
            if (xmlQueries.hasNext()) {
                contextQuery.update((XmlNamedNativeQuery)xmlQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(contextQuery);
        }
        while (xmlQueries.hasNext()) {
            this.addNamedNativeQuery(this.buildNamedNativeQuery((XmlNamedNativeQuery)xmlQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery resourceNamedNativeQuery) {
        return this.getXmlContextNodeFactory().buildOrmNamedNativeQuery(this, resourceNamedNativeQuery);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateQueries(messages);
    }

    protected void validateQueries(List<IMessage> messages) {
        Iterator<OrmQuery> localQueries = this.queries();
        while (localQueries.hasNext()) {
            OrmQuery localQuery = localQueries.next();
            ListIterator<Query> globalQueries = this.getPersistenceUnit().queries();
            while (globalQueries.hasNext()) {
                if (!localQuery.duplicates((Query)globalQueries.next())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{localQuery.getName()}, localQuery, localQuery.getNameTextRange()));
            }
        }
    }

    protected Iterator<OrmQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceQueryContainer.getValidationTextRange();
    }
}

