/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IUnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class UnaryExpression
extends OperatorExpression
implements IUnaryExpression {
    public Expression expression;
    public Constant optimizedBooleanConstant;

    public UnaryExpression(Expression expression, int operator) {
        this.expression = expression;
        this.bits |= operator << 6;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.expression.checkNPE(currentScope, flowContext, flowInfo);
        if ((this.bits & 0xFC0) >> 6 == 11) {
            return this.expression.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.expression.analyseCode(currentScope, flowContext, flowInfo);
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? (this.constant == null ? Constant.NotAConstant : this.constant) : this.optimizedBooleanConstant;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        output.append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, output);
    }

    public final int getOperator() {
        return (this.bits & 0xFC0) >> 6;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding expressionType = null;
        expressionType = this.getOperator() == 22 && this.expression instanceof SingleNameReference ? TypeBinding.UNKNOWN : this.expression.resolveType(scope);
        if (expressionType == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int expressionTypeID = expressionType.id;
        if (expressionTypeID > 15) {
            expressionTypeID = 1;
        }
        int tableId = -1;
        int operator = (this.bits & 0xFC0) >> 6;
        switch (operator) {
            case 11: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 12: {
                tableId = 10;
                break;
            }
            case 22: {
                this.resolvedType = scope.getJavaLangString();
                break;
            }
            case 21: {
                this.resolvedType = TypeBinding.VOID;
                break;
            }
            default: {
                tableId = 13;
            }
        }
        if (tableId > -1) {
            int operatorSignature = OperatorSignatures[tableId][(expressionTypeID << 4) + expressionTypeID];
            this.bits |= operatorSignature & 0xF;
            switch (operatorSignature & 0xF) {
                case 5: {
                    this.resolvedType = TypeBinding.BOOLEAN;
                    break;
                }
                case 2: {
                    this.resolvedType = TypeBinding.CHAR;
                    break;
                }
                case 8: {
                    this.resolvedType = TypeBinding.DOUBLE;
                    break;
                }
                case 9: {
                    this.resolvedType = TypeBinding.FLOAT;
                    break;
                }
                case 10: {
                    this.resolvedType = scope.getJavaLangNumber();
                    break;
                }
                case 7: {
                    this.resolvedType = TypeBinding.LONG;
                    break;
                }
                case 13: {
                    this.resolvedType = TypeBinding.UNKNOWN;
                    break;
                }
                default: {
                    this.constant = Constant.NotAConstant;
                    if (expressionTypeID != 0) {
                        scope.problemReporter().invalidOperator(this, expressionType);
                    }
                    return null;
                }
            }
        }
        if (this.expression.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperation(this.expression.constant, expressionTypeID, operator);
        } else {
            Constant cst;
            this.constant = Constant.NotAConstant;
            if (operator == 11 && (cst = this.expression.optimizedBooleanConstant()) != Constant.NotAConstant) {
                this.optimizedBooleanConstant = BooleanConstant.fromValue(!cst.booleanValue());
            }
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 110;
    }

    public IExpression getExpression() {
        return this.expression;
    }
}

