/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration
implements IArgument {
    public char[] comment;

    public Argument(char[] name, long posNom, TypeReference tr, int modifiers) {
        super(name, (int)(posNom >>> 32), (int)posNom);
        this.declarationSourceEnd = (int)posNom;
        this.modifiers = modifiers;
        this.type = tr;
        this.bits |= 0x40000000;
    }

    public char[] getComment() {
        return this.comment;
    }

    public void bind(MethodScope scope, TypeBinding typeBinding, boolean used) {
        Binding existingVariable = scope.getLocalBinding(this.name, 3, this, false);
        if (existingVariable != null && existingVariable.isValidBinding() && existingVariable instanceof LocalVariableBinding) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)existingVariable;
            if (localVariableBinding.declaringScope.compilationUnitScope() == scope.compilationUnitScope()) {
                scope.problemReporter().localVariableHiding(this, existingVariable, false);
            }
        }
        if (this.binding == null) {
            this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, true);
        }
        scope.addLocalVariable(this.binding);
        this.binding.declaration = this;
        this.binding.useFlag = used ? 1 : 0;
    }

    public int getKind() {
        return 5;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        Argument.printIndent(indent, output);
        Argument.printModifiers(this.modifiers, output);
        return output.append(this.name);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope scope) {
        ReferenceBinding exceptionType;
        ReferenceBinding javaLangError = scope.getJavaLangError();
        TypeBinding typeBinding = exceptionType = this.type != null ? this.type.resolveType(scope, true) : javaLangError;
        if (exceptionType == null) {
            return null;
        }
        boolean hasError = false;
        Binding existingVariable = scope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (existingVariable != null && existingVariable.isValidBinding()) {
            scope.problemReporter().localVariableHiding(this, existingVariable, false);
        }
        this.binding = new LocalVariableBinding(this, (TypeBinding)exceptionType, this.modifiers, false);
        scope.addLocalVariable(this.binding);
        if (hasError) {
            return null;
        }
        return exceptionType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.type != null) {
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope) && this.type != null) {
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 7;
    }
}

