/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.text.MessageFormat;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.search.JavaSearchDocumentDelegate;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.BasicRefactorSearchRequestor;

public class JSPTypeRenameRequestor
extends BasicRefactorSearchRequestor {
    public JSPTypeRenameRequestor(IType type, String newName) {
        super((IJavaElement)type, newName);
    }

    private IType getType() {
        return (IType)this.getElement();
    }

    protected String getRenameText(JavaSearchDocumentDelegate searchDoc, SearchMatch javaMatch) {
        String renameText = this.getNewName();
        String pkg = this.getType().getPackageFragment().getElementName();
        IJavaElement parent = this.getType().getParent();
        String parentName = parent != null ? parent.getElementName() : null;
        JSPTranslationExtension trans = searchDoc.getJspTranslation();
        String matchText = trans.getJavaText().substring(javaMatch.getOffset(), javaMatch.getOffset() + javaMatch.getLength());
        if (trans.isImport(javaMatch.getOffset()) || this.isFullyQualified(matchText)) {
            if (!pkg.equals("")) {
                renameText = String.valueOf(pkg) + "." + renameText;
            }
        } else if (parentName != null && matchText.startsWith(parentName)) {
            renameText = String.valueOf(parentName) + "." + renameText;
        }
        return renameText;
    }

    protected String getDescription() {
        String typeName = this.getElement().getElementName();
        String newName = this.getNewName();
        String description = MessageFormat.format(JSPUIMessages.BasicRefactorSearchRequestor_4, typeName, newName);
        return description;
    }
}

