/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentproperties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JSPFContentPropertiesManager {
    private static JSPFContentPropertiesManager _instance = null;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    ContentPropertiesManagerJob fJob = new ContentPropertiesManagerJob();

    public static synchronized void startup() {
        _instance = new JSPFContentPropertiesManager();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(JSPFContentPropertiesManager._instance.fResourceChangeListener, 1);
    }

    public static synchronized void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(JSPFContentPropertiesManager._instance.fResourceChangeListener);
        _instance = null;
    }

    private class ContentPropertiesManagerJob
    extends Job {
        private static final int PROPERTIES_UPDATE_DELAY = 500;
        private List asyncChanges = new ArrayList();

        public ContentPropertiesManagerJob() {
            super(JSPCoreMessages.JSPFContentPropertiesManager_Updating);
            this.setSystem(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChanges(Set newChanges) {
            if (newChanges.isEmpty()) {
                return;
            }
            List list = this.asyncChanges;
            synchronized (list) {
                this.asyncChanges.addAll(newChanges);
                this.asyncChanges.notify();
            }
            this.schedule(500L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProject getNextChange() {
            List list = this.asyncChanges;
            synchronized (list) {
                return this.asyncChanges.isEmpty() ? null : (IProject)this.asyncChanges.remove(this.asyncChanges.size() - 1);
            }
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 212->215)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.asyncChanges;
            synchronized (list) {
                return !this.asyncChanges.isEmpty();
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private void processEntryChanges(IResourceDelta projectDelta, Set projectsToSave) {
            boolean resourceChanges = false;
            boolean resourceChanges2 = false;
            IProject currentProject = (IProject)projectDelta.getResource();
            resourceChanges = this.processPreferences(currentProject, "jsp-content-type", projectDelta, projectsToSave);
            resourceChanges2 = this.processPreferences(currentProject, "jsp-language", projectDelta, projectsToSave);
            if (resourceChanges || resourceChanges2) {
                projectsToSave.add(currentProject);
            }
        }

        private boolean processPreferences(IProject currentProject, String key, IResourceDelta projectDelta, Set projectsToSave) {
            String[] affectedResources;
            boolean resourceChanges = false;
            Preferences projectPrefs = JSPFContentProperties.getPreferences(currentProject, key, false);
            if (projectPrefs == null) {
                return false;
            }
            try {
                affectedResources = projectPrefs.keys();
            }
            catch (BackingStoreException e) {
                Logger.log(202, "Problem retreiving JSP Fragment preferences", e);
                return false;
            }
            int i = 0;
            while (i < affectedResources.length) {
                IResourceDelta memberDelta = projectDelta.findMember((IPath)new Path(affectedResources[i]));
                if (memberDelta != null && memberDelta.getKind() == 2) {
                    resourceChanges = true;
                    String currentValue = projectPrefs.get(affectedResources[i], null);
                    projectPrefs.remove(affectedResources[i]);
                    if ((memberDelta.getFlags() & 0x2000) != 0) {
                        IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(memberDelta.getMovedToPath().segment(0));
                        Preferences targetPrefs = JSPFContentProperties.getPreferences(targetProject, key, true);
                        targetPrefs.put(JSPFContentProperties.getKeyFor(memberDelta.getMovedToPath()), currentValue);
                        if (targetProject != currentProject) {
                            projectsToSave.add(targetProject);
                        }
                    }
                }
                ++i;
            }
            return resourceChanges;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] projectDeltas = delta.getAffectedChildren();
            HashSet projectsToSave = new HashSet();
            int i = 0;
            while (i < projectDeltas.length) {
                if (projectDeltas[i].getKind() == 4 && (projectDeltas[i].getFlags() & 0x4000) == 0) {
                    this.processEntryChanges(projectDeltas[i], projectsToSave);
                }
                ++i;
            }
            JSPFContentPropertiesManager.this.fJob.addChanges(projectsToSave);
        }
    }
}

