/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;

public class TTypes {
    private TTypes() {
    }

    public static TType createArrayType(TType elementType, int dimensions) {
        return elementType.getEnvironment().createArrayType(elementType, dimensions);
    }

    public static Iterator getAllSubTypesIterator(TType type) {
        return new AllSubtypesIterator(type);
    }

    public static Iterator getAllSuperTypesIterator(TType type) {
        return new AllSupertypesIterator(type);
    }

    public static boolean canAssignTo(TType rhs, TType lhs) {
        if (rhs.isHierarchyType() && lhs.isHierarchyType()) {
            HierarchyType rhsGeneric = (HierarchyType)rhs.getTypeDeclaration();
            HierarchyType lhsGeneric = (HierarchyType)lhs.getTypeDeclaration();
            return lhs.isJavaLangObject() || rhsGeneric.equals(lhsGeneric) || rhsGeneric.isSubType(lhsGeneric);
        }
        if (rhs.isTypeVariable()) {
            if (rhs.canAssignTo(lhs)) {
                return true;
            }
            return lhs.isJavaLangObject();
        }
        return rhs.canAssignTo(lhs);
    }

    private static class AllSubtypesIterator
    implements Iterator {
        private final Stack fWorklist = new Stack();

        public AllSubtypesIterator(TType type) {
            this.fWorklist.push(type.getTypeDeclaration());
        }

        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        public Object next() {
            TType result = (TType)this.fWorklist.pop();
            TType[] subTypes = result.getSubTypes();
            int i = 0;
            while (i < subTypes.length) {
                this.fWorklist.push(subTypes[i].getTypeDeclaration());
                ++i;
            }
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AllSupertypesIterator
    implements Iterator {
        private final Stack fWorklist = new Stack();

        public AllSupertypesIterator(TType type) {
            this.pushSupertypes(type);
        }

        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        public Object next() {
            TType result = (TType)this.fWorklist.pop();
            this.pushSupertypes(result);
            return result;
        }

        private void pushSupertypes(TType type) {
            if (type.isJavaLangObject()) {
                return;
            }
            if (type.isTypeVariable() || type.isCaptureType()) {
                TType[] bounds = ((AbstractTypeVariable)type).getBounds();
                int i = 0;
                while (i < bounds.length) {
                    this.fWorklist.push(bounds[i].getTypeDeclaration());
                    ++i;
                }
            } else {
                TType superclass = type.getSuperclass();
                if (superclass == null) {
                    if (type.isInterface()) {
                        this.fWorklist.push(type.getEnvironment().getJavaLangObject());
                    }
                } else {
                    this.fWorklist.push(superclass.getTypeDeclaration());
                }
                TType[] interfaces = type.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    this.fWorklist.push(interfaces[i].getTypeDeclaration());
                    ++i;
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

